#include "../librpc/gen_ndr/ndr_svcctl.h"
#ifndef __CLI_SVCCTL__
#define __CLI_SVCCTL__
struct tevent_req *rpccli_svcctl_CloseServiceHandle_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct policy_handle *_handle /* [in,out] [ref] */);
NTSTATUS rpccli_svcctl_CloseServiceHandle_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result);
NTSTATUS rpccli_svcctl_CloseServiceHandle(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in,out] [ref] */,
					  WERROR *werror);
struct tevent_req *rpccli_svcctl_ControlService_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_handle /* [in] [ref] */,
						     enum SERVICE_CONTROL _control /* [in]  */,
						     struct SERVICE_STATUS *_service_status /* [out] [ref] */);
NTSTATUS rpccli_svcctl_ControlService_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_svcctl_ControlService(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      enum SERVICE_CONTROL control /* [in]  */,
				      struct SERVICE_STATUS *service_status /* [out] [ref] */,
				      WERROR *werror);
struct tevent_req *rpccli_svcctl_DeleteService_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct policy_handle *_handle /* [in] [ref] */);
NTSTATUS rpccli_svcctl_DeleteService_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result);
NTSTATUS rpccli_svcctl_DeleteService(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     WERROR *werror);
struct tevent_req *rpccli_svcctl_LockServiceDatabase_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  struct policy_handle *_lock /* [out] [ref] */);
NTSTATUS rpccli_svcctl_LockServiceDatabase_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_svcctl_LockServiceDatabase(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   struct policy_handle *lock /* [out] [ref] */,
					   WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceObjectSecurity_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct rpc_pipe_client *cli,
								 struct policy_handle *_handle /* [in] [ref] */,
								 uint32_t _security_flags /* [in]  */,
								 uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
								 uint32_t _offered /* [in] [range(0,0x40000)] */,
								 uint32_t *_needed /* [out] [ref,range(0,0x40000)] */);
NTSTATUS rpccli_svcctl_QueryServiceObjectSecurity_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceObjectSecurity(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle *handle /* [in] [ref] */,
						  uint32_t security_flags /* [in]  */,
						  uint8_t *buffer /* [out] [ref,size_is(offered)] */,
						  uint32_t offered /* [in] [range(0,0x40000)] */,
						  uint32_t *needed /* [out] [ref,range(0,0x40000)] */,
						  WERROR *werror);
struct tevent_req *rpccli_svcctl_SetServiceObjectSecurity_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct rpc_pipe_client *cli,
							       struct policy_handle *_handle /* [in] [ref] */,
							       uint32_t _security_flags /* [in]  */,
							       uint8_t *_buffer /* [in] [ref,size_is(offered)] */,
							       uint32_t _offered /* [in]  */);
NTSTATUS rpccli_svcctl_SetServiceObjectSecurity_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result);
NTSTATUS rpccli_svcctl_SetServiceObjectSecurity(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *handle /* [in] [ref] */,
						uint32_t security_flags /* [in]  */,
						uint8_t *buffer /* [in] [ref,size_is(offered)] */,
						uint32_t offered /* [in]  */,
						WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceStatus_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct policy_handle *_handle /* [in] [ref] */,
							 struct SERVICE_STATUS *_service_status /* [out] [ref] */);
NTSTATUS rpccli_svcctl_QueryServiceStatus_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceStatus(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in] [ref] */,
					  struct SERVICE_STATUS *service_status /* [out] [ref] */,
					  WERROR *werror);
struct tevent_req *rpccli_svcctl_SetServiceStatus_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli);
NTSTATUS rpccli_svcctl_SetServiceStatus_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result);
NTSTATUS rpccli_svcctl_SetServiceStatus(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror);
struct tevent_req *rpccli_svcctl_UnlockServiceDatabase_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    struct policy_handle *_lock /* [in,out] [ref] */);
NTSTATUS rpccli_svcctl_UnlockServiceDatabase_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result);
NTSTATUS rpccli_svcctl_UnlockServiceDatabase(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *lock /* [in,out] [ref] */,
					     WERROR *werror);
struct tevent_req *rpccli_svcctl_NotifyBootConfigStatus_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli);
NTSTATUS rpccli_svcctl_NotifyBootConfigStatus_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_svcctl_NotifyBootConfigStatus(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror);
struct tevent_req *rpccli_svcctl_SCSetServiceBitsW_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t _bits /* [in]  */,
							uint32_t _bitson /* [in]  */,
							uint32_t _immediate /* [in]  */);
NTSTATUS rpccli_svcctl_SCSetServiceBitsW_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result);
NTSTATUS rpccli_svcctl_SCSetServiceBitsW(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 uint32_t bits /* [in]  */,
					 uint32_t bitson /* [in]  */,
					 uint32_t immediate /* [in]  */,
					 WERROR *werror);
struct tevent_req *rpccli_svcctl_ChangeServiceConfigW_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   struct policy_handle *_handle /* [in] [ref] */,
							   uint32_t _type /* [in]  */,
							   enum svcctl_StartType _start_type /* [in]  */,
							   enum svcctl_ErrorControl _error_control /* [in]  */,
							   const char *_binary_path /* [in] [unique,charset(UTF16)] */,
							   const char *_load_order_group /* [in] [unique,charset(UTF16)] */,
							   uint32_t *_tag_id /* [out] [ref] */,
							   const char *_dependencies /* [in] [unique,charset(UTF16)] */,
							   const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
							   const char *_password /* [in] [unique,charset(UTF16)] */,
							   const char *_display_name /* [in] [unique,charset(UTF16)] */);
NTSTATUS rpccli_svcctl_ChangeServiceConfigW_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result);
NTSTATUS rpccli_svcctl_ChangeServiceConfigW(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    uint32_t type /* [in]  */,
					    enum svcctl_StartType start_type /* [in]  */,
					    enum svcctl_ErrorControl error_control /* [in]  */,
					    const char *binary_path /* [in] [unique,charset(UTF16)] */,
					    const char *load_order_group /* [in] [unique,charset(UTF16)] */,
					    uint32_t *tag_id /* [out] [ref] */,
					    const char *dependencies /* [in] [unique,charset(UTF16)] */,
					    const char *service_start_name /* [in] [unique,charset(UTF16)] */,
					    const char *password /* [in] [unique,charset(UTF16)] */,
					    const char *display_name /* [in] [unique,charset(UTF16)] */,
					    WERROR *werror);
struct tevent_req *rpccli_svcctl_CreateServiceW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_scmanager_handle /* [in] [ref] */,
						     const char *_ServiceName /* [in] [charset(UTF16)] */,
						     const char *_DisplayName /* [in] [unique,charset(UTF16)] */,
						     uint32_t _desired_access /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_StartType _start_type /* [in]  */,
						     enum svcctl_ErrorControl _error_control /* [in]  */,
						     const char *_binary_path /* [in] [charset(UTF16)] */,
						     const char *_LoadOrderGroupKey /* [in] [unique,charset(UTF16)] */,
						     uint32_t *_TagId /* [in,out] [unique] */,
						     uint8_t *_dependencies /* [in] [unique,size_is(dependencies_size)] */,
						     uint32_t _dependencies_size /* [in]  */,
						     const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
						     uint8_t *_password /* [in] [unique,size_is(password_size)] */,
						     uint32_t _password_size /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_svcctl_CreateServiceW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_svcctl_CreateServiceW(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *scmanager_handle /* [in] [ref] */,
				      const char *ServiceName /* [in] [charset(UTF16)] */,
				      const char *DisplayName /* [in] [unique,charset(UTF16)] */,
				      uint32_t desired_access /* [in]  */,
				      uint32_t type /* [in]  */,
				      enum svcctl_StartType start_type /* [in]  */,
				      enum svcctl_ErrorControl error_control /* [in]  */,
				      const char *binary_path /* [in] [charset(UTF16)] */,
				      const char *LoadOrderGroupKey /* [in] [unique,charset(UTF16)] */,
				      uint32_t *TagId /* [in,out] [unique] */,
				      uint8_t *dependencies /* [in] [unique,size_is(dependencies_size)] */,
				      uint32_t dependencies_size /* [in]  */,
				      const char *service_start_name /* [in] [unique,charset(UTF16)] */,
				      uint8_t *password /* [in] [unique,size_is(password_size)] */,
				      uint32_t password_size /* [in]  */,
				      struct policy_handle *handle /* [out] [ref] */,
				      WERROR *werror);
struct tevent_req *rpccli_svcctl_EnumDependentServicesW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     struct policy_handle *_service /* [in] [ref] */,
							     enum svcctl_ServiceState _state /* [in]  */,
							     uint8_t *_service_status /* [out] [ref,size_is(offered)] */,
							     uint32_t _offered /* [in] [range(0,0x40000)] */,
							     uint32_t *_needed /* [out] [ref,range(0,0x40000)] */,
							     uint32_t *_services_returned /* [out] [ref,range(0,0x40000)] */);
NTSTATUS rpccli_svcctl_EnumDependentServicesW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_svcctl_EnumDependentServicesW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *service /* [in] [ref] */,
					      enum svcctl_ServiceState state /* [in]  */,
					      uint8_t *service_status /* [out] [ref,size_is(offered)] */,
					      uint32_t offered /* [in] [range(0,0x40000)] */,
					      uint32_t *needed /* [out] [ref,range(0,0x40000)] */,
					      uint32_t *services_returned /* [out] [ref,range(0,0x40000)] */,
					      WERROR *werror);
struct tevent_req *rpccli_svcctl_EnumServicesStatusW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _type /* [in]  */,
							  enum svcctl_ServiceState _state /* [in]  */,
							  uint8_t *_service /* [out] [ref,size_is(offered)] */,
							  uint32_t _offered /* [in] [range(0,0x40000)] */,
							  uint32_t *_needed /* [out] [ref,range(0,0x40000)] */,
							  uint32_t *_services_returned /* [out] [ref,range(0,0x40000)] */,
							  uint32_t *_resume_handle /* [in,out] [unique] */);
NTSTATUS rpccli_svcctl_EnumServicesStatusW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_svcctl_EnumServicesStatusW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t type /* [in]  */,
					   enum svcctl_ServiceState state /* [in]  */,
					   uint8_t *service /* [out] [ref,size_is(offered)] */,
					   uint32_t offered /* [in] [range(0,0x40000)] */,
					   uint32_t *needed /* [out] [ref,range(0,0x40000)] */,
					   uint32_t *services_returned /* [out] [ref,range(0,0x40000)] */,
					   uint32_t *resume_handle /* [in,out] [unique] */,
					   WERROR *werror);
struct tevent_req *rpccli_svcctl_OpenSCManagerW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     const char *_MachineName /* [in] [unique,charset(UTF16)] */,
						     const char *_DatabaseName /* [in] [unique,charset(UTF16)] */,
						     uint32_t _access_mask /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_svcctl_OpenSCManagerW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_svcctl_OpenSCManagerW(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *MachineName /* [in] [unique,charset(UTF16)] */,
				      const char *DatabaseName /* [in] [unique,charset(UTF16)] */,
				      uint32_t access_mask /* [in]  */,
				      struct policy_handle *handle /* [out] [ref] */,
				      WERROR *werror);
struct tevent_req *rpccli_svcctl_OpenServiceW_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct policy_handle *_scmanager_handle /* [in] [ref] */,
						   const char *_ServiceName /* [in] [charset(UTF16)] */,
						   uint32_t _access_mask /* [in]  */,
						   struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_svcctl_OpenServiceW_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result);
NTSTATUS rpccli_svcctl_OpenServiceW(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *scmanager_handle /* [in] [ref] */,
				    const char *ServiceName /* [in] [charset(UTF16)] */,
				    uint32_t access_mask /* [in]  */,
				    struct policy_handle *handle /* [out] [ref] */,
				    WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceConfigW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  struct QUERY_SERVICE_CONFIG *_query /* [out] [ref] */,
							  uint32_t _offered /* [in] [range(0,8192)] */,
							  uint32_t *_needed /* [out] [ref,range(0,8192)] */);
NTSTATUS rpccli_svcctl_QueryServiceConfigW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceConfigW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   struct QUERY_SERVICE_CONFIG *query /* [out] [ref] */,
					   uint32_t offered /* [in] [range(0,8192)] */,
					   uint32_t *needed /* [out] [ref,range(0,8192)] */,
					   WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceLockStatusW_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli,
							      struct policy_handle *_handle /* [in] [ref] */,
							      uint32_t _offered /* [in]  */,
							      struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
							      uint32_t *_needed /* [out] [ref] */);
NTSTATUS rpccli_svcctl_QueryServiceLockStatusW_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceLockStatusW(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       uint32_t offered /* [in]  */,
					       struct SERVICE_LOCK_STATUS *lock_status /* [out] [ref] */,
					       uint32_t *needed /* [out] [ref] */,
					       WERROR *werror);
struct tevent_req *rpccli_svcctl_StartServiceW_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct policy_handle *_handle /* [in] [ref] */,
						    uint32_t _NumArgs /* [in] [range(0,SC_MAX_ARGUMENTS)] */,
						    struct svcctl_ArgumentString *_Arguments /* [in] [unique,size_is(NumArgs)] */);
NTSTATUS rpccli_svcctl_StartServiceW_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result);
NTSTATUS rpccli_svcctl_StartServiceW(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     uint32_t NumArgs /* [in] [range(0,SC_MAX_ARGUMENTS)] */,
				     struct svcctl_ArgumentString *Arguments /* [in] [unique,size_is(NumArgs)] */,
				     WERROR *werror);
struct tevent_req *rpccli_svcctl_GetServiceDisplayNameW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     struct policy_handle *_handle /* [in] [ref] */,
							     const char *_service_name /* [in] [unique,charset(UTF16)] */,
							     const char **_display_name /* [out] [ref,charset(UTF16)] */,
							     uint32_t *_display_name_length /* [in,out] [unique] */);
NTSTATUS rpccli_svcctl_GetServiceDisplayNameW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_svcctl_GetServiceDisplayNameW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *handle /* [in] [ref] */,
					      const char *service_name /* [in] [unique,charset(UTF16)] */,
					      const char **display_name /* [out] [ref,charset(UTF16)] */,
					      uint32_t *display_name_length /* [in,out] [unique] */,
					      WERROR *werror);
struct tevent_req *rpccli_svcctl_GetServiceKeyNameW_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_service_name /* [in] [unique,charset(UTF16)] */,
							 const char **_key_name /* [out] [ref,charset(UTF16)] */,
							 uint32_t *_display_name_length /* [in,out] [unique] */);
NTSTATUS rpccli_svcctl_GetServiceKeyNameW_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result);
NTSTATUS rpccli_svcctl_GetServiceKeyNameW(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in] [ref] */,
					  const char *service_name /* [in] [unique,charset(UTF16)] */,
					  const char **key_name /* [out] [ref,charset(UTF16)] */,
					  uint32_t *display_name_length /* [in,out] [unique] */,
					  WERROR *werror);
struct tevent_req *rpccli_svcctl_SCSetServiceBitsA_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t _bits /* [in]  */,
							uint32_t _bitson /* [in]  */,
							uint32_t _immediate /* [in]  */);
NTSTATUS rpccli_svcctl_SCSetServiceBitsA_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result);
NTSTATUS rpccli_svcctl_SCSetServiceBitsA(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 uint32_t bits /* [in]  */,
					 uint32_t bitson /* [in]  */,
					 uint32_t immediate /* [in]  */,
					 WERROR *werror);
struct tevent_req *rpccli_svcctl_ChangeServiceConfigA_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   struct policy_handle *_handle /* [in] [ref] */,
							   uint32_t _type /* [in]  */,
							   enum svcctl_StartType _start_type /* [in]  */,
							   enum svcctl_ErrorControl _error_control /* [in]  */,
							   const char *_binary_path /* [in] [unique,charset(UTF16)] */,
							   const char *_load_order_group /* [in] [unique,charset(UTF16)] */,
							   uint32_t *_tag_id /* [out] [ref] */,
							   const char *_dependencies /* [in] [unique,charset(UTF16)] */,
							   const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
							   const char *_password /* [in] [unique,charset(UTF16)] */,
							   const char *_display_name /* [in] [unique,charset(UTF16)] */);
NTSTATUS rpccli_svcctl_ChangeServiceConfigA_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result);
NTSTATUS rpccli_svcctl_ChangeServiceConfigA(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    uint32_t type /* [in]  */,
					    enum svcctl_StartType start_type /* [in]  */,
					    enum svcctl_ErrorControl error_control /* [in]  */,
					    const char *binary_path /* [in] [unique,charset(UTF16)] */,
					    const char *load_order_group /* [in] [unique,charset(UTF16)] */,
					    uint32_t *tag_id /* [out] [ref] */,
					    const char *dependencies /* [in] [unique,charset(UTF16)] */,
					    const char *service_start_name /* [in] [unique,charset(UTF16)] */,
					    const char *password /* [in] [unique,charset(UTF16)] */,
					    const char *display_name /* [in] [unique,charset(UTF16)] */,
					    WERROR *werror);
struct tevent_req *rpccli_svcctl_CreateServiceA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_handle /* [in] [ref] */,
						     const char *_ServiceName /* [in] [unique,charset(UTF16)] */,
						     const char *_DisplayName /* [in] [unique,charset(UTF16)] */,
						     uint32_t _desired_access /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_StartType _start_type /* [in]  */,
						     enum svcctl_ErrorControl _error_control /* [in]  */,
						     const char *_binary_path /* [in] [unique,charset(UTF16)] */,
						     const char *_LoadOrderGroupKey /* [in] [unique,charset(UTF16)] */,
						     uint32_t *_TagId /* [out] [unique] */,
						     const char *_dependencies /* [in] [unique,charset(UTF16)] */,
						     const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
						     const char *_password /* [in] [unique,charset(UTF16)] */);
NTSTATUS rpccli_svcctl_CreateServiceA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_svcctl_CreateServiceA(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      const char *ServiceName /* [in] [unique,charset(UTF16)] */,
				      const char *DisplayName /* [in] [unique,charset(UTF16)] */,
				      uint32_t desired_access /* [in]  */,
				      uint32_t type /* [in]  */,
				      enum svcctl_StartType start_type /* [in]  */,
				      enum svcctl_ErrorControl error_control /* [in]  */,
				      const char *binary_path /* [in] [unique,charset(UTF16)] */,
				      const char *LoadOrderGroupKey /* [in] [unique,charset(UTF16)] */,
				      uint32_t *TagId /* [out] [unique] */,
				      const char *dependencies /* [in] [unique,charset(UTF16)] */,
				      const char *service_start_name /* [in] [unique,charset(UTF16)] */,
				      const char *password /* [in] [unique,charset(UTF16)] */,
				      WERROR *werror);
struct tevent_req *rpccli_svcctl_EnumDependentServicesA_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     struct policy_handle *_service /* [in] [ref] */,
							     enum svcctl_ServiceState _state /* [in]  */,
							     struct ENUM_SERVICE_STATUSA *_service_status /* [out] [unique] */,
							     uint32_t _offered /* [in]  */,
							     uint32_t *_needed /* [out] [ref] */,
							     uint32_t *_services_returned /* [out] [ref] */);
NTSTATUS rpccli_svcctl_EnumDependentServicesA_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_svcctl_EnumDependentServicesA(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *service /* [in] [ref] */,
					      enum svcctl_ServiceState state /* [in]  */,
					      struct ENUM_SERVICE_STATUSA *service_status /* [out] [unique] */,
					      uint32_t offered /* [in]  */,
					      uint32_t *needed /* [out] [ref] */,
					      uint32_t *services_returned /* [out] [ref] */,
					      WERROR *werror);
struct tevent_req *rpccli_svcctl_EnumServicesStatusA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _type /* [in]  */,
							  enum svcctl_ServiceState _state /* [in]  */,
							  uint32_t _offered /* [in]  */,
							  uint8_t *_service /* [out] [size_is(offered)] */,
							  uint32_t *_needed /* [out] [ref] */,
							  uint32_t *_services_returned /* [out] [ref] */,
							  uint32_t *_resume_handle /* [in,out] [unique] */);
NTSTATUS rpccli_svcctl_EnumServicesStatusA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_svcctl_EnumServicesStatusA(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t type /* [in]  */,
					   enum svcctl_ServiceState state /* [in]  */,
					   uint32_t offered /* [in]  */,
					   uint8_t *service /* [out] [size_is(offered)] */,
					   uint32_t *needed /* [out] [ref] */,
					   uint32_t *services_returned /* [out] [ref] */,
					   uint32_t *resume_handle /* [in,out] [unique] */,
					   WERROR *werror);
struct tevent_req *rpccli_svcctl_OpenSCManagerA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     const char *_MachineName /* [in] [unique,charset(UTF16)] */,
						     const char *_DatabaseName /* [in] [unique,charset(UTF16)] */,
						     uint32_t _access_mask /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */);
NTSTATUS rpccli_svcctl_OpenSCManagerA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_svcctl_OpenSCManagerA(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *MachineName /* [in] [unique,charset(UTF16)] */,
				      const char *DatabaseName /* [in] [unique,charset(UTF16)] */,
				      uint32_t access_mask /* [in]  */,
				      struct policy_handle *handle /* [out] [ref] */,
				      WERROR *werror);
struct tevent_req *rpccli_svcctl_OpenServiceA_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct policy_handle *_scmanager_handle /* [in] [ref] */,
						   const char *_ServiceName /* [in] [unique,charset(UTF16)] */,
						   uint32_t _access_mask /* [in]  */);
NTSTATUS rpccli_svcctl_OpenServiceA_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result);
NTSTATUS rpccli_svcctl_OpenServiceA(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *scmanager_handle /* [in] [ref] */,
				    const char *ServiceName /* [in] [unique,charset(UTF16)] */,
				    uint32_t access_mask /* [in]  */,
				    WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceConfigA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint8_t *_query /* [out]  */,
							  uint32_t _offered /* [in]  */,
							  uint32_t *_needed /* [out] [ref] */);
NTSTATUS rpccli_svcctl_QueryServiceConfigA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceConfigA(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint8_t *query /* [out]  */,
					   uint32_t offered /* [in]  */,
					   uint32_t *needed /* [out] [ref] */,
					   WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceLockStatusA_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli,
							      struct policy_handle *_handle /* [in] [ref] */,
							      uint32_t _offered /* [in]  */,
							      struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
							      uint32_t *_needed /* [out] [ref] */);
NTSTATUS rpccli_svcctl_QueryServiceLockStatusA_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceLockStatusA(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       uint32_t offered /* [in]  */,
					       struct SERVICE_LOCK_STATUS *lock_status /* [out] [ref] */,
					       uint32_t *needed /* [out] [ref] */,
					       WERROR *werror);
struct tevent_req *rpccli_svcctl_StartServiceA_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct policy_handle *_handle /* [in] [ref] */,
						    uint32_t _NumArgs /* [in]  */,
						    const char *_Arguments /* [in] [unique,charset(UTF16)] */);
NTSTATUS rpccli_svcctl_StartServiceA_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result);
NTSTATUS rpccli_svcctl_StartServiceA(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     uint32_t NumArgs /* [in]  */,
				     const char *Arguments /* [in] [unique,charset(UTF16)] */,
				     WERROR *werror);
struct tevent_req *rpccli_svcctl_GetServiceDisplayNameA_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     struct policy_handle *_handle /* [in] [ref] */,
							     const char *_service_name /* [in] [unique,charset(UTF16)] */,
							     const char **_display_name /* [out] [ref,charset(UTF16)] */,
							     uint32_t *_display_name_length /* [in,out] [unique] */);
NTSTATUS rpccli_svcctl_GetServiceDisplayNameA_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_svcctl_GetServiceDisplayNameA(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *handle /* [in] [ref] */,
					      const char *service_name /* [in] [unique,charset(UTF16)] */,
					      const char **display_name /* [out] [ref,charset(UTF16)] */,
					      uint32_t *display_name_length /* [in,out] [unique] */,
					      WERROR *werror);
struct tevent_req *rpccli_svcctl_GetServiceKeyNameA_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_service_name /* [in] [unique,charset(UTF16)] */,
							 const char **_key_name /* [out] [ref,charset(UTF16)] */,
							 uint32_t *_display_name_length /* [in,out] [unique] */);
NTSTATUS rpccli_svcctl_GetServiceKeyNameA_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result);
NTSTATUS rpccli_svcctl_GetServiceKeyNameA(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in] [ref] */,
					  const char *service_name /* [in] [unique,charset(UTF16)] */,
					  const char **key_name /* [out] [ref,charset(UTF16)] */,
					  uint32_t *display_name_length /* [in,out] [unique] */,
					  WERROR *werror);
struct tevent_req *rpccli_svcctl_GetCurrentGroupeStateW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli);
NTSTATUS rpccli_svcctl_GetCurrentGroupeStateW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_svcctl_GetCurrentGroupeStateW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror);
struct tevent_req *rpccli_svcctl_EnumServiceGroupW_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli);
NTSTATUS rpccli_svcctl_EnumServiceGroupW_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result);
NTSTATUS rpccli_svcctl_EnumServiceGroupW(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror);
struct tevent_req *rpccli_svcctl_ChangeServiceConfig2A_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    struct policy_handle *_handle /* [in] [ref] */,
							    uint32_t _info_level /* [in]  */,
							    uint8_t *_info /* [in] [unique] */);
NTSTATUS rpccli_svcctl_ChangeServiceConfig2A_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result);
NTSTATUS rpccli_svcctl_ChangeServiceConfig2A(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *handle /* [in] [ref] */,
					     uint32_t info_level /* [in]  */,
					     uint8_t *info /* [in] [unique] */,
					     WERROR *werror);
struct tevent_req *rpccli_svcctl_ChangeServiceConfig2W_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    struct policy_handle *_handle /* [in] [ref] */,
							    uint32_t _info_level /* [in]  */,
							    uint8_t *_info /* [in] [unique] */);
NTSTATUS rpccli_svcctl_ChangeServiceConfig2W_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result);
NTSTATUS rpccli_svcctl_ChangeServiceConfig2W(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *handle /* [in] [ref] */,
					     uint32_t info_level /* [in]  */,
					     uint8_t *info /* [in] [unique] */,
					     WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceConfig2A_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_ConfigLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out]  */,
							   uint32_t _offered /* [in]  */,
							   uint32_t *_needed /* [out] [ref] */);
NTSTATUS rpccli_svcctl_QueryServiceConfig2A_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceConfig2A(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    enum svcctl_ConfigLevel info_level /* [in]  */,
					    uint8_t *buffer /* [out]  */,
					    uint32_t offered /* [in]  */,
					    uint32_t *needed /* [out] [ref] */,
					    WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceConfig2W_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_ConfigLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
							   uint32_t _offered /* [in] [range(0,8192)] */,
							   uint32_t *_needed /* [out] [ref,range(0,8192)] */);
NTSTATUS rpccli_svcctl_QueryServiceConfig2W_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceConfig2W(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    enum svcctl_ConfigLevel info_level /* [in]  */,
					    uint8_t *buffer /* [out] [ref,size_is(offered)] */,
					    uint32_t offered /* [in] [range(0,8192)] */,
					    uint32_t *needed /* [out] [ref,range(0,8192)] */,
					    WERROR *werror);
struct tevent_req *rpccli_svcctl_QueryServiceStatusEx_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_StatusLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
							   uint32_t _offered /* [in] [range(0,8192)] */,
							   uint32_t *_needed /* [out] [ref,range(0,8192)] */);
NTSTATUS rpccli_svcctl_QueryServiceStatusEx_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result);
NTSTATUS rpccli_svcctl_QueryServiceStatusEx(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    enum svcctl_StatusLevel info_level /* [in]  */,
					    uint8_t *buffer /* [out] [ref,size_is(offered)] */,
					    uint32_t offered /* [in] [range(0,8192)] */,
					    uint32_t *needed /* [out] [ref,range(0,8192)] */,
					    WERROR *werror);
struct tevent_req *rpccli_EnumServicesStatusExA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_scmanager /* [in] [ref] */,
						     uint32_t _info_level /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_ServiceState _state /* [in]  */,
						     uint8_t *_services /* [out]  */,
						     uint32_t _offered /* [in]  */,
						     uint32_t *_needed /* [out] [ref] */,
						     uint32_t *_service_returned /* [out] [ref] */,
						     uint32_t *_resume_handle /* [in,out] [unique] */,
						     const char **_group_name /* [out] [ref,charset(UTF16)] */);
NTSTATUS rpccli_EnumServicesStatusExA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_EnumServicesStatusExA(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *scmanager /* [in] [ref] */,
				      uint32_t info_level /* [in]  */,
				      uint32_t type /* [in]  */,
				      enum svcctl_ServiceState state /* [in]  */,
				      uint8_t *services /* [out]  */,
				      uint32_t offered /* [in]  */,
				      uint32_t *needed /* [out] [ref] */,
				      uint32_t *service_returned /* [out] [ref] */,
				      uint32_t *resume_handle /* [in,out] [unique] */,
				      const char **group_name /* [out] [ref,charset(UTF16)] */,
				      WERROR *werror);
struct tevent_req *rpccli_EnumServicesStatusExW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_scmanager /* [in] [ref] */,
						     uint32_t _info_level /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_ServiceState _state /* [in]  */,
						     uint8_t *_services /* [out] [ref,size_is(offered)] */,
						     uint32_t _offered /* [in] [range(0,0x40000)] */,
						     uint32_t *_needed /* [out] [ref,range(0,0x40000)] */,
						     uint32_t *_service_returned /* [out] [ref,range(0,0x40000)] */,
						     uint32_t *_resume_handle /* [in,out] [unique,range(0,0x40000)] */,
						     const char *_group_name /* [in] [unique,charset(UTF16)] */);
NTSTATUS rpccli_EnumServicesStatusExW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result);
NTSTATUS rpccli_EnumServicesStatusExW(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *scmanager /* [in] [ref] */,
				      uint32_t info_level /* [in]  */,
				      uint32_t type /* [in]  */,
				      enum svcctl_ServiceState state /* [in]  */,
				      uint8_t *services /* [out] [ref,size_is(offered)] */,
				      uint32_t offered /* [in] [range(0,0x40000)] */,
				      uint32_t *needed /* [out] [ref,range(0,0x40000)] */,
				      uint32_t *service_returned /* [out] [ref,range(0,0x40000)] */,
				      uint32_t *resume_handle /* [in,out] [unique,range(0,0x40000)] */,
				      const char *group_name /* [in] [unique,charset(UTF16)] */,
				      WERROR *werror);
struct tevent_req *rpccli_svcctl_SCSendTSMessage_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli);
NTSTATUS rpccli_svcctl_SCSendTSMessage_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result);
NTSTATUS rpccli_svcctl_SCSendTSMessage(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       WERROR *werror);
#endif /* __CLI_SVCCTL__ */
