#include "../librpc/gen_ndr/ndr_srvsvc.h"
#ifndef __CLI_SRVSVC__
#define __CLI_SRVSVC__
NTSTATUS rpccli_srvsvc_NetCharDevEnum(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc /* [in] [unique,charset(UTF16)] */,
				      struct srvsvc_NetCharDevInfoCtr *info_ctr /* [in,out] [ref] */,
				      uint32_t max_buffer /* [in]  */,
				      uint32_t *totalentries /* [out] [ref] */,
				      uint32_t *resume_handle /* [in,out] [unique] */,
				      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevGetInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *device_name /* [in] [charset(UTF16)] */,
					 uint32_t level /* [in]  */,
					 union srvsvc_NetCharDevInfo *info /* [out] [ref,switch_is(level)] */,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevControl(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *device_name /* [in] [charset(UTF16)] */,
					 uint32_t opcode /* [in]  */,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQEnum(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *user /* [in] [unique,charset(UTF16)] */,
				       struct srvsvc_NetCharDevQInfoCtr *info_ctr /* [in,out] [ref] */,
				       uint32_t max_buffer /* [in]  */,
				       uint32_t *totalentries /* [out] [ref] */,
				       uint32_t *resume_handle /* [in,out] [unique] */,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQGetInfo(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *queue_name /* [in] [charset(UTF16)] */,
					  const char *user /* [in] [charset(UTF16)] */,
					  uint32_t level /* [in]  */,
					  union srvsvc_NetCharDevQInfo *info /* [out] [ref,switch_is(level)] */,
					  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQSetInfo(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *queue_name /* [in] [charset(UTF16)] */,
					  uint32_t level /* [in]  */,
					  union srvsvc_NetCharDevQInfo info /* [in] [switch_is(level)] */,
					  uint32_t *parm_error /* [in,out] [unique] */,
					  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQPurge(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc /* [in] [unique,charset(UTF16)] */,
					const char *queue_name /* [in] [charset(UTF16)] */,
					WERROR *werror);
NTSTATUS rpccli_srvsvc_NetCharDevQPurgeSelf(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_unc /* [in] [unique,charset(UTF16)] */,
					    const char *queue_name /* [in] [charset(UTF16)] */,
					    const char *computer_name /* [in] [charset(UTF16)] */,
					    WERROR *werror);
NTSTATUS rpccli_srvsvc_NetConnEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *path /* [in] [unique,charset(UTF16)] */,
				   struct srvsvc_NetConnInfoCtr *info_ctr /* [in,out] [ref] */,
				   uint32_t max_buffer /* [in]  */,
				   uint32_t *totalentries /* [out] [ref] */,
				   uint32_t *resume_handle /* [in,out] [unique] */,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetFileEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *path /* [in] [unique,charset(UTF16)] */,
				   const char *user /* [in] [unique,charset(UTF16)] */,
				   struct srvsvc_NetFileInfoCtr *info_ctr /* [in,out] [ref] */,
				   uint32_t max_buffer /* [in]  */,
				   uint32_t *totalentries /* [out] [ref] */,
				   uint32_t *resume_handle /* [in,out] [unique] */,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetFileGetInfo(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc /* [in] [unique,charset(UTF16)] */,
				      uint32_t fid /* [in]  */,
				      uint32_t level /* [in]  */,
				      union srvsvc_NetFileInfo *info /* [out] [ref,switch_is(level)] */,
				      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetFileClose(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    uint32_t fid /* [in]  */,
				    WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSessEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *client /* [in] [unique,charset(UTF16)] */,
				   const char *user /* [in] [unique,charset(UTF16)] */,
				   struct srvsvc_NetSessInfoCtr *info_ctr /* [in,out] [ref] */,
				   uint32_t max_buffer /* [in]  */,
				   uint32_t *totalentries /* [out] [ref] */,
				   uint32_t *resume_handle /* [in,out] [unique] */,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSessDel(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *server_unc /* [in] [unique,charset(UTF16)] */,
				  const char *client /* [in] [unique,charset(UTF16)] */,
				  const char *user /* [in] [unique,charset(UTF16)] */,
				  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareAdd(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   uint32_t level /* [in]  */,
				   union srvsvc_NetShareInfo *info /* [in] [ref,switch_is(level)] */,
				   uint32_t *parm_error /* [in,out] [unique] */,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareEnumAll(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       struct srvsvc_NetShareInfoCtr *info_ctr /* [in,out] [ref] */,
				       uint32_t max_buffer /* [in]  */,
				       uint32_t *totalentries /* [out] [ref] */,
				       uint32_t *resume_handle /* [in,out] [unique] */,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareGetInfo(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *share_name /* [in] [charset(UTF16)] */,
				       uint32_t level /* [in]  */,
				       union srvsvc_NetShareInfo *info /* [out] [ref,switch_is(level)] */,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareSetInfo(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *share_name /* [in] [charset(UTF16)] */,
				       uint32_t level /* [in]  */,
				       union srvsvc_NetShareInfo *info /* [in] [ref,switch_is(level)] */,
				       uint32_t *parm_error /* [in,out] [unique] */,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareDel(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *share_name /* [in] [charset(UTF16)] */,
				   uint32_t reserved /* [in]  */,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareDelSticky(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *share_name /* [in] [charset(UTF16)] */,
					 uint32_t reserved /* [in]  */,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareCheck(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     const char *device_name /* [in] [charset(UTF16)] */,
				     enum srvsvc_ShareType *type /* [out] [ref] */,
				     WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSrvGetInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     uint32_t level /* [in]  */,
				     union srvsvc_NetSrvInfo *info /* [out] [ref,switch_is(level)] */,
				     WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSrvSetInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     uint32_t level /* [in]  */,
				     union srvsvc_NetSrvInfo *info /* [in] [ref,switch_is(level)] */,
				     uint32_t *parm_error /* [in,out] [unique] */,
				     WERROR *werror);
NTSTATUS rpccli_srvsvc_NetDiskEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   uint32_t level /* [in]  */,
				   struct srvsvc_NetDiskInfo *info /* [in,out] [ref] */,
				   uint32_t maxlen /* [in]  */,
				   uint32_t *totalentries /* [out] [ref] */,
				   uint32_t *resume_handle /* [in,out] [unique] */,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetServerStatisticsGet(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_unc /* [in] [unique,charset(UTF16)] */,
					      const char *service /* [in] [unique,charset(UTF16)] */,
					      uint32_t level /* [in]  */,
					      uint32_t options /* [in]  */,
					      struct srvsvc_Statistics **stats /* [out] [ref] */,
					      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetTransportAdd(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       uint32_t level /* [in]  */,
				       union srvsvc_NetTransportInfo info /* [in] [switch_is(level)] */,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetTransportEnum(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc /* [in] [unique,charset(UTF16)] */,
					struct srvsvc_NetTransportInfoCtr *transports /* [in,out] [ref] */,
					uint32_t max_buffer /* [in]  */,
					uint32_t *totalentries /* [out] [ref] */,
					uint32_t *resume_handle /* [in,out] [unique] */,
					WERROR *werror);
NTSTATUS rpccli_srvsvc_NetTransportDel(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       uint32_t level /* [in]  */,
				       struct srvsvc_NetTransportInfo0 *info0 /* [in] [ref] */,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetRemoteTOD(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    struct srvsvc_NetRemoteTODInfo **info /* [out] [ref] */,
				    WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSetServiceBits(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *transport /* [in] [unique,charset(UTF16)] */,
					 uint32_t servicebits /* [in]  */,
					 uint32_t updateimmediately /* [in]  */,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetPathType(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *path /* [in] [charset(UTF16)] */,
				   uint32_t pathflags /* [in]  */,
				   uint32_t *pathtype /* [out] [ref] */,
				   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetPathCanonicalize(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_unc /* [in] [unique,charset(UTF16)] */,
					   const char *path /* [in] [charset(UTF16)] */,
					   uint8_t *can_path /* [out] [size_is(maxbuf)] */,
					   uint32_t maxbuf /* [in]  */,
					   const char *prefix /* [in] [charset(UTF16)] */,
					   uint32_t *pathtype /* [in,out] [ref] */,
					   uint32_t pathflags /* [in]  */,
					   WERROR *werror);
NTSTATUS rpccli_srvsvc_NetPathCompare(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_unc /* [in] [unique,charset(UTF16)] */,
				      const char *path1 /* [in] [charset(UTF16)] */,
				      const char *path2 /* [in] [charset(UTF16)] */,
				      uint32_t pathtype /* [in]  */,
				      uint32_t pathflags /* [in]  */,
				      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetNameValidate(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *name /* [in] [charset(UTF16)] */,
				       uint32_t name_type /* [in]  */,
				       uint32_t flags /* [in]  */,
				       WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRPRNAMECANONICALIZE(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror);
NTSTATUS rpccli_srvsvc_NetPRNameCompare(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc /* [in] [unique,charset(UTF16)] */,
					const char *name1 /* [in] [charset(UTF16)] */,
					const char *name2 /* [in] [charset(UTF16)] */,
					uint32_t name_type /* [in]  */,
					uint32_t flags /* [in]  */,
					WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareEnum(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    struct srvsvc_NetShareInfoCtr *info_ctr /* [in,out] [ref] */,
				    uint32_t max_buffer /* [in]  */,
				    uint32_t *totalentries /* [out] [ref] */,
				    uint32_t *resume_handle /* [in,out] [unique] */,
				    WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareDelStart(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_unc /* [in] [unique,charset(UTF16)] */,
					const char *share /* [in] [charset(UTF16)] */,
					uint32_t reserved /* [in]  */,
					struct policy_handle *hnd /* [out] [unique] */,
					WERROR *werror);
NTSTATUS rpccli_srvsvc_NetShareDelCommit(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *hnd /* [in,out] [unique] */,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NetGetFileSecurity(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *share /* [in] [unique,charset(UTF16)] */,
					  const char *file /* [in] [charset(UTF16)] */,
					  uint32_t securityinformation /* [in]  */,
					  struct sec_desc_buf **sd_buf /* [out] [ref] */,
					  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetSetFileSecurity(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *share /* [in] [unique,charset(UTF16)] */,
					  const char *file /* [in] [charset(UTF16)] */,
					  uint32_t securityinformation /* [in]  */,
					  struct sec_desc_buf *sd_buf /* [in] [ref] */,
					  WERROR *werror);
NTSTATUS rpccli_srvsvc_NetServerTransportAddEx(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *server_unc /* [in] [unique,charset(UTF16)] */,
					       uint32_t level /* [in]  */,
					       union srvsvc_NetTransportInfo info /* [in] [switch_is(level)] */,
					       WERROR *werror);
NTSTATUS rpccli_srvsvc_NetServerSetServiceBitsEx(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *emulated_server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *transport /* [in] [unique,charset(UTF16)] */,
						 uint32_t servicebitsofinterest /* [in]  */,
						 uint32_t servicebits /* [in]  */,
						 uint32_t updateimmediately /* [in]  */,
						 WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSGETVERSION(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSCREATELOCALPARTITION(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSDELETELOCALPARTITION(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSSETLOCALVOLUMESTATE(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSSETSERVERINFO(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSCREATEEXITPOINT(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSDELETEEXITPOINT(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSMODIFYPREFIX(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSFIXLOCALVOLUME(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRDFSMANAGERREPORTSITEINFO(struct rpc_pipe_client *cli,
						    TALLOC_CTX *mem_ctx,
						    WERROR *werror);
NTSTATUS rpccli_srvsvc_NETRSERVERTRANSPORTDELEX(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						WERROR *werror);
#endif /* __CLI_SRVSVC__ */
