#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sched.h>

void process_file(char *filename)
{
	int fd;
	struct stat buf;
	
	if (!filename)
		return;
		
	fd = open(filename,O_RDONLY);
	if (fd<0)
		return;
	
	if (fstat(fd, &buf)<0) 	 
		return;
	
#if 0
	/* don't readahead on nfs */
	if (!gnu_dev_major(buf.st_dev))
		return;
#endif
        
	readahead(fd, (loff_t)0, (size_t)buf.st_size);
/*        posix_fadvise(fd, (off_t) 0, (off_t) 0, POSIX_FADV_NORMAL|POSIX_FADV_WILLNEED);
*/
          close(fd);
	/* be nice to other processes now */
	sched_yield();
}


int main(int argc, char **argv)
{
	int i;
	for (i=1; i<argc; i++)
		process_file(argv[i]);
	return 0;
}
