/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFile.h"

#include "File.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFile);

/* Hash table */

static const HashTableValue JSFileTableValues[6] =
{
    { "name", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileName), (intptr_t)0 },
    { "type", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileType), (intptr_t)0 },
    { "fileName", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileFileName), (intptr_t)0 },
    { "fileSize", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileFileSize), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSFileTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSFileTableValues, 0 };
#else
    { 17, 15, JSFileTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSFileConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSFileConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSFileConstructorTableValues, 0 };
#else
    { 1, 0, JSFileConstructorTableValues, 0 };
#endif

class JSFileConstructor : public DOMConstructorObject {
public:
    JSFileConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSFileConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSFilePrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSFileConstructor::s_info = { "FileConstructor", 0, &JSFileConstructorTable, 0 };

bool JSFileConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileConstructor, DOMObject>(exec, &JSFileConstructorTable, this, propertyName, slot);
}

bool JSFileConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileConstructor, DOMObject>(exec, &JSFileConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSFilePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSFilePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSFilePrototypeTableValues, 0 };
#else
    { 1, 0, JSFilePrototypeTableValues, 0 };
#endif

const ClassInfo JSFilePrototype::s_info = { "FilePrototype", 0, &JSFilePrototypeTable, 0 };

JSObject* JSFilePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFile>(exec, globalObject);
}

const ClassInfo JSFile::s_info = { "File", &JSBlob::s_info, &JSFileTable, 0 };

JSFile::JSFile(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<File> impl)
    : JSBlob(structure, globalObject, impl)
{
}

JSObject* JSFile::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSFilePrototype(JSFilePrototype::createStructure(JSBlobPrototype::self(exec, globalObject)));
}

bool JSFile::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFile, Base>(exec, &JSFileTable, this, propertyName, slot);
}

bool JSFile::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFile, Base>(exec, &JSFileTable, this, propertyName, descriptor);
}

JSValue jsFileName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFile* castedThis = static_cast<JSFile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    File* imp = static_cast<File*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}

JSValue jsFileType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFile* castedThis = static_cast<JSFile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    File* imp = static_cast<File*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}

JSValue jsFileFileName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFile* castedThis = static_cast<JSFile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    File* imp = static_cast<File*>(castedThis->impl());
    JSValue result = jsString(exec, imp->fileName());
    return result;
}

JSValue jsFileFileSize(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFile* castedThis = static_cast<JSFile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    File* imp = static_cast<File*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->fileSize());
    return result;
}

JSValue jsFileConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFile* domObject = static_cast<JSFile*>(asObject(slotBase));
    return JSFile::getConstructor(exec, domObject->globalObject());
}
JSValue JSFile::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, File* object)
{
    return getDOMObjectWrapper<JSFile>(exec, globalObject, object);
}
File* toFile(JSC::JSValue value)
{
    return value.inherits(&JSFile::s_info) ? static_cast<JSFile*>(asObject(value))->impl() : 0;
}

}
