/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLEmbedElement.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "HTMLEmbedElement.h"
#include "JSSVGDocument.h"
#include "PlatformString.h"
#include "SVGDocument.h"
#include "kjs_dom.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLEmbedElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "width", JSHTMLEmbedElement::WidthAttrNum, DontDelete, 0, 0 },
    { "height", JSHTMLEmbedElement::HeightAttrNum, DontDelete, 0, &JSHTMLEmbedElementTableEntries[7] },
    { 0, 0, 0, 0, 0 },
    { "type", JSHTMLEmbedElement::TypeAttrNum, DontDelete, 0, 0 },
    { "align", JSHTMLEmbedElement::AlignAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "name", JSHTMLEmbedElement::NameAttrNum, DontDelete, 0, &JSHTMLEmbedElementTableEntries[8] },
    { "src", JSHTMLEmbedElement::SrcAttrNum, DontDelete, 0, &JSHTMLEmbedElementTableEntries[9] },
    { "constructor", JSHTMLEmbedElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLEmbedElementTable = 
{
    2, 10, JSHTMLEmbedElementTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSHTMLEmbedElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLEmbedElementConstructorTable = 
{
    2, 1, JSHTMLEmbedElementConstructorTableEntries, 1
};

class JSHTMLEmbedElementConstructor : public DOMObject {
public:
    JSHTMLEmbedElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLEmbedElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLEmbedElementConstructor::info = { "HTMLEmbedElementConstructor", 0, &JSHTMLEmbedElementConstructorTable, 0 };

bool JSHTMLEmbedElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLEmbedElementConstructor, DOMObject>(exec, &JSHTMLEmbedElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLEmbedElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLEmbedElementPrototypeTableEntries[] =
{
    { "getSVGDocument", JSHTMLEmbedElement::GetSVGDocumentFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSHTMLEmbedElementPrototypeTable = 
{
    2, 1, JSHTMLEmbedElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLEmbedElementPrototype::info = { "HTMLEmbedElementPrototype", 0, &JSHTMLEmbedElementPrototypeTable, 0 };

JSObject* JSHTMLEmbedElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLEmbedElementPrototype>(exec, "[[JSHTMLEmbedElement.prototype]]");
}

bool JSHTMLEmbedElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSHTMLEmbedElementPrototypeFunction, JSObject>(exec, &JSHTMLEmbedElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLEmbedElement::info = { "HTMLEmbedElement", &JSHTMLElement::info, &JSHTMLEmbedElementTable, 0 };

JSHTMLEmbedElement::JSHTMLEmbedElement(ExecState* exec, HTMLEmbedElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLEmbedElementPrototype::self(exec));
}

bool JSHTMLEmbedElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLEmbedElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLEmbedElement, JSHTMLElement>(exec, &JSHTMLEmbedElementTable, this, propertyName, slot);
}

JSValue* JSHTMLEmbedElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        return jsString(imp->align());
    }
    case HeightAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        return jsString(imp->height());
    }
    case NameAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        return jsString(imp->name());
    }
    case SrcAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        return jsString(imp->src());
    }
    case TypeAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        return jsString(imp->type());
    }
    case WidthAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        return jsString(imp->width());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLEmbedElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    if (customPut(exec, propertyName, value, attr))
        return;
    lookupPut<JSHTMLEmbedElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLEmbedElementTable, this);
}

void JSHTMLEmbedElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HeightAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        imp->setHeight(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NameAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SrcAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    case WidthAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());

        imp->setWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLEmbedElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLEmbedElementConstructor>(exec, "[[HTMLEmbedElement.constructor]]");
}
JSValue* JSHTMLEmbedElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLEmbedElement::info))
      return throwError(exec, TypeError);

    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(thisObj)->impl());

    switch (id) {
    case JSHTMLEmbedElement::GetSVGDocumentFuncNum: {
        ExceptionCode ec = 0;
        if (!checkNodeSecurity(exec, imp->getSVGDocument(ec)))
            return jsUndefined();


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getSVGDocument(ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}
