// This file is generated by kconfig_compiler from gsm.kcfg.
// All changes you do to this file will be lost.

#include "gsmpersistence.h"

#include "gsm.h"

using namespace Knm;

GsmPersistence::GsmPersistence(GsmSetting * setting, KSharedConfig::Ptr config, ConnectionPersistence::SecretStorageMode mode) : SettingPersistence(setting, config, mode)
{
}

GsmPersistence::~GsmPersistence()
{
}

void GsmPersistence::load()
{
  GsmSetting * setting = static_cast<GsmSetting *>(m_setting);
  setting->setNumber(m_config->readEntry("number", "*99#"));
  setting->setUsername(m_config->readEntry("username", ""));
  setting->setApn(m_config->readEntry("apn", ""));
  setting->setNetworkid(m_config->readEntry("networkid", ""));
  setting->setNetworktype(m_config->readEntry("networktype", 0));
  setting->setBand(m_config->readEntry("band", 0));
  // SECRETS
  if (m_storageMode == ConnectionPersistence::PlainText) {
    setting->setPassword(m_config->readEntry("password", ""));
    setting->setPin(m_config->readEntry("pin", ""));
    setting->setPuk(m_config->readEntry("puk", ""));
    setting->setSecretsAvailable(true);
  }
  setting->setInitialized();
}

void GsmPersistence::save()
{
  GsmSetting * setting = static_cast<GsmSetting *>(m_setting);
  m_config->writeEntry("number", setting->number());
  m_config->writeEntry("username", setting->username());
  m_config->writeEntry("apn", setting->apn());
  m_config->writeEntry("networkid", setting->networkid());
  m_config->writeEntry("networktype", setting->networktype());
  m_config->writeEntry("band", setting->band());
  // SECRET
  if (m_storageMode == ConnectionPersistence::PlainText) {
    m_config->writeEntry("password", setting->password());
    m_config->writeEntry("pin", setting->pin());
    m_config->writeEntry("puk", setting->puk());
  }
}

QMap<QString,QString> GsmPersistence::secrets() const
{
  GsmSetting * setting = static_cast<GsmSetting *>(m_setting);
  QMap<QString,QString> map;
  map.insert(QLatin1String("password"), setting->password());
  map.insert(QLatin1String("pin"), setting->pin());
  map.insert(QLatin1String("puk"), setting->puk());
  return map;
}

void GsmPersistence::restoreSecrets(QMap<QString,QString> secrets) const
{
  if (m_storageMode == ConnectionPersistence::Secure) {
    GsmSetting * setting = static_cast<GsmSetting *>(m_setting);
    setting->setPassword(secrets.value("password"));
    setting->setPin(secrets.value("pin"));
    setting->setPuk(secrets.value("puk"));
    setting->setSecretsAvailable(true);
  }
}
