/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment Boilerplate plugin
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "pgmbpviewport.h"

GST_DEBUG_CATEGORY_EXTERN (pgm_bp_debug);
#define GST_CAT_DEFAULT pgm_bp_debug

static PgmCanvasClass *parent_class = NULL;

static PgmError
pgm_bp_viewport_set_title (PgmViewport *viewport,
                           const gchar * title)
{
  GST_DEBUG_OBJECT (viewport, "set_title");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_set_cursor (PgmViewport *viewport,
                            PgmViewportCursor cursor)
{
  GST_DEBUG_OBJECT (viewport, "set_cursor");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_set_icon (PgmViewport *viewport,
                          GdkPixbuf *icon)
{
  GST_DEBUG_OBJECT (viewport, "set_icon");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_set_size (PgmViewport *viewport,
                          gint width,
                          gint height)
{
  GST_DEBUG_OBJECT (viewport, "set_size");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_get_size (PgmViewport *viewport,
                          gint *width,
                          gint *height)
{
  GST_LOG_OBJECT (viewport, "get_size");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_set_fullscreen (PgmViewport *viewport,
                                gboolean fullscreen)
{
  GST_DEBUG_OBJECT (viewport, "set_fullscreen");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_get_fullscreen (PgmViewport *viewport,
                                gboolean *fullscreen)
{
  GST_LOG_OBJECT (viewport, "get_fullscreen");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_set_screen_resolution (PgmViewport *viewport,
                                       gint width,
                                       gint height)
{
  GST_DEBUG_OBJECT (viewport, "set_screen_resolution");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_get_screen_resolution (PgmViewport *viewport,
                                       gint *width,
                                       gint *height)
{
  GST_LOG_OBJECT (viewport, "get_screen_resolution");
  /* FIXME: we should store screen resolution and size somewhere in
   * PgmBpViewport, so that the setters and getters work */

  *width = viewport->width;
  *height = viewport->height;

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_set_screen_size_mm (PgmViewport *viewport,
                                    gint width,
                                    gint height)
{
  GST_DEBUG_OBJECT (viewport, "set_screen_size_mm");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_get_screen_size_mm (PgmViewport *viewport,
                                    gint *width,
                                    gint *height)
{
  GST_LOG_OBJECT (viewport, "get_screen_size_mm");

  *width = viewport->width;
  *height = viewport->height;

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_set_canvas (PgmViewport *viewport,
                            PgmCanvas *canvas)
{
  GST_DEBUG_OBJECT (viewport, "set_canvas");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_get_pixel_formats (PgmViewport *viewport,
                                   gulong *formats_mask)
{
  GST_LOG_OBJECT (viewport, "get_pixel_formats");

  *formats_mask =
      PGM_IMAGE_RGB
      | PGM_IMAGE_BGR
      | PGM_IMAGE_RGBA
      | PGM_IMAGE_BGRA
      | PGM_IMAGE_I420
      | PGM_IMAGE_YV12
      | PGM_IMAGE_UYVY
      | PGM_IMAGE_YUYV;

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_get_caps_mask (PgmViewport *viewport,
                               gulong *caps_mask)
{
  GST_DEBUG_OBJECT (viewport, "get_caps_mask");

  return PGM_ERROR_OK;
}

static PgmError
pgm_bp_viewport_read_pixels (PgmViewport *viewport,
                             guint x,
                             guint y,
                             guint width,
                             guint height,
                             guint8 *pixels)
{
  GST_DEBUG_OBJECT (viewport, "read_pixels");

  pgm_viewport_push_pixels (viewport, width, height, pixels);

  return PGM_ERROR_OK;
}

/* GObject stuff */

PGM_DEFINE_DYNAMIC_TYPE (PgmBpViewport, pgm_bp_viewport, PGM_TYPE_VIEWPORT);

void
pgm_bp_viewport_register (GTypeModule *module)
{
  pgm_bp_viewport_register_type (module);
}

static void
pgm_bp_viewport_dispose (GObject *object)
{
  PgmBpViewport *viewport = PGM_BP_VIEWPORT (object);

  GST_DEBUG_OBJECT (viewport, "disposing boilerplate viewport");

  if (viewport->mutex)
    g_mutex_free (viewport->mutex);
  viewport->initialized = FALSE;

  GST_CALL_PARENT (G_OBJECT_CLASS, dispose, (object));
}

static void
pgm_bp_viewport_class_init (PgmBpViewportClass *klass)
{
  GObjectClass *gobject_class;
  PgmViewportClass *viewport_class;

  parent_class = g_type_class_peek_parent (klass);

  gobject_class = G_OBJECT_CLASS (klass);
  viewport_class = PGM_VIEWPORT_CLASS (klass);

  /* GObject virtual table */
  gobject_class->dispose = GST_DEBUG_FUNCPTR (pgm_bp_viewport_dispose);

  /* PgmViewport virtual table */
  viewport_class->set_title = GST_DEBUG_FUNCPTR (pgm_bp_viewport_set_title);
  viewport_class->set_cursor = GST_DEBUG_FUNCPTR (pgm_bp_viewport_set_cursor);
  viewport_class->set_icon = GST_DEBUG_FUNCPTR (pgm_bp_viewport_set_icon);
  viewport_class->set_size = GST_DEBUG_FUNCPTR (pgm_bp_viewport_set_size);
  viewport_class->get_size = GST_DEBUG_FUNCPTR (pgm_bp_viewport_get_size);
  viewport_class->set_fullscreen =
    GST_DEBUG_FUNCPTR (pgm_bp_viewport_set_fullscreen);
  viewport_class->get_fullscreen =
    GST_DEBUG_FUNCPTR (pgm_bp_viewport_get_fullscreen);
  viewport_class->set_screen_resolution =
    GST_DEBUG_FUNCPTR (pgm_bp_viewport_set_screen_resolution);
  viewport_class->get_screen_resolution =
    GST_DEBUG_FUNCPTR (pgm_bp_viewport_get_screen_resolution);
  viewport_class->set_screen_size_mm =
    GST_DEBUG_FUNCPTR (pgm_bp_viewport_set_screen_size_mm);
  viewport_class->get_screen_size_mm =
    GST_DEBUG_FUNCPTR (pgm_bp_viewport_get_screen_size_mm);
  viewport_class->set_canvas = GST_DEBUG_FUNCPTR (pgm_bp_viewport_set_canvas);
  viewport_class->get_pixel_formats =
    GST_DEBUG_FUNCPTR (pgm_bp_viewport_get_pixel_formats);
  viewport_class->get_caps_mask =
    GST_DEBUG_FUNCPTR (pgm_bp_viewport_get_caps_mask);
  viewport_class->read_pixels = GST_DEBUG_FUNCPTR (pgm_bp_viewport_read_pixels);
}

static void
pgm_bp_viewport_class_finalize (PgmBpViewportClass *klass)
{
  return;
}

static void
pgm_bp_viewport_init (PgmBpViewport *viewport)
{
  GST_DEBUG_OBJECT (viewport, "initializing boilerplate viewport");

  viewport->mutex = g_mutex_new ();
}

PgmViewport *
pgm_bp_viewport_new (void)
{
  return g_object_new (PGM_TYPE_BP_VIEWPORT, NULL);
}
