/*
 * Copyright (c) 1997, 2010, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2009, 2010, 2011 Red Hat, Inc.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

#include "precompiled.hpp"
#include "interpreter/interpreter.hpp"
#include "memory/allocation.inline.hpp"
#include "prims/methodHandles.hpp"

#define __ _masm->

int MethodHandles::adapter_conversion_ops_supported_mask() {
  return ((1<<java_lang_invoke_AdapterMethodHandle::OP_RETYPE_ONLY)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_RETYPE_RAW)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_CHECK_CAST)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_PRIM_TO_PRIM)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_REF_TO_PRIM)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_SWAP_ARGS)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_ROT_ARGS)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_DUP_ARGS)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_DROP_ARGS)
         |(1<<java_lang_invoke_AdapterMethodHandle::OP_SPREAD_ARGS)
         );
}

void MethodHandles::generate_method_handle_stub(MacroAssembler*          masm,
                                                MethodHandles::EntryKind ek) {
  init_entry(ek, (MethodHandleEntry *) ek);
}
void MethodHandles::RicochetFrame::generate_ricochet_blob(MacroAssembler* _masm,
                                                          // output params:
                                                          int* bounce_offset,
                                                          int* exception_offset,
                                                          int* frame_size_in_words) {
  (*frame_size_in_words) = 0;
  address start = __ pc();
  (*bounce_offset) = __ pc() - start;
  (*exception_offset) = __ pc() - start;
}

frame MethodHandles::ricochet_frame_sender(const frame& fr, RegisterMap *map) {
  //RicochetFrame* f = RicochetFrame::from_frame(fr);
  // Cf. is_interpreted_frame path of frame::sender
  //  intptr_t* younger_sp = fr.sp();
  //  intptr_t* sp         = fr.sender_sp();
  //  return frame(sp, younger_sp, this_frame_adjusted_stack);
  ShouldNotCallThis();  
}

void MethodHandles::ricochet_frame_oops_do(const frame& fr, OopClosure* blk, const RegisterMap* reg_map) {
  //  ResourceMark rm;
  //  RicochetFrame* f = RicochetFrame::from_frame(fr);

  // pick up the argument type descriptor:
  //  Thread* thread = Thread::current();
  // process fixed part
  //  blk->do_oop((oop*)f->saved_target_addr());
  //  blk->do_oop((oop*)f->saved_args_layout_addr());

  // process variable arguments:
  //  if (cookie.is_null())  return;  // no arguments to describe

  // the cookie is actually the invokeExact method for my target
  // his argument signature is what I'm interested in
  //  assert(cookie->is_method(), "");
  //  methodHandle invoker(thread, methodOop(cookie()));
  //  assert(invoker->name() == vmSymbols::invokeExact_name(), "must be this kind of method");
  //  assert(!invoker->is_static(), "must have MH argument");
  //  int slot_count = invoker->size_of_parameters();
  //  assert(slot_count >= 1, "must include 'this'");
  //  intptr_t* base = f->saved_args_base();
  //  intptr_t* retval = NULL;
  //  if (f->has_return_value_slot())
  //    retval = f->return_value_slot_addr();
  //  int slot_num = slot_count - 1;
  //  intptr_t* loc = &base[slot_num];
  //blk->do_oop((oop*) loc);   // original target, which is irrelevant
  //  int arg_num = 0;
  //  for (SignatureStream ss(invoker->signature()); !ss.is_done(); ss.next()) {
  //    if (ss.at_return_type())  continue;
  //    BasicType ptype = ss.type();
  //    if (ptype == T_ARRAY)  ptype = T_OBJECT; // fold all refs to T_OBJECT
  //    assert(ptype >= T_BOOLEAN && ptype <= T_OBJECT, "not array or void");
  //    slot_num -= type2size[ptype];
  //    loc = &base[slot_num];
  //    bool is_oop = (ptype == T_OBJECT && loc != retval);
  //    if (is_oop)  blk->do_oop((oop*)loc);
  //    arg_num += 1;
  //  }
  //  assert(slot_num == 0, "must have processed all the arguments");
}
