/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Color.h"

#include "Debug.h"
#include "SharedPointer.h"

using namespace GTLCore;

struct Color::Private : public SharedPointerData {
  Private() {}
  Private(const Private& _rhs) : SharedPointerData(), r(_rhs.r), g(_rhs.g), b(_rhs.b), a(_rhs.a)
  {}
  float r, g, b, a;
};

Color::Color() : d(new Private)
{
  d->ref();
  d->r = 0.0;
  d->g = 0.0;
  d->b = 0.0;
  d->a = 0.0;
}

Color::Color(float r, float g, float b, float a) : d(new Private)
{
  d->ref();
  d->r = r;
  d->g = g;
  d->b = b;
  d->a = a;
}

GTL_SHARED_DATA(Color)

bool Color::operator==(const Color& c)
{
  if (d == c.d) return true;
  return d->r == c.d->r and d->g == c.d->g and d->b == c.d->b and d->a == c.d->a;
}

float Color::red() const
{
  return d->r;
}

float Color::green() const
{
  return d->g;
}

float Color::blue() const
{
  return d->b;
}

float Color::alpha() const
{
  return d->a;
}

void Color::setRed(float r)
{
  deref();
  d->r = r;
}

void Color::setGreen(float r)
{
  deref();
  d->g = r;
}

void Color::setBlue(float r)
{
  deref();
  d->b = r;
}

void Color::setAlpha(float r)
{
  deref();
  d->a = r;
}
