/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_TEMPLATE_PARSER_H_
#define _OPENCTL_TEMPLATE_PARSER_H_

#include "TemplateAST_p.h"

#include <GTLCore/String.h>
#include <GTLCore/Token_p.h>

namespace GTLCore {
  class CompilationMessage;
  class CompilationMessages;
  class Token;
}

namespace OpenCTL {
  class TemplateLexer;
  /**
   * @internal
   * @ingroup OpenCTL
   *
   * @brief Parser of CTL Templates 
   */
  class TemplateParser {
    public:
      TemplateParser( TemplateLexer* _lexer, const GTLCore::String& _fileName, const std::list<GTLCore::String>& _includeDirectories);
      ~TemplateParser();
      TemplateAST::Node* parse();
      const GTLCore::CompilationMessages& errorMessages() const;
    private:
      TemplateAST::Node* parseAllChannels( TemplateAST::AllChannelsNode::WhichChannel _whichChannel );
      /**
       * parse something like "(myname)"
       */
      GTLCore::String parseName(bool _isOperation);
    private:
      void getNextToken();
      const GTLCore::Token& currentToken();
      void reportError( const GTLCore::String& errMsg, const GTLCore::Token& token );
      void reportUnexpected( const GTLCore::Token& token );
      bool isOfType( const GTLCore::Token& , GTLCore::Token::Type type );
    private:
      struct Private;
      Private* const d;
  };
}

#endif
