/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "MetadataLexer_p.h"

#include "GTLCore/Token_p.h"

#include "Debug.h"

using namespace OpenShiva;

MetadataLexer::MetadataLexer(std::istream* sstream) : LexerBase(sstream)
{
}

MetadataLexer::~MetadataLexer()
{
}

GTLCore::Token MetadataLexer::nextToken()
{
  int lastChar = getNextNonSeparatorChar();
  int initial_line = line() - 1;
  int initial_col = column() - 1;
  if( eof() ) return GTLCore::Token(GTLCore::Token::END_OF_FILE, line(), initial_col);
  // Test for comment
  GTLCore::Token commentToken;
  if( ignoreComment( commentToken, lastChar ) )
  {
    return commentToken;
  }
  if(isalpha(lastChar))
  {
    return GTLCore::Token(GTLCore::Token::IDENTIFIER, getIdentifier(lastChar),line(), initial_col);
  } else if( isdigit(lastChar) )
  { // if it's a digit 
    return getDigit(lastChar);
  } else if( lastChar == '"' ) {
    return getString(lastChar);
  } else {
    CHAR_IS_TOKEN('-', MINUS );
    CHAR_IS_TOKEN(';', SEMI );
    CHAR_IS_TOKEN(':', COLON );
    CHAR_IS_TOKEN('<', INFERIOR );
    CHAR_IS_TOKEN('>', SUPPERIOR );
    CHAR_IS_TOKEN('{', STARTBRACE );
    CHAR_IS_TOKEN('}', ENDBRACE );
    CHAR_IS_TOKEN(',', COMA );
  }
  if( lastChar > 128 ) return nextToken();
  GTLCore::String str;
  str = lastChar;
  GTL_DEBUG("Unknown token : " << lastChar << " " << str << " at " << initial_line << "," << initial_col);
  return GTLCore::Token(GTLCore::Token::UNKNOWN, initial_line, initial_col);
}

