/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_MODULE_P_H_
#define _OPENCTL_MODULE_P_H_

#include <map>
#include <list>
#include <GTLCore/ScopedName.h>
#include <vector>

namespace llvm {
  class Constant;
  class Module;
}

namespace GTLCore {
  class Function;
  class Parameter;
  class TypesManager;
  /**
   * @internal
   * This class is not part of the public API of GTLCore.
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT ModuleData {
    public:
      ModuleData( llvm::Module* llvmModule);
      ~ModuleData();
      bool appendFunction(const ScopedName& name, Function* function);
      const std::list<Function*>* function(const String& _currentNameSpace, const String& _name) const;
      const std::list<Function*>* function(const ScopedName& name);
      const GTLCore::Function* function(const GTLCore::String& _nameSpace, const GTLCore::String& name, std::vector<GTLCore::Parameter>& arguments) const;
      std::list<Function*> functions();
      std::map< ScopedName, llvm::Constant* > constants() { return m_constants; }
      void addConstant( const ScopedName& _scopedName, llvm::Constant* _constant )
      {
        m_constants[_scopedName] = _constant;
      }
      void linkWith( const GTLCore::String& _string);
      void linkWith( const ModuleData* _module );
      void doLink();
      llvm::Module* llvmModule() { return m_llvmModule; }
      const llvm::Module* llvmModule() const { return m_llvmModule; }
      llvm::Module* llvmLinkedModule() { return m_llvmLinkedModule; }
      const llvm::Module* llvmLinkedModule() const { return m_llvmLinkedModule; }
      TypesManager* typesManager() { return m_typesManager; }
      const TypesManager* typesManager() const { return m_typesManager; }
    private:
      void linkWith( const llvm::Module* _module );
    private:
      llvm::Module* m_llvmModule;
      llvm::Module* m_llvmLinkedModule;
      std::map<ScopedName, std::list<Function*>* > m_functions;
      TypesManager* m_typesManager;
      std::map< ScopedName, llvm::Constant* > m_constants;
      std::list< const llvm::Module* > m_linkModuleWith;
      std::list< GTLCore::String > m_linkModuleWithArchives;
  };
}

#endif
