/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_METADATA_PARAMETER_ENTRY_H_
#define _GTLCORE_METADATA_PARAMETER_ENTRY_H_

#include <GTLCore/Metadata/Group.h>

namespace GTLCore {
  class Type;
  class Value;
  namespace Metadata {
    /**
     * @ingroup GTLCore_Metadata
     * @brief represent a parameter entry in a metadata
     * 
     * This metadata @ref Entry is a @ref Group countaining at least a name,
     * a default value and a widget type.
     */
    class GTLCORE_EXPORT ParameterEntry : public Group {
      friend class Factory;
      private:
        ParameterEntry( const GTLCore::String& _name, const std::list< const Entry* >& _entries );
        virtual ~ParameterEntry();
      public:
        /**
         * Possible widget types.
         */
        enum WidgetType {
          CheckBoxWidget, ///< checkbox (for booleans)
          IntegerWidget, ///< integer
          IntegerVectorWidget, ///< vector of integers
          FloatWidget, ///< float
          FloatVectorWidget, ///< vector of floats
          CurveWidget, ///< curve
          RgbColorWidget, ///< color selector
          RgbaColorWidget ///< color selector with RGBA
        };
      public:
        /**
         * @return the minimum value
         */
        const Value& minimumValue() const;
        /**
         * @return the maximum value
         */
        const Value& maximumValue() const;
        /**
         * @return the default value
         */
        const Value& defaultValue() const;
        /**
         * @return the type of the value
         */
        const Type* valueType() const;
        /**
         * @return a description of this parameter
         */
        const GTLCore::String& description() const;
        /**
         * @return the type of widget that should be used to modify this parameter
         */
        WidgetType widgetType() const;
      public:
        virtual const ParameterEntry* asParameterEntry() const;
      private:
        struct Private;
        Private* const d;
    };
  }
}

#endif
