/*
 * Copyright 2010 Inalogic® Inc.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License, as
 * published by the  Free Software Foundation; either version 2.1 or 3.0
 * of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License along with this program. If not, see <http://www.gnu.org/licenses/>
 *
 * Authored by: Jay Taoko <jaytaoko@inalogic.com>
 *
 */

#ifndef MATRIX4PREVIEW_H
#define MATRIX4PREVIEW_H

#include "NuxGraphics/GpuDevice.h"
#include "NuxGraphics/GLDeviceObjects.h"
#include "Matrix4Editor.h"

namespace nux
{

  class HLayout;
  class StaticTextBox;

  class Matrix4Preview : public View
  {
  public:
    Matrix4Preview (Matrix4 matrix = Matrix4::IDENTITY(), NUX_FILE_LINE_PROTO);
    ~Matrix4Preview();
    virtual long ProcessEvent (IEvent &ievent, long TraverseInfo, long ProcessEventInfo);
    virtual void Draw (GraphicsEngine &GfxContext, bool force_draw);
    virtual void DrawContent (GraphicsEngine &GfxContext, bool force_draw);
    virtual void PostDraw (GraphicsEngine &GfxContext, bool force_draw);

    sigc::signal<void, Matrix4Editor * > sigMatrixChanged;
    void RecvDialogChange (Matrix4Editor *matrixeditor);

    void SetMatrix (Matrix4 matrix);
    Matrix4 GetMatrix() const;

  private:
    void RecvTimer (void *v);
    void RecvClick (int x, int y, unsigned long button_flags, unsigned long key_flags);
    TimerFunctor *m_ChangeDetectionTimer;
    TimerHandle m_ChangeTimerHandler;

    Matrix4 m_Matrix;
    Matrix4DialogProxy *m_DialogThreadProxy;
  };


}

#endif // MATRIX4PREVIEW_H

