/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_WM_H_
#define _NL_WM_H_

#include <glib-object.h>
#include <gtk/gtk.h>
#include <libwnck/libwnck.h>

#define NL_TYPE_WM (nl_wm_get_type ())

#define NL_WM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_WM, NlWm))

#define NL_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_WM, NlWmClass))

#define NL_IS_WM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_WM))

#define NL_IS_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_WM))

#define NL_WM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_WM, NlWmClass))

typedef struct _NlWm        NlWm;
typedef struct _NlWmClass   NlWmClass;
typedef struct _NlWmPrivate NlWmPrivate;
 
struct _NlWm
{
  GObject        parent;	

  NlWmPrivate *priv;
};

struct _NlWmClass
{
  GObjectClass   parent_class;

  /*< signals />*/
  void (*show_windec) (NlWm *wm, WnckWindow *window);
  void (*hide_windec) (NlWm *wm);
};

GType nl_wm_get_type (void) G_GNUC_CONST;

NlWm * nl_wm_get_default (void);


#endif /* _NL_WM_H_ */

