function su_create_instance(nsclass, nsinterface)
{
	try {
		return Components.classes[nsclass]
					.createInstance(Components.interfaces[nsinterface]);
	} catch (e) {
		return null;
	}
}

function su_get_service(nsclass, nsinterface)
{
	try {
		return Components.classes[nsclass]
					.getService(Components.interfaces[nsinterface]);
	} catch (e) {
		return null;
	}
}

function su_include(uri)
{
	su_get_service(
				"@mozilla.org/moz/jssubscript-loader;1",
				"mozIJSSubScriptLoader")
				.loadSubScript(uri);
}

function su_get_element(id)
{
	return document.getElementById(id);
}

su_include("chrome://stumbleupon/content/datastore.js");

var su_ds = su_Datastore.getService();
var icons_only;
var bad_stumble;
var great_stumble;
var parent_window = null;
var search_plugin;
//var autocomplete_source;
var keyspec;
var shortcut_item;
var recent_keypress_modifiers;
var preferred_position_group;
var preferred_show_firstrater_label_always;
var stumbleupon_toolbar_menuitem = null;
var TOGGLE_TOOLBAR_LISTITEM_INDEX = 4;
var enable_ids = [
			"shortcut_stumble",
			"shortcut_thumbup",
			"shortcut_thumbdown",
			"shortcut_tag",
			"shortcut_reviews"];
//			"shortcut_details"
var mode_ids = [
//			"show_mode_all",
			"show_mode_friends",
			"show_mode_news",
			"show_mode_photo",
			"show_mode_search",
			"show_mode_stumblers",
			"show_mode_video",
			"show_mode_wiki",
			"show_mode_more"];
	
function doOK()
{
	//!!! Update all open windows for this application. -- JW

	// now save new prefs...

	if (is_parent_window_destroyed())
	{
		su_get_element("stumble_pref_dialog").cancelDialog();
		return true;
	}
	
	
	su_ds.setValue("$show_mode", su_get_element("show_mode").checked);
	for (i = 0; i < mode_ids.length; i++)
	{
		su_ds.setValue("$" + mode_ids[i], su_get_element(mode_ids[i]).checked);
	}
	
	su_ds.setValue("$show_field", su_get_element("show_field").checked);

	// see if they have changed...
	var thebutton = su_get_element("bad-stumble");
	bad_stumble = thebutton.checked;
	su_ds.setValue("$bad_stumble", bad_stumble);

	thebutton = su_get_element("great-stumble");
	great_stumble = thebutton.checked;
	su_ds.setValue("$great_stumble", great_stumble);

	su_ds.setValue("$prefetch", su_get_element("prefetch").checked);

//	su_ds.setValue("$comment_firstrating", su_get_element("comment_firstrating").checked);

	su_ds.setValue("$review_new_window", su_get_element("review_new_window").checked);
	su_ds.setValue("$rate_new_window", su_get_element("rate_new_window").checked);
//	su_ds.setValue("$search_new_window", su_get_element("search_new_window").checked);

	var new_stumble_topics = su_get_element("stumble_topics").checked;
	su_ds.setValue("$stumble_topics", new_stumble_topics);

	var new_show_topics = su_get_element("show_topics").checked;
	su_ds.setValue("$show_topics", new_show_topics);

	var new_show_info = su_get_element("show_info").checked;
	su_ds.setValue("$show_info", new_show_info);

	var new_show_tag = su_get_element("show_tag").checked;
	su_ds.setValue("$show_tag", new_show_tag);
	if (new_show_tag)
		su_ds.setValue("$shown_tag", true);

	var new_show_flag = su_get_element("show_flag").checked;
	su_ds.setValue("$show_flag", new_show_flag);

//	var new_show_search = su_get_element("show_search").checked;
//	su_ds.setValue("$show_search", new_show_search);

	su_ds.setValue("$show_legacy_network",  
				su_get_element("show_legacy_network").checked);

	var new_show_home = su_get_element("show_home").checked;
	su_ds.setValue("$show_home", new_show_home);

//	var new_show_editinfo = su_get_element("show_editinfo").checked;
//	su_ds.setValue("$show_editinfo", new_show_editinfo);

	su_ds.setValue("$show_legacy_forums", 
				su_get_element("show_legacy_forums").checked);

	var new_show_friends = su_get_element("show_friends").checked;
	su_ds.setValue("$show_friends", new_show_friends);

	var new_show_matches = su_get_element("show_matches").checked;
	su_ds.setValue("$show_matches", new_show_matches);

	var new_show_aboutme = su_get_element("show_aboutme").checked;
	su_ds.setValue("$show_aboutme", new_show_aboutme);

	var new_show_groups = su_get_element("show_groups").checked;
	su_ds.setValue("$show_groups", new_show_groups);

	var new_show_messages = su_get_element("show_messages").checked;
	su_ds.setValue("$show_messages", new_show_messages);

	var new_show_referral = su_get_element("show_referral").checked;
	su_ds.setValue("$show_referral", new_show_referral);

	var new_search_clear_queries = su_get_element("search_clear_queries").checked;
	su_ds.setValue("$search_clear_queries", new_search_clear_queries);

	var new_show_searchlinks_score = su_get_element("show_searchlinks_score").checked;
	su_ds.setValue("$show_searchlinks_score", new_show_searchlinks_score);

	var new_show_searchlinks_friends = su_get_element("show_searchlinks_friends").checked;
	su_ds.setValue("$show_searchlinks_friends", new_show_searchlinks_friends);

	var new_show_searchlinks_topic = su_get_element("show_searchlinks_topic").checked;
	su_ds.setValue("$show_searchlinks_topic", new_show_searchlinks_topic);

	var new_show_searchlinks_logo = su_get_element("show_searchlinks_logo").checked;
	su_ds.setValue("$show_searchlinks_logo", new_show_searchlinks_logo);

	var new_stumble_upon_change = su_get_element("stumble_upon_change").checked;
	su_ds.setValue("$stumble_upon_change", new_stumble_upon_change);

//	var new_autocomplete_type = su_get_element("search_group").selectedItem.value;
//	su_ds.setValue("$autocomplete_type", new_autocomplete_type);

	// now see if icons thingies have changed...
	var new_icons_only;
	if (su_get_element("icons-only").selected)
	{
		new_icons_only = "icons-only";
		su_ds.setValue("$show_firstrater_label_always", su_get_element("show_firstrater_label_always").checked);
	}
	else if (su_get_element("text-icons").selected)
	{
		new_icons_only = "text-icons";
		su_ds.setValue("$show_firstrater_label_always", preferred_show_firstrater_label_always);
	}
	su_ds.setValue("$icons", new_icons_only);

//	else if (su_get_element("extra-text").selected)
//		new_icons_only = "extra-text";

/*
	if ((navigator.userAgent.indexOf("Win") != -1) &&
				(navigator.userAgent.indexOf("Firefox") != -1))
	{
		// The plugin only works on Firefox under XP for now....
		// See also the relevant section in stumbleuponOverlay.js.

		var new_search_plugin = su_get_element("search_plugin").checked;

		if (new_search_plugin != search_plugin)
		{
			su_ds.setValue("$search_plugin", new_search_plugin);
			if (parent_window)
			{
				if (new_search_plugin)
				{
					parent_window.su_add_search_plugin(1);
					alert("The search engine plugin will be added when you restart your browser.");
				}
				else
				{
					parent_window.su_remove_search_plugin();
					alert("The search engine plugin will be removed when you restart your browser.");
				}
			}
		}
	}
*/
	var toolbar_toggle_visible = su_get_element("toggle").checked;
	su_ds.setValue("@toolbar_toggle_visible", toolbar_toggle_visible)
	var old_toolbar_position = su_ds.getValue("@toolbar-position");
	var toolbar_position = su_get_element("toolbar-position").selectedItem.id;
	su_ds.setValue("@toolbar-position", toolbar_position);
	if (su_get_element("position-group").selectedItem)
	{
		var toolbar = parent_window.su_get_element(toolbar_position);
		var customizable = (toolbar.hasAttribute("customizable") && 
					(toolbar.getAttribute("customizable") == "true"))

		var position_group = su_get_element("position-group").selectedItem.id;
		
		if ((position_group == "drop") && ((! customizable) ||
					(toolbar_position != old_toolbar_position)))
			position_group = "first";
			
		su_ds.setValue("@position-group", position_group);
	}

	var shortcuts_enabled = su_get_element("shortcuts-enable").checked;
	su_ds.setValue("$shortcuts_enabled", shortcuts_enabled);
	
	var shortcut_stumble = su_get_element("shortcut_stumble").getAttribute("keyspec");
	su_ds.setValue("$shortcut_stumble", shortcut_stumble);

	var shortcut_reviews = su_get_element("shortcut_reviews").getAttribute("keyspec");
	su_ds.setValue("$shortcut_reviews", shortcut_reviews);

	var shortcut_thumbup = su_get_element("shortcut_thumbup").getAttribute("keyspec");
	su_ds.setValue("$shortcut_thumbup", shortcut_thumbup);

	var shortcut_thumbdown = su_get_element("shortcut_thumbdown").getAttribute("keyspec");
	su_ds.setValue("$shortcut_thumbdown", shortcut_thumbdown);

	var shortcut_tag = su_get_element("shortcut_tag").getAttribute("keyspec");
	su_ds.setValue("$shortcut_tag", shortcut_tag);

//	var shortcut_details = su_get_element("shortcut_details").getAttribute("keyspec");
//	su_ds.setValue("$shortcut_details", shortcut_details);

	var shortcut_toolbar = su_get_element("shortcut_toolbar").getAttribute("keyspec");
	su_ds.setValue("$shortcut_toolbar", shortcut_toolbar);
	
	su_ds.flushPrefs();

	parent_window.setTimeout(function (parent) { parent.su_handle_preference_dialog_accept(); }, 0, parent_window);
	
	return true;
}

function doCancel()
{
	if (! is_parent_window_destroyed())
	{
		parent_window.su_preference_dialog = null;
	}
	return true;
}

function is_parent_window_destroyed()
{
	// Verify that the window is undestroyed. -- JW
	try { var str = parent_window.location + " "; }
	catch (e)
	{
		return true;
	}
	return false;
}

function init()
{
	var i;
	if (opener && opener.location.href.indexOf("extensions.xul") != -1)
	{
		if (opener.opener && (opener.opener.location.href.indexOf("browser.xul") != -1))
		{
			// opened from the extensions window
			parent_window = opener.opener;
		}
		else 
		{
			// possibly opened from the all-in-one sidebar
			var window_service = Components.classes["@mozilla.org/appshell/window-mediator;1"]
						.getService(Components.interfaces.nsIWindowMediator);
			parent_window = window_service.getMostRecentWindow("navigator:browser");
		}
	}
	else
	{
		// opened via the toolbar Menu
		parent_window = opener;
	}

	if (is_parent_window_destroyed())
	{
		su_get_element("stumble_pref_dialog").cancelDialog();
		return;
	}

	parent_window.su_preference_dialog = su_get_element("stumble_pref_dialog");

	if (su_ds.getValue("@current_user") == 0)
	{
		var id_list = su_ds.getValue("@id_list");

		var ids = id_list.split(":");

		var found_an_id = false;

		for (i = 0; i < ids.length; i++)
		{
			if (ids[i] == "")
				continue;

			found_an_id = true;
			break;
		}

		if (found_an_id)
		{
			alert("You can edit preferences after you sign-in.\n\n" +
						'Click the "Start Stumbling..." button on the toolbar to sign-in.');
		}
		else
		{
			alert("You can edit toolbar preferences after you create a StumbleUpon profile.\n\n" +
						'Click the "Start Stumbling..." button on the toolbar to create a profile.');
		}
		window.close();
		return;
	}

	if (su_ds.hasFeature("$sociallinks"))
		su_get_element("show_searchlinks_friends_box").hidden = false;

	if (su_ds.hasFeature("$reportoption"))
		su_get_element("$show_flag_box").hidden = false;

	var show_searchlinks_score = su_ds.getValue("$show_searchlinks_score");
	su_get_element("show_searchlinks_score").checked = show_searchlinks_score;
	
	var show_searchlinks_friends = su_ds.getValue("$show_searchlinks_friends");
	su_get_element("show_searchlinks_friends").checked = show_searchlinks_friends;

	var show_searchlinks_topic = su_ds.getValue("$show_searchlinks_topic");
	su_get_element("show_searchlinks_topic").checked = show_searchlinks_topic;

	var show_searchlinks_logo = su_ds.getValue("$show_searchlinks_logo");
	su_get_element("show_searchlinks_logo").checked = show_searchlinks_logo;
	
	var stumble_upon_change = su_ds.getValue("$stumble_upon_change");
	su_get_element("stumble_upon_change").checked = stumble_upon_change;

	su_update_searchlinks_logo_enabled_state();
//	}

	bad_stumble = su_ds.getValue("$bad_stumble");
	great_stumble = su_ds.getValue("$great_stumble");

	su_get_element("show_field").checked = su_ds.getValue("$show_field");
//	update_field_enabled_state();	
/*
	if ((navigator.userAgent.indexOf("Win") != -1) &&
				(navigator.userAgent.indexOf("Firefox") != -1))
	{
		search_plugin = su_ds.getValue("$search_plugin");
	}
	else
	{
		// The plugin only works on Firefox under XP for now....
		// Hide the search plug-in configuration control until we figure out
		// how to install/uninstall on other platforms.
		// See also the relevant section in stumbleuponOverlay.js.

		su_get_element("search_plugin").hidden = true;
	}
*/

	su_get_element("show_mode").checked = su_ds.getValue("$show_mode");
	for (i = 0; i < mode_ids.length; i++)
	{
		su_get_element(mode_ids[i]).checked = su_ds.getValue("$" + mode_ids[i]);
	}
	update_mode_enabled_state();

	// set inputs...
	su_get_element("bad-stumble").checked = bad_stumble;
	su_get_element("great-stumble").checked = great_stumble;
//	su_get_element("search_plugin").checked = search_plugin;

	su_get_element("prefetch").checked = su_ds.getValue("$prefetch");
//	su_get_element("comment_firstrating").checked = su_ds.getValue("$comment_firstrating");
	su_get_element("review_new_window").checked = su_ds.getValue("$review_new_window");
	su_get_element("rate_new_window").checked = su_ds.getValue("$rate_new_window");
//	su_get_element("search_new_window").checked = su_ds.getValue("$search_new_window");
	su_get_element("stumble_topics").checked = su_ds.getValue("$stumble_topics");
	su_get_element("search_clear_queries").checked = su_ds.getValue("$search_clear_queries");

	su_get_element("show_topics").checked = su_ds.getValue("$show_topics");
	su_get_element("show_info").checked = su_ds.getValue("$show_info");
//	su_get_element("show_search").checked = su_ds.getValue("$show_search");
	su_get_element("show_tag").checked = su_ds.getValue("$show_tag");
	su_get_element("show_flag").checked = su_ds.getValue("$show_flag");
	su_get_element("show_referral").checked = su_ds.getValue("$show_referral");
	su_get_element("show_aboutme").checked = su_ds.getValue("$show_aboutme");
	su_get_element("show_home").checked = su_ds.getValue("$show_home");
	su_get_element("show_friends").checked = su_ds.getValue("$show_friends");
	su_get_element("show_messages").checked = su_ds.getValue("$show_messages");
	su_get_element("show_legacy_network").checked = su_ds.getValue("$show_legacy_network");
	su_get_element("show_matches").checked = su_ds.getValue("$show_matches");
	su_get_element("show_legacy_forums").checked = su_ds.getValue("$show_legacy_forums");
	su_get_element("show_groups").checked = su_ds.getValue("$show_groups");
//	su_get_element("show_editinfo").checked = su_ds.getValue("$show_editinfo");

	su_get_element("toggle").checked = su_ds.getValue("@toolbar_toggle_visible");

	icons_only = su_ds.getValue("$icons");

	if (icons_only == "extra-text")
		icons_only = "text-icons";

	su_get_element("text-group").selectedItem = su_get_element(icons_only);

	preferred_show_firstrater_label_always = su_ds.getValue("$show_firstrater_label_always");
	update_firstrater_label_enabled_state();

//	var autocomplete_type = su_ds.getValue("$autocomplete_type");
//	su_get_element("search_group").selectedItem = su_get_element("search_group_" + autocomplete_type);

	var shortcut_stumble_default;
	var shortcut_reviews_default;
	var shortcut_thumbup_default;
	var shortcut_thumbdown_default;
	var shortcut_tag_default;
//	var shortcut_details_default;
	var shortcut_toolbar_default;

	if (parent_window.su_host.mac)
	{
		shortcut_stumble_default = "Alt+VK_ESCAPE";
		shortcut_thumbup_default = "Alt+VK_F1";
		shortcut_thumbdown_default = "Alt+VK_F2";
		shortcut_tag_default     = "Alt+VK_SLASH";
		shortcut_reviews_default = "Alt+VK_F3";
//		shortcut_details_default = "Alt+VK_F4";
		shortcut_toolbar_default = "Command+VK_F11";
	}
	else if (parent_window.su_host.win)
	{
 		shortcut_stumble_default = "Alt+VK_BACK_QUOTE";
 		shortcut_thumbup_default = "Alt+VK_1";
 		shortcut_thumbdown_default = "Alt+VK_2";
		shortcut_tag_default     = "Alt+VK_SLASH";
 		shortcut_reviews_default = "Alt+VK_3";
//		shortcut_details_default = "Alt+VK_4";
		shortcut_toolbar_default = "Ctrl+VK_F11";
	}
	else
	{
		shortcut_stumble_default = "Alt+VK_ESCAPE";
		shortcut_thumbup_default = "Alt+VK_F1";
		shortcut_thumbdown_default = "Alt+VK_F2";
		shortcut_tag_default     = "Alt+VK_SLASH";
 		shortcut_reviews_default = "Alt+VK_F3";
//		shortcut_details_default = "Alt+VK_F4";
		shortcut_toolbar_default = "Ctrl+VK_F11";
	}
	var shortcut_stumble = su_ds.getPrefValue("$shortcut_stumble", shortcut_stumble_default);
	var shortcut_thumbup = su_ds.getPrefValue("$shortcut_thumbup", shortcut_thumbup_default);
	var shortcut_thumbdown = su_ds.getPrefValue("$shortcut_thumbdown", shortcut_thumbdown_default);
	var shortcut_tag = su_ds.getPrefValue("$shortcut_tag", shortcut_tag_default);
	var shortcut_reviews = su_ds.getPrefValue("$shortcut_reviews", shortcut_reviews_default);
//	var shortcut_details = su_ds.getPrefValue("$shortcut_details", shortcut_details_default);
	var shortcut_toolbar = su_ds.getPrefValue("$shortcut_toolbar", shortcut_toolbar_default);

	su_get_element("shortcut_stumble").setAttribute("keyspec", shortcut_stumble);
	su_get_element("shortcut_stumble").setAttribute("keyspec-default", shortcut_stumble_default);
	su_get_element("shortcut_thumbup").setAttribute("keyspec", shortcut_thumbup);
	su_get_element("shortcut_thumbup").setAttribute("keyspec-default", shortcut_thumbup_default);
	su_get_element("shortcut_thumbdown").setAttribute("keyspec", shortcut_thumbdown);
	su_get_element("shortcut_thumbdown").setAttribute("keyspec-default", shortcut_thumbdown_default);
	su_get_element("shortcut_tag").setAttribute("keyspec", shortcut_tag);
	su_get_element("shortcut_tag").setAttribute("keyspec-default", shortcut_tag_default);
	su_get_element("shortcut_reviews").setAttribute("keyspec", shortcut_reviews);
	su_get_element("shortcut_reviews").setAttribute("keyspec-default", shortcut_reviews_default);
//	su_get_element("shortcut_details").setAttribute("keyspec", shortcut_details);
//	su_get_element("shortcut_details").setAttribute("keyspec-default", shortcut_details_default);

	var shortcuts_enabled = su_ds.getValue("$shortcuts_enabled");
	su_get_element("shortcuts-enable").checked = shortcuts_enabled;
	handle_shortcuts_enable_command(shortcuts_enabled);

	su_get_element("shortcut_toolbar").setAttribute("label", "  " + parent_window.su_get_display_keyspec(shortcut_toolbar));
	su_get_element("shortcut_toolbar").setAttribute("keyspec", shortcut_toolbar);
	su_get_element("shortcut_toolbar").setAttribute("keyspec-default", shortcut_toolbar_default);

	
	if (! parent_window.BrowserCustomizeToolbar)
	{
		su_get_element("placement-toolkit-caption").hidden = true;
		su_get_element("placement-caption").hidden = false;
		su_get_element("customize-position-box").hidden = true;
	}
	init_toolbar_placement();
}

function init_toolbar_placement()
{
	// Create list of toolbars for toolbar-position

	var toolbars = parent_window.document.getElementsByTagName("toolbar");
	var statusbars = parent_window.document.getElementsByTagName("statusbar");
	var menubars = parent_window.document.getElementsByTagName("menubar");
	var popup = su_get_element("placement-popup");
	var x, bar, item, val, list;

	// first remove the toolbars already there...
	while (popup.hasChildNodes())
		popup.removeChild(popup.firstChild);

	toolbars = concat(toolbars, statusbars);
	toolbars = concat(toolbars, menubars);
	
	for (x = 0; x < toolbars.length; x++)
	{
		if (! toolbars[x].hasAttribute("id"))
			continue;
		
		var bar_id = toolbars[x].getAttribute("id");

		if (su_ds.lookup("toolbarid", "bad_target_flag", bar_id))
			continue;

		// weird firefox toolbar
		if ((bar_id == "toolbar-menubar") &&
					(navigator.userAgent.indexOf("Mac") != -1))
			continue;

		// Exclude the All-in-One Sidebar extension toolbars. -- JW
		if (bar_id.indexOf("aios") == 0)
			continue;
		
		// Exclude the ScrapBook toolbars. -- JW
		if (bar_id.indexOf("ScrapBook") == 0)
			continue;

		// Exclude webdeveloper supplemental toolbars. -- JW
		if ((bar_id.indexOf("webdeveloper") != -1) && 
					(bar_id != "webdeveloper-toolbar"))
			continue;
		
		item = document.createElement("menuitem");
		item.setAttribute("id", bar_id);
		item.value = bar_id;
		if (item.value == "status-bar")
			item.setAttribute("label", "Status Bar");
		else if (item.value == "toolbar-menubar")
			item.setAttribute("label", "Menu Bar");
		else if (item.value == "nav-bar")
			item.setAttribute("label", "Navigation Toolbar");
		else if (item.value == "PersonalToolbar")
			item.setAttribute("label", "Personal Toolbar");
		else if (item.value == "linktoolbar")
			item.setAttribute("label", "Link Toolbar");
		else if (toolbars[x].hasAttribute("toolbarname"))
			item.setAttribute("label", toolbars[x].getAttribute("toolbarname"));
		else
			item.setAttribute("label", bar_id);
		
		if (bar_id == "stumbleupon")
		{
			stumbleupon_toolbar_menuitem = item;
		}
		
		popup.appendChild(item);
	}

	var toolbar_position = su_ds.getValue("@toolbar-position");
	if ((toolbar_position == "webpedia") || 
				(toolbar_position == "fbToolbar"))
	{
		toolbar_position = "stumbleupon";
	}
	su_get_element("toolbar-position").selectedItem = su_get_element(toolbar_position);

	var position_group = su_ds.getValue("@position-group");
	if ((toolbar_position == "stumbleupon") || 
				(toolbar_position == "gtbToolbar") || 
				(toolbar_position == "yahoo-toolbar") ||
				(toolbar_position == "prefbar") ||
				(toolbar_position == "MBSTB-Toolbar"))
	{
		position_group = "first";
		su_ds.setValue("@position-group", "first");
	}
	preferred_position_group = position_group;
	su_get_element("position-group").selectedItem = su_get_element(position_group);
	
	handle_toolbar_position_command(toolbar_position);
	handle_position_group_command(position_group);
}
	
function concat(c1, c2)
{
	// Concats too collections into an array.
	var c3 = new Array(c1.length + c2.length);
	var x,y = 0;

	for (x = 0; x < c1.length; x++)
		c3[y++] = c1[x];

	for (x = 0; x < c2.length; x++)
		c3[y++] = c2[x];

	return c3;
}

/*
function topWindow()
{
	//XXX need app specific
	var windowManager = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService();
	var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
	var win = windowManagerInterface.getMostRecentWindow("navigator:browser");
	if (!win)
		win = window.openDialog("chrome://browser/content/browser.xul", "_blank", "chrome,all,dialog=no", "about:blank", null, null);
	return win;
}
*/

function update_firstrater_label_enabled_state()
{
	if (su_get_element("icons-only").selected)
	{
		su_get_element("show_firstrater_label_always").checked = preferred_show_firstrater_label_always;
		su_get_element("show_firstrater_label_always").disabled = false;
	}
	else if (su_get_element("text-icons").selected)
	{
		preferred_show_firstrater_label_always = su_get_element("show_firstrater_label_always").checked;
		su_get_element("show_firstrater_label_always").checked = true;
		su_get_element("show_firstrater_label_always").disabled = true;
	}
}

function su_update_searchlinks_logo_enabled_state()
{
	var show_searchlinks_score = su_get_element("show_searchlinks_score").checked;
	var show_searchlinks_friends = su_get_element("show_searchlinks_friends").checked;
	var show_searchlinks_topic = su_get_element("show_searchlinks_topic").checked;
	su_get_element("show_searchlinks_logo").disabled = 
				(!(show_searchlinks_score || show_searchlinks_friends || show_searchlinks_topic));
}

function update_mode_enabled_state()
{
	var enabled = su_get_element("show_mode").checked;
	var i;
	for (i = 0; i < mode_ids.length; i++)
	{
		su_get_element(mode_ids[i]).disabled = (! enabled);
	}
	su_get_element("show_mode_more").disabled = (! enabled);
	
}

//function update_field_enabled_state()
//{
//	var enabled = su_get_element("show_field").checked;
//	
//	su_get_element("search_group_prompt").disabled = (! enabled);
//	su_get_element("search_group_query").disabled = (! enabled);
//	su_get_element("search_group_tag").disabled = (! enabled);
//	
//}

function handle_toggle_label_click()
{
	su_get_element("toggle").checked = (! su_get_element("toggle").checked); 
}

function handle_toolbar_position_command(toolbar_position)
{
	if ((toolbar_position == "stumbleupon") || 
				(toolbar_position == "gtbToolbar") || 
				(toolbar_position == "yahoo-toolbar") ||
				(toolbar_position == "prefbar") ||
				(toolbar_position == "MBSTB-Toolbar"))
	{
		su_get_element("last").disabled = true;
		su_get_element("position-group").selectedItem = su_get_element("first");
		
	}
	else
	{
		su_get_element("last").disabled = false;
		su_get_element("position-group").selectedItem = su_get_element(preferred_position_group);
	}
}

function handle_position_group_command(position_group)
{
	preferred_position_group = position_group;
}

function handle_customize_position_command()
{
	su_ds.setValue("@toolbar-position", "stumbleupon");
	su_ds.setValue("@position-group", "drop");
	su_ds.flushPrefs();
	parent_window.setTimeout(function (parent) { parent.su_customize_toolbox(); }, 100, parent_window);
	window.close();
}

function handle_more_mode_command()
{
	window.openDialog(
				"chrome://stumbleupon/content/moreChannelsDialog.xul", 
				"More Channels",
				"chrome,modal,dialog,centerscreen,dependent");
}

function handle_shortcuts_enable_command(enabled)
{
	var ids = enable_ids;
	
	var i;
	var found = false;
	for (i = 0; i < ids.length; i++)
	{
		var el = su_get_element(ids[i]);
		if (el == shortcut_item)
			found = true;
		var label = su_get_element(ids[i] + "_label");
		if (enabled)
		{
			label.disabled = false;
			el.setAttribute("label", "  " + 
						parent_window.su_get_display_keyspec(
						el.getAttribute("keyspec")));
		}
		else
		{
			label.disabled = true;
			el.setAttribute("label", "");
		}
	}
	
	if (found && (! enabled))
	{
		shortcut_item = null;
		refresh_shortcut_preview();
	}
}
		
// handles the select event for the shortcuts element
function handle_shortcuts_select(event)
{
	su_get_element("shortcut_preview").disabled = false;
	su_get_element("shortcut_change").disabled = false;

	shortcut_item = get_shortcut_item_from_index(event.target.selectedIndex);
	keyspec = shortcut_item.getAttribute("keyspec");
	
	if (! su_get_element("shortcuts-enable").checked)
	{
		var ids = enable_ids;
		var found = false;
		for (i = 0; i < ids.length; i++)
		{
			if (ids[i] == shortcut_item.id)
			{
				found = true;
				break;
			}
		}
		if (found)
		{
			su_get_element("shortcuts-enable").checked = true;
			handle_shortcuts_enable_command(true);
		}
	}
	
	refresh_shortcut_preview();
}

// dereferences a shortcut selected item index to the cell element
// used to display the shortcut
function get_shortcut_item_from_index(index)
{
	switch (index)
	{
		case 0: item_id = "shortcut_stumble";   break;
		case 1: item_id = "shortcut_thumbup";   break;
		case 2: item_id = "shortcut_thumbdown"; break;
		case 3: item_id = "shortcut_tag";       break;
		case 4: item_id = "shortcut_reviews";   break;
		case 5: item_id = "shortcut_toolbar";   break;
//		case 5: item_id = "shortcut_details";   break;
//		case 6: item_id = "shortcut_toolbar";   break;
	}
	return su_get_element(item_id);
}

// handles the shortcut disable button command
function handle_shortcut_disable_command()
{
	keyspec = "";
	shortcut_item.setAttribute("keyspec", keyspec);
	shortcut_item.setAttribute("label", "");
	
	refresh_shortcut_preview();

	if (shortcut_item.id == "shortcut_toolbar")
	{
		set_toolbar_position_label("StumbleUpon Toolbar");
	}
}

// handles the shortcut revert button command
function handle_shortcut_revert_command()
{
	keyspec = shortcut_item.getAttribute("keyspec-default");
	shortcut_item.setAttribute("keyspec", keyspec);
	shortcut_item.setAttribute("label", "  " + parent_window.su_get_display_keyspec(keyspec));
	
	refresh_shortcut_preview();

	var item_cur;
	for (var i = 0; i <= 5; i++)
	{
		item_cur = get_shortcut_item_from_index(i);
 		if ((item_cur != shortcut_item) && (item_cur.getAttribute("keyspec") == keyspec))
		{
			item_cur.setAttribute("keyspec", "");
			item_cur.setAttribute("label", "");
			if ((i == TOGGLE_TOOLBAR_LISTITEM_INDEX) && (stumbleupon_toolbar_menuitem != null))
			{
				set_toolbar_position_label("StumbleUpon Toolbar");
			}
		}
	}
}

// handles the shortcut change button command
function handle_shortcut_change_command()
{
	shortcut_item.setAttribute("keyspec", keyspec);
	shortcut_item.setAttribute("label", "  " + parent_window.su_get_display_keyspec(keyspec));

	refresh_shortcut_preview();	
	
	var item_cur;
	for (var i = 0; i <= 4; i++)
	{
		item_cur = get_shortcut_item_from_index(i);
		if ((item_cur != shortcut_item) && (item_cur.getAttribute("keyspec") == keyspec))
		{
			item_cur.setAttribute("keyspec", "");
			item_cur.setAttribute("label", "");
			if (i == TOGGLE_TOOLBAR_LISTITEM_INDEX)
			{
				set_toolbar_position_label("StumbleUpon Toolbar");
			}
		}
	}
	
	if (shortcut_item.id == "shortcut_toolbar")
	{
		set_toolbar_position_label("StumbleUpon Toolbar (" +
					parent_window.su_get_display_keyspec(keyspec) + ")")
	}
}

// used by the shortcut configuration routines to update the 
// StumbleUpon Toolbar menuitem in the toolbar-position popup
function set_toolbar_position_label(label)
{
	if (stumbleupon_toolbar_menuitem != null)
	{
		stumbleupon_toolbar_menuitem.label = label;
		var toolbar_position = su_get_element("toolbar-position");
		if (toolbar_position.selectedItem == stumbleupon_toolbar_menuitem)
		{
			if (stumbleupon_toolbar_menuitem.previousSibling)
			{
				toolbar_position.selectedItem = stumbleupon_toolbar_menuitem.previousSibling;
				toolbar_position.selectedItem = stumbleupon_toolbar_menuitem;
			}
			else if (stumbleupon_toolbar_menuitem.nextSibling)
			{
				toolbar_position.selectedItem = stumbleupon_toolbar_menuitem.nextSibling;
				toolbar_position.selectedItem = stumbleupon_toolbar_menuitem;
			}
		}
	}
}

// handles the keyup event for the shortcuts list
function handle_shortcuts_keyup(event)
{
	if ((event.keyCode == KeyEvent.DOM_VK_UP) ||
				(event.keyCode == KeyEvent.DOM_VK_DOWN))
	{
		return true;
	}
	else
	{
		return handle_shortcut_preview_keyup(event);
	}
}

// handles the keypress event for the shortcuts list
function handle_shortcuts_keypress(event)
{
	return handle_shortcut_preview_keypress(event);
}

// handles the keypress event for the shortcut-preview textbox
function handle_shortcut_preview_keypress(event)
{
  var str = "";

	if (event.altKey)	  str += "Alt+";
	if (event.ctrlKey)  str += "Ctrl+";
	if (event.metaKey)  str += "Command+";
	if (event.shiftKey) str += "Shift+";

	recent_keypress_modifiers = str;

	return true;
}

// handles the keyup event for the shortcut-preview textbox
function handle_shortcut_preview_keyup(event)
{
  if ((event.keyCode == KeyEvent.DOM_VK_TAB) ||
  			(event.keyCode == KeyEvent.DOM_VK_SHIFT) ||
  			(event.keyCode == KeyEvent.DOM_VK_CONTROL) ||
  			(event.keyCode == KeyEvent.DOM_VK_ALT) ||
  			(event.keyCode == KeyEvent.DOM_VK_META) ||
  			(event.keyCode == KeyEvent.DOM_VK_NUM_LOCK) ||
  			(event.keyCode == KeyEvent.DOM_VK_SCROLL_LOCK) ||
  			(event.keyCode == KeyEvent.DOM_VK_CAPS_LOCK))
  {
  	return true;
  }
  event.stopPropagation();
  event.preventDefault();
	
	var keyid;
	if (event.charCode)
	{
		keyid = parent_window.su_keyids_by_eventkeycode[event.charCode];
	}
	else
	{
  	keyid = parent_window.su_keyids_by_eventkeycode[event.keyCode];
	}
	
	keyspec = recent_keypress_modifiers + keyid;
	refresh_shortcut_preview();
	
	return false;
}

// sets button and label state given keyspec being previewed as a
// binding for shortcut_item
function refresh_shortcut_preview()
{
	var shortcut_revert = su_get_element("shortcut_revert");
	var shortcut_disable = su_get_element("shortcut_disable");
	var shortcut_change = su_get_element("shortcut_change");

	if (! shortcut_item)
	{
		if (shortcut_revert.hasAttribute("tooltiptext"))
			shortcut_revert.removeAttribute("tooltiptext");
		
		shortcut_revert.disabled = true;
		shortcut_disable.disabled = true;
		shortcut_change.disabled = true;
		
		su_get_element("shortcut_preview").value = "";
		su_get_element("shortcut_default_behavior").value = "";
		return;
	}

	var keyspec_current = shortcut_item.getAttribute("keyspec");
	var keyspec_default = shortcut_item.getAttribute("keyspec-default");
	
	if (keyspec_current == keyspec_default)
	{
		shortcut_revert.removeAttribute("tooltiptext");
		shortcut_revert.disabled = true;
	}
	else
	{
		shortcut_revert.setAttribute("tooltiptext", 
					"Revert to " + parent_window.su_get_display_keyspec(keyspec_default));
		shortcut_revert.disabled = false;
	}
	
	shortcut_change.disabled = (keyspec_current == keyspec);
	
	shortcut_disable.disabled = (keyspec_current == "");

	su_get_element("shortcut_preview").value = parent_window.su_get_display_keyspec(keyspec);
	su_get_element("shortcut_default_behavior").value = get_default_binding_desc(keyspec);
}

// returns description suitable for user consuption for the target
// of a keybinding
function get_default_binding_desc(spec)
{
	var desc = "";

	if (spec == "")
	{
		return desc;
	}

	if (is_keyspec_accellerated(spec))
	{
		if (typeof parent_window.su_keys_by_keyspec[spec] != "undefined")
		{
			var key = parent_window.su_keys_by_keyspec[spec];
			desc = get_binding_name_from_key(key);
			if (desc == "key_StumbleUpon:ToggleToolbar")
			{
				desc = "";
			}
		}
		else if ((spec.indexOf("Alt") != -1) && 
					(spec.replace(/[\+_]/g, "").search(/\d|\W/) == -1) &&
					(spec.indexOf("VK_BACK_QUOTE") == -1) &&
					(spec != "Alt+VK_SLASH"))
		{
			desc = "[menu accellerator]";
		}
		else if ((! parent_window.su_host.win) &&
					(spec.search(/VK_\d/) != -1))
		{
			desc = "[mode/navigation]";
		}
	}
	else if (is_keyspec_editing(spec))
	{
		desc = "[editing]";
	}
	else
	{
		desc = "[mode/navigation]"
	}
	return desc;
}

function is_keyspec_accellerated(spec)
{
	return (spec.indexOf("Ctrl") != -1) ||
				(spec.indexOf("Alt") != -1) ||
				(spec.indexOf("Command") != -1)
}

function is_keyspec_editing(spec)
{
	if ((spec.indexOf("VK_HOME") != -1) ||
				(spec.indexOf("VK_END") != -1) ||
				(spec.indexOf("VK_INSERT") != -1) ||
				(spec.indexOf("VK_DELETE") != -1))
	{
		return true;
	}
	else if (is_keyspec_accellerated(spec))
	{
		return false;
	}
	else if (spec.indexOf("VK_NUMPAD") != -1)
	{
		return true;
	}
	else
	{
		var parts = spec.split("+");
		return parts[parts.length - 1].length <= 4;
	}
}

// [IP:] [kudos:] The following two functions are from the public 
// domain keyconfig extension by Joe Dorando. -- JW

// searches for a description suitable for user consumption for a
// given key element
function get_binding_name_from_key(aKey)
{
  var val;

  if(aKey.hasAttribute("label")) return aKey.getAttribute("label");

  if(aKey.hasAttribute("command") || aKey.hasAttribute("observes")) {
    var command = aKey.getAttribute("command") || aKey.getAttribute("observes");
    var node = parent_window.su_get_element(command);
    if(node && node.hasAttribute("label")) return node.getAttribute("label");
    val = getLabel("command", command);
    if(!val) val = getLabel("observes", command);
  }

  if(!val) val = getLabel("key", aKey.id);

  if(val) return val;

  var id = aKey.id.replace(/xxx_key.+?_/,"");
	var converter = su_create_instance(
				"@mozilla.org/intl/scriptableunicodeconverter",
				"nsIScriptableUnicodeConverter");
  try {
		id = converter.ConvertToUnicode(id);
	} catch(err) {}

  return id;
}
function getLabel(attr, value) {
  var Users = parent_window.document.getElementsByAttribute(attr,value);
  var User;

  for(var i = 0, l = Users.length; i < l; i++)
    if(Users[i].hasAttribute("label") && (!User || User.localName == "menuitem")) User = Users[i];

  if(!User) return null;

  if(User.localName == "menuitem" && User.parentNode.parentNode.parentNode.localName == "menupopup") {
    return User.getAttribute("label") + " [" + User.parentNode.parentNode.getAttribute("label") + "]";
  } else return User.getAttribute("label");
}


