/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.List;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.FigureTransferCommand;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class CutCommand
extends FigureTransferCommand {
    public CutCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        FigureEnumeration figureEnumeration = this.view().selection();
        List list = CollectionsFactory.current().createList();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            list.add(0, figure);
            FigureEnumeration figureEnumeration2 = figure.getDependendFigures();
            if (figureEnumeration2 == null) continue;
            while (figureEnumeration2.hasNextFigure()) {
                list.add(0, figureEnumeration2.nextFigure());
            }
        }
        figureEnumeration = new FigureEnumerator(list);
        this.getUndoActivity().setAffectedFigures(figureEnumeration);
        UndoActivity undoActivity = (UndoActivity)this.getUndoActivity();
        undoActivity.setSelectedFigures(this.view().selection());
        this.copyFigures(undoActivity.getSelectedFigures(), undoActivity.getSelectedFiguresCount());
        this.deleteFigures(this.getUndoActivity().getAffectedFigures());
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private FigureTransferCommand myCommand;
        private List mySelectedFigures;

        public UndoActivity(FigureTransferCommand figureTransferCommand) {
            super(figureTransferCommand.view());
            this.myCommand = figureTransferCommand;
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (super.undo() && this.getAffectedFigures().hasNextFigure()) {
                this.getDrawingView().clearSelection();
                this.myCommand.insertFigures(this.getAffectedFiguresReversed(), 0, 0);
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.myCommand.copyFigures(this.getSelectedFigures(), this.getSelectedFiguresCount());
                this.myCommand.deleteFigures(this.getAffectedFigures());
                return true;
            }
            return false;
        }

        public void setSelectedFigures(FigureEnumeration figureEnumeration) {
            this.rememberSelectedFigures(figureEnumeration);
        }

        protected void rememberSelectedFigures(FigureEnumeration figureEnumeration) {
            this.mySelectedFigures = CollectionsFactory.current().createList();
            while (figureEnumeration.hasNextFigure()) {
                this.mySelectedFigures.add(figureEnumeration.nextFigure());
            }
        }

        public FigureEnumeration getSelectedFigures() {
            return new FigureEnumerator(CollectionsFactory.current().createList(this.mySelectedFigures));
        }

        public int getSelectedFiguresCount() {
            return this.mySelectedFigures.size();
        }

        public void release() {
            super.release();
            FigureEnumeration figureEnumeration = this.getSelectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                figureEnumeration.nextFigure().release();
            }
            this.setSelectedFigures(FigureEnumerator.getEmptyEnumeration());
        }
    }
}

