/*
 * Copyright (C) 2008, 2009 Free Software Foundation
 * Written by Eric Blake and Bruno Haible
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <config.h>

#include <string.h>

#include <stdio.h>
#include <stdlib.h>

#define ASSERT(expr) \
  do                                                                         \
    {                                                                        \
      if (!(expr))                                                           \
        {                                                                    \
          fprintf (stderr, "%s:%d: assertion failed\n", __FILE__, __LINE__); \
          fflush (stderr);                                                   \
          abort ();                                                          \
        }                                                                    \
    }                                                                        \
  while (0)

/* Calculating void * + int is not portable, so this wrapper converts
   to char * to make the tests easier to write.  */
#define RAWMEMCHR (char *) rawmemchr

int
main (void)
{
  size_t n = 0x100000;
  char *input = malloc (n + 1);
  ASSERT (input);

  input[0] = 'a';
  input[1] = 'b';
  memset (input + 2, 'c', 1024);
  memset (input + 1026, 'd', n - 1028);
  input[n - 2] = 'e';
  input[n - 1] = 'a';
  input[n] = '\0';

  /* Basic behavior tests.  */
  ASSERT (RAWMEMCHR (input, 'a') == input);
  ASSERT (RAWMEMCHR (input, 'b') == input + 1);
  ASSERT (RAWMEMCHR (input, 'c') == input + 2);
  ASSERT (RAWMEMCHR (input, 'd') == input + 1026);

  ASSERT (RAWMEMCHR (input + 1, 'a') == input + n - 1);
  ASSERT (RAWMEMCHR (input + 1, 'e') == input + n - 2);

  ASSERT (RAWMEMCHR (input, '\0') == input + n);

  /* Alignment tests.  */
  {
    int i, j;
    for (i = 0; i < 32; i++)
      {
        for (j = 0; j < 256; j++)
          input[i + j] = j;
        for (j = 0; j < 256; j++)
          {
            ASSERT (RAWMEMCHR (input + i, j) == input + i + j);
          }
      }
  }

  free (input);

  return 0;
}
