#!/usr/bin/env python

import re
import glob
import sys

path = str(sys.argv[1])

if len(sys.argv) != 3:
    print 'usage: python post.py directory versionNumber'
    sys.exit(1)

heading1 = re.compile(r'(<!-- Generated by Doxygen [0-9\.]+ -->\n)<h1>([^<]+)\s*</h1>')
heading1a = re.compile(r'(<!-- Generated by Doxygen [0-9\.]+ -->\n)<h1>(<a name[^<]+</a>)\n</h1>')
heading2 = re.compile(r'(<!-- Generated by Doxygen [0-9\.]+ -->\n)<a name[^>]*><h2>([^<]+)</h2></a>')
heading3 = re.compile(r'(<!-- Generated by Doxygen [0-9\.]+ -->\n)<h1>([^<]+)<br>\n<small>\n\[[^\]]*\]</small>\n</h1>')
headingReplacement = r'''\1<table border=0 cellspacing=0 bgcolor="#e0d0a0" width="100%" cellpadding=5>
<tr>
<th align=left valign=top>
<A HREF ="#_details" ><IMG BORDER=0 ALT="details" SRC="documents/pfeilGross.gif"></A>
</th>
<th><font size="+2">\2
</font></th>
<th align=right ><a href="http://kogs-www.informatik.uni-hamburg.de/~koethe/vigra/"><IMG border=0 ALT="VIGRA" SRC="documents/vigra.gif"></a></th></tr>
</table><p>'''

def convertHeader(text):
    text = heading1.sub(headingReplacement, text)
    text = heading1a.sub(headingReplacement, text)
    text = heading2.sub(headingReplacement, text)
    text = heading3.sub(headingReplacement, text)
    return text

def makeBlindTable(color):
    return r'<table border=0 cellpadding=5 width="100%" bgcolor=' + \
           color + r'><tr><td><br>\1</td></tr></table><br>'

inheritanceDiagram = re.compile(r'<p>Inheritance diagram for ')
coordinates = re.compile(r'<area [^>]*coords="0,0')

def hasBaseClass(text):
    result = inheritanceDiagram.search(text)
    if not result:
        return 0
    result = coordinates.search(text)
    if not result:
        return 0
    return 1

detailsHeading = re.compile(r'<hr><a name="_details"></a>(<h2>Detailed Description</h2>)')
includePath = re.compile(r'#include &lt;(<a class="el" href="[^"]+">)([^<]+)</a>&gt;')
uselessAnchor = re.compile(r'(?P<id>[a-zA-Z_][^/]*)\.html#(?P=id)"')
memberHeading = re.compile(r'class="md"')
tableHeadingWorkaround1 = re.compile(r'<td>(\s*<th|\s*<td)')
tableHeadingWorkaround2 = re.compile(r'(</th>\s*|</td>\s*)</td>')
insertVersion = re.compile(r'VERSION_VERSION_VERSION')
insertSTLLink = re.compile(r'WWW_STL_DOCU')
renameHeading = re.compile(r'Compounds')
listOfAllMembers = re.compile(r'<a href=".*?">List of all members.</a>')

def convertPage(text):
#    text = re.sub(r'(?s)<div class="fragment">(.*?)</div>', r'<div class="fragment">' + makeBlindTable("#f0e0c0"), text)
#    text = re.sub(r'<td><div class="ah">', r'<td bgcolor="#000000"><div class="ah">', text)
    text = detailsHeading.sub(r'<a name="_details"><br></a>' + makeBlindTable("#e0d0a0"), text)
    text = includePath.sub(r'#include "\1vigra/\2</a>"', text)
    text = uselessAnchor.sub(r'\g<id>.html"', text)
    text = memberHeading.sub(r'class="md" bgcolor="#f0e0c0"', text)
    text = tableHeadingWorkaround1.sub(r'\1', text)
    text = tableHeadingWorkaround2.sub(r'\1', text)
    text = insertVersion.sub(sys.argv[2], text)
    text = insertSTLLink.sub(r'http://www.sgi.com/tech/stl/', text)
    text = renameHeading.sub(r'Classes', text)
    if listOfAllMembers.search(text) and not hasBaseClass(text):
        text = listOfAllMembers.sub('', text)
    return text

divBegin = re.compile(r'<div class="fragment">')
divEnd = re.compile(r'</div>')

def convertSource(text):
    text = divBegin.sub('', text)
    text = divEnd.sub('', text)
    return text
    
def getFunctionList(text):
    result = re.search(r'<tr><td colspan=2><br><h2>Functions</h2></td></tr>', text)
    text = text[result.regs[0][0]:]
    return re.findall(r'<td valign=bottom><a class="el" href="([^"]+)">([^<]+)</a>', text)
    
    
def generateFunctionIndex():
    f = open(path + "/namespacevigra.html")
    text = f.read()
    f.close()

    functionList = getFunctionList(text)

    for k in ['srcImageRange', 'srcImage', 'destImageRange', 'destImage', 'maskImage']:
        functionList.append(('group__ImageIterators.html#ImageBasedArgumentObjectFactories', k))
    for k in ['srcMultiArrayRange', 'srcMultiArray', 'destMultiArrayRange', 'destMultiArray']:
        functionList.append(('group__ImageIterators.html#MultiArrayBasedArgumentObjectFactories', k))
    for k in ['srcIterRange', 'srcIter', 'destIterRange', 'destIter', 'maskIter']:
        functionList.append(('group__ImageIterators.html#IteratorBasedArgumentObjectFactories', k))

    functionList.sort(lambda a,b: cmp(a[1], b[1]))

    index = ""
    initials = []
    for i in range(len(functionList)):
        overloaded = None
        functionName = functionList[i][1]
        link = functionList[i][0]
        initial = functionName[0]
        if i > 0:
            lastInitial = functionList[i-1][1][0]
            if initial != lastInitial:
                initials.append(initial)
                index = index + '<a name="index_' + initial + '"><h3>- ' + initial + ' -</h3></a>\n'

            lastFunctionName = functionList[i-1][1]
            if functionName == lastFunctionName:
                overloaded = 1

        if i < len(functionList) - 1:
            nextFunctionName = functionList[i+1][1]
            if functionName == nextFunctionName:
                overloaded = 1

        index = index + '<a href="'+ link + '">' + functionName + '</a>()'
        if overloaded:
            group = re.sub(r'group__([^\.]+)\.html.*', r'\1', link)
            index = index + ' [' + group + ']'
        index = index + '<br>\n'

    f = open(path + "/functions.html")
    text = f.read()
    f.close()

    header = re.match(r'(?s)(.*)\n<a href="#index', text).group(1)
    footer = re.search(r'(?s)(<!-- footer.html -->.*)', text).group(1)

    text = re.sub(r'Compound\s(Member\sIndex|Members)', r'Function Index', header)
    for i in range(len(initials)):
        initial = initials[i]
        if i != 0:
            text = text + ' | '
        text = text + '<a href="#index_' + initial + '">' + initial + '</a>'
    text = text + '</center>\n<p>\n'
    text = text + index
    text = text + footer

    f = open(path + "/functionindex.html", 'w+')
    f.write(text)
    f.close()

typedefField = re.compile(r'<table cellpadding="0" cellspacing="0" border="0">\s*'+\
                    r'<tr>\s*<td class="md".*?>(.*?)\n\s*</table>')

def findExplicitDeclarations(text):
    decl = {}
    t = text
    while len(t):
        m = re.search(r'Declarations?:[^\(]*?(\s*<a class="code"[^>]*>|\s*)([a-zA-Z_][a-zA-Z_0-9]*)(</a>| *)\(', t)
        if not m: break
        decl[m.groups()[1]] = 1
        t = t[m.end():]
    t = ""
    for i in decl.keys():
        t = t + i + "|"
    if t:
        return "(" + t[:-1] + ")"
    else:
        return None

functionSignature2 = re.compile(r'(<td class="md"[^>]*>)'+\
                               r'([^<]*| <a[^<]*</a>[^<]*)</td>')
functionSignature3 = re.compile(r'(<td class="md"[^>]*>)([^<]*)</table>')

functionHeading = re.compile(r'(<td class="md" bgcolor="#f0e0c0">)(\s*'+\
            r'<table cellpadding="0" cellspacing="0" border="0">.*?</table>)', re.S)

def processFile(fileName):
    print fileName          # log message
    f = open(fileName)
    text = f.read()
    f.close()
    
    text = convertHeader(text)   # page header processing
    if not re.search(r'.*source.html', fileName):
        text = convertPage(text)   # normal page processing
    else:
        text = convertSource(text) # source code page processing
    if re.search(r'.*/group__.*html', fileName):
        text = typedefField.sub(r'<br><b>&nbsp;\1</b><br>&nbsp;', text)
        declPattern = findExplicitDeclarations(text)  # is the declaration hardcoded in the docu?
        if declPattern:
            # replace the signature in the header with (...) if the signature
            # is given explicitly later
            text = re.sub(r'(<td nowrap align=right valign=top>template&lt;).*?(&gt;.*?)'+declPattern+\
                          r'(.*?</tr>)', r'\1...\2\3\4', text)
            functionSignature1 = re.compile(r'<table cellpadding="0" cellspacing="0" border="0">\s*'+\
                     r'<tr>\s*<td class="md"[^>]*>([^<]*?)'+declPattern+r' *</td>.*?</table>', re.S)
            text = functionSignature1.sub(r'<br><b>&nbsp;\1\2 (...)</b><br>&nbsp;', text)

    # make function signatures bold if they haven't been processed yet
    text = functionHeading.sub(r'\1<br>\2</br>', text)
    text = functionSignature2.sub(r'\1<b>\2</b></td>', text)
    text = functionSignature3.sub(r'\1<b>\2</b></td></table>', text)
    
    if re.search(r'.*/index.html', fileName):
        text = re.sub(r'<h3 align="center">\d+\.\d+\.\d+</h3>', '', text)
    if re.search(r'.*/namespacevigra.html', fileName):
        text = re.sub(r"template&lt;.*?&gt;", "template&lt;...&gt;", text)
    if re.search(r'.*/classes.html', fileName):
        text = re.sub(r'(<div class="ah">)(&nbsp;&nbsp;.&nbsp;&nbsp;)', r'\1<font color="white"><b>\2</b>', text)
        text = re.sub(r'\(<a class="el" href="namespace[^\)]*\)', '', text)
    f = open(fileName, 'w+')
    f.write(text)
    f.close()
    

files = glob.glob(path + '/*.html')  # use absolute path to files
#files = glob.glob(str(sys.argv[1]) + '/ImageIterator.html')
#files = glob.glob('../doc/*.html')

for file in files:
   processFile(file)

generateFunctionIndex()
