/* unity-scope-interface.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-scope-interface.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "unity.h"
#include <gio/gio.h>


#define UNITY_TYPE_SCOPE_INFO (unity_scope_info_get_type ())
typedef struct _UnityScopeInfo UnityScopeInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_SCOPE_SERVICE (unity_scope_service_get_type ())
#define UNITY_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeService))
#define UNITY_IS_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_SERVICE))
#define UNITY_SCOPE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeServiceIface))

typedef struct _UnityScopeService UnityScopeService;
typedef struct _UnityScopeServiceIface UnityScopeServiceIface;

#define UNITY_TYPE_SCOPE_SERVICE_PROXY (unity_scope_service_proxy_get_type ())
typedef GDBusProxy UnityScopeServiceProxy;
typedef GDBusProxyClass UnityScopeServiceProxyClass;

struct _UnityScopeInfo {
	gchar* dbus_path;
	GVariant* sources;
	gboolean search_in_global;
	gchar* private_connection_name;
	gchar* results_model_name;
	gchar* global_results_model_name;
	gchar* filters_model_name;
	GHashTable* hints;
};

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityScopeServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*set_view_type) (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_view_type_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*set_active_sources) (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
};



GType unity_scope_info_get_type (void) G_GNUC_CONST;
UnityScopeInfo* unity_scope_info_dup (const UnityScopeInfo* self);
void unity_scope_info_free (UnityScopeInfo* self);
void unity_scope_info_copy (const UnityScopeInfo* self, UnityScopeInfo* dest);
void unity_scope_info_destroy (UnityScopeInfo* self);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_scope_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_scope_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_scope_service_get_type (void) G_GNUC_CONST;
void unity_scope_service_info_request (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
void unity_scope_service_activate (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
void unity_scope_service_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_service_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
void unity_scope_service_global_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_service_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
void unity_scope_service_preview (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
void unity_scope_service_set_view_type (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_set_view_type_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
void unity_scope_service_set_active_sources (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_scope_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_unity_scope_service_changed (UnityScopeService* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void unity_scope_service_proxy_info_request_async (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_activate_async (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
static void unity_scope_service_proxy_search_async (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GHashTable* unity_scope_service_proxy_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_global_search_async (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GHashTable* unity_scope_service_proxy_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_preview_async (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
static void unity_scope_service_proxy_set_view_type_async (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_set_view_type_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_set_active_sources_async (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_service_proxy_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_service_proxy_unity_scope_service_interface_init (UnityScopeServiceIface* iface);
static void _dbus_unity_scope_service_info_request (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_info_request_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_activate (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_activate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_search (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_global_search (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_global_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_preview (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_preview_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_set_view_type (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_set_view_type_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_scope_service_set_active_sources (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_scope_service_set_active_sources_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void unity_scope_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_scope_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_scope_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_unity_scope_service_changed (GObject* _sender, UnityScopeInfo* lens_info, gpointer* _data);
static void _unity_scope_service_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusErrorEntry unity_scope_error_entries[] = {{UNITY_SCOPE_ERROR_SEARCH_CANCELLED, "com.canonical.Unity.ScopeError.SearchCancelled"}, {UNITY_SCOPE_ERROR_UNKNOWN, "com.canonical.Unity.ScopeError.Unknown"}};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_info_request_in[] = {NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_info_request_out[] = {NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_info_request = {-1, "InfoRequest", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_info_request_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_info_request_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_activate_uri = {-1, "uri", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_activate_action_type = {-1, "action_type", "u"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_activate_result = {-1, "result", "(sua{sv})"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_activate_in[] = {&_unity_scope_service_dbus_arg_info_activate_uri, &_unity_scope_service_dbus_arg_info_activate_action_type, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_activate_out[] = {&_unity_scope_service_dbus_arg_info_activate_result, NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_activate = {-1, "Activate", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_activate_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_activate_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_search_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_search_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_search_result = {-1, "result", "a{sv}"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_search_in[] = {&_unity_scope_service_dbus_arg_info_search_search_string, &_unity_scope_service_dbus_arg_info_search_hints, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_search_out[] = {&_unity_scope_service_dbus_arg_info_search_result, NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_search = {-1, "Search", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_search_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_search_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_global_search_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_global_search_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_global_search_result = {-1, "result", "a{sv}"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_global_search_in[] = {&_unity_scope_service_dbus_arg_info_global_search_search_string, &_unity_scope_service_dbus_arg_info_global_search_hints, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_global_search_out[] = {&_unity_scope_service_dbus_arg_info_global_search_result, NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_global_search = {-1, "GlobalSearch", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_global_search_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_global_search_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_preview_uri = {-1, "uri", "s"};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_preview_result = {-1, "result", "(ssa{sv})"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_preview_in[] = {&_unity_scope_service_dbus_arg_info_preview_uri, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_preview_out[] = {&_unity_scope_service_dbus_arg_info_preview_result, NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_preview = {-1, "Preview", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_preview_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_preview_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_set_view_type_view_type = {-1, "view_type", "u"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_set_view_type_in[] = {&_unity_scope_service_dbus_arg_info_set_view_type_view_type, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_set_view_type_out[] = {NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_set_view_type = {-1, "SetViewType", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_set_view_type_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_set_view_type_out)};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_set_active_sources_sources = {-1, "sources", "as"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_set_active_sources_in[] = {&_unity_scope_service_dbus_arg_info_set_active_sources_sources, NULL};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_set_active_sources_out[] = {NULL};
static const GDBusMethodInfo _unity_scope_service_dbus_method_info_set_active_sources = {-1, "SetActiveSources", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_set_active_sources_in), (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_set_active_sources_out)};
static const GDBusMethodInfo * const _unity_scope_service_dbus_method_info[] = {&_unity_scope_service_dbus_method_info_info_request, &_unity_scope_service_dbus_method_info_activate, &_unity_scope_service_dbus_method_info_search, &_unity_scope_service_dbus_method_info_global_search, &_unity_scope_service_dbus_method_info_preview, &_unity_scope_service_dbus_method_info_set_view_type, &_unity_scope_service_dbus_method_info_set_active_sources, NULL};
static const GDBusArgInfo _unity_scope_service_dbus_arg_info_changed_lens_info = {-1, "lens_info", "(svbssssa{sv})"};
static const GDBusArgInfo * const _unity_scope_service_dbus_arg_info_changed[] = {&_unity_scope_service_dbus_arg_info_changed_lens_info, NULL};
static const GDBusSignalInfo _unity_scope_service_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_unity_scope_service_dbus_arg_info_changed)};
static const GDBusSignalInfo * const _unity_scope_service_dbus_signal_info[] = {&_unity_scope_service_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo * const _unity_scope_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_scope_service_dbus_interface_info = {-1, "com.canonical.Unity.Scope", (GDBusMethodInfo **) (&_unity_scope_service_dbus_method_info), (GDBusSignalInfo **) (&_unity_scope_service_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_scope_service_dbus_property_info)};
static const GDBusInterfaceVTable _unity_scope_service_dbus_interface_vtable = {unity_scope_service_dbus_interface_method_call, unity_scope_service_dbus_interface_get_property, unity_scope_service_dbus_interface_set_property};

static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void unity_scope_info_copy (const UnityScopeInfo* self, UnityScopeInfo* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* _tmp14_;
	_tmp0_ = (*self).dbus_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).dbus_path);
	(*dest).dbus_path = _tmp1_;
	_tmp2_ = (*self).sources;
	_tmp3_ = _g_variant_ref0 (_tmp2_);
	_g_variant_unref0 ((*dest).sources);
	(*dest).sources = _tmp3_;
	_tmp4_ = (*self).search_in_global;
	(*dest).search_in_global = _tmp4_;
	_tmp5_ = (*self).private_connection_name;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).private_connection_name);
	(*dest).private_connection_name = _tmp6_;
	_tmp7_ = (*self).results_model_name;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*dest).results_model_name);
	(*dest).results_model_name = _tmp8_;
	_tmp9_ = (*self).global_results_model_name;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 ((*dest).global_results_model_name);
	(*dest).global_results_model_name = _tmp10_;
	_tmp11_ = (*self).filters_model_name;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 ((*dest).filters_model_name);
	(*dest).filters_model_name = _tmp12_;
	_tmp13_ = (*self).hints;
	_tmp14_ = _g_hash_table_ref0 (_tmp13_);
	_g_hash_table_unref0 ((*dest).hints);
	(*dest).hints = _tmp14_;
}


void unity_scope_info_destroy (UnityScopeInfo* self) {
	_g_free0 ((*self).dbus_path);
	_g_variant_unref0 ((*self).sources);
	_g_free0 ((*self).private_connection_name);
	_g_free0 ((*self).results_model_name);
	_g_free0 ((*self).global_results_model_name);
	_g_free0 ((*self).filters_model_name);
	_g_hash_table_unref0 ((*self).hints);
}


UnityScopeInfo* unity_scope_info_dup (const UnityScopeInfo* self) {
	UnityScopeInfo* dup;
	dup = g_new0 (UnityScopeInfo, 1);
	unity_scope_info_copy (self, dup);
	return dup;
}


void unity_scope_info_free (UnityScopeInfo* self) {
	unity_scope_info_destroy (self);
	g_free (self);
}


GType unity_scope_info_get_type (void) {
	static volatile gsize unity_scope_info_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_info_type_id__volatile)) {
		GType unity_scope_info_type_id;
		unity_scope_info_type_id = g_boxed_type_register_static ("UnityScopeInfo", (GBoxedCopyFunc) unity_scope_info_dup, (GBoxedFreeFunc) unity_scope_info_free);
		g_once_init_leave (&unity_scope_info_type_id__volatile, unity_scope_info_type_id);
	}
	return unity_scope_info_type_id__volatile;
}


void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	guint _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	_tmp0_ = (*self).uri;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).uri);
	(*dest).uri = _tmp1_;
	_tmp2_ = (*self).handled;
	(*dest).handled = _tmp2_;
	_tmp3_ = (*self).hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_g_hash_table_unref0 ((*dest).hints);
	(*dest).hints = _tmp4_;
}


void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self) {
	_g_free0 ((*self).uri);
	_g_hash_table_unref0 ((*self).hints);
}


UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self) {
	UnityActivationReplyRaw* dup;
	dup = g_new0 (UnityActivationReplyRaw, 1);
	unity_activation_reply_raw_copy (self, dup);
	return dup;
}


void unity_activation_reply_raw_free (UnityActivationReplyRaw* self) {
	unity_activation_reply_raw_destroy (self);
	g_free (self);
}


GType unity_activation_reply_raw_get_type (void) {
	static volatile gsize unity_activation_reply_raw_type_id__volatile = 0;
	if (g_once_init_enter (&unity_activation_reply_raw_type_id__volatile)) {
		GType unity_activation_reply_raw_type_id;
		unity_activation_reply_raw_type_id = g_boxed_type_register_static ("UnityActivationReplyRaw", (GBoxedCopyFunc) unity_activation_reply_raw_dup, (GBoxedFreeFunc) unity_activation_reply_raw_free);
		g_once_init_leave (&unity_activation_reply_raw_type_id__volatile, unity_activation_reply_raw_type_id);
	}
	return unity_activation_reply_raw_type_id__volatile;
}


void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	_tmp0_ = (*self).uri;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).uri);
	(*dest).uri = _tmp1_;
	_tmp2_ = (*self).renderer_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).renderer_name);
	(*dest).renderer_name = _tmp3_;
	_tmp4_ = (*self).properties;
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp5_;
}


void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self) {
	_g_free0 ((*self).uri);
	_g_free0 ((*self).renderer_name);
	_g_hash_table_unref0 ((*self).properties);
}


UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self) {
	UnityPreviewReplyRaw* dup;
	dup = g_new0 (UnityPreviewReplyRaw, 1);
	unity_preview_reply_raw_copy (self, dup);
	return dup;
}


void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self) {
	unity_preview_reply_raw_destroy (self);
	g_free (self);
}


GType unity_preview_reply_raw_get_type (void) {
	static volatile gsize unity_preview_reply_raw_type_id__volatile = 0;
	if (g_once_init_enter (&unity_preview_reply_raw_type_id__volatile)) {
		GType unity_preview_reply_raw_type_id;
		unity_preview_reply_raw_type_id = g_boxed_type_register_static ("UnityPreviewReplyRaw", (GBoxedCopyFunc) unity_preview_reply_raw_dup, (GBoxedFreeFunc) unity_preview_reply_raw_free);
		g_once_init_leave (&unity_preview_reply_raw_type_id__volatile, unity_preview_reply_raw_type_id);
	}
	return unity_preview_reply_raw_type_id__volatile;
}


GQuark unity_scope_error_quark (void) {
	static volatile gsize unity_scope_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("unity_scope_error-quark", &unity_scope_error_quark_volatile, unity_scope_error_entries, G_N_ELEMENTS (unity_scope_error_entries));
	return (GQuark) unity_scope_error_quark_volatile;
}


void unity_scope_service_info_request (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->info_request (self, _callback_, _user_data_);
}


void unity_scope_service_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->info_request_finish (self, _res_, error);
}


void unity_scope_service_activate (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->activate (self, uri, action_type, _callback_, _user_data_);
}


void unity_scope_service_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->activate_finish (self, _res_, result, error);
}


void unity_scope_service_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->search (self, search_string, hints, _callback_, _user_data_);
}


GHashTable* unity_scope_service_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	return UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->search_finish (self, _res_, error);
}


void unity_scope_service_global_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->global_search (self, search_string, hints, _callback_, _user_data_);
}


GHashTable* unity_scope_service_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	return UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->global_search_finish (self, _res_, error);
}


void unity_scope_service_preview (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->preview (self, uri, _callback_, _user_data_);
}


void unity_scope_service_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->preview_finish (self, _res_, result, error);
}


void unity_scope_service_set_view_type (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->set_view_type (self, view_type, _callback_, _user_data_);
}


void unity_scope_service_set_view_type_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->set_view_type_finish (self, _res_, error);
}


void unity_scope_service_set_active_sources (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->set_active_sources (self, sources, sources_length1, _callback_, _user_data_);
}


void unity_scope_service_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	UNITY_SCOPE_SERVICE_GET_INTERFACE (self)->set_active_sources_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static void unity_scope_service_base_init (UnityScopeServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", UNITY_TYPE_SCOPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_TYPE_SCOPE_INFO);
	}
}


/**
 * ScopeService:
 *
 * The Scope interface exported on DBus
 */
GType unity_scope_service_get_type (void) {
	static volatile gsize unity_scope_service_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeServiceIface), (GBaseInitFunc) unity_scope_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_scope_service_type_id;
		unity_scope_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityScopeService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_scope_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_scope_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) unity_scope_service_proxy_get_type);
		g_type_set_qdata (unity_scope_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.Unity.Scope");
		g_type_set_qdata (unity_scope_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_scope_service_register_object);
		g_once_init_leave (&unity_scope_service_type_id__volatile, unity_scope_service_type_id);
	}
	return unity_scope_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityScopeServiceProxy, unity_scope_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_TYPE_SCOPE_SERVICE, unity_scope_service_proxy_unity_scope_service_interface_init) )
static void unity_scope_service_proxy_class_init (UnityScopeServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = unity_scope_service_proxy_g_signal;
}


static void _dbus_handle_unity_scope_service_changed (UnityScopeService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	UnityScopeInfo lens_info = {0};
	GVariant* _tmp112_;
	UnityScopeInfo _tmp113_;
	GVariantIter _tmp114_;
	GVariant* _tmp115_;
	GVariant* _tmp116_;
	GVariant* _tmp117_;
	GVariant* _tmp118_;
	GVariant* _tmp119_;
	GVariant* _tmp120_;
	GVariant* _tmp121_;
	GVariant* _tmp122_;
	GHashTable* _tmp123_;
	GVariantIter _tmp124_;
	GVariant* _tmp125_;
	GVariant* _tmp126_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp112_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp114_, _tmp112_);
	_tmp115_ = g_variant_iter_next_value (&_tmp114_);
	_tmp113_.dbus_path = g_variant_dup_string (_tmp115_, NULL);
	g_variant_unref (_tmp115_);
	_tmp116_ = g_variant_iter_next_value (&_tmp114_);
	_tmp113_.sources = g_variant_get_variant (_tmp116_);
	g_variant_unref (_tmp116_);
	_tmp117_ = g_variant_iter_next_value (&_tmp114_);
	_tmp113_.search_in_global = g_variant_get_boolean (_tmp117_);
	g_variant_unref (_tmp117_);
	_tmp118_ = g_variant_iter_next_value (&_tmp114_);
	_tmp113_.private_connection_name = g_variant_dup_string (_tmp118_, NULL);
	g_variant_unref (_tmp118_);
	_tmp119_ = g_variant_iter_next_value (&_tmp114_);
	_tmp113_.results_model_name = g_variant_dup_string (_tmp119_, NULL);
	g_variant_unref (_tmp119_);
	_tmp120_ = g_variant_iter_next_value (&_tmp114_);
	_tmp113_.global_results_model_name = g_variant_dup_string (_tmp120_, NULL);
	g_variant_unref (_tmp120_);
	_tmp121_ = g_variant_iter_next_value (&_tmp114_);
	_tmp113_.filters_model_name = g_variant_dup_string (_tmp121_, NULL);
	g_variant_unref (_tmp121_);
	_tmp122_ = g_variant_iter_next_value (&_tmp114_);
	_tmp123_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp124_, _tmp122_);
	while (g_variant_iter_loop (&_tmp124_, "{?*}", &_tmp125_, &_tmp126_)) {
		g_hash_table_insert (_tmp123_, g_variant_dup_string (_tmp125_, NULL), g_variant_get_variant (_tmp126_));
	}
	_tmp113_.hints = _tmp123_;
	g_variant_unref (_tmp122_);
	lens_info = _tmp113_;
	g_variant_unref (_tmp112_);
	g_signal_emit_by_name (self, "changed", &lens_info);
	unity_scope_info_destroy (&lens_info);
}


static void unity_scope_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_unity_scope_service_changed ((UnityScopeService*) proxy, parameters);
	}
}


static void unity_scope_service_proxy_init (UnityScopeServiceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void unity_scope_service_proxy_info_request_async (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "InfoRequest");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_activate_async (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "Activate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (action_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _tmp127_;
	UnityActivationReplyRaw _tmp128_;
	GVariantIter _tmp129_;
	GVariant* _tmp130_;
	GVariant* _tmp131_;
	GVariant* _tmp132_;
	GHashTable* _tmp133_;
	GVariantIter _tmp134_;
	GVariant* _tmp135_;
	GVariant* _tmp136_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp127_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp129_, _tmp127_);
	_tmp130_ = g_variant_iter_next_value (&_tmp129_);
	_tmp128_.uri = g_variant_dup_string (_tmp130_, NULL);
	g_variant_unref (_tmp130_);
	_tmp131_ = g_variant_iter_next_value (&_tmp129_);
	_tmp128_.handled = g_variant_get_uint32 (_tmp131_);
	g_variant_unref (_tmp131_);
	_tmp132_ = g_variant_iter_next_value (&_tmp129_);
	_tmp133_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp134_, _tmp132_);
	while (g_variant_iter_loop (&_tmp134_, "{?*}", &_tmp135_, &_tmp136_)) {
		g_hash_table_insert (_tmp133_, g_variant_dup_string (_tmp135_, NULL), g_variant_get_variant (_tmp136_));
	}
	_tmp128_.hints = _tmp133_;
	g_variant_unref (_tmp132_);
	*result = _tmp128_;
	g_variant_unref (_tmp127_);
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_search_async (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp137_;
	GHashTableIter _tmp138_;
	gpointer _tmp139_;
	gpointer _tmp140_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "Search");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp138_, hints);
	g_variant_builder_init (&_tmp137_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp138_, &_tmp139_, &_tmp140_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp139_;
		_value = (GVariant*) _tmp140_;
		g_variant_builder_add (&_tmp137_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp137_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static GHashTable* unity_scope_service_proxy_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable* _result;
	GVariant* _tmp141_;
	GHashTable* _tmp142_;
	GVariantIter _tmp143_;
	GVariant* _tmp144_;
	GVariant* _tmp145_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp141_ = g_variant_iter_next_value (&_reply_iter);
	_tmp142_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp143_, _tmp141_);
	while (g_variant_iter_loop (&_tmp143_, "{?*}", &_tmp144_, &_tmp145_)) {
		g_hash_table_insert (_tmp142_, g_variant_dup_string (_tmp144_, NULL), g_variant_get_variant (_tmp145_));
	}
	_result = _tmp142_;
	g_variant_unref (_tmp141_);
	g_object_unref (_reply_message);
	return _result;
}


static void unity_scope_service_proxy_global_search_async (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp146_;
	GHashTableIter _tmp147_;
	gpointer _tmp148_;
	gpointer _tmp149_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "GlobalSearch");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp147_, hints);
	g_variant_builder_init (&_tmp146_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp147_, &_tmp148_, &_tmp149_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp148_;
		_value = (GVariant*) _tmp149_;
		g_variant_builder_add (&_tmp146_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp146_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static GHashTable* unity_scope_service_proxy_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable* _result;
	GVariant* _tmp150_;
	GHashTable* _tmp151_;
	GVariantIter _tmp152_;
	GVariant* _tmp153_;
	GVariant* _tmp154_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp150_ = g_variant_iter_next_value (&_reply_iter);
	_tmp151_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp152_, _tmp150_);
	while (g_variant_iter_loop (&_tmp152_, "{?*}", &_tmp153_, &_tmp154_)) {
		g_hash_table_insert (_tmp151_, g_variant_dup_string (_tmp153_, NULL), g_variant_get_variant (_tmp154_));
	}
	_result = _tmp151_;
	g_variant_unref (_tmp150_);
	g_object_unref (_reply_message);
	return _result;
}


static void unity_scope_service_proxy_preview_async (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "Preview");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _tmp155_;
	UnityPreviewReplyRaw _tmp156_;
	GVariantIter _tmp157_;
	GVariant* _tmp158_;
	GVariant* _tmp159_;
	GVariant* _tmp160_;
	GHashTable* _tmp161_;
	GVariantIter _tmp162_;
	GVariant* _tmp163_;
	GVariant* _tmp164_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp155_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp157_, _tmp155_);
	_tmp158_ = g_variant_iter_next_value (&_tmp157_);
	_tmp156_.uri = g_variant_dup_string (_tmp158_, NULL);
	g_variant_unref (_tmp158_);
	_tmp159_ = g_variant_iter_next_value (&_tmp157_);
	_tmp156_.renderer_name = g_variant_dup_string (_tmp159_, NULL);
	g_variant_unref (_tmp159_);
	_tmp160_ = g_variant_iter_next_value (&_tmp157_);
	_tmp161_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp162_, _tmp160_);
	while (g_variant_iter_loop (&_tmp162_, "{?*}", &_tmp163_, &_tmp164_)) {
		g_hash_table_insert (_tmp161_, g_variant_dup_string (_tmp163_, NULL), g_variant_get_variant (_tmp164_));
	}
	_tmp156_.properties = _tmp161_;
	g_variant_unref (_tmp160_);
	*result = _tmp156_;
	g_variant_unref (_tmp155_);
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_set_view_type_async (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "SetViewType");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (view_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_set_view_type_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_set_active_sources_async (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp165_;
	GVariantBuilder _tmp166_;
	int _tmp167_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Scope", "SetActiveSources");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp165_ = sources;
	g_variant_builder_init (&_tmp166_, G_VARIANT_TYPE ("as"));
	for (_tmp167_ = 0; _tmp167_ < sources_length1; _tmp167_++) {
		g_variant_builder_add_value (&_tmp166_, g_variant_new_string (*_tmp165_));
		_tmp165_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp166_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_scope_service_proxy_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_scope_service_proxy_unity_scope_service_interface_init (UnityScopeServiceIface* iface) {
	iface->info_request = unity_scope_service_proxy_info_request_async;
	iface->info_request_finish = unity_scope_service_proxy_info_request_finish;
	iface->activate = unity_scope_service_proxy_activate_async;
	iface->activate_finish = unity_scope_service_proxy_activate_finish;
	iface->search = unity_scope_service_proxy_search_async;
	iface->search_finish = unity_scope_service_proxy_search_finish;
	iface->global_search = unity_scope_service_proxy_global_search_async;
	iface->global_search_finish = unity_scope_service_proxy_global_search_finish;
	iface->preview = unity_scope_service_proxy_preview_async;
	iface->preview_finish = unity_scope_service_proxy_preview_finish;
	iface->set_view_type = unity_scope_service_proxy_set_view_type_async;
	iface->set_view_type_finish = unity_scope_service_proxy_set_view_type_finish;
	iface->set_active_sources = unity_scope_service_proxy_set_active_sources_async;
	iface->set_active_sources_finish = unity_scope_service_proxy_set_active_sources_finish;
}


static void _dbus_unity_scope_service_info_request (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	unity_scope_service_info_request (self, (GAsyncReadyCallback) _dbus_unity_scope_service_info_request_ready, invocation);
}


static void _dbus_unity_scope_service_info_request_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_scope_service_info_request_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_activate (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp168_;
	guint action_type = 0U;
	GVariant* _tmp169_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp168_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp168_, NULL);
	g_variant_unref (_tmp168_);
	_tmp169_ = g_variant_iter_next_value (&_arguments_iter);
	action_type = g_variant_get_uint32 (_tmp169_);
	g_variant_unref (_tmp169_);
	unity_scope_service_activate (self, uri, action_type, (GAsyncReadyCallback) _dbus_unity_scope_service_activate_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_unity_scope_service_activate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	UnityActivationReplyRaw result = {0};
	GVariantBuilder _tmp170_;
	GVariantBuilder _tmp171_;
	GHashTableIter _tmp172_;
	gpointer _tmp173_;
	gpointer _tmp174_;
	invocation = _user_data_;
	unity_scope_service_activate_finish ((UnityScopeService*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp170_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp170_, g_variant_new_string (result.uri));
	g_variant_builder_add_value (&_tmp170_, g_variant_new_uint32 (result.handled));
	g_hash_table_iter_init (&_tmp172_, result.hints);
	g_variant_builder_init (&_tmp171_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp172_, &_tmp173_, &_tmp174_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp173_;
		_value = (GVariant*) _tmp174_;
		g_variant_builder_add (&_tmp171_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp170_, g_variant_builder_end (&_tmp171_));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp170_));
	unity_activation_reply_raw_destroy (&result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_search (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp175_;
	GHashTable* hints = NULL;
	GVariant* _tmp176_;
	GHashTable* _tmp177_;
	GVariantIter _tmp178_;
	GVariant* _tmp179_;
	GVariant* _tmp180_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp175_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp175_, NULL);
	g_variant_unref (_tmp175_);
	_tmp176_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp177_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp178_, _tmp176_);
	while (g_variant_iter_loop (&_tmp178_, "{?*}", &_tmp179_, &_tmp180_)) {
		g_hash_table_insert (_tmp177_, g_variant_dup_string (_tmp179_, NULL), g_variant_get_variant (_tmp180_));
	}
	hints = _tmp177_;
	g_variant_unref (_tmp176_);
	unity_scope_service_search (self, search_string, hints, (GAsyncReadyCallback) _dbus_unity_scope_service_search_ready, invocation);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void _dbus_unity_scope_service_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp181_;
	GHashTableIter _tmp182_;
	gpointer _tmp183_;
	gpointer _tmp184_;
	invocation = _user_data_;
	result = unity_scope_service_search_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp182_, result);
	g_variant_builder_init (&_tmp181_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp182_, &_tmp183_, &_tmp184_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp183_;
		_value = (GVariant*) _tmp184_;
		g_variant_builder_add (&_tmp181_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp181_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_global_search (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp185_;
	GHashTable* hints = NULL;
	GVariant* _tmp186_;
	GHashTable* _tmp187_;
	GVariantIter _tmp188_;
	GVariant* _tmp189_;
	GVariant* _tmp190_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp185_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp185_, NULL);
	g_variant_unref (_tmp185_);
	_tmp186_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp187_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp188_, _tmp186_);
	while (g_variant_iter_loop (&_tmp188_, "{?*}", &_tmp189_, &_tmp190_)) {
		g_hash_table_insert (_tmp187_, g_variant_dup_string (_tmp189_, NULL), g_variant_get_variant (_tmp190_));
	}
	hints = _tmp187_;
	g_variant_unref (_tmp186_);
	unity_scope_service_global_search (self, search_string, hints, (GAsyncReadyCallback) _dbus_unity_scope_service_global_search_ready, invocation);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void _dbus_unity_scope_service_global_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp191_;
	GHashTableIter _tmp192_;
	gpointer _tmp193_;
	gpointer _tmp194_;
	invocation = _user_data_;
	result = unity_scope_service_global_search_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp192_, result);
	g_variant_builder_init (&_tmp191_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp192_, &_tmp193_, &_tmp194_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp193_;
		_value = (GVariant*) _tmp194_;
		g_variant_builder_add (&_tmp191_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp191_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_preview (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp195_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp195_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp195_, NULL);
	g_variant_unref (_tmp195_);
	unity_scope_service_preview (self, uri, (GAsyncReadyCallback) _dbus_unity_scope_service_preview_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_unity_scope_service_preview_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	UnityPreviewReplyRaw result = {0};
	GVariantBuilder _tmp196_;
	GVariantBuilder _tmp197_;
	GHashTableIter _tmp198_;
	gpointer _tmp199_;
	gpointer _tmp200_;
	invocation = _user_data_;
	unity_scope_service_preview_finish ((UnityScopeService*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp196_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp196_, g_variant_new_string (result.uri));
	g_variant_builder_add_value (&_tmp196_, g_variant_new_string (result.renderer_name));
	g_hash_table_iter_init (&_tmp198_, result.properties);
	g_variant_builder_init (&_tmp197_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp198_, &_tmp199_, &_tmp200_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp199_;
		_value = (GVariant*) _tmp200_;
		g_variant_builder_add (&_tmp197_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp196_, g_variant_builder_end (&_tmp197_));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp196_));
	unity_preview_reply_raw_destroy (&result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_set_view_type (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	guint view_type = 0U;
	GVariant* _tmp201_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp201_ = g_variant_iter_next_value (&_arguments_iter);
	view_type = g_variant_get_uint32 (_tmp201_);
	g_variant_unref (_tmp201_);
	unity_scope_service_set_view_type (self, view_type, (GAsyncReadyCallback) _dbus_unity_scope_service_set_view_type_ready, invocation);
}


static void _dbus_unity_scope_service_set_view_type_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_scope_service_set_view_type_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_scope_service_set_active_sources (UnityScopeService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar** sources = NULL;
	int sources_length1 = 0;
	GVariant* _tmp202_;
	gchar** _tmp203_;
	int _tmp203__length;
	int _tmp203__size;
	int _tmp203__length1;
	GVariantIter _tmp204_;
	GVariant* _tmp205_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp202_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp203_ = g_new (gchar*, 5);
	_tmp203__length = 0;
	_tmp203__size = 4;
	_tmp203__length1 = 0;
	g_variant_iter_init (&_tmp204_, _tmp202_);
	for (; (_tmp205_ = g_variant_iter_next_value (&_tmp204_)) != NULL; _tmp203__length1++) {
		if (_tmp203__size == _tmp203__length) {
			_tmp203__size = 2 * _tmp203__size;
			_tmp203_ = g_renew (gchar*, _tmp203_, _tmp203__size + 1);
		}
		_tmp203_[_tmp203__length++] = g_variant_dup_string (_tmp205_, NULL);
		g_variant_unref (_tmp205_);
	}
	sources_length1 = _tmp203__length1;
	_tmp203_[_tmp203__length] = NULL;
	sources = _tmp203_;
	g_variant_unref (_tmp202_);
	unity_scope_service_set_active_sources (self, sources, sources_length1, (GAsyncReadyCallback) _dbus_unity_scope_service_set_active_sources_ready, invocation);
	sources = (_vala_array_free (sources, sources_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_unity_scope_service_set_active_sources_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_scope_service_set_active_sources_finish ((UnityScopeService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_scope_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "InfoRequest") == 0) {
		_dbus_unity_scope_service_info_request (object, parameters, invocation);
	} else if (strcmp (method_name, "Activate") == 0) {
		_dbus_unity_scope_service_activate (object, parameters, invocation);
	} else if (strcmp (method_name, "Search") == 0) {
		_dbus_unity_scope_service_search (object, parameters, invocation);
	} else if (strcmp (method_name, "GlobalSearch") == 0) {
		_dbus_unity_scope_service_global_search (object, parameters, invocation);
	} else if (strcmp (method_name, "Preview") == 0) {
		_dbus_unity_scope_service_preview (object, parameters, invocation);
	} else if (strcmp (method_name, "SetViewType") == 0) {
		_dbus_unity_scope_service_set_view_type (object, parameters, invocation);
	} else if (strcmp (method_name, "SetActiveSources") == 0) {
		_dbus_unity_scope_service_set_active_sources (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_scope_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_scope_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_unity_scope_service_changed (GObject* _sender, UnityScopeInfo* lens_info, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp206_;
	GVariantBuilder _tmp207_;
	GHashTableIter _tmp208_;
	gpointer _tmp209_;
	gpointer _tmp210_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp206_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp206_, g_variant_new_string ((*lens_info).dbus_path));
	g_variant_builder_add_value (&_tmp206_, g_variant_new_variant ((*lens_info).sources));
	g_variant_builder_add_value (&_tmp206_, g_variant_new_boolean ((*lens_info).search_in_global));
	g_variant_builder_add_value (&_tmp206_, g_variant_new_string ((*lens_info).private_connection_name));
	g_variant_builder_add_value (&_tmp206_, g_variant_new_string ((*lens_info).results_model_name));
	g_variant_builder_add_value (&_tmp206_, g_variant_new_string ((*lens_info).global_results_model_name));
	g_variant_builder_add_value (&_tmp206_, g_variant_new_string ((*lens_info).filters_model_name));
	g_hash_table_iter_init (&_tmp208_, (*lens_info).hints);
	g_variant_builder_init (&_tmp207_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp208_, &_tmp209_, &_tmp210_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp209_;
		_value = (GVariant*) _tmp210_;
		g_variant_builder_add (&_tmp207_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp206_, g_variant_builder_end (&_tmp207_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp206_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Scope", "Changed", _arguments, NULL);
}


guint unity_scope_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_scope_service_dbus_interface_info), &_unity_scope_service_dbus_interface_vtable, data, _unity_scope_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_unity_scope_service_changed, data);
	return result;
}


static void _unity_scope_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_unity_scope_service_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



