/* unity-lens-interface.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-lens-interface.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define UNITY_TYPE_LENS_INFO (unity_lens_info_get_type ())
typedef struct _UnityLensInfo UnityLensInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_TYPE_LENS_SERVICE (unity_lens_service_get_type ())
#define UNITY_LENS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LENS_SERVICE, UnityLensService))
#define UNITY_IS_LENS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LENS_SERVICE))
#define UNITY_LENS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_LENS_SERVICE, UnityLensServiceIface))

typedef struct _UnityLensService UnityLensService;
typedef struct _UnityLensServiceIface UnityLensServiceIface;

#define UNITY_TYPE_LENS_SERVICE_PROXY (unity_lens_service_proxy_get_type ())

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;
typedef GDBusProxy UnityLensServiceProxy;
typedef GDBusProxyClass UnityLensServiceProxyClass;

struct _UnityLensInfo {
	gchar* dbus_path;
	gboolean search_in_global;
	gboolean visible;
	gchar* search_hint;
	gchar* private_connection_name;
	gchar* results_model_name;
	gchar* global_results_model_name;
	gchar* categories_model_name;
	gchar* filters_model_name;
	GHashTable* hints;
};

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityLensServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityLensService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityLensService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityLensService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*global_search_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityLensService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityLensService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*update_filter) (UnityLensService* self, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_filter_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
	void (*set_active) (UnityLensService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_finish) (UnityLensService* self, GAsyncResult* _res_, GError** error);
};



GType unity_lens_info_get_type (void) G_GNUC_CONST;
UnityLensInfo* unity_lens_info_dup (const UnityLensInfo* self);
void unity_lens_info_free (UnityLensInfo* self);
void unity_lens_info_copy (const UnityLensInfo* self, UnityLensInfo* dest);
void unity_lens_info_destroy (UnityLensInfo* self);
GType unity_lens_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_lens_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_lens_service_get_type (void) G_GNUC_CONST;
void unity_lens_service_info_request (UnityLensService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_lens_service_info_request_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
void unity_lens_service_activate (UnityLensService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_lens_service_activate_finish (UnityLensService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
void unity_lens_service_search (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_lens_service_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
void unity_lens_service_global_search (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_lens_service_global_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
void unity_lens_service_preview (UnityLensService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_lens_service_preview_finish (UnityLensService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
void unity_lens_service_update_filter (UnityLensService* self, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_lens_service_update_filter_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
void unity_lens_service_set_active (UnityLensService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_lens_service_set_active_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_lens_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_unity_lens_service_changed (UnityLensService* self, GVariant* parameters);
static void _dbus_handle_unity_lens_service_search_finished (UnityLensService* self, GVariant* parameters);
static void _dbus_handle_unity_lens_service_global_search_finished (UnityLensService* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void unity_lens_service_proxy_info_request_async (UnityLensService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_lens_service_proxy_info_request_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
static void unity_lens_service_proxy_activate_async (UnityLensService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_lens_service_proxy_activate_finish (UnityLensService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
static void unity_lens_service_proxy_search_async (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_lens_service_proxy_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
static void unity_lens_service_proxy_global_search_async (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_lens_service_proxy_global_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
static void unity_lens_service_proxy_preview_async (UnityLensService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_lens_service_proxy_preview_finish (UnityLensService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
static void unity_lens_service_proxy_update_filter_async (UnityLensService* self, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_lens_service_proxy_update_filter_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
static void unity_lens_service_proxy_set_active_async (UnityLensService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_lens_service_proxy_set_active_finish (UnityLensService* self, GAsyncResult* _res_, GError** error);
static void unity_lens_service_proxy_unity_lens_service_interface_init (UnityLensServiceIface* iface);
static void _dbus_unity_lens_service_info_request (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_lens_service_info_request_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_lens_service_activate (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_lens_service_activate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_lens_service_search (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_lens_service_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_lens_service_global_search (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_lens_service_global_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_lens_service_preview (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_lens_service_preview_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_lens_service_update_filter (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_lens_service_update_filter_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_lens_service_set_active (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_lens_service_set_active_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void unity_lens_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_lens_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_lens_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_unity_lens_service_changed (GObject* _sender, UnityLensInfo* lens_info, gpointer* _data);
static void _dbus_unity_lens_service_search_finished (GObject* _sender, const gchar* search_string, GHashTable* hints, gpointer* _data);
static void _dbus_unity_lens_service_global_search_finished (GObject* _sender, const gchar* search_string, GHashTable* hints, gpointer* _data);
static void _unity_lens_service_unregister_object (gpointer user_data);

static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_info_request_in[] = {NULL};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_info_request_out[] = {NULL};
static const GDBusMethodInfo _unity_lens_service_dbus_method_info_info_request = {-1, "InfoRequest", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_info_request_in), (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_info_request_out)};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_activate_uri = {-1, "uri", "s"};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_activate_action_type = {-1, "action_type", "u"};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_activate_result = {-1, "result", "(sua{sv})"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_activate_in[] = {&_unity_lens_service_dbus_arg_info_activate_uri, &_unity_lens_service_dbus_arg_info_activate_action_type, NULL};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_activate_out[] = {&_unity_lens_service_dbus_arg_info_activate_result, NULL};
static const GDBusMethodInfo _unity_lens_service_dbus_method_info_activate = {-1, "Activate", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_activate_in), (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_activate_out)};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_search_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_search_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_search_in[] = {&_unity_lens_service_dbus_arg_info_search_search_string, &_unity_lens_service_dbus_arg_info_search_hints, NULL};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_search_out[] = {NULL};
static const GDBusMethodInfo _unity_lens_service_dbus_method_info_search = {-1, "Search", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_search_in), (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_search_out)};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_global_search_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_global_search_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_global_search_in[] = {&_unity_lens_service_dbus_arg_info_global_search_search_string, &_unity_lens_service_dbus_arg_info_global_search_hints, NULL};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_global_search_out[] = {NULL};
static const GDBusMethodInfo _unity_lens_service_dbus_method_info_global_search = {-1, "GlobalSearch", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_global_search_in), (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_global_search_out)};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_preview_uri = {-1, "uri", "s"};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_preview_result = {-1, "result", "(ssa{sv})"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_preview_in[] = {&_unity_lens_service_dbus_arg_info_preview_uri, NULL};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_preview_out[] = {&_unity_lens_service_dbus_arg_info_preview_result, NULL};
static const GDBusMethodInfo _unity_lens_service_dbus_method_info_preview = {-1, "Preview", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_preview_in), (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_preview_out)};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_update_filter_filter_name = {-1, "filter_name", "s"};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_update_filter_properties = {-1, "properties", "a{sv}"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_update_filter_in[] = {&_unity_lens_service_dbus_arg_info_update_filter_filter_name, &_unity_lens_service_dbus_arg_info_update_filter_properties, NULL};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_update_filter_out[] = {NULL};
static const GDBusMethodInfo _unity_lens_service_dbus_method_info_update_filter = {-1, "UpdateFilter", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_update_filter_in), (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_update_filter_out)};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_set_active_active = {-1, "active", "b"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_set_active_in[] = {&_unity_lens_service_dbus_arg_info_set_active_active, NULL};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_set_active_out[] = {NULL};
static const GDBusMethodInfo _unity_lens_service_dbus_method_info_set_active = {-1, "SetActive", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_set_active_in), (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_set_active_out)};
static const GDBusMethodInfo * const _unity_lens_service_dbus_method_info[] = {&_unity_lens_service_dbus_method_info_info_request, &_unity_lens_service_dbus_method_info_activate, &_unity_lens_service_dbus_method_info_search, &_unity_lens_service_dbus_method_info_global_search, &_unity_lens_service_dbus_method_info_preview, &_unity_lens_service_dbus_method_info_update_filter, &_unity_lens_service_dbus_method_info_set_active, NULL};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_changed_lens_info = {-1, "lens_info", "(sbbssssssa{sv})"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_changed[] = {&_unity_lens_service_dbus_arg_info_changed_lens_info, NULL};
static const GDBusSignalInfo _unity_lens_service_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_changed)};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_search_finished_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_search_finished_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_search_finished[] = {&_unity_lens_service_dbus_arg_info_search_finished_search_string, &_unity_lens_service_dbus_arg_info_search_finished_hints, NULL};
static const GDBusSignalInfo _unity_lens_service_dbus_signal_info_search_finished = {-1, "SearchFinished", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_search_finished)};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_global_search_finished_search_string = {-1, "search_string", "s"};
static const GDBusArgInfo _unity_lens_service_dbus_arg_info_global_search_finished_hints = {-1, "hints", "a{sv}"};
static const GDBusArgInfo * const _unity_lens_service_dbus_arg_info_global_search_finished[] = {&_unity_lens_service_dbus_arg_info_global_search_finished_search_string, &_unity_lens_service_dbus_arg_info_global_search_finished_hints, NULL};
static const GDBusSignalInfo _unity_lens_service_dbus_signal_info_global_search_finished = {-1, "GlobalSearchFinished", (GDBusArgInfo **) (&_unity_lens_service_dbus_arg_info_global_search_finished)};
static const GDBusSignalInfo * const _unity_lens_service_dbus_signal_info[] = {&_unity_lens_service_dbus_signal_info_changed, &_unity_lens_service_dbus_signal_info_search_finished, &_unity_lens_service_dbus_signal_info_global_search_finished, NULL};
static const GDBusPropertyInfo * const _unity_lens_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_lens_service_dbus_interface_info = {-1, "com.canonical.Unity.Lens", (GDBusMethodInfo **) (&_unity_lens_service_dbus_method_info), (GDBusSignalInfo **) (&_unity_lens_service_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_lens_service_dbus_property_info)};
static const GDBusInterfaceVTable _unity_lens_service_dbus_interface_vtable = {unity_lens_service_dbus_interface_method_call, unity_lens_service_dbus_interface_get_property, unity_lens_service_dbus_interface_set_property};

static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void unity_lens_info_copy (const UnityLensInfo* self, UnityLensInfo* dest) {
	dest->dbus_path = g_strdup (self->dbus_path);
	dest->search_in_global = self->search_in_global;
	dest->visible = self->visible;
	dest->search_hint = g_strdup (self->search_hint);
	dest->private_connection_name = g_strdup (self->private_connection_name);
	dest->results_model_name = g_strdup (self->results_model_name);
	dest->global_results_model_name = g_strdup (self->global_results_model_name);
	dest->categories_model_name = g_strdup (self->categories_model_name);
	dest->filters_model_name = g_strdup (self->filters_model_name);
	dest->hints = _g_hash_table_ref0 (self->hints);
}


void unity_lens_info_destroy (UnityLensInfo* self) {
	_g_free0 ((*self).dbus_path);
	_g_free0 ((*self).search_hint);
	_g_free0 ((*self).private_connection_name);
	_g_free0 ((*self).results_model_name);
	_g_free0 ((*self).global_results_model_name);
	_g_free0 ((*self).categories_model_name);
	_g_free0 ((*self).filters_model_name);
	_g_hash_table_unref0 ((*self).hints);
}


UnityLensInfo* unity_lens_info_dup (const UnityLensInfo* self) {
	UnityLensInfo* dup;
	dup = g_new0 (UnityLensInfo, 1);
	unity_lens_info_copy (self, dup);
	return dup;
}


void unity_lens_info_free (UnityLensInfo* self) {
	unity_lens_info_destroy (self);
	g_free (self);
}


GType unity_lens_info_get_type (void) {
	static volatile gsize unity_lens_info_type_id__volatile = 0;
	if (g_once_init_enter (&unity_lens_info_type_id__volatile)) {
		GType unity_lens_info_type_id;
		unity_lens_info_type_id = g_boxed_type_register_static ("UnityLensInfo", (GBoxedCopyFunc) unity_lens_info_dup, (GBoxedFreeFunc) unity_lens_info_free);
		g_once_init_leave (&unity_lens_info_type_id__volatile, unity_lens_info_type_id);
	}
	return unity_lens_info_type_id__volatile;
}


void unity_lens_service_info_request (UnityLensService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->info_request (self, _callback_, _user_data_);
}


void unity_lens_service_info_request_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->info_request_finish (self, _res_, error);
}


void unity_lens_service_activate (UnityLensService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->activate (self, uri, action_type, _callback_, _user_data_);
}


void unity_lens_service_activate_finish (UnityLensService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->activate_finish (self, _res_, result, error);
}


void unity_lens_service_search (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->search (self, search_string, hints, _callback_, _user_data_);
}


void unity_lens_service_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->search_finish (self, _res_, error);
}


void unity_lens_service_global_search (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->global_search (self, search_string, hints, _callback_, _user_data_);
}


void unity_lens_service_global_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->global_search_finish (self, _res_, error);
}


void unity_lens_service_preview (UnityLensService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->preview (self, uri, _callback_, _user_data_);
}


void unity_lens_service_preview_finish (UnityLensService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->preview_finish (self, _res_, result, error);
}


void unity_lens_service_update_filter (UnityLensService* self, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->update_filter (self, filter_name, properties, _callback_, _user_data_);
}


void unity_lens_service_update_filter_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->update_filter_finish (self, _res_, error);
}


void unity_lens_service_set_active (UnityLensService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->set_active (self, active, _callback_, _user_data_);
}


void unity_lens_service_set_active_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	UNITY_LENS_SERVICE_GET_INTERFACE (self)->set_active_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}


static void unity_lens_service_base_init (UnityLensServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", UNITY_TYPE_LENS_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_TYPE_LENS_INFO);
		g_signal_new ("search_finished", UNITY_TYPE_LENS_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
		g_signal_new ("global_search_finished", UNITY_TYPE_LENS_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
	}
}


/**
 * LensService:
 *
 * The Lens interface exported on DBus
 */
GType unity_lens_service_get_type (void) {
	static volatile gsize unity_lens_service_type_id__volatile = 0;
	if (g_once_init_enter (&unity_lens_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLensServiceIface), (GBaseInitFunc) unity_lens_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_lens_service_type_id;
		unity_lens_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityLensService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_lens_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_lens_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) unity_lens_service_proxy_get_type);
		g_type_set_qdata (unity_lens_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.Unity.Lens");
		g_type_set_qdata (unity_lens_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_lens_service_register_object);
		g_once_init_leave (&unity_lens_service_type_id__volatile, unity_lens_service_type_id);
	}
	return unity_lens_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityLensServiceProxy, unity_lens_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_TYPE_LENS_SERVICE, unity_lens_service_proxy_unity_lens_service_interface_init) )
static void unity_lens_service_proxy_class_init (UnityLensServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = unity_lens_service_proxy_g_signal;
}


static void _dbus_handle_unity_lens_service_changed (UnityLensService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	UnityLensInfo lens_info = {0};
	GVariant* _tmp8_;
	UnityLensInfo _tmp9_;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GHashTable* _tmp21_;
	GVariantIter _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp10_, _tmp8_);
	_tmp11_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.dbus_path = g_variant_dup_string (_tmp11_, NULL);
	g_variant_unref (_tmp11_);
	_tmp12_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.search_in_global = g_variant_get_boolean (_tmp12_);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.visible = g_variant_get_boolean (_tmp13_);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.search_hint = g_variant_dup_string (_tmp14_, NULL);
	g_variant_unref (_tmp14_);
	_tmp15_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.private_connection_name = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.results_model_name = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	_tmp17_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.global_results_model_name = g_variant_dup_string (_tmp17_, NULL);
	g_variant_unref (_tmp17_);
	_tmp18_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.categories_model_name = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	_tmp19_ = g_variant_iter_next_value (&_tmp10_);
	_tmp9_.filters_model_name = g_variant_dup_string (_tmp19_, NULL);
	g_variant_unref (_tmp19_);
	_tmp20_ = g_variant_iter_next_value (&_tmp10_);
	_tmp21_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp22_, _tmp20_);
	while (g_variant_iter_loop (&_tmp22_, "{?*}", &_tmp23_, &_tmp24_)) {
		g_hash_table_insert (_tmp21_, g_variant_dup_string (_tmp23_, NULL), g_variant_get_variant (_tmp24_));
	}
	_tmp9_.hints = _tmp21_;
	g_variant_unref (_tmp20_);
	lens_info = _tmp9_;
	g_variant_unref (_tmp8_);
	g_signal_emit_by_name (self, "changed", &lens_info);
	unity_lens_info_destroy (&lens_info);
}


static void _dbus_handle_unity_lens_service_search_finished (UnityLensService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp25_;
	GHashTable* hints = NULL;
	GVariant* _tmp26_;
	GHashTable* _tmp27_;
	GVariantIter _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	_tmp26_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp27_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp28_, _tmp26_);
	while (g_variant_iter_loop (&_tmp28_, "{?*}", &_tmp29_, &_tmp30_)) {
		g_hash_table_insert (_tmp27_, g_variant_dup_string (_tmp29_, NULL), g_variant_get_variant (_tmp30_));
	}
	hints = _tmp27_;
	g_variant_unref (_tmp26_);
	g_signal_emit_by_name (self, "search-finished", search_string, hints);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void _dbus_handle_unity_lens_service_global_search_finished (UnityLensService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp31_;
	GHashTable* hints = NULL;
	GVariant* _tmp32_;
	GHashTable* _tmp33_;
	GVariantIter _tmp34_;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp31_, NULL);
	g_variant_unref (_tmp31_);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp33_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp34_, _tmp32_);
	while (g_variant_iter_loop (&_tmp34_, "{?*}", &_tmp35_, &_tmp36_)) {
		g_hash_table_insert (_tmp33_, g_variant_dup_string (_tmp35_, NULL), g_variant_get_variant (_tmp36_));
	}
	hints = _tmp33_;
	g_variant_unref (_tmp32_);
	g_signal_emit_by_name (self, "global-search-finished", search_string, hints);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void unity_lens_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_unity_lens_service_changed ((UnityLensService*) proxy, parameters);
	} else if (strcmp (signal_name, "SearchFinished") == 0) {
		_dbus_handle_unity_lens_service_search_finished ((UnityLensService*) proxy, parameters);
	} else if (strcmp (signal_name, "GlobalSearchFinished") == 0) {
		_dbus_handle_unity_lens_service_global_search_finished ((UnityLensService*) proxy, parameters);
	}
}


static void unity_lens_service_proxy_init (UnityLensServiceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void unity_lens_service_proxy_info_request_async (UnityLensService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Lens", "InfoRequest");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_lens_service_proxy_info_request_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_lens_service_proxy_activate_async (UnityLensService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Lens", "Activate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (action_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_lens_service_proxy_activate_finish (UnityLensService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _tmp37_;
	UnityActivationReplyRaw _tmp38_;
	GVariantIter _tmp39_;
	GVariant* _tmp40_;
	GVariant* _tmp41_;
	GVariant* _tmp42_;
	GHashTable* _tmp43_;
	GVariantIter _tmp44_;
	GVariant* _tmp45_;
	GVariant* _tmp46_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp37_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp39_, _tmp37_);
	_tmp40_ = g_variant_iter_next_value (&_tmp39_);
	_tmp38_.uri = g_variant_dup_string (_tmp40_, NULL);
	g_variant_unref (_tmp40_);
	_tmp41_ = g_variant_iter_next_value (&_tmp39_);
	_tmp38_.handled = g_variant_get_uint32 (_tmp41_);
	g_variant_unref (_tmp41_);
	_tmp42_ = g_variant_iter_next_value (&_tmp39_);
	_tmp43_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp44_, _tmp42_);
	while (g_variant_iter_loop (&_tmp44_, "{?*}", &_tmp45_, &_tmp46_)) {
		g_hash_table_insert (_tmp43_, g_variant_dup_string (_tmp45_, NULL), g_variant_get_variant (_tmp46_));
	}
	_tmp38_.hints = _tmp43_;
	g_variant_unref (_tmp42_);
	*result = _tmp38_;
	g_variant_unref (_tmp37_);
	g_object_unref (_reply_message);
}


static void unity_lens_service_proxy_search_async (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp47_;
	GHashTableIter _tmp48_;
	gpointer _tmp49_;
	gpointer _tmp50_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Lens", "Search");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp48_, hints);
	g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp48_, &_tmp49_, &_tmp50_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp49_;
		_value = (GVariant*) _tmp50_;
		g_variant_builder_add (&_tmp47_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp47_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_lens_service_proxy_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_lens_service_proxy_global_search_async (UnityLensService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp51_;
	GHashTableIter _tmp52_;
	gpointer _tmp53_;
	gpointer _tmp54_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Lens", "GlobalSearch");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp52_, hints);
	g_variant_builder_init (&_tmp51_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp52_, &_tmp53_, &_tmp54_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp53_;
		_value = (GVariant*) _tmp54_;
		g_variant_builder_add (&_tmp51_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp51_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_lens_service_proxy_global_search_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_lens_service_proxy_preview_async (UnityLensService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Lens", "Preview");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_lens_service_proxy_preview_finish (UnityLensService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _tmp55_;
	UnityPreviewReplyRaw _tmp56_;
	GVariantIter _tmp57_;
	GVariant* _tmp58_;
	GVariant* _tmp59_;
	GVariant* _tmp60_;
	GHashTable* _tmp61_;
	GVariantIter _tmp62_;
	GVariant* _tmp63_;
	GVariant* _tmp64_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp55_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp57_, _tmp55_);
	_tmp58_ = g_variant_iter_next_value (&_tmp57_);
	_tmp56_.uri = g_variant_dup_string (_tmp58_, NULL);
	g_variant_unref (_tmp58_);
	_tmp59_ = g_variant_iter_next_value (&_tmp57_);
	_tmp56_.renderer_name = g_variant_dup_string (_tmp59_, NULL);
	g_variant_unref (_tmp59_);
	_tmp60_ = g_variant_iter_next_value (&_tmp57_);
	_tmp61_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp62_, _tmp60_);
	while (g_variant_iter_loop (&_tmp62_, "{?*}", &_tmp63_, &_tmp64_)) {
		g_hash_table_insert (_tmp61_, g_variant_dup_string (_tmp63_, NULL), g_variant_get_variant (_tmp64_));
	}
	_tmp56_.properties = _tmp61_;
	g_variant_unref (_tmp60_);
	*result = _tmp56_;
	g_variant_unref (_tmp55_);
	g_object_unref (_reply_message);
}


static void unity_lens_service_proxy_update_filter_async (UnityLensService* self, const gchar* filter_name, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp65_;
	GHashTableIter _tmp66_;
	gpointer _tmp67_;
	gpointer _tmp68_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Lens", "UpdateFilter");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (filter_name));
	g_hash_table_iter_init (&_tmp66_, properties);
	g_variant_builder_init (&_tmp65_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp66_, &_tmp67_, &_tmp68_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp67_;
		_value = (GVariant*) _tmp68_;
		g_variant_builder_add (&_tmp65_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp65_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_lens_service_proxy_update_filter_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_lens_service_proxy_set_active_async (UnityLensService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.Lens", "SetActive");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (active));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_lens_service_proxy_set_active_finish (UnityLensService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_lens_service_proxy_unity_lens_service_interface_init (UnityLensServiceIface* iface) {
	iface->info_request = unity_lens_service_proxy_info_request_async;
	iface->info_request_finish = unity_lens_service_proxy_info_request_finish;
	iface->activate = unity_lens_service_proxy_activate_async;
	iface->activate_finish = unity_lens_service_proxy_activate_finish;
	iface->search = unity_lens_service_proxy_search_async;
	iface->search_finish = unity_lens_service_proxy_search_finish;
	iface->global_search = unity_lens_service_proxy_global_search_async;
	iface->global_search_finish = unity_lens_service_proxy_global_search_finish;
	iface->preview = unity_lens_service_proxy_preview_async;
	iface->preview_finish = unity_lens_service_proxy_preview_finish;
	iface->update_filter = unity_lens_service_proxy_update_filter_async;
	iface->update_filter_finish = unity_lens_service_proxy_update_filter_finish;
	iface->set_active = unity_lens_service_proxy_set_active_async;
	iface->set_active_finish = unity_lens_service_proxy_set_active_finish;
}


static void _dbus_unity_lens_service_info_request (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	unity_lens_service_info_request (self, (GAsyncReadyCallback) _dbus_unity_lens_service_info_request_ready, invocation);
}


static void _dbus_unity_lens_service_info_request_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_lens_service_info_request_finish ((UnityLensService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_lens_service_activate (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp69_;
	guint action_type = 0U;
	GVariant* _tmp70_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp69_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp69_, NULL);
	g_variant_unref (_tmp69_);
	_tmp70_ = g_variant_iter_next_value (&_arguments_iter);
	action_type = g_variant_get_uint32 (_tmp70_);
	g_variant_unref (_tmp70_);
	unity_lens_service_activate (self, uri, action_type, (GAsyncReadyCallback) _dbus_unity_lens_service_activate_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_unity_lens_service_activate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	UnityActivationReplyRaw result = {0};
	GVariantBuilder _tmp71_;
	GVariantBuilder _tmp72_;
	GHashTableIter _tmp73_;
	gpointer _tmp74_;
	gpointer _tmp75_;
	invocation = _user_data_;
	unity_lens_service_activate_finish ((UnityLensService*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp71_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp71_, g_variant_new_string (result.uri));
	g_variant_builder_add_value (&_tmp71_, g_variant_new_uint32 (result.handled));
	g_hash_table_iter_init (&_tmp73_, result.hints);
	g_variant_builder_init (&_tmp72_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp73_, &_tmp74_, &_tmp75_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp74_;
		_value = (GVariant*) _tmp75_;
		g_variant_builder_add (&_tmp72_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp71_, g_variant_builder_end (&_tmp72_));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp71_));
	unity_activation_reply_raw_destroy (& result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_lens_service_search (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp76_;
	GHashTable* hints = NULL;
	GVariant* _tmp77_;
	GHashTable* _tmp78_;
	GVariantIter _tmp79_;
	GVariant* _tmp80_;
	GVariant* _tmp81_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp76_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp76_, NULL);
	g_variant_unref (_tmp76_);
	_tmp77_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp78_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp79_, _tmp77_);
	while (g_variant_iter_loop (&_tmp79_, "{?*}", &_tmp80_, &_tmp81_)) {
		g_hash_table_insert (_tmp78_, g_variant_dup_string (_tmp80_, NULL), g_variant_get_variant (_tmp81_));
	}
	hints = _tmp78_;
	g_variant_unref (_tmp77_);
	unity_lens_service_search (self, search_string, hints, (GAsyncReadyCallback) _dbus_unity_lens_service_search_ready, invocation);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void _dbus_unity_lens_service_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_lens_service_search_finish ((UnityLensService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_lens_service_global_search (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* search_string = NULL;
	GVariant* _tmp82_;
	GHashTable* hints = NULL;
	GVariant* _tmp83_;
	GHashTable* _tmp84_;
	GVariantIter _tmp85_;
	GVariant* _tmp86_;
	GVariant* _tmp87_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp82_ = g_variant_iter_next_value (&_arguments_iter);
	search_string = g_variant_dup_string (_tmp82_, NULL);
	g_variant_unref (_tmp82_);
	_tmp83_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp84_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp85_, _tmp83_);
	while (g_variant_iter_loop (&_tmp85_, "{?*}", &_tmp86_, &_tmp87_)) {
		g_hash_table_insert (_tmp84_, g_variant_dup_string (_tmp86_, NULL), g_variant_get_variant (_tmp87_));
	}
	hints = _tmp84_;
	g_variant_unref (_tmp83_);
	unity_lens_service_global_search (self, search_string, hints, (GAsyncReadyCallback) _dbus_unity_lens_service_global_search_ready, invocation);
	_g_free0 (search_string);
	_g_hash_table_unref0 (hints);
}


static void _dbus_unity_lens_service_global_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_lens_service_global_search_finish ((UnityLensService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_lens_service_preview (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp88_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp88_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp88_, NULL);
	g_variant_unref (_tmp88_);
	unity_lens_service_preview (self, uri, (GAsyncReadyCallback) _dbus_unity_lens_service_preview_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_unity_lens_service_preview_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	UnityPreviewReplyRaw result = {0};
	GVariantBuilder _tmp89_;
	GVariantBuilder _tmp90_;
	GHashTableIter _tmp91_;
	gpointer _tmp92_;
	gpointer _tmp93_;
	invocation = _user_data_;
	unity_lens_service_preview_finish ((UnityLensService*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp89_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp89_, g_variant_new_string (result.uri));
	g_variant_builder_add_value (&_tmp89_, g_variant_new_string (result.renderer_name));
	g_hash_table_iter_init (&_tmp91_, result.properties);
	g_variant_builder_init (&_tmp90_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp91_, &_tmp92_, &_tmp93_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp92_;
		_value = (GVariant*) _tmp93_;
		g_variant_builder_add (&_tmp90_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp89_, g_variant_builder_end (&_tmp90_));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp89_));
	unity_preview_reply_raw_destroy (& result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_lens_service_update_filter (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* filter_name = NULL;
	GVariant* _tmp94_;
	GHashTable* properties = NULL;
	GVariant* _tmp95_;
	GHashTable* _tmp96_;
	GVariantIter _tmp97_;
	GVariant* _tmp98_;
	GVariant* _tmp99_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp94_ = g_variant_iter_next_value (&_arguments_iter);
	filter_name = g_variant_dup_string (_tmp94_, NULL);
	g_variant_unref (_tmp94_);
	_tmp95_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp96_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp97_, _tmp95_);
	while (g_variant_iter_loop (&_tmp97_, "{?*}", &_tmp98_, &_tmp99_)) {
		g_hash_table_insert (_tmp96_, g_variant_dup_string (_tmp98_, NULL), g_variant_get_variant (_tmp99_));
	}
	properties = _tmp96_;
	g_variant_unref (_tmp95_);
	unity_lens_service_update_filter (self, filter_name, properties, (GAsyncReadyCallback) _dbus_unity_lens_service_update_filter_ready, invocation);
	_g_free0 (filter_name);
	_g_hash_table_unref0 (properties);
}


static void _dbus_unity_lens_service_update_filter_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_lens_service_update_filter_finish ((UnityLensService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_lens_service_set_active (UnityLensService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gboolean active = FALSE;
	GVariant* _tmp100_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp100_ = g_variant_iter_next_value (&_arguments_iter);
	active = g_variant_get_boolean (_tmp100_);
	g_variant_unref (_tmp100_);
	unity_lens_service_set_active (self, active, (GAsyncReadyCallback) _dbus_unity_lens_service_set_active_ready, invocation);
}


static void _dbus_unity_lens_service_set_active_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_lens_service_set_active_finish ((UnityLensService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_lens_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "InfoRequest") == 0) {
		_dbus_unity_lens_service_info_request (object, parameters, invocation);
	} else if (strcmp (method_name, "Activate") == 0) {
		_dbus_unity_lens_service_activate (object, parameters, invocation);
	} else if (strcmp (method_name, "Search") == 0) {
		_dbus_unity_lens_service_search (object, parameters, invocation);
	} else if (strcmp (method_name, "GlobalSearch") == 0) {
		_dbus_unity_lens_service_global_search (object, parameters, invocation);
	} else if (strcmp (method_name, "Preview") == 0) {
		_dbus_unity_lens_service_preview (object, parameters, invocation);
	} else if (strcmp (method_name, "UpdateFilter") == 0) {
		_dbus_unity_lens_service_update_filter (object, parameters, invocation);
	} else if (strcmp (method_name, "SetActive") == 0) {
		_dbus_unity_lens_service_set_active (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_lens_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_lens_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_unity_lens_service_changed (GObject* _sender, UnityLensInfo* lens_info, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp101_;
	GVariantBuilder _tmp102_;
	GHashTableIter _tmp103_;
	gpointer _tmp104_;
	gpointer _tmp105_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp101_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*lens_info).dbus_path));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_boolean ((*lens_info).search_in_global));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_boolean ((*lens_info).visible));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*lens_info).search_hint));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*lens_info).private_connection_name));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*lens_info).results_model_name));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*lens_info).global_results_model_name));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*lens_info).categories_model_name));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*lens_info).filters_model_name));
	g_hash_table_iter_init (&_tmp103_, (*lens_info).hints);
	g_variant_builder_init (&_tmp102_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp103_, &_tmp104_, &_tmp105_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp104_;
		_value = (GVariant*) _tmp105_;
		g_variant_builder_add (&_tmp102_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_tmp101_, g_variant_builder_end (&_tmp102_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp101_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Lens", "Changed", _arguments, NULL);
}


static void _dbus_unity_lens_service_search_finished (GObject* _sender, const gchar* search_string, GHashTable* hints, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp106_;
	GHashTableIter _tmp107_;
	gpointer _tmp108_;
	gpointer _tmp109_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp107_, hints);
	g_variant_builder_init (&_tmp106_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp107_, &_tmp108_, &_tmp109_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp108_;
		_value = (GVariant*) _tmp109_;
		g_variant_builder_add (&_tmp106_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp106_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Lens", "SearchFinished", _arguments, NULL);
}


static void _dbus_unity_lens_service_global_search_finished (GObject* _sender, const gchar* search_string, GHashTable* hints, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp110_;
	GHashTableIter _tmp111_;
	gpointer _tmp112_;
	gpointer _tmp113_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (search_string));
	g_hash_table_iter_init (&_tmp111_, hints);
	g_variant_builder_init (&_tmp110_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp111_, &_tmp112_, &_tmp113_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp112_;
		_value = (GVariant*) _tmp113_;
		g_variant_builder_add (&_tmp110_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp110_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.Lens", "GlobalSearchFinished", _arguments, NULL);
}


guint unity_lens_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_lens_service_dbus_interface_info), &_unity_lens_service_dbus_interface_vtable, data, _unity_lens_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_unity_lens_service_changed, data);
	g_signal_connect (object, "search-finished", (GCallback) _dbus_unity_lens_service_search_finished, data);
	g_signal_connect (object, "global-search-finished", (GCallback) _dbus_unity_lens_service_global_search_finished, data);
	return result;
}


static void _unity_lens_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



