/* unity-place-browser.c generated by valac 0.12.0, the Vala compiler
 * generated from unity-place-browser.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define UNITY_TYPE__BROWSINGSTATE (unity__browsingstate_get_type ())
typedef struct _Unity_BrowsingState Unity_BrowsingState;
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_TYPE_BROWSING_OP (unity_browsing_op_get_type ())

#define UNITY_TYPE_BROWSER_SERVICE (unity_browser_service_get_type ())
#define UNITY_BROWSER_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_BROWSER_SERVICE, UnityBrowserService))
#define UNITY_IS_BROWSER_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_BROWSER_SERVICE))
#define UNITY_BROWSER_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_BROWSER_SERVICE, UnityBrowserServiceIface))

typedef struct _UnityBrowserService UnityBrowserService;
typedef struct _UnityBrowserServiceIface UnityBrowserServiceIface;

#define UNITY_TYPE_BROWSER_SERVICE_PROXY (unity_browser_service_proxy_get_type ())
typedef GDBusProxy UnityBrowserServiceProxy;
typedef GDBusProxyClass UnityBrowserServiceProxyClass;

#define UNITY_TYPE_BROWSER_SERVICE_IMPL (unity_browser_service_impl_get_type ())
#define UNITY_BROWSER_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_BROWSER_SERVICE_IMPL, UnityBrowserServiceImpl))
#define UNITY_BROWSER_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_BROWSER_SERVICE_IMPL, UnityBrowserServiceImplClass))
#define UNITY_IS_BROWSER_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_BROWSER_SERVICE_IMPL))
#define UNITY_IS_BROWSER_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_BROWSER_SERVICE_IMPL))
#define UNITY_BROWSER_SERVICE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_BROWSER_SERVICE_IMPL, UnityBrowserServiceImplClass))

typedef struct _UnityBrowserServiceImpl UnityBrowserServiceImpl;
typedef struct _UnityBrowserServiceImplClass UnityBrowserServiceImplClass;
typedef struct _UnityBrowserServiceImplPrivate UnityBrowserServiceImplPrivate;

#define UNITY_TYPE_BROWSER (unity_browser_get_type ())
#define UNITY_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_BROWSER, UnityBrowser))
#define UNITY_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_BROWSER, UnityBrowserClass))
#define UNITY_IS_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_BROWSER))
#define UNITY_IS_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_BROWSER))
#define UNITY_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_BROWSER, UnityBrowserClass))

typedef struct _UnityBrowser UnityBrowser;
typedef struct _UnityBrowserClass UnityBrowserClass;
typedef struct _UnityBrowserPrivate UnityBrowserPrivate;

#define UNITY_TYPE_STACK (unity_stack_get_type ())
#define UNITY_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_STACK, UnityStack))
#define UNITY_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_STACK, UnityStackClass))
#define UNITY_IS_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_STACK))
#define UNITY_IS_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_STACK))
#define UNITY_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_STACK, UnityStackClass))

typedef struct _UnityStack UnityStack;
typedef struct _UnityStackClass UnityStackClass;

#define UNITY_TYPE_STATE (unity_state_get_type ())
#define UNITY_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_STATE, UnityState))
#define UNITY_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_STATE, UnityStateClass))
#define UNITY_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_STATE))
#define UNITY_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_STATE))
#define UNITY_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_STATE, UnityStateClass))

typedef struct _UnityState UnityState;
typedef struct _UnityStateClass UnityStateClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _unity_stack_unref0(var) ((var == NULL) ? NULL : (var = (unity_stack_unref (var), NULL)))
#define _unity_state_unref0(var) ((var == NULL) ? NULL : (var = (unity_state_unref (var), NULL)))
typedef struct _UnityStatePrivate UnityStatePrivate;
typedef struct _UnityParamSpecState UnityParamSpecState;
typedef struct _UnityStackPrivate UnityStackPrivate;
typedef struct _UnityParamSpecStack UnityParamSpecStack;

struct _Unity_BrowsingState {
	gboolean sensitive;
	gchar* comment;
};

typedef enum  {
	UNITY_BROWSING_OP_BACK,
	UNITY_BROWSING_OP_FORWARD,
	UNITY_BROWSING_OP_NUM_OPS
} UnityBrowsingOp;

struct _UnityBrowserServiceIface {
	GTypeInterface parent_iface;
	Unity_BrowsingState* (*go_back) (UnityBrowserService* self, int* result_length1, GError** error);
	Unity_BrowsingState* (*go_forward) (UnityBrowserService* self, int* result_length1, GError** error);
	Unity_BrowsingState* (*get_state) (UnityBrowserService* self, int* result_length1, GError** error);
};

struct _UnityBrowserServiceImpl {
	GObject parent_instance;
	UnityBrowserServiceImplPrivate * priv;
};

struct _UnityBrowserServiceImplClass {
	GObjectClass parent_class;
};

struct _UnityBrowserServiceImplPrivate {
	gchar* _dbus_path;
	Unity_BrowsingState* _browsing_state;
	gint _browsing_state_length1;
	gint __browsing_state_size_;
};

struct _UnityBrowser {
	GObject parent_instance;
	UnityBrowserPrivate * priv;
};

struct _UnityBrowserClass {
	GObjectClass parent_class;
};

struct _UnityBrowserPrivate {
	GType e_type;
	GBoxedCopyFunc e_dup_func;
	GDestroyNotify e_destroy_func;
	UnityBrowserServiceImpl* service;
	UnityStack* back_stack;
	UnityStack* forward_stack;
	UnityState* current_state;
	gchar* _dbus_path;
};

struct _UnityState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityStatePrivate * priv;
	gpointer state;
	gchar* comment;
};

struct _UnityStateClass {
	GTypeClass parent_class;
	void (*finalize) (UnityState *self);
};

struct _UnityStatePrivate {
	GType e_type;
	GBoxedCopyFunc e_dup_func;
	GDestroyNotify e_destroy_func;
};

struct _UnityParamSpecState {
	GParamSpec parent_instance;
};

struct _UnityStack {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityStackPrivate * priv;
};

struct _UnityStackClass {
	GTypeClass parent_class;
	void (*finalize) (UnityStack *self);
};

struct _UnityStackPrivate {
	GType e_type;
	GBoxedCopyFunc e_dup_func;
	GDestroyNotify e_destroy_func;
	GeeLinkedList* list;
};

struct _UnityParamSpecStack {
	GParamSpec parent_instance;
};


static gpointer unity_browser_service_impl_parent_class = NULL;
static UnityBrowserServiceIface* unity_browser_service_impl_unity_browser_service_parent_iface = NULL;
static gpointer unity_browser_parent_class = NULL;
static gpointer unity_state_parent_class = NULL;
static gpointer unity_stack_parent_class = NULL;

GType unity__browsingstate_get_type (void) G_GNUC_CONST;
Unity_BrowsingState* unity__browsingstate_dup (const Unity_BrowsingState* self);
void unity__browsingstate_free (Unity_BrowsingState* self);
void unity__browsingstate_copy (const Unity_BrowsingState* self, Unity_BrowsingState* dest);
void unity__browsingstate_destroy (Unity_BrowsingState* self);
GType unity_browsing_op_get_type (void) G_GNUC_CONST;
GType unity_browser_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_browser_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_browser_service_get_type (void) G_GNUC_CONST;
Unity_BrowsingState* unity_browser_service_go_back (UnityBrowserService* self, int* result_length1, GError** error);
Unity_BrowsingState* unity_browser_service_go_forward (UnityBrowserService* self, int* result_length1, GError** error);
Unity_BrowsingState* unity_browser_service_get_state (UnityBrowserService* self, int* result_length1, GError** error);
static void unity_browser_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static Unity_BrowsingState* unity_browser_service_proxy_go_back (UnityBrowserService* self, int* result_length1, GError** error);
static Unity_BrowsingState* unity_browser_service_proxy_go_forward (UnityBrowserService* self, int* result_length1, GError** error);
static Unity_BrowsingState* unity_browser_service_proxy_get_state (UnityBrowserService* self, int* result_length1, GError** error);
static void unity_browser_service_proxy_unity_browser_service_interface_init (UnityBrowserServiceIface* iface);
static void _vala_Unity_BrowsingState_array_free (Unity_BrowsingState* array, gint array_length);
static void _dbus_unity_browser_service_go_back (UnityBrowserService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_browser_service_go_forward (UnityBrowserService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_browser_service_get_state (UnityBrowserService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void unity_browser_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_browser_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_browser_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _unity_browser_service_unregister_object (gpointer user_data);
GType unity_browser_service_impl_get_type (void) G_GNUC_CONST;
#define UNITY_BROWSER_SERVICE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_BROWSER_SERVICE_IMPL, UnityBrowserServiceImplPrivate))
enum  {
	UNITY_BROWSER_SERVICE_IMPL_DUMMY_PROPERTY,
	UNITY_BROWSER_SERVICE_IMPL_DBUS_PATH
};
UnityBrowserServiceImpl* unity_browser_service_impl_new (const gchar* dbus_path);
UnityBrowserServiceImpl* unity_browser_service_impl_construct (GType object_type, const gchar* dbus_path);
static void unity_browser_service_impl_set_dbus_path (UnityBrowserServiceImpl* self, const gchar* value);
static void unity_browser_service_impl_set_browsing_state (UnityBrowserServiceImpl* self, Unity_BrowsingState* value, int value_length1);
static Unity_BrowsingState* unity_browser_service_impl_real_go_back (UnityBrowserService* base, int* result_length1, GError** error);
Unity_BrowsingState* unity_browser_service_impl_get_browsing_state (UnityBrowserServiceImpl* self, int* result_length1);
static Unity_BrowsingState* _vala_array_dup9 (Unity_BrowsingState* self, int length);
static Unity_BrowsingState* unity_browser_service_impl_real_go_forward (UnityBrowserService* base, int* result_length1, GError** error);
static Unity_BrowsingState* _vala_array_dup10 (Unity_BrowsingState* self, int length);
static Unity_BrowsingState* unity_browser_service_impl_real_get_state (UnityBrowserService* base, int* result_length1, GError** error);
static Unity_BrowsingState* _vala_array_dup11 (Unity_BrowsingState* self, int length);
const gchar* unity_browser_service_impl_get_dbus_path (UnityBrowserServiceImpl* self);
static Unity_BrowsingState* _vala_array_dup12 (Unity_BrowsingState* self, int length);
static void unity_browser_service_impl_finalize (GObject* obj);
static void _vala_unity_browser_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_browser_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_browser_get_type (void) G_GNUC_CONST;
gpointer unity_stack_ref (gpointer instance);
void unity_stack_unref (gpointer instance);
GParamSpec* unity_param_spec_stack (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_value_set_stack (GValue* value, gpointer v_object);
void unity_value_take_stack (GValue* value, gpointer v_object);
gpointer unity_value_get_stack (const GValue* value);
GType unity_stack_get_type (void) G_GNUC_CONST;
gpointer unity_state_ref (gpointer instance);
void unity_state_unref (gpointer instance);
GParamSpec* unity_param_spec_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_value_set_state (GValue* value, gpointer v_object);
void unity_value_take_state (GValue* value, gpointer v_object);
gpointer unity_value_get_state (const GValue* value);
GType unity_state_get_type (void) G_GNUC_CONST;
#define UNITY_BROWSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_BROWSER, UnityBrowserPrivate))
enum  {
	UNITY_BROWSER_DUMMY_PROPERTY,
	UNITY_BROWSER_E_TYPE,
	UNITY_BROWSER_E_DUP_FUNC,
	UNITY_BROWSER_E_DESTROY_FUNC,
	UNITY_BROWSER_DBUS_PATH
};
UnityBrowser* unity_browser_new (GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func, const gchar* dbus_path);
UnityBrowser* unity_browser_construct (GType object_type, GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func, const gchar* dbus_path);
static void unity_browser_set_dbus_path (UnityBrowser* self, const gchar* value);
UnityStack* unity_stack_new (GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func);
UnityStack* unity_stack_construct (GType object_type, GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func);
void unity_browser_go_back (UnityBrowser* self);
static void _unity_browser_go_back_unity_browser_service_impl_back (UnityBrowserServiceImpl* _sender, gpointer self);
void unity_browser_go_forward (UnityBrowser* self);
static void _unity_browser_go_forward_unity_browser_service_impl_forward (UnityBrowserServiceImpl* _sender, gpointer self);
static void unity_browser_update_service_state (UnityBrowser* self);
void unity_browser_record_state (UnityBrowser* self, gconstpointer state, const gchar* comment);
UnityStack* unity_stack_push (UnityStack* self, gconstpointer element);
UnityState* unity_state_new (GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func);
UnityState* unity_state_construct (GType object_type, GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func);
void unity_browser_clear (UnityBrowser* self);
void unity_stack_clear (UnityStack* self);
gpointer unity_stack_pop (UnityStack* self);
gboolean unity_stack_is_empty (UnityStack* self);
gpointer unity_stack_peek (UnityStack* self);
UnityBrowserService* unity_browser_get_service (UnityBrowser* self);
const gchar* unity_browser_get_dbus_path (UnityBrowser* self);
static void g_cclosure_user_marshal_VOID__POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_browser_finalize (GObject* obj);
static void _vala_unity_browser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_browser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_STATE, UnityStatePrivate))
enum  {
	UNITY_STATE_DUMMY_PROPERTY
};
static void unity_state_finalize (UnityState* obj);
#define UNITY_STACK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_STACK, UnityStackPrivate))
enum  {
	UNITY_STACK_DUMMY_PROPERTY
};
gint unity_stack_size (UnityStack* self);
static void unity_stack_finalize (UnityStack* obj);

static const GDBusArgInfo _unity_browser_service_dbus_arg_info_go_back_result = {-1, "result", "a(bs)"};
static const GDBusArgInfo * const _unity_browser_service_dbus_arg_info_go_back_in[] = {NULL};
static const GDBusArgInfo * const _unity_browser_service_dbus_arg_info_go_back_out[] = {&_unity_browser_service_dbus_arg_info_go_back_result, NULL};
static const GDBusMethodInfo _unity_browser_service_dbus_method_info_go_back = {-1, "GoBack", (GDBusArgInfo **) (&_unity_browser_service_dbus_arg_info_go_back_in), (GDBusArgInfo **) (&_unity_browser_service_dbus_arg_info_go_back_out)};
static const GDBusArgInfo _unity_browser_service_dbus_arg_info_go_forward_result = {-1, "result", "a(bs)"};
static const GDBusArgInfo * const _unity_browser_service_dbus_arg_info_go_forward_in[] = {NULL};
static const GDBusArgInfo * const _unity_browser_service_dbus_arg_info_go_forward_out[] = {&_unity_browser_service_dbus_arg_info_go_forward_result, NULL};
static const GDBusMethodInfo _unity_browser_service_dbus_method_info_go_forward = {-1, "GoForward", (GDBusArgInfo **) (&_unity_browser_service_dbus_arg_info_go_forward_in), (GDBusArgInfo **) (&_unity_browser_service_dbus_arg_info_go_forward_out)};
static const GDBusArgInfo _unity_browser_service_dbus_arg_info_get_state_result = {-1, "result", "a(bs)"};
static const GDBusArgInfo * const _unity_browser_service_dbus_arg_info_get_state_in[] = {NULL};
static const GDBusArgInfo * const _unity_browser_service_dbus_arg_info_get_state_out[] = {&_unity_browser_service_dbus_arg_info_get_state_result, NULL};
static const GDBusMethodInfo _unity_browser_service_dbus_method_info_get_state = {-1, "GetState", (GDBusArgInfo **) (&_unity_browser_service_dbus_arg_info_get_state_in), (GDBusArgInfo **) (&_unity_browser_service_dbus_arg_info_get_state_out)};
static const GDBusMethodInfo * const _unity_browser_service_dbus_method_info[] = {&_unity_browser_service_dbus_method_info_go_back, &_unity_browser_service_dbus_method_info_go_forward, &_unity_browser_service_dbus_method_info_get_state, NULL};
static const GDBusSignalInfo * const _unity_browser_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _unity_browser_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_browser_service_dbus_interface_info = {-1, "com.canonical.Unity.PlaceBrowser", (GDBusMethodInfo **) (&_unity_browser_service_dbus_method_info), (GDBusSignalInfo **) (&_unity_browser_service_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_browser_service_dbus_property_info)};
static const GDBusInterfaceVTable _unity_browser_service_dbus_interface_vtable = {unity_browser_service_dbus_interface_method_call, unity_browser_service_dbus_interface_get_property, unity_browser_service_dbus_interface_set_property};

void unity__browsingstate_copy (const Unity_BrowsingState* self, Unity_BrowsingState* dest) {
	dest->sensitive = self->sensitive;
	dest->comment = g_strdup (self->comment);
}


void unity__browsingstate_destroy (Unity_BrowsingState* self) {
	_g_free0 ((*self).comment);
}


Unity_BrowsingState* unity__browsingstate_dup (const Unity_BrowsingState* self) {
	Unity_BrowsingState* dup;
	dup = g_new0 (Unity_BrowsingState, 1);
	unity__browsingstate_copy (self, dup);
	return dup;
}


void unity__browsingstate_free (Unity_BrowsingState* self) {
	unity__browsingstate_destroy (self);
	g_free (self);
}


GType unity__browsingstate_get_type (void) {
	static volatile gsize unity__browsingstate_type_id__volatile = 0;
	if (g_once_init_enter (&unity__browsingstate_type_id__volatile)) {
		GType unity__browsingstate_type_id;
		unity__browsingstate_type_id = g_boxed_type_register_static ("Unity_BrowsingState", (GBoxedCopyFunc) unity__browsingstate_dup, (GBoxedFreeFunc) unity__browsingstate_free);
		g_once_init_leave (&unity__browsingstate_type_id__volatile, unity__browsingstate_type_id);
	}
	return unity__browsingstate_type_id__volatile;
}


GType unity_browsing_op_get_type (void) {
	static volatile gsize unity_browsing_op_type_id__volatile = 0;
	if (g_once_init_enter (&unity_browsing_op_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_BROWSING_OP_BACK, "UNITY_BROWSING_OP_BACK", "back"}, {UNITY_BROWSING_OP_FORWARD, "UNITY_BROWSING_OP_FORWARD", "forward"}, {UNITY_BROWSING_OP_NUM_OPS, "UNITY_BROWSING_OP_NUM_OPS", "num-ops"}, {0, NULL, NULL}};
		GType unity_browsing_op_type_id;
		unity_browsing_op_type_id = g_enum_register_static ("UnityBrowsingOp", values);
		g_once_init_leave (&unity_browsing_op_type_id__volatile, unity_browsing_op_type_id);
	}
	return unity_browsing_op_type_id__volatile;
}


/**
     * Returns the new browsing state after the operation has been performed
     */
Unity_BrowsingState* unity_browser_service_go_back (UnityBrowserService* self, int* result_length1, GError** error) {
	return UNITY_BROWSER_SERVICE_GET_INTERFACE (self)->go_back (self, result_length1, error);
}


/**
     * Returns the new browsing state after the operation has been performed
     */
Unity_BrowsingState* unity_browser_service_go_forward (UnityBrowserService* self, int* result_length1, GError** error) {
	return UNITY_BROWSER_SERVICE_GET_INTERFACE (self)->go_forward (self, result_length1, error);
}


/**
     * Returns the current browsing state
     */
Unity_BrowsingState* unity_browser_service_get_state (UnityBrowserService* self, int* result_length1, GError** error) {
	return UNITY_BROWSER_SERVICE_GET_INTERFACE (self)->get_state (self, result_length1, error);
}


static void unity_browser_service_base_init (UnityBrowserServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
   * Private DBus interface for managing browsing states
   */
GType unity_browser_service_get_type (void) {
	static volatile gsize unity_browser_service_type_id__volatile = 0;
	if (g_once_init_enter (&unity_browser_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityBrowserServiceIface), (GBaseInitFunc) unity_browser_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_browser_service_type_id;
		unity_browser_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityBrowserService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_browser_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_browser_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) unity_browser_service_proxy_get_type);
		g_type_set_qdata (unity_browser_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.Unity.PlaceBrowser");
		g_type_set_qdata (unity_browser_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_browser_service_register_object);
		g_once_init_leave (&unity_browser_service_type_id__volatile, unity_browser_service_type_id);
	}
	return unity_browser_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityBrowserServiceProxy, unity_browser_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_TYPE_BROWSER_SERVICE, unity_browser_service_proxy_unity_browser_service_interface_init) )
static void unity_browser_service_proxy_class_init (UnityBrowserServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = unity_browser_service_proxy_g_signal;
}


static void unity_browser_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void unity_browser_service_proxy_init (UnityBrowserServiceProxy* self) {
}


static Unity_BrowsingState* unity_browser_service_proxy_go_back (UnityBrowserService* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	Unity_BrowsingState* _result;
	int _result_length1;
	GVariant* _tmp224_;
	Unity_BrowsingState* _tmp225_;
	int _tmp225__length;
	int _tmp225__size;
	int _tmp225__length1;
	GVariantIter _tmp226_;
	GVariant* _tmp227_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.PlaceBrowser", "GoBack");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp224_ = g_variant_iter_next_value (&_reply_iter);
	_tmp225_ = g_new (Unity_BrowsingState, 5);
	_tmp225__length = 0;
	_tmp225__size = 4;
	_tmp225__length1 = 0;
	g_variant_iter_init (&_tmp226_, _tmp224_);
	for (; (_tmp227_ = g_variant_iter_next_value (&_tmp226_)) != NULL; _tmp225__length1++) {
		Unity_BrowsingState _tmp228_;
		GVariantIter _tmp229_;
		GVariant* _tmp230_;
		GVariant* _tmp231_;
		if (_tmp225__size == _tmp225__length) {
			_tmp225__size = 2 * _tmp225__size;
			_tmp225_ = g_renew (Unity_BrowsingState, _tmp225_, _tmp225__size + 1);
		}
		g_variant_iter_init (&_tmp229_, _tmp227_);
		_tmp230_ = g_variant_iter_next_value (&_tmp229_);
		_tmp228_.sensitive = g_variant_get_boolean (_tmp230_);
		g_variant_unref (_tmp230_);
		_tmp231_ = g_variant_iter_next_value (&_tmp229_);
		_tmp228_.comment = g_variant_dup_string (_tmp231_, NULL);
		g_variant_unref (_tmp231_);
		_tmp225_[_tmp225__length++] = _tmp228_;
		g_variant_unref (_tmp227_);
	}
	_result_length1 = _tmp225__length1;
	_result = _tmp225_;
	g_variant_unref (_tmp224_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static Unity_BrowsingState* unity_browser_service_proxy_go_forward (UnityBrowserService* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	Unity_BrowsingState* _result;
	int _result_length1;
	GVariant* _tmp232_;
	Unity_BrowsingState* _tmp233_;
	int _tmp233__length;
	int _tmp233__size;
	int _tmp233__length1;
	GVariantIter _tmp234_;
	GVariant* _tmp235_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.PlaceBrowser", "GoForward");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp232_ = g_variant_iter_next_value (&_reply_iter);
	_tmp233_ = g_new (Unity_BrowsingState, 5);
	_tmp233__length = 0;
	_tmp233__size = 4;
	_tmp233__length1 = 0;
	g_variant_iter_init (&_tmp234_, _tmp232_);
	for (; (_tmp235_ = g_variant_iter_next_value (&_tmp234_)) != NULL; _tmp233__length1++) {
		Unity_BrowsingState _tmp236_;
		GVariantIter _tmp237_;
		GVariant* _tmp238_;
		GVariant* _tmp239_;
		if (_tmp233__size == _tmp233__length) {
			_tmp233__size = 2 * _tmp233__size;
			_tmp233_ = g_renew (Unity_BrowsingState, _tmp233_, _tmp233__size + 1);
		}
		g_variant_iter_init (&_tmp237_, _tmp235_);
		_tmp238_ = g_variant_iter_next_value (&_tmp237_);
		_tmp236_.sensitive = g_variant_get_boolean (_tmp238_);
		g_variant_unref (_tmp238_);
		_tmp239_ = g_variant_iter_next_value (&_tmp237_);
		_tmp236_.comment = g_variant_dup_string (_tmp239_, NULL);
		g_variant_unref (_tmp239_);
		_tmp233_[_tmp233__length++] = _tmp236_;
		g_variant_unref (_tmp235_);
	}
	_result_length1 = _tmp233__length1;
	_result = _tmp233_;
	g_variant_unref (_tmp232_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static Unity_BrowsingState* unity_browser_service_proxy_get_state (UnityBrowserService* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	Unity_BrowsingState* _result;
	int _result_length1;
	GVariant* _tmp240_;
	Unity_BrowsingState* _tmp241_;
	int _tmp241__length;
	int _tmp241__size;
	int _tmp241__length1;
	GVariantIter _tmp242_;
	GVariant* _tmp243_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.Unity.PlaceBrowser", "GetState");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp240_ = g_variant_iter_next_value (&_reply_iter);
	_tmp241_ = g_new (Unity_BrowsingState, 5);
	_tmp241__length = 0;
	_tmp241__size = 4;
	_tmp241__length1 = 0;
	g_variant_iter_init (&_tmp242_, _tmp240_);
	for (; (_tmp243_ = g_variant_iter_next_value (&_tmp242_)) != NULL; _tmp241__length1++) {
		Unity_BrowsingState _tmp244_;
		GVariantIter _tmp245_;
		GVariant* _tmp246_;
		GVariant* _tmp247_;
		if (_tmp241__size == _tmp241__length) {
			_tmp241__size = 2 * _tmp241__size;
			_tmp241_ = g_renew (Unity_BrowsingState, _tmp241_, _tmp241__size + 1);
		}
		g_variant_iter_init (&_tmp245_, _tmp243_);
		_tmp246_ = g_variant_iter_next_value (&_tmp245_);
		_tmp244_.sensitive = g_variant_get_boolean (_tmp246_);
		g_variant_unref (_tmp246_);
		_tmp247_ = g_variant_iter_next_value (&_tmp245_);
		_tmp244_.comment = g_variant_dup_string (_tmp247_, NULL);
		g_variant_unref (_tmp247_);
		_tmp241_[_tmp241__length++] = _tmp244_;
		g_variant_unref (_tmp243_);
	}
	_result_length1 = _tmp241__length1;
	_result = _tmp241_;
	g_variant_unref (_tmp240_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void unity_browser_service_proxy_unity_browser_service_interface_init (UnityBrowserServiceIface* iface) {
	iface->go_back = unity_browser_service_proxy_go_back;
	iface->go_forward = unity_browser_service_proxy_go_forward;
	iface->get_state = unity_browser_service_proxy_get_state;
}


static void _vala_Unity_BrowsingState_array_free (Unity_BrowsingState* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			unity__browsingstate_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_unity_browser_service_go_back (UnityBrowserService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	Unity_BrowsingState* result;
	int result_length1 = 0;
	Unity_BrowsingState* _tmp248_;
	GVariantBuilder _tmp249_;
	int _tmp250_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = unity_browser_service_go_back (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp248_ = result;
	g_variant_builder_init (&_tmp249_, G_VARIANT_TYPE ("a(bs)"));
	for (_tmp250_ = 0; _tmp250_ < result_length1; _tmp250_++) {
		GVariantBuilder _tmp251_;
		g_variant_builder_init (&_tmp251_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp251_, g_variant_new_boolean ((*_tmp248_).sensitive));
		g_variant_builder_add_value (&_tmp251_, g_variant_new_string ((*_tmp248_).comment));
		g_variant_builder_add_value (&_tmp249_, g_variant_builder_end (&_tmp251_));
		_tmp248_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp249_));
	 result = (_vala_Unity_BrowsingState_array_free ( result,  result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_browser_service_go_forward (UnityBrowserService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	Unity_BrowsingState* result;
	int result_length1 = 0;
	Unity_BrowsingState* _tmp252_;
	GVariantBuilder _tmp253_;
	int _tmp254_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = unity_browser_service_go_forward (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp252_ = result;
	g_variant_builder_init (&_tmp253_, G_VARIANT_TYPE ("a(bs)"));
	for (_tmp254_ = 0; _tmp254_ < result_length1; _tmp254_++) {
		GVariantBuilder _tmp255_;
		g_variant_builder_init (&_tmp255_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp255_, g_variant_new_boolean ((*_tmp252_).sensitive));
		g_variant_builder_add_value (&_tmp255_, g_variant_new_string ((*_tmp252_).comment));
		g_variant_builder_add_value (&_tmp253_, g_variant_builder_end (&_tmp255_));
		_tmp252_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp253_));
	 result = (_vala_Unity_BrowsingState_array_free ( result,  result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_browser_service_get_state (UnityBrowserService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	Unity_BrowsingState* result;
	int result_length1 = 0;
	Unity_BrowsingState* _tmp256_;
	GVariantBuilder _tmp257_;
	int _tmp258_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = unity_browser_service_get_state (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp256_ = result;
	g_variant_builder_init (&_tmp257_, G_VARIANT_TYPE ("a(bs)"));
	for (_tmp258_ = 0; _tmp258_ < result_length1; _tmp258_++) {
		GVariantBuilder _tmp259_;
		g_variant_builder_init (&_tmp259_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp259_, g_variant_new_boolean ((*_tmp256_).sensitive));
		g_variant_builder_add_value (&_tmp259_, g_variant_new_string ((*_tmp256_).comment));
		g_variant_builder_add_value (&_tmp257_, g_variant_builder_end (&_tmp259_));
		_tmp256_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp257_));
	 result = (_vala_Unity_BrowsingState_array_free ( result,  result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_browser_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GoBack") == 0) {
		_dbus_unity_browser_service_go_back (object, parameters, invocation);
	} else if (strcmp (method_name, "GoForward") == 0) {
		_dbus_unity_browser_service_go_forward (object, parameters, invocation);
	} else if (strcmp (method_name, "GetState") == 0) {
		_dbus_unity_browser_service_get_state (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_browser_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_browser_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint unity_browser_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_browser_service_dbus_interface_info), &_unity_browser_service_dbus_interface_vtable, data, _unity_browser_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _unity_browser_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


UnityBrowserServiceImpl* unity_browser_service_impl_construct (GType object_type, const gchar* dbus_path) {
	UnityBrowserServiceImpl * self = NULL;
	Unity_BrowsingState* _tmp0_ = NULL;
	Unity_BrowsingState* _tmp1_;
	gint _tmp1__length1;
	Unity_BrowsingState* _tmp2_;
	g_return_val_if_fail (dbus_path != NULL, NULL);
	self = (UnityBrowserServiceImpl*) g_object_new (object_type, NULL);
	unity_browser_service_impl_set_dbus_path (self, dbus_path);
	_tmp0_ = g_new0 (Unity_BrowsingState, UNITY_BROWSING_OP_NUM_OPS);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = UNITY_BROWSING_OP_NUM_OPS;
	_tmp2_ = _tmp1_;
	unity_browser_service_impl_set_browsing_state (self, _tmp2_, UNITY_BROWSING_OP_NUM_OPS);
	_tmp1_ = (_vala_Unity_BrowsingState_array_free (_tmp1_, _tmp1__length1), NULL);
	return self;
}


UnityBrowserServiceImpl* unity_browser_service_impl_new (const gchar* dbus_path) {
	return unity_browser_service_impl_construct (UNITY_TYPE_BROWSER_SERVICE_IMPL, dbus_path);
}


static Unity_BrowsingState* _vala_array_dup9 (Unity_BrowsingState* self, int length) {
	Unity_BrowsingState* result;
	int i;
	result = g_new0 (Unity_BrowsingState, length);
	for (i = 0; i < length; i++) {
		Unity_BrowsingState _tmp0_ = {0};
		unity__browsingstate_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static Unity_BrowsingState* unity_browser_service_impl_real_go_back (UnityBrowserService* base, int* result_length1, GError** error) {
	UnityBrowserServiceImpl * self;
	Unity_BrowsingState* result = NULL;
	Unity_BrowsingState* _tmp0_ = NULL;
	gint _tmp1_;
	Unity_BrowsingState* _tmp2_;
	Unity_BrowsingState* _tmp3_;
	Unity_BrowsingState* _tmp4_;
	self = (UnityBrowserServiceImpl*) base;
	g_signal_emit_by_name (self, "back");
	_tmp0_ = unity_browser_service_impl_get_browsing_state (self, &_tmp1_);
	_tmp2_ = (_tmp3_ = _tmp0_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup9 (_tmp3_, _tmp1_));
	_tmp4_ = _tmp2_;
	*result_length1 = _tmp1_;
	result = _tmp4_;
	return result;
}


static Unity_BrowsingState* _vala_array_dup10 (Unity_BrowsingState* self, int length) {
	Unity_BrowsingState* result;
	int i;
	result = g_new0 (Unity_BrowsingState, length);
	for (i = 0; i < length; i++) {
		Unity_BrowsingState _tmp0_ = {0};
		unity__browsingstate_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static Unity_BrowsingState* unity_browser_service_impl_real_go_forward (UnityBrowserService* base, int* result_length1, GError** error) {
	UnityBrowserServiceImpl * self;
	Unity_BrowsingState* result = NULL;
	Unity_BrowsingState* _tmp0_ = NULL;
	gint _tmp1_;
	Unity_BrowsingState* _tmp2_;
	Unity_BrowsingState* _tmp3_;
	Unity_BrowsingState* _tmp4_;
	self = (UnityBrowserServiceImpl*) base;
	g_signal_emit_by_name (self, "forward");
	_tmp0_ = unity_browser_service_impl_get_browsing_state (self, &_tmp1_);
	_tmp2_ = (_tmp3_ = _tmp0_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup10 (_tmp3_, _tmp1_));
	_tmp4_ = _tmp2_;
	*result_length1 = _tmp1_;
	result = _tmp4_;
	return result;
}


static Unity_BrowsingState* _vala_array_dup11 (Unity_BrowsingState* self, int length) {
	Unity_BrowsingState* result;
	int i;
	result = g_new0 (Unity_BrowsingState, length);
	for (i = 0; i < length; i++) {
		Unity_BrowsingState _tmp0_ = {0};
		unity__browsingstate_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static Unity_BrowsingState* unity_browser_service_impl_real_get_state (UnityBrowserService* base, int* result_length1, GError** error) {
	UnityBrowserServiceImpl * self;
	Unity_BrowsingState* result = NULL;
	Unity_BrowsingState* _tmp0_ = NULL;
	gint _tmp1_;
	Unity_BrowsingState* _tmp2_;
	Unity_BrowsingState* _tmp3_;
	Unity_BrowsingState* _tmp4_;
	self = (UnityBrowserServiceImpl*) base;
	_tmp0_ = unity_browser_service_impl_get_browsing_state (self, &_tmp1_);
	_tmp2_ = (_tmp3_ = _tmp0_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup11 (_tmp3_, _tmp1_));
	_tmp4_ = _tmp2_;
	*result_length1 = _tmp1_;
	result = _tmp4_;
	return result;
}


const gchar* unity_browser_service_impl_get_dbus_path (UnityBrowserServiceImpl* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dbus_path;
	return result;
}


static void unity_browser_service_impl_set_dbus_path (UnityBrowserServiceImpl* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_dbus_path = _tmp0_;
	g_object_notify ((GObject *) self, "dbus-path");
}


Unity_BrowsingState* unity_browser_service_impl_get_browsing_state (UnityBrowserServiceImpl* self, int* result_length1) {
	Unity_BrowsingState* result;
	Unity_BrowsingState* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_browsing_state;
	*result_length1 = self->priv->_browsing_state_length1;
	result = _tmp0_;
	return result;
}


static Unity_BrowsingState* _vala_array_dup12 (Unity_BrowsingState* self, int length) {
	Unity_BrowsingState* result;
	int i;
	result = g_new0 (Unity_BrowsingState, length);
	for (i = 0; i < length; i++) {
		Unity_BrowsingState _tmp0_ = {0};
		unity__browsingstate_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void unity_browser_service_impl_set_browsing_state (UnityBrowserServiceImpl* self, Unity_BrowsingState* value, int value_length1) {
	Unity_BrowsingState* _tmp0_;
	Unity_BrowsingState* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup12 (_tmp1_, value_length1));
	self->priv->_browsing_state = (_vala_Unity_BrowsingState_array_free (self->priv->_browsing_state, self->priv->_browsing_state_length1), NULL);
	self->priv->_browsing_state = _tmp0_;
	self->priv->_browsing_state_length1 = value_length1;
	self->priv->__browsing_state_size_ = value_length1;
}


static void unity_browser_service_impl_class_init (UnityBrowserServiceImplClass * klass) {
	unity_browser_service_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityBrowserServiceImplPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_browser_service_impl_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_browser_service_impl_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_browser_service_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_BROWSER_SERVICE_IMPL_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("back", UNITY_TYPE_BROWSER_SERVICE_IMPL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("forward", UNITY_TYPE_BROWSER_SERVICE_IMPL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_browser_service_impl_unity_browser_service_interface_init (UnityBrowserServiceIface * iface) {
	unity_browser_service_impl_unity_browser_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->go_back = (Unity_BrowsingState* (*)(UnityBrowserService* ,int* ,GError**)) unity_browser_service_impl_real_go_back;
	iface->go_forward = (Unity_BrowsingState* (*)(UnityBrowserService* ,int* ,GError**)) unity_browser_service_impl_real_go_forward;
	iface->get_state = (Unity_BrowsingState* (*)(UnityBrowserService* ,int* ,GError**)) unity_browser_service_impl_real_get_state;
}


static void unity_browser_service_impl_instance_init (UnityBrowserServiceImpl * self) {
	self->priv = UNITY_BROWSER_SERVICE_IMPL_GET_PRIVATE (self);
}


static void unity_browser_service_impl_finalize (GObject* obj) {
	UnityBrowserServiceImpl * self;
	self = UNITY_BROWSER_SERVICE_IMPL (obj);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_browsing_state = (_vala_Unity_BrowsingState_array_free (self->priv->_browsing_state, self->priv->_browsing_state_length1), NULL);
	G_OBJECT_CLASS (unity_browser_service_impl_parent_class)->finalize (obj);
}


/**
   * Helper class to shield away the ugly DBus wire format
   */
GType unity_browser_service_impl_get_type (void) {
	static volatile gsize unity_browser_service_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_browser_service_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityBrowserServiceImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_browser_service_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityBrowserServiceImpl), 0, (GInstanceInitFunc) unity_browser_service_impl_instance_init, NULL };
		static const GInterfaceInfo unity_browser_service_info = { (GInterfaceInitFunc) unity_browser_service_impl_unity_browser_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_browser_service_impl_type_id;
		unity_browser_service_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityBrowserServiceImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_browser_service_impl_type_id, UNITY_TYPE_BROWSER_SERVICE, &unity_browser_service_info);
		g_once_init_leave (&unity_browser_service_impl_type_id__volatile, unity_browser_service_impl_type_id);
	}
	return unity_browser_service_impl_type_id__volatile;
}


static void _vala_unity_browser_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityBrowserServiceImpl * self;
	self = UNITY_BROWSER_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_BROWSER_SERVICE_IMPL_DBUS_PATH:
		g_value_set_string (value, unity_browser_service_impl_get_dbus_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_browser_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityBrowserServiceImpl * self;
	self = UNITY_BROWSER_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_BROWSER_SERVICE_IMPL_DBUS_PATH:
		unity_browser_service_impl_set_dbus_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _unity_browser_go_back_unity_browser_service_impl_back (UnityBrowserServiceImpl* _sender, gpointer self) {
	unity_browser_go_back (self);
}


static void _unity_browser_go_forward_unity_browser_service_impl_forward (UnityBrowserServiceImpl* _sender, gpointer self) {
	unity_browser_go_forward (self);
}


UnityBrowser* unity_browser_construct (GType object_type, GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func, const gchar* dbus_path) {
	UnityBrowser * self = NULL;
	UnityBrowserServiceImpl* _tmp0_ = NULL;
	UnityStack* _tmp1_ = NULL;
	UnityStack* _tmp2_ = NULL;
	g_return_val_if_fail (dbus_path != NULL, NULL);
	self = (UnityBrowser*) g_object_new (object_type, NULL);
	self->priv->e_type = e_type;
	self->priv->e_dup_func = e_dup_func;
	self->priv->e_destroy_func = e_destroy_func;
	unity_browser_set_dbus_path (self, dbus_path);
	_tmp0_ = unity_browser_service_impl_new (dbus_path);
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp0_;
	_tmp1_ = unity_stack_new (UNITY_TYPE_STATE, (GBoxedCopyFunc) unity_state_ref, unity_state_unref);
	_unity_stack_unref0 (self->priv->back_stack);
	self->priv->back_stack = _tmp1_;
	_tmp2_ = unity_stack_new (UNITY_TYPE_STATE, (GBoxedCopyFunc) unity_state_ref, unity_state_unref);
	_unity_stack_unref0 (self->priv->forward_stack);
	self->priv->forward_stack = _tmp2_;
	g_signal_connect_object (self->priv->service, "back", (GCallback) _unity_browser_go_back_unity_browser_service_impl_back, self, 0);
	g_signal_connect_object (self->priv->service, "forward", (GCallback) _unity_browser_go_forward_unity_browser_service_impl_forward, self, 0);
	unity_browser_update_service_state (self);
	return self;
}


UnityBrowser* unity_browser_new (GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func, const gchar* dbus_path) {
	return unity_browser_construct (UNITY_TYPE_BROWSER, e_type, e_dup_func, e_destroy_func, dbus_path);
}


/**
     * Use this method to track a state (and associated comment) in
     * the back/forward stacks
     */
static gpointer _unity_state_ref0 (gpointer self) {
	return self ? unity_state_ref (self) : NULL;
}


void unity_browser_record_state (UnityBrowser* self, gconstpointer state, const gchar* comment) {
	UnityState* _tmp2_ = NULL;
	UnityState* s;
	gpointer _tmp3_;
	gconstpointer _tmp4_;
	gchar* _tmp5_;
	UnityState* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	if (self->priv->current_state != NULL) {
		UnityStack* _tmp0_ = NULL;
		UnityStack* _tmp1_;
		_tmp0_ = unity_stack_push (self->priv->back_stack, self->priv->current_state);
		_tmp1_ = _tmp0_;
		_unity_stack_unref0 (_tmp1_);
	}
	_tmp2_ = unity_state_new (self->priv->e_type, (GBoxedCopyFunc) self->priv->e_dup_func, self->priv->e_destroy_func);
	s = _tmp2_;
	_tmp3_ = (_tmp4_ = state, ((_tmp4_ == NULL) || (self->priv->e_dup_func == NULL)) ? ((gpointer) _tmp4_) : self->priv->e_dup_func ((gpointer) _tmp4_));
	((s->state == NULL) || (self->priv->e_destroy_func == NULL)) ? NULL : (s->state = (self->priv->e_destroy_func (s->state), NULL));
	s->state = _tmp3_;
	_tmp5_ = g_strdup (comment);
	_g_free0 (s->comment);
	s->comment = _tmp5_;
	_tmp6_ = _unity_state_ref0 (s);
	_unity_state_unref0 (self->priv->current_state);
	self->priv->current_state = _tmp6_;
	unity_browser_update_service_state (self);
	_unity_state_unref0 (s);
}


void unity_browser_clear (UnityBrowser* self) {
	g_return_if_fail (self != NULL);
	unity_stack_clear (self->priv->back_stack);
	unity_stack_clear (self->priv->forward_stack);
	_unity_state_unref0 (self->priv->current_state);
	self->priv->current_state = NULL;
}


void unity_browser_go_back (UnityBrowser* self) {
	gpointer _tmp0_ = NULL;
	UnityState* state;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_stack_pop (self->priv->back_stack);
	state = (UnityState*) _tmp0_;
	if (state != NULL) {
		UnityState* _tmp3_;
		if (self->priv->current_state != NULL) {
			UnityStack* _tmp1_ = NULL;
			UnityStack* _tmp2_;
			_tmp1_ = unity_stack_push (self->priv->forward_stack, self->priv->current_state);
			_tmp2_ = _tmp1_;
			_unity_stack_unref0 (_tmp2_);
		}
		_tmp3_ = _unity_state_ref0 (state);
		_unity_state_unref0 (self->priv->current_state);
		self->priv->current_state = _tmp3_;
		unity_browser_update_service_state (self);
		g_signal_emit_by_name (self, "back", state->state, state->comment);
	}
	_unity_state_unref0 (state);
}


void unity_browser_go_forward (UnityBrowser* self) {
	gpointer _tmp0_ = NULL;
	UnityState* state;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_stack_pop (self->priv->forward_stack);
	state = (UnityState*) _tmp0_;
	if (state != NULL) {
		if (self->priv->current_state != NULL) {
			UnityStack* _tmp1_ = NULL;
			UnityStack* _tmp2_;
			_tmp1_ = unity_stack_push (self->priv->back_stack, self->priv->current_state);
			_tmp2_ = _tmp1_;
			_unity_stack_unref0 (_tmp2_);
		}
		unity_browser_update_service_state (self);
		g_signal_emit_by_name (self, "forward", state->state, state->comment);
	}
	_unity_state_unref0 (state);
}


static void unity_browser_update_service_state (UnityBrowser* self) {
	Unity_BrowsingState* _tmp0_ = NULL;
	gint _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	Unity_BrowsingState* _tmp7_ = NULL;
	gint _tmp8_;
	gchar* _tmp9_;
	Unity_BrowsingState* _tmp10_ = NULL;
	gint _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp14_;
	Unity_BrowsingState* _tmp17_ = NULL;
	gint _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_browser_service_impl_get_browsing_state (self->priv->service, &_tmp1_);
	_tmp2_ = unity_stack_is_empty (self->priv->back_stack);
	_tmp0_[UNITY_BROWSING_OP_BACK].sensitive = !_tmp2_;
	_tmp4_ = unity_stack_is_empty (self->priv->back_stack);
	if (_tmp4_) {
		_tmp3_ = "";
	} else {
		gpointer _tmp5_ = NULL;
		UnityState* _tmp6_;
		_tmp5_ = unity_stack_peek (self->priv->back_stack);
		_tmp6_ = (UnityState*) _tmp5_;
		_tmp3_ = _tmp6_->comment;
		_unity_state_unref0 (_tmp6_);
	}
	_tmp7_ = unity_browser_service_impl_get_browsing_state (self->priv->service, &_tmp8_);
	_tmp9_ = g_strdup (_tmp3_);
	_g_free0 (_tmp7_[UNITY_BROWSING_OP_BACK].comment);
	_tmp7_[UNITY_BROWSING_OP_BACK].comment = _tmp9_;
	_tmp10_ = unity_browser_service_impl_get_browsing_state (self->priv->service, &_tmp11_);
	_tmp12_ = unity_stack_is_empty (self->priv->forward_stack);
	_tmp10_[UNITY_BROWSING_OP_FORWARD].sensitive = !_tmp12_;
	_tmp14_ = unity_stack_is_empty (self->priv->forward_stack);
	if (_tmp14_) {
		_tmp13_ = "";
	} else {
		gpointer _tmp15_ = NULL;
		UnityState* _tmp16_;
		_tmp15_ = unity_stack_peek (self->priv->forward_stack);
		_tmp16_ = (UnityState*) _tmp15_;
		_tmp13_ = _tmp16_->comment;
		_unity_state_unref0 (_tmp16_);
	}
	_tmp17_ = unity_browser_service_impl_get_browsing_state (self->priv->service, &_tmp18_);
	_tmp19_ = g_strdup (_tmp13_);
	_g_free0 (_tmp17_[UNITY_BROWSING_OP_FORWARD].comment);
	_tmp17_[UNITY_BROWSING_OP_FORWARD].comment = _tmp19_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


UnityBrowserService* unity_browser_get_service (UnityBrowser* self) {
	UnityBrowserService* result = NULL;
	UnityBrowserService* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 ((UnityBrowserService*) self->priv->service);
	result = _tmp0_;
	return result;
}


const gchar* unity_browser_get_dbus_path (UnityBrowser* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dbus_path;
	return result;
}


static void unity_browser_set_dbus_path (UnityBrowser* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_dbus_path = _tmp0_;
	g_object_notify ((GObject *) self, "dbus-path");
}


static void g_cclosure_user_marshal_VOID__POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void unity_browser_class_init (UnityBrowserClass * klass) {
	unity_browser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityBrowserPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_browser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_browser_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_browser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_BROWSER_E_TYPE, g_param_spec_gtype ("e-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_BROWSER_E_DUP_FUNC, g_param_spec_pointer ("e-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_BROWSER_E_DESTROY_FUNC, g_param_spec_pointer ("e-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_BROWSER_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("back", UNITY_TYPE_BROWSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_STRING, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_STRING);
	g_signal_new ("forward", UNITY_TYPE_BROWSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_STRING, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_STRING);
}


static void unity_browser_instance_init (UnityBrowser * self) {
	self->priv = UNITY_BROWSER_GET_PRIVATE (self);
	self->priv->current_state = NULL;
}


static void unity_browser_finalize (GObject* obj) {
	UnityBrowser * self;
	self = UNITY_BROWSER (obj);
	_g_object_unref0 (self->priv->service);
	_unity_stack_unref0 (self->priv->back_stack);
	_unity_stack_unref0 (self->priv->forward_stack);
	_unity_state_unref0 (self->priv->current_state);
	_g_free0 (self->priv->_dbus_path);
	G_OBJECT_CLASS (unity_browser_parent_class)->finalize (obj);
}


/**
   * Manages the browsing state of a place entry. The browsing state is stored
   * as a generic type so this class can address a range of browsing contexts.
   *
   * You can monitor for back/forward navigation by listening to the
   * appropriate signals on the browser instance. When navigating into a
   * new state you should record the state in the Browser object by calling
   * browser.record_state(). Note that you should not record the state when
   * changing state because of back/forward signals. This is done automatically
   * by the browser instance.
   *
   * To actually expose this browsing mechanism for a place entry
   * set the 'browser' property of the EntryInfo instance to this and when
   * browsing is disabled entry_info.browser = null;.
   */
GType unity_browser_get_type (void) {
	static volatile gsize unity_browser_type_id__volatile = 0;
	if (g_once_init_enter (&unity_browser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityBrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityBrowser), 0, (GInstanceInitFunc) unity_browser_instance_init, NULL };
		GType unity_browser_type_id;
		unity_browser_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityBrowser", &g_define_type_info, 0);
		g_once_init_leave (&unity_browser_type_id__volatile, unity_browser_type_id);
	}
	return unity_browser_type_id__volatile;
}


static void _vala_unity_browser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityBrowser * self;
	self = UNITY_BROWSER (object);
	switch (property_id) {
		case UNITY_BROWSER_DBUS_PATH:
		g_value_set_string (value, unity_browser_get_dbus_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_browser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityBrowser * self;
	self = UNITY_BROWSER (object);
	switch (property_id) {
		case UNITY_BROWSER_DBUS_PATH:
		unity_browser_set_dbus_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case UNITY_BROWSER_E_TYPE:
		self->priv->e_type = g_value_get_gtype (value);
		break;
		case UNITY_BROWSER_E_DUP_FUNC:
		self->priv->e_dup_func = g_value_get_pointer (value);
		break;
		case UNITY_BROWSER_E_DESTROY_FUNC:
		self->priv->e_destroy_func = g_value_get_pointer (value);
		break;
	}
}


UnityState* unity_state_construct (GType object_type, GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func) {
	UnityState* self = NULL;
	self = (UnityState*) g_type_create_instance (object_type);
	self->priv->e_type = e_type;
	self->priv->e_dup_func = e_dup_func;
	self->priv->e_destroy_func = e_destroy_func;
	return self;
}


UnityState* unity_state_new (GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func) {
	return unity_state_construct (UNITY_TYPE_STATE, e_type, e_dup_func, e_destroy_func);
}


static void unity_value_state_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_value_state_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_state_unref (value->data[0].v_pointer);
	}
}


static void unity_value_state_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_value_state_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_value_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityState* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_value_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityState** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_param_spec_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityParamSpecState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_TYPE_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_value_get_state (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STATE), NULL);
	return value->data[0].v_pointer;
}


void unity_value_set_state (GValue* value, gpointer v_object) {
	UnityState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_state_unref (old);
	}
}


void unity_value_take_state (GValue* value, gpointer v_object) {
	UnityState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_state_unref (old);
	}
}


static void unity_state_class_init (UnityStateClass * klass) {
	unity_state_parent_class = g_type_class_peek_parent (klass);
	UNITY_STATE_CLASS (klass)->finalize = unity_state_finalize;
	g_type_class_add_private (klass, sizeof (UnityStatePrivate));
}


static void unity_state_instance_init (UnityState * self) {
	self->priv = UNITY_STATE_GET_PRIVATE (self);
	self->state = NULL;
	self->comment = NULL;
	self->ref_count = 1;
}


static void unity_state_finalize (UnityState* obj) {
	UnityState * self;
	self = UNITY_STATE (obj);
	((self->state == NULL) || (self->priv->e_destroy_func == NULL)) ? NULL : (self->state = (self->priv->e_destroy_func (self->state), NULL));
	_g_free0 (self->comment);
}


GType unity_state_get_type (void) {
	static volatile gsize unity_state_type_id__volatile = 0;
	if (g_once_init_enter (&unity_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_value_state_init, unity_value_state_free_value, unity_value_state_copy_value, unity_value_state_peek_pointer, "p", unity_value_state_collect_value, "p", unity_value_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityState), 0, (GInstanceInitFunc) unity_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_state_type_id;
		unity_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_state_type_id__volatile, unity_state_type_id);
	}
	return unity_state_type_id__volatile;
}


gpointer unity_state_ref (gpointer instance) {
	UnityState* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_state_unref (gpointer instance) {
	UnityState* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


UnityStack* unity_stack_construct (GType object_type, GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func) {
	UnityStack* self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	self = (UnityStack*) g_type_create_instance (object_type);
	self->priv->e_type = e_type;
	self->priv->e_dup_func = e_dup_func;
	self->priv->e_destroy_func = e_destroy_func;
	_tmp0_ = gee_linked_list_new (e_type, (GBoxedCopyFunc) e_dup_func, e_destroy_func, NULL);
	_g_object_unref0 (self->priv->list);
	self->priv->list = _tmp0_;
	return self;
}


UnityStack* unity_stack_new (GType e_type, GBoxedCopyFunc e_dup_func, GDestroyNotify e_destroy_func) {
	return unity_stack_construct (UNITY_TYPE_STACK, e_type, e_dup_func, e_destroy_func);
}


static gpointer _unity_stack_ref0 (gpointer self) {
	return self ? unity_stack_ref (self) : NULL;
}


UnityStack* unity_stack_push (UnityStack* self, gconstpointer element) {
	UnityStack* result = NULL;
	UnityStack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	gee_deque_offer_head ((GeeDeque*) self->priv->list, element);
	_tmp0_ = _unity_stack_ref0 (self);
	result = _tmp0_;
	return result;
}


gpointer unity_stack_pop (UnityStack* self) {
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_deque_poll_head ((GeeDeque*) self->priv->list);
	result = _tmp0_;
	return result;
}


gpointer unity_stack_peek (UnityStack* self) {
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_deque_peek_head ((GeeDeque*) self->priv->list);
	result = _tmp0_;
	return result;
}


gint unity_stack_size (UnityStack* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->list);
	result = _tmp0_;
	return result;
}


void unity_stack_clear (UnityStack* self) {
	g_return_if_fail (self != NULL);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->list);
}


gboolean unity_stack_is_empty (UnityStack* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = unity_stack_size (self);
	result = _tmp0_ == 0;
	return result;
}


static void unity_value_stack_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_value_stack_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_stack_unref (value->data[0].v_pointer);
	}
}


static void unity_value_stack_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_stack_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_value_stack_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_value_stack_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityStack* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_stack_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_value_stack_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityStack** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_stack_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_param_spec_stack (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityParamSpecStack* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_TYPE_STACK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_value_get_stack (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STACK), NULL);
	return value->data[0].v_pointer;
}


void unity_value_set_stack (GValue* value, gpointer v_object) {
	UnityStack* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STACK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_STACK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_stack_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_stack_unref (old);
	}
}


void unity_value_take_stack (GValue* value, gpointer v_object) {
	UnityStack* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STACK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_STACK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_stack_unref (old);
	}
}


static void unity_stack_class_init (UnityStackClass * klass) {
	unity_stack_parent_class = g_type_class_peek_parent (klass);
	UNITY_STACK_CLASS (klass)->finalize = unity_stack_finalize;
	g_type_class_add_private (klass, sizeof (UnityStackPrivate));
}


static void unity_stack_instance_init (UnityStack * self) {
	self->priv = UNITY_STACK_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void unity_stack_finalize (UnityStack* obj) {
	UnityStack * self;
	self = UNITY_STACK (obj);
	_g_object_unref0 (self->priv->list);
}


/**
   * Private shim class to have a propor stack api
   */
GType unity_stack_get_type (void) {
	static volatile gsize unity_stack_type_id__volatile = 0;
	if (g_once_init_enter (&unity_stack_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_value_stack_init, unity_value_stack_free_value, unity_value_stack_copy_value, unity_value_stack_peek_pointer, "p", unity_value_stack_collect_value, "p", unity_value_stack_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityStack), 0, (GInstanceInitFunc) unity_stack_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_stack_type_id;
		unity_stack_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityStack", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_stack_type_id__volatile, unity_stack_type_id);
	}
	return unity_stack_type_id__volatile;
}


gpointer unity_stack_ref (gpointer instance) {
	UnityStack* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_stack_unref (gpointer instance) {
	UnityStack* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_STACK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



