/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-action-invoker.c
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */
#include <stdlib.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include <glib/gstdio.h>

#include <time.h>

#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/client.h>

static gchar *application = NULL;
const gchar *action = NULL;

static gboolean
quit_and_flush (gpointer user_data)
{
	while (g_main_context_pending (NULL))
		{
			g_main_context_iteration (NULL, TRUE);                                                                                
		}
	g_dbus_connection_flush_sync (g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, NULL), NULL, NULL);
	
	exit (0);
	
	return FALSE;
}

static gboolean
invoke_item (gpointer user_data)
{
  DbusmenuMenuitem *root;
  const GList *children;
  const GList *walk;
  gboolean found_application;
  
  root = (DbusmenuMenuitem *)user_data;

  children = dbusmenu_menuitem_get_children (root);
  
  found_application = FALSE;
  
  for (walk = children;
       walk != NULL;
       walk = walk->next)
    {
      DbusmenuMenuitem *child;
      
      const gchar *child_label;
	  const gchar *child_type;
      
      child = (DbusmenuMenuitem *)walk->data;

      child_label = dbusmenu_menuitem_property_get (child, "label");
	  child_type = dbusmenu_menuitem_property_get (child, "type");
	  
	  if (child_label == NULL)
		{
		  child_label = dbusmenu_menuitem_property_get (child, "indicator-label");
		}

	  if ((found_application == FALSE) && (g_strcmp0 (child_label, application) == 0) 
		  && (g_strcmp0 (child_type, "application-item") == 0))
		{
		  found_application = TRUE;
		  
		  if (action == NULL)
			{
			  printf("Invoking indicator item: %s\n", action);
			  dbusmenu_menuitem_handle_event (child, "clicked", NULL, time (NULL));
			  g_timeout_add (500, quit_and_flush, NULL);
			}
		}
	  else
		{
		  if ((found_application == TRUE) && (g_strcmp0 (child_type, "seperator") == 0))
			{
			  printf("No action found: %s for %s \n", action, application);
			  exit (1);
			}
		  else if ((found_application == TRUE) && (g_strcmp0 (child_label, action) == 0))
			{
			  printf("Invoking action item: %s\n", action);
			  dbusmenu_menuitem_handle_event (child, "clicked", NULL, time (NULL));
			  
			  g_timeout_add (500, quit_and_flush, NULL);
			  
			  return FALSE;
			}
		}
    }
  
  printf("No action found: %s for %s \n", action, application);
  exit (1);

  return FALSE;
}


static void
on_root_changed (DbusmenuClient *client,
				 DbusmenuMenuitem *newitem,
				 gpointer user_data)
{
  while (g_main_context_pending (NULL))
	{
	  g_main_context_iteration (NULL, TRUE);
	}
  g_timeout_add_seconds (1, invoke_item, newitem);
}

static void
make_client ()
{
  DbusmenuClient *client;
  
  client = dbusmenu_client_new ("com.canonical.indicator.messages", "/com/canonical/indicator/messages/menu");
  
  g_signal_connect (client, "root-changed",
					G_CALLBACK (on_root_changed),
					NULL);
  
}


gint
main (gint argc, gchar **argv)
{
  if (argc == 2)
	{
	  application = argv[1];
	  action = NULL;
	}
  else if (argc == 3)
	{
	  application = argv[1];
	  action = argv[2];
	}
  else
	{
	  g_printf ("Usage: indicator-action-invoker application (action?)");
	  exit (1);
	}
  
  g_type_init ();
  
  make_client ();
  
  g_main_loop_run (g_main_loop_new (NULL, FALSE));
  
  return 0;  
}
