/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-application-repository.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_APPLICATION_REPOSITORY_H
#define __UNITY_WEBAPPS_APPLICATION_REPOSITORY_H


#define UNITY_WEBAPPS_TYPE_APPLICATION_REPOSITORY              (unity_webapps_application_repository_get_type())
#define UNITY_WEBAPPS_APPLICATION_REPOSITORY(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_APPLICATION_REPOSITORY, UnityWebappsApplicationRepository))
#define UNITY_WEBAPPS_APPLICATION_REPOSITORY_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_APPLICATION_REPOSITORY, UnityWebappsApplicationRepositoryClass))
#define UNITY_WEBAPPS_IS_APPLICATION_REPOSITORY(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_APPLICATION_REPOSITORY))
#define UNITY_WEBAPPS_IS_APPLICATION_REPOSITORY_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_APPLICATION_REPOSITORY))
#define UNITY_WEBAPPS_APPLICATION_REPOSITORY_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_APPLICATION_REPOSITORY, UnityWebappsApplicationRepositoryClass))

#include "unity-webapps-available-application.h"

typedef struct _UnityWebappsApplicationRepositoryPrivate UnityWebappsApplicationRepositoryPrivate;

typedef struct _UnityWebappsApplicationRepository UnityWebappsApplicationRepository;

struct _UnityWebappsApplicationRepository {
	GObject object;

	UnityWebappsApplicationRepositoryPrivate *priv;
};

typedef struct _UnityWebappsApplicationRepositoryClass UnityWebappsApplicationRepositoryClass;

struct _UnityWebappsApplicationRepositoryClass
{
	GObjectClass parent_class;
};

typedef enum {
	UNITY_WEBAPPS_APPLICATION_STATUS_AVAILABLE,
	UNITY_WEBAPPS_APPLICATION_STATUS_INSTALLED,
	UNITY_WEBAPPS_APPLICATION_STATUS_UNRESOLVED
} UnityWebappsApplicationStatus;

GType unity_webapps_application_repository_get_type (void) G_GNUC_CONST;

UnityWebappsApplicationRepository *unity_webapps_application_repository_new_default ();

gboolean
unity_webapps_application_repository_prepare (UnityWebappsApplicationRepository *repository);

GList * unity_webapps_application_repository_resolve_url (UnityWebappsApplicationRepository *repository, const gchar *url);
gchar * unity_webapps_application_repository_resolve_url_as_json (UnityWebappsApplicationRepository *repository, const gchar *url);

UnityWebappsApplicationStatus
unity_webapps_application_repository_get_resolved_application_status (UnityWebappsApplicationRepository *repository, const gchar *application);
const gchar *
unity_webapps_application_repository_get_resolved_application_name (UnityWebappsApplicationRepository *repository,
																	const gchar *application);
const gchar *
unity_webapps_application_repository_get_resolved_application_domain (UnityWebappsApplicationRepository *repository,
																	  const gchar *application);

typedef void (*UnityWebappsApplicationRepositoryInstallCallback) (UnityWebappsApplicationRepository *repository, const gchar *name, UnityWebappsApplicationStatus status, gpointer user_data);

void
unity_webapps_application_repository_install_application (UnityWebappsApplicationRepository *repository, const gchar *name,
														  UnityWebappsApplicationRepositoryInstallCallback callback, gpointer user_data);

gchar *
unity_webapps_application_repository_get_userscript_contents (UnityWebappsApplicationRepository *repository, const gchar *name);

#endif
