/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-music-player-context.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_MUSIC_PLAYER_CONTEXT_H
#define __UNITY_WEBAPPS_MUSIC_PLAYER_CONTEXT_H

#include <unity.h>

typedef struct _UnityWebappsMusicPlayerContext UnityWebappsMusicPlayerContext;

#include "../unity-webapps-gen-music-player.h"

#include "unity-webapps-context-daemon.h"

#include "unity-webapps-dirs.h"

struct _UnityWebappsMusicPlayerContext {
	GDBusConnection *connection;
	UnityWebappsGenMusicPlayer *music_player_service_interface;
	
	gchar *desktop_name;
	gchar *canonical_name;
	gchar *label;
	
	UnityMusicPlayer *music_player;
	
	gchar *most_recent_client;
	
	GHashTable *playlist_names_by_id;
};

UnityWebappsMusicPlayerContext *unity_webapps_music_player_context_new (GDBusConnection *connection, const gchar *desktop_file_name, const gchar *canonical_name, const gchar *label);
void unity_webapps_music_player_context_free (UnityWebappsMusicPlayerContext *music_player_context);

#endif
