/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2010 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <libubuntuone/syncdaemon.h>

static void
display_download_cb (gpointer key, gpointer value, gpointer user_data)
{
	SyncdaemonDownload *item_data = (SyncdaemonDownload *) value;
	gint *count = (gint *) user_data;

	*count = *count + 1;
	g_print ("Download #%d:\n", *count);
	g_print ("\tPath:\t%s\n", item_data->path);
	g_print ("\tShare ID\t:%s\n", item_data->share_id);
	g_print ("\tNode ID:\t%s\n", item_data->node_id);
	g_print ("\tStatus:\t%d of %d bytes downloaded\n", item_data->n_bytes_read, item_data->deflated_size);
}

static gboolean
timeout_cb (gpointer user_data)
{
	GHashTable *downloads;
	gint count = 0;

	g_print ("\n*** GETTING DOWNLOADS ***\n");
	downloads = syncdaemon_get_current_downloads ();
	g_hash_table_foreach (downloads, (GHFunc) display_download_cb, &count);
	g_hash_table_destroy (downloads);

	return TRUE;
}

int
main (int argc, char *argv[])
{
	GMainLoop *main_loop;
	g_type_init ();

	g_timeout_add (3000, (GSourceFunc) timeout_cb, NULL);

	/* Run the main loop */
	main_loop = g_main_loop_new (NULL, FALSE);
	g_main_loop_run (main_loop);

	return 0;
}
