/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef QT_BAMF_LIST_MODELS_H
#define QT_BAMF_LIST_MODELS_H

// Thin wrappers around QList<T> inheriting from QObject.
// This is rendered necessary by QML’s type registration system
// (see http://doc.qt.nokia.com/4.7-snapshot/qdeclarativeengine.html).
// Note: the use of templates would save some boiler-plate code,
// unfortunately QObjects can’t be template classes.

#include <QtCore/QObject>
#include <QtCore/QList>

class __attribute__ ((visibility ("default"))) BamfUintList : public QObject
{
    Q_OBJECT

public:
    BamfUintList(const QList<uint> & list) : m_list(list) {}

    Q_INVOKABLE int size() const { return m_list.size(); }
    Q_INVOKABLE uint at(int i) const { return m_list.at(i); }

private:
    QList<uint> m_list;
};


class BamfView;
class __attribute__ ((visibility ("default"))) BamfViewList : public QObject
{
    Q_OBJECT

public:
    BamfViewList(const QList<BamfView *> & list) : m_list(list) {}

    Q_INVOKABLE int size() const { return m_list.size(); }
    Q_INVOKABLE BamfView * at(int i) const { return m_list.at(i); }

private:
    QList<BamfView *> m_list;
};


class BamfApplication;
class __attribute__ ((visibility ("default"))) BamfApplicationList : public QObject
{
    Q_OBJECT

public:
    BamfApplicationList(const QList<BamfApplication *> & list) : m_list(list) {}

    Q_INVOKABLE int size() const { return m_list.size(); }
    Q_INVOKABLE BamfApplication * at(int i) const { return m_list.at(i); }

private:
    QList<BamfApplication *> m_list;
};


class BamfWindow;
class __attribute__ ((visibility ("default"))) BamfWindowList : public QObject
{
    Q_OBJECT

public:
    BamfWindowList(const QList<BamfWindow *> & list) : m_list(list) {}

    Q_INVOKABLE int size() const { return m_list.size(); }
    Q_INVOKABLE BamfWindow * at(int i) const { return m_list.at(i); }

private:
    QList<BamfWindow *> m_list;
};

#endif

