static const ucschar hangul_keyboard_table_2[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:       exclamation mark               */
    0x0022,     /* 0x22 quotedbl:     quotation mark                 */
    0x0023,     /* 0x23 numbersign:   number sign                    */
    0x0024,     /* 0x24 dollar:       dollar sign                    */
    0x0025,     /* 0x25 percent:      percent sign                   */
    0x0026,     /* 0x26 ampersand:    ampersand                      */
    0x0027,     /* 0x27 apostrophe:   apostrophe                     */
    0x0028,     /* 0x28 parenleft:    left parenthesis               */
    0x0029,     /* 0x29 parenright:   right parenthesis              */
    0x002a,     /* 0x2A asterisk:     asterisk                       */
    0x002b,     /* 0x2B plus:         plus sign                      */
    0x002c,     /* 0x2C comma:        comma                          */
    0x002d,     /* 0x2D minus:        minus sign                     */
    0x002e,     /* 0x2E period:       period                         */
    0x002f,     /* 0x2F slash:        slash                          */
    0x0030,     /* 0x30 0:            0                              */
    0x0031,     /* 0x31 1:            1                              */
    0x0032,     /* 0x32 2:            2                              */
    0x0033,     /* 0x33 3:            3                              */
    0x0034,     /* 0x34 4:            4                              */
    0x0035,     /* 0x35 5:            5                              */
    0x0036,     /* 0x36 6:            6                              */
    0x0037,     /* 0x37 7:            7                              */
    0x0038,     /* 0x38 8:            8                              */
    0x0039,     /* 0x39 9:            9                              */
    0x003a,     /* 0x3A colon:        colon                          */
    0x003b,     /* 0x3B semicolon:    semicolon                      */
    0x003c,     /* 0x3C less:         less-than sign                 */
    0x003d,     /* 0x3D equal:        equals sign                    */
    0x003e,     /* 0x3E greater:      greater-than sign              */
    0x003f,     /* 0x3F question:     question mark                  */
    0x0040,     /* 0x40 at:           commercial at                  */
    0x1106,     /* 0x41 A:            choseong mieum                 */
    0x1172,     /* 0x42 B:            jungseong yu                   */
    0x110e,     /* 0x43 C:            choseong chieuch               */
    0x110b,     /* 0x44 D:            choseong ieung                 */
    0x1104,     /* 0x45 E:            choseong ssangtikeut           */
    0x1105,     /* 0x46 F:            choseong rieul                 */
    0x1112,     /* 0x47 G:            choseong hieuh                 */
    0x1169,     /* 0x48 H:            jungseong o                    */
    0x1163,     /* 0x49 I:            jungseong ya                   */
    0x1165,     /* 0x4A J:            jungseong eo                   */
    0x1161,     /* 0x4B K:            jungseong a                    */
    0x1175,     /* 0x4C L:            jungseong i                    */
    0x1173,     /* 0x4D M:            jungseong eu                   */
    0x116e,     /* 0x4E N:            jungseong u                    */
    0x1164,     /* 0x4F O:            jungseong yae                  */
    0x1168,     /* 0x50 P:            jungseong ye                   */
    0x1108,     /* 0x51 Q:            choseong ssangpieup            */
    0x1101,     /* 0x52 R:            choseong ssangkiyeok           */
    0x1102,     /* 0x53 S:            choseong nieun                 */
    0x110a,     /* 0x54 T:            choseong ssangsios             */
    0x1167,     /* 0x55 U:            jungseong yeo                  */
    0x1111,     /* 0x56 V:            choseong phieuph               */
    0x110d,     /* 0x57 W:            choseong ssangcieuc            */
    0x1110,     /* 0x58 X:            choseong thieuth               */
    0x116d,     /* 0x59 Y:            jungseong yo                   */
    0x110f,     /* 0x5A Z:            choseong khieukh               */
    0x005b,     /* 0x5B bracketleft:  left bracket                   */
    0x005c,     /* 0x5C backslash:    backslash                      */
    0x005d,     /* 0x5D bracketright: right bracket                  */
    0x005e,     /* 0x5E asciicircum:  circumflex accent              */
    0x005f,     /* 0x5F underscore:   underscore                     */
    0x0060,     /* 0x60 quoteleft:    grave accent                   */
    0x1106,     /* 0x61 a:            choseong  mieum                */
    0x1172,     /* 0x62 b:            jungseong yu                   */
    0x110e,     /* 0x63 c:            choseong  chieuch              */
    0x110b,     /* 0x64 d:            choseong  ieung                */
    0x1103,     /* 0x65 e:            choseong  tikeut               */
    0x1105,     /* 0x66 f:            choseong  rieul                */
    0x1112,     /* 0x67 g:            choseong  hieuh                */
    0x1169,     /* 0x68 h:            jungseong o                    */
    0x1163,     /* 0x69 i:            jungseong ya                   */
    0x1165,     /* 0x6A j:            jungseong eo                   */
    0x1161,     /* 0x6B k:            jungseong a                    */
    0x1175,     /* 0x6C l:            jungseong i                    */
    0x1173,     /* 0x6D m:            jungseong eu                   */
    0x116e,     /* 0x6E n:            jungseong u                    */
    0x1162,     /* 0x6F o:            jungseong ae                   */
    0x1166,     /* 0x70 p:            jungseong e                    */
    0x1107,     /* 0x71 q:            choseong  pieup                */
    0x1100,     /* 0x72 r:            choseong  kiyeok               */
    0x1102,     /* 0x73 s:            choseong  nieun                */
    0x1109,     /* 0x74 t:            choseong  sios                 */
    0x1167,     /* 0x75 u:            jungseong yeo                  */
    0x1111,     /* 0x76 v:            choseong  phieuph              */
    0x110c,     /* 0x77 w:            choseong  cieuc                */
    0x1110,     /* 0x78 x:            choseong  thieuth              */
    0x116d,     /* 0x79 y:            jungseong yo                   */
    0x110f,     /* 0x7A z:            choseong  khieukh              */
    0x007b,     /* 0x7B braceleft:    left brace                     */
    0x007c,     /* 0x7C bar:          vertical bar                   */
    0x007d,     /* 0x7D braceright:   right brace                    */
    0x007e,     /* 0x7E asciitilde:   tilde                          */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_32[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:         exclamation mark             */
    0x0022,     /* 0x22 quotedbl:       quotation mark               */
    0x0023,     /* 0x23 numbersign:     number sign                  */
    0x0024,     /* 0x24 dollar:         dollar sign                  */
    0x0025,     /* 0x25 percent:        percent sign                 */
    0x0026,     /* 0x26 ampersand:      ampersand                    */
    0x0027,     /* 0x27 apostrophe:     apostrophe                   */
    0x0028,     /* 0x28 parenleft:      left parenthesis             */
    0x0029,     /* 0x29 parenright:     right parenthesis            */
    0x002a,     /* 0x2A asterisk:       asterisk                     */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x002d,     /* 0x2D minus:          minus sign                   */
    0x002e,     /* 0x2E period:         period                       */
    0x002f,     /* 0x2F slash:          slash                        */
    0x0030,     /* 0x30 0:              0                            */
    0x0031,     /* 0x31 1:              1                            */
    0x0032,     /* 0x32 2:              2                            */
    0x0033,     /* 0x33 3:              3                            */
    0x0034,     /* 0x34 4:              4                            */
    0x0035,     /* 0x35 5:              5                            */
    0x0036,     /* 0x36 6:              6                            */
    0x0037,     /* 0x37 7:              7                            */
    0x0038,     /* 0x38 8:              8                            */
    0x0039,     /* 0x39 9:              9                            */
    0x003a,     /* 0x3A colon:          colon                        */
    0x003b,     /* 0x3B semicolon:      semicolon                    */
    0x003c,     /* 0x3C less:           less-than sign               */
    0x003d,     /* 0x3D equal:          equals sign                  */
    0x003e,     /* 0x3E greater:        greater-than sign            */
    0x003f,     /* 0x3F question:       question mark                */
    0x0040,     /* 0x40 at:             commercial at                */
    0x11b7,     /* 0x41 A:              jongseong mieum              */
    0x1172,     /* 0x42 B:              jungseong yu                 */
    0x11be,     /* 0x43 C:              jongseong chieuch            */
    0x11bc,     /* 0x44 D:              jongseong ieung              */
    0x11ae,     /* 0x45 E:              jongseong tikeut             */
    0x11af,     /* 0x46 F:              jongseong rieul              */
    0x11c2,     /* 0x47 G:              jongseong hieuh              */
    0x1169,     /* 0x48 H:              jungseong o                  */
    0x1163,     /* 0x49 I:              jungseong ya                 */
    0x1165,     /* 0x4A J:              jungseong eo                 */
    0x1161,     /* 0x4B K:              jungseong a                  */
    0x1175,     /* 0x4C L:              jungseong i                  */
    0x1173,     /* 0x4D M:              jungseong eu                 */
    0x116e,     /* 0x4E N:              jungseong u                  */
    0x1164,     /* 0x4F O:              jungseong yae                */
    0x1168,     /* 0x50 P:              jungseong ye                 */
    0x11b8,     /* 0x51 Q:              jongseong pieup              */
    0x11a8,     /* 0x52 R:              jongseong kiyeok             */
    0x11ab,     /* 0x53 S:              jongseong nieun              */
    0x11ba,     /* 0x54 T:              jongseong sios               */
    0x1167,     /* 0x55 U:              jungseong yeo                */
    0x11c1,     /* 0x56 V:              jongseong phieuph            */
    0x11bd,     /* 0x57 W:              jongseong cieuc              */
    0x11c0,     /* 0x58 X:              jongseong thieuth            */
    0x116d,     /* 0x59 Y:              jungseong yo                 */
    0x11bf,     /* 0x5A Z:              jongseong khieukh            */
    0x005b,     /* 0x5B bracketleft:    left bracket                 */
    0x005c,     /* 0x5C backslash:      backslash                    */
    0x005d,     /* 0x5D bracketright:   right bracket                */
    0x005e,     /* 0x5E asciicircum:    circumflex accent            */
    0x005f,     /* 0x5F underscore:     underscore                   */
    0x0060,     /* 0x60 quoteleft:      grave accent                 */
    0x1106,     /* 0x61 a:              choseong  mieum              */
    0x1172,     /* 0x62 b:              jungseong yu                 */
    0x110e,     /* 0x63 c:              choseong  chieuch            */
    0x110b,     /* 0x64 d:              choseong  ieung              */
    0x1103,     /* 0x65 e:              choseong  tikeut             */
    0x1105,     /* 0x66 f:              choseong  rieul              */
    0x1112,     /* 0x67 g:              choseong  hieuh              */
    0x1169,     /* 0x68 h:              jungseong o                  */
    0x1163,     /* 0x69 i:              jungseong ya                 */
    0x1165,     /* 0x6A j:              jungseong eo                 */
    0x1161,     /* 0x6B k:              jungseong a                  */
    0x1175,     /* 0x6C l:              jungseong i                  */
    0x1173,     /* 0x6D m:              jungseong eu                 */
    0x116e,     /* 0x6E n:              jungseong u                  */
    0x1162,     /* 0x6F o:              jungseong ae                 */
    0x1166,     /* 0x70 p:              jungseong e                  */
    0x1107,     /* 0x71 q:              choseong  pieup              */
    0x1100,     /* 0x72 r:              choseong  kiyeok             */
    0x1102,     /* 0x73 s:              choseong  nieun              */
    0x1109,     /* 0x74 t:              choseong  sios               */
    0x1167,     /* 0x75 u:              jungseong yeo                */
    0x1111,     /* 0x76 v:              choseong  phieuph            */
    0x110c,     /* 0x77 w:              choseong  cieuc              */
    0x1110,     /* 0x78 x:              choseong  thieuth            */
    0x116d,     /* 0x79 y:              jungseong yo                 */
    0x110f,     /* 0x7A z:              choseong  khieukh            */
    0x007b,     /* 0x7B braceleft:      left brace                   */
    0x007c,     /* 0x7C bar:            vertical bar                 */
    0x007d,     /* 0x7D braceright:     right brace                  */
    0x203b,     /* 0x7E asciitilde:     tilde                        */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_390[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x11bd,     /* 0x21 exclam:         jongseong cieuc              */
    0x0022,     /* 0x22 quotedbl:       quotatioin mark              */
    0x0023,     /* 0x23 numbersign:     number sign                  */
    0x0024,     /* 0x24 dollar:         dollar sign                  */
    0x0025,     /* 0x25 percent:        percent sign                 */
    0x0026,     /* 0x26 ampersand:      ampersand                    */
    0x1110,     /* 0x27 apostrophe:     choseong thieuth             */
    0x0028,     /* 0x28 parenleft:      left parenthesis             */
    0x0029,     /* 0x29 parenright:     right parenthesis            */
    0x002a,     /* 0x2A asterisk:       asterisk                     */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x002d,     /* 0x2D minus:          minus sign                   */
    0x002e,     /* 0x2E period:         period                       */
    0x1169,     /* 0x2F slash:          jungseong o                  */
    0x110f,     /* 0x30 0:              choseong  khieukh            */
    0x11c2,     /* 0x31 1:              jongseong hieuh              */
    0x11bb,     /* 0x32 2:              jongseong ssangsios          */
    0x11b8,     /* 0x33 3:              jongseong pieup              */
    0x116d,     /* 0x34 4:              jungseong yo                 */
    0x1172,     /* 0x35 5:              jungseong yu                 */
    0x1163,     /* 0x36 6:              jungseong ya                 */
    0x1168,     /* 0x37 7:              jungseong ye                 */
    0x1174,     /* 0x38 8:              jungseong yi                 */
    0x116e,     /* 0x39 9:              jungseong u                  */
    0x003a,     /* 0x3A colon:          colon                        */
    0x1107,     /* 0x3B semicolon:      choseong  pieup              */
    0x0032,     /* 0x3C less:           2                            */
    0x003d,     /* 0x3D equal:          euals sign                   */
    0x0033,     /* 0x3E greater:        3                            */
    0x003f,     /* 0x3F question:       question mark                */
    0x0040,     /* 0x40 at:             commertial at                */
    0x11ae,     /* 0x41 A:              jongseong tikeut             */
    0x0021,     /* 0x42 B:              exclamation mark             */
    0x11b1,     /* 0x43 C:              jongseong rieul-mieum        */
    0x11b0,     /* 0x44 D:              jongseong rieul-kiyeok       */
    0x11bf,     /* 0x45 E:              jongseong khieukh            */
    0x11a9,     /* 0x46 F:              jongseong ssangkiyeok        */
    0x002f,     /* 0x47 G:              slash                        */
    0x0027,     /* 0x48 H:              apostrophe                   */
    0x0038,     /* 0x49 I:              8                            */
    0x0034,     /* 0x4A J:              4                            */
    0x0035,     /* 0x4B K:              5                            */
    0x0036,     /* 0x4C L:              6                            */
    0x0031,     /* 0x4D M:              1                            */
    0x0030,     /* 0x4E N:              0                            */
    0x0039,     /* 0x4F O:              9                            */
    0x003e,     /* 0x50 P:              greater-than sign            */
    0x11c1,     /* 0x51 Q:              jongseong phieuph            */
    0x1164,     /* 0x52 R:              jungseong yae                */
    0x11ad,     /* 0x53 S:              jongseong nieun-hieuh        */
    0x003b,     /* 0x54 T:              semicolon                    */
    0x0037,     /* 0x55 U:              7                            */
    0x11b6,     /* 0x56 V:              jongseong rieul-hieuh        */
    0x11c0,     /* 0x57 W:              jongseong thikeuth           */
    0x11b9,     /* 0x58 X:              jongseong pieup-sios         */
    0x003c,     /* 0x59 Y:              less-than sign               */
    0x11be,     /* 0x5A Z:              jongseong chieuch            */
    0x005b,     /* 0x5B bracketleft:    left bracket                 */
    0x005c,     /* 0x5C backslash:      backslash                    */
    0x005d,     /* 0x5D bracketright:   right bracket                */
    0x005e,     /* 0x5E asciicircum:    circumflex accent            */
    0x005f,     /* 0x5F underscore:     underscore                   */
    0x0060,     /* 0x60 quoteleft:      grave accent                 */
    0x11bc,     /* 0x61 a:              jongseong ieung              */
    0x116e,     /* 0x62 b:              jungseong u                  */
    0x1166,     /* 0x63 c:              jungseong e                  */
    0x1175,     /* 0x64 d:              jungseong i                  */
    0x1167,     /* 0x65 e:              jungseong yeo                */
    0x1161,     /* 0x66 f:              jungseong a                  */
    0x1173,     /* 0x67 g:              jungseong eu                 */
    0x1102,     /* 0x68 h:              choseong  nieun              */
    0x1106,     /* 0x69 i:              choseong  mieum              */
    0x110b,     /* 0x6A j:              choseong  ieung              */
    0x1100,     /* 0x6B k:              choseong  kiyeok             */
    0x110c,     /* 0x6C l:              choseong  cieuc              */
    0x1112,     /* 0x6D m:              choseong  hieuh              */
    0x1109,     /* 0x6E n:              choseong  sios               */
    0x110e,     /* 0x6F o:              choseong  chieuch            */
    0x1111,     /* 0x70 p:              choseong  phieuph            */
    0x11ba,     /* 0x71 q:              jongseong sios               */
    0x1162,     /* 0x72 r:              jungseong ae                 */
    0x11ab,     /* 0x73 s:              jongseong nieun              */
    0x1165,     /* 0x74 t:              jungseong eo                 */
    0x1103,     /* 0x75 u:              choseong  tikeut             */
    0x1169,     /* 0x76 v:              jungseong o                  */
    0x11af,     /* 0x77 w:              jongseong rieul              */
    0x11a8,     /* 0x78 x:              jongseong kiyeok             */
    0x1105,     /* 0x79 y:              choseong  rieul              */
    0x11b7,     /* 0x7A z:              jongseong mieum              */
    0x007b,     /* 0x7B braceleft:      left brace                   */
    0x007c,     /* 0x7C bar:            vertical line(bar)           */
    0x007d,     /* 0x7D braceright:     right brace                  */
    0x007e,     /* 0x7E asciitilde:     tilde                        */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_3final[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x11a9,     /* 0x21 exclam:         jongseong ssangkiyeok        */
    0x00b7,     /* 0x22 quotedbl:       middle dot                   */
    0x11bd,     /* 0x23 numbersign:     jognseong cieuc              */
    0x11b5,     /* 0x24 dollar:         jongseong rieul-phieuph      */
    0x11b4,     /* 0x25 percent:        jongseong rieul-thieuth      */
    0x201c,     /* 0x26 ampersand:      left double quotation mark   */
    0x1110,     /* 0x27 apostrophe:     choseong  thieuth            */
    0x0027,     /* 0x28 parenleft:      apostrophe                   */
    0x007e,     /* 0x29 parenright:     Tilde                        */
    0x201d,     /* 0x2A asterisk:       right double quotation mark  */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x0029,     /* 0x2D minus:          right parenthesis            */
    0x002e,     /* 0x2E period:         period                       */
    0x1169,     /* 0x2F slash:          jungseong o                  */
    0x110f,     /* 0x30 0:              choseong  khieukh            */
    0x11c2,     /* 0x31 1:              jongseong hieuh              */
    0x11bb,     /* 0x32 2:              jongseong ssangsios          */
    0x11b8,     /* 0x33 3:              jongseong pieup              */
    0x116d,     /* 0x34 4:              jungseong yo                 */
    0x1172,     /* 0x35 5:              jungseong yu                 */
    0x1163,     /* 0x36 6:              jungseong ya                 */
    0x1168,     /* 0x37 7:              jungseong ye                 */
    0x1174,     /* 0x38 8:              jungseong yi                 */
    0x116e,     /* 0x39 9:              jungseong u                  */
    0x0034,     /* 0x3A colon:          4                            */
    0x1107,     /* 0x3B semicolon:      choseong  pieup              */
    0x002c,     /* 0x3C less:           comma                        */
    0x003e,     /* 0x3D equal:          greater-than sign            */
    0x002e,     /* 0x3E greater:        period                       */
    0x0021,     /* 0x3F question:       exclamation mark             */
    0x11b0,     /* 0x40 at:             jongseong rieul-kiyeok       */
    0x11ae,     /* 0x41 A:              jongseong tikeut             */
    0x003f,     /* 0x42 B:              question mark                */
    0x11bf,     /* 0x43 C:              jongseong khieukh            */
    0x11b2,     /* 0x44 D:              jongseong rieul-pieup        */
    0x11ac,     /* 0x45 E:              jongseong nieun-cieuc        */
    0x11b1,     /* 0x46 F:              jongseong rieul-mieum        */
    0x1164,     /* 0x47 G:              jungseong yae                */
    0x0030,     /* 0x48 H:              0                            */
    0x0037,     /* 0x49 I:              7                            */
    0x0031,     /* 0x4A J:              1                            */
    0x0032,     /* 0x4B K:              2                            */
    0x0033,     /* 0x4C L:              3                            */
    0x0022,     /* 0x4D M:              double quotation mark        */
    0x002d,     /* 0x4E N:              minus sign                   */
    0x0038,     /* 0x4F O:              8                            */
    0x0039,     /* 0x50 P:              9                            */
    0x11c1,     /* 0x51 Q:              jongseong phieuph            */
    0x11b6,     /* 0x52 R:              jongseong rieul-hieuh        */
    0x11ad,     /* 0x53 S:              jongseong nieun-hieuh        */
    0x11b3,     /* 0x54 T:              jongseong rieul-sios         */
    0x0036,     /* 0x55 U:              6                            */
    0x11aa,     /* 0x56 V:              jongseong kiyeok-sios        */
    0x11c0,     /* 0x57 W:              jongseong thikeuth           */
    0x11b9,     /* 0x58 X:              jongseong pieup-sios         */
    0x0035,     /* 0x59 Y:              5                            */
    0x11be,     /* 0x5A Z:              jongseong chieuch            */
    0x0028,     /* 0x5B bracketleft:    left parenthesis             */
    0x003a,     /* 0x5C backslash:      colon                        */
    0x003c,     /* 0x5D bracketright:   less-than sign               */
    0x003d,     /* 0x5E asciicircum:    equals sign                  */
    0x003b,     /* 0x5F underscore:     semicolon                    */
    0x002a,     /* 0x60 quoteleft:      asterisk                     */
    0x11bc,     /* 0x61 a:              jongseong ieung              */
    0x116e,     /* 0x62 b:              jungseong u                  */
    0x1166,     /* 0x63 c:              jungseong e                  */
    0x1175,     /* 0x64 d:              jungseong i                  */
    0x1167,     /* 0x65 e:              jungseong yeo                */
    0x1161,     /* 0x66 f:              jungseong a                  */
    0x1173,     /* 0x67 g:              jungseong eu                 */
    0x1102,     /* 0x68 h:              choseong  nieun              */
    0x1106,     /* 0x69 i:              choseong  mieum              */
    0x110b,     /* 0x6A j:              choseong  ieung              */
    0x1100,     /* 0x6B k:              choseong  kiyeok             */
    0x110c,     /* 0x6C l:              choseong  cieuc              */
    0x1112,     /* 0x6D m:              choseong  hieuh              */
    0x1109,     /* 0x6E n:              choseong  sios               */
    0x110e,     /* 0x6F o:              choseong  chieuch            */
    0x1111,     /* 0x70 p:              choseong  phieuph            */
    0x11ba,     /* 0x71 q:              jongseong sios               */
    0x1162,     /* 0x72 r:              jungseong ae                 */
    0x11ab,     /* 0x73 s:              jongseong nieun              */
    0x1165,     /* 0x74 t:              jungseong eo                 */
    0x1103,     /* 0x75 u:              choseong  tikeut             */
    0x1169,     /* 0x76 v:              jungseong o                  */
    0x11af,     /* 0x77 w:              jongseong rieul              */
    0x11a8,     /* 0x78 x:              jongseong kiyeok             */
    0x1105,     /* 0x79 y:              choseong  rieul              */
    0x11b7,     /* 0x7A z:              jongseong mieum              */
    0x0025,     /* 0x7B braceleft:      percent sign                 */
    0x005c,     /* 0x7C bar:            backslash                    */
    0x002f,     /* 0x7D braceright:     slash                        */
    0x203b,     /* 0x7E asciitilde:     reference mark               */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_3sun[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:         exclamation mark             */
    0x0022,     /* 0x22 quotedbl:       quotatioin mark              */
    0x0023,     /* 0x23 numbersign:     number sign                  */
    0x0024,     /* 0x24 dollar:         dollar sign                  */
    0x0025,     /* 0x25 percent:        percent sign                 */
    0x0026,     /* 0x26 ampersand:      ampersand                    */
    0x1110,     /* 0x27 apostrophe:     choseong thieuth             */
    0x0028,     /* 0x28 parenleft:      left parenthesis             */
    0x0029,     /* 0x29 parenright:     right parenthesis            */
    0x002a,     /* 0x2A asterisk:       asterisk                     */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x11bd,     /* 0x2D minus:          jongseong cieuc              */
    0x002e,     /* 0x2E period:         period                       */
    0x11ae,     /* 0x2F slash:          jongseong tikeut             */
    0x1164,     /* 0x30 0:              choseong  yae                */
    0x11c2,     /* 0x31 1:              jongseong hieuh              */
    0x11bb,     /* 0x32 2:              jongseong ssangsios          */
    0x11b8,     /* 0x33 3:              jongseong pieup              */
    0x116d,     /* 0x34 4:              jungseong yo                 */
    0x1172,     /* 0x35 5:              jungseong yu                 */
    0x1163,     /* 0x36 6:              jungseong ya                 */
    0x1168,     /* 0x37 7:              jungseong ye                 */
    0x1174,     /* 0x38 8:              jungseong yi                 */
    0x110f,     /* 0x39 9:              choseong khieukh             */
    0x003a,     /* 0x3A colon:          colon                        */
    0x1107,     /* 0x3B semicolon:      choseong  pieup              */
    0x0032,     /* 0x3C less:           2                            */
    0x11be,     /* 0x3D equal:          jongseong chieuch            */
    0x0033,     /* 0x3E greater:        3                            */
    0x003f,     /* 0x3F question:       question mark                */
    0x0040,     /* 0x40 at:             commertial at                */
    0x11bc,     /* 0x41 A:              jongseong ieung              */
    0x0021,     /* 0x42 B:              exclamation mark             */
    0x005c,     /* 0x43 C:              backslash                    */
    0x005d,     /* 0x44 D:              right bracket                */
    0x1167,     /* 0x45 E:              jungseong yeo                */
    0x1161,     /* 0x46 F:              jungseong a                  */
    0x002f,     /* 0x47 G:              slash                        */
    0x0027,     /* 0x48 H:              apostrophe                   */
    0x0038,     /* 0x49 I:              8                            */
    0x0034,     /* 0x4A J:              4                            */
    0x0035,     /* 0x4B K:              5                            */
    0x0036,     /* 0x4C L:              6                            */
    0x0031,     /* 0x4D M:              1                            */
    0x0030,     /* 0x4E N:              0                            */
    0x0039,     /* 0x4F O:              9                            */
    0x003e,     /* 0x50 P:              greater-than sign            */
    0x11ba,     /* 0x51 Q:              jongseong sios               */
    0x1162,     /* 0x52 R:              jungseong ae                 */
    0x005b,     /* 0x53 S:              left bracket                 */
    0x003b,     /* 0x54 T:              semicolon                    */
    0x0037,     /* 0x55 U:              7                            */
    0x1169,     /* 0x56 V:              jungseong o                  */
    0x11af,     /* 0x57 W:              jongseong rieul              */
    0x003d,     /* 0x58 X:              equals sign                  */
    0x003c,     /* 0x59 Y:              less-than sign               */
    0x002d,     /* 0x5A Z:              minus sign                   */
    0x11c0,     /* 0x5B bracketleft:    jongseong thieuth            */
    0x11bf,     /* 0x5C backslash:      jongseong khieukh            */
    0x11c1,     /* 0x5D bracketright:   jongseong phieuph            */
    0x005e,     /* 0x5E asciicircum:    circumflex accent            */
    0x005f,     /* 0x5F underscore:     underscore                   */
    0x0060,     /* 0x60 quoteleft:      grave accent                 */
    0x11bc,     /* 0x61 a:              jongseong ieung              */
    0x116e,     /* 0x62 b:              jungseong u                  */
    0x1166,     /* 0x63 c:              jungseong e                  */
    0x1175,     /* 0x64 d:              jungseong i                  */
    0x1167,     /* 0x65 e:              jungseong yeo                */
    0x1161,     /* 0x66 f:              jungseong a                  */
    0x1173,     /* 0x67 g:              jungseong eu                 */
    0x1102,     /* 0x68 h:              choseong  nieun              */
    0x1106,     /* 0x69 i:              choseong  mieum              */
    0x110b,     /* 0x6A j:              choseong  ieung              */
    0x1100,     /* 0x6B k:              choseong  kiyeok             */
    0x110c,     /* 0x6C l:              choseong  cieuc              */
    0x1112,     /* 0x6D m:              choseong  hieuh              */
    0x1109,     /* 0x6E n:              choseong  sios               */
    0x110e,     /* 0x6F o:              choseong  chieuch            */
    0x1111,     /* 0x70 p:              choseong  phieuph            */
    0x11ba,     /* 0x71 q:              jongseong sios               */
    0x1162,     /* 0x72 r:              jungseong ae                 */
    0x11ab,     /* 0x73 s:              jongseong nieun              */
    0x1165,     /* 0x74 t:              jungseong eo                 */
    0x1103,     /* 0x75 u:              choseong  tikeut             */
    0x1169,     /* 0x76 v:              jungseong o                  */
    0x11af,     /* 0x77 w:              jongseong rieul              */
    0x11a8,     /* 0x78 x:              jongseong kiyeok             */
    0x1105,     /* 0x79 y:              choseong  rieul              */
    0x11b7,     /* 0x7A z:              jongseong mieum              */
    0x007b,     /* 0x7B braceleft:      left brace                   */
    0x007c,     /* 0x7C bar:            vertical line(bar)           */
    0x007d,     /* 0x7D braceright:     right brace                  */
    0x007e,     /* 0x7E asciitilde:     tilde                        */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_3yet[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x11bd,     /* 0x21 exclam:         jongseong cieuc              */
    0x0022,     /* 0x22 quotedbl:       quotatioin mark              */
    0x0023,     /* 0x23 numbersign:     number sign                  */
    0x0024,     /* 0x24 dollar:         dollar sign                  */
    0x0025,     /* 0x25 percent:        percent sign                 */
    0x0026,     /* 0x26 ampersand:      ampersand                    */
    0x1110,     /* 0x27 apostrophe:     choseong thieuth             */
    0x0028,     /* 0x28 parenleft:      left parenthesis             */
    0x0029,     /* 0x29 parenright:     right parenthesis            */
    0x002a,     /* 0x2A asterisk:       asterisk                     */
    0x002b,     /* 0x2B plus:           plus sign                    */
    0x002c,     /* 0x2C comma:          comma                        */
    0x002d,     /* 0x2D minus:          minus sign                   */
    0x002e,     /* 0x2E period:         period                       */
    0x1169,     /* 0x2F slash:          jungseong o                  */
    0x110f,     /* 0x30 0:              choseong  khieukh            */
    0x11c2,     /* 0x31 1:              jongseong hieuh              */
    0x11bb,     /* 0x32 2:              jongseong ssangsios          */
    0x11b8,     /* 0x33 3:              jongseong pieup              */
    0x116d,     /* 0x34 4:              jungseong yo                 */
    0x1172,     /* 0x35 5:              jungseong yu                 */
    0x1163,     /* 0x36 6:              jungseong ya                 */
    0x1168,     /* 0x37 7:              jungseong ye                 */
    0x1174,     /* 0x38 8:              jungseong yi                 */
    0x116e,     /* 0x39 9:              jungseong u                  */
    0x003a,     /* 0x3A colon:          colon                        */
    0x1107,     /* 0x3B semicolon:      choseong  pieup              */
    0x113c,     /* 0x3C less:           choseong chitueumsios        */
    0x003d,     /* 0x3D equal:          euals sign                   */
    0x113e,     /* 0x3E greater:        choseong ceongchieumsios     */
    0x003f,     /* 0x3F question:       question mark                */
    0x11eb,     /* 0x40 at:             jongseong pansios            */
    0x11ae,     /* 0x41 A:              jongseong tikeut             */
    0x116e,     /* 0x42 B:              jungseong u                  */
    0x11b1,     /* 0x43 C:              jongseong rieul-mieum        */
    0x11b0,     /* 0x44 D:              jongseong rieul-kiyeok       */
    0x11bf,     /* 0x45 E:              jongseong khieukh            */
    0x11a9,     /* 0x46 F:              jongseong ssangkiyeok        */
    0x119e,     /* 0x47 G:              jungseong araea              */
    0x1102,     /* 0x48 H:              choseong nieun               */
    0x1154,     /* 0x49 I:              choseong chitueumchieuch     */
    0x114c,     /* 0x4A J:              choseong yesieung            */
    0x114e,     /* 0x4B K:              choseong chitueumcieuc       */
    0x1150,     /* 0x4C L:              choseong ceongchieumcieuc    */
    0x1159,     /* 0x4D M:              choseong yeorinhieuh         */
    0x1140,     /* 0x4E N:              choseong pansios             */
    0x1155,     /* 0x4F O:              choseong ceongchieumchieuch  */
    0x1111,     /* 0x50 P:              choseong phieuph             */
    0x11c1,     /* 0x51 Q:              jongseong phieuph            */
    0x1164,     /* 0x52 R:              jungseong yae                */
    0x11ad,     /* 0x53 S:              jongseong nieun-hieuh        */
    0x1165,     /* 0x54 T:              jungseong eo                 */
    0x302e,     /* 0x55 U:              single dot tone mark         */
    0x11b6,     /* 0x56 V:              jongseong rieul-hieuh        */
    0x11c0,     /* 0x57 W:              jongseong thikeuth           */
    0x11b9,     /* 0x58 X:              jongseong pieup-sios         */
    0x302f,     /* 0x59 Y:              double dot tone mark         */
    0x11be,     /* 0x5A Z:              jongseong chieuch            */
    0x005b,     /* 0x5B bracketleft:    left bracket                 */
    0x005c,     /* 0x5C backslash:      backslash                    */
    0x005d,     /* 0x5D bracketright:   right bracket                */
    0x005e,     /* 0x5E asciicircum:    circumflex accent            */
    0x005f,     /* 0x5F underscore:     underscore                   */
    0x11f9,     /* 0x60 quoteleft:      jongseong yeorinhieuh        */
    0x11bc,     /* 0x61 a:              jongseong ieung              */
    0x116e,     /* 0x62 b:              jungseong u                  */
    0x1166,     /* 0x63 c:              jungseong e                  */
    0x1175,     /* 0x64 d:              jungseong i                  */
    0x1167,     /* 0x65 e:              jungseong yeo                */
    0x1161,     /* 0x66 f:              jungseong a                  */
    0x1173,     /* 0x67 g:              jungseong eu                 */
    0x1102,     /* 0x68 h:              choseong  nieun              */
    0x1106,     /* 0x69 i:              choseong  mieum              */
    0x110b,     /* 0x6A j:              choseong  ieung              */
    0x1100,     /* 0x6B k:              choseong  kiyeok             */
    0x110c,     /* 0x6C l:              choseong  cieuc              */
    0x1112,     /* 0x6D m:              choseong  hieuh              */
    0x1109,     /* 0x6E n:              choseong  sios               */
    0x110e,     /* 0x6F o:              choseong  chieuch            */
    0x1111,     /* 0x70 p:              choseong  phieuph            */
    0x11ba,     /* 0x71 q:              jongseong sios               */
    0x1162,     /* 0x72 r:              jungseong ae                 */
    0x11ab,     /* 0x73 s:              jongseong nieun              */
    0x1165,     /* 0x74 t:              jungseong eo                 */
    0x1103,     /* 0x75 u:              choseong  tikeut             */
    0x1169,     /* 0x76 v:              jungseong o                  */
    0x11af,     /* 0x77 w:              jongseong rieul              */
    0x11a8,     /* 0x78 x:              jongseong kiyeok             */
    0x1105,     /* 0x79 y:              choseong  rieul              */
    0x11b7,     /* 0x7A z:              jongseong mieum              */
    0x007b,     /* 0x7B braceleft:      left brace                   */
    0x007c,     /* 0x7C bar:            vertical line(bar)           */
    0x007d,     /* 0x7D braceright:     right brace                  */
    0x11f0,     /* 0x7E asciitilde:     jongseong yesieung           */
    0x0000      /* 0x7F delete                                       */
};

static const ucschar hangul_keyboard_table_romaja[] = {
    0x0000,     /* 0x00 null                                         */
    0x0000,     /* 0x01 start of heading                             */
    0x0000,     /* 0x02 start of text                                */
    0x0000,     /* 0x03 end of text                                  */
    0x0000,     /* 0x04 end of transmission                          */
    0x0000,     /* 0x05 enquiry                                      */
    0x0000,     /* 0x06 acknowledge                                  */
    0x0000,     /* 0x07 bell                                         */
    0x0000,     /* 0x08 backspace                                    */
    0x0000,     /* 0x09 character tabulation                         */
    0x0000,     /* 0x0A line feed (lf)                               */
    0x0000,     /* 0x0B line tabulation                              */
    0x0000,     /* 0x0C form feed (ff)                               */
    0x0000,     /* 0x0D carriage return (cr)                         */
    0x0000,     /* 0x0E shift out                                    */
    0x0000,     /* 0x0F shift in                                     */
    0x0000,     /* 0x10 data link escape                             */
    0x0000,     /* 0x11 device control one                           */
    0x0000,     /* 0x12 device control two                           */
    0x0000,     /* 0x13 device control three                         */
    0x0000,     /* 0x14 device control four                          */
    0x0000,     /* 0x15 negative acknowledge                         */
    0x0000,     /* 0x16 synchronous idle                             */
    0x0000,     /* 0x17 end of transmission block                    */
    0x0000,     /* 0x18 cancel                                       */
    0x0000,     /* 0x19 end of medium                                */
    0x0000,     /* 0x1A substitute                                   */
    0x0000,     /* 0x1B escape                                       */
    0x0000,     /* 0x1C information separator four                   */
    0x0000,     /* 0x1D information separator three                  */
    0x0000,     /* 0x1E information separator two                    */
    0x0000,     /* 0x1F information separator one                    */
    0x0000,     /* 0x20 space                                        */
    0x0021,     /* 0x21 exclam:       exclamation mark               */
    0x0022,     /* 0x22 quotedbl:     quotation mark                 */
    0x0023,     /* 0x23 numbersign:   number sign                    */
    0x0024,     /* 0x24 dollar:       dollar sign                    */
    0x0025,     /* 0x25 percent:      percent sign                   */
    0x0026,     /* 0x26 ampersand:    ampersand                      */
    0x0027,     /* 0x27 apostrophe:   apostrophe                     */
    0x0028,     /* 0x28 parenleft:    left parenthesis               */
    0x0029,     /* 0x29 parenright:   right parenthesis              */
    0x002a,     /* 0x2A asterisk:     asterisk                       */
    0x002b,     /* 0x2B plus:         plus sign                      */
    0x002c,     /* 0x2C comma:        comma                          */
    0x002d,     /* 0x2D minus:        minus sign                     */
    0x002e,     /* 0x2E period:       period                         */
    0x002f,     /* 0x2F slash:        slash                          */
    0x0030,     /* 0x30 0:            0                              */
    0x0031,     /* 0x31 1:            1                              */
    0x0032,     /* 0x32 2:            2                              */
    0x0033,     /* 0x33 3:            3                              */
    0x0034,     /* 0x34 4:            4                              */
    0x0035,     /* 0x35 5:            5                              */
    0x0036,     /* 0x36 6:            6                              */
    0x0037,     /* 0x37 7:            7                              */
    0x0038,     /* 0x38 8:            8                              */
    0x0039,     /* 0x39 9:            9                              */
    0x003a,     /* 0x3A colon:        colon                          */
    0x003b,     /* 0x3B semicolon:    semicolon                      */
    0x003c,     /* 0x3C less:         less-than sign                 */
    0x003d,     /* 0x3D equal:        equals sign                    */
    0x003e,     /* 0x3E greater:      greater-than sign              */
    0x003f,     /* 0x3F question:     question mark                  */
    0x0040,     /* 0x40 at:           commercial at                  */
    0x1161,     /* 0x41 A:            jungseong a                    */
    0x1107,     /* 0x42 B:            choseong  pieup                */
    0x110e,     /* 0x43 C:            choseong  chieuch              */
    0x1103,     /* 0x44 D:            choseong  tikeut               */
    0x1166,     /* 0x45 E:            jungseong e                    */
    0x1111,     /* 0x46 F:            choseong  phieuph              */
    0x1100,     /* 0x47 G:            choseong  kiyeok               */
    0x1112,     /* 0x48 H:            choseong  heiuh                */
    0x1175,     /* 0x49 I:            jungseong i                    */
    0x110c,     /* 0x4A J:            choseong  cieuc                */
    0x110f,     /* 0x4B K:            choseong  khieukh              */
    0x1105,     /* 0x4C L:            choseong  rieul                */
    0x1106,     /* 0x4D M:            choseong  mieum                */
    0x1102,     /* 0x4E N:            choseong  nieun                */
    0x1169,     /* 0x4F O:            jungseong o                    */
    0x1111,     /* 0x50 P:            choseong  phieuph              */
    0x110f,     /* 0x51 Q:            choseong  khieukh              */
    0x1105,     /* 0x52 R:            choseong  rieul                */
    0x1109,     /* 0x53 S:            choseong  sios                 */
    0x1110,     /* 0x54 T:            choseong  thieuth              */
    0x116e,     /* 0x55 U:            jungseong u                    */
    0x1107,     /* 0x56 V:            choseong  pieup                */
    0x116e,     /* 0x57 W:            jungseong u                    */
    0x110c,     /* 0x58 X:            choseong  cieuc                */
    0x1175,     /* 0x59 Y:            jungseong i                    */
    0x110c,     /* 0x5A Z:            choseong  cieuc                */
    0x005b,     /* 0x5B bracketleft:  left bracket                   */
    0x005c,     /* 0x5C backslash:    backslash                      */
    0x005d,     /* 0x5D bracketright: right bracket                  */
    0x005e,     /* 0x5E asciicircum:  circumflex accent              */
    0x005f,     /* 0x5F underscore:   underscore                     */
    0x0060,     /* 0x60 quoteleft:    grave accent                   */
    0x1161,     /* 0x61 a:            jungseong a                    */
    0x1107,     /* 0x62 b:            choseong  pieup                */
    0x110e,     /* 0x63 c:            choseong  chieuch              */
    0x1103,     /* 0x64 d:            choseong  tikeut               */
    0x1166,     /* 0x65 e:            jungseong e                    */
    0x1111,     /* 0x66 f:            choseong  phieuph              */
    0x1100,     /* 0x67 g:            choseong  kiyeok               */
    0x1112,     /* 0x68 h:            choseong  hieuh                */
    0x1175,     /* 0x69 i:            jungseong i                    */
    0x110c,     /* 0x6A j:            choseong  cieuc                */
    0x110f,     /* 0x6B k:            choseong  khieukh              */
    0x1105,     /* 0x6C l:            choseong  rieul                */
    0x1106,     /* 0x6D m:            choseong  mieum                */
    0x1102,     /* 0x6E n:            choseong  nieun                */
    0x1169,     /* 0x6F o:            jungseong o                    */
    0x1111,     /* 0x70 p:            choseong  pieup                */
    0x110f,     /* 0x71 q:            choseong  khieukh              */
    0x1105,     /* 0x72 r:            choseong  rieul                */
    0x1109,     /* 0x73 s:            choseong  sios                 */
    0x1110,     /* 0x74 t:            choseong  thieuth              */
    0x116e,     /* 0x75 u:            jungseong u                    */
    0x1107,     /* 0x76 v:            choseong  phieuph              */
    0x116e,     /* 0x77 w:            jungseong u                    */
    0x11aa,     /* 0x78 x:            jongseong kiyeoksios           */
    0x1175,     /* 0x79 y:            jungseong i                    */
    0x110c,     /* 0x7A z:            choseong  cieuc                */
    0x007b,     /* 0x7B braceleft:    left brace                     */
    0x007c,     /* 0x7C bar:          vertical bar                   */
    0x007d,     /* 0x7D braceright:   right brace                    */
    0x007e,     /* 0x7E asciitilde:   tilde                          */
    0x0000      /* 0x7F delete                                       */
};

static const HangulCombinationItem hangul_combination_table_default[] = {
  { 0x11001100, 0x1101 }, /* choseong  kiyeok + kiyeok  = ssangkiyeok   */
  { 0x11031103, 0x1104 }, /* choseong  tikeut + tikeut  = ssangtikeut   */
  { 0x11071107, 0x1108 }, /* choseong  pieup  + pieup   = ssangpieup    */
  { 0x11091109, 0x110a }, /* choseong  sios   + sios    = ssangsios     */
  { 0x110c110c, 0x110d }, /* choseong  cieuc  + cieuc   = ssangcieuc    */
  { 0x11691161, 0x116a }, /* jungseong o      + a       = wa            */
  { 0x11691162, 0x116b }, /* jungseong o      + ae      = wae           */
  { 0x11691175, 0x116c }, /* jungseong o      + i       = oe            */
  { 0x116e1165, 0x116f }, /* jungseong u      + eo      = weo           */
  { 0x116e1166, 0x1170 }, /* jungseong u      + e       = we            */
  { 0x116e1175, 0x1171 }, /* jungseong u      + i       = wi            */
  { 0x11731175, 0x1174 }, /* jungseong eu     + i       = yi            */
  { 0x11a811a8, 0x11a9 }, /* jongseong kiyeok + kiyeok  = ssangekiyeok  */
  { 0x11a811ba, 0x11aa }, /* jongseong kiyeok + sios    = kiyeok-sois   */
  { 0x11ab11bd, 0x11ac }, /* jongseong nieun  + cieuc   = nieun-cieuc   */
  { 0x11ab11c2, 0x11ad }, /* jongseong nieun  + hieuh   = nieun-hieuh   */
  { 0x11af11a8, 0x11b0 }, /* jongseong rieul  + kiyeok  = rieul-kiyeok  */
  { 0x11af11b7, 0x11b1 }, /* jongseong rieul  + mieum   = rieul-mieum   */
  { 0x11af11b8, 0x11b2 }, /* jongseong rieul  + pieup   = rieul-pieup   */
  { 0x11af11ba, 0x11b3 }, /* jongseong rieul  + sios    = rieul-sios    */
  { 0x11af11c0, 0x11b4 }, /* jongseong rieul  + thieuth = rieul-thieuth */
  { 0x11af11c1, 0x11b5 }, /* jongseong rieul  + phieuph = rieul-phieuph */
  { 0x11af11c2, 0x11b6 }, /* jongseong rieul  + hieuh   = rieul-hieuh   */
  { 0x11b811ba, 0x11b9 }, /* jongseong pieup  + sios    = pieup-sios    */
  { 0x11ba11ba, 0x11bb }, /* jongseong sios   + sios    = ssangsios     */
};

static const HangulCombinationItem hangul_combination_table_romaja[] = {
  { 0x11001100, 0x1101 }, /* choseong  kiyeok + kiyeok  = ssangkiyeok   */
  { 0x11031103, 0x1104 }, /* choseong  tikeut + tikeut  = ssangtikeut   */
  { 0x11071107, 0x1108 }, /* choseong  pieup  + pieup   = ssangpieup    */
  { 0x11091109, 0x110a }, /* choseong  sios   + sios    = ssangsios     */
  { 0x110c110c, 0x110d }, /* choseong  cieuc  + cieuc   = ssangcieuc    */
  { 0x110e1112, 0x110e }, /* choseong  chieuch+ hieuh   = chieuch       */
  { 0x11611166, 0x1162 }, /* jungseong a      + e       = ae            */
  { 0x11611175, 0x1162 }, /* jungseong a      + i       = ae            */
  { 0x11631166, 0x1164 }, /* jungseong ya     + e       = yae           */
  { 0x11631175, 0x1164 }, /* jungseong ya     + i       = yae           */
  { 0x11661169, 0x1165 }, /* jungseong e      + o       = eo            */
  { 0x1166116e, 0x1173 }, /* jungseong e      + u       = eu            */
  { 0x11681169, 0x1167 }, /* jungseong ye     + o       = yeo           */
  { 0x11691161, 0x116a }, /* jungseong o      + a       = wa            */
  { 0x11691162, 0x116b }, /* jungseong o      + ae      = wae           */
  { 0x11691175, 0x116c }, /* jungseong o      + i       = oe            */
  { 0x116a1166, 0x116b }, /* jungseong wa     + e       = wae           */
  { 0x116a1175, 0x116b }, /* jungseong wa     + i       = wae           */
  { 0x116e1161, 0x116a }, /* jungseong u      + a       = wa            */
  { 0x116e1165, 0x116f }, /* jungseong u      + eo      = weo           */
  { 0x116e1166, 0x1170 }, /* jungseong u      + e       = we            */
  { 0x116e1169, 0x116f }, /* jungseong u      + o       = weo           */
  { 0x116e1175, 0x1171 }, /* jungseong u      + i       = wi            */
  { 0x11701169, 0x116f }, /* jungseong we     + o       = weo           */
  { 0x11731175, 0x1174 }, /* jungseong eu     + i       = yi            */
  { 0x11751161, 0x1163 }, /* jungseong i      + a       = ya            */
  { 0x11751162, 0x1164 }, /* jungseong i      + ae      = yae           */
  { 0x11751165, 0x1167 }, /* jungseong i      + eo      = yeo           */
  { 0x11751166, 0x1168 }, /* jungseong i      + e       = ye            */
  { 0x11751169, 0x116d }, /* jungseong i      + o       = yo            */
  { 0x1175116e, 0x1172 }, /* jungseong i      + u       = yu            */
  { 0x11a811a8, 0x11a9 }, /* jongseong kiyeok + kiyeok  = ssangekiyeok  */
  { 0x11a811ba, 0x11aa }, /* jongseong kiyeok + sios    = kiyeok-sois   */
  { 0x11ab11a8, 0x11bc }, /* jongseong nieun  + kiyeok  = ieung         */
  { 0x11ab11bd, 0x11ac }, /* jongseong nieun  + cieuc   = nieun-cieuc   */
  { 0x11ab11c2, 0x11ad }, /* jongseong nieun  + hieuh   = nieun-hieuh   */
  { 0x11af11a8, 0x11b0 }, /* jongseong rieul  + kiyeok  = rieul-kiyeok  */
  { 0x11af11b7, 0x11b1 }, /* jongseong rieul  + mieum   = rieul-mieum   */
  { 0x11af11b8, 0x11b2 }, /* jongseong rieul  + pieup   = rieul-pieup   */
  { 0x11af11ba, 0x11b3 }, /* jongseong rieul  + sios    = rieul-sios    */
  { 0x11af11c0, 0x11b4 }, /* jongseong rieul  + thieuth = rieul-thieuth */
  { 0x11af11c1, 0x11b5 }, /* jongseong rieul  + phieuph = rieul-phieuph */
  { 0x11af11c2, 0x11b6 }, /* jongseong rieul  + hieuh   = rieul-hieuh   */
  { 0x11b811ba, 0x11b9 }, /* jongseong pieup  + sios    = pieup-sios    */
  { 0x11ba11ba, 0x11bb }, /* jongseong sios   + sios    = ssangsios     */
};

static const HangulCombinationItem hangul_combination_table_full[] = {
  { 0x11001100, 0x1101 }, /* choseong ssangkiyeok           = kiyeok + kiyeok */
  { 0x11021100, 0x1113 }, /* choseong nieun-kiyeok          = nieun + kiyeok */
  { 0x11021102, 0x1114 }, /* choseong ssangnieun            = nieun + nieun */
  { 0x11021103, 0x1115 }, /* choseong nieun-tikeut          = nieun + tikeut */
  { 0x11021107, 0x1116 }, /* choseong nieun-pieup           = nieun + pieup */
  { 0x11031100, 0x1117 }, /* choseong tikeut-kiyeok         = tikeut + kiyeok */
  { 0x11031103, 0x1104 }, /* choseong ssangtikeut           = tikeut + tikeut */
  { 0x11051102, 0x1118 }, /* choseong rieul-nieun           = rieul + nieun */
  { 0x11051105, 0x1119 }, /* choseong ssangrieul            = rieul + rieul */
  { 0x1105110b, 0x111b }, /* choseong kapyeounrieul         = rieul + ieung */
  { 0x11051112, 0x111a }, /* choseong rieul-hieuh           = rieul + hieuh */
  { 0x11061107, 0x111c }, /* choseong mieum-pieup           = mieum + pieup */
  { 0x1106110b, 0x111d }, /* choseong kapyeounmieum         = mieum + ieung */
  { 0x11071100, 0x111e }, /* choseong pieup-kiyeok          = pieup + kiyeok */
  { 0x11071102, 0x111f }, /* choseong pieup-nieun           = pieup + nieun */
  { 0x11071103, 0x1120 }, /* choseong pieup-tikeut          = pieup + tikeut */
  { 0x11071107, 0x1108 }, /* choseong ssangpieup            = pieup + pieup */
  { 0x11071109, 0x1121 }, /* choseong pieup-sios            = pieup + sios */
  { 0x1107110b, 0x112b }, /* choseong kapyeounpieup         = pieup + ieung */
  { 0x1107110c, 0x1127 }, /* choseong pieup-cieuc           = pieup + cieuc */
  { 0x1107110e, 0x1128 }, /* choseong pieup-chieuch         = pieup + chieuch */
  { 0x11071110, 0x1129 }, /* choseong pieup-thieuth         = pieup + thieuth */
  { 0x11071111, 0x112a }, /* choseong pieup-phieuph         = pieup + phieuph */
  { 0x1108110b, 0x112c }, /* choseong kapyeounssangpieup    = ssangpieup + ieung */
  { 0x11091100, 0x112d }, /* choseong sios-kiyeok           = sios + kiyeok */
  { 0x11091102, 0x112e }, /* choseong sios-nieun            = sios + nieun */
  { 0x11091103, 0x112f }, /* choseong sios-tikeut           = sios + tikeut */
  { 0x11091105, 0x1130 }, /* choseong sios-rieul            = sios + rieul */
  { 0x11091106, 0x1131 }, /* choseong sios-mieum            = sios + mieum */
  { 0x11091107, 0x1132 }, /* choseong sios-pieup            = sios + pieup */
  { 0x11091109, 0x110a }, /* choseong ssangsios             = sios + sios */
  { 0x1109110b, 0x1135 }, /* choseong sios-ieung            = sios + ieung */
  { 0x1109110c, 0x1136 }, /* choseong sios-cieuc            = sios + cieuc */
  { 0x1109110e, 0x1137 }, /* choseong sios-chieuch          = sios + chieuch */
  { 0x1109110f, 0x1138 }, /* choseong sios-khieukh          = sios + khieukh */
  { 0x11091110, 0x1139 }, /* choseong sios-thieuth          = sios + thieuth */
  { 0x11091111, 0x113a }, /* choseong sios-phieuph          = sios + phieuph */
  { 0x11091112, 0x113b }, /* choseong sios-hieuh            = sios + hieuh */
  { 0x110a1109, 0x1134 }, /* choseong sios-ssangsios        = ssangsios + sios */
  { 0x110b1100, 0x1141 }, /* choseong ieung-kiyeok          = ieung + kiyeok */
  { 0x110b1103, 0x1142 }, /* choseong ieung-tikeut          = ieung + tikeut */
  { 0x110b1106, 0x1143 }, /* choseong ieung-mieum           = ieung + mieum */
  { 0x110b1107, 0x1144 }, /* choseong ieung-pieup           = ieung + pieup */
  { 0x110b1109, 0x1145 }, /* choseong ieung-sios            = ieung + sios */
  { 0x110b110b, 0x1147 }, /* choseong ssangieung            = ieung + ieung */
  { 0x110b110c, 0x1148 }, /* choseong ieung-cieuc           = ieung + cieuc */
  { 0x110b110e, 0x1149 }, /* choseong ieung-chieuch         = ieung + chieuch */
  { 0x110b1110, 0x114a }, /* choseong ieung-thieuth         = ieung + thieuth */
  { 0x110b1111, 0x114b }, /* choseong ieung-phieuph         = ieung + phieuph */
  { 0x110b1140, 0x1146 }, /* choseong ieung-pansios         = ieung + pansios */
  { 0x110c110b, 0x114d }, /* choseong cieuc-ieung           = cieuc + ieung */
  { 0x110c110c, 0x110d }, /* choseong ssangcieuc            = cieuc + cieuc */
  { 0x110e110f, 0x1152 }, /* choseong chieuch-khieukh       = chieuch + khieukh */
  { 0x110e1112, 0x1153 }, /* choseong chieuch-hieuh         = chieuch + hieuh */
  { 0x11111107, 0x1156 }, /* choseong phieuph-pieup         = phieuph + pieup */
  { 0x1111110b, 0x1157 }, /* choseong kapyeounphieuph       = phieuph + ieung */
  { 0x11121112, 0x1158 }, /* choseong ssanghieuh            = hieuh + hieuh */
  { 0x11211100, 0x1122 }, /* choseong pieup-sios-kiyeok     = pieup-sios + kiyeok */
  { 0x11211103, 0x1123 }, /* choseong pieup-sios-tikeut     = pieup-sios + tikeut */
  { 0x11211107, 0x1124 }, /* choseong pieup-sios-pieup      = pieup-sios + pieup */
  { 0x11211109, 0x1125 }, /* choseong pieup-ssangsios       = pieup-sios + sios */
  { 0x1121110c, 0x1126 }, /* choseong pieup-sios-cieuc      = pieup-sios + cieuc */
  { 0x11321100, 0x1133 }, /* choseong sios-pieup-kiyeok     = sios-pieup + kiyeok */
  { 0x113c113c, 0x113d }, /* choseong chitueumssangsios     = chitueumsios + chitueumsios */
  { 0x113e113e, 0x113f }, /* choseong ceongchieumssangsios  = ceongchieumsios + ceongchieumsios */
  { 0x114e114e, 0x114f }, /* choseong chitueumssangcieuc    = chitueumcieuc + chitueumcieuc */
  { 0x11501150, 0x1151 }, /* choseong ceongchieumssangcieuc = ceongchieumcieuc + ceongchieumcieuc */
  { 0x11611169, 0x1176 }, /* jungseong a-o                  = a + o */
  { 0x1161116e, 0x1177 }, /* jungseong a-u                  = a + u */
  { 0x11611175, 0x1162 }, /* jungseong ae                   = a */
  { 0x11631169, 0x1178 }, /* jungseong ya-o                 = ya + o */
  { 0x1163116d, 0x1179 }, /* jungseong ya-yo                = ya + yo */
  { 0x11631175, 0x1164 }, /* jungseong yae                  = ya */
  { 0x11651169, 0x117a }, /* jungseong eo-o                 = eo + o */
  { 0x1165116e, 0x117b }, /* jungseong eo-u                 = eo + u */
  { 0x11651173, 0x117c }, /* jungseong eo-eu                = eo + eu */
  { 0x11651175, 0x1166 }, /* jungseong e                    = eo */
  { 0x11671169, 0x117d }, /* jungseong yeo-o                = yeo + o */
  { 0x1167116e, 0x117e }, /* jungseong yeo-u                = yeo + u */
  { 0x11671175, 0x1168 }, /* jungseong ye                   = yeo */
  { 0x11691161, 0x116a }, /* jungseong wa                   = o + a */
  { 0x11691165, 0x117f }, /* jungseong o-eo                 = o + eo */
  { 0x11691166, 0x1180 }, /* jungseong o-e                  = o + e */
  { 0x11691168, 0x1181 }, /* jungseong o-ye                 = o + ye */
  { 0x11691169, 0x1182 }, /* jungseong o-o                  = o + o */
  { 0x1169116e, 0x1183 }, /* jungseong o-u                  = o + u */
  { 0x11691175, 0x116c }, /* jungseong oe                   = o */
  { 0x116a1175, 0x116b }, /* jungseong wae                  = wa */
  { 0x116d1163, 0x1184 }, /* jungseong yo-ya                = yo + ya */
  { 0x116d1164, 0x1185 }, /* jungseong yo-yae               = yo + yae */
  { 0x116d1167, 0x1186 }, /* jungseong yo-yeo               = yo + yeo */
  { 0x116d1169, 0x1187 }, /* jungseong yo-o                 = yo + o */
  { 0x116d1175, 0x1188 }, /* jungseong yo-i                 = yo + i */
  { 0x116e1161, 0x1189 }, /* jungseong u-a                  = u + a */
  { 0x116e1162, 0x118a }, /* jungseong u-ae                 = u + ae */
  { 0x116e1165, 0x116f }, /* jungseong weo                  = u + eo */
  { 0x116e1168, 0x118c }, /* jungseong u-ye                 = u + ye */
  { 0x116e116e, 0x118d }, /* jungseong u-u                  = u + u */
  { 0x116e1175, 0x1171 }, /* jungseong wi                   = u */
  { 0x116f1173, 0x118b }, /* jungseong u-eo-eu              = weo + eu */
  { 0x116f1175, 0x1170 }, /* jungseong we                   = weo */
  { 0x11721161, 0x118e }, /* jungseong yu-a                 = yu + a */
  { 0x11721165, 0x118f }, /* jungseong yu-eo                = yu + eo */
  { 0x11721166, 0x1190 }, /* jungseong yu-e                 = yu + e */
  { 0x11721167, 0x1191 }, /* jungseong yu-yeo               = yu + yeo */
  { 0x11721168, 0x1192 }, /* jungseong yu-ye                = yu + ye */
  { 0x1172116e, 0x1193 }, /* jungseong yu-u                 = yu + u */
  { 0x11721175, 0x1194 }, /* jungseong yu-i                 = yu + i */
  { 0x1173116e, 0x1195 }, /* jungseong eu-u                 = eu + u */
  { 0x11731173, 0x1196 }, /* jungseong eu-eu                = eu + eu */
  { 0x11731175, 0x1174 }, /* jungseong yi                   = eu */
  { 0x1174116e, 0x1197 }, /* jungseong yi-u                 = yi + u */
  { 0x11751161, 0x1198 }, /* jungseong i-a                  = i + a */
  { 0x11751163, 0x1199 }, /* jungseong i-ya                 = i + ya */
  { 0x11751169, 0x119a }, /* jungseong i-o                  = i + o */
  { 0x1175116e, 0x119b }, /* jungseong i-u                  = i + u */
  { 0x11751173, 0x119c }, /* jungseong i-eu                 = i + eu */
  { 0x1175119e, 0x119d }, /* jungseong i-araea              = i */
  { 0x119e1165, 0x119f }, /* jungseong araea-eo             = araea + eo */
  { 0x119e116e, 0x11a0 }, /* jungseong araea-u              = araea + u */
  { 0x119e1175, 0x11a1 }, /* jungseong araea-i              = araea + i */
  { 0x119e119e, 0x11a2 }, /* jungseong ssangaraea           = araea + araea */
  { 0x11a811a8, 0x11a9 }, /* jongseong ssangkiyeok          = kiyeok + kiyeok */
  { 0x11a811af, 0x11c3 }, /* jongseong kiyeok-rieul         = kiyeok + rieul */
  { 0x11a811ba, 0x11aa }, /* jongseong kiyeok-sios          = kiyeok */
  { 0x11aa11a8, 0x11c4 }, /* jongseong kiyeok-sios-kiyeok   = kiyeok-sios + kiyeok */
  { 0x11ab11a8, 0x11c5 }, /* jongseong nieun-kiyeok         = nieun + kiyeok */
  { 0x11ab11ae, 0x11c6 }, /* jongseong nieun-tikeut         = nieun + tikeut */
  { 0x11ab11ba, 0x11c7 }, /* jongseong nieun-sios           = nieun + sios */
  { 0x11ab11bd, 0x11ac }, /* jongseong nieun-cieuc          = nieun */
  { 0x11ab11c0, 0x11c9 }, /* jongseong nieun-thieuth        = nieun + thieuth */
  { 0x11ab11c2, 0x11ad }, /* jongseong nieun-hieuh          = nieun */
  { 0x11ab11eb, 0x11c8 }, /* jongseong nieun-pansios        = nieun */
  { 0x11ae11a8, 0x11ca }, /* jongseong tikeut-kiyeok        = tikeut + kiyeok */
  { 0x11ae11af, 0x11cb }, /* jongseong tikeut-rieul         = tikeut + rieul */
  { 0x11af11a8, 0x11b0 }, /* jongseong rieul-kiyeok         = rieul + kiyeok */
  { 0x11af11ab, 0x11cd }, /* jongseong rieul-nieun          = rieul + nieun */
  { 0x11af11ae, 0x11ce }, /* jongseong rieul-tikeut         = rieul + tikeut */
  { 0x11af11af, 0x11d0 }, /* jongseong ssangrieul           = rieul + rieul */
  { 0x11af11b7, 0x11b1 }, /* jongseong rieul-mieum          = rieul */
  { 0x11af11b8, 0x11b2 }, /* jongseong rieul-pieup          = rieul */
  { 0x11af11ba, 0x11b3 }, /* jongseong rieul-sios           = rieul */
  { 0x11af11bf, 0x11d8 }, /* jongseong rieul-khieukh        = rieul + khieukh */
  { 0x11af11c0, 0x11b4 }, /* jongseong rieul-thieuth        = rieul */
  { 0x11af11c1, 0x11b5 }, /* jongseong rieul-phieuph        = rieul */
  { 0x11af11c2, 0x11b6 }, /* jongseong rieul-hieuh          = rieul */
  { 0x11af11eb, 0x11d7 }, /* jongseong rieul-pansios        = rieul */
  { 0x11af11f9, 0x11d9 }, /* jongseong rieul-yeorinhieuh    = rieul */
  { 0x11b011ba, 0x11cc }, /* jongseong rieul-kiyeok-sios    = rieul-kiyeok + sios */
  { 0x11b111a8, 0x11d1 }, /* jongseong rieul-mieum-kiyeok   = rieul-mieum + kiyeok */
  { 0x11b111ba, 0x11d2 }, /* jongseong rieul-mieum-sios     = rieul-mieum + sios */
  { 0x11b211ba, 0x11d3 }, /* jongseong rieul-pieup-sios     = rieul-pieup + sios */
  { 0x11b211bc, 0x11d5 }, /* jongseong rieul-kapyeounpieup  = rieul-pieup + ieung */
  { 0x11b211c2, 0x11d4 }, /* jongseong rieul-pieup-hieuh    = rieul-pieup + hieuh */
  { 0x11b311ba, 0x11d6 }, /* jongseong rieul-ssangsios      = rieul-sios + sios */
  { 0x11b711a8, 0x11da }, /* jongseong mieum-kiyeok         = mieum + kiyeok */
  { 0x11b711af, 0x11db }, /* jongseong mieum-rieul          = mieum + rieul */
  { 0x11b711b8, 0x11dc }, /* jongseong mieum-pieup          = mieum + pieup */
  { 0x11b711ba, 0x11dd }, /* jongseong mieum-sios           = mieum + sios */
  { 0x11b711bc, 0x11e2 }, /* jongseong kapyeounmieum        = mieum + ieung */
  { 0x11b711be, 0x11e0 }, /* jongseong mieum-chieuch        = mieum + chieuch */
  { 0x11b711c2, 0x11e1 }, /* jongseong mieum-hieuh          = mieum + hieuh */
  { 0x11b711eb, 0x11df }, /* jongseong mieum-pansios        = mieum */
  { 0x11b811af, 0x11e3 }, /* jongseong pieup-rieul          = pieup + rieul */
  { 0x11b811ba, 0x11b9 }, /* jongseong pieup-sios           = pieup */
  { 0x11b811bc, 0x11e6 }, /* jongseong kapyeounpieup        = pieup + ieung */
  { 0x11b811c1, 0x11e4 }, /* jongseong pieup-phieuph        = pieup + phieuph */
  { 0x11b811c2, 0x11e5 }, /* jongseong pieup-hieuh          = pieup + hieuh */
  { 0x11ba11a8, 0x11e7 }, /* jongseong sios-kiyeok          = sios + kiyeok */
  { 0x11ba11ae, 0x11e8 }, /* jongseong sios-tikeut          = sios + tikeut */
  { 0x11ba11af, 0x11e9 }, /* jongseong sios-rieul           = sios + rieul */
  { 0x11ba11b8, 0x11ea }, /* jongseong sios-pieup           = sios + pieup */
  { 0x11ba11ba, 0x11bb }, /* jongseong ssangsios            = sios + sios */
  { 0x11bc11a8, 0x11ec }, /* jongseong ieung-kiyeok         = ieung + kiyeok */
  { 0x11bc11bc, 0x11ee }, /* jongseong ssangieung           = ieung + ieung */
  { 0x11bc11bf, 0x11ef }, /* jongseong ieung-khieukh        = ieung + khieukh */
  { 0x11c111b8, 0x11f3 }, /* jongseong phieuph-pieup        = phieuph + pieup */
  { 0x11c111bc, 0x11f4 }, /* jongseong kapyeounphieuph      = phieuph + ieung */
  { 0x11c211ab, 0x11f5 }, /* jongseong hieuh-nieun          = hieuh + nieun */
  { 0x11c211af, 0x11f6 }, /* jongseong hieuh-rieul          = hieuh + rieul */
  { 0x11c211b7, 0x11f7 }, /* jongseong hieuh-mieum          = hieuh + mieum */
  { 0x11c211b8, 0x11f8 }, /* jongseong hieuh-pieup          = hieuh + pieup */
  { 0x11ce11c2, 0x11cf }, /* jongseong rieul-tikeut-hieuh   = rieul-tikeut + hieuh */
  { 0x11dd11ba, 0x11de }, /* jongseong mieum-ssangsios      = mieum-sios + sios */
  { 0x11ec11a8, 0x11ed }, /* jongseong ieung-ssangkiyeok    = ieung-kiyeok + kiyeok */
  { 0x11f011ba, 0x11f1 }, /* jongseong yesieung-sios        = yesieung + sios */
  { 0x11f011eb, 0x11f2 }, /* jongseong yesieung-pansios     = yesieung + pansios */
};
