/* urlshorten.c generated by valac 0.11.6, the Vala compiler
 * generated from urlshorten.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus.h>
#include "gwibber.h"


#define TYPE_URL_SHORTEN_INTERFACE (url_shorten_interface_get_type ())
#define URL_SHORTEN_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_URL_SHORTEN_INTERFACE, URLShortenInterface))
#define IS_URL_SHORTEN_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_URL_SHORTEN_INTERFACE))
#define URL_SHORTEN_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_URL_SHORTEN_INTERFACE, URLShortenInterfaceIface))

typedef struct _URLShortenInterface URLShortenInterface;
typedef struct _URLShortenInterfaceIface URLShortenInterfaceIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _URLShortenInterfaceDBusProxy URLShortenInterfaceDBusProxy;
typedef DBusGProxyClass URLShortenInterfaceDBusProxyClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

struct _URLShortenInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*Shorten) (URLShortenInterface* self, const gchar* url, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _URLShortenInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _GwibberURLShortenPrivate {
	URLShortenInterface* url_service;
	GwibberUtils* utils;
};


static gpointer gwibber_url_shorten_parent_class = NULL;

URLShortenInterface* url_shorten_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType url_shorten_interface_get_type (void) G_GNUC_CONST;
gchar* url_shorten_interface_Shorten (URLShortenInterface* self, const gchar* url, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void url_shorten_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _url_shorten_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult url_shorten_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_url_shorten_interface_introspect (URLShortenInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_url_shorten_interface_property_get_all (URLShortenInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_url_shorten_interface_Shorten (URLShortenInterface* self, DBusConnection* connection, DBusMessage* message);
GType url_shorten_interface_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult url_shorten_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	URL_SHORTEN_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static gchar* url_shorten_interface_dbus_proxy_Shorten (URLShortenInterface* self, const gchar* url, GError** error);
static void url_shorten_interface_dbus_proxy_url_shorten_interface__interface_init (URLShortenInterfaceIface* iface);
static void _vala_url_shorten_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_url_shorten_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_URL_SHORTEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_URL_SHORTEN, GwibberURLShortenPrivate))
enum  {
	GWIBBER_URL_SHORTEN_DUMMY_PROPERTY
};
#define GWIBBER_URL_SHORTEN_url_name "com.Gwibber.URLShorten"
#define GWIBBER_URL_SHORTEN_url_path "/com/gwibber/URLShorten"
#define GWIBBER_URL_SHORTEN_url_iface "com.Gwibber.URLShorten"
static GObject * gwibber_url_shorten_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GwibberUtils* gwibber_utils_new (void);
GwibberUtils* gwibber_utils_construct (GType object_type);
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_url_shorten_url_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void gwibber_url_shorten_finalize (GObject* obj);

static const DBusObjectPathVTable _url_shorten_interface_dbus_path_vtable = {_url_shorten_interface_dbus_unregister, url_shorten_interface_dbus_message};
static const _DBusObjectVTable _url_shorten_interface_dbus_vtable = {url_shorten_interface_dbus_register_object};

gchar* url_shorten_interface_Shorten (URLShortenInterface* self, const gchar* url, GError** error) {
	return URL_SHORTEN_INTERFACE_GET_INTERFACE (self)->Shorten (self, url, error);
}


static void url_shorten_interface_base_init (URLShortenInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _url_shorten_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_url_shorten_interface_introspect (URLShortenInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.Gwibber.URLShorten\">\n  <method name=\"Shorten\">\n    <arg name=\"url\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_url_shorten_interface_property_get_all (URLShortenInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "com.Gwibber.URLShorten") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_url_shorten_interface_Shorten (URLShortenInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gchar* url = NULL;
	const char* _tmp1_;
	gchar* result;
	DBusMessage* reply;
	const char* _tmp2_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	url = g_strdup (_tmp1_);
	result = url_shorten_interface_Shorten (self, url, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (url);
	_tmp2_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp2_);
	_g_free0 ( result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult url_shorten_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_url_shorten_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_url_shorten_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.URLShorten", "Shorten")) {
		result = _dbus_url_shorten_interface_Shorten (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void url_shorten_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_url_shorten_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


GType url_shorten_interface_get_type (void) {
	static volatile gsize url_shorten_interface_type_id__volatile = 0;
	if (g_once_init_enter (&url_shorten_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (URLShortenInterfaceIface), (GBaseInitFunc) url_shorten_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType url_shorten_interface_type_id;
		url_shorten_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "URLShortenInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (url_shorten_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (url_shorten_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &url_shorten_interface_dbus_proxy_get_type);
		g_type_set_qdata (url_shorten_interface_type_id, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_url_shorten_interface_dbus_vtable));
		g_once_init_leave (&url_shorten_interface_type_id__volatile, url_shorten_interface_type_id);
	}
	return url_shorten_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (URLShortenInterfaceDBusProxy, url_shorten_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_URL_SHORTEN_INTERFACE, url_shorten_interface_dbus_proxy_url_shorten_interface__interface_init) );
URLShortenInterface* url_shorten_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	URLShortenInterface* self;
	self = g_object_new (url_shorten_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "com.Gwibber.URLShorten", NULL);
	return self;
}


static GObject* url_shorten_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (url_shorten_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), url_shorten_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s',interface='com.Gwibber.URLShorten'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult url_shorten_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void url_shorten_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((URLShortenInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((URLShortenInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), url_shorten_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (url_shorten_interface_dbus_proxy_parent_class)->dispose (self);
}


static void url_shorten_interface_dbus_proxy_class_init (URLShortenInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = url_shorten_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = url_shorten_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_url_shorten_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_url_shorten_interface_dbus_proxy_set_property;
}


static void url_shorten_interface_dbus_proxy_init (URLShortenInterfaceDBusProxy* self) {
}


static gchar* url_shorten_interface_dbus_proxy_Shorten (URLShortenInterface* self, const gchar* url, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp29_;
	gchar* _result;
	const char* _tmp30_;
	if (((URLShortenInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.URLShorten", "Shorten");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp29_ = url;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp29_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp31_;
			_edomain = DBUS_GERROR;
			_tmp31_ = _dbus_error.name + 27;
			if (strcmp (_tmp31_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp31_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp31_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp31_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp31_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp31_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp31_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp31_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp31_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp31_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp31_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp31_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp31_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp31_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp31_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp31_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp31_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp31_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp31_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp31_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp31_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp31_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp31_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp31_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp31_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp31_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp31_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp31_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp31_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp31_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp31_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp31_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp31_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp30_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp30_);
	dbus_message_unref (_reply);
	return _result;
}


static void url_shorten_interface_dbus_proxy_url_shorten_interface__interface_init (URLShortenInterfaceIface* iface) {
	iface->Shorten = url_shorten_interface_dbus_proxy_Shorten;
}


static void _vala_url_shorten_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_url_shorten_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


GwibberURLShorten* gwibber_url_shorten_construct (GType object_type) {
	GwibberURLShorten * self = NULL;
	self = (GwibberURLShorten*) g_object_new (object_type, NULL);
	return self;
}


GwibberURLShorten* gwibber_url_shorten_new (void) {
	return gwibber_url_shorten_construct (GWIBBER_TYPE_URL_SHORTEN);
}


/**
         * com.Gwibber.URLShorten
         **/
gchar* gwibber_url_shorten_shorten (GwibberURLShorten* self, const gchar* url) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = url_shorten_interface_Shorten (self->priv->url_service, url, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch21_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
	goto __finally21;
	__catch21_dbus_gerror:
	{
		GError * e;
		gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("urlshorten.vala:81: %s", e->message);
		_tmp2_ = g_strdup ("Failed");
		result = _tmp2_;
		_g_error_free0 (e);
		return result;
	}
	__finally21:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void gwibber_url_shorten_url_available (GwibberURLShorten* self, gboolean is_up) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "is-available", is_up);
}


static void _gwibber_url_shorten_url_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_url_shorten_url_available (self, up);
}


static GObject * gwibber_url_shorten_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberURLShorten * self;
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* dbus_conn;
	URLShortenInterface* _tmp1_;
	GwibberUtils* _tmp2_ = NULL;
	GwibberUtils* _tmp3_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_url_shorten_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_URL_SHORTEN (obj);
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	dbus_conn = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch22_g_error;
	}
	_tmp1_ = url_shorten_interface_dbus_proxy_new (dbus_conn, GWIBBER_URL_SHORTEN_url_name, GWIBBER_URL_SHORTEN_url_path);
	_g_object_unref0 (self->priv->url_service);
	self->priv->url_service = _tmp1_;
	_tmp2_ = gwibber_utils_new ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp3_;
	gwibber_utils_setup (self->priv->utils, GWIBBER_URL_SHORTEN_url_name, &_inner_error_);
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (dbus_conn);
		goto __catch22_g_error;
	}
	g_signal_connect_object (self->priv->utils, "available", (GCallback) _gwibber_url_shorten_url_available_gwibber_utils_available, self, 0);
	_dbus_g_connection_unref0 (dbus_conn);
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("urlshorten.vala:65: Unable to get Gwibber URLShorten");
		_g_error_free0 (e);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void gwibber_url_shorten_class_init (GwibberURLShortenClass * klass) {
	gwibber_url_shorten_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberURLShortenPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_url_shorten_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_url_shorten_finalize;
	/** 
	            URLShorten::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.URLShorten availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_URL_SHORTEN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gwibber_url_shorten_instance_init (GwibberURLShorten * self) {
	self->priv = GWIBBER_URL_SHORTEN_GET_PRIVATE (self);
}


static void gwibber_url_shorten_finalize (GObject* obj) {
	GwibberURLShorten * self;
	self = GWIBBER_URL_SHORTEN (obj);
	_g_object_unref0 (self->priv->url_service);
	_g_object_unref0 (self->priv->utils);
	G_OBJECT_CLASS (gwibber_url_shorten_parent_class)->finalize (obj);
}


GType gwibber_url_shorten_get_type (void) {
	static volatile gsize gwibber_url_shorten_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_url_shorten_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberURLShortenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_url_shorten_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberURLShorten), 0, (GInstanceInitFunc) gwibber_url_shorten_instance_init, NULL };
		GType gwibber_url_shorten_type_id;
		gwibber_url_shorten_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberURLShorten", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_url_shorten_type_id__volatile, gwibber_url_shorten_type_id);
	}
	return gwibber_url_shorten_type_id__volatile;
}



