/* testlist.c generated by valac 0.11.5, the Vala compiler
 * generated from testlist.vala, do not modify */

/* testlist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_LIST_TESTS (list_tests_get_type ())
#define LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_TESTS, ListTests))
#define LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_TESTS, ListTestsClass))
#define IS_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_TESTS))
#define IS_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_TESTS))
#define LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_TESTS, ListTestsClass))

typedef struct _ListTests ListTests;
typedef struct _ListTestsClass ListTestsClass;
typedef struct _ListTestsPrivate ListTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _ListTests {
	CollectionTests parent_instance;
	ListTestsPrivate * priv;
};

struct _ListTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_retained) (ListTests* self);
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer list_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType list_tests_get_type (void) G_GNUC_CONST;
enum  {
	LIST_TESTS_DUMMY_PROPERTY
};
ListTests* list_tests_construct (GType object_type, const gchar* name);
CollectionTests* collection_tests_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void list_tests_test_iterator_is_ordered (ListTests* self);
static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self);
void list_tests_test_list_iterator (ListTests* self);
static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self);
void list_tests_test_duplicates_are_retained (ListTests* self);
static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self);
void list_tests_test_get (ListTests* self);
static void _list_tests_test_get_gee_test_case_test_method (gpointer self);
void list_tests_test_set (ListTests* self);
static void _list_tests_test_set_gee_test_case_test_method (gpointer self);
void list_tests_test_insert (ListTests* self);
static void _list_tests_test_insert_gee_test_case_test_method (gpointer self);
void list_tests_test_remove_at (ListTests* self);
static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self);
void list_tests_test_index_of (ListTests* self);
static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self);
void list_tests_test_first (ListTests* self);
static void _list_tests_test_first_gee_test_case_test_method (gpointer self);
void list_tests_test_last (ListTests* self);
static void _list_tests_test_last_gee_test_case_test_method (gpointer self);
void list_tests_test_insert_all (ListTests* self);
static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self);
void list_tests_test_slice (ListTests* self);
static void _list_tests_test_slice_gee_test_case_test_method (gpointer self);
static void list_tests_real_test_duplicates_are_retained (ListTests* self);


static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self) {
	list_tests_test_iterator_is_ordered (self);
}


static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self) {
	list_tests_test_list_iterator (self);
}


static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self) {
	list_tests_test_duplicates_are_retained (self);
}


static void _list_tests_test_get_gee_test_case_test_method (gpointer self) {
	list_tests_test_get (self);
}


static void _list_tests_test_set_gee_test_case_test_method (gpointer self) {
	list_tests_test_set (self);
}


static void _list_tests_test_insert_gee_test_case_test_method (gpointer self) {
	list_tests_test_insert (self);
}


static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self) {
	list_tests_test_remove_at (self);
}


static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self) {
	list_tests_test_index_of (self);
}


static void _list_tests_test_first_gee_test_case_test_method (gpointer self) {
	list_tests_test_first (self);
}


static void _list_tests_test_last_gee_test_case_test_method (gpointer self) {
	list_tests_test_last (self);
}


static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self) {
	list_tests_test_insert_all (self);
}


static void _list_tests_test_slice_gee_test_case_test_method (gpointer self) {
	list_tests_test_slice (self);
}


ListTests* list_tests_construct (GType object_type, const gchar* name) {
	ListTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ListTests*) collection_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] iterator is ordered", _list_tests_test_iterator_is_ordered_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] list iterator", _list_tests_test_list_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] duplicates are retained", _list_tests_test_duplicates_are_retained_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] get", _list_tests_test_get_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] set", _list_tests_test_set_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert", _list_tests_test_insert_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] remove_at", _list_tests_test_remove_at_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] index_of", _list_tests_test_index_of_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] first", _list_tests_test_first_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] last", _list_tests_test_last_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert_all", _list_tests_test_insert_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] slice", _list_tests_test_slice_gee_test_case_test_method, self);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void list_tests_test_iterator_is_ordered (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iterator;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GeeIterator* _tmp8_ = NULL;
	GeeIterator* _tmp9_;
	gboolean _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gboolean _tmp16_;
	gpointer _tmp17_ = NULL;
	gchar* _tmp18_;
	gboolean _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) test_list);
	iterator = _tmp2_;
	_tmp3_ = gee_iterator_next (iterator);
	g_assert (!_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp7_);
	_tmp8_ = gee_iterable_iterator ((GeeIterable*) test_list);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (iterator);
	iterator = _tmp9_;
	_tmp10_ = gee_iterator_next (iterator);
	g_assert (_tmp10_);
	_tmp11_ = gee_iterator_get (iterator);
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (g_strcmp0 (_tmp12_, "one") == 0);
	_g_free0 (_tmp12_);
	_tmp13_ = gee_iterator_next (iterator);
	g_assert (_tmp13_);
	_tmp14_ = gee_iterator_get (iterator);
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "two") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_iterator_next (iterator);
	g_assert (_tmp16_);
	_tmp17_ = gee_iterator_get (iterator);
	_tmp18_ = (gchar*) _tmp17_;
	g_assert (g_strcmp0 (_tmp18_, "three") == 0);
	_g_free0 (_tmp18_);
	_tmp19_ = gee_iterator_next (iterator);
	g_assert (_tmp19_);
	_tmp20_ = gee_iterator_get (iterator);
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "one") == 0);
	_g_free0 (_tmp21_);
	_tmp22_ = gee_iterator_next (iterator);
	g_assert (!_tmp22_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}


void list_tests_test_list_iterator (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	GeeListIterator* _tmp2_ = NULL;
	GeeListIterator* iterator;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GeeListIterator* _tmp12_ = NULL;
	GeeListIterator* _tmp13_;
	gboolean _tmp14_;
	gpointer _tmp15_ = NULL;
	gchar* _tmp16_;
	gint _tmp17_;
	gboolean _tmp18_;
	gpointer _tmp19_ = NULL;
	gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean _tmp28_;
	gpointer _tmp29_ = NULL;
	gchar* _tmp30_;
	gint _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gpointer _tmp35_ = NULL;
	gchar* _tmp36_;
	gint _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	gpointer _tmp41_ = NULL;
	gchar* _tmp42_;
	gint _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	gpointer _tmp48_ = NULL;
	gchar* _tmp49_;
	gint _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	gpointer _tmp53_ = NULL;
	gchar* _tmp54_;
	gint _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	gpointer _tmp58_ = NULL;
	gchar* _tmp59_;
	gint _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	gpointer _tmp63_ = NULL;
	gchar* _tmp64_;
	gint _tmp65_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = gee_list_list_iterator (test_list);
	iterator = _tmp2_;
	_tmp3_ = gee_iterator_has_next ((GeeIterator*) iterator);
	g_assert (!_tmp3_);
	_tmp4_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (!_tmp4_);
	_tmp5_ = gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator);
	g_assert (!_tmp5_);
	_tmp6_ = gee_bidir_iterator_previous ((GeeBidirIterator*) iterator);
	g_assert (!_tmp6_);
	_tmp7_ = gee_iterator_first ((GeeIterator*) iterator);
	g_assert (!_tmp7_);
	_tmp8_ = gee_bidir_iterator_last ((GeeBidirIterator*) iterator);
	g_assert (!_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp10_);
	_tmp11_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp11_);
	_tmp12_ = gee_list_list_iterator (test_list);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (iterator);
	iterator = _tmp13_;
	_tmp14_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp14_);
	_tmp15_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp16_ = (gchar*) _tmp15_;
	g_assert (g_strcmp0 (_tmp16_, "one") == 0);
	_g_free0 (_tmp16_);
	_tmp17_ = gee_list_iterator_index (iterator);
	g_assert (_tmp17_ == 0);
	gee_list_iterator_set (iterator, "new one");
	_tmp18_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp18_);
	_tmp19_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp20_ = (gchar*) _tmp19_;
	g_assert (g_strcmp0 (_tmp20_, "two") == 0);
	_g_free0 (_tmp20_);
	_tmp21_ = gee_list_iterator_index (iterator);
	g_assert (_tmp21_ == 1);
	gee_list_iterator_set (iterator, "new two");
	_tmp22_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp22_ == 3);
	_tmp23_ = gee_list_iterator_index (iterator);
	g_assert (_tmp23_ == 1);
	gee_list_iterator_insert (iterator, "before two");
	_tmp24_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp24_ == 4);
	_tmp25_ = gee_list_iterator_index (iterator);
	g_assert (_tmp25_ == 2);
	gee_list_iterator_add (iterator, "after two");
	_tmp26_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp26_ == 5);
	_tmp27_ = gee_list_iterator_index (iterator);
	g_assert (_tmp27_ == 3);
	_tmp28_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp28_);
	_tmp29_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp30_ = (gchar*) _tmp29_;
	g_assert (g_strcmp0 (_tmp30_, "three") == 0);
	_g_free0 (_tmp30_);
	_tmp31_ = gee_list_iterator_index (iterator);
	g_assert (_tmp31_ == 4);
	gee_list_iterator_set (iterator, "new three");
	_tmp32_ = gee_iterator_has_next ((GeeIterator*) iterator);
	g_assert (!_tmp32_);
	_tmp33_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (!_tmp33_);
	_tmp34_ = gee_iterator_first ((GeeIterator*) iterator);
	g_assert (_tmp34_);
	_tmp35_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp36_ = (gchar*) _tmp35_;
	g_assert (g_strcmp0 (_tmp36_, "new one") == 0);
	_g_free0 (_tmp36_);
	_tmp37_ = gee_list_iterator_index (iterator);
	g_assert (_tmp37_ == 0);
	_tmp38_ = gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator);
	g_assert (!_tmp38_);
	_tmp39_ = gee_bidir_iterator_previous ((GeeBidirIterator*) iterator);
	g_assert (!_tmp39_);
	_tmp40_ = gee_bidir_iterator_last ((GeeBidirIterator*) iterator);
	g_assert (_tmp40_);
	_tmp41_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp42_ = (gchar*) _tmp41_;
	g_assert (g_strcmp0 (_tmp42_, "new three") == 0);
	_g_free0 (_tmp42_);
	_tmp43_ = gee_list_iterator_index (iterator);
	g_assert (_tmp43_ == 4);
	_tmp44_ = gee_iterator_has_next ((GeeIterator*) iterator);
	g_assert (!_tmp44_);
	_tmp45_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (!_tmp45_);
	_tmp46_ = gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator);
	g_assert (_tmp46_);
	_tmp47_ = gee_bidir_iterator_previous ((GeeBidirIterator*) iterator);
	g_assert (_tmp47_);
	_tmp48_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp49_ = (gchar*) _tmp48_;
	g_assert (g_strcmp0 (_tmp49_, "after two") == 0);
	_g_free0 (_tmp49_);
	_tmp50_ = gee_list_iterator_index (iterator);
	g_assert (_tmp50_ == 3);
	_tmp51_ = gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator);
	g_assert (_tmp51_);
	_tmp52_ = gee_bidir_iterator_previous ((GeeBidirIterator*) iterator);
	g_assert (_tmp52_);
	_tmp53_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp54_ = (gchar*) _tmp53_;
	g_assert (g_strcmp0 (_tmp54_, "new two") == 0);
	_g_free0 (_tmp54_);
	_tmp55_ = gee_list_iterator_index (iterator);
	g_assert (_tmp55_ == 2);
	_tmp56_ = gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator);
	g_assert (_tmp56_);
	_tmp57_ = gee_bidir_iterator_previous ((GeeBidirIterator*) iterator);
	g_assert (_tmp57_);
	_tmp58_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp59_ = (gchar*) _tmp58_;
	g_assert (g_strcmp0 (_tmp59_, "before two") == 0);
	_g_free0 (_tmp59_);
	_tmp60_ = gee_list_iterator_index (iterator);
	g_assert (_tmp60_ == 1);
	_tmp61_ = gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator);
	g_assert (_tmp61_);
	_tmp62_ = gee_bidir_iterator_previous ((GeeBidirIterator*) iterator);
	g_assert (_tmp62_);
	_tmp63_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp64_ = (gchar*) _tmp63_;
	g_assert (g_strcmp0 (_tmp64_, "new one") == 0);
	_g_free0 (_tmp64_);
	_tmp65_ = gee_list_iterator_index (iterator);
	g_assert (_tmp65_ == 0);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}


static void list_tests_real_test_duplicates_are_retained (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gint _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp4_ == 1);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp7_ == 2);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp10_ == 3);
	_tmp11_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	g_assert (_tmp11_);
	_tmp12_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	g_assert (_tmp12_);
	_tmp13_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp13_ == 2);
	_tmp14_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	g_assert (_tmp14_);
	_tmp15_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	g_assert (_tmp15_);
	_tmp16_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp16_ == 1);
	_tmp17_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	g_assert (_tmp17_);
	_tmp18_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	g_assert (!_tmp18_);
	_tmp19_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp19_ == 0);
	_g_object_unref0 (test_list);
}


void list_tests_test_duplicates_are_retained (ListTests* self) {
	LIST_TESTS_GET_CLASS (self)->test_duplicates_are_retained (self);
}


void list_tests_test_get (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gpointer _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp11_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		gpointer _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gee_list_get (test_list, 0);
		_tmp4_ = (gchar*) _tmp3_;
		_g_free0 (_tmp4_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_list_get (test_list, 0);
	_tmp7_ = (gchar*) _tmp6_;
	g_assert (g_strcmp0 (_tmp7_, "one") == 0);
	_g_free0 (_tmp7_);
	_tmp8_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp8_) {
		gpointer _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp9_ = gee_list_get (test_list, 1);
		_tmp10_ = (gchar*) _tmp9_;
		_g_free0 (_tmp10_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp11_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp11_) {
		gpointer _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp12_ = gee_list_get (test_list, -1);
		_tmp13_ = (gchar*) _tmp12_;
		_g_free0 (_tmp13_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp14_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp14_);
	_tmp15_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp15_);
	_tmp16_ = gee_list_get (test_list, 0);
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "one") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_list_get (test_list, 1);
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "two") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_list_get (test_list, 2);
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "three") == 0);
	_g_free0 (_tmp21_);
	gee_collection_clear ((GeeCollection*) test_list);
	_tmp22_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp22_) {
		gpointer _tmp23_ = NULL;
		gchar* _tmp24_;
		_tmp23_ = gee_list_get (test_list, 0);
		_tmp24_ = (gchar*) _tmp23_;
		_g_free0 (_tmp24_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_set (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	gint _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_ = NULL;
	gchar* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp2_ == 0);
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		gee_list_set (test_list, 0, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp4_ == 0);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp6_ == 1);
	_tmp7_ = gee_list_get (test_list, 0);
	_tmp8_ = (gchar*) _tmp7_;
	g_assert (g_strcmp0 (_tmp8_, "one") == 0);
	_g_free0 (_tmp8_);
	gee_list_set (test_list, 0, "two");
	_tmp9_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp9_ == 1);
	_tmp10_ = gee_list_get (test_list, 0);
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "two") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp12_ == 1);
	_tmp13_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp13_) {
		gee_list_set (test_list, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp14_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp14_ == 1);
	_g_object_unref0 (test_list);
}


void list_tests_test_insert (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	gboolean _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_ = NULL;
	gchar* _tmp6_;
	gpointer _tmp7_ = NULL;
	gchar* _tmp8_;
	gpointer _tmp9_ = NULL;
	gchar* _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	gpointer _tmp15_ = NULL;
	gchar* _tmp16_;
	gboolean _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		gee_list_insert (test_list, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp3_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp3_ == 0);
	gee_list_insert (test_list, 0, "one");
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp4_ == 1);
	_tmp5_ = gee_list_get (test_list, 0);
	_tmp6_ = (gchar*) _tmp5_;
	g_assert (g_strcmp0 (_tmp6_, "one") == 0);
	_g_free0 (_tmp6_);
	gee_list_insert (test_list, 0, "two");
	_tmp7_ = gee_list_get (test_list, 0);
	_tmp8_ = (gchar*) _tmp7_;
	g_assert (g_strcmp0 (_tmp8_, "two") == 0);
	_g_free0 (_tmp8_);
	_tmp9_ = gee_list_get (test_list, 1);
	_tmp10_ = (gchar*) _tmp9_;
	g_assert (g_strcmp0 (_tmp10_, "one") == 0);
	_g_free0 (_tmp10_);
	gee_list_insert (test_list, 1, "three");
	_tmp11_ = gee_list_get (test_list, 0);
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (g_strcmp0 (_tmp12_, "two") == 0);
	_g_free0 (_tmp12_);
	_tmp13_ = gee_list_get (test_list, 1);
	_tmp14_ = (gchar*) _tmp13_;
	g_assert (g_strcmp0 (_tmp14_, "three") == 0);
	_g_free0 (_tmp14_);
	_tmp15_ = gee_list_get (test_list, 2);
	_tmp16_ = (gchar*) _tmp15_;
	g_assert (g_strcmp0 (_tmp16_, "one") == 0);
	_g_free0 (_tmp16_);
	_tmp17_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp17_) {
		gee_list_insert (test_list, 4, "four");
		exit (0);
	}
	g_test_trap_assert_failed ();
	gee_list_insert (test_list, 3, "four");
	_tmp18_ = gee_list_get (test_list, 0);
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "two") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_list_get (test_list, 1);
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "three") == 0);
	_g_free0 (_tmp21_);
	_tmp22_ = gee_list_get (test_list, 2);
	_tmp23_ = (gchar*) _tmp22_;
	g_assert (g_strcmp0 (_tmp23_, "one") == 0);
	_g_free0 (_tmp23_);
	_tmp24_ = gee_list_get (test_list, 3);
	_tmp25_ = (gchar*) _tmp24_;
	g_assert (g_strcmp0 (_tmp25_, "four") == 0);
	_g_free0 (_tmp25_);
	_tmp26_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp26_) {
		gee_list_insert (test_list, -1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_remove_at (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gint _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_ = NULL;
	gchar* _tmp18_;
	gpointer _tmp19_ = NULL;
	gchar* _tmp20_;
	gpointer _tmp21_ = NULL;
	gchar* _tmp22_;
	gpointer _tmp23_ = NULL;
	gchar* _tmp24_;
	gpointer _tmp25_ = NULL;
	gchar* _tmp26_;
	gint _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	gpointer _tmp30_ = NULL;
	gchar* _tmp31_;
	gpointer _tmp32_ = NULL;
	gchar* _tmp33_;
	gpointer _tmp34_ = NULL;
	gchar* _tmp35_;
	gint _tmp36_;
	gpointer _tmp37_ = NULL;
	gchar* _tmp38_;
	gpointer _tmp39_ = NULL;
	gchar* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		gpointer _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gee_list_remove_at (test_list, 0);
		_tmp4_ = (gchar*) _tmp3_;
		_g_free0 (_tmp4_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp5_) {
		gpointer _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = gee_list_remove_at (test_list, 1);
		_tmp7_ = (gchar*) _tmp6_;
		_g_free0 (_tmp7_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp8_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp10_);
	_tmp11_ = gee_collection_add ((GeeCollection*) test_list, "four");
	g_assert (_tmp11_);
	_tmp12_ = gee_collection_add ((GeeCollection*) test_list, "five");
	g_assert (_tmp12_);
	_tmp13_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp13_ == 5);
	_tmp14_ = gee_list_remove_at (test_list, 0);
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "one") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp16_ == 4);
	_tmp17_ = gee_list_get (test_list, 0);
	_tmp18_ = (gchar*) _tmp17_;
	g_assert (g_strcmp0 (_tmp18_, "two") == 0);
	_g_free0 (_tmp18_);
	_tmp19_ = gee_list_get (test_list, 1);
	_tmp20_ = (gchar*) _tmp19_;
	g_assert (g_strcmp0 (_tmp20_, "three") == 0);
	_g_free0 (_tmp20_);
	_tmp21_ = gee_list_get (test_list, 2);
	_tmp22_ = (gchar*) _tmp21_;
	g_assert (g_strcmp0 (_tmp22_, "four") == 0);
	_g_free0 (_tmp22_);
	_tmp23_ = gee_list_get (test_list, 3);
	_tmp24_ = (gchar*) _tmp23_;
	g_assert (g_strcmp0 (_tmp24_, "five") == 0);
	_g_free0 (_tmp24_);
	_tmp25_ = gee_list_remove_at (test_list, 3);
	_tmp26_ = (gchar*) _tmp25_;
	g_assert (g_strcmp0 (_tmp26_, "five") == 0);
	_g_free0 (_tmp26_);
	_tmp27_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp27_ == 3);
	_tmp28_ = gee_list_get (test_list, 0);
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "two") == 0);
	_g_free0 (_tmp29_);
	_tmp30_ = gee_list_get (test_list, 1);
	_tmp31_ = (gchar*) _tmp30_;
	g_assert (g_strcmp0 (_tmp31_, "three") == 0);
	_g_free0 (_tmp31_);
	_tmp32_ = gee_list_get (test_list, 2);
	_tmp33_ = (gchar*) _tmp32_;
	g_assert (g_strcmp0 (_tmp33_, "four") == 0);
	_g_free0 (_tmp33_);
	_tmp34_ = gee_list_remove_at (test_list, 1);
	_tmp35_ = (gchar*) _tmp34_;
	g_assert (g_strcmp0 (_tmp35_, "three") == 0);
	_g_free0 (_tmp35_);
	_tmp36_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp36_ == 2);
	_tmp37_ = gee_list_get (test_list, 0);
	_tmp38_ = (gchar*) _tmp37_;
	g_assert (g_strcmp0 (_tmp38_, "two") == 0);
	_g_free0 (_tmp38_);
	_tmp39_ = gee_list_get (test_list, 1);
	_tmp40_ = (gchar*) _tmp39_;
	g_assert (g_strcmp0 (_tmp40_, "four") == 0);
	_g_free0 (_tmp40_);
	_tmp41_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp41_) {
		gpointer _tmp42_ = NULL;
		gchar* _tmp43_;
		_tmp42_ = gee_list_remove_at (test_list, 2);
		_tmp43_ = (gchar*) _tmp42_;
		_g_free0 (_tmp43_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp44_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp44_) {
		gpointer _tmp45_ = NULL;
		gchar* _tmp46_;
		_tmp45_ = gee_list_remove_at (test_list, -1);
		_tmp46_ = (gchar*) _tmp45_;
		_g_free0 (_tmp46_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_index_of (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	gint _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = gee_list_index_of (test_list, "one");
	g_assert (_tmp2_ == (-1));
	_tmp3_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp3_);
	_tmp4_ = gee_list_index_of (test_list, "one");
	g_assert (_tmp4_ == 0);
	_tmp5_ = gee_list_index_of (test_list, "two");
	g_assert (_tmp5_ == (-1));
	_tmp6_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_list, "four");
	g_assert (_tmp8_);
	_tmp9_ = gee_list_index_of (test_list, "one");
	g_assert (_tmp9_ == 0);
	_tmp10_ = gee_list_index_of (test_list, "two");
	g_assert (_tmp10_ == 1);
	_tmp11_ = gee_list_index_of (test_list, "three");
	g_assert (_tmp11_ == 2);
	_tmp12_ = gee_list_index_of (test_list, "four");
	g_assert (_tmp12_ == 3);
	_tmp13_ = gee_list_index_of (test_list, "five");
	g_assert (_tmp13_ == (-1));
	_g_object_unref0 (test_list);
}


void list_tests_test_first (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gpointer _tmp6_ = NULL;
	gchar* _tmp7_;
	gpointer _tmp8_ = NULL;
	gchar* _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		gpointer _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gee_list_first (test_list);
		_tmp4_ = (gchar*) _tmp3_;
		_g_free0 (_tmp4_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_list_first (test_list);
	_tmp7_ = (gchar*) _tmp6_;
	g_assert (g_strcmp0 (_tmp7_, "one") == 0);
	_g_free0 (_tmp7_);
	_tmp8_ = gee_list_first (test_list);
	_tmp9_ = (gchar*) _tmp8_;
	_tmp10_ = gee_list_get (test_list, 0);
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp9_, _tmp11_) == 0);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp12_);
	_tmp13_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp13_);
	_tmp14_ = gee_list_first (test_list);
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "one") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_list_first (test_list);
	_tmp17_ = (gchar*) _tmp16_;
	_tmp18_ = gee_list_get (test_list, 0);
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp17_, _tmp19_) == 0);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	gee_collection_clear ((GeeCollection*) test_list);
	_tmp20_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp20_) {
		gpointer _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp21_ = gee_list_first (test_list);
		_tmp22_ = (gchar*) _tmp21_;
		_g_free0 (_tmp22_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_last (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gpointer _tmp6_ = NULL;
	gchar* _tmp7_;
	gpointer _tmp8_ = NULL;
	gchar* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gpointer _tmp15_ = NULL;
	gchar* _tmp16_;
	gpointer _tmp17_ = NULL;
	gchar* _tmp18_;
	gint _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		gpointer _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gee_list_last (test_list);
		_tmp4_ = (gchar*) _tmp3_;
		_g_free0 (_tmp4_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_list_last (test_list);
	_tmp7_ = (gchar*) _tmp6_;
	g_assert (g_strcmp0 (_tmp7_, "one") == 0);
	_g_free0 (_tmp7_);
	_tmp8_ = gee_list_last (test_list);
	_tmp9_ = (gchar*) _tmp8_;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp11_ = gee_list_get (test_list, _tmp10_ - 1);
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (g_strcmp0 (_tmp9_, _tmp12_) == 0);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_tmp13_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp13_);
	_tmp14_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp14_);
	_tmp15_ = gee_list_last (test_list);
	_tmp16_ = (gchar*) _tmp15_;
	g_assert (g_strcmp0 (_tmp16_, "three") == 0);
	_g_free0 (_tmp16_);
	_tmp17_ = gee_list_last (test_list);
	_tmp18_ = (gchar*) _tmp17_;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp20_ = gee_list_get (test_list, _tmp19_ - 1);
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp18_, _tmp21_) == 0);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	gee_collection_clear ((GeeCollection*) test_list);
	_tmp22_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp22_) {
		gpointer _tmp23_ = NULL;
		gchar* _tmp24_;
		_tmp23_ = gee_list_last (test_list);
		_tmp24_ = (gchar*) _tmp23_;
		_g_free0 (_tmp24_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_insert_all (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* dummy;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gpointer _tmp32_ = NULL;
	gchar* _tmp33_;
	gpointer _tmp34_ = NULL;
	gchar* _tmp35_;
	gpointer _tmp36_ = NULL;
	gchar* _tmp37_;
	gpointer _tmp38_ = NULL;
	gchar* _tmp39_;
	gpointer _tmp40_ = NULL;
	gchar* _tmp41_;
	gpointer _tmp42_ = NULL;
	gchar* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	gpointer _tmp55_ = NULL;
	gchar* _tmp56_;
	gpointer _tmp57_ = NULL;
	gchar* _tmp58_;
	gpointer _tmp59_ = NULL;
	gchar* _tmp60_;
	gpointer _tmp61_ = NULL;
	gchar* _tmp62_;
	gpointer _tmp63_ = NULL;
	gchar* _tmp64_;
	gpointer _tmp65_ = NULL;
	gchar* _tmp66_;
	gpointer _tmp67_ = NULL;
	gchar* _tmp68_;
	gboolean _tmp69_;
	gboolean _tmp70_;
	gboolean _tmp71_;
	gboolean _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	gpointer _tmp79_ = NULL;
	gchar* _tmp80_;
	gpointer _tmp81_ = NULL;
	gchar* _tmp82_;
	gpointer _tmp83_ = NULL;
	gchar* _tmp84_;
	gpointer _tmp85_ = NULL;
	gchar* _tmp86_;
	gpointer _tmp87_ = NULL;
	gchar* _tmp88_;
	gpointer _tmp89_ = NULL;
	gchar* _tmp90_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = _tmp2_;
	_tmp3_ = gee_collection_add ((GeeCollection*) test_list, "zero");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp6_ == 3);
	_tmp7_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	g_assert (_tmp7_);
	gee_list_insert_all (test_list, 0, (GeeCollection*) dummy);
	_tmp8_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp8_ == 3);
	_tmp9_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	g_assert (_tmp9_);
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp10_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "zero");
	g_assert (_tmp10_);
	_tmp11_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "one");
	g_assert (_tmp11_);
	_tmp12_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "two");
	g_assert (_tmp12_);
	_tmp13_ = gee_collection_get_is_empty ((GeeCollection*) test_list);
	g_assert (_tmp13_);
	_tmp14_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp14_ == 3);
	gee_list_insert_all (test_list, 0, (GeeCollection*) dummy);
	_tmp15_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp15_ == 3);
	_tmp16_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp16_ == 3);
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp17_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "zero");
	g_assert (_tmp17_);
	_tmp18_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "one");
	g_assert (_tmp18_);
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "two");
	g_assert (_tmp19_);
	_tmp20_ = gee_collection_get_is_empty ((GeeCollection*) test_list);
	g_assert (_tmp20_);
	_tmp21_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp21_) {
		gee_list_insert_all (test_list, 1, (GeeCollection*) dummy);
		exit (0);
	}
	g_test_trap_assert_failed ();
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp22_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp22_);
	_tmp23_ = gee_collection_add ((GeeCollection*) test_list, "four");
	g_assert (_tmp23_);
	_tmp24_ = gee_collection_add ((GeeCollection*) test_list, "five");
	g_assert (_tmp24_);
	_tmp25_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "zero");
	g_assert (_tmp25_);
	_tmp26_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "one");
	g_assert (_tmp26_);
	_tmp27_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "two");
	g_assert (_tmp27_);
	_tmp28_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp28_ == 3);
	_tmp29_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp29_ == 3);
	gee_list_insert_all (test_list, 0, (GeeCollection*) dummy);
	_tmp30_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp30_ == 6);
	_tmp31_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp31_ == 3);
	_tmp32_ = gee_list_get (test_list, 0);
	_tmp33_ = (gchar*) _tmp32_;
	g_assert (g_strcmp0 (_tmp33_, "zero") == 0);
	_g_free0 (_tmp33_);
	_tmp34_ = gee_list_get (test_list, 1);
	_tmp35_ = (gchar*) _tmp34_;
	g_assert (g_strcmp0 (_tmp35_, "one") == 0);
	_g_free0 (_tmp35_);
	_tmp36_ = gee_list_get (test_list, 2);
	_tmp37_ = (gchar*) _tmp36_;
	g_assert (g_strcmp0 (_tmp37_, "two") == 0);
	_g_free0 (_tmp37_);
	_tmp38_ = gee_list_get (test_list, 3);
	_tmp39_ = (gchar*) _tmp38_;
	g_assert (g_strcmp0 (_tmp39_, "three") == 0);
	_g_free0 (_tmp39_);
	_tmp40_ = gee_list_get (test_list, 4);
	_tmp41_ = (gchar*) _tmp40_;
	g_assert (g_strcmp0 (_tmp41_, "four") == 0);
	_g_free0 (_tmp41_);
	_tmp42_ = gee_list_get (test_list, 5);
	_tmp43_ = (gchar*) _tmp42_;
	g_assert (g_strcmp0 (_tmp43_, "five") == 0);
	_g_free0 (_tmp43_);
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp44_ = gee_collection_add ((GeeCollection*) test_list, "zero");
	g_assert (_tmp44_);
	_tmp45_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp45_);
	_tmp46_ = gee_collection_add ((GeeCollection*) test_list, "five");
	g_assert (_tmp46_);
	_tmp47_ = gee_collection_add ((GeeCollection*) test_list, "six");
	g_assert (_tmp47_);
	_tmp48_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "two");
	g_assert (_tmp48_);
	_tmp49_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "three");
	g_assert (_tmp49_);
	_tmp50_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "four");
	g_assert (_tmp50_);
	_tmp51_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp51_ == 4);
	_tmp52_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp52_ == 3);
	gee_list_insert_all (test_list, 2, (GeeCollection*) dummy);
	_tmp53_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp53_ == 7);
	_tmp54_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp54_ == 3);
	_tmp55_ = gee_list_get (test_list, 0);
	_tmp56_ = (gchar*) _tmp55_;
	g_assert (g_strcmp0 (_tmp56_, "zero") == 0);
	_g_free0 (_tmp56_);
	_tmp57_ = gee_list_get (test_list, 1);
	_tmp58_ = (gchar*) _tmp57_;
	g_assert (g_strcmp0 (_tmp58_, "one") == 0);
	_g_free0 (_tmp58_);
	_tmp59_ = gee_list_get (test_list, 2);
	_tmp60_ = (gchar*) _tmp59_;
	g_assert (g_strcmp0 (_tmp60_, "two") == 0);
	_g_free0 (_tmp60_);
	_tmp61_ = gee_list_get (test_list, 3);
	_tmp62_ = (gchar*) _tmp61_;
	g_assert (g_strcmp0 (_tmp62_, "three") == 0);
	_g_free0 (_tmp62_);
	_tmp63_ = gee_list_get (test_list, 4);
	_tmp64_ = (gchar*) _tmp63_;
	g_assert (g_strcmp0 (_tmp64_, "four") == 0);
	_g_free0 (_tmp64_);
	_tmp65_ = gee_list_get (test_list, 5);
	_tmp66_ = (gchar*) _tmp65_;
	g_assert (g_strcmp0 (_tmp66_, "five") == 0);
	_g_free0 (_tmp66_);
	_tmp67_ = gee_list_get (test_list, 6);
	_tmp68_ = (gchar*) _tmp67_;
	g_assert (g_strcmp0 (_tmp68_, "six") == 0);
	_g_free0 (_tmp68_);
	gee_collection_clear ((GeeCollection*) test_list);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp69_ = gee_collection_add ((GeeCollection*) test_list, "zero");
	g_assert (_tmp69_);
	_tmp70_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp70_);
	_tmp71_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp71_);
	_tmp72_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "three");
	g_assert (_tmp72_);
	_tmp73_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "four");
	g_assert (_tmp73_);
	_tmp74_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "five");
	g_assert (_tmp74_);
	_tmp75_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp75_ == 3);
	_tmp76_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp76_ == 3);
	gee_list_insert_all (test_list, 3, (GeeCollection*) dummy);
	_tmp77_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp77_ == 6);
	_tmp78_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp78_ == 3);
	_tmp79_ = gee_list_get (test_list, 0);
	_tmp80_ = (gchar*) _tmp79_;
	g_assert (g_strcmp0 (_tmp80_, "zero") == 0);
	_g_free0 (_tmp80_);
	_tmp81_ = gee_list_get (test_list, 1);
	_tmp82_ = (gchar*) _tmp81_;
	g_assert (g_strcmp0 (_tmp82_, "one") == 0);
	_g_free0 (_tmp82_);
	_tmp83_ = gee_list_get (test_list, 2);
	_tmp84_ = (gchar*) _tmp83_;
	g_assert (g_strcmp0 (_tmp84_, "two") == 0);
	_g_free0 (_tmp84_);
	_tmp85_ = gee_list_get (test_list, 3);
	_tmp86_ = (gchar*) _tmp85_;
	g_assert (g_strcmp0 (_tmp86_, "three") == 0);
	_g_free0 (_tmp86_);
	_tmp87_ = gee_list_get (test_list, 4);
	_tmp88_ = (gchar*) _tmp87_;
	g_assert (g_strcmp0 (_tmp88_, "four") == 0);
	_g_free0 (_tmp88_);
	_tmp89_ = gee_list_get (test_list, 5);
	_tmp90_ = (gchar*) _tmp89_;
	g_assert (g_strcmp0 (_tmp90_, "five") == 0);
	_g_free0 (_tmp90_);
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}


void list_tests_test_slice (ListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* test_list;
	GeeList* dummy = NULL;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gint _tmp11_;
	GeeList* _tmp12_ = NULL;
	GeeList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	test_list = _tmp1_;
	g_assert (test_list != NULL);
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		GeeList* _tmp3_ = NULL;
		GeeList* _tmp4_;
		_tmp3_ = gee_list_slice (test_list, 1, 4);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (dummy);
		dummy = _tmp4_;
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = gee_collection_add ((GeeCollection*) test_list, "zero");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_list, "one");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_list, "two");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_list, "three");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_list, "four");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_add ((GeeCollection*) test_list, "five");
	g_assert (_tmp10_);
	_tmp11_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp11_ == 6);
	_tmp12_ = gee_list_slice (test_list, 1, 4);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (dummy);
	dummy = _tmp13_;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) dummy);
	g_assert (_tmp14_ == 3);
	_tmp15_ = gee_collection_get_size ((GeeCollection*) test_list);
	g_assert (_tmp15_ == 6);
	_tmp16_ = gee_list_get (dummy, 0);
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "one") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_list_get (dummy, 1);
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "two") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_list_get (dummy, 2);
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "three") == 0);
	_g_free0 (_tmp21_);
	_tmp22_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp22_) {
		GeeList* _tmp23_ = NULL;
		GeeList* _tmp24_;
		_tmp23_ = gee_list_slice (test_list, 0, 9);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (dummy);
		dummy = _tmp24_;
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}


static void list_tests_class_init (ListTestsClass * klass) {
	list_tests_parent_class = g_type_class_peek_parent (klass);
	LIST_TESTS_CLASS (klass)->test_duplicates_are_retained = list_tests_real_test_duplicates_are_retained;
}


static void list_tests_instance_init (ListTests * self) {
}


GType list_tests_get_type (void) {
	static volatile gsize list_tests_type_id__volatile = 0;
	if (g_once_init_enter (&list_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListTests), 0, (GInstanceInitFunc) list_tests_instance_init, NULL };
		GType list_tests_type_id;
		list_tests_type_id = g_type_register_static (TYPE_COLLECTION_TESTS, "ListTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&list_tests_type_id__volatile, list_tests_type_id);
	}
	return list_tests_type_id__volatile;
}



