/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 36 "./parser.y"

#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libgda/sql-parser/gda-sql-parser-private.h>
#include <libgda/sql-parser/gda-statement-struct-util.h>
#include <libgda/sql-parser/gda-statement-struct-trans.h>
#include <libgda/sql-parser/gda-statement-struct-insert.h>
#include <libgda/sql-parser/gda-statement-struct-update.h>
#include <libgda/sql-parser/gda-statement-struct-delete.h>
#include <libgda/sql-parser/gda-statement-struct-select.h>
#include <libgda/sql-parser/gda-statement-struct-compound.h>
#include <libgda/sql-parser/gda-statement-struct-parts.h>
#include <assert.h>

typedef struct {
	GValue *fname;
	GdaSqlExpr *expr;
} UpdateSet;

typedef struct {
	gboolean    distinct;
	GdaSqlExpr *expr;
} Distinct;

typedef struct {
	GdaSqlExpr *count;
	GdaSqlExpr *offset;
} Limit;

typedef struct {
	GSList *when_list;
	GSList *then_list;
} CaseBody;

static GdaSqlOperatorType
sql_operation_string_to_operator (const gchar *op)
{
	switch (g_ascii_toupper (*op)) {
	case 'A':
		return GDA_SQL_OPERATOR_TYPE_AND;
	case 'O':
		return GDA_SQL_OPERATOR_TYPE_OR;
	case 'N':
		return GDA_SQL_OPERATOR_TYPE_NOT;
	case '=':
		return GDA_SQL_OPERATOR_TYPE_EQ;
	case 'I':
		if (op[1] == 'S')
			return GDA_SQL_OPERATOR_TYPE_IS;
		else if (op[1] == 'N')
			return GDA_SQL_OPERATOR_TYPE_IN;
		break;
	case 'L':
		return GDA_SQL_OPERATOR_TYPE_LIKE;
	case 'B':
		return GDA_SQL_OPERATOR_TYPE_BETWEEN;
	case '>':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_GEQ;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_GT;
		break;
	case '<':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_LEQ;
		else if (op[1] == '>')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_LT;
		break;
	case '!':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == '~') {
			if (op[2] == 0)
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP;
			else if (op[2] == '*')
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI;
		}
		break;
	case '~':
		if (op[1] == '*')
			return GDA_SQL_OPERATOR_TYPE_REGEXP_CI;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_REGEXP;
		break;
	case 'S':
		return GDA_SQL_OPERATOR_TYPE_SIMILAR;
	case '|':
		if (op[1] == '|')
			return GDA_SQL_OPERATOR_TYPE_CONCAT;
		else
			return GDA_SQL_OPERATOR_TYPE_BITOR;
	case '+':
		return GDA_SQL_OPERATOR_TYPE_PLUS;
	case '-':
		return GDA_SQL_OPERATOR_TYPE_MINUS;
	case '*':
		return GDA_SQL_OPERATOR_TYPE_STAR;
	case '/':
		return GDA_SQL_OPERATOR_TYPE_DIV;
	case '%':
		return GDA_SQL_OPERATOR_TYPE_REM;
	case '&':
		return GDA_SQL_OPERATOR_TYPE_BITAND;
	}
	g_error ("Unhandled operator named '%s'\n", op);
	return 0;
}

static GdaSqlOperatorType
string_to_op_type (GValue *value)
{
	GdaSqlOperatorType op;
	op = sql_operation_string_to_operator (g_value_get_string (value));
	g_value_reset (value);
	g_free (value);
	return op;
}

static GdaSqlExpr *
compose_multiple_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	if (left->cond && (left->cond->operator_type == op)) {
		ret = left;
		ret->cond->operands = g_slist_append (ret->cond->operands, right);
	}
	else {
		GdaSqlOperation *cond;
		ret = gda_sql_expr_new (NULL);
		cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
		ret->cond = cond;
		cond->operator_type = op;
		cond->operands = g_slist_prepend (NULL, right);
		GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
		cond->operands = g_slist_prepend (cond->operands, left);
		GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	}
	return ret;
}

static GdaSqlExpr *
create_two_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, right);
	GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
	cond->operands = g_slist_prepend (cond->operands, left);
	GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlExpr *
create_uni_expr (GdaSqlOperatorType op, GdaSqlExpr *expr) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, expr);
	GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlStatement *
compose_multiple_compounds (GdaSqlStatementCompoundType ctype, GdaSqlStatement *left, GdaSqlStatement *right) {
	GdaSqlStatement *ret = NULL;
	GdaSqlStatementCompound *lc = (GdaSqlStatementCompound*) left->contents;
	if (lc->compound_type == ctype) {
		GdaSqlStatementCompound *rc = (GdaSqlStatementCompound*) right->contents;
		if (!rc->stmt_list->next || rc->compound_type == ctype) {
			GSList *list;
			for (list = rc->stmt_list; list; list = list->next)
				GDA_SQL_ANY_PART (((GdaSqlStatement*)list->data)->contents)->parent = GDA_SQL_ANY_PART (lc);

			ret = left;
			lc->stmt_list = g_slist_concat (lc->stmt_list, rc->stmt_list);
			rc->stmt_list = NULL;
			gda_sql_statement_free (right);
		}
	}
	else {
		ret = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
		gda_sql_statement_compound_set_type (ret, ctype);
		gda_sql_statement_compound_take_stmt (ret, left);
		gda_sql_statement_compound_take_stmt (ret, right);
	}
	return ret;
}

#line 206 "parser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    gda_lemon_capi_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is gda_lemon_capi_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    gda_lemon_capi_parserARG_SDECL     A static variable declaration for the %extra_argument
**    gda_lemon_capi_parserARG_PDECL     A parameter declaration for the %extra_argument
**    gda_lemon_capi_parserARG_STORE     Code to store %extra_argument into yypParser
**    gda_lemon_capi_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 208
#define YYACTIONTYPE unsigned short int
#define gda_lemon_capi_parserTOKENTYPE GValue *
typedef union {
  int yyinit;
  gda_lemon_capi_parserTOKENTYPE yy0;
  Limit yy20;
  GdaSqlSelectFrom * yy59;
  GdaSqlExpr* yy122;
  Distinct * yy189;
  gboolean yy216;
  GdaSqlSelectTarget * yy224;
  GSList * yy247;
  CaseBody yy263;
  GdaTransactionIsolation yy307;
  GdaSqlStatement * yy308;
  GdaSqlSelectJoinType yy317;
  GdaSqlExpr * yy328;
  GdaSqlOperatorType yy381;
  GSList* yy393;
  GdaSqlParamSpec * yy405;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define gda_lemon_capi_parserARG_SDECL GdaSqlParserIface *pdata;
#define gda_lemon_capi_parserARG_PDECL ,GdaSqlParserIface *pdata
#define gda_lemon_capi_parserARG_FETCH GdaSqlParserIface *pdata = yypParser->pdata
#define gda_lemon_capi_parserARG_STORE yypParser->pdata = pdata
#define YYNSTATE 359
#define YYNRULE 195
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (1375)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    38,  167,  166,  165,  322,  334,   22,  358,  357,   36,
 /*    10 */    40,   40,   40,   40,   37,   37,   37,   37,   37,  290,
 /*    20 */    44,   44,   47,   47,   49,   49,   48,   46,   46,   41,
 /*    30 */   347,  217,  346,  345,  344,  343,  167,  166,  165,  359,
 /*    40 */    42,   43,  197,   13,  233,  333,   75,   39,   39,   36,
 /*    50 */    40,   40,   40,   40,   37,   37,   37,   37,   37,  360,
 /*    60 */    44,   44,  317,  165,   49,   49,   48,   46,   46,   41,
 /*    70 */   351,  316,  312,  223,  222,  194,  193,  192,  224,  241,
 /*    80 */   285,  199,  285,   38,  323,  283,   75,  283,  133,  313,
 /*    90 */   284,  132,  284,   21,  241,  131,  135,   37,   37,   37,
 /*   100 */    37,   37,   47,   44,   44,  356,  169,   49,   49,   48,
 /*   110 */    46,   46,   41,  167,  166,  165,  230,  214,  154,  214,
 /*   120 */   190,   34,  190,   42,   43,  197,   13,  233,  333,   75,
 /*   130 */    39,   39,   36,   40,   40,   40,   40,   37,   37,   37,
 /*   140 */    37,   37,  351,   44,   44,  297,  308,   49,   49,   48,
 /*   150 */    46,   46,   41,   38,   37,    1,   44,   44,  282,  281,
 /*   160 */    49,   49,   48,   46,   46,   41,  276,  275,   79,   75,
 /*   170 */   327,  352,  346,  345,  344,  343,   28,  178,   26,  306,
 /*   180 */   362,  127,   75,  221,   51,  167,  166,  165,  362,  362,
 /*   190 */   362,  395,  207,   42,   43,  197,   13,  233,  333,  140,
 /*   200 */    39,   39,   36,   40,   40,   40,   40,   37,   37,   37,
 /*   210 */    37,   37,  188,   44,   44,  126,  220,   49,   49,   48,
 /*   220 */    46,   46,   41,   38,  304,   45,  350,  370,  342,   49,
 /*   230 */    49,   48,   46,   46,   41,   48,   46,   46,   41,   75,
 /*   240 */    41,  370,  370,  352,  332,  280,  278,  189,  358,  357,
 /*   250 */   213,   75,  259,  258,  187,   75,  272,   75,   72,  150,
 /*   260 */   280,  219,  274,   42,   43,  197,   13,  233,  333,  318,
 /*   270 */    39,   39,   36,   40,   40,   40,   40,   37,   37,   37,
 /*   280 */    37,   37,  336,   44,   44,   54,  341,   49,   49,   48,
 /*   290 */    46,   46,   41,  337,  167,  166,  165,  139,  350,   38,
 /*   300 */    40,   40,   40,   40,   37,   37,   37,   37,   37,   75,
 /*   310 */    44,   44,  335,    6,   49,   49,   48,   46,   46,   41,
 /*   320 */   167,  166,  165,  324,  351,  263,  262,   65,  287,  134,
 /*   330 */   125,  167,  166,  165,  274,   50,   75,    3,   74,   42,
 /*   340 */    43,  197,   13,  233,  333,  168,   39,   39,   36,   40,
 /*   350 */    40,   40,   40,   37,   37,   37,   37,   37,    2,   44,
 /*   360 */    44,  315,   63,   49,   49,   48,   46,   46,   41,  177,
 /*   370 */   215,  149,  180,  241,  336,  238,  237,  285,  238,   38,
 /*   380 */   198,   60,  283,  321,  101,   75,  355,  284,  320,  355,
 /*   390 */   351,  152,  227,   11,  300,  395,  167,  166,  165,  167,
 /*   400 */   166,  165,   53,  147,  239,  348,  229,  239,  348,   10,
 /*   410 */   261,  260,   73,  129,  120,  339,   20,  190,   27,   42,
 /*   420 */    43,  197,   13,  233,  333,  352,   39,   39,   36,   40,
 /*   430 */    40,   40,   40,   37,   37,   37,   37,   37,  369,   44,
 /*   440 */    44,  351,  311,   49,   49,   48,   46,   46,   41,   18,
 /*   450 */   293,  176,  369,  369,   52,  351,  280,   81,  241,   38,
 /*   460 */   238,  241,  196,  238,  280,   75,  101,  267,  355,  100,
 /*   470 */   144,   59,  257,  274,  555,  141,  146,  119,  250,  202,
 /*   480 */   350,  338,  142,   55,  123,  140,  310,  249,   47,  239,
 /*   490 */   348,  352,  239,  348,  355,  159,   47,  309,   24,   42,
 /*   500 */    43,  197,   13,  233,  333,   47,   39,   39,   36,   40,
 /*   510 */    40,   40,   40,   37,   37,   37,   37,   37,  307,   44,
 /*   520 */    44,  351,  175,   49,   49,   48,   46,   46,   41,  241,
 /*   530 */   305,  238,   79,  195,  174,   38,  241,  101,  238,  355,
 /*   540 */    76,  241,  352,  238,   92,   75,  350,  248,  241,   87,
 /*   550 */   299,  355,  116,   56,  191,  303,  352,  225,   16,  288,
 /*   560 */   239,  348,  241,  140,  353,   73,  182,  239,  348,  241,
 /*   570 */   210,  234,  239,  348,   54,   42,   43,  197,   13,  233,
 /*   580 */   333,  351,   39,   39,   36,   40,   40,   40,   40,   37,
 /*   590 */    37,   37,   37,   37,  277,   44,   44,  350,  211,   49,
 /*   600 */    49,   48,   46,   46,   41,   38,  241,  216,  299,  180,
 /*   610 */   242,  350,  183,  241,  354,  296,  265,  173,  241,  273,
 /*   620 */   301,   75,  352,  269,  355,  274,  355,  355,   69,  274,
 /*   630 */   266,  355,  148,  241,  355,  145,  274,  172,  330,    9,
 /*   640 */   329,  209,  212,    8,  295,   42,   35,  197,   13,  233,
 /*   650 */   333,  205,   39,   39,   36,   40,   40,   40,   40,   37,
 /*   660 */    37,   37,   37,   37,  351,   44,   44,  331,  328,   49,
 /*   670 */    49,   48,   46,   46,   41,   38,  241,  350,  238,  241,
 /*   680 */   186,  238,  352,  185,  101,  181,  241,  101,  143,  292,
 /*   690 */   241,   75,  201,  241,  336,  200,    7,   70,  256,  247,
 /*   700 */    67,   57,  355,   15,  274,   14,  171,  239,  348,  170,
 /*   710 */   239,  348,  158,   80,  289,   42,   33,  197,   13,  233,
 /*   720 */   333,   50,   39,   39,   36,   40,   40,   40,   40,   37,
 /*   730 */    37,   37,   37,   37,   78,   44,   44,  350,   77,   49,
 /*   740 */    49,   48,   46,   46,   41,   38,  241,  336,  238,   75,
 /*   750 */   184,  237,  138,  238,  101,   25,  226,  157,   19,   62,
 /*   760 */   156,   75,  155,  228,   23,  352,   17,  294,  319,  279,
 /*   770 */   218,  214,  153,  271,   71,   54,  268,  239,  348,  172,
 /*   780 */   302,  291,  239,  348,  121,  264,   43,  197,   13,  233,
 /*   790 */   333,  351,   39,   39,   36,   40,   40,   40,   40,   37,
 /*   800 */    37,   37,   37,   37,   58,   44,   44,  351,   64,   49,
 /*   810 */    49,   48,   46,   46,   41,   38,  235,  179,  208,  241,
 /*   820 */   350,  238,  203,   68,  241,  204,  238,  105,  206,  246,
 /*   830 */    66,   75,   87,  351,  355,  244,  298,   82,  151,  240,
 /*   840 */   164,  232,  235,  245,  349,  254,  241,  253,  238,  130,
 /*   850 */   239,  348,  252,  236,  118,  239,  348,  197,   13,  233,
 /*   860 */   333,  124,   39,   39,   36,   40,   40,   40,   40,   37,
 /*   870 */    37,   37,   37,   37,   30,   44,   44,  239,  348,   49,
 /*   880 */    49,   48,   46,   46,   41,  241,  351,  238,  286,  122,
 /*   890 */   270,  556,  352,  136,  255,  243,   31,   32,  340,  251,
 /*   900 */    30,   75,  351,  314,  325,   29,    4,  241,  352,  238,
 /*   910 */   241,  235,  238,  556,  556,  104,  239,  348,  137,  556,
 /*   920 */   556,  556,   31,   32,  330,  556,  329,  556,  556,  556,
 /*   930 */   556,   29,    5,  556,  352,  556,  556,  140,  239,  348,
 /*   940 */   556,  239,  348,  556,  128,  556,  556,  350,  556,   12,
 /*   950 */   330,  556,  329,  331,  328,  231,  351,  556,  326,  556,
 /*   960 */   556,  556,  556,  350,  241,  235,  238,  556,  556,   30,
 /*   970 */   556,  556,   86,  556,  556,   12,  556,  556,  556,  331,
 /*   980 */   328,  231,  556,  556,  326,  556,  241,  352,  238,  350,
 /*   990 */   556,   31,   32,  340,  117,  239,  348,  241,  556,  238,
 /*  1000 */    29,    5,  556,  352,  241,  109,  238,  556,  556,  556,
 /*  1010 */   556,  556,  106,  556,  556,  556,  556,  239,  348,  330,
 /*  1020 */   556,  329,  556,   30,  556,  351,  556,  556,  239,  348,
 /*  1030 */   241,  556,  238,  556,  235,  239,  348,  556,  163,  241,
 /*  1040 */   556,  238,  350,  556,   12,   31,   32,  114,  331,  328,
 /*  1050 */   231,  556,  556,  326,   29,    4,  556,  352,  350,  556,
 /*  1060 */   556,  239,  348,  556,  556,  556,  556,  556,  556,  556,
 /*  1070 */   239,  348,  556,  330,  241,  329,  238,  241,  556,  238,
 /*  1080 */   556,  556,  112,  556,  556,  111,  140,  241,  556,  238,
 /*  1090 */   556,  556,   30,  556,  556,  115,  556,  556,   12,  556,
 /*  1100 */   556,  556,  331,  328,  231,  239,  348,  326,  239,  348,
 /*  1110 */   556,  556,  350,  556,   31,   32,  556,  556,  239,  348,
 /*  1120 */   241,  556,  238,   29,    5,  241,  352,  238,  103,  556,
 /*  1130 */   556,  556,  556,  113,  556,  556,  556,  556,  556,  556,
 /*  1140 */   556,  556,  330,  556,  329,  556,  556,  556,  556,  556,
 /*  1150 */   556,  239,  348,  556,  556,  556,  239,  348,  241,  556,
 /*  1160 */   238,  241,  556,  238,  556,  556,  102,   12,  556,  108,
 /*  1170 */   556,  331,  328,  231,  556,  241,  326,  238,  556,  556,
 /*  1180 */   556,  350,  556,  162,  556,  556,  556,  556,  556,  239,
 /*  1190 */   348,  556,  239,  348,  556,  241,  556,  238,  556,  556,
 /*  1200 */   241,  556,  238,  161,  556,  556,  239,  348,  107,  241,
 /*  1210 */   556,  238,  556,  556,  241,  556,  238,  160,  556,  556,
 /*  1220 */   556,  556,   85,  556,  556,  556,  239,  348,  241,  556,
 /*  1230 */   238,  239,  348,  556,  556,  556,   99,  556,  556,  556,
 /*  1240 */   239,  348,  556,  556,  556,  239,  348,  241,  556,  238,
 /*  1250 */   556,  556,  556,  556,  556,   98,  241,  556,  238,  239,
 /*  1260 */   348,  556,  556,  556,   84,  241,  556,  238,  241,  556,
 /*  1270 */   238,  556,  241,   97,  238,  241,   83,  238,  239,  348,
 /*  1280 */    96,  556,  241,   95,  238,  556,  556,  239,  348,  556,
 /*  1290 */    61,  556,  556,  241,  556,  238,  239,  348,  556,  239,
 /*  1300 */   348,   94,  556,  239,  348,  556,  239,  348,  556,  556,
 /*  1310 */   556,  556,  556,  239,  348,  556,  556,  556,  556,  556,
 /*  1320 */   556,  241,  556,  238,  239,  348,  241,  556,  238,   93,
 /*  1330 */   241,  556,  238,  241,   91,  238,  556,  241,   90,  238,
 /*  1340 */   556,   89,  241,  556,  238,   88,  556,  556,  556,  556,
 /*  1350 */   110,  556,  239,  348,  556,  556,  556,  239,  348,  556,
 /*  1360 */   556,  239,  348,  556,  239,  348,  556,  556,  239,  348,
 /*  1370 */   556,  556,  556,  239,  348,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    26,  109,  110,  111,  101,  101,   32,  115,  116,   75,
 /*    10 */    76,   77,   78,   79,   80,   81,   82,   83,   84,  130,
 /*    20 */    86,   87,  119,  119,   90,   91,   92,   93,   94,   95,
 /*    30 */   151,  142,  153,  154,  155,  156,  109,  110,  111,    0,
 /*    40 */    66,   67,   68,   69,   70,   71,  112,   73,   74,   75,
 /*    50 */    76,   77,   78,   79,   80,   81,   82,   83,   84,    0,
 /*    60 */    86,   87,    5,  111,   90,   91,   92,   93,   94,   95,
 /*    70 */     1,   14,  102,  103,  104,  105,  106,  107,  108,  169,
 /*    80 */    13,  171,   13,   26,  101,   18,  112,   18,  178,  119,
 /*    90 */    23,  140,   23,  119,  169,  140,  171,   80,   81,   82,
 /*   100 */    83,   84,  119,   86,   87,  101,  150,   90,   91,   92,
 /*   110 */    93,   94,   95,  109,  110,  111,   70,   50,  193,   50,
 /*   120 */    53,   75,   53,   66,   67,   68,   69,   70,   71,  112,
 /*   130 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   140 */    83,   84,    1,   86,   87,    1,  102,   90,   91,   92,
 /*   150 */    93,   94,   95,   26,   84,  100,   86,   87,   57,   58,
 /*   160 */    90,   91,   92,   93,   94,   95,   54,   55,  100,  112,
 /*   170 */   151,  102,  153,  154,  155,  156,  144,  101,  146,  102,
 /*   180 */   101,  140,  112,  139,  117,  109,  110,  111,  109,  110,
 /*   190 */   111,   50,  124,   66,   67,   68,   69,   70,   71,  131,
 /*   200 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   210 */    83,   84,   23,   86,   87,  140,  139,   90,   91,   92,
 /*   220 */    93,   94,   95,   26,  102,  100,  157,  101,  101,   90,
 /*   230 */    91,   92,   93,   94,   95,   92,   93,   94,   95,  112,
 /*   240 */    95,  115,  116,  102,   17,  119,   52,   53,  115,  116,
 /*   250 */    56,  112,   63,   64,   65,  112,  163,  112,  117,  166,
 /*   260 */   119,  139,  169,   66,   67,   68,   69,   70,   71,  189,
 /*   270 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   280 */    83,   84,  202,   86,   87,  141,  101,   90,   91,   92,
 /*   290 */    93,   94,   95,  101,  109,  110,  111,  182,  157,   26,
 /*   300 */    76,   77,   78,   79,   80,   81,   82,   83,   84,  112,
 /*   310 */    86,   87,  101,  198,   90,   91,   92,   93,   94,   95,
 /*   320 */   109,  110,  111,  101,    1,   63,   64,  119,  163,  164,
 /*   330 */   165,  109,  110,  111,  169,  127,  112,  100,  141,   66,
 /*   340 */    67,   68,   69,   70,   71,  150,   73,   74,   75,   76,
 /*   350 */    77,   78,   79,   80,   81,   82,   83,   84,  100,   86,
 /*   360 */    87,  189,    8,   90,   91,   92,   93,   94,   95,  162,
 /*   370 */   160,   17,  162,  169,  202,  171,  169,   13,  171,   26,
 /*   380 */   173,  177,   18,  101,  177,  112,  179,   23,  101,  179,
 /*   390 */     1,  101,  188,  134,  101,   50,  109,  110,  111,  109,
 /*   400 */   110,  111,   48,   49,  200,  201,  199,  200,  201,  134,
 /*   410 */    63,   64,  119,   59,   60,   92,  119,   53,  145,   66,
 /*   420 */    67,   68,   69,   70,   71,  102,   73,   74,   75,   76,
 /*   430 */    77,   78,   79,   80,   81,   82,   83,   84,  101,   86,
 /*   440 */    87,    1,  102,   90,   91,   92,   93,   94,   95,  119,
 /*   450 */   119,  162,  115,  116,  100,    1,  119,  126,  169,   26,
 /*   460 */   171,  169,  173,  171,  119,  112,  177,  163,  179,  177,
 /*   470 */   101,  100,  168,  169,  159,  160,  122,  162,  101,  125,
 /*   480 */   157,   92,  128,  164,  165,  131,  102,  101,  119,  200,
 /*   490 */   201,  102,  200,  201,  179,  203,  119,  102,  145,   66,
 /*   500 */    67,   68,   69,   70,   71,  119,   73,   74,   75,   76,
 /*   510 */    77,   78,   79,   80,   81,   82,   83,   84,  102,   86,
 /*   520 */    87,    1,  162,   90,   91,   92,   93,   94,   95,  169,
 /*   530 */   102,  171,  100,  173,  162,   26,  169,  177,  171,  179,
 /*   540 */   100,  169,  102,  171,  177,  112,  157,  101,  169,  177,
 /*   550 */   171,  179,  191,  192,  175,  102,  102,  190,  138,  101,
 /*   560 */   200,  201,  169,  131,  171,  119,   51,  200,  201,  169,
 /*   570 */   119,  171,  200,  201,  141,   66,   67,   68,   69,   70,
 /*   580 */    71,    1,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   590 */    81,   82,   83,   84,   53,   86,   87,  157,  118,   90,
 /*   600 */    91,   92,   93,   94,   95,   26,  169,  162,  171,  162,
 /*   610 */   162,  157,  175,  169,  162,  171,  120,  162,  169,  163,
 /*   620 */   171,  112,  102,  163,  179,  169,  179,  179,  123,  169,
 /*   630 */   163,  179,  118,  169,  179,  171,  169,   57,  118,  100,
 /*   640 */   120,   61,   62,  100,  200,   66,   67,   68,   69,   70,
 /*   650 */    71,  119,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   660 */    81,   82,   83,   84,    1,   86,   87,  147,  148,   90,
 /*   670 */    91,   92,   93,   94,   95,   26,  169,  157,  171,  169,
 /*   680 */   173,  171,  102,  173,  177,  162,  169,  177,  171,  197,
 /*   690 */   169,  112,  171,  169,  202,  171,  100,  117,  163,    1,
 /*   700 */   126,  129,  179,   74,  169,   74,  206,  200,  201,  206,
 /*   710 */   200,  201,  176,  180,  130,   66,   67,   68,   69,   70,
 /*   720 */    71,  127,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   730 */    81,   82,   83,   84,  180,   86,   87,  157,  180,   90,
 /*   740 */    91,   92,   93,   94,   95,   26,  169,  202,  171,  112,
 /*   750 */   173,  169,  204,  171,  177,  144,  136,  184,  135,  177,
 /*   760 */   185,  112,  186,  133,  132,  102,  138,  197,  187,  165,
 /*   770 */   137,   50,  194,  165,  167,  141,  117,  200,  201,   57,
 /*   780 */   195,  199,  200,  201,  121,  168,   67,   68,   69,   70,
 /*   790 */    71,    1,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   800 */    81,   82,   83,   84,  100,   86,   87,    1,  167,   90,
 /*   810 */    91,   92,   93,   94,   95,   26,   10,  162,  170,  169,
 /*   820 */   157,  171,   66,  172,  169,  119,  171,  177,  174,  176,
 /*   830 */   170,  112,  177,    1,  179,  161,  197,  181,  166,  169,
 /*   840 */   183,  205,   10,  176,  169,  169,  169,  169,  171,   59,
 /*   850 */   200,  201,  169,  169,  177,  200,  201,   68,   69,   70,
 /*   860 */    71,  166,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   870 */    81,   82,   83,   84,   68,   86,   87,  200,  201,   90,
 /*   880 */    91,   92,   93,   94,   95,  169,    1,  171,  164,  166,
 /*   890 */   164,  207,  102,  177,  169,  161,   90,   91,   92,  169,
 /*   900 */    68,  112,    1,  196,   72,   99,  100,  169,  102,  171,
 /*   910 */   169,   10,  171,  207,  207,  177,  200,  201,  177,  207,
 /*   920 */   207,  207,   90,   91,  118,  207,  120,  207,  207,  207,
 /*   930 */   207,   99,  100,  207,  102,  207,  207,  131,  200,  201,
 /*   940 */   207,  200,  201,  207,   59,  207,  207,  157,  207,  143,
 /*   950 */   118,  207,  120,  147,  148,  149,    1,  207,  152,  207,
 /*   960 */   207,  207,  207,  157,  169,   10,  171,  207,  207,   68,
 /*   970 */   207,  207,  177,  207,  207,  143,  207,  207,  207,  147,
 /*   980 */   148,  149,  207,  207,  152,  207,  169,  102,  171,  157,
 /*   990 */   207,   90,   91,   92,  177,  200,  201,  169,  207,  171,
 /*  1000 */    99,  100,  207,  102,  169,  177,  171,  207,  207,  207,
 /*  1010 */   207,  207,  177,  207,  207,  207,  207,  200,  201,  118,
 /*  1020 */   207,  120,  207,   68,  207,    1,  207,  207,  200,  201,
 /*  1030 */   169,  207,  171,  207,   10,  200,  201,  207,  177,  169,
 /*  1040 */   207,  171,  157,  207,  143,   90,   91,  177,  147,  148,
 /*  1050 */   149,  207,  207,  152,   99,  100,  207,  102,  157,  207,
 /*  1060 */   207,  200,  201,  207,  207,  207,  207,  207,  207,  207,
 /*  1070 */   200,  201,  207,  118,  169,  120,  171,  169,  207,  171,
 /*  1080 */   207,  207,  177,  207,  207,  177,  131,  169,  207,  171,
 /*  1090 */   207,  207,   68,  207,  207,  177,  207,  207,  143,  207,
 /*  1100 */   207,  207,  147,  148,  149,  200,  201,  152,  200,  201,
 /*  1110 */   207,  207,  157,  207,   90,   91,  207,  207,  200,  201,
 /*  1120 */   169,  207,  171,   99,  100,  169,  102,  171,  177,  207,
 /*  1130 */   207,  207,  207,  177,  207,  207,  207,  207,  207,  207,
 /*  1140 */   207,  207,  118,  207,  120,  207,  207,  207,  207,  207,
 /*  1150 */   207,  200,  201,  207,  207,  207,  200,  201,  169,  207,
 /*  1160 */   171,  169,  207,  171,  207,  207,  177,  143,  207,  177,
 /*  1170 */   207,  147,  148,  149,  207,  169,  152,  171,  207,  207,
 /*  1180 */   207,  157,  207,  177,  207,  207,  207,  207,  207,  200,
 /*  1190 */   201,  207,  200,  201,  207,  169,  207,  171,  207,  207,
 /*  1200 */   169,  207,  171,  177,  207,  207,  200,  201,  177,  169,
 /*  1210 */   207,  171,  207,  207,  169,  207,  171,  177,  207,  207,
 /*  1220 */   207,  207,  177,  207,  207,  207,  200,  201,  169,  207,
 /*  1230 */   171,  200,  201,  207,  207,  207,  177,  207,  207,  207,
 /*  1240 */   200,  201,  207,  207,  207,  200,  201,  169,  207,  171,
 /*  1250 */   207,  207,  207,  207,  207,  177,  169,  207,  171,  200,
 /*  1260 */   201,  207,  207,  207,  177,  169,  207,  171,  169,  207,
 /*  1270 */   171,  207,  169,  177,  171,  169,  177,  171,  200,  201,
 /*  1280 */   177,  207,  169,  177,  171,  207,  207,  200,  201,  207,
 /*  1290 */   177,  207,  207,  169,  207,  171,  200,  201,  207,  200,
 /*  1300 */   201,  177,  207,  200,  201,  207,  200,  201,  207,  207,
 /*  1310 */   207,  207,  207,  200,  201,  207,  207,  207,  207,  207,
 /*  1320 */   207,  169,  207,  171,  200,  201,  169,  207,  171,  177,
 /*  1330 */   169,  207,  171,  169,  177,  171,  207,  169,  177,  171,
 /*  1340 */   207,  177,  169,  207,  171,  177,  207,  207,  207,  207,
 /*  1350 */   177,  207,  200,  201,  207,  207,  207,  200,  201,  207,
 /*  1360 */   207,  200,  201,  207,  200,  201,  207,  207,  200,  201,
 /*  1370 */   207,  207,  207,  200,  201,
};
#define YY_SHIFT_USE_DFLT (-122)
#define YY_SHIFT_COUNT (244)
#define YY_SHIFT_MIN   (-121)
#define YY_SHIFT_MAX   (1024)
static const short yy_shift_ofst[] = {
 /*     0 */   354,  806,  955,  955,  955,  955,  901, 1024, 1024, 1024,
 /*    10 */  1024, 1024, 1024,  832, 1024, 1024, 1024, 1024, 1024, 1024,
 /*    20 */  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
 /*    30 */  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
 /*    40 */  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
 /*    50 */  1024,   69,  354,  580,  520,  141,  440,  454,  454,  454,
 /*    60 */    57,   57,  433,   67,  663,  454,  454,  454,   68,  454,
 /*    70 */   454,  454,  454,  454,  454,  454,  432,  432,  432,  432,
 /*    80 */   432, -122, -122,  -26,  353,  273,  197,  127,  509,  509,
 /*    90 */   509,  509,  509,  509,  509,  509,  509,  509,  509,  509,
 /*   100 */   509,  509,  649,  579,  509,  509,  719,  789,  789,  789,
 /*   110 */   -66,  -66,  -66,  224,   17,   70,  -30,  139,  143, -108,
 /*   120 */   885,  790,  364,  337,  364,  126,  389,  323,  454,  454,
 /*   130 */   454,  454,  454,  208,  345,  144,  145,  145,   32,  331,
 /*   140 */  -111,  133,  756,  594,  706,  704,  756,  659,  722,  659,
 /*   150 */   721,  721,  634,  633,  628,  632,  630,  623,  620,  611,
 /*   160 */   637,  637,  637,  637,  594,  584,  584,  584, -122, -122,
 /*   170 */    19, -121,  189,  290,  287,  222,  211,  185,   79,   76,
 /*   180 */     4,  -73,  194,  446,  386,  377,  369,  347,  262,  112,
 /*   190 */   101,  293,  122,   77,   44,  -17,  -96,   46,  -97,  631,
 /*   200 */   629,  572,  574,  698,  596,  543,  532,  539,  505,  514,
 /*   210 */   496,  451,  480,  541,  515,  458,  -48,  420,  371,  453,
 /*   220 */   428,  416,  395,  384,  340,  330,  275,  297,  259,  282,
 /*   230 */   258,  195,  227,  237,  192,  125,   75,   41,   55,  -44,
 /*   240 */   -45,  -49,  -48,   59,   39,
};
#define YY_REDUCE_USE_DFLT (-91)
#define YY_REDUCE_COUNT (169)
#define YY_REDUCE_MIN   (-90)
#define YY_REDUCE_MAX   (1173)
static const short yy_reduce_ofst[] = {
 /*     0 */   315,  207,  360,  289,  655,  372,  582,  577,  510,  507,
 /*    10 */   367,  204,  292, 1173, 1168, 1164, 1161, 1157, 1152, 1124,
 /*    20 */  1113, 1106, 1103, 1099, 1096, 1087, 1078, 1059, 1045, 1040,
 /*    30 */  1031, 1026, 1006,  992,  989,  956,  951,  918,  908,  905,
 /*    40 */   870,  861,  835,  828,  817,  795,  741,  738,  716,  677,
 /*    50 */   650,  165,  210,  304,  444,   93,  -75,  -90,  437,  379,
 /*    60 */   172,   80,  492,  319,  535,  524,  521,  517,  523,  464,
 /*    70 */   467,  460,  456,  449,  400,  393,  455,  452,  448,  447,
 /*    80 */   445,  361,  115,  545,  545,  545,  545,  545,  545,  545,
 /*    90 */   545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
 /*   100 */   545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
 /*   110 */   545,  545,  545,  545,  545,  545,  707,  545,  545,  734,
 /*   120 */   730,  725,  726,  723,  724,  695,  675,  684,  683,  678,
 /*   130 */   676,  675,  670,  667,  672,  639,  545,  545,  636,  657,
 /*   140 */   656,  674,  660,  653,  654,  651,  648,  641,  617,  607,
 /*   150 */   608,  604,  570,  585,  578,  581,  576,  575,  573,  548,
 /*   160 */   545,  545,  545,  545,  536,  558,  554,  533,  503,  500,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   554,  491,  491,  491,  554,  554,  554,  491,  491,  491,
 /*    10 */   554,  554,  529,  554,  554,  554,  554,  554,  554,  554,
 /*    20 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    30 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    40 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    50 */   554,  401,  554,  401,  554,  401,  554,  554,  554,  554,
 /*    60 */   447,  447,  484,  365,  401,  554,  554,  554,  554,  554,
 /*    70 */   401,  401,  401,  554,  554,  554,  554,  554,  554,  554,
 /*    80 */   554,  457,  476,  438,  554,  554,  554,  554,  429,  428,
 /*    90 */   488,  459,  490,  489,  449,  440,  439,  531,  532,  530,
 /*   100 */   528,  493,  554,  554,  492,  426,  510,  518,  517,  509,
 /*   110 */   521,  514,  513,  516,  512,  515,  453,  506,  503,  554,
 /*   120 */   554,  554,  554,  395,  554,  395,  554,  554,  554,  554,
 /*   130 */   554,  554,  554,  425,  371,  484,  504,  505,  533,  452,
 /*   140 */   485,  554,  416,  425,  413,  420,  416,  393,  381,  393,
 /*   150 */   554,  554,  484,  456,  460,  437,  441,  448,  450,  554,
 /*   160 */   519,  508,  507,  511,  425,  434,  434,  434,  543,  543,
 /*   170 */   554,  554,  554,  554,  554,  554,  554,  554,  522,  554,
 /*   180 */   554,  415,  554,  554,  554,  554,  554,  386,  385,  554,
 /*   190 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*   200 */   554,  554,  554,  554,  554,  554,  414,  554,  554,  554,
 /*   210 */   554,  379,  554,  554,  554,  554,  431,  487,  554,  554,
 /*   220 */   554,  554,  554,  554,  554,  451,  554,  442,  554,  554,
 /*   230 */   554,  554,  554,  554,  554,  554,  552,  551,  497,  495,
 /*   240 */   552,  551,  432,  554,  554,  427,  424,  417,  421,  419,
 /*   250 */   418,  410,  409,  408,  412,  411,  384,  383,  388,  387,
 /*   260 */   392,  391,  390,  389,  382,  380,  378,  377,  394,  376,
 /*   270 */   375,  374,  368,  367,  402,  400,  399,  398,  397,  372,
 /*   280 */   396,  407,  406,  405,  404,  403,  373,  366,  361,  435,
 /*   290 */   486,  478,  477,  475,  474,  483,  482,  473,  472,  423,
 /*   300 */   455,  422,  454,  471,  470,  469,  468,  467,  466,  465,
 /*   310 */   464,  463,  462,  461,  458,  444,  446,  445,  443,  436,
 /*   320 */   522,  500,  498,  525,  526,  535,  542,  540,  539,  538,
 /*   330 */   537,  536,  527,  534,  523,  524,  520,  501,  481,  480,
 /*   340 */   479,  499,  496,  547,  546,  545,  544,  541,  494,  553,
 /*   350 */   550,  549,  548,  502,  433,  430,  362,  364,  363,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         ID => nothing */
    1,  /*      ABORT => ID */
    1,  /*      AFTER => ID */
    1,  /*    ANALYZE => ID */
    1,  /*        ASC => ID */
    1,  /*     ATTACH => ID */
    1,  /*     BEFORE => ID */
    1,  /*      BEGIN => ID */
    1,  /*    CASCADE => ID */
    1,  /*       CAST => ID */
    1,  /*   CONFLICT => ID */
    1,  /*   DATABASE => ID */
    1,  /*   DEFERRED => ID */
    1,  /*       DESC => ID */
    1,  /*     DETACH => ID */
    1,  /*       EACH => ID */
    1,  /*        END => ID */
    1,  /*  EXCLUSIVE => ID */
    1,  /*    EXPLAIN => ID */
    1,  /*       FAIL => ID */
    1,  /*        FOR => ID */
    1,  /*     IGNORE => ID */
    1,  /*  IMMEDIATE => ID */
    1,  /*  INITIALLY => ID */
    1,  /*    INSTEAD => ID */
    1,  /*       LIKE => ID */
    1,  /*      MATCH => ID */
    1,  /*       PLAN => ID */
    1,  /*      QUERY => ID */
    1,  /*        KEY => ID */
    1,  /*         OF => ID */
    1,  /*     OFFSET => ID */
    1,  /*     PRAGMA => ID */
    1,  /*      RAISE => ID */
    1,  /*    REPLACE => ID */
    1,  /*   RESTRICT => ID */
    1,  /*        ROW => ID */
    1,  /*       TEMP => ID */
    1,  /*    TRIGGER => ID */
    1,  /*     VACUUM => ID */
    1,  /*       VIEW => ID */
    1,  /*    VIRTUAL => ID */
    1,  /*    REINDEX => ID */
    1,  /*     RENAME => ID */
    1,  /*   CTIME_KW => ID */
    1,  /*         IF => ID */
    1,  /*  DELIMITER => ID */
    1,  /*     COMMIT => ID */
    1,  /*   ROLLBACK => ID */
    1,  /*  ISOLATION => ID */
    1,  /*      LEVEL => ID */
    1,  /* SERIALIZABLE => ID */
    1,  /*       READ => ID */
    1,  /*  COMMITTED => ID */
    1,  /* UNCOMMITTED => ID */
    1,  /* REPEATABLE => ID */
    1,  /*      WRITE => ID */
    1,  /*       ONLY => ID */
    1,  /*  SAVEPOINT => ID */
    1,  /*    RELEASE => ID */
    1,  /*    COMMENT => ID */
    1,  /*      FORCE => ID */
    1,  /*       WAIT => ID */
    1,  /*     NOWAIT => ID */
    1,  /*      BATCH => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  gda_lemon_capi_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void gda_lemon_capi_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ID",            "ABORT",         "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "END",           "EXCLUSIVE",     "EXPLAIN",     
  "FAIL",          "FOR",           "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "MATCH",       
  "PLAN",          "QUERY",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "TEMP",          "TRIGGER",     
  "VACUUM",        "VIEW",          "VIRTUAL",       "REINDEX",     
  "RENAME",        "CTIME_KW",      "IF",            "DELIMITER",   
  "COMMIT",        "ROLLBACK",      "ISOLATION",     "LEVEL",       
  "SERIALIZABLE",  "READ",          "COMMITTED",     "UNCOMMITTED", 
  "REPEATABLE",    "WRITE",         "ONLY",          "SAVEPOINT",   
  "RELEASE",       "COMMENT",       "FORCE",         "WAIT",        
  "NOWAIT",        "BATCH",         "OR",            "AND",         
  "NOT",           "IS",            "IN",            "ISNULL",      
  "NOTNULL",       "DIFF",          "EQ",            "BETWEEN",     
  "GT",            "LEQ",           "LT",            "GEQ",         
  "REGEXP",        "REGEXP_CI",     "NOT_REGEXP",    "NOT_REGEXP_CI",
  "SIMILAR",       "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "LP",            "RP",            "JOIN",          "INNER",       
  "NATURAL",       "LEFT",          "RIGHT",         "FULL",        
  "CROSS",         "UNION",         "EXCEPT",        "INTERSECT",   
  "PGCAST",        "ILLEGAL",       "SQLCOMMENT",    "SEMI",        
  "END_OF_FILE",   "TRANSACTION",   "STRING",        "COMMA",       
  "INTEGER",       "TO",            "INSERT",        "INTO",        
  "VALUES",        "DELETE",        "FROM",          "WHERE",       
  "UPDATE",        "SET",           "ALL",           "SELECT",      
  "LIMIT",         "ORDER",         "BY",            "HAVING",      
  "GROUP",         "USING",         "ON",            "OUTER",       
  "DOT",           "AS",            "DISTINCT",      "CASE",        
  "WHEN",          "THEN",          "ELSE",          "NULL",        
  "FLOAT",         "UNSPECVAL",     "LSBRACKET",     "RSBRACKET",   
  "SIMPLEPARAM",   "PNAME",         "PDESCR",        "PTYPE",       
  "PNULLOK",       "TEXTUAL",       "error",         "stmt",        
  "cmd",           "eos",           "compound",      "nm_opt",      
  "transtype",     "transilev",     "opt_comma",     "trans_opt_kw",
  "ora_commit_write",  "nm",            "opt_on_conflict",  "fullname",    
  "inscollist_opt",  "exprlist",      "ins_extra_values",  "inscollist",  
  "where_opt",     "expr",          "setlist",       "selectcmd",   
  "opt_compound_all",  "distinct",      "selcollist",    "from",        
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sortlist",      "sortorder",     "nexprlist",     "seltablist",  
  "stl_prefix",    "seltarget",     "on_cond",       "using_opt",   
  "jointype",      "as",            "sclp",          "starname",    
  "value",         "pvalue",        "uni_op",        "case_operand",
  "case_exprlist",  "case_else",     "paramspec",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stmt ::= cmd eos",
 /*   1 */ "stmt ::= compound eos",
 /*   2 */ "cmd ::= LP cmd RP",
 /*   3 */ "compound ::= LP compound RP",
 /*   4 */ "eos ::= SEMI",
 /*   5 */ "eos ::= END_OF_FILE",
 /*   6 */ "cmd ::= BEGIN",
 /*   7 */ "cmd ::= BEGIN TRANSACTION nm_opt",
 /*   8 */ "cmd ::= BEGIN transtype TRANSACTION nm_opt",
 /*   9 */ "cmd ::= BEGIN transtype nm_opt",
 /*  10 */ "cmd ::= BEGIN transilev",
 /*  11 */ "cmd ::= BEGIN TRANSACTION transilev",
 /*  12 */ "cmd ::= BEGIN TRANSACTION transtype",
 /*  13 */ "cmd ::= BEGIN TRANSACTION transtype opt_comma transilev",
 /*  14 */ "cmd ::= BEGIN TRANSACTION transilev opt_comma transtype",
 /*  15 */ "cmd ::= BEGIN transtype opt_comma transilev",
 /*  16 */ "cmd ::= BEGIN transilev opt_comma transtype",
 /*  17 */ "cmd ::= END trans_opt_kw nm_opt",
 /*  18 */ "cmd ::= COMMIT nm_opt",
 /*  19 */ "cmd ::= COMMIT TRANSACTION nm_opt",
 /*  20 */ "cmd ::= COMMIT FORCE STRING",
 /*  21 */ "cmd ::= COMMIT FORCE STRING COMMA INTEGER",
 /*  22 */ "cmd ::= COMMIT COMMENT STRING",
 /*  23 */ "cmd ::= COMMIT COMMENT STRING ora_commit_write",
 /*  24 */ "cmd ::= COMMIT ora_commit_write",
 /*  25 */ "cmd ::= ROLLBACK trans_opt_kw nm_opt",
 /*  26 */ "ora_commit_write ::= WRITE IMMEDIATE",
 /*  27 */ "ora_commit_write ::= WRITE BATCH",
 /*  28 */ "ora_commit_write ::= WRITE WAIT",
 /*  29 */ "ora_commit_write ::= WRITE NOWAIT",
 /*  30 */ "ora_commit_write ::= WRITE IMMEDIATE WAIT",
 /*  31 */ "ora_commit_write ::= WRITE IMMEDIATE NOWAIT",
 /*  32 */ "ora_commit_write ::= WRITE BATCH WAIT",
 /*  33 */ "ora_commit_write ::= WRITE BATCH NOWAIT",
 /*  34 */ "trans_opt_kw ::=",
 /*  35 */ "trans_opt_kw ::= TRANSACTION",
 /*  36 */ "opt_comma ::=",
 /*  37 */ "opt_comma ::= COMMA",
 /*  38 */ "transilev ::= ISOLATION LEVEL SERIALIZABLE",
 /*  39 */ "transilev ::= ISOLATION LEVEL REPEATABLE READ",
 /*  40 */ "transilev ::= ISOLATION LEVEL READ COMMITTED",
 /*  41 */ "transilev ::= ISOLATION LEVEL READ UNCOMMITTED",
 /*  42 */ "nm_opt ::=",
 /*  43 */ "nm_opt ::= nm",
 /*  44 */ "transtype ::= DEFERRED",
 /*  45 */ "transtype ::= IMMEDIATE",
 /*  46 */ "transtype ::= EXCLUSIVE",
 /*  47 */ "transtype ::= READ WRITE",
 /*  48 */ "transtype ::= READ ONLY",
 /*  49 */ "cmd ::= SAVEPOINT nm",
 /*  50 */ "cmd ::= RELEASE SAVEPOINT nm",
 /*  51 */ "cmd ::= RELEASE nm",
 /*  52 */ "cmd ::= ROLLBACK trans_opt_kw TO nm",
 /*  53 */ "cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm",
 /*  54 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP",
 /*  55 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values",
 /*  56 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound",
 /*  57 */ "opt_on_conflict ::=",
 /*  58 */ "opt_on_conflict ::= OR ID",
 /*  59 */ "ins_extra_values ::= ins_extra_values COMMA LP exprlist RP",
 /*  60 */ "ins_extra_values ::= COMMA LP exprlist RP",
 /*  61 */ "inscollist_opt ::=",
 /*  62 */ "inscollist_opt ::= LP inscollist RP",
 /*  63 */ "inscollist ::= inscollist COMMA fullname",
 /*  64 */ "inscollist ::= fullname",
 /*  65 */ "cmd ::= DELETE FROM fullname where_opt",
 /*  66 */ "where_opt ::=",
 /*  67 */ "where_opt ::= WHERE expr",
 /*  68 */ "cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt",
 /*  69 */ "setlist ::= setlist COMMA fullname EQ expr",
 /*  70 */ "setlist ::= fullname EQ expr",
 /*  71 */ "compound ::= selectcmd",
 /*  72 */ "compound ::= compound UNION opt_compound_all compound",
 /*  73 */ "compound ::= compound EXCEPT opt_compound_all compound",
 /*  74 */ "compound ::= compound INTERSECT opt_compound_all compound",
 /*  75 */ "opt_compound_all ::=",
 /*  76 */ "opt_compound_all ::= ALL",
 /*  77 */ "selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  78 */ "limit_opt ::=",
 /*  79 */ "limit_opt ::= LIMIT expr",
 /*  80 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /*  81 */ "limit_opt ::= LIMIT expr COMMA expr",
 /*  82 */ "orderby_opt ::=",
 /*  83 */ "orderby_opt ::= ORDER BY sortlist",
 /*  84 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  85 */ "sortlist ::= expr sortorder",
 /*  86 */ "sortorder ::= ASC",
 /*  87 */ "sortorder ::= DESC",
 /*  88 */ "sortorder ::=",
 /*  89 */ "having_opt ::=",
 /*  90 */ "having_opt ::= HAVING expr",
 /*  91 */ "groupby_opt ::=",
 /*  92 */ "groupby_opt ::= GROUP BY nexprlist",
 /*  93 */ "from ::=",
 /*  94 */ "from ::= FROM seltablist",
 /*  95 */ "seltablist ::= stl_prefix seltarget on_cond using_opt",
 /*  96 */ "using_opt ::= USING LP inscollist RP",
 /*  97 */ "using_opt ::=",
 /*  98 */ "stl_prefix ::=",
 /*  99 */ "stl_prefix ::= seltablist jointype",
 /* 100 */ "on_cond ::= ON expr",
 /* 101 */ "on_cond ::=",
 /* 102 */ "jointype ::= COMMA",
 /* 103 */ "jointype ::= JOIN",
 /* 104 */ "jointype ::= CROSS JOIN",
 /* 105 */ "jointype ::= INNER JOIN",
 /* 106 */ "jointype ::= NATURAL JOIN",
 /* 107 */ "jointype ::= LEFT JOIN",
 /* 108 */ "jointype ::= LEFT OUTER JOIN",
 /* 109 */ "jointype ::= RIGHT JOIN",
 /* 110 */ "jointype ::= RIGHT OUTER JOIN",
 /* 111 */ "jointype ::= FULL JOIN",
 /* 112 */ "jointype ::= FULL OUTER JOIN",
 /* 113 */ "seltarget ::= fullname as",
 /* 114 */ "seltarget ::= fullname ID",
 /* 115 */ "seltarget ::= LP compound RP as",
 /* 116 */ "sclp ::= selcollist COMMA",
 /* 117 */ "sclp ::=",
 /* 118 */ "selcollist ::= sclp expr as",
 /* 119 */ "selcollist ::= sclp starname",
 /* 120 */ "starname ::= STAR",
 /* 121 */ "starname ::= nm DOT STAR",
 /* 122 */ "starname ::= nm DOT nm DOT STAR",
 /* 123 */ "as ::= AS fullname",
 /* 124 */ "as ::= AS value",
 /* 125 */ "as ::=",
 /* 126 */ "distinct ::=",
 /* 127 */ "distinct ::= ALL",
 /* 128 */ "distinct ::= DISTINCT",
 /* 129 */ "distinct ::= DISTINCT ON expr",
 /* 130 */ "nexprlist ::= nexprlist COMMA expr",
 /* 131 */ "nexprlist ::= expr",
 /* 132 */ "exprlist ::=",
 /* 133 */ "exprlist ::= exprlist COMMA expr",
 /* 134 */ "exprlist ::= expr",
 /* 135 */ "expr ::= pvalue",
 /* 136 */ "expr ::= value",
 /* 137 */ "expr ::= LP expr RP",
 /* 138 */ "expr ::= fullname",
 /* 139 */ "expr ::= fullname LP exprlist RP",
 /* 140 */ "expr ::= fullname LP compound RP",
 /* 141 */ "expr ::= fullname LP starname RP",
 /* 142 */ "expr ::= CAST LP expr AS fullname RP",
 /* 143 */ "expr ::= expr PGCAST fullname",
 /* 144 */ "expr ::= expr PLUS|MINUS expr",
 /* 145 */ "expr ::= expr STAR expr",
 /* 146 */ "expr ::= expr SLASH|REM expr",
 /* 147 */ "expr ::= expr BITAND|BITOR expr",
 /* 148 */ "expr ::= MINUS expr",
 /* 149 */ "expr ::= PLUS expr",
 /* 150 */ "expr ::= expr AND expr",
 /* 151 */ "expr ::= expr OR expr",
 /* 152 */ "expr ::= expr CONCAT expr",
 /* 153 */ "expr ::= expr GT|LEQ|GEQ|LT expr",
 /* 154 */ "expr ::= expr DIFF|EQ expr",
 /* 155 */ "expr ::= expr LIKE expr",
 /* 156 */ "expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr",
 /* 157 */ "expr ::= expr BETWEEN expr AND expr",
 /* 158 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 159 */ "expr ::= NOT expr",
 /* 160 */ "expr ::= BITNOT expr",
 /* 161 */ "expr ::= expr uni_op",
 /* 162 */ "expr ::= expr IS expr",
 /* 163 */ "expr ::= LP compound RP",
 /* 164 */ "expr ::= expr IN LP exprlist RP",
 /* 165 */ "expr ::= expr IN LP compound RP",
 /* 166 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 167 */ "expr ::= expr NOT IN LP compound RP",
 /* 168 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 169 */ "case_operand ::= expr",
 /* 170 */ "case_operand ::=",
 /* 171 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 172 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 173 */ "case_else ::= ELSE expr",
 /* 174 */ "case_else ::=",
 /* 175 */ "uni_op ::= ISNULL",
 /* 176 */ "uni_op ::= IS NOTNULL",
 /* 177 */ "value ::= NULL",
 /* 178 */ "value ::= STRING",
 /* 179 */ "value ::= INTEGER",
 /* 180 */ "value ::= FLOAT",
 /* 181 */ "pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET",
 /* 182 */ "pvalue ::= value LSBRACKET paramspec RSBRACKET",
 /* 183 */ "pvalue ::= SIMPLEPARAM",
 /* 184 */ "paramspec ::=",
 /* 185 */ "paramspec ::= paramspec PNAME",
 /* 186 */ "paramspec ::= paramspec PDESCR",
 /* 187 */ "paramspec ::= paramspec PTYPE",
 /* 188 */ "paramspec ::= paramspec PNULLOK",
 /* 189 */ "nm ::= JOIN",
 /* 190 */ "nm ::= ID",
 /* 191 */ "nm ::= TEXTUAL",
 /* 192 */ "fullname ::= nm",
 /* 193 */ "fullname ::= nm DOT nm",
 /* 194 */ "fullname ::= nm DOT nm DOT nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to gda_lemon_capi_parser and gda_lemon_capi_parserFree.
*/
void *gda_lemon_capi_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  gda_lemon_capi_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
      /* TERMINAL Destructor */
    case 1: /* ID */
    case 2: /* ABORT */
    case 3: /* AFTER */
    case 4: /* ANALYZE */
    case 5: /* ASC */
    case 6: /* ATTACH */
    case 7: /* BEFORE */
    case 8: /* BEGIN */
    case 9: /* CASCADE */
    case 10: /* CAST */
    case 11: /* CONFLICT */
    case 12: /* DATABASE */
    case 13: /* DEFERRED */
    case 14: /* DESC */
    case 15: /* DETACH */
    case 16: /* EACH */
    case 17: /* END */
    case 18: /* EXCLUSIVE */
    case 19: /* EXPLAIN */
    case 20: /* FAIL */
    case 21: /* FOR */
    case 22: /* IGNORE */
    case 23: /* IMMEDIATE */
    case 24: /* INITIALLY */
    case 25: /* INSTEAD */
    case 26: /* LIKE */
    case 27: /* MATCH */
    case 28: /* PLAN */
    case 29: /* QUERY */
    case 30: /* KEY */
    case 31: /* OF */
    case 32: /* OFFSET */
    case 33: /* PRAGMA */
    case 34: /* RAISE */
    case 35: /* REPLACE */
    case 36: /* RESTRICT */
    case 37: /* ROW */
    case 38: /* TEMP */
    case 39: /* TRIGGER */
    case 40: /* VACUUM */
    case 41: /* VIEW */
    case 42: /* VIRTUAL */
    case 43: /* REINDEX */
    case 44: /* RENAME */
    case 45: /* CTIME_KW */
    case 46: /* IF */
    case 47: /* DELIMITER */
    case 48: /* COMMIT */
    case 49: /* ROLLBACK */
    case 50: /* ISOLATION */
    case 51: /* LEVEL */
    case 52: /* SERIALIZABLE */
    case 53: /* READ */
    case 54: /* COMMITTED */
    case 55: /* UNCOMMITTED */
    case 56: /* REPEATABLE */
    case 57: /* WRITE */
    case 58: /* ONLY */
    case 59: /* SAVEPOINT */
    case 60: /* RELEASE */
    case 61: /* COMMENT */
    case 62: /* FORCE */
    case 63: /* WAIT */
    case 64: /* NOWAIT */
    case 65: /* BATCH */
    case 66: /* OR */
    case 67: /* AND */
    case 68: /* NOT */
    case 69: /* IS */
    case 70: /* IN */
    case 71: /* ISNULL */
    case 72: /* NOTNULL */
    case 73: /* DIFF */
    case 74: /* EQ */
    case 75: /* BETWEEN */
    case 76: /* GT */
    case 77: /* LEQ */
    case 78: /* LT */
    case 79: /* GEQ */
    case 80: /* REGEXP */
    case 81: /* REGEXP_CI */
    case 82: /* NOT_REGEXP */
    case 83: /* NOT_REGEXP_CI */
    case 84: /* SIMILAR */
    case 85: /* ESCAPE */
    case 86: /* BITAND */
    case 87: /* BITOR */
    case 88: /* LSHIFT */
    case 89: /* RSHIFT */
    case 90: /* PLUS */
    case 91: /* MINUS */
    case 92: /* STAR */
    case 93: /* SLASH */
    case 94: /* REM */
    case 95: /* CONCAT */
    case 96: /* COLLATE */
    case 97: /* UMINUS */
    case 98: /* UPLUS */
    case 99: /* BITNOT */
    case 100: /* LP */
    case 101: /* RP */
    case 102: /* JOIN */
    case 103: /* INNER */
    case 104: /* NATURAL */
    case 105: /* LEFT */
    case 106: /* RIGHT */
    case 107: /* FULL */
    case 108: /* CROSS */
    case 109: /* UNION */
    case 110: /* EXCEPT */
    case 111: /* INTERSECT */
    case 112: /* PGCAST */
    case 113: /* ILLEGAL */
    case 114: /* SQLCOMMENT */
    case 115: /* SEMI */
    case 116: /* END_OF_FILE */
    case 117: /* TRANSACTION */
    case 118: /* STRING */
    case 119: /* COMMA */
    case 120: /* INTEGER */
    case 121: /* TO */
    case 122: /* INSERT */
    case 123: /* INTO */
    case 124: /* VALUES */
    case 125: /* DELETE */
    case 126: /* FROM */
    case 127: /* WHERE */
    case 128: /* UPDATE */
    case 129: /* SET */
    case 130: /* ALL */
    case 131: /* SELECT */
    case 132: /* LIMIT */
    case 133: /* ORDER */
    case 134: /* BY */
    case 135: /* HAVING */
    case 136: /* GROUP */
    case 137: /* USING */
    case 138: /* ON */
    case 139: /* OUTER */
    case 140: /* DOT */
    case 141: /* AS */
    case 142: /* DISTINCT */
    case 143: /* CASE */
    case 144: /* WHEN */
    case 145: /* THEN */
    case 146: /* ELSE */
    case 147: /* NULL */
    case 148: /* FLOAT */
    case 149: /* UNSPECVAL */
    case 150: /* LSBRACKET */
    case 151: /* RSBRACKET */
    case 152: /* SIMPLEPARAM */
    case 153: /* PNAME */
    case 154: /* PDESCR */
    case 155: /* PTYPE */
    case 156: /* PNULLOK */
    case 157: /* TEXTUAL */
{
#line 9 "./parser.y"
if ((yypminor->yy0)) {
#ifdef GDA_DEBUG_NO
		 gchar *str = gda_sql_value_stringify ((yypminor->yy0));
		 g_print ("___ token destructor /%s/\n", str)
		 g_free (str);
#endif
		 g_value_unset ((yypminor->yy0)); g_free ((yypminor->yy0));}
#line 1386 "parser.c"
}
      break;
    case 159: /* stmt */
{
#line 278 "./parser.y"
g_print ("Statement destroyed by parser: %p\n", (yypminor->yy308)); gda_sql_statement_free ((yypminor->yy308));
#line 1393 "parser.c"
}
      break;
    case 160: /* cmd */
    case 162: /* compound */
    case 179: /* selectcmd */
{
#line 301 "./parser.y"
gda_sql_statement_free ((yypminor->yy308));
#line 1402 "parser.c"
}
      break;
    case 172: /* inscollist_opt */
    case 175: /* inscollist */
    case 195: /* using_opt */
{
#line 478 "./parser.y"
if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_field_free, NULL); g_slist_free ((yypminor->yy393));}
#line 1411 "parser.c"
}
      break;
    case 173: /* exprlist */
    case 190: /* nexprlist */
{
#line 764 "./parser.y"
if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy247));}
#line 1419 "parser.c"
}
      break;
    case 174: /* ins_extra_values */
{
#line 467 "./parser.y"
GSList *list;
		for (list = (yypminor->yy393); list; list = list->next) {
			g_slist_foreach ((GSList*) list->data, (GFunc) gda_sql_field_free, NULL); 
			g_slist_free ((GSList*) list->data);
		}
		g_slist_free ((yypminor->yy393));

#line 1432 "parser.c"
}
      break;
    case 176: /* where_opt */
    case 177: /* expr */
    case 185: /* having_opt */
    case 194: /* on_cond */
    case 201: /* pvalue */
{
#line 500 "./parser.y"
gda_sql_expr_free ((yypminor->yy328));
#line 1443 "parser.c"
}
      break;
    case 178: /* setlist */
{
#line 520 "./parser.y"
GSList *list;
	for (list = (yypminor->yy393); list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		g_value_reset (set->fname); g_free (set->fname);
		gda_sql_expr_free (set->expr);
		g_free (set);
	}
	g_slist_free ((yypminor->yy393));

#line 1458 "parser.c"
}
      break;
    case 181: /* distinct */
{
#line 750 "./parser.y"
if ((yypminor->yy189)) {if ((yypminor->yy189)->expr) gda_sql_expr_free ((yypminor->yy189)->expr); g_free ((yypminor->yy189));}
#line 1465 "parser.c"
}
      break;
    case 182: /* selcollist */
    case 198: /* sclp */
{
#line 707 "./parser.y"
g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_field_free, NULL); g_slist_free ((yypminor->yy247));
#line 1473 "parser.c"
}
      break;
    case 183: /* from */
    case 191: /* seltablist */
    case 192: /* stl_prefix */
{
#line 633 "./parser.y"
gda_sql_select_from_free ((yypminor->yy59));
#line 1482 "parser.c"
}
      break;
    case 184: /* groupby_opt */
{
#line 628 "./parser.y"
if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy393));}
#line 1489 "parser.c"
}
      break;
    case 186: /* orderby_opt */
    case 188: /* sortlist */
{
#line 597 "./parser.y"
if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_order_free, NULL); g_slist_free ((yypminor->yy247));}
#line 1497 "parser.c"
}
      break;
    case 187: /* limit_opt */
{
#line 590 "./parser.y"
gda_sql_expr_free ((yypminor->yy20).count); gda_sql_expr_free ((yypminor->yy20).offset);
#line 1504 "parser.c"
}
      break;
    case 193: /* seltarget */
{
#line 692 "./parser.y"
gda_sql_select_target_free ((yypminor->yy224));
#line 1511 "parser.c"
}
      break;
    case 203: /* case_operand */
    case 205: /* case_else */
{
#line 928 "./parser.y"
gda_sql_expr_free ((yypminor->yy122));
#line 1519 "parser.c"
}
      break;
    case 204: /* case_exprlist */
{
#line 933 "./parser.y"
g_slist_foreach ((yypminor->yy263).when_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).when_list);
	g_slist_foreach ((yypminor->yy263).then_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).then_list);
#line 1527 "parser.c"
}
      break;
    case 206: /* paramspec */
{
#line 971 "./parser.y"
gda_sql_param_spec_free ((yypminor->yy405));
#line 1534 "parser.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from gda_lemon_capi_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void gda_lemon_capi_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int gda_lemon_capi_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   gda_lemon_capi_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 25 "./parser.y"

	gda_sql_parser_set_overflow_error (pdata->parser);
#line 1719 "parser.c"
   gda_lemon_capi_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 159, 2 },
  { 159, 2 },
  { 160, 3 },
  { 162, 3 },
  { 161, 1 },
  { 161, 1 },
  { 160, 1 },
  { 160, 3 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 5 },
  { 160, 4 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 3 },
  { 160, 4 },
  { 160, 2 },
  { 160, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 167, 0 },
  { 167, 1 },
  { 166, 0 },
  { 166, 1 },
  { 165, 3 },
  { 165, 4 },
  { 165, 4 },
  { 165, 4 },
  { 163, 0 },
  { 163, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 2 },
  { 164, 2 },
  { 160, 2 },
  { 160, 3 },
  { 160, 2 },
  { 160, 4 },
  { 160, 5 },
  { 160, 9 },
  { 160, 10 },
  { 160, 6 },
  { 170, 0 },
  { 170, 2 },
  { 174, 5 },
  { 174, 4 },
  { 172, 0 },
  { 172, 3 },
  { 175, 3 },
  { 175, 1 },
  { 160, 4 },
  { 176, 0 },
  { 176, 2 },
  { 160, 6 },
  { 178, 5 },
  { 178, 3 },
  { 162, 1 },
  { 162, 4 },
  { 162, 4 },
  { 162, 4 },
  { 180, 0 },
  { 180, 1 },
  { 179, 9 },
  { 187, 0 },
  { 187, 2 },
  { 187, 4 },
  { 187, 4 },
  { 186, 0 },
  { 186, 3 },
  { 188, 4 },
  { 188, 2 },
  { 189, 1 },
  { 189, 1 },
  { 189, 0 },
  { 185, 0 },
  { 185, 2 },
  { 184, 0 },
  { 184, 3 },
  { 183, 0 },
  { 183, 2 },
  { 191, 4 },
  { 195, 4 },
  { 195, 0 },
  { 192, 0 },
  { 192, 2 },
  { 194, 2 },
  { 194, 0 },
  { 196, 1 },
  { 196, 1 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 193, 2 },
  { 193, 2 },
  { 193, 4 },
  { 198, 2 },
  { 198, 0 },
  { 182, 3 },
  { 182, 2 },
  { 199, 1 },
  { 199, 3 },
  { 199, 5 },
  { 197, 2 },
  { 197, 2 },
  { 197, 0 },
  { 181, 0 },
  { 181, 1 },
  { 181, 1 },
  { 181, 3 },
  { 190, 3 },
  { 190, 1 },
  { 173, 0 },
  { 173, 3 },
  { 173, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 3 },
  { 177, 1 },
  { 177, 4 },
  { 177, 4 },
  { 177, 4 },
  { 177, 6 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 6 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 5 },
  { 177, 6 },
  { 177, 6 },
  { 177, 5 },
  { 203, 1 },
  { 203, 0 },
  { 204, 5 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 202, 1 },
  { 202, 2 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 201, 4 },
  { 201, 4 },
  { 201, 1 },
  { 206, 0 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 169, 1 },
  { 169, 1 },
  { 169, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  gda_lemon_capi_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* stmt ::= cmd eos */
#line 279 "./parser.y"
{pdata->parsed_statement = yymsp[-1].minor.yy308;}
#line 2028 "parser.c"
        break;
      case 1: /* stmt ::= compound eos */
#line 280 "./parser.y"
{
	GdaSqlStatementCompound *scompound = (GdaSqlStatementCompound *) yymsp[-1].minor.yy308->contents;
	if (scompound->stmt_list->next)
		/* real compound (multiple statements) */
		pdata->parsed_statement = yymsp[-1].minor.yy308;
	else {
		/* false compound (only 1 select) */
		pdata->parsed_statement = (GdaSqlStatement*) scompound->stmt_list->data;
		GDA_SQL_ANY_PART (pdata->parsed_statement->contents)->parent = NULL;
		g_slist_free (scompound->stmt_list);
		scompound->stmt_list = NULL;
		gda_sql_statement_free (yymsp[-1].minor.yy308);
	}
}
#line 2046 "parser.c"
        break;
      case 2: /* cmd ::= LP cmd RP */
      case 3: /* compound ::= LP compound RP */ yytestcase(yyruleno==3);
#line 294 "./parser.y"
{yygotominor.yy308 = yymsp[-1].minor.yy308;  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 2054 "parser.c"
        break;
      case 4: /* eos ::= SEMI */
#line 297 "./parser.y"
{
  yy_destructor(yypParser,115,&yymsp[0].minor);
}
#line 2061 "parser.c"
        break;
      case 5: /* eos ::= END_OF_FILE */
#line 298 "./parser.y"
{
  yy_destructor(yypParser,116,&yymsp[0].minor);
}
#line 2068 "parser.c"
        break;
      case 6: /* cmd ::= BEGIN */
#line 306 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);  yy_destructor(yypParser,8,&yymsp[0].minor);
}
#line 2074 "parser.c"
        break;
      case 7: /* cmd ::= BEGIN TRANSACTION nm_opt */
#line 307 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					 gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,117,&yymsp[-1].minor);
}
#line 2083 "parser.c"
        break;
      case 8: /* cmd ::= BEGIN transtype TRANSACTION nm_opt */
#line 311 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						      gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy0);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
  yy_destructor(yypParser,117,&yymsp[-1].minor);
}
#line 2093 "parser.c"
        break;
      case 9: /* cmd ::= BEGIN transtype nm_opt */
#line 316 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					  gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-1].minor.yy0);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
}
#line 2102 "parser.c"
        break;
      case 10: /* cmd ::= BEGIN transilev */
#line 321 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
				gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-1].minor);
}
#line 2110 "parser.c"
        break;
      case 11: /* cmd ::= BEGIN TRANSACTION transilev */
#line 325 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,117,&yymsp[-1].minor);
}
#line 2119 "parser.c"
        break;
      case 12: /* cmd ::= BEGIN TRANSACTION transtype */
#line 329 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,117,&yymsp[-1].minor);
}
#line 2128 "parser.c"
        break;
      case 13: /* cmd ::= BEGIN TRANSACTION transtype opt_comma transilev */
#line 333 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,117,&yymsp[-3].minor);
}
#line 2138 "parser.c"
        break;
      case 14: /* cmd ::= BEGIN TRANSACTION transilev opt_comma transtype */
#line 338 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,117,&yymsp[-3].minor);
}
#line 2148 "parser.c"
        break;
      case 15: /* cmd ::= BEGIN transtype opt_comma transilev */
#line 343 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2157 "parser.c"
        break;
      case 16: /* cmd ::= BEGIN transilev opt_comma transtype */
#line 348 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2166 "parser.c"
        break;
      case 17: /* cmd ::= END trans_opt_kw nm_opt */
#line 353 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,17,&yymsp[-2].minor);
}
#line 2174 "parser.c"
        break;
      case 18: /* cmd ::= COMMIT nm_opt */
#line 357 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
			      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,48,&yymsp[-1].minor);
}
#line 2182 "parser.c"
        break;
      case 19: /* cmd ::= COMMIT TRANSACTION nm_opt */
#line 361 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,48,&yymsp[-2].minor);
  yy_destructor(yypParser,117,&yymsp[-1].minor);
}
#line 2191 "parser.c"
        break;
      case 20: /* cmd ::= COMMIT FORCE STRING */
#line 365 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-2].minor);
  yy_destructor(yypParser,62,&yymsp[-1].minor);
  yy_destructor(yypParser,118,&yymsp[0].minor);
}
#line 2199 "parser.c"
        break;
      case 21: /* cmd ::= COMMIT FORCE STRING COMMA INTEGER */
#line 366 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-4].minor);
  yy_destructor(yypParser,62,&yymsp[-3].minor);
  yy_destructor(yypParser,118,&yymsp[-2].minor);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2209 "parser.c"
        break;
      case 22: /* cmd ::= COMMIT COMMENT STRING */
#line 367 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[-1].minor);
  yy_destructor(yypParser,118,&yymsp[0].minor);
}
#line 2217 "parser.c"
        break;
      case 23: /* cmd ::= COMMIT COMMENT STRING ora_commit_write */
#line 368 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-3].minor);
  yy_destructor(yypParser,61,&yymsp[-2].minor);
  yy_destructor(yypParser,118,&yymsp[-1].minor);
}
#line 2225 "parser.c"
        break;
      case 24: /* cmd ::= COMMIT ora_commit_write */
#line 369 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,48,&yymsp[-1].minor);
}
#line 2231 "parser.c"
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt_kw nm_opt */
#line 371 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK);
					     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-2].minor);
}
#line 2239 "parser.c"
        break;
      case 26: /* ora_commit_write ::= WRITE IMMEDIATE */
#line 375 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,23,&yymsp[0].minor);
}
#line 2247 "parser.c"
        break;
      case 27: /* ora_commit_write ::= WRITE BATCH */
#line 376 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2255 "parser.c"
        break;
      case 28: /* ora_commit_write ::= WRITE WAIT */
#line 377 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,63,&yymsp[0].minor);
}
#line 2263 "parser.c"
        break;
      case 29: /* ora_commit_write ::= WRITE NOWAIT */
#line 378 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2271 "parser.c"
        break;
      case 30: /* ora_commit_write ::= WRITE IMMEDIATE WAIT */
#line 379 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,63,&yymsp[0].minor);
}
#line 2280 "parser.c"
        break;
      case 31: /* ora_commit_write ::= WRITE IMMEDIATE NOWAIT */
#line 380 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2289 "parser.c"
        break;
      case 32: /* ora_commit_write ::= WRITE BATCH WAIT */
#line 381 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,65,&yymsp[-1].minor);
  yy_destructor(yypParser,63,&yymsp[0].minor);
}
#line 2298 "parser.c"
        break;
      case 33: /* ora_commit_write ::= WRITE BATCH NOWAIT */
#line 382 "./parser.y"
{
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,65,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2307 "parser.c"
        break;
      case 35: /* trans_opt_kw ::= TRANSACTION */
#line 385 "./parser.y"
{
  yy_destructor(yypParser,117,&yymsp[0].minor);
}
#line 2314 "parser.c"
        break;
      case 37: /* opt_comma ::= COMMA */
#line 388 "./parser.y"
{
  yy_destructor(yypParser,119,&yymsp[0].minor);
}
#line 2321 "parser.c"
        break;
      case 38: /* transilev ::= ISOLATION LEVEL SERIALIZABLE */
#line 391 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_SERIALIZABLE;  yy_destructor(yypParser,50,&yymsp[-2].minor);
  yy_destructor(yypParser,51,&yymsp[-1].minor);
  yy_destructor(yypParser,52,&yymsp[0].minor);
}
#line 2329 "parser.c"
        break;
      case 39: /* transilev ::= ISOLATION LEVEL REPEATABLE READ */
#line 392 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_REPEATABLE_READ;  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,56,&yymsp[-1].minor);
  yy_destructor(yypParser,53,&yymsp[0].minor);
}
#line 2338 "parser.c"
        break;
      case 40: /* transilev ::= ISOLATION LEVEL READ COMMITTED */
#line 393 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_COMMITTED;  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,54,&yymsp[0].minor);
}
#line 2347 "parser.c"
        break;
      case 41: /* transilev ::= ISOLATION LEVEL READ UNCOMMITTED */
#line 394 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED;  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,55,&yymsp[0].minor);
}
#line 2356 "parser.c"
        break;
      case 42: /* nm_opt ::= */
      case 57: /* opt_on_conflict ::= */ yytestcase(yyruleno==57);
      case 125: /* as ::= */ yytestcase(yyruleno==125);
#line 396 "./parser.y"
{yygotominor.yy0 = NULL;}
#line 2363 "parser.c"
        break;
      case 43: /* nm_opt ::= nm */
      case 44: /* transtype ::= DEFERRED */ yytestcase(yyruleno==44);
      case 45: /* transtype ::= IMMEDIATE */ yytestcase(yyruleno==45);
      case 46: /* transtype ::= EXCLUSIVE */ yytestcase(yyruleno==46);
      case 120: /* starname ::= STAR */ yytestcase(yyruleno==120);
      case 178: /* value ::= STRING */ yytestcase(yyruleno==178);
      case 179: /* value ::= INTEGER */ yytestcase(yyruleno==179);
      case 180: /* value ::= FLOAT */ yytestcase(yyruleno==180);
      case 189: /* nm ::= JOIN */ yytestcase(yyruleno==189);
      case 190: /* nm ::= ID */ yytestcase(yyruleno==190);
      case 191: /* nm ::= TEXTUAL */ yytestcase(yyruleno==191);
      case 192: /* fullname ::= nm */ yytestcase(yyruleno==192);
#line 397 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2379 "parser.c"
        break;
      case 47: /* transtype ::= READ WRITE */
#line 402 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			      g_value_init (yygotominor.yy0, G_TYPE_STRING);
			      g_value_set_string (yygotominor.yy0, "READ_WRITE");
  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 2389 "parser.c"
        break;
      case 48: /* transtype ::= READ ONLY */
#line 406 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			     g_value_init (yygotominor.yy0, G_TYPE_STRING);
			     g_value_set_string (yygotominor.yy0, "READ_ONLY");
  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,58,&yymsp[0].minor);
}
#line 2399 "parser.c"
        break;
      case 49: /* cmd ::= SAVEPOINT nm */
#line 414 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SAVEPOINT);
				    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 2407 "parser.c"
        break;
      case 50: /* cmd ::= RELEASE SAVEPOINT nm */
#line 418 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
				     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 2416 "parser.c"
        break;
      case 51: /* cmd ::= RELEASE nm */
#line 422 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
			   gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2424 "parser.c"
        break;
      case 52: /* cmd ::= ROLLBACK trans_opt_kw TO nm */
#line 426 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
					    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-3].minor);
  yy_destructor(yypParser,121,&yymsp[-1].minor);
}
#line 2433 "parser.c"
        break;
      case 53: /* cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm */
#line 430 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-4].minor);
  yy_destructor(yypParser,121,&yymsp[-2].minor);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 2443 "parser.c"
        break;
      case 54: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP */
#line 437 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-5].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-4].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-7].minor.yy0);
  yy_destructor(yypParser,122,&yymsp[-8].minor);
  yy_destructor(yypParser,123,&yymsp[-6].minor);
  yy_destructor(yypParser,124,&yymsp[-3].minor);
  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 2459 "parser.c"
        break;
      case 55: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values */
#line 445 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-6].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-5].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-2].minor.yy247);
	gda_sql_statement_insert_take_extra_values_list (yygotominor.yy308, yymsp[0].minor.yy393);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-8].minor.yy0);
  yy_destructor(yypParser,122,&yymsp[-9].minor);
  yy_destructor(yypParser,123,&yymsp[-7].minor);
  yy_destructor(yypParser,124,&yymsp[-4].minor);
  yy_destructor(yypParser,100,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-1].minor);
}
#line 2476 "parser.c"
        break;
      case 56: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound */
#line 454 "./parser.y"
{
        yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
        gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-2].minor.yy0);
        gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-1].minor.yy393);
        gda_sql_statement_insert_take_select (yygotominor.yy308, yymsp[0].minor.yy308);
        gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy0);
  yy_destructor(yypParser,122,&yymsp[-5].minor);
  yy_destructor(yypParser,123,&yymsp[-3].minor);
}
#line 2489 "parser.c"
        break;
      case 58: /* opt_on_conflict ::= OR ID */
#line 464 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,66,&yymsp[-1].minor);
}
#line 2495 "parser.c"
        break;
      case 59: /* ins_extra_values ::= ins_extra_values COMMA LP exprlist RP */
#line 474 "./parser.y"
{yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, yymsp[-1].minor.yy247);  yy_destructor(yypParser,119,&yymsp[-3].minor);
  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 2503 "parser.c"
        break;
      case 60: /* ins_extra_values ::= COMMA LP exprlist RP */
#line 475 "./parser.y"
{yygotominor.yy393 = g_slist_append (NULL, yymsp[-1].minor.yy247);  yy_destructor(yypParser,119,&yymsp[-3].minor);
  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 2511 "parser.c"
        break;
      case 61: /* inscollist_opt ::= */
      case 97: /* using_opt ::= */ yytestcase(yyruleno==97);
#line 479 "./parser.y"
{yygotominor.yy393 = NULL;}
#line 2517 "parser.c"
        break;
      case 62: /* inscollist_opt ::= LP inscollist RP */
#line 480 "./parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 2524 "parser.c"
        break;
      case 63: /* inscollist ::= inscollist COMMA fullname */
#line 484 "./parser.y"
{GdaSqlField *field;
						    field = gda_sql_field_new (NULL);
						    gda_sql_field_take_name (field, yymsp[0].minor.yy0);
						    yygotominor.yy393 = g_slist_append (yymsp[-2].minor.yy393, field);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 2534 "parser.c"
        break;
      case 64: /* inscollist ::= fullname */
#line 489 "./parser.y"
{GdaSqlField *field = gda_sql_field_new (NULL);
				gda_sql_field_take_name (field, yymsp[0].minor.yy0);
				yygotominor.yy393 = g_slist_prepend (NULL, field);
}
#line 2542 "parser.c"
        break;
      case 65: /* cmd ::= DELETE FROM fullname where_opt */
#line 495 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE); 
						  gda_sql_statement_delete_take_table_name (yygotominor.yy308, yymsp[-1].minor.yy0);
						  gda_sql_statement_delete_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);  yy_destructor(yypParser,125,&yymsp[-3].minor);
  yy_destructor(yypParser,126,&yymsp[-2].minor);
}
#line 2551 "parser.c"
        break;
      case 66: /* where_opt ::= */
      case 89: /* having_opt ::= */ yytestcase(yyruleno==89);
      case 101: /* on_cond ::= */ yytestcase(yyruleno==101);
#line 501 "./parser.y"
{yygotominor.yy328 = NULL;}
#line 2558 "parser.c"
        break;
      case 67: /* where_opt ::= WHERE expr */
#line 502 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(yypParser,127,&yymsp[-1].minor);
}
#line 2564 "parser.c"
        break;
      case 68: /* cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt */
#line 505 "./parser.y"
{
	GSList *list;
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_UPDATE);
	gda_sql_statement_update_take_table_name (yygotominor.yy308, yymsp[-3].minor.yy0);
	gda_sql_statement_update_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy0);
	gda_sql_statement_update_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);
	for (list = yymsp[-1].minor.yy393; list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		gda_sql_statement_update_take_set_value (yygotominor.yy308, set->fname, set->expr);
		g_free (set);
	}
	g_slist_free (yymsp[-1].minor.yy393);
  yy_destructor(yypParser,128,&yymsp[-5].minor);
  yy_destructor(yypParser,129,&yymsp[-2].minor);
}
#line 2583 "parser.c"
        break;
      case 69: /* setlist ::= setlist COMMA fullname EQ expr */
#line 529 "./parser.y"
{UpdateSet *set;
							 set = g_new (UpdateSet, 1);
							 set->fname = yymsp[-2].minor.yy0;
							 set->expr = yymsp[0].minor.yy328;
							 yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, set);
  yy_destructor(yypParser,119,&yymsp[-3].minor);
  yy_destructor(yypParser,74,&yymsp[-1].minor);
}
#line 2595 "parser.c"
        break;
      case 70: /* setlist ::= fullname EQ expr */
#line 535 "./parser.y"
{UpdateSet *set;
					set = g_new (UpdateSet, 1);
					set->fname = yymsp[-2].minor.yy0;
					set->expr = yymsp[0].minor.yy328;
					yygotominor.yy393 = g_slist_append (NULL, set);
  yy_destructor(yypParser,74,&yymsp[-1].minor);
}
#line 2606 "parser.c"
        break;
      case 71: /* compound ::= selectcmd */
#line 546 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
	gda_sql_statement_compound_take_stmt (yygotominor.yy308, yymsp[0].minor.yy308);
}
#line 2614 "parser.c"
        break;
      case 72: /* compound ::= compound UNION opt_compound_all compound */
#line 550 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_UNION_ALL : GDA_SQL_STATEMENT_COMPOUND_UNION,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(yypParser,109,&yymsp[-2].minor);
}
#line 2623 "parser.c"
        break;
      case 73: /* compound ::= compound EXCEPT opt_compound_all compound */
#line 555 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL : GDA_SQL_STATEMENT_COMPOUND_EXCEPT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(yypParser,110,&yymsp[-2].minor);
}
#line 2632 "parser.c"
        break;
      case 74: /* compound ::= compound INTERSECT opt_compound_all compound */
#line 560 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL : GDA_SQL_STATEMENT_COMPOUND_INTERSECT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(yypParser,111,&yymsp[-2].minor);
}
#line 2641 "parser.c"
        break;
      case 75: /* opt_compound_all ::= */
#line 566 "./parser.y"
{yygotominor.yy216 = FALSE;}
#line 2646 "parser.c"
        break;
      case 76: /* opt_compound_all ::= ALL */
#line 567 "./parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(yypParser,130,&yymsp[0].minor);
}
#line 2652 "parser.c"
        break;
      case 77: /* selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 574 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SELECT);
	if (yymsp[-7].minor.yy189) {
		gda_sql_statement_select_take_distinct (yygotominor.yy308, yymsp[-7].minor.yy189->distinct, yymsp[-7].minor.yy189->expr);
		g_free (yymsp[-7].minor.yy189);
	}
	gda_sql_statement_select_take_expr_list (yygotominor.yy308, yymsp[-6].minor.yy247);
	gda_sql_statement_select_take_from (yygotominor.yy308, yymsp[-5].minor.yy59);
	gda_sql_statement_select_take_where_cond (yygotominor.yy308, yymsp[-4].minor.yy328);
	gda_sql_statement_select_take_group_by (yygotominor.yy308, yymsp[-3].minor.yy393);
	gda_sql_statement_select_take_having_cond (yygotominor.yy308, yymsp[-2].minor.yy328);
	gda_sql_statement_select_take_order_by (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_select_take_limits (yygotominor.yy308, yymsp[0].minor.yy20.count, yymsp[0].minor.yy20.offset);
  yy_destructor(yypParser,131,&yymsp[-8].minor);
}
#line 2671 "parser.c"
        break;
      case 78: /* limit_opt ::= */
#line 591 "./parser.y"
{yygotominor.yy20.count = NULL; yygotominor.yy20.offset = NULL;}
#line 2676 "parser.c"
        break;
      case 79: /* limit_opt ::= LIMIT expr */
#line 592 "./parser.y"
{yygotominor.yy20.count = yymsp[0].minor.yy328; yygotominor.yy20.offset = NULL;  yy_destructor(yypParser,132,&yymsp[-1].minor);
}
#line 2682 "parser.c"
        break;
      case 80: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 593 "./parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(yypParser,132,&yymsp[-3].minor);
  yy_destructor(yypParser,32,&yymsp[-1].minor);
}
#line 2689 "parser.c"
        break;
      case 81: /* limit_opt ::= LIMIT expr COMMA expr */
#line 594 "./parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(yypParser,132,&yymsp[-3].minor);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 2696 "parser.c"
        break;
      case 82: /* orderby_opt ::= */
#line 598 "./parser.y"
{yygotominor.yy247 = 0;}
#line 2701 "parser.c"
        break;
      case 83: /* orderby_opt ::= ORDER BY sortlist */
#line 599 "./parser.y"
{yygotominor.yy247 = yymsp[0].minor.yy247;  yy_destructor(yypParser,133,&yymsp[-2].minor);
  yy_destructor(yypParser,134,&yymsp[-1].minor);
}
#line 2708 "parser.c"
        break;
      case 84: /* sortlist ::= sortlist COMMA expr sortorder */
#line 603 "./parser.y"
{GdaSqlSelectOrder *order;
							 order = gda_sql_select_order_new (NULL);
							 order->expr = yymsp[-1].minor.yy328;
							 order->asc = yymsp[0].minor.yy216;
							 yygotominor.yy247 = g_slist_append (yymsp[-3].minor.yy247, order);
  yy_destructor(yypParser,119,&yymsp[-2].minor);
}
#line 2719 "parser.c"
        break;
      case 85: /* sortlist ::= expr sortorder */
#line 609 "./parser.y"
{GdaSqlSelectOrder *order;
				       order = gda_sql_select_order_new (NULL);
				       order->expr = yymsp[-1].minor.yy328;
				       order->asc = yymsp[0].minor.yy216;
				       yygotominor.yy247 = g_slist_prepend (NULL, order);
}
#line 2729 "parser.c"
        break;
      case 86: /* sortorder ::= ASC */
#line 617 "./parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(yypParser,5,&yymsp[0].minor);
}
#line 2735 "parser.c"
        break;
      case 87: /* sortorder ::= DESC */
#line 618 "./parser.y"
{yygotominor.yy216 = FALSE;  yy_destructor(yypParser,14,&yymsp[0].minor);
}
#line 2741 "parser.c"
        break;
      case 88: /* sortorder ::= */
#line 619 "./parser.y"
{yygotominor.yy216 = TRUE;}
#line 2746 "parser.c"
        break;
      case 90: /* having_opt ::= HAVING expr */
#line 625 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(yypParser,135,&yymsp[-1].minor);
}
#line 2752 "parser.c"
        break;
      case 91: /* groupby_opt ::= */
#line 629 "./parser.y"
{yygotominor.yy393 = 0;}
#line 2757 "parser.c"
        break;
      case 92: /* groupby_opt ::= GROUP BY nexprlist */
#line 630 "./parser.y"
{yygotominor.yy393 = yymsp[0].minor.yy247;  yy_destructor(yypParser,136,&yymsp[-2].minor);
  yy_destructor(yypParser,134,&yymsp[-1].minor);
}
#line 2764 "parser.c"
        break;
      case 93: /* from ::= */
      case 98: /* stl_prefix ::= */ yytestcase(yyruleno==98);
#line 634 "./parser.y"
{yygotominor.yy59 = NULL;}
#line 2770 "parser.c"
        break;
      case 94: /* from ::= FROM seltablist */
#line 635 "./parser.y"
{yygotominor.yy59 = yymsp[0].minor.yy59;  yy_destructor(yypParser,126,&yymsp[-1].minor);
}
#line 2776 "parser.c"
        break;
      case 95: /* seltablist ::= stl_prefix seltarget on_cond using_opt */
#line 642 "./parser.y"
{
	GSList *last;
	if (yymsp[-3].minor.yy59)
		yygotominor.yy59 = yymsp[-3].minor.yy59;
	else 
		yygotominor.yy59 = gda_sql_select_from_new (NULL);
	gda_sql_select_from_take_new_target (yygotominor.yy59, yymsp[-2].minor.yy224);
	last = g_slist_last (yygotominor.yy59->joins);
	if (last) {
		GdaSqlSelectJoin *join = (GdaSqlSelectJoin *) (last->data);
		join->expr = yymsp[-1].minor.yy328;
		join->position = g_slist_length (yygotominor.yy59->targets) - 1;
		join->use = yymsp[0].minor.yy393;
	}
}
#line 2795 "parser.c"
        break;
      case 96: /* using_opt ::= USING LP inscollist RP */
#line 660 "./parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(yypParser,137,&yymsp[-3].minor);
  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 2803 "parser.c"
        break;
      case 99: /* stl_prefix ::= seltablist jointype */
#line 664 "./parser.y"
{GdaSqlSelectJoin *join;
					      yygotominor.yy59 = yymsp[-1].minor.yy59;
					      join = gda_sql_select_join_new (GDA_SQL_ANY_PART (yygotominor.yy59));
					      join->type = yymsp[0].minor.yy317;
					      gda_sql_select_from_take_new_join (yygotominor.yy59, join);
}
#line 2813 "parser.c"
        break;
      case 100: /* on_cond ::= ON expr */
#line 674 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(yypParser,138,&yymsp[-1].minor);
}
#line 2819 "parser.c"
        break;
      case 102: /* jointype ::= COMMA */
#line 678 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,119,&yymsp[0].minor);
}
#line 2825 "parser.c"
        break;
      case 103: /* jointype ::= JOIN */
#line 679 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2831 "parser.c"
        break;
      case 104: /* jointype ::= CROSS JOIN */
#line 680 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,108,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2838 "parser.c"
        break;
      case 105: /* jointype ::= INNER JOIN */
#line 681 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,103,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2845 "parser.c"
        break;
      case 106: /* jointype ::= NATURAL JOIN */
#line 682 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_NATURAL;  yy_destructor(yypParser,104,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2852 "parser.c"
        break;
      case 107: /* jointype ::= LEFT JOIN */
#line 683 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,105,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2859 "parser.c"
        break;
      case 108: /* jointype ::= LEFT OUTER JOIN */
#line 684 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,139,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2867 "parser.c"
        break;
      case 109: /* jointype ::= RIGHT JOIN */
#line 685 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,106,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2874 "parser.c"
        break;
      case 110: /* jointype ::= RIGHT OUTER JOIN */
#line 686 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,106,&yymsp[-2].minor);
  yy_destructor(yypParser,139,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2882 "parser.c"
        break;
      case 111: /* jointype ::= FULL JOIN */
#line 687 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,107,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2889 "parser.c"
        break;
      case 112: /* jointype ::= FULL OUTER JOIN */
#line 688 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,107,&yymsp[-2].minor);
  yy_destructor(yypParser,139,&yymsp[-1].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2897 "parser.c"
        break;
      case 113: /* seltarget ::= fullname as */
#line 693 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
				     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
				     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy0);
}
#line 2905 "parser.c"
        break;
      case 114: /* seltarget ::= fullname ID */
#line 697 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
                                     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
                                     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy0);
}
#line 2913 "parser.c"
        break;
      case 115: /* seltarget ::= LP compound RP as */
#line 701 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
					     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
					     gda_sql_select_target_take_select (yygotominor.yy224, yymsp[-2].minor.yy308);
  yy_destructor(yypParser,100,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-1].minor);
}
#line 2923 "parser.c"
        break;
      case 116: /* sclp ::= selcollist COMMA */
#line 711 "./parser.y"
{yygotominor.yy247 = yymsp[-1].minor.yy247;  yy_destructor(yypParser,119,&yymsp[0].minor);
}
#line 2929 "parser.c"
        break;
      case 117: /* sclp ::= */
      case 132: /* exprlist ::= */ yytestcase(yyruleno==132);
#line 712 "./parser.y"
{yygotominor.yy247 = NULL;}
#line 2935 "parser.c"
        break;
      case 118: /* selcollist ::= sclp expr as */
#line 714 "./parser.y"
{GdaSqlSelectField *field;
					  field = gda_sql_select_field_new (NULL);
					  gda_sql_select_field_take_expr (field, yymsp[-1].minor.yy328);
					  gda_sql_select_field_take_alias (field, yymsp[0].minor.yy0); 
					  yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, field);}
#line 2944 "parser.c"
        break;
      case 119: /* selcollist ::= sclp starname */
#line 719 "./parser.y"
{GdaSqlSelectField *field;
					field = gda_sql_select_field_new (NULL);
					gda_sql_select_field_take_star_value (field, yymsp[0].minor.yy0);
					yygotominor.yy247 = g_slist_append (yymsp[-1].minor.yy247, field);}
#line 2952 "parser.c"
        break;
      case 121: /* starname ::= nm DOT STAR */
      case 193: /* fullname ::= nm DOT nm */ yytestcase(yyruleno==193);
#line 725 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
}
#line 2966 "parser.c"
        break;
      case 122: /* starname ::= nm DOT nm DOT STAR */
      case 194: /* fullname ::= nm DOT nm DOT nm */ yytestcase(yyruleno==194);
#line 734 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy0), 
							 g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-4].minor.yy0); g_free (yymsp[-4].minor.yy0);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,140,&yymsp[-3].minor);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
}
#line 2983 "parser.c"
        break;
      case 123: /* as ::= AS fullname */
      case 124: /* as ::= AS value */ yytestcase(yyruleno==124);
#line 745 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,141,&yymsp[-1].minor);
}
#line 2990 "parser.c"
        break;
      case 126: /* distinct ::= */
#line 751 "./parser.y"
{yygotominor.yy189 = NULL;}
#line 2995 "parser.c"
        break;
      case 127: /* distinct ::= ALL */
#line 752 "./parser.y"
{yygotominor.yy189 = NULL;  yy_destructor(yypParser,130,&yymsp[0].minor);
}
#line 3001 "parser.c"
        break;
      case 128: /* distinct ::= DISTINCT */
#line 753 "./parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE;  yy_destructor(yypParser,142,&yymsp[0].minor);
}
#line 3007 "parser.c"
        break;
      case 129: /* distinct ::= DISTINCT ON expr */
#line 754 "./parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE; yygotominor.yy189->expr = yymsp[0].minor.yy328;  yy_destructor(yypParser,142,&yymsp[-2].minor);
  yy_destructor(yypParser,138,&yymsp[-1].minor);
}
#line 3014 "parser.c"
        break;
      case 130: /* nexprlist ::= nexprlist COMMA expr */
      case 133: /* exprlist ::= exprlist COMMA expr */ yytestcase(yyruleno==133);
#line 759 "./parser.y"
{yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, yymsp[0].minor.yy328);  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 3021 "parser.c"
        break;
      case 131: /* nexprlist ::= expr */
      case 134: /* exprlist ::= expr */ yytestcase(yyruleno==134);
#line 760 "./parser.y"
{yygotominor.yy247 = g_slist_append (NULL, yymsp[0].minor.yy328);}
#line 3027 "parser.c"
        break;
      case 135: /* expr ::= pvalue */
#line 772 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;}
#line 3032 "parser.c"
        break;
      case 136: /* expr ::= value */
      case 138: /* expr ::= fullname */ yytestcase(yyruleno==138);
#line 773 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[0].minor.yy0;}
#line 3038 "parser.c"
        break;
      case 137: /* expr ::= LP expr RP */
#line 774 "./parser.y"
{yygotominor.yy328 = yymsp[-1].minor.yy328;  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3045 "parser.c"
        break;
      case 139: /* expr ::= fullname LP exprlist RP */
#line 776 "./parser.y"
{GdaSqlFunction *func;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    gda_sql_function_take_args_list (func, yymsp[-1].minor.yy247);
					    yygotominor.yy328->func = func;  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3057 "parser.c"
        break;
      case 140: /* expr ::= fullname LP compound RP */
#line 782 "./parser.y"
{GdaSqlFunction *func;
					     GdaSqlExpr *expr;
					     yygotominor.yy328 = gda_sql_expr_new (NULL); 
					     func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					     gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					     expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					     gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					     gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					     yygotominor.yy328->func = func;  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3072 "parser.c"
        break;
      case 141: /* expr ::= fullname LP starname RP */
#line 791 "./parser.y"
{GdaSqlFunction *func;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					    expr->value = yymsp[-1].minor.yy0;
					    gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					    yygotominor.yy328->func = func;  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3087 "parser.c"
        break;
      case 142: /* expr ::= CAST LP expr AS fullname RP */
#line 800 "./parser.y"
{yygotominor.yy328 = yymsp[-3].minor.yy328;
						yymsp[-3].minor.yy328->cast_as = g_value_dup_string (yymsp[-1].minor.yy0);
						g_value_reset (yymsp[-1].minor.yy0);
						g_free (yymsp[-1].minor.yy0);  yy_destructor(yypParser,10,&yymsp[-5].minor);
  yy_destructor(yypParser,100,&yymsp[-4].minor);
  yy_destructor(yypParser,141,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3099 "parser.c"
        break;
      case 143: /* expr ::= expr PGCAST fullname */
#line 804 "./parser.y"
{yygotominor.yy328 = yymsp[-2].minor.yy328;
					 yymsp[-2].minor.yy328->cast_as = g_value_dup_string (yymsp[0].minor.yy0);
					 g_value_reset (yymsp[0].minor.yy0);
					 g_free (yymsp[0].minor.yy0);  yy_destructor(yypParser,112,&yymsp[-1].minor);
}
#line 3108 "parser.c"
        break;
      case 144: /* expr ::= expr PLUS|MINUS expr */
#line 809 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3113 "parser.c"
        break;
      case 145: /* expr ::= expr STAR expr */
#line 810 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_STAR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,92,&yymsp[-1].minor);
}
#line 3119 "parser.c"
        break;
      case 146: /* expr ::= expr SLASH|REM expr */
      case 147: /* expr ::= expr BITAND|BITOR expr */ yytestcase(yyruleno==147);
      case 153: /* expr ::= expr GT|LEQ|GEQ|LT expr */ yytestcase(yyruleno==153);
      case 154: /* expr ::= expr DIFF|EQ expr */ yytestcase(yyruleno==154);
      case 156: /* expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr */ yytestcase(yyruleno==156);
#line 811 "./parser.y"
{yygotominor.yy328 = create_two_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3128 "parser.c"
        break;
      case 148: /* expr ::= MINUS expr */
#line 814 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_MINUS, yymsp[0].minor.yy328);  yy_destructor(yypParser,91,&yymsp[-1].minor);
}
#line 3134 "parser.c"
        break;
      case 149: /* expr ::= PLUS expr */
#line 815 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_PLUS, yymsp[0].minor.yy328);  yy_destructor(yypParser,90,&yymsp[-1].minor);
}
#line 3140 "parser.c"
        break;
      case 150: /* expr ::= expr AND expr */
#line 817 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_AND, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 3146 "parser.c"
        break;
      case 151: /* expr ::= expr OR expr */
#line 818 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_OR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,66,&yymsp[-1].minor);
}
#line 3152 "parser.c"
        break;
      case 152: /* expr ::= expr CONCAT expr */
#line 819 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_CONCAT, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,95,&yymsp[-1].minor);
}
#line 3158 "parser.c"
        break;
      case 155: /* expr ::= expr LIKE expr */
#line 823 "./parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_TYPE_LIKE, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,26,&yymsp[-1].minor);
}
#line 3164 "parser.c"
        break;
      case 157: /* expr ::= expr BETWEEN expr AND expr */
#line 825 "./parser.y"
{GdaSqlOperation *cond;
						  yygotominor.yy328 = gda_sql_expr_new (NULL);
						  cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						  yygotominor.yy328->cond = cond;
						  cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						  cond->operands = g_slist_append (NULL, yymsp[-4].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,75,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 3182 "parser.c"
        break;
      case 158: /* expr ::= expr NOT BETWEEN expr AND expr */
#line 838 "./parser.y"
{GdaSqlOperation *cond;
						      GdaSqlExpr *expr;
						      expr = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (expr));
						      expr->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						      cond->operands = g_slist_append (NULL, yymsp[-5].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);

						      yygotominor.yy328 = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						      yygotominor.yy328->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOT;
						      cond->operands = g_slist_prepend (NULL, expr);
						      GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,68,&yymsp[-4].minor);
  yy_destructor(yypParser,75,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 3209 "parser.c"
        break;
      case 159: /* expr ::= NOT expr */
#line 859 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_NOT, yymsp[0].minor.yy328);  yy_destructor(yypParser,68,&yymsp[-1].minor);
}
#line 3215 "parser.c"
        break;
      case 160: /* expr ::= BITNOT expr */
#line 860 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_BITNOT, yymsp[0].minor.yy328);  yy_destructor(yypParser,99,&yymsp[-1].minor);
}
#line 3221 "parser.c"
        break;
      case 161: /* expr ::= expr uni_op */
#line 861 "./parser.y"
{yygotominor.yy328 = create_uni_expr (yymsp[0].minor.yy381, yymsp[-1].minor.yy328);}
#line 3226 "parser.c"
        break;
      case 162: /* expr ::= expr IS expr */
#line 863 "./parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_TYPE_IS, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 3232 "parser.c"
        break;
      case 163: /* expr ::= LP compound RP */
#line 864 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); gda_sql_expr_take_select (yygotominor.yy328, yymsp[-1].minor.yy308);  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3239 "parser.c"
        break;
      case 164: /* expr ::= expr IN LP exprlist RP */
#line 865 "./parser.y"
{GdaSqlOperation *cond;
					   GSList *list;
					   yygotominor.yy328 = gda_sql_expr_new (NULL);
					   cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					   yygotominor.yy328->cond = cond;
					   cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					   cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-4].minor.yy328);
					   for (list = cond->operands; list; list = list->next)
						   GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,70,&yymsp[-3].minor);
  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3256 "parser.c"
        break;
      case 165: /* expr ::= expr IN LP compound RP */
#line 875 "./parser.y"
{GdaSqlOperation *cond;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL);
					    cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    yygotominor.yy328->cond = cond;
					    cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					    
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					    gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					    cond->operands = g_slist_prepend (NULL, expr);
					    cond->operands = g_slist_prepend (cond->operands, yymsp[-4].minor.yy328);
					    GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,70,&yymsp[-3].minor);
  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3276 "parser.c"
        break;
      case 166: /* expr ::= expr NOT IN LP exprlist RP */
#line 888 "./parser.y"
{GdaSqlOperation *cond;
					       GSList *list;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-5].minor.yy328);
					       for (list = cond->operands; list; list = list->next)
						       GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,68,&yymsp[-4].minor);
  yy_destructor(yypParser,70,&yymsp[-3].minor);
  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3294 "parser.c"
        break;
      case 167: /* expr ::= expr NOT IN LP compound RP */
#line 898 "./parser.y"
{GdaSqlOperation *cond;
					       GdaSqlExpr *expr;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       
					       expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					       gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					       cond->operands = g_slist_prepend (NULL, expr);
					       cond->operands = g_slist_prepend (cond->operands, yymsp[-5].minor.yy328);
					       GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,68,&yymsp[-4].minor);
  yy_destructor(yypParser,70,&yymsp[-3].minor);
  yy_destructor(yypParser,100,&yymsp[-2].minor);
  yy_destructor(yypParser,101,&yymsp[0].minor);
}
#line 3315 "parser.c"
        break;
      case 168: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 911 "./parser.y"
{
	GdaSqlCase *sc;
	GSList *list;
	yygotominor.yy328 = gda_sql_expr_new (NULL);
	sc = gda_sql_case_new (GDA_SQL_ANY_PART (yygotominor.yy328));
	sc->base_expr = yymsp[-3].minor.yy122;
	sc->else_expr = yymsp[-1].minor.yy122;
	sc->when_expr_list = yymsp[-2].minor.yy263.when_list;
	sc->then_expr_list = yymsp[-2].minor.yy263.then_list;
	yygotominor.yy328->case_s = sc;
	for (list = sc->when_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
	for (list = sc->then_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
  yy_destructor(yypParser,143,&yymsp[-4].minor);
  yy_destructor(yypParser,17,&yymsp[0].minor);
}
#line 3336 "parser.c"
        break;
      case 169: /* case_operand ::= expr */
#line 929 "./parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;}
#line 3341 "parser.c"
        break;
      case 170: /* case_operand ::= */
      case 174: /* case_else ::= */ yytestcase(yyruleno==174);
#line 930 "./parser.y"
{yygotominor.yy122 = NULL;}
#line 3347 "parser.c"
        break;
      case 171: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 936 "./parser.y"
{
	yygotominor.yy263.when_list = g_slist_append (yymsp[-4].minor.yy263.when_list, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_append (yymsp[-4].minor.yy263.then_list, yymsp[0].minor.yy328);
  yy_destructor(yypParser,144,&yymsp[-3].minor);
  yy_destructor(yypParser,145,&yymsp[-1].minor);
}
#line 3357 "parser.c"
        break;
      case 172: /* case_exprlist ::= WHEN expr THEN expr */
#line 940 "./parser.y"
{
	yygotominor.yy263.when_list = g_slist_prepend (NULL, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_prepend (NULL, yymsp[0].minor.yy328);
  yy_destructor(yypParser,144,&yymsp[-3].minor);
  yy_destructor(yypParser,145,&yymsp[-1].minor);
}
#line 3367 "parser.c"
        break;
      case 173: /* case_else ::= ELSE expr */
#line 947 "./parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;  yy_destructor(yypParser,146,&yymsp[-1].minor);
}
#line 3373 "parser.c"
        break;
      case 175: /* uni_op ::= ISNULL */
#line 951 "./parser.y"
{yygotominor.yy381 = GDA_SQL_OPERATOR_TYPE_ISNULL;  yy_destructor(yypParser,71,&yymsp[0].minor);
}
#line 3379 "parser.c"
        break;
      case 176: /* uni_op ::= IS NOTNULL */
#line 952 "./parser.y"
{yygotominor.yy381 = GDA_SQL_OPERATOR_TYPE_ISNOTNULL;  yy_destructor(yypParser,69,&yymsp[-1].minor);
  yy_destructor(yypParser,72,&yymsp[0].minor);
}
#line 3386 "parser.c"
        break;
      case 177: /* value ::= NULL */
#line 956 "./parser.y"
{yygotominor.yy0 = NULL;  yy_destructor(yypParser,147,&yymsp[0].minor);
}
#line 3392 "parser.c"
        break;
      case 181: /* pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET */
#line 965 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(yypParser,149,&yymsp[-3].minor);
  yy_destructor(yypParser,150,&yymsp[-2].minor);
  yy_destructor(yypParser,151,&yymsp[0].minor);
}
#line 3400 "parser.c"
        break;
      case 182: /* pvalue ::= value LSBRACKET paramspec RSBRACKET */
#line 966 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[-3].minor.yy0; yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(yypParser,150,&yymsp[-2].minor);
  yy_destructor(yypParser,151,&yymsp[0].minor);
}
#line 3407 "parser.c"
        break;
      case 183: /* pvalue ::= SIMPLEPARAM */
#line 967 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = gda_sql_param_spec_new (yymsp[0].minor.yy0);}
#line 3412 "parser.c"
        break;
      case 184: /* paramspec ::= */
#line 972 "./parser.y"
{yygotominor.yy405 = NULL;}
#line 3417 "parser.c"
        break;
      case 185: /* paramspec ::= paramspec PNAME */
#line 973 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_name (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3423 "parser.c"
        break;
      case 186: /* paramspec ::= paramspec PDESCR */
#line 975 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_descr (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3429 "parser.c"
        break;
      case 187: /* paramspec ::= paramspec PTYPE */
#line 977 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_type (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3435 "parser.c"
        break;
      case 188: /* paramspec ::= paramspec PNULLOK */
#line 979 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					   gda_sql_param_spec_take_nullok (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3441 "parser.c"
        break;
      default:
      /* (34) trans_opt_kw ::= */ yytestcase(yyruleno==34);
      /* (36) opt_comma ::= */ yytestcase(yyruleno==36);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  gda_lemon_capi_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  gda_lemon_capi_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  gda_lemon_capi_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 22 "./parser.y"

	gda_sql_parser_set_syntax_error (pdata->parser);
#line 3508 "parser.c"
  gda_lemon_capi_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  gda_lemon_capi_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  gda_lemon_capi_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "gda_lemon_capi_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void gda_lemon_capi_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  gda_lemon_capi_parserTOKENTYPE yyminor       /* The value for the token */
  gda_lemon_capi_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  gda_lemon_capi_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
