/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * ParserTools.java
 * ------------
 */
package org.pentaho.reporting.libraries.formula.parser;

/**
 * Creation-Date: 03.11.2006, 18:57:23
 *
 * @author Thomas Morgner
 */
public class ParserTools
{
  private ParserTools()
  {
  }

  /**
   * Unconditionally removes the first and last character of the given string and also unquotes the quoted double-quotes.
   *
   * @param s the string to be stripped.
   * @return the stripped string.
   */
  public static String stripQuote(final String s)
  {
    boolean encounteredQuote = false;

    final StringBuffer b = new StringBuffer(s.length() - 2);
    final int size = s.length() - 1;
    for (int i = 1; i < size; i++)
    {
      final char c = s.charAt(i);
      if (encounteredQuote)
      {
        if (c == '"')
        {
          encounteredQuote = false;
          continue;
        }
      }
      if (c == '"')
      {
        encounteredQuote = true;
      }
      else
      {
        encounteredQuote = false;
      }
      b.append(c);
    }
    return b.toString();
  }
}
