/*
 * OMAP54xx EMIF registers and bitfields
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 *
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __EMIF_REGS_H
#define __EMIF_REGS_H

/* Registers offset */
#define EMIF_MODULE_ID_AND_REVISION			0x0000
#define EMIF_STATUS					0x0004
#define EMIF_SDRAM_CONFIG				0x0008
#define EMIF_SDRAM_CONFIG_2				0x000c
#define EMIF_SDRAM_REFRESH_CONTROL			0x0010
#define EMIF_SDRAM_REFRESH_CTRL_SHDW		0x0014
#define EMIF_SDRAM_TIMING_1				0x0018
#define EMIF_SDRAM_TIMING_1_SHDW			0x001c
#define EMIF_SDRAM_TIMING_2				0x0020
#define EMIF_SDRAM_TIMING_2_SHDW			0x0024
#define EMIF_SDRAM_TIMING_3				0x0028
#define EMIF_SDRAM_TIMING_3_SHDW			0x002c
#define EMIF_LPDDR2_NVM_TIMING				0x0030
#define EMIF_LPDDR2_NVM_TIMING_SHDW			0x0034
#define EMIF_POWER_MANAGEMENT_CONTROL			0x0038
#define EMIF_POWER_MANAGEMENT_CTRL_SHDW		0x003c
#define EMIF_LPDDR2_MODE_REG_DATA			0x0040
#define EMIF_LPDDR2_MODE_REG_CONFIG			0x0050
#define EMIF_OCP_CONFIG					0x0054
#define EMIF_OCP_CONFIG_VALUE_1				0x0058
#define EMIF_OCP_CONFIG_VALUE_2				0x005c
#define EMIF_IODFT_TEST_LOGIC_GLOBAL_CONTROL		0x0060
#define EMIF_IODFT_TEST_LOGIC_CTRL_MISR_RESULT	0x0064
#define EMIF_IODFT_TEST_LOGIC_ADDRESS_MISR_RESULT	0x0068
#define EMIF_IODFT_TEST_LOGIC_DATA_MISR_RESULT_1	0x006c
#define EMIF_IODFT_TEST_LOGIC_DATA_MISR_RESULT_2	0x0070
#define EMIF_IODFT_TEST_LOGIC_DATA_MISR_RESULT_3	0x0074
#define EMIF_PERFORMANCE_COUNTER_1			0x0080
#define EMIF_PERFORMANCE_COUNTER_2			0x0084
#define EMIF_PERFORMANCE_COUNTER_CONFIG			0x0088
#define EMIF_PERFORMANCE_COUNTER_MASTER_REGION_SELECT	0x008c
#define EMIF_PERFORMANCE_COUNTER_TIME			0x0090
#define EMIF_MISC_REG					0x0094
#define EMIF_DLL_CALIB_CTRL				0x0098
#define EMIF_DLL_CALIB_CTRL_SHDW			0x009c
#define EMIF_END_OF_INTERRUPT				0x00a0
#define EMIF_SYSTEM_OCP_INTERRUPT_RAW_STATUS		0x00a4
#define EMIF_LL_OCP_INTERRUPT_RAW_STATUS	0x00a8
#define EMIF_SYSTEM_OCP_INTERRUPT_STATUS		0x00ac
#define EMIF_LL_OCP_INTERRUPT_STATUS		0x00b0
#define EMIF_SYSTEM_OCP_INTERRUPT_ENABLE_SET		0x00b4
#define EMIF_LL_OCP_INTERRUPT_ENABLE_SET	0x00b8
#define EMIF_SYSTEM_OCP_INTERRUPT_ENABLE_CLEAR		0x00bc
#define EMIF_LL_OCP_INTERRUPT_ENABLE_CLEAR	0x00c0
#define EMIF_SDRAM_OUTPUT_IMPEDANCE_CALIBRATION_CONFIG	0x00c8
#define EMIF_TEMPERATURE_ALERT_CONFIG			0x00cc
#define EMIF_OCP_ERROR_LOG				0x00d0
#define EMIF_READ_WRITE_LEVELING_RAMP_WINDOW		0x00d4
#define EMIF_READ_WRITE_LEVELING_RAMP_CONTROL		0x00d8
#define EMIF_READ_WRITE_LEVELING_CONTROL		0x00dc
#define EMIF_DDR_PHY_CTRL_1				0x00e4
#define EMIF_DDR_PHY_CTRL_1_SHDW			0x00e8
#define EMIF_DDR_PHY_CTRL_2				0x00ec
#define EMIF_PRIORITY_TO_CLASS_OF_SERVICE_MAPPING	0x0100
#define EMIF_CONNECTION_ID_TO_CLASS_OF_SERVICE_1_MAPPING	0x0104
#define EMIF_CONNECTION_ID_TO_CLASS_OF_SERVICE_2_MAPPING	0x0108
#define EMIF_READ_WRITE_EXECUTION_THRESHOLD		0x0120
#define EMIF_COS_CONFIG					0x0124
#define EMIF_PHY_STATUS_1				0x0140
#define EMIF_PHY_STATUS_2				0x0144
#define EMIF_PHY_STATUS_3				0x0148
#define EMIF_PHY_STATUS_4				0x014c
#define EMIF_PHY_STATUS_5				0x0150
#define EMIF_PHY_STATUS_6				0x0154
#define EMIF_PHY_STATUS_7				0x0158
#define EMIF_PHY_STATUS_8				0x015c
#define EMIF_PHY_STATUS_9				0x0160
#define EMIF_PHY_STATUS_10				0x0164
#define EMIF_PHY_STATUS_11				0x0168
#define EMIF_PHY_STATUS_12				0x016c
#define EMIF_PHY_STATUS_13				0x0170
#define EMIF_PHY_STATUS_14				0x0174
#define EMIF_PHY_STATUS_15				0x0178
#define EMIF_PHY_STATUS_16				0x017c
#define EMIF_PHY_STATUS_17				0x0180
#define EMIF_PHY_STATUS_18				0x0184
#define EMIF_PHY_STATUS_19				0x0188
#define EMIF_PHY_STATUS_20				0x018c
#define EMIF_PHY_STATUS_21				0x0190
#define EMIF_EXT_PHY_CTRL_1				0x0200
#define EMIF_EXT_PHY_CTRL_1_SHDW			0x0204
#define EMIF_EXT_PHY_CTRL_2				0x0208
#define EMIF_EXT_PHY_CTRL_2_SHDW			0x020c
#define EMIF_EXT_PHY_CTRL_3				0x0210
#define EMIF_EXT_PHY_CTRL_3_SHDW			0x0214
#define EMIF_EXT_PHY_CTRL_4				0x0218
#define EMIF_EXT_PHY_CTRL_4_SHDW			0x021c
#define EMIF_EXT_PHY_CTRL_5				0x0220
#define EMIF_EXT_PHY_CTRL_5_SHDW			0x0224
#define EMIF_EXT_PHY_CTRL_6				0x0228
#define EMIF_EXT_PHY_CTRL_6_SHDW			0x022c
#define EMIF_EXT_PHY_CTRL_7				0x0230
#define EMIF_EXT_PHY_CTRL_7_SHDW			0x0234
#define EMIF_EXT_PHY_CTRL_8				0x0238
#define EMIF_EXT_PHY_CTRL_8_SHDW			0x023c
#define EMIF_EXT_PHY_CTRL_9				0x0240
#define EMIF_EXT_PHY_CTRL_9_SHDW			0x0244
#define EMIF_EXT_PHY_CTRL_10				0x0248
#define EMIF_EXT_PHY_CTRL_10_SHDW			0x024c
#define EMIF_EXT_PHY_CTRL_11				0x0250
#define EMIF_EXT_PHY_CTRL_11_SHDW			0x0254
#define EMIF_EXT_PHY_CTRL_12				0x0258
#define EMIF_EXT_PHY_CTRL_12_SHDW			0x025c
#define EMIF_EXT_PHY_CTRL_13				0x0260
#define EMIF_EXT_PHY_CTRL_13_SHDW			0x0264
#define EMIF_EXT_PHY_CTRL_14				0x0268
#define EMIF_EXT_PHY_CTRL_14_SHDW			0x026c
#define EMIF_EXT_PHY_CTRL_15				0x0270
#define EMIF_EXT_PHY_CTRL_15_SHDW			0x0274
#define EMIF_EXT_PHY_CTRL_16				0x0278
#define EMIF_EXT_PHY_CTRL_16_SHDW			0x027c
#define EMIF_EXT_PHY_CTRL_17				0x0280
#define EMIF_EXT_PHY_CTRL_17_SHDW			0x0284
#define EMIF_EXT_PHY_CTRL_18				0x0288
#define EMIF_EXT_PHY_CTRL_18_SHDW			0x028c
#define EMIF_EXT_PHY_CTRL_19				0x0290
#define EMIF_EXT_PHY_CTRL_19_SHDW			0x0294
#define EMIF_EXT_PHY_CTRL_20				0x0298
#define EMIF_EXT_PHY_CTRL_20_SHDW			0x029c
#define EMIF_EXT_PHY_CTRL_21				0x02a0
#define EMIF_EXT_PHY_CTRL_21_SHDW			0x02a4
#define EMIF_EXT_PHY_CTRL_22				0x02a8
#define EMIF_EXT_PHY_CTRL_22_SHDW			0x02ac
#define EMIF_EXT_PHY_CTRL_23				0x02b0
#define EMIF_EXT_PHY_CTRL_23_SHDW			0x02b4
#define EMIF_EXT_PHY_CTRL_24				0x02b8
#define EMIF_EXT_PHY_CTRL_24_SHDW			0x02bc
#define EMIF_EXT_PHY_CTRL_25				0x02c0
#define EMIF_EXT_PHY_CTRL_25_SHDW			0x02c4
#define EMIF_EXT_PHY_CTRL_26				0x02c8
#define EMIF_EXT_PHY_CTRL_26_SHDW			0x02cc
#define EMIF_EXT_PHY_CTRL_27				0x02d0
#define EMIF_EXT_PHY_CTRL_27_SHDW			0x02d4
#define EMIF_EXT_PHY_CTRL_28				0x02d8
#define EMIF_EXT_PHY_CTRL_28_SHDW			0x02dc
#define EMIF_EXT_PHY_CTRL_29				0x02e0
#define EMIF_EXT_PHY_CTRL_29_SHDW			0x02e4
#define EMIF_EXT_PHY_CTRL_30				0x02e8
#define EMIF_EXT_PHY_CTRL_30_SHDW			0x02ec

/* Registers shifts and masks */

/* EMIF_MODULE_ID_AND_REVISION */
#define SCHEME_SHIFT			30
#define SCHEME_MASK			(0x3 << 30)
#define MODULE_ID_SHIFT			16
#define MODULE_ID_MASK			(0xfff << 16)
#define RTL_VERSION_SHIFT		11
#define RTL_VERSION_MASK		(0x1f << 11)
#define MAJOR_REVISION_SHIFT		8
#define MAJOR_REVISION_MASK		(0x7 << 8)
#define MINOR_REVISION_SHIFT		0
#define MINOR_REVISION_MASK		(0x3f << 0)

/* STATUS */
#define BE_SHIFT			31
#define BE_MASK				(1 << 31)
#define DUAL_CLK_MODE_SHIFT		30
#define DUAL_CLK_MODE_MASK		(1 << 30)
#define FAST_INIT_SHIFT			29
#define FAST_INIT_MASK			(1 << 29)
#define RDLVLGATETO_SHIFT		6
#define RDLVLGATETO_MASK		(1 << 6)
#define RDLVLTO_SHIFT			5
#define RDLVLTO_MASK			(1 << 5)
#define WRLVLTO_SHIFT			4
#define WRLVLTO_MASK			(1 << 4)
#define PHY_DLL_READY_SHIFT		2
#define PHY_DLL_READY_MASK		(1 << 2)

/* SDRAM_CONFIG */
#define SDRAM_TYPE_SHIFT		29
#define SDRAM_TYPE_MASK			(0x7 << 29)
#define IBANK_POS_SHIFT			27
#define IBANK_POS_MASK			(0x3 << 27)
#define DDR_TERM_SHIFT			24
#define DDR_TERM_MASK			(0x7 << 24)
#define DDR2_DDQS_SHIFT			23
#define DDR2_DDQS_MASK			(1 << 23)
#define DYN_ODT_SHIFT			21
#define DYN_ODT_MASK			(0x3 << 21)
#define DDR_DISABLE_DLL_SHIFT		20
#define DDR_DISABLE_DLL_MASK		(1 << 20)
#define SDRAM_DRIVE_SHIFT		18
#define SDRAM_DRIVE_MASK		(0x3 << 18)
#define CWL_SHIFT			16
#define CWL_MASK			(0x3 << 16)
#define NARROW_MODE_SHIFT		14
#define NARROW_MODE_MASK		(0x3 << 14)
#define CL_SHIFT			10
#define CL_MASK				(0xf << 10)
#define ROWSIZE_SHIFT			7
#define ROWSIZE_MASK			(0x7 << 7)
#define IBANK_SHIFT			4
#define IBANK_MASK			(0x7 << 4)
#define EBANK_SHIFT			3
#define EBANK_MASK			(1 << 3)
#define PAGESIZE_SHIFT			0
#define PAGESIZE_MASK			(0x7 << 0)

/* SDRAM_CONFIG_2 */
#define CS1NVMEN_SHIFT			30
#define CS1NVMEN_MASK			(1 << 30)
#define EBANK_POS_SHIFT			27
#define EBANK_POS_MASK			(1 << 27)
#define RDBNUM_SHIFT			4
#define RDBNUM_MASK			(0x3 << 4)
#define RDBSIZE_SHIFT			0
#define RDBSIZE_MASK			(0x7 << 0)

/* SDRAM_REFRESH_CONTROL */
#define INITREF_DIS_SHIFT		31
#define INITREF_DIS_MASK		(1 << 31)
#define SRT_SHIFT			29
#define SRT_MASK			(1 << 29)
#define ASR_SHIFT			28
#define ASR_MASK			(1 << 28)
#define PASR_SHIFT			24
#define PASR_MASK			(0x7 << 24)
#define REFRESH_RATE_SHIFT		0
#define REFRESH_RATE_MASK		(0xffff << 0)

/* SDRAM_REFRESH_CTRL_SHDW */
#define REFRESH_RATE_SHDW_SHIFT		0
#define REFRESH_RATE_SHDW_MASK		(0xffff << 0)

/* SDRAM_TIMING_1 */
#define T_RTW_SHIFT			29
#define T_RTW_MASK			(0x7 << 29)
#define T_RP_SHIFT			25
#define T_RP_MASK			(0xf << 25)
#define T_RCD_SHIFT			21
#define T_RCD_MASK			(0xf << 21)
#define T_WR_SHIFT			17
#define T_WR_MASK			(0xf << 17)
#define T_RAS_SHIFT			12
#define T_RAS_MASK			(0x1f << 12)
#define T_RC_SHIFT			6
#define T_RC_MASK			(0x3f << 6)
#define T_RRD_SHIFT			3
#define T_RRD_MASK			(0x7 << 3)
#define T_WTR_SHIFT			0
#define T_WTR_MASK			(0x7 << 0)

/* SDRAM_TIMING_1_SHDW */
#define T_RTW_SHDW_SHIFT		29
#define T_RTW_SHDW_MASK			(0x7 << 29)
#define T_RP_SHDW_SHIFT			25
#define T_RP_SHDW_MASK			(0xf << 25)
#define T_RCD_SHDW_SHIFT		21
#define T_RCD_SHDW_MASK			(0xf << 21)
#define T_WR_SHDW_SHIFT			17
#define T_WR_SHDW_MASK			(0xf << 17)
#define T_RAS_SHDW_SHIFT		12
#define T_RAS_SHDW_MASK			(0x1f << 12)
#define T_RC_SHDW_SHIFT			6
#define T_RC_SHDW_MASK			(0x3f << 6)
#define T_RRD_SHDW_SHIFT		3
#define T_RRD_SHDW_MASK			(0x7 << 3)
#define T_WTR_SHDW_SHIFT		0
#define T_WTR_SHDW_MASK			(0x7 << 0)

/* SDRAM_TIMING_2 */
#define T_XP_SHIFT			28
#define T_XP_MASK			(0x7 << 28)
#define T_ODT_SHIFT			25
#define T_ODT_MASK			(0x7 << 25)
#define T_XSNR_SHIFT			16
#define T_XSNR_MASK			(0x1ff << 16)
#define T_XSRD_SHIFT			6
#define T_XSRD_MASK			(0x3ff << 6)
#define T_RTP_SHIFT			3
#define T_RTP_MASK			(0x7 << 3)
#define T_CKE_SHIFT			0
#define T_CKE_MASK			(0x7 << 0)

/* SDRAM_TIMING_2_SHDW */
#define T_XP_SHDW_SHIFT			28
#define T_XP_SHDW_MASK			(0x7 << 28)
#define T_ODT_SHDW_SHIFT		25
#define T_ODT_SHDW_MASK			(0x7 << 25)
#define T_XSNR_SHDW_SHIFT		16
#define T_XSNR_SHDW_MASK		(0x1ff << 16)
#define T_XSRD_SHDW_SHIFT		6
#define T_XSRD_SHDW_MASK		(0x3ff << 6)
#define T_RTP_SHDW_SHIFT		3
#define T_RTP_SHDW_MASK			(0x7 << 3)
#define T_CKE_SHDW_SHIFT		0
#define T_CKE_SHDW_MASK			(0x7 << 0)

/* SDRAM_TIMING_3 */
#define T_PDLL_UL_SHIFT			28
#define T_PDLL_UL_MASK			(0xf << 28)
#define T_CSTA_SHIFT			24
#define T_CSTA_MASK			(0xf << 24)
#define T_CKESR_SHIFT			21
#define T_CKESR_MASK			(0x7 << 21)
#define ZQ_ZQCS_SHIFT			15
#define ZQ_ZQCS_MASK			(0x3f << 15)
#define T_TDQSCKMAX_SHIFT		13
#define T_TDQSCKMAX_MASK		(0x3 << 13)
#define T_RFC_SHIFT			4
#define T_RFC_MASK			(0x1ff << 4)
#define T_RAS_MAX_SHIFT			0
#define T_RAS_MAX_MASK			(0xf << 0)

/* SDRAM_TIMING_3_SHDW */
#define T_PDLL_UL_SHDW_SHIFT		28
#define T_PDLL_UL_SHDW_MASK		(0xf << 28)
#define T_CSTA_SHDW_SHIFT		24
#define T_CSTA_SHDW_MASK		(0xf << 24)
#define T_CKESR_SHDW_SHIFT		21
#define T_CKESR_SHDW_MASK		(0x7 << 21)
#define ZQ_ZQCS_SHDW_SHIFT		15
#define ZQ_ZQCS_SHDW_MASK		(0x3f << 15)
#define T_TDQSCKMAX_SHDW_SHIFT		13
#define T_TDQSCKMAX_SHDW_MASK		(0x3 << 13)
#define T_RFC_SHDW_SHIFT		4
#define T_RFC_SHDW_MASK			(0x1ff << 4)
#define T_RAS_MAX_SHDW_SHIFT		0
#define T_RAS_MAX_SHDW_MASK		(0xf << 0)

/* LPDDR2_NVM_TIMING */
#define NVM_T_XP_SHIFT			28
#define NVM_T_XP_MASK			(0x7 << 28)
#define NVM_T_WTR_SHIFT			24
#define NVM_T_WTR_MASK			(0x7 << 24)
#define NVM_T_RP_SHIFT			20
#define NVM_T_RP_MASK			(0xf << 20)
#define NVM_T_WRA_SHIFT			16
#define NVM_T_WRA_MASK			(0xf << 16)
#define NVM_T_RRD_SHIFT			8
#define NVM_T_RRD_MASK			(0xff << 8)
#define NVM_T_RCDMIN_SHIFT		0
#define NVM_T_RCDMIN_MASK		(0xff << 0)

/* LPDDR2_NVM_TIMING_SHDW */
#define NVM_T_XP_SHDW_SHIFT		28
#define NVM_T_XP_SHDW_MASK		(0x7 << 28)
#define NVM_T_WTR_SHDW_SHIFT		24
#define NVM_T_WTR_SHDW_MASK		(0x7 << 24)
#define NVM_T_RP_SHDW_SHIFT		20
#define NVM_T_RP_SHDW_MASK		(0xf << 20)
#define NVM_T_WRA_SHDW_SHIFT		16
#define NVM_T_WRA_SHDW_MASK		(0xf << 16)
#define NVM_T_RRD_SHDW_SHIFT		8
#define NVM_T_RRD_SHDW_MASK		(0xff << 8)
#define NVM_T_RCDMIN_SHDW_SHIFT		0
#define NVM_T_RCDMIN_SHDW_MASK		(0xff << 0)

/* POWER_MANAGEMENT_CONTROL */
#define PD_TIM_SHIFT			12
#define PD_TIM_MASK			(0xf << 12)
#define DPD_EN_SHIFT			11
#define DPD_EN_MASK			(1 << 11)
#define LP_MODE_SHIFT			8
#define LP_MODE_MASK			(0x7 << 8)
#define SR_TIM_SHIFT			4
#define SR_TIM_MASK			(0xf << 4)
#define CS_TIM_SHIFT			0
#define CS_TIM_MASK			(0xf << 0)

/* POWER_MANAGEMENT_CTRL_SHDW */
#define PD_TIM_SHDW_SHIFT		12
#define PD_TIM_SHDW_MASK		(0xf << 12)
#define SR_TIM_SHDW_SHIFT		4
#define SR_TIM_SHDW_MASK		(0xf << 4)
#define CS_TIM_SHDW_SHIFT		0
#define CS_TIM_SHDW_MASK		(0xf << 0)

/* LPDDR2_MODE_REG_DATA */
#define VALUE_0_SHIFT			0
#define VALUE_0_MASK			(0x7f << 0)

/* LPDDR2_MODE_REG_CONFIG */
#define CS_SHIFT			31
#define CS_MASK				(1 << 31)
#define REFRESH_EN_SHIFT		30
#define REFRESH_EN_MASK			(1 << 30)
#define ADDRESS_SHIFT			0
#define ADDRESS_MASK			(0xff << 0)

/* OCP_CONFIG */
#define SYS_THRESH_MAX_SHIFT		24
#define SYS_THRESH_MAX_MASK		(0xf << 24)
#define MPU_THRESH_MAX_SHIFT		20
#define MPU_THRESH_MAX_MASK		(0xf << 20)
#define LL_THRESH_MAX_SHIFT		16
#define LL_THRESH_MAX_MASK		(0xf << 16)

/* OCP_CONFIG_VALUE_1 */
#define SYS_BUS_WIDTH_SHIFT		30
#define SYS_BUS_WIDTH_MASK		(0x3 << 30)
#define LL_BUS_WIDTH_SHIFT		28
#define LL_BUS_WIDTH_MASK		(0x3 << 28)
#define WR_FIFO_DEPTH_SHIFT		8
#define WR_FIFO_DEPTH_MASK		(0xff << 8)
#define CMD_FIFO_DEPTH_SHIFT		0
#define CMD_FIFO_DEPTH_MASK		(0xff << 0)

/* OCP_CONFIG_VALUE_2 */
#define RREG_FIFO_DEPTH_SHIFT		16
#define RREG_FIFO_DEPTH_MASK		(0xff << 16)
#define RSD_FIFO_DEPTH_SHIFT		8
#define RSD_FIFO_DEPTH_MASK		(0xff << 8)
#define RCMD_FIFO_DEPTH_SHIFT		0
#define RCMD_FIFO_DEPTH_MASK		(0xff << 0)

/* IODFT_TEST_LOGIC_GLOBAL_CONTROL */
#define TLEC_SHIFT			16
#define TLEC_MASK			(0xffff << 16)
#define MT_SHIFT			14
#define MT_MASK				(1 << 14)
#define ACT_CAP_EN_SHIFT		13
#define ACT_CAP_EN_MASK			(1 << 13)
#define OPG_LD_SHIFT			12
#define OPG_LD_MASK			(1 << 12)
#define RESET_PHY_SHIFT			10
#define RESET_PHY_MASK			(1 << 10)
#define MMS_SHIFT			8
#define MMS_MASK			(1 << 8)
#define MC_SHIFT			4
#define MC_MASK				(0x3 << 4)
#define PC_SHIFT			1
#define PC_MASK				(0x7 << 1)
#define TM_SHIFT			0
#define TM_MASK				(1 << 0)

/* IODFT_TEST_LOGIC_CTRL_MISR_RESULT */
#define DQM_TLMR_SHIFT			12
#define DQM_TLMR_MASK			(0x3ff << 12)
#define CTL_TLMR_SHIFT			0
#define CTL_TLMR_MASK			(0x7ff << 0)

/* IODFT_TEST_LOGIC_ADDRESS_MISR_RESULT */
#define ADDR_TLMR_SHIFT			0
#define ADDR_TLMR_MASK			(0x1fffff << 0)

/* IODFT_TEST_LOGIC_DATA_MISR_RESULT_1 */
#define DATA_TLMR_31_0_SHIFT		0
#define DATA_TLMR_31_0_MASK		(0xffffffff << 0)

/* IODFT_TEST_LOGIC_DATA_MISR_RESULT_2 */
#define DATA_TLMR_63_32_SHIFT		0
#define DATA_TLMR_63_32_MASK		(0xffffffff << 0)

/* IODFT_TEST_LOGIC_DATA_MISR_RESULT_3 */
#define DATA_TLMR_66_64_SHIFT		0
#define DATA_TLMR_66_64_MASK		(0x7 << 0)

/* PERFORMANCE_COUNTER_1 */
#define COUNTER1_SHIFT			0
#define COUNTER1_MASK			(0xffffffff << 0)

/* PERFORMANCE_COUNTER_2 */
#define COUNTER2_SHIFT			0
#define COUNTER2_MASK			(0xffffffff << 0)

/* PERFORMANCE_COUNTER_CONFIG */
#define CNTR2_MCONNID_EN_SHIFT		31
#define CNTR2_MCONNID_EN_MASK		(1 << 31)
#define CNTR2_REGION_EN_SHIFT		30
#define CNTR2_REGION_EN_MASK		(1 << 30)
#define CNTR2_CFG_SHIFT			16
#define CNTR2_CFG_MASK			(0xf << 16)
#define CNTR1_MCONNID_EN_SHIFT		15
#define CNTR1_MCONNID_EN_MASK		(1 << 15)
#define CNTR1_REGION_EN_SHIFT		14
#define CNTR1_REGION_EN_MASK		(1 << 14)
#define CNTR1_CFG_SHIFT			0
#define CNTR1_CFG_MASK			(0xf << 0)

/* PERFORMANCE_COUNTER_MASTER_REGION_SELECT */
#define MCONNID2_SHIFT			24
#define MCONNID2_MASK			(0xff << 24)
#define REGION_SEL2_SHIFT		16
#define REGION_SEL2_MASK		(0x3 << 16)
#define MCONNID1_SHIFT			8
#define MCONNID1_MASK			(0xff << 8)
#define REGION_SEL1_SHIFT		0
#define REGION_SEL1_MASK		(0x3 << 0)

/* PERFORMANCE_COUNTER_TIME */
#define TOTAL_TIME_SHIFT		0
#define TOTAL_TIME_MASK			(0xffffffff << 0)

/* MISC_REG */
#define DLL_CALIB_OS_SHIFT		0
#define DLL_CALIB_OS_MASK		(1 << 0)

/* DLL_CALIB_CTRL */
#define ACK_WAIT_SHIFT			16
#define ACK_WAIT_MASK			(0xf << 16)
#define DLL_CALIB_INTERVAL_SHIFT	0
#define DLL_CALIB_INTERVAL_MASK		(0x1ff << 0)

/* DLL_CALIB_CTRL_SHDW */
#define ACK_WAIT_SHDW_SHIFT		16
#define ACK_WAIT_SHDW_MASK		(0xf << 16)
#define DLL_CALIB_INTERVAL_SHDW_SHIFT	0
#define DLL_CALIB_INTERVAL_SHDW_MASK	(0x1ff << 0)

/* END_OF_INTERRUPT */
#define EOI_SHIFT			0
#define EOI_MASK			(1 << 0)

/* SYSTEM_OCP_INTERRUPT_RAW_STATUS */
#define DNV_SYS_SHIFT			2
#define DNV_SYS_MASK			(1 << 2)
#define TA_SYS_SHIFT			1
#define TA_SYS_MASK			(1 << 1)
#define ERR_SYS_SHIFT			0
#define ERR_SYS_MASK			(1 << 0)

/* LOW_LATENCY_OCP_INTERRUPT_RAW_STATUS */
#define DNV_LL_SHIFT			2
#define DNV_LL_MASK			(1 << 2)
#define TA_LL_SHIFT			1
#define TA_LL_MASK			(1 << 1)
#define ERR_LL_SHIFT			0
#define ERR_LL_MASK			(1 << 0)

/* SYSTEM_OCP_INTERRUPT_ENABLE_SET */
#define EN_DNV_SYS_SHIFT		2
#define EN_DNV_SYS_MASK			(1 << 2)
#define EN_TA_SYS_SHIFT			1
#define EN_TA_SYS_MASK			(1 << 1)
#define EN_ERR_SYS_SHIFT			0
#define EN_ERR_SYS_MASK			(1 << 0)

/* LOW_LATENCY_OCP_INTERRUPT_ENABLE_SET */
#define EN_DNV_LL_SHIFT			2
#define EN_DNV_LL_MASK			(1 << 2)
#define EN_TA_LL_SHIFT			1
#define EN_TA_LL_MASK			(1 << 1)
#define EN_ERR_LL_SHIFT			0
#define EN_ERR_LL_MASK			(1 << 0)

/* SDRAM_OUTPUT_IMPEDANCE_CALIBRATION_CONFIG */
#define ZQ_CS1EN_SHIFT			31
#define ZQ_CS1EN_MASK			(1 << 31)
#define ZQ_CS0EN_SHIFT			30
#define ZQ_CS0EN_MASK			(1 << 30)
#define ZQ_DUALCALEN_SHIFT		29
#define ZQ_DUALCALEN_MASK		(1 << 29)
#define ZQ_SFEXITEN_SHIFT		28
#define ZQ_SFEXITEN_MASK		(1 << 28)
#define ZQ_ZQINIT_MULT_SHIFT		18
#define ZQ_ZQINIT_MULT_MASK		(0x3 << 18)
#define ZQ_ZQCL_MULT_SHIFT		16
#define ZQ_ZQCL_MULT_MASK		(0x3 << 16)
#define ZQ_REFINTERVAL_SHIFT		0
#define ZQ_REFINTERVAL_MASK		(0xffff << 0)

/* TEMPERATURE_ALERT_CONFIG */
#define TA_CS1EN_SHIFT			31
#define TA_CS1EN_MASK			(1 << 31)
#define TA_CS0EN_SHIFT			30
#define TA_CS0EN_MASK			(1 << 30)
#define TA_SFEXITEN_SHIFT		28
#define TA_SFEXITEN_MASK		(1 << 28)
#define TA_DEVWDT_SHIFT			26
#define TA_DEVWDT_MASK			(0x3 << 26)
#define TA_DEVCNT_SHIFT			24
#define TA_DEVCNT_MASK			(0x3 << 24)
#define TA_REFINTERVAL_SHIFT		0
#define TA_REFINTERVAL_MASK		(0x3fffff << 0)

/* OCP_ERROR_LOG */
#define MADDRSPACE_SHIFT		14
#define MADDRSPACE_MASK			(0x3 << 14)
#define MBURSTSEQ_SHIFT			11
#define MBURSTSEQ_MASK			(0x7 << 11)
#define MCMD_SHIFT			8
#define MCMD_MASK			(0x7 << 8)
#define MCONNID_SHIFT			0
#define MCONNID_MASK			(0xff << 0)

/* READ_WRITE_LEVELING_RAMP_WINDOW */
#define RDWRLVLINC_RMP_WIN_SHIFT	0
#define RDWRLVLINC_RMP_WIN_MASK		(0x1fff << 0)

/* READ_WRITE_LEVELING_RAMP_CONTROL */
#define RDWRLVL_EN_SHIFT		31
#define RDWRLVL_EN_MASK			(1 << 31)
#define RDWRLVLINC_RMP_PRE_SHIFT	24
#define RDWRLVLINC_RMP_PRE_MASK		(0x7f << 24)
#define RDLVLINC_RMP_INT_SHIFT		16
#define RDLVLINC_RMP_INT_MASK		(0xff << 16)
#define RDLVLGATEINC_RMP_INT_SHIFT	8
#define RDLVLGATEINC_RMP_INT_MASK	(0xff << 8)
#define WRLVLINC_RMP_INT_SHIFT		0
#define WRLVLINC_RMP_INT_MASK		(0xff << 0)

/* READ_WRITE_LEVELING_CONTROL */
#define RDWRLVLFULL_START_SHIFT		31
#define RDWRLVLFULL_START_MASK		(1 << 31)
#define RDWRLVLINC_PRE_SHIFT		24
#define RDWRLVLINC_PRE_MASK		(0x7f << 24)
#define RDLVLINC_INT_SHIFT		16
#define RDLVLINC_INT_MASK		(0xff << 16)
#define RDLVLGATEINC_INT_SHIFT		8
#define RDLVLGATEINC_INT_MASK		(0xff << 8)
#define WRLVLINC_INT_SHIFT		0
#define WRLVLINC_INT_MASK		(0xff << 0)

/* DDR_PHY_CTRL_1 - EMIF4D */
#define DLL_SLAVE_DLY_CTRL_SHIFT_4D	4
#define DLL_SLAVE_DLY_CTRL_MASK_4D	(0xFF << 4)
#define READ_LATENCY_SHIFT_4D		0
#define READ_LATENCY_MASK_4D		(0xf << 0)

/* DDR_PHY_CTRL_1 - EMIF4D5 */
#define DLL_HALF_DELAY_SHIFT_4D5	21
#define DLL_HALF_DELAY_MASK_4D5		(1 << 21)
#define READ_LATENCY_SHIFT_4D5		0
#define READ_LATENCY_MASK_4D5		(0x1f << 0)


/* DDR_PHY_CTRL_1_SHDW */
#define DDR_PHY_CTRL_1_SHDW_SHIFT	5
#define DDR_PHY_CTRL_1_SHDW_MASK	(0x7ffffff << 5)
#define READ_LATENCY_SHDW_SHIFT		0
#define READ_LATENCY_SHDW_MASK		(0x1f << 0)

/* DDR_PHY_CTRL_2 */
#define DDR_PHY_CTRL_2_SHIFT		0
#define DDR_PHY_CTRL_2_MASK		(0xffffffff << 0)

/* PRIORITY_TO_CLASS_OF_SERVICE_MAPPING */
#define PRI_COS_MAP_EN_SHIFT		31
#define PRI_COS_MAP_EN_MASK		(1 << 31)
#define PRI_7_COS_SHIFT			14
#define PRI_7_COS_MASK			(0x3 << 14)
#define PRI_6_COS_SHIFT			12
#define PRI_6_COS_MASK			(0x3 << 12)
#define PRI_5_COS_SHIFT			10
#define PRI_5_COS_MASK			(0x3 << 10)
#define PRI_4_COS_SHIFT			8
#define PRI_4_COS_MASK			(0x3 << 8)
#define PRI_3_COS_SHIFT			6
#define PRI_3_COS_MASK			(0x3 << 6)
#define PRI_2_COS_SHIFT			4
#define PRI_2_COS_MASK			(0x3 << 4)
#define PRI_1_COS_SHIFT			2
#define PRI_1_COS_MASK			(0x3 << 2)
#define PRI_0_COS_SHIFT			0
#define PRI_0_COS_MASK			(0x3 << 0)

/* CONNECTION_ID_TO_CLASS_OF_SERVICE_1_MAPPING */
#define CONNID_COS_1_MAP_EN_SHIFT	31
#define CONNID_COS_1_MAP_EN_MASK	(1 << 31)
#define CONNID_1_COS_1_SHIFT		23
#define CONNID_1_COS_1_MASK		(0xff << 23)
#define MSK_1_COS_1_SHIFT		20
#define MSK_1_COS_1_MASK		(0x7 << 20)
#define CONNID_2_COS_1_SHIFT		12
#define CONNID_2_COS_1_MASK		(0xff << 12)
#define MSK_2_COS_1_SHIFT		10
#define MSK_2_COS_1_MASK		(0x3 << 10)
#define CONNID_3_COS_1_SHIFT		2
#define CONNID_3_COS_1_MASK		(0xff << 2)
#define MSK_3_COS_1_SHIFT		0
#define MSK_3_COS_1_MASK		(0x3 << 0)

/* CONNECTION_ID_TO_CLASS_OF_SERVICE_2_MAPPING */
#define CONNID_COS_2_MAP_EN_SHIFT	31
#define CONNID_COS_2_MAP_EN_MASK	(1 << 31)
#define CONNID_1_COS_2_SHIFT		23
#define CONNID_1_COS_2_MASK		(0xff << 23)
#define MSK_1_COS_2_SHIFT		20
#define MSK_1_COS_2_MASK		(0x7 << 20)
#define CONNID_2_COS_2_SHIFT		12
#define CONNID_2_COS_2_MASK		(0xff << 12)
#define MSK_2_COS_2_SHIFT		10
#define MSK_2_COS_2_MASK		(0x3 << 10)
#define CONNID_3_COS_2_SHIFT		2
#define CONNID_3_COS_2_MASK		(0xff << 2)
#define MSK_3_COS_2_SHIFT		0
#define MSK_3_COS_2_MASK		(0x3 << 0)

/* READ_WRITE_EXECUTION_THRESHOLD */
#define WR_THRSH_SHIFT			8
#define WR_THRSH_MASK			(0x1f << 8)
#define RD_THRSH_SHIFT			0
#define RD_THRSH_MASK			(0x1f << 0)

/* COS_CONFIG */
#define COS_COUNT_1_SHIFT		16
#define COS_COUNT_1_MASK		(0xff << 16)
#define COS_COUNT_2_SHIFT		8
#define COS_COUNT_2_MASK		(0xff << 8)
#define PR_OLD_COUNT_SHIFT		0
#define PR_OLD_COUNT_MASK		(0xff << 0)

/* PHY_STATUS_1 */
#define PHY_STATUS_1_SHIFT		0
#define PHY_STATUS_1_MASK		(0xffffffff << 0)

/* PHY_STATUS_2 */
#define PHY_STATUS_2_SHIFT		0
#define PHY_STATUS_2_MASK		(0xffffffff << 0)

/* PHY_STATUS_3 */
#define PHY_STATUS_3_SHIFT		0
#define PHY_STATUS_3_MASK		(0xffffffff << 0)

/* PHY_STATUS_4 */
#define PHY_STATUS_4_SHIFT		0
#define PHY_STATUS_4_MASK		(0xffffffff << 0)

/* PHY_STATUS_5 */
#define PHY_STATUS_5_SHIFT		0
#define PHY_STATUS_5_MASK		(0xffffffff << 0)

/* PHY_STATUS_6 */
#define PHY_STATUS_6_SHIFT		0
#define PHY_STATUS_6_MASK		(0xffffffff << 0)

/* PHY_STATUS_7 */
#define PHY_STATUS_7_SHIFT		0
#define PHY_STATUS_7_MASK		(0xffffffff << 0)

/* PHY_STATUS_8 */
#define PHY_STATUS_8_SHIFT		0
#define PHY_STATUS_8_MASK		(0xffffffff << 0)

/* PHY_STATUS_9 */
#define PHY_STATUS_9_SHIFT		0
#define PHY_STATUS_9_MASK		(0xffffffff << 0)

/* PHY_STATUS_10 */
#define PHY_STATUS_10_SHIFT		0
#define PHY_STATUS_10_MASK		(0xffffffff << 0)

/* PHY_STATUS_11 */
#define PHY_STATUS_11_SHIFT		0
#define PHY_STATUS_11_MASK		(0xffffffff << 0)

/* PHY_STATUS_12 */
#define PHY_STATUS_12_SHIFT		0
#define PHY_STATUS_12_MASK		(0xffffffff << 0)

/* PHY_STATUS_13 */
#define PHY_STATUS_13_SHIFT		0
#define PHY_STATUS_13_MASK		(0xffffffff << 0)

/* PHY_STATUS_14 */
#define PHY_STATUS_14_SHIFT		0
#define PHY_STATUS_14_MASK		(0xffffffff << 0)

/* PHY_STATUS_15 */
#define PHY_STATUS_15_SHIFT		0
#define PHY_STATUS_15_MASK		(0xffffffff << 0)

/* PHY_STATUS_16 */
#define PHY_STATUS_16_SHIFT		0
#define PHY_STATUS_16_MASK		(0xffffffff << 0)

/* PHY_STATUS_17 */
#define PHY_STATUS_17_SHIFT		0
#define PHY_STATUS_17_MASK		(0xffffffff << 0)

/* PHY_STATUS_18 */
#define PHY_STATUS_18_SHIFT		0
#define PHY_STATUS_18_MASK		(0xffffffff << 0)

/* PHY_STATUS_19 */
#define PHY_STATUS_19_SHIFT		0
#define PHY_STATUS_19_MASK		(0xffffffff << 0)

/* PHY_STATUS_20 */
#define PHY_STATUS_20_SHIFT		0
#define PHY_STATUS_20_MASK		(0xffffffff << 0)

/* PHY_STATUS_21 */
#define PHY_STATUS_21_SHIFT		0
#define PHY_STATUS_21_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_1 */
#define EXT_PHY_CTRL_1_SHIFT		0
#define EXT_PHY_CTRL_1_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_1_SHDW */
#define EXT_PHY_CTRL_1_SHDW_SHIFT	0
#define EXT_PHY_CTRL_1_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_2 */
#define EXT_PHY_CTRL_2_SHIFT		0
#define EXT_PHY_CTRL_2_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_2_SHDW */
#define EXT_PHY_CTRL_2_SHDW_SHIFT	0
#define EXT_PHY_CTRL_2_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_3 */
#define EXT_PHY_CTRL_3_SHIFT		0
#define EXT_PHY_CTRL_3_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_3_SHDW */
#define EXT_PHY_CTRL_3_SHDW_SHIFT	0
#define EXT_PHY_CTRL_3_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_4 */
#define EXT_PHY_CTRL_4_SHIFT		0
#define EXT_PHY_CTRL_4_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_4_SHDW */
#define EXT_PHY_CTRL_4_SHDW_SHIFT	0
#define EXT_PHY_CTRL_4_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_5 */
#define EXT_PHY_CTRL_5_SHIFT		0
#define EXT_PHY_CTRL_5_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_5_SHDW */
#define EXT_PHY_CTRL_5_SHDW_SHIFT	0
#define EXT_PHY_CTRL_5_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_6 */
#define EXT_PHY_CTRL_6_SHIFT		0
#define EXT_PHY_CTRL_6_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_6_SHDW */
#define EXT_PHY_CTRL_6_SHDW_SHIFT	0
#define EXT_PHY_CTRL_6_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_7 */
#define EXT_PHY_CTRL_7_SHIFT		0
#define EXT_PHY_CTRL_7_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_7_SHDW */
#define EXT_PHY_CTRL_7_SHDW_SHIFT	0
#define EXT_PHY_CTRL_7_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_8 */
#define EXT_PHY_CTRL_8_SHIFT		0
#define EXT_PHY_CTRL_8_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_8_SHDW */
#define EXT_PHY_CTRL_8_SHDW_SHIFT	0
#define EXT_PHY_CTRL_8_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_9 */
#define EXT_PHY_CTRL_9_SHIFT		0
#define EXT_PHY_CTRL_9_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_9_SHDW */
#define EXT_PHY_CTRL_9_SHDW_SHIFT	0
#define EXT_PHY_CTRL_9_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_10 */
#define EXT_PHY_CTRL_10_SHIFT		0
#define EXT_PHY_CTRL_10_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_10_SHDW */
#define EXT_PHY_CTRL_10_SHDW_SHIFT	0
#define EXT_PHY_CTRL_10_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_11 */
#define EXT_PHY_CTRL_11_SHIFT		0
#define EXT_PHY_CTRL_11_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_11_SHDW */
#define EXT_PHY_CTRL_11_SHDW_SHIFT	0
#define EXT_PHY_CTRL_11_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_12 */
#define EXT_PHY_CTRL_12_SHIFT		0
#define EXT_PHY_CTRL_12_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_12_SHDW */
#define EXT_PHY_CTRL_12_SHDW_SHIFT	0
#define EXT_PHY_CTRL_12_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_13 */
#define EXT_PHY_CTRL_13_SHIFT		0
#define EXT_PHY_CTRL_13_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_13_SHDW */
#define EXT_PHY_CTRL_13_SHDW_SHIFT	0
#define EXT_PHY_CTRL_13_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_14 */
#define EXT_PHY_CTRL_14_SHIFT		0
#define EXT_PHY_CTRL_14_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_14_SHDW */
#define EXT_PHY_CTRL_14_SHDW_SHIFT	0
#define EXT_PHY_CTRL_14_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_15 */
#define EXT_PHY_CTRL_15_SHIFT		0
#define EXT_PHY_CTRL_15_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_15_SHDW */
#define EXT_PHY_CTRL_15_SHDW_SHIFT	0
#define EXT_PHY_CTRL_15_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_16 */
#define EXT_PHY_CTRL_16_SHIFT		0
#define EXT_PHY_CTRL_16_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_16_SHDW */
#define EXT_PHY_CTRL_16_SHDW_SHIFT	0
#define EXT_PHY_CTRL_16_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_17 */
#define EXT_PHY_CTRL_17_SHIFT		0
#define EXT_PHY_CTRL_17_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_17_SHDW */
#define EXT_PHY_CTRL_17_SHDW_SHIFT	0
#define EXT_PHY_CTRL_17_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_18 */
#define EXT_PHY_CTRL_18_SHIFT		0
#define EXT_PHY_CTRL_18_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_18_SHDW */
#define EXT_PHY_CTRL_18_SHDW_SHIFT	0
#define EXT_PHY_CTRL_18_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_19 */
#define EXT_PHY_CTRL_19_SHIFT		0
#define EXT_PHY_CTRL_19_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_19_SHDW */
#define EXT_PHY_CTRL_19_SHDW_SHIFT	0
#define EXT_PHY_CTRL_19_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_20 */
#define EXT_PHY_CTRL_20_SHIFT		0
#define EXT_PHY_CTRL_20_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_20_SHDW */
#define EXT_PHY_CTRL_20_SHDW_SHIFT	0
#define EXT_PHY_CTRL_20_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_21 */
#define EXT_PHY_CTRL_21_SHIFT		0
#define EXT_PHY_CTRL_21_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_21_SHDW */
#define EXT_PHY_CTRL_21_SHDW_SHIFT	0
#define EXT_PHY_CTRL_21_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_22 */
#define EXT_PHY_CTRL_22_SHIFT		0
#define EXT_PHY_CTRL_22_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_22_SHDW */
#define EXT_PHY_CTRL_22_SHDW_SHIFT	0
#define EXT_PHY_CTRL_22_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_23 */
#define EXT_PHY_CTRL_23_SHIFT		0
#define EXT_PHY_CTRL_23_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_23_SHDW */
#define EXT_PHY_CTRL_23_SHDW_SHIFT	0
#define EXT_PHY_CTRL_23_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_24 */
#define EXT_PHY_CTRL_24_SHIFT		0
#define EXT_PHY_CTRL_24_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_24_SHDW */
#define EXT_PHY_CTRL_24_SHDW_SHIFT	0
#define EXT_PHY_CTRL_24_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_25 */
#define EXT_PHY_CTRL_25_SHIFT		0
#define EXT_PHY_CTRL_25_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_25_SHDW */
#define EXT_PHY_CTRL_25_SHDW_SHIFT	0
#define EXT_PHY_CTRL_25_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_26 */
#define EXT_PHY_CTRL_26_SHIFT		0
#define EXT_PHY_CTRL_26_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_26_SHDW */
#define EXT_PHY_CTRL_26_SHDW_SHIFT	0
#define EXT_PHY_CTRL_26_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_27 */
#define EXT_PHY_CTRL_27_SHIFT		0
#define EXT_PHY_CTRL_27_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_27_SHDW */
#define EXT_PHY_CTRL_27_SHDW_SHIFT	0
#define EXT_PHY_CTRL_27_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_28 */
#define EXT_PHY_CTRL_28_SHIFT		0
#define EXT_PHY_CTRL_28_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_28_SHDW */
#define EXT_PHY_CTRL_28_SHDW_SHIFT	0
#define EXT_PHY_CTRL_28_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_29 */
#define EXT_PHY_CTRL_29_SHIFT		0
#define EXT_PHY_CTRL_29_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_29_SHDW */
#define EXT_PHY_CTRL_29_SHDW_SHIFT	0
#define EXT_PHY_CTRL_29_SHDW_MASK	(0xffffffff << 0)

/* EXT_PHY_CTRL_30 */
#define EXT_PHY_CTRL_30_SHIFT		0
#define EXT_PHY_CTRL_30_MASK		(0xffffffff << 0)

/* EXT_PHY_CTRL_30_SHDW */
#define EXT_PHY_CTRL_30_SHDW_SHIFT	0
#define EXT_PHY_CTRL_30_SHDW_MASK	(0xffffffff << 0)

#endif
