/*
 * OMAP4 Clock domains framework
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Abhijit Pagare (abhijitpagare@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_CLOCKDOMAINS54XX_H
#define __ARCH_ARM_MACH_OMAP2_CLOCKDOMAINS54XX_H

#include <plat/clockdomain.h>

#if defined(CONFIG_ARCH_OMAP4)

/* Wakeup Dependencies for OMAP4 Clock Domains */

static struct clkdm_dep c2c_wkdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep cam_wkdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep dma_wkdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dss_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "ipu_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4sec_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep dsp_wkdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep dss_wkdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep gpu_wkdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep ipu_wkdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dsp_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dss_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "gpu_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4sec_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep iva_wkdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep l3init_wkdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4sec_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep l4sec_wkdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep mipiext_wkdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep mpu_wkdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dsp_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dss_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "gpu_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "ipu_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4sec_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

/* Sleep Dependencies for OMAP4 Clock Domains */

static struct clkdm_dep c2c_sleepdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep cam_sleepdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep dma_sleepdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dss_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "ipu_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4sec_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep dsp_sleepdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep dss_sleepdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep gpu_sleepdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep ipu_sleepdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dsp_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dss_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "gpu_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4sec_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep iva_sleepdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep l3init_sleepdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4sec_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep l4sec_sleepdeps[] = {
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep mipiext_sleepdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

static struct clkdm_dep mpu_sleepdeps[] = {
	{
		.clkdm_name	 = "abe_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dsp_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "dss_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "emif_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "gpu_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "ipu_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "iva_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3init_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main1_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l3main2_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4cfg_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4per_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "l4sec_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{
		.clkdm_name	 = "wkupaon_44xx_clkdm",
		.omap_chip	 = OMAP_CHIP_INIT(CHIP_IS_OMAP4430)
	},
	{ NULL },
};

/* OMAP4 Clock Domains */

static struct clockdomain l4sec_44xx_clkdm = {
	.name		  = "l4sec_clkdm",
	.pwrdm		  = { .name = "l4per_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_L4SEC_CLKSTCTRL,
	.dep_bit	  = OMAP4430_L4SEC_STATDEP_SHIFT,
	.wkdep_srcs	  = l4sec_wkdeps,
	.sleepdep_srcs	  = l4sec_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain iva_44xx_clkdm = {
	.name		  = "iva_clkdm",
	.pwrdm		  = { .name = "iva_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_IVA_CLKSTCTRL,
	.dep_bit	  = OMAP4430_IVA_STATDEP_SHIFT,
	.wkdep_srcs	  = iva_wkdeps,
	.sleepdep_srcs	  = iva_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain mipiext_44xx_clkdm = {
	.name		  = "mipiext_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_MIPIEXT_CLKSTCTRL,
	.wkdep_srcs	  = mipiext_wkdeps,
	.sleepdep_srcs	  = mipiext_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain l3main2_44xx_clkdm = {
	.name		  = "l3main2_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_L3MAIN2_CLKSTCTRL,
	.dep_bit	  = OMAP4430_L3MAIN2_STATDEP_SHIFT,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain l3main1_44xx_clkdm = {
	.name		  = "l3main1_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_L3MAIN1_CLKSTCTRL,
	.dep_bit	  = OMAP4430_L3MAIN1_STATDEP_SHIFT,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain custefuse_44xx_clkdm = {
	.name		  = "custefuse_clkdm",
	.pwrdm		  = { .name = "custefuse_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_CUSTEFUSE_CLKSTCTRL,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain ipu_44xx_clkdm = {
	.name		  = "ipu_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_IPU_CLKSTCTRL,
	.dep_bit	  = OMAP4430_IPU_STATDEP_SHIFT,
	.wkdep_srcs	  = ipu_wkdeps,
	.sleepdep_srcs	  = ipu_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain l4cfg_44xx_clkdm = {
	.name		  = "l4cfg_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_L4CFG_CLKSTCTRL,
	.dep_bit	  = OMAP4430_L4CFG_STATDEP_SHIFT,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain dss_44xx_clkdm = {
	.name		  = "dss_clkdm",
	.pwrdm		  = { .name = "dss_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_DSS_CLKSTCTRL,
	.dep_bit	  = OMAP4430_DSS_STATDEP_SHIFT,
	.wkdep_srcs	  = dss_wkdeps,
	.sleepdep_srcs	  = dss_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain dsp_44xx_clkdm = {
	.name		  = "dsp_clkdm",
	.pwrdm		  = { .name = "dsp_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_DSP_CLKSTCTRL,
	.dep_bit	  = OMAP4430_DSP_STATDEP_SHIFT,
	.wkdep_srcs	  = dsp_wkdeps,
	.sleepdep_srcs	  = dsp_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain c2c_44xx_clkdm = {
	.name		  = "c2c_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_C2C_CLKSTCTRL,
	.wkdep_srcs	  = c2c_wkdeps,
	.sleepdep_srcs	  = c2c_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain l4per_44xx_clkdm = {
	.name		  = "l4per_clkdm",
	.pwrdm		  = { .name = "l4per_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_L4PER_CLKSTCTRL,
	.dep_bit	  = OMAP4430_L4PER_STATDEP_SHIFT,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain gpu_44xx_clkdm = {
	.name		  = "gpu_clkdm",
	.pwrdm		  = { .name = "gpu_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_GPU_CLKSTCTRL,
	.dep_bit	  = OMAP4430_GPU_STATDEP_SHIFT,
	.wkdep_srcs	  = gpu_wkdeps,
	.sleepdep_srcs	  = gpu_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain wkupaon_44xx_clkdm = {
	.name		  = "wkupaon_clkdm",
	.pwrdm		  = { .name = "wkupaon_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_WKUPAON_CLKSTCTRL,
	.dep_bit	  = OMAP4430_WKUPAON_STATDEP_SHIFT,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain mpu0_44xx_clkdm = {
	.name		  = "mpu0_clkdm",
	.pwrdm		  = { .name = "cpu0_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_PDA_CPU0_CLKSTCTRL,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain mpu1_44xx_clkdm = {
	.name		  = "mpu1_clkdm",
	.pwrdm		  = { .name = "cpu1_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_PDA_CPU1_CLKSTCTRL,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain coreaon_44xx_clkdm = {
	.name		  = "coreaon_clkdm",
	.pwrdm		  = { .name = "coreaon_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_COREAON_CLKSTCTRL,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain mpu_44xx_clkdm = {
	.name		  = "mpu_clkdm",
	.pwrdm		  = { .name = "mpu_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_MPU_CLKSTCTRL,
	.wkdep_srcs	  = mpu_wkdeps,
	.sleepdep_srcs	  = mpu_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain l3init_44xx_clkdm = {
	.name		  = "l3init_clkdm",
	.pwrdm		  = { .name = "l3init_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_L3INIT_CLKSTCTRL,
	.dep_bit	  = OMAP4430_L3INIT_STATDEP_SHIFT,
	.wkdep_srcs	  = l3init_wkdeps,
	.sleepdep_srcs	  = l3init_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain dma_44xx_clkdm = {
	.name		  = "dma_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_DMA_CLKSTCTRL,
	.wkdep_srcs	  = dma_wkdeps,
	.sleepdep_srcs	  = dma_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain l3instr_44xx_clkdm = {
	.name		  = "l3instr_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_L3INSTR_CLKSTCTRL,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain emif_44xx_clkdm = {
	.name		  = "emif_clkdm",
	.pwrdm		  = { .name = "core_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_EMIF_CLKSTCTRL,
	.dep_bit	  = OMAP4430_EMIF_STATDEP_SHIFT,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_FORCE_WAKEUP | CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain emu_44xx_clkdm = {
	.name		  = "emu_clkdm",
	.pwrdm		  = { .name = "emu_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_EMU_CLKSTCTRL,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct clockdomain cam_44xx_clkdm = {
	.name		  = "cam_clkdm",
	.pwrdm		  = { .name = "cam_pwrdm" },
	.clkstctrl_reg	  = OMAP4430_CM_CAM_CLKSTCTRL,
	.wkdep_srcs	  = cam_wkdeps,
	.sleepdep_srcs	  = cam_sleepdeps,
	.clktrctrl_mask	  = OMAP4430_CLKTRCTRL_MASK,
	.flags		  = CLKDM_CAN_HWSUP_SWSUP,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

#endif

#endif
