/* Editor Settings: expandtabs and use 4 spaces for indentation
 * ex: set softtabstop=4 tabstop=8 expandtab shiftwidth=4: *
 */

/*
 *
 *   NT status and Win32 error code mapping table
 *
 *   Some of these definitions were written from scratch.
 *
 *   NT status codes are unsigned 32-bit hex values
 *
 *   Win32 error codes are unsigned 32-bit decimal values
 */

/* Win32 codes*/
#ifdef __ERROR_WIN32__

#include <lw/winerror.h>

#endif

/* Equivalence table*/
#ifdef __ERROR_XMACRO__
#define S STATUS_CODE

// List of lw extended errors
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_CACHE_PATH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_CONFIG_PATH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_PREFIX_PATH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INSUFFICIENT_BUFFER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_OUT_OF_MEMORY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_MESSAGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNEXPECTED_MESSAGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_USER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DATA_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NOT_IMPLEMENTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_CONTEXT_ITEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_REGEX_COMPILE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NSS_EDIT_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_HANDLER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INTERNAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NOT_HANDLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_DNS_RESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DNS_RESOLUTION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_FAILED_TIME_CONVERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_SID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_PASSWORD_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNEXPECTED_DB_RESULT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_PASSWORD_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ACCOUNT_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_USER_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_GROUP_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_GROUP_INFO_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_USER_INFO_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNSUPPORTED_USER_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNSUPPORTED_GROUP_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_LOGIN_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_HOMEDIR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_GROUP_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_MORE_GROUPS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_MORE_USERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_FAILED_ADD_USER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_FAILED_ADD_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_LSA_CONNECTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_AUTH_PROVIDER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_PARAMETER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NO_PARENT_DN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_DOMAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_FAILED_GETDN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DUPLICATE_DOMAINNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CALL_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_GSS_CALL_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_FAILED_FIND_DC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_CELL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_GROUP_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_FAILED_CREATE_HOMEDIR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_PASSWORD_TOO_WEAK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_SID_REVISION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ACCOUNT_LOCKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ACCOUNT_DISABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_USER_CANNOT_CHANGE_PASSWD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LOAD_LIBRARY_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LOOKUP_SYMBOL_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_EVENTLOG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_CONFIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNEXPECTED_TOKEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NO_RECORDS_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DUPLICATE_USERNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DUPLICATE_GROUPNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DUPLICATE_CELLNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_STRING_CONV_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_ACCOUNT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_PASSWORD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_QUERY_CREATION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DUPLICATE_USER_OR_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_KRB5_CACHE_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NOT_JOINED_TO_AD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_FAILED_TO_SET_TIME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_NETBIOS_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_NETLOGON_RESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_OBJECTGUID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_DOMAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_DEFAULT_REALM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LOGON_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SITE_INFORMATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_LDAP_STRING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_LDAP_ATTR_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NULL_BUFFER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_CLOCK_SKEW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_NO_KEYS_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_SERVICE_NOT_AVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_SERVICE_RESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NSS_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_AUTH_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_LDAP_DN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NOT_MAPPED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_NETLOGON_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ENUM_DOMAIN_TRUSTS_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_LSABINDING_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_OPENPOLICY_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_LSA_LOOKUPNAME2_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_SET_SESS_CREDS_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_REL_SESS_CREDS_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_CLOSEPOLICY_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_LSA_LOOKUPNAME2_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_LSA_LOOKUPNAME2_FOUND_DUPLICATES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_TRUSTED_DOMAIN_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INCOMPATIBLE_MODES_BETWEEN_TRUSTEDDOMAINS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DCE_CALL_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_FAILED_TO_LOOKUP_DC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_NSS_ARTEFACT_INFO_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNSUPPORTED_NSS_ARTEFACT_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_USER_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_LOG_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_METRIC_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_METRIC_PACK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_METRIC_INFO_LEVEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_FAILED_STARTUP_PREREQUISITE_CHECK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_MAC_FLUSH_DS_CACHE_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LSA_SERVER_UNREACHABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_NSS_ARTEFACT_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_AGENT_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DOMAIN_IS_OFFLINE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_HOMEDIR_TEMPLATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_PARSE_SID_STRING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_LSA_LOOKUPSIDS_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_LSA_LOOKUPSIDS_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_LSA_LOOKUPSIDS_FOUND_DUPLICATES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_PASSWORD_RESTRICTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_OBJECT_NOT_ENABLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_MORE_NSS_ARTEFACTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_NSS_MAP_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_NSS_KEY_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_NSS_KEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_NSS_MAP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_SERVER_UNAVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_CREATE_KEY_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_CANNOT_DETECT_USER_PROCESSES, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_TRACE_NOT_INITIALIZED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_TRACE_FLAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DCERPC_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_RPC_SERVER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_SERVER_REGISTRATION_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_RPC_SERVER_RUNTIME_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DOMAIN_IN_USE, -1, "" )
S ( LW_STATUS_INTERNAL_ERROR,    LW_ERROR_SAM_DATABASE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_SAM_INIT_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_OBJECT_IN_USE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_ATTRIBUTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_GET_DC_NAME_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_ATTRIBUTE_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_ATTRIBUTE_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_MEMBER_IN_LOCAL_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_MEMBER_NOT_IN_LOCAL_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_S_PRINCIPAL_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_GROUP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_WARNING_CONTINUE_NEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ACCESS_DENIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_PROCESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INTERRUPTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_GENERIC_IO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENXIO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_E2BIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOEXEC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ECHILD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EAGAIN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EFAULT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOTBLK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EBUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EEXIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EXDEV, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENODEV, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOTDIR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EISDIR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EMFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOTTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ETXTBSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EFBIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOSPC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ESPIPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EROFS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EMLINK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EPIPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EDOM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ERANGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENAMETOOLONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOLCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOTEMPTY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ELOOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOMSG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EIDRM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ECHRNG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EL2NSYNC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EL3HLT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EL3RST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ELNRNG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EUNATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOCSI, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EL2HLT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EBADE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EBADR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EXFULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOANO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EBADRQC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EBADSLT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EDEADLOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EBFONT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOSTR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENODATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ETIME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOSR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENONET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOPKG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EREMOTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOLINK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EADV, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ESRMNT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ECOMM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EPROTO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EMULTIHOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EDOTDOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EBADMSG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EOVERFLOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOTUNIQ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EBADFD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EREMCHG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ELIBACC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ELIBBAD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ELIBSCN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ELIBMAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ELIBEXEC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EILSEQ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ERESTART, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ESTRPIPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EUSERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOTSOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EDESTADDRREQ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EMSGSIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EPROTOTYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOPROTOOPT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EPROTONOSUPPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ESOCKTNOSUPPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EOPNOTSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EPFNOSUPPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EAFNOSUPPORT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EADDRINUSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EADDRNOTAVAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENETDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENETUNREACH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENETRESET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ECONNABORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ECONNRESET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOBUFS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EISCONN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOTCONN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ESHUTDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ETOOMANYREFS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ETIMEDOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ECONNREFUSED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EHOSTDOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EHOSTUNREACH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EALREADY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EINPROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ESTALE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EUCLEAN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOTNAM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENAVAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EISNAM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EREMOTEIO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EDQUOT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ENOMEDIUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_EMEDIUMTYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_ERRNO_ECANCELED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_SERVER_DOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_LOCAL_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_ENCODING_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_DECODING_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_TIMEOUT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_AUTH_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_FILTER_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_USER_CANCELLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_PARAM_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NO_MEMORY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CONNECT_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CONTROL_NOT_FOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NO_RESULTS_RETURNED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_MORE_RESULTS_TO_RETURN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CLIENT_LOOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_REFERRAL_LIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_OPERATIONS_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_PROTOCOL_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_TIMELIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_SIZELIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_COMPARE_FALSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_COMPARE_TRUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_STRONG_AUTH_NOT_SUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_STRONG_AUTH_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_PARTIAL_RESULTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NO_SUCH_ATTRIBUTE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_UNDEFINED_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_INAPPROPRIATE_MATCHING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CONSTRAINT_VIOLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_TYPE_OR_VALUE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NO_SUCH_OBJECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_ALIAS_PROBLEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_INVALID_DN_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_IS_LEAF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_ALIAS_DEREF_PROBLEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_REFERRAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_ADMINLIMIT_EXCEEDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_UNAVAILABLE_CRITICAL_EXTENSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CONFIDENTIALITY_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_SASL_BIND_IN_PROGRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_X_PROXY_AUTHZ_FAILURE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_INAPPROPRIATE_AUTH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_INVALID_CREDENTIALS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_INSUFFICIENT_ACCESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_BUSY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_UNAVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_UNWILLING_TO_PERFORM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_LOOP_DETECT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NAMING_VIOLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_OBJECT_CLASS_VIOLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NOT_ALLOWED_ON_NONLEAF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NOT_ALLOWED_ON_RDN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_ALREADY_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NO_OBJECT_CLASS_MODS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_RESULTS_TOO_LARGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_AFFECTS_MULTIPLE_DSAS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CUP_RESOURCES_EXHAUSTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CUP_SECURITY_VIOLATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CUP_INVALID_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CUP_UNSUPPORTED_SCHEME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CUP_RELOAD_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CANCELLED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_NO_SUCH_OPERATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_TOO_LATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_CANNOT_CANCEL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_ASSERTION_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_LDAP_INVALID_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_BAD_MECH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_BAD_NAMETYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_BAD_NAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_CREDENTIAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_CRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_TOKEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNSUPPORTED_SUBPROTO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_UNSUPPORTED_CRYPTO_OP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_TEST_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_CSV_BAD_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_CSV_NO_SUCH_FIELD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_INVALID_SERVICE_TRANSITION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_SERVICE_DEPENDENCY_UNMET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_SERVICE_UNRESPONSIVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_NO_SUCH_SERVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_DEPENDENT_SERVICE_STILL_RUNNING, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_BAD_TIMEFORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_MISSING_FIELD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_MISPLACED_FIELD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_TYPE_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_OVERFLOW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_OVERRUN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_BAD_ID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_BAD_LENGTH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_BAD_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_PARSE_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_BAD_GMTIME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_MISMATCH_INDEF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ASN1_MISSING_EOC, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB524_KRB4_DISABLED, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_NONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_NAME_EXP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_SERVICE_EXP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_BAD_PVNO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_C_OLD_MAST_KVNO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_S_OLD_MAST_KVNO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_PRINCIPAL_NOT_UNIQUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_NULL_KEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_CANNOT_POSTDATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_POLICY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_BADOPTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_ETYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_SUMTYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_PADATA_TYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_TRTYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_SERVICE_REVOKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_TGT_REVOKED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_CLIENT_NOTYET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_SERVICE_NOTYET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_PREAUTH_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_SERVER_NOMATCH, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_SVC_UNAVAILABLE, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_BAD_INTEGRITY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_TKT_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_TKT_NYV, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_REPEAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_NOT_US, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_BADMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_BADADDR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_BADVERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_MSG_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_MODIFIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_BADORDER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_ILL_CR_TKT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_BADKEYVER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_NOKEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_MUT_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_BADDIRECTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_METHOD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_BADSEQ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_INAPP_CKSUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_PATH_NOT_ACCEPTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_ERR_RESPONSE_TOO_BIG, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_ERR_GENERIC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_ERR_FIELD_TOOLONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_CLIENT_NOT_TRUSTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_KDC_NOT_TRUSTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_INVALID_SIG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_DH_KEY_PARAMETERS_NOT_ACCEPTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_CERTIFICATE_MISMATCH, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_CANT_VERIFY_CERTIFICATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_INVALID_CERTIFICATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_REVOKED_CERTIFICATE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_REVOCATION_STATUS_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_REVOCATION_STATUS_UNAVAILABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_CLIENT_NAME_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_KDC_NAME_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_INCONSISTENT_KEY_PURPOSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_DIGEST_IN_CERT_NOT_ACCEPTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_PA_CHECKSUM_MUST_BE_INCLUDED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_DIGEST_IN_SIGNED_DATA_NOT_ACCEPTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KDC_ERR_PUBLIC_KEY_ENCRYPTION_NOT_SUPPORTED, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ERR_RCSID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_LIBOS_BADLOCKFLAG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_LIBOS_CANTREADPWD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_LIBOS_PWDINTR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PARSE_ILLCHAR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PARSE_MALFORMED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CONFIG_CANTOPEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CONFIG_BADFORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CONFIG_NOTENUFSPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_BADMSGTYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_BADNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_UNKNOWN_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_NOTFOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_END, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_NO_TKT_SUPPLIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_WRONG_PRINC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_TKT_INVALID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PRINC_NOMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KDCREP_MODIFIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KDCREP_SKEW, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_IN_TKT_REALM_MISMATCH, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROG_ETYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROG_KEYTYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_WRONG_ETYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROG_SUMTYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_REALM_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SERVICE_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_NO_LOCALNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_MUTUAL_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_TYPE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_MALLOC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_TYPE_NOTFOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_REPLAY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_IO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_NOIO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_PARSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_IO_EOF, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_IO_MALLOC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_IO_PERM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_IO_IO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_IO_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_IO_SPACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_TRANS_CANTOPEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_TRANS_BADFORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_LNAME_CANTOPEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_LNAME_NOTRANS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_LNAME_BADFORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CRYPTO_INTERNAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_BADNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_UNKNOWN_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_NOTFOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_END, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_NOWRITE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_IOERR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_NO_TKT_IN_RLM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5DES_BAD_KEYPAR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5DES_WEAK_KEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_BAD_ENCTYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_BAD_KEYSIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_BAD_MSIZE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_TYPE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_TYPE_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_IO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_FCC_PERM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_FCC_NOFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_FCC_INTERNAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_WRITE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_NOMEM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_NOT_KTYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_INVALID_FLAGS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_NO_2ND_TKT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_NOCREDS_SUPPLIED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SENDAUTH_BADAUTHVERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SENDAUTH_BADAPPLVERS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SENDAUTH_BADRESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SENDAUTH_REJECTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PREAUTH_BAD_TYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PREAUTH_NO_KEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PREAUTH_FAILED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RCACHE_BADVNO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CCACHE_BADVNO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KEYTAB_BADVNO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROG_ATYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_RC_REQUIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ERR_BAD_HOSTNAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ERR_HOST_REALM_UNKNOWN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SNAME_UNSUPP_NAMETYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5KRB_AP_ERR_V4_REPLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_REALM_CANT_RESOLVE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_TKT_NOT_FORWARDABLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_FWD_BAD_PRINCIPAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_GET_IN_TKT_LOOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CONFIG_NODEFREALM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SAM_UNSUPPORTED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SAM_INVALID_ETYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SAM_NO_CHECKSUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_SAM_BAD_CHECKSUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_NAME_TOOLONG, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_KVNONOTFOUND, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_APPL_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_LIB_EXPIRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CHPW_PWDNULL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CHPW_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KT_FORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_NOPERM_ETYPE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CONFIG_ETYPE_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_OBSOLETE_FN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_EAI_FAIL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_EAI_NODATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_EAI_NONAME, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_EAI_SERVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ERR_NUMERIC_REALM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ERR_BAD_S2K_PARAMS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_ERR_NO_SERVICE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_READONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_CC_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_DELTAT_BADFORMAT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PLUGIN_NO_HANDLE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PLUGIN_OP_NOTSUPP, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_NONE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_PRINCIPAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_KEYBLOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CHECKSUM, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ENCRYPT_BLOCK, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ENC_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CRYPTOSYSTEM_ENTRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CS_TABLE_ENTRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CHECKSUM_ENTRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_AUTHDATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_TRANSITED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ENC_TKT_PART, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_TICKET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_AUTHENTICATOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_TKT_AUTHENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CREDS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_LAST_REQ_ENTRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_PA_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_KDC_REQ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ENC_KDC_REP_PART, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_KDC_REP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ERROR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_AP_REQ, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_AP_REP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_AP_REP_ENC_PART, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_RESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_SAFE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_PRIV, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_PRIV_ENC_PART, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CRED, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CRED_INFO, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CRED_ENC_PART, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_PWD_DATA, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ADDRESS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_KEYTAB_ENTRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_OS_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ALT_METHOD, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ETYPE_INFO_ENTRY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_DB_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_AUTH_CONTEXT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_KEYTAB, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_RCACHE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_CCACHE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_PREAUTH_OPS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_SAM_CHALLENGE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_SAM_CHALLENGE_2, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_SAM_KEY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ENC_SAM_RESPONSE_ENC, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_ENC_SAM_RESPONSE_ENC_2, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_SAM_RESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_SAM_RESPONSE_2, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_PREDICTED_SAM_RESPONSE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_PASSWD_PHRASE_ELEMENT, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_GSS_OID, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_KV5M_GSS_QUEUE, -1, "" )

S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_VERSION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_MAGIC_NODE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_NO_SECTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_NO_RELATION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_ADD_NOT_SECTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_SECTION_WITH_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_BAD_LINK_LIST, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_BAD_GROUP_LVL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_BAD_PARENT_PTR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_MAGIC_ITERATOR, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_SET_SECTION_VALUE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_EINVAL, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_READ_ONLY, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_SECTION_NOTOP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_SECTION_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_RELATION_SYNTAX, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_EXTRA_CBRACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_MISSING_OBRACE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_MAGIC_PROFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_MAGIC_SECTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_TOPSECTION_ITER_NOSUPP, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_INVALID_SECTION, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_END_OF_SECTIONS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_BAD_NAMESET, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_NO_PROFILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_MAGIC_FILE, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_FAIL_OPEN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_EXISTS, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_BAD_BOOLEAN, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_BAD_INTEGER, -1, "" )
S ( LW_STATUS_MESSAGE_NOT_FOUND, LW_ERROR_KRB5_PROF_MAGIC_FILE_DATA, -1, "" )

#undef S
#endif


/*
local variables:
mode: c
c-basic-offset: 4
indent-tabs-mode: nil
tab-width: 4
end:
*/
