/* Editor Settings: expandtabs and use 4 spaces for indentation
 * ex: set softtabstop=4 tabstop=8 expandtab shiftwidth=4: *
 * -*- mode: c, c-basic-offset: 4 -*- */

/*
 * Copyright Likewise Software    2004-2008
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewisesoftware.com
 */

/*
 * Copyright (C) Likewise Software. All rights reserved.
 *
 * Module Name:
 *
 *        nss-user.h
 *
 * Abstract:
 *
 *        Name Server Switch (Likewise LSASS)
 *
 *        Handle NSS User Information
 *
 * Authors: Krishna Ganugapati (krishnag@likewisesoftware.com)
 *          Sriram Nambakam (snambakam@likewisesoftware.com)
 *
 */

#ifndef __LSANSSUSER_H__
#define __LSANSSUSER_H__

NSS_STATUS
_nss_lsass_setpwent(
    void
    );

NSS_STATUS
_nss_lsass_getpwent_r(
    struct passwd * pUser,
    char *          pszBuf,
    size_t          bufLen,
    int*            pErrorNumber
    );

NSS_STATUS
_nss_lsass_endpwent(
    void
    );

NSS_STATUS
_nss_lsass_getpwnam_r(
    const char *    pszName,
    struct passwd * pUser,
    char *          pszBuf,
    size_t          bufLen,
    int*            pErrorNumber
    );

NSS_STATUS
_nss_lsass_getpwuid_r(
    uid_t           uid,
    struct passwd*  pUser,
    char *          pszBuf,
    size_t          bufLen,
    int*            pErrorNumber
    );


DWORD
_nss_lsass_get_principal(
    PCSTR pszUserName,
    PSTR* ppszPrincipalName
    );

VOID
_nss_lsass_free_principal(
    PSTR pszPrincipalName
    );

DWORD
_nss_lsass_get_user_groups(
    PCSTR    pszUserName,
    gid_t ** ppGroups,
    int *    pNumberOfGroups
    );

VOID
_nss_lsass_free_user_groups(
    gid_t * pGroups
    );

#endif /* __LSANSSUSER_H__ */

