/* header auto-generated by pidl */

#include <stdint.h>

#include "librpc/gen_ndr/security.h"
#ifndef _HEADER_lsarpc
#define _HEADER_lsarpc

#define LSA_ENUM_TRUST_DOMAIN_MULTIPLIER	( 60 )
#define LSA_REF_DOMAIN_LIST_MULTIPLIER	( 32 )
#define LSA_ENUM_TRUST_DOMAIN_EX_MULTIPLIER	( 82 )
struct lsa_String {
	uint16_t length;/* [value(2*strlen_m(string))] */
	uint16_t size;/* [value(2*strlen_m(string))] */
	const char *string;/* [unique,charset(UTF16),length_is(length/2),size_is(size/2)] */
}/* [public,noejs] */;

struct lsa_StringLarge {
	uint16_t length;/* [value(2*strlen_m(string))] */
	uint16_t size;/* [value(2*(strlen_m(string)+1))] */
	const char *string;/* [unique,charset(UTF16),length_is(length/2),size_is(size/2)] */
}/* [public] */;

struct lsa_Strings {
	uint32_t count;
	struct lsa_String *names;/* [unique,size_is(count)] */
}/* [public] */;

struct lsa_AsciiString {
	uint16_t length;/* [value(strlen_m(string))] */
	uint16_t size;/* [value(strlen_m(string))] */
	const char * string;/* [unique,flag(LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_LEN4)] */
}/* [public] */;

struct lsa_LUID {
	uint32_t low;
	uint32_t high;
};

struct lsa_PrivEntry {
	struct lsa_StringLarge name;
	struct lsa_LUID luid;
};

struct lsa_PrivArray {
	uint32_t count;
	struct lsa_PrivEntry *privs;/* [unique,size_is(count)] */
};

struct lsa_QosInfo {
	uint32_t len;
	uint16_t impersonation_level;
	uint8_t context_mode;
	uint8_t effective_only;
};

struct lsa_ObjectAttribute {
	uint32_t len;
	uint8_t *root_dir;/* [unique] */
	const char *object_name;/* [unique,charset(UTF16)] */
	uint32_t attributes;
	struct security_descriptor *sec_desc;/* [unique] */
	struct lsa_QosInfo *sec_qos;/* [unique] */
};

struct lsa_AuditLogInfo {
	uint32_t percent_full;
	uint32_t log_size;
	NTTIME retention_time;
	uint8_t shutdown_in_progress;
	NTTIME time_to_shutdown;
	uint32_t next_audit_record;
	uint32_t unknown;
};

enum lsa_PolicyAuditPolicy
#ifndef USE_UINT_ENUMS
 {
	LSA_AUDIT_POLICY_NONE=0,
	LSA_AUDIT_POLICY_SUCCESS=1,
	LSA_AUDIT_POLICY_FAILURE=2,
	LSA_AUDIT_POLICY_ALL=(LSA_AUDIT_POLICY_SUCCESS|LSA_AUDIT_POLICY_FAILURE),
	LSA_AUDIT_POLICY_CLEAR=4
}
#else
 { __donnot_use_enum_lsa_PolicyAuditPolicy=0x7FFFFFFF}
#define LSA_AUDIT_POLICY_NONE ( 0 )
#define LSA_AUDIT_POLICY_SUCCESS ( 1 )
#define LSA_AUDIT_POLICY_FAILURE ( 2 )
#define LSA_AUDIT_POLICY_ALL ( (LSA_AUDIT_POLICY_SUCCESS|LSA_AUDIT_POLICY_FAILURE) )
#define LSA_AUDIT_POLICY_CLEAR ( 4 )
#endif
;

enum lsa_PolicyAuditEventType
#ifndef USE_UINT_ENUMS
 {
	LSA_AUDIT_CATEGORY_SYSTEM=0,
	LSA_AUDIT_CATEGORY_LOGON=1,
	LSA_AUDIT_CATEGORY_FILE_AND_OBJECT_ACCESS=2,
	LSA_AUDIT_CATEGORY_USE_OF_USER_RIGHTS=3,
	LSA_AUDIT_CATEGORY_PROCCESS_TRACKING=4,
	LSA_AUDIT_CATEGORY_SECURITY_POLICY_CHANGES=5,
	LSA_AUDIT_CATEGORY_ACCOUNT_MANAGEMENT=6,
	LSA_AUDIT_CATEGORY_DIRECTORY_SERVICE_ACCESS=7,
	LSA_AUDIT_CATEGORY_ACCOUNT_LOGON=8
}
#else
 { __donnot_use_enum_lsa_PolicyAuditEventType=0x7FFFFFFF}
#define LSA_AUDIT_CATEGORY_SYSTEM ( 0 )
#define LSA_AUDIT_CATEGORY_LOGON ( 1 )
#define LSA_AUDIT_CATEGORY_FILE_AND_OBJECT_ACCESS ( 2 )
#define LSA_AUDIT_CATEGORY_USE_OF_USER_RIGHTS ( 3 )
#define LSA_AUDIT_CATEGORY_PROCCESS_TRACKING ( 4 )
#define LSA_AUDIT_CATEGORY_SECURITY_POLICY_CHANGES ( 5 )
#define LSA_AUDIT_CATEGORY_ACCOUNT_MANAGEMENT ( 6 )
#define LSA_AUDIT_CATEGORY_DIRECTORY_SERVICE_ACCESS ( 7 )
#define LSA_AUDIT_CATEGORY_ACCOUNT_LOGON ( 8 )
#endif
;

struct lsa_AuditEventsInfo {
	uint32_t auditing_mode;
	enum lsa_PolicyAuditPolicy *settings;/* [unique,size_is(count)] */
	uint32_t count;
};

struct lsa_DomainInfo {
	struct lsa_StringLarge name;
	struct dom_sid2 *sid;/* [unique] */
};

struct lsa_PDAccountInfo {
	struct lsa_String name;
};

struct lsa_ServerRole {
	uint16_t unknown;
	uint16_t role;
};

struct lsa_ReplicaSourceInfo {
	struct lsa_String source;
	struct lsa_String account;
};

struct lsa_DefaultQuotaInfo {
	uint32_t paged_pool;
	uint32_t non_paged_pool;
	uint32_t min_wss;
	uint32_t max_wss;
	uint32_t pagefile;
	uint64_t unknown;
};

struct lsa_ModificationInfo {
	uint64_t modified_id;
	NTTIME db_create_time;
};

struct lsa_AuditFullSetInfo {
	uint8_t shutdown_on_full;
};

struct lsa_AuditFullQueryInfo {
	uint16_t unknown;
	uint8_t shutdown_on_full;
	uint8_t log_is_full;
};

struct lsa_DnsDomainInfo {
	struct lsa_StringLarge name;
	struct lsa_StringLarge dns_domain;
	struct lsa_StringLarge dns_forest;
	struct GUID domain_guid;
	struct dom_sid2 *sid;/* [unique] */
};

enum lsa_PolicyInfo
#ifndef USE_UINT_ENUMS
 {
	LSA_POLICY_INFO_AUDIT_LOG=1,
	LSA_POLICY_INFO_AUDIT_EVENTS=2,
	LSA_POLICY_INFO_DOMAIN=3,
	LSA_POLICY_INFO_PD=4,
	LSA_POLICY_INFO_ACCOUNT_DOMAIN=5,
	LSA_POLICY_INFO_ROLE=6,
	LSA_POLICY_INFO_REPLICA=7,
	LSA_POLICY_INFO_QUOTA=8,
	LSA_POLICY_INFO_DB=9,
	LSA_POLICY_INFO_AUDIT_FULL_SET=10,
	LSA_POLICY_INFO_AUDIT_FULL_QUERY=11,
	LSA_POLICY_INFO_DNS=12
}
#else
 { __donnot_use_enum_lsa_PolicyInfo=0x7FFFFFFF}
#define LSA_POLICY_INFO_AUDIT_LOG ( 1 )
#define LSA_POLICY_INFO_AUDIT_EVENTS ( 2 )
#define LSA_POLICY_INFO_DOMAIN ( 3 )
#define LSA_POLICY_INFO_PD ( 4 )
#define LSA_POLICY_INFO_ACCOUNT_DOMAIN ( 5 )
#define LSA_POLICY_INFO_ROLE ( 6 )
#define LSA_POLICY_INFO_REPLICA ( 7 )
#define LSA_POLICY_INFO_QUOTA ( 8 )
#define LSA_POLICY_INFO_DB ( 9 )
#define LSA_POLICY_INFO_AUDIT_FULL_SET ( 10 )
#define LSA_POLICY_INFO_AUDIT_FULL_QUERY ( 11 )
#define LSA_POLICY_INFO_DNS ( 12 )
#endif
;

union lsa_PolicyInformation {
	struct lsa_AuditLogInfo audit_log;/* [case(LSA_POLICY_INFO_AUDIT_LOG)] */
	struct lsa_AuditEventsInfo audit_events;/* [case(LSA_POLICY_INFO_AUDIT_EVENTS)] */
	struct lsa_DomainInfo domain;/* [case(LSA_POLICY_INFO_DOMAIN)] */
	struct lsa_PDAccountInfo pd;/* [case(LSA_POLICY_INFO_PD)] */
	struct lsa_DomainInfo account_domain;/* [case(LSA_POLICY_INFO_ACCOUNT_DOMAIN)] */
	struct lsa_ServerRole role;/* [case(LSA_POLICY_INFO_ROLE)] */
	struct lsa_ReplicaSourceInfo replica;/* [case(LSA_POLICY_INFO_REPLICA)] */
	struct lsa_DefaultQuotaInfo quota;/* [case(LSA_POLICY_INFO_QUOTA)] */
	struct lsa_ModificationInfo db;/* [case(LSA_POLICY_INFO_DB)] */
	struct lsa_AuditFullSetInfo auditfullset;/* [case(LSA_POLICY_INFO_AUDIT_FULL_SET)] */
	struct lsa_AuditFullQueryInfo auditfullquery;/* [case(LSA_POLICY_INFO_AUDIT_FULL_QUERY)] */
	struct lsa_DnsDomainInfo dns;/* [case(LSA_POLICY_INFO_DNS)] */
}/* [switch_type(uint16)] */;

struct lsa_SidPtr {
	struct dom_sid2 *sid;/* [unique] */
};

struct lsa_SidArray {
	uint32_t num_sids;/* [range(0,1000)] */
	struct lsa_SidPtr *sids;/* [unique,size_is(num_sids)] */
}/* [public] */;

struct lsa_DomainList {
	uint32_t count;
	struct lsa_DomainInfo *domains;/* [unique,size_is(count)] */
};

enum lsa_SidType
#ifndef USE_UINT_ENUMS
 {
	SID_NAME_USE_NONE=0,
	SID_NAME_USER=1,
	SID_NAME_DOM_GRP=2,
	SID_NAME_DOMAIN=3,
	SID_NAME_ALIAS=4,
	SID_NAME_WKN_GRP=5,
	SID_NAME_DELETED=6,
	SID_NAME_INVALID=7,
	SID_NAME_UNKNOWN=8,
	SID_NAME_COMPUTER=9
}
#else
 { __donnot_use_enum_lsa_SidType=0x7FFFFFFF}
#define SID_NAME_USE_NONE ( 0 )
#define SID_NAME_USER ( 1 )
#define SID_NAME_DOM_GRP ( 2 )
#define SID_NAME_DOMAIN ( 3 )
#define SID_NAME_ALIAS ( 4 )
#define SID_NAME_WKN_GRP ( 5 )
#define SID_NAME_DELETED ( 6 )
#define SID_NAME_INVALID ( 7 )
#define SID_NAME_UNKNOWN ( 8 )
#define SID_NAME_COMPUTER ( 9 )
#endif
;

struct lsa_TranslatedSid {
	enum lsa_SidType sid_type;
	uint32_t rid;
	uint32_t sid_index;
};

struct lsa_TransSidArray {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedSid *sids;/* [unique,size_is(count)] */
};

struct lsa_RefDomainList {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_DomainInfo *domains;/* [unique,size_is(count)] */
	uint32_t max_size;
};

enum lsa_LookupNamesLevel
#ifndef USE_UINT_ENUMS
 {
	LSA_LOOKUP_NAMES_ALL=1,
	LSA_LOOKUP_NAMES_DOMAINS_ONLY=2,
	LSA_LOOKUP_NAMES_PRIMARY_DOMAIN_ONLY=3,
	LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY=4,
	LSA_LOOKUP_NAMES_FOREST_TRUSTS_ONLY=5,
	LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY2=6
}
#else
 { __donnot_use_enum_lsa_LookupNamesLevel=0x7FFFFFFF}
#define LSA_LOOKUP_NAMES_ALL ( 1 )
#define LSA_LOOKUP_NAMES_DOMAINS_ONLY ( 2 )
#define LSA_LOOKUP_NAMES_PRIMARY_DOMAIN_ONLY ( 3 )
#define LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY ( 4 )
#define LSA_LOOKUP_NAMES_FOREST_TRUSTS_ONLY ( 5 )
#define LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY2 ( 6 )
#endif
;

struct lsa_TranslatedName {
	enum lsa_SidType sid_type;
	struct lsa_String name;
	uint32_t sid_index;
};

struct lsa_TransNameArray {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedName *names;/* [unique,size_is(count)] */
};

struct lsa_LUIDAttribute {
	struct lsa_LUID luid;
	uint32_t attribute;
};

struct lsa_PrivilegeSet {
	uint32_t count;/* [range(0,1000)] */
	uint32_t unknown;
	struct lsa_LUIDAttribute *set;/* [size_is(count)] */
};

struct lsa_DATA_BUF {
	uint32_t length;
	uint32_t size;
	uint8_t *data;/* [unique,length_is(length),size_is(size)] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct lsa_DATA_BUF2 {
	uint32_t size;/* [range(0,65536)] */
	uint8_t *data;/* [unique,size_is(size)] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

enum lsa_TrustDomInfoEnum
#ifndef USE_UINT_ENUMS
 {
	LSA_TRUSTED_DOMAIN_INFO_NAME=1,
	LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS_INFO=2,
	LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET=3,
	LSA_TRUSTED_DOMAIN_INFO_PASSWORD=4,
	LSA_TRUSTED_DOMAIN_INFO_BASIC=5,
	LSA_TRUSTED_DOMAIN_INFO_INFO_EX=6,
	LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO=7,
	LSA_TRUSTED_DOMAIN_INFO_FULL_INFO=8,
	LSA_TRUSTED_DOMAIN_INFO_11=11,
	LSA_TRUSTED_DOMAIN_INFO_INFO_ALL=12
}
#else
 { __donnot_use_enum_lsa_TrustDomInfoEnum=0x7FFFFFFF}
#define LSA_TRUSTED_DOMAIN_INFO_NAME ( 1 )
#define LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS_INFO ( 2 )
#define LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET ( 3 )
#define LSA_TRUSTED_DOMAIN_INFO_PASSWORD ( 4 )
#define LSA_TRUSTED_DOMAIN_INFO_BASIC ( 5 )
#define LSA_TRUSTED_DOMAIN_INFO_INFO_EX ( 6 )
#define LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO ( 7 )
#define LSA_TRUSTED_DOMAIN_INFO_FULL_INFO ( 8 )
#define LSA_TRUSTED_DOMAIN_INFO_11 ( 11 )
#define LSA_TRUSTED_DOMAIN_INFO_INFO_ALL ( 12 )
#endif
;

struct lsa_TrustDomainInfoName {
	struct lsa_StringLarge netbios_name;
};

struct lsa_TrustDomainInfoPosixOffset {
	uint32_t posix_offset;
};

struct lsa_TrustDomainInfoPassword {
	struct lsa_DATA_BUF *password;/* [unique] */
	struct lsa_DATA_BUF *old_password;/* [unique] */
};

struct lsa_TrustDomainInfoBasic {
	struct lsa_String netbios_name;
	struct dom_sid2 *sid;/* [unique] */
};

struct lsa_TrustDomainInfoInfoEx {
	struct lsa_StringLarge domain_name;
	struct lsa_StringLarge netbios_name;
	struct dom_sid2 *sid;/* [unique] */
	uint32_t trust_direction;
	uint32_t trust_type;
	uint32_t trust_attributes;
};

struct lsa_TrustDomainInfoBuffer {
	NTTIME last_update_time;
	uint32_t secret_type;
	struct lsa_DATA_BUF2 data;
};

struct lsa_TrustDomainInfoAuthInfo {
	uint32_t incoming_count;
	struct lsa_TrustDomainInfoBuffer *incoming_current_auth_info;/* [unique] */
	struct lsa_TrustDomainInfoBuffer *incoming_previous_auth_info;/* [unique] */
	uint32_t outgoing_count;
	struct lsa_TrustDomainInfoBuffer *outgoing_current_auth_info;/* [unique] */
	struct lsa_TrustDomainInfoBuffer *outgoing_previous_auth_info;/* [unique] */
};

struct lsa_TrustDomainInfoFullInfo {
	struct lsa_TrustDomainInfoInfoEx info_ex;
	struct lsa_TrustDomainInfoPosixOffset posix_offset;
	struct lsa_TrustDomainInfoAuthInfo auth_info;
};

struct lsa_TrustDomainInfo11 {
	struct lsa_TrustDomainInfoInfoEx info_ex;
	struct lsa_DATA_BUF2 data1;
};

struct lsa_TrustDomainInfoInfoAll {
	struct lsa_TrustDomainInfoInfoEx info_ex;
	struct lsa_DATA_BUF2 data1;
	struct lsa_TrustDomainInfoPosixOffset posix_offset;
	struct lsa_TrustDomainInfoAuthInfo auth_info;
};

union lsa_TrustedDomainInfo {
	struct lsa_TrustDomainInfoName name;/* [case(LSA_TRUSTED_DOMAIN_INFO_NAME)] */
	struct lsa_TrustDomainInfoPosixOffset posix_offset;/* [case(LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET)] */
	struct lsa_TrustDomainInfoPassword password;/* [case(LSA_TRUSTED_DOMAIN_INFO_PASSWORD)] */
	struct lsa_TrustDomainInfoBasic info_basic;/* [case(LSA_TRUSTED_DOMAIN_INFO_BASIC)] */
	struct lsa_TrustDomainInfoInfoEx info_ex;/* [case(LSA_TRUSTED_DOMAIN_INFO_INFO_EX)] */
	struct lsa_TrustDomainInfoAuthInfo auth_info;/* [case(LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO)] */
	struct lsa_TrustDomainInfoFullInfo full_info;/* [case(LSA_TRUSTED_DOMAIN_INFO_FULL_INFO)] */
	struct lsa_TrustDomainInfo11 info11;/* [case(LSA_TRUSTED_DOMAIN_INFO_11)] */
	struct lsa_TrustDomainInfoInfoAll info_all;/* [case(LSA_TRUSTED_DOMAIN_INFO_INFO_ALL)] */
}/* [switch_type(lsa_TrustDomInfoEnum)] */;

struct lsa_DATA_BUF_PTR {
	struct lsa_DATA_BUF *buf;/* [unique] */
};

struct lsa_RightAttribute {
	const char *name;/* [unique,charset(UTF16)] */
};

struct lsa_RightSet {
	uint32_t count;
	struct lsa_StringLarge *names;/* [unique,size_is(count)] */
};

struct lsa_StringPointer {
	struct lsa_String *string;/* [unique] */
};

struct lsa_DomainListEx {
	uint32_t count;
	struct lsa_TrustDomainInfoInfoEx *domains;/* [unique,size_is(count)] */
};

struct lsa_DomainInfoKerberos {
	uint32_t enforce_restrictions;
	uint64_t service_tkt_lifetime;
	uint64_t user_tkt_lifetime;
	uint64_t user_tkt_renewaltime;
	uint64_t clock_skew;
	uint64_t unknown6;
};

struct lsa_DomainInfoEfs {
	uint32_t blob_size;
	uint8_t *efs_blob;/* [unique,size_is(blob_size)] */
};

enum lsa_DomainInfoEnum
#ifndef USE_UINT_ENUMS
 {
	LSA_DOMAIN_INFO_POLICY_EFS=2,
	LSA_DOMAIN_INFO_POLICY_KERBEROS=3
}
#else
 { __donnot_use_enum_lsa_DomainInfoEnum=0x7FFFFFFF}
#define LSA_DOMAIN_INFO_POLICY_EFS ( 2 )
#define LSA_DOMAIN_INFO_POLICY_KERBEROS ( 3 )
#endif
;

union lsa_DomainInformationPolicy {
	struct lsa_DomainInfoEfs efs_info;/* [case(LSA_DOMAIN_INFO_POLICY_EFS)] */
	struct lsa_DomainInfoKerberos kerberos_info;/* [case(LSA_DOMAIN_INFO_POLICY_KERBEROS)] */
}/* [switch_type(uint16)] */;

struct lsa_TranslatedName2 {
	enum lsa_SidType sid_type;
	struct lsa_String name;
	uint32_t sid_index;
	uint32_t unknown;
};

struct lsa_TransNameArray2 {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedName2 *names;/* [unique,size_is(count)] */
};

struct lsa_TranslatedSid2 {
	enum lsa_SidType sid_type;
	uint32_t rid;
	uint32_t sid_index;
	uint32_t unknown;
};

struct lsa_TransSidArray2 {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedSid2 *sids;/* [unique,size_is(count)] */
};

struct lsa_TranslatedSid3 {
	enum lsa_SidType sid_type;
	struct dom_sid2 *sid;/* [unique] */
	uint32_t sid_index;
	uint32_t unknown;
};

struct lsa_TransSidArray3 {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedSid3 *sids;/* [unique,size_is(count)] */
};

struct lsa_ForestTrustBinaryData {
	uint32_t length;/* [range(0,131072)] */
	uint8_t *data;/* [unique,size_is(length)] */
};

struct lsa_ForestTrustDomainInfo {
	struct dom_sid2 *domain_sid;/* [unique] */
	struct lsa_StringLarge dns_domain_name;
	struct lsa_StringLarge netbios_domain_name;
};

union lsa_ForestTrustData {
	struct lsa_String top_level_name;/* [case(LSA_FOREST_TRUST_TOP_LEVEL_NAME)] */
	struct lsa_StringLarge top_level_name_ex;/* [case(LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX)] */
	struct lsa_ForestTrustDomainInfo domain_info;/* [case(LSA_FOREST_TRUST_DOMAIN_INFO)] */
	struct lsa_ForestTrustBinaryData data;/* [default] */
}/* [switch_type(uint32)] */;

enum lsa_ForestTrustRecordType
#ifndef USE_UINT_ENUMS
 {
	LSA_FOREST_TRUST_TOP_LEVEL_NAME=0,
	LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX=1,
	LSA_FOREST_TRUST_DOMAIN_INFO=2,
	LSA_FOREST_TRUST_RECORD_TYPE_LAST=3
}
#else
 { __donnot_use_enum_lsa_ForestTrustRecordType=0x7FFFFFFF}
#define LSA_FOREST_TRUST_TOP_LEVEL_NAME ( 0 )
#define LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX ( 1 )
#define LSA_FOREST_TRUST_DOMAIN_INFO ( 2 )
#define LSA_FOREST_TRUST_RECORD_TYPE_LAST ( 3 )
#endif
;

struct lsa_ForestTrustRecord {
	uint32_t flags;
	enum lsa_ForestTrustRecordType level;
	uint64_t unknown;
	union lsa_ForestTrustData forest_trust_data;/* [switch_is(level)] */
};

struct lsa_ForestTrustInformation {
	uint32_t count;/* [range(0,4000)] */
	struct lsa_ForestTrustRecord **entries;/* [unique,size_is(count)] */
}/* [public] */;


struct lsa_Close {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_Delete {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_EnumPrivs {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t max_count;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		struct lsa_PrivArray *privs;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_QuerySecurity {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t sec_info;
	} in;

	struct {
		struct sec_desc_buf *sdbuf;/* [unique] */
		NTSTATUS result;
	} out;

};


struct lsa_SetSecObj {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_ChangePassword {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenPolicy {
	struct {
		uint16_t *system_name;/* [unique] */
		struct lsa_ObjectAttribute *attr;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_QueryInfoPolicy {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum lsa_PolicyInfo level;
	} in;

	struct {
		union lsa_PolicyInformation *info;/* [unique,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetInfoPolicy {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum lsa_PolicyInfo level;
		union lsa_PolicyInformation *info;/* [ref,switch_is(level)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_ClearAuditLog {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CreateAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *acct_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumAccounts {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t num_entries;/* [range(0,8192)] */
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		struct lsa_SidArray *sids;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CreateTrustedDomain {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_DomainInfo *info;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumTrustDom {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t max_size;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		struct lsa_DomainList *domains;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupNames {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t num_names;/* [range(0,1000)] */
		struct lsa_String *names;/* [size_is(num_names)] */
		enum lsa_LookupNamesLevel level;
		struct lsa_TransSidArray *sids;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [unique] */
		struct lsa_TransSidArray *sids;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupSids {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_SidArray *sids;/* [ref] */
		uint16_t level;
		struct lsa_TransNameArray *names;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [unique] */
		struct lsa_TransNameArray *names;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CreateSecret {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String name;
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *sec_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_OpenAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *acct_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumPrivsAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct lsa_PrivilegeSet *privs;/* [unique] */
		NTSTATUS result;
	} out;

};


struct lsa_AddPrivilegesToAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_PrivilegeSet *privs;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_RemovePrivilegesFromAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint8_t remove_all;
		struct lsa_PrivilegeSet *privs;/* [unique] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_GetQuotasForAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_SetQuotasForAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_GetSystemAccessAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_SetSystemAccessAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenTrustedDomain {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_QueryTrustedDomainInfo {
	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		enum lsa_TrustDomInfoEnum level;
	} in;

	struct {
		union lsa_TrustedDomainInfo *info;/* [unique,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetInformationTrustedDomain {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenSecret {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String name;
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *sec_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_SetSecret {
	struct {
		struct policy_handle *sec_handle;/* [ref] */
		struct lsa_DATA_BUF *new_val;/* [unique] */
		struct lsa_DATA_BUF *old_val;/* [unique] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_QuerySecret {
	struct {
		struct policy_handle *sec_handle;/* [ref] */
		struct lsa_DATA_BUF_PTR *new_val;/* [unique] */
		NTTIME *new_mtime;/* [unique] */
		struct lsa_DATA_BUF_PTR *old_val;/* [unique] */
		NTTIME *old_mtime;/* [unique] */
	} in;

	struct {
		struct lsa_DATA_BUF_PTR *new_val;/* [unique] */
		NTTIME *new_mtime;/* [unique] */
		struct lsa_DATA_BUF_PTR *old_val;/* [unique] */
		NTTIME *old_mtime;/* [unique] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupPrivValue {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *name;/* [ref] */
	} in;

	struct {
		struct lsa_LUID *luid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupPrivName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_LUID *luid;/* [ref] */
	} in;

	struct {
		struct lsa_StringLarge *name;/* [unique] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupPrivDisplayName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *name;/* [ref] */
		uint16_t unknown;
		uint16_t *language_id;/* [ref] */
	} in;

	struct {
		struct lsa_StringLarge *disp_name;/* [unique] */
		uint16_t *language_id;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_DeleteObject {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_EnumAccountsWithUserRight {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *name;/* [unique] */
	} in;

	struct {
		struct lsa_SidArray *sids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumAccountRights {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
	} in;

	struct {
		struct lsa_RightSet *rights;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_AddAccountRights {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		struct lsa_RightSet *rights;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_RemoveAccountRights {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		uint32_t unknown;
		struct lsa_RightSet *rights;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_QueryTrustedDomainInfoBySid {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *dom_sid;/* [ref] */
		enum lsa_TrustDomInfoEnum level;
	} in;

	struct {
		union lsa_TrustedDomainInfo *info;/* [unique,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetTrustedDomainInfo {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_DeleteTrustedDomain {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *dom_sid;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_StorePrivateData {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_RetrievePrivateData {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenPolicy2 {
	struct {
		const char *system_name;/* [unique,charset(UTF16)] */
		struct lsa_ObjectAttribute *attr;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_GetUserName {
	struct {
		const char *system_name;/* [unique,charset(UTF16)] */
		struct lsa_String *account_name;/* [unique] */
		struct lsa_StringPointer *authority_name;/* [unique] */
	} in;

	struct {
		struct lsa_String *account_name;/* [unique] */
		struct lsa_StringPointer *authority_name;/* [unique] */
		NTSTATUS result;
	} out;

};


struct lsa_QueryInfoPolicy2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum lsa_PolicyInfo level;
	} in;

	struct {
		union lsa_PolicyInformation *info;/* [unique,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetInfoPolicy2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum lsa_PolicyInfo level;
		union lsa_PolicyInformation *info;/* [ref,switch_is(level)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_QueryTrustedDomainInfoByName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String trusted_domain;
		enum lsa_TrustDomInfoEnum level;
	} in;

	struct {
		union lsa_TrustedDomainInfo *info;/* [unique,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetTrustedDomainInfoByName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String trusted_domain;
		enum lsa_TrustDomInfoEnum level;
		union lsa_TrustedDomainInfo *info;/* [unique,switch_is(level)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_EnumTrustedDomainsEx {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t max_size;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		struct lsa_DomainListEx *domains;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CreateTrustedDomainEx {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CloseTrustedDomainEx {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_QueryDomainInformationPolicy {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint16_t level;
	} in;

	struct {
		union lsa_DomainInformationPolicy *info;/* [unique,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetDomainInformationPolicy {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint16_t level;
		union lsa_DomainInformationPolicy *info;/* [unique,switch_is(level)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenTrustedDomainByName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String name;
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_TestCall {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LookupSids2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_SidArray *sids;/* [ref] */
		uint16_t level;
		uint32_t unknown1;
		uint32_t unknown2;
		struct lsa_TransNameArray2 *names;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [unique] */
		struct lsa_TransNameArray2 *names;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupNames2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t num_names;/* [range(0,1000)] */
		struct lsa_String *names;/* [size_is(num_names)] */
		enum lsa_LookupNamesLevel level;
		uint32_t unknown1;
		uint32_t unknown2;
		struct lsa_TransSidArray2 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [unique] */
		struct lsa_TransSidArray2 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CreateTrustedDomainEx2 {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRWRITE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRREAD {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRENUMERATE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRWRITEDOMAINCREDENTIALS {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRREADDOMAINCREDENTIALS {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRDELETE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRGETTARGETINFO {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRPROFILELOADED {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LookupNames3 {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t num_names;/* [range(0,1000)] */
		struct lsa_String *names;/* [size_is(num_names)] */
		enum lsa_LookupNamesLevel level;
		uint32_t unknown1;
		uint32_t unknown2;
		struct lsa_TransSidArray3 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [unique] */
		struct lsa_TransSidArray3 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CREDRGETSESSIONTYPES {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARREGISTERAUDITEVENT {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARGENAUDITEVENT {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARUNREGISTERAUDITEVENT {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_lsaRQueryForestTrustInformation {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *trusted_domain_name;/* [ref] */
		uint16_t unknown;
	} in;

	struct {
		struct lsa_ForestTrustInformation **forest_trust_info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LSARSETFORESTTRUSTINFORMATION {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRRENAME {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LookupSids3 {
	struct {
		struct lsa_SidArray *sids;/* [ref] */
		uint16_t level;
		uint32_t unknown1;
		uint32_t unknown2;
		struct lsa_TransNameArray2 *names;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [unique] */
		struct lsa_TransNameArray2 *names;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupNames4 {
	struct {
		uint32_t num_names;/* [range(0,1000)] */
		struct lsa_String *names;/* [size_is(num_names)] */
		enum lsa_LookupNamesLevel level;
		uint32_t unknown1;
		uint32_t unknown2;
		struct lsa_TransSidArray3 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [unique] */
		struct lsa_TransSidArray3 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LSAROPENPOLICYSCE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARADTREPORTSECURITYEVENT {
	struct {
		NTSTATUS result;
	} out;

};

#endif /* _HEADER_lsarpc */
