/*
 * Copyright 2007, Intel Corporation
 *
 * This file is part of kerneloops.org
 *
 * This program file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named COPYING; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authors:
 * 	Arjan van de Ven <arjan@linux.intel.com>
 * James Westby <james.westby@canonical.com>
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <curl/curl.h>

#include "kerneloops.h"


static void write_logfile(int count, char *result_url)
{
	openlog("kerneloops-submit", 0, LOG_KERN);
	syslog(LOG_WARNING, "Submitted %i kernel oopses to www.kerneloops.org", count);
	if (result_url && result_url[0])
		syslog(LOG_WARNING, "kerneloops.org: oops is posted as %s", result_url);
	closelog();
}

static char result_url[4096];

static size_t writefunction( void *ptr, size_t size, size_t nmemb, void __attribute((unused)) *stream)
{
	char *c, *c1, *c2;
	c = malloc(size*nmemb + 1);
	memset(c, 0, size*nmemb + 1);
	memcpy(c, ptr, size*nmemb);
	c1 = strstr(c, "201 ");
	if (c1) {
		c1+=4;
		c2 = strchr(c1, '\n');
		if (c2) *c2 = 0;
		strncpy(result_url, c1, 4095);
	}
	return size * nmemb;
}

void submit_oops(char *text)
{
	int result;
	CURL *handle;
	struct curl_httppost *post = NULL;
	struct curl_httppost *last = NULL;

	handle = curl_easy_init();

	curl_easy_setopt(handle, CURLOPT_URL, submit_url);

	/* set up the POST data */
	curl_formadd(&post, &last,
		CURLFORM_COPYNAME, "oopsdata",
		CURLFORM_COPYCONTENTS, text, CURLFORM_END);

	if (allow_distro_to_pass_on) {
		curl_formadd(&post, &last,
			CURLFORM_COPYNAME, "pass_on_allowed",
			CURLFORM_COPYCONTENTS, "yes", CURLFORM_END);
	}

	curl_easy_setopt(handle, CURLOPT_HTTPPOST, post);
	curl_easy_setopt(handle, CURLOPT_WRITEFUNCTION, writefunction);
	result = curl_easy_perform(handle);

	write_logfile(1, result_url);

	if (result_url)
		printf("%s\n", result_url);

	curl_formfree(post);
	curl_easy_cleanup(handle);
}

int main(int __unused argc, char __unused **argv)
{
    char text[10000];
    size_t resp;
    char *buf = text;
    size_t to_read = 10000;

    while (!feof(stdin) && !ferror(stdin)) {
        resp = fread(buf, 1, to_read, stdin);
        buf = buf + resp;
        to_read = to_read - resp;
    }

    if (ferror(stdin)) {
        write_logfile(1, "ferror(stdin)\n");
        return 1;
    }

    read_config_file("/etc/kerneloops.conf");

    submit_oops(text);

    return 0;
}
