/***************************************************************************
                          kcoordrangelist.cpp  -  description
                             -------------------
    begin                : Mon Jun 30 2003
    copyright            : (C) 2003 by Friedrich W. H. Kossebau
    email                : kossebau@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Library General Public           *
 *   License version 2 as published by the Free Software Foundation.       *
 *                                                                         *
 ***************************************************************************/


#include "kcoordrangelist.h"


namespace KHEUI {

KCoordRangeList::KCoordRangeList()
{
}


KCoordRangeList::~KCoordRangeList()
{
}


void KCoordRangeList::addCoordRange( KCoordRange NewCoordRange )
{
  if( !NewCoordRange.isValid() )
    return;
  // we try to insert it by ascending indizes
  // if sections are overlapping we combine them
  iterator S = begin();
  for( ; S!=end(); ++S )
  {
 // TODO: add bufferwidth to rangelist so consecutive ranges can be joined, cmp ksectionlist
    // is next CoordRange behind the new CoordRange?
    if( NewCoordRange.endsBefore(*S) )
    {
      // put the new before it
      insert( S, NewCoordRange );
      return;
    }

    // does the next CoordRange overlap?
    if( (*S).overlaps(NewCoordRange) )
    {
      // Start of the combined sections is the smaller one
      NewCoordRange.extendStartTo( (*S).start() );
      // next we search all the overlapping sections and keep the highest end index
      KCoord End((*S).end());
      iterator LS = S;
      for( ++LS; LS!=end(); ++LS )
      {
        if( NewCoordRange.endsBefore((*LS).start()) )
          break;
        End = (*LS).end();
      }
      // the higher end is the end of the combined CoordRange
      NewCoordRange.extendEndTo( End );
      // remove all overlapping sections
      S = erase( S, LS );
      // and instead insert the combined one
      insert( S, NewCoordRange );
      return;
    }
  }

  // all others are before the new?
  if( S == end() )
    // add it at the end
    append( NewCoordRange );
}

}
