//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.QColor;
import org.kde.qt.QRect;
import org.kde.qt.QListViewItem;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QPaintEvent;
import org.kde.qt.QPoint;
import org.kde.qt.QDragEnterEvent;
import org.kde.qt.QDragMoveEvent;
import org.kde.qt.QPainter;
import org.kde.qt.QDragLeaveEvent;
import org.kde.qt.QFocusEvent;
import org.kde.qt.QKeyEvent;
import org.kde.qt.QMouseEvent;
import org.kde.qt.QDropEvent;
import org.kde.qt.QEvent;
import org.kde.qt.QIconSet;
import org.kde.qt.QWidget;
import org.kde.qt.QResizeEvent;
import org.kde.qt.QDragObject;

public interface KListViewSignals {
	/**	
		 This signal is emitted whenever the user executes an listview item.
		 That means depending on the KDE wide Single Click/Double Click
		 setting the user clicked or double clicked on that item.
			@param item is the pointer to the executed listview item.
			 Note that you may not delete any QListViewItem objects in slots
		 connected to this signal.
		   		@short    This signal is emitted whenever the user executes an listview item.
	*/
	void executed(QListViewItem item);
	/**	
		 This signal is emitted whenever the user executes an listview item.
		 That means depending on the KDE wide Single Click/Double Click
		 setting the user clicked or double clicked on that item.
			@param item is the pointer to the executed listview item.
			@param pos is the position where the user has clicked
			@param c is the column into which the user clicked.
			 Note that you may not delete any QListViewItem objects in slots
		 connected to this signal.
		   		@short    This signal is emitted whenever the user executes an listview item.
	*/
	void executed(QListViewItem item, QPoint pos, int c);
	/**	
		 This signal gets emitted whenever something acceptable is
		 dropped onto the listview.
			@param e is the drop event itself (it has already been accepted)
			@param after is the item after which the drop occurred (or null, if
		 the drop was above all items)
				@short    This signal gets emitted whenever something acceptable is  dropped onto the listview.
		@see #acceptDrop
	*/
	void dropped(QDropEvent e, QListViewItem after);
	/**	
		 This signal gets emitted whenever something acceptable is
		 dropped onto the listview.
			 This is an overloaded version of the above (provided to simplify
		 processing drops outside of the class).
			@param list is the listview
			@param e is the drop event itself (it has already been accepted)
			@param after is the item after which the drop occurred (or null, if
		 the drop was above all items
		   		@short    This signal gets emitted whenever something acceptable is  dropped onto the listview.
	*/
	void dropped(KListView list, QDropEvent e, QListViewItem after);
	/**	
		 This signal gets emitted whenever something acceptable is
		 dropped onto the listview.
			 This function also provides a parent, in the event that your listview
		 is a tree
			@param list is the listview
			@param e is the drop event itself (it has already been accepted)
			@param parent the item that is to be the parent of the new item
			@param after is the item after which the drop occurred (or null, if
		 the drop was above all items
		   		@short    This signal gets emitted whenever something acceptable is  dropped onto the listview.
	*/
	void dropped(KListView list, QDropEvent e, QListViewItem parent, QListViewItem after);
	/**	
		 This signal gets emitted whenever something acceptable is
		 dropped onto the listview.
			 This function also provides a parent, in the event that your listview
		 is a tree
			@param e is the drop event itself (it has already been accepted)
			@param parent the item that is to be the parent of the new item
			@param after is the item after which the drop occurred (or null, if
		 the drop was above all items
		   		@short    This signal gets emitted whenever something acceptable is  dropped onto the listview.
	*/
	void dropped(QDropEvent e, QListViewItem parent, QListViewItem after);
	/**	
		 This signal is emitted when ever the user moves an item in the list via
		 DnD.
		 If more than one item is moved at the same time, this signal is only emitted
		 once.
		   		@short    This signal is emitted when ever the user moves an item in the list via  DnD.
	*/
	void moved();
	/**	
		 Connect to this signal if you want to do some preprocessing before
		 a move is made, for example, to disable sorting
			 This is sent only once per each groups of moves.  That is, for each
		 drop that is a move this will be emitted once, before KListView calls
				@short    Connect to this signal if you want to do some preprocessing before  a move is made, for example, to disable sorting 
		@see #moveItem
	*/
	void aboutToMove();
	/**	
		 This signal is emitted when ever the user moves an item in the list via
		 DnD.
		 If more than one item is moved at the same time, <code>afterFirst</code> and
		 <code>afterNow</code> will reflect what was true before the move.
		 This differs from moved(), so be careful. All the items will have been
		 moved before moved() is emitted, which is not true in this method. // FIXME
			@param item the item that was moved
			@param afterFirst the item that parameter item was in before the move, in the list
			@param afterNow the item it's currently after.
		   		@short    This signal is emitted when ever the user moves an item in the list via  DnD.
	*/
	void moved(QListViewItem item, QListViewItem afterFirst, QListViewItem afterNow);
	// void moved(QPtrList<QListViewItem>& arg1,QPtrList<QListViewItem>& arg2,QPtrList<QListViewItem>& arg3); >>>> NOT CONVERTED
	/**	
		 This signal gets emitted when an item is renamed via in-place renaming.
			@param item is the renamed item.
			@param str is the new value of column <code>col.</code>
			@param col is the renamed column.
		   		@short    This signal gets emitted when an item is renamed via in-place renaming.
	*/
	void itemRenamed(QListViewItem item, String str, int col);
	/**	
		 Same as above, but without the extra information.
		   		@short    Same as above, but without the extra information.
	*/
	void itemRenamed(QListViewItem item);
	/**	
		 This signal is emitted when the shortcut key for popup-menus is pressed.
			 Normally you should not use this, just connect a slot to signal
		 contextMenu (KListView, QListViewItem, QPoint) to correctly
		 handle showing context menus regardless of settings.
			@param list is this listview.
			@param item is the currentItem() at the time the key was pressed. May be null.
		   		@short    This signal is emitted when the shortcut key for popup-menus is pressed.
	*/
	void menuShortCutPressed(KListView list, QListViewItem item);
	/**	
		 This signal is emitted whenever a context-menu should be shown for item <code>i.</code>
		 It automatically adjusts for all settings involved (Menu key, showMenuOnPress/Click).
			@param l is this listview.
			@param i is the item for which the menu should be shown. May be null.
			@param p is the point at which the menu should be shown.
		   		@short    This signal is emitted whenever a context-menu should be shown for item <code>i.</code>
	*/
	void contextMenu(KListView l, QListViewItem i, QPoint p);
	void itemAdded(QListViewItem item);
	void itemRemoved(QListViewItem item);
}
