//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Text;
	using System.Collections.Generic;


	[SmokeClass("KWallet")]
	public class KWallet : Object {
		protected SmokeInvocation interceptor = null;

		/// <remarks>
		///  KDE Wallet
		///  This class implements a generic system-wide Wallet for KDE.  This is the
		///  ONLY public interface.
		///  See <see cref="IWalletSignals"></see> for signals emitted by Wallet
		/// </remarks>		<author> George Staikos <staikos@kde.org>
		/// </author>
		/// 		<short> KDE Wallet Class.</short>

		[SmokeClass("KWallet::Wallet")]
		public class Wallet : QObject, IDisposable {
	 		protected Wallet(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(Wallet), this);
			}
			private static SmokeInvocation staticInterceptor = null;
			static Wallet() {
				staticInterceptor = new SmokeInvocation(typeof(Wallet), null);
			}
			// int writeEntry(const QString& arg1,const QByteArray& arg2,KWallet::Wallet::EntryType arg3); >>>> NOT CONVERTED
			// KWallet::Wallet::EntryType entryType(const QString& arg1); >>>> NOT CONVERTED
			// KWallet::Wallet* openWallet(const QString& arg1,WId arg2,KWallet::Wallet::OpenType arg3); >>>> NOT CONVERTED
			/// <remarks>
			///   This syncs the wallet file on disk with what is in memory.
			///   You don't normally need to use this.  It happens
			///   automatically on close.
			/// </remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     This syncs the wallet file on disk with what is in memory.</short>
			[SmokeMethod("sync()")]
			public virtual int Sync() {
				return (int) interceptor.Invoke("sync", "sync()", typeof(int));
			}
			/// <remarks>
			///   This closes and locks the current wallet.  It will
			///   disconnect all applications using the wallet.
			/// </remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     This closes and locks the current wallet.</short>
			[SmokeMethod("lockWallet()")]
			public virtual int LockWallet() {
				return (int) interceptor.Invoke("lockWallet", "lockWallet()", typeof(int));
			}
			/// <remarks>
			///   The name of the current wallet.
			/// 		 </remarks>		<short>     The name of the current wallet.</short>
			[SmokeMethod("walletName() const")]
			public virtual string WalletName() {
				return (string) interceptor.Invoke("walletName", "walletName() const", typeof(string));
			}
			/// <remarks>
			///   Determine if the current wallet is open, and is a valid
			///   wallet handle.
			/// </remarks>		<return> Returns true if the wallet handle is valid and open.
			/// 		 </return>
			/// 		<short>     Determine if the current wallet is open, and is a valid   wallet handle.</short>
			[SmokeMethod("isOpen() const")]
			public virtual bool IsOpen() {
				return (bool) interceptor.Invoke("isOpen", "isOpen() const", typeof(bool));
			}
			/// <remarks>
			///   Request to the wallet service to change the password of
			///   the current wallet.
			/// <param> name="w" The window id to associate any dialogs with.
			/// 		 </param></remarks>		<short>     Request to the wallet service to change the password of   the current wallet.</short>
			[SmokeMethod("requestChangePassword(WId)")]
			public virtual void RequestChangePassword(uint w) {
				interceptor.Invoke("requestChangePassword$", "requestChangePassword(WId)", typeof(void), typeof(uint), w);
			}
			/// <remarks>
			///   Obtain the list of all folders contained in the wallet.
			/// </remarks>		<return> Returns an empty list if the wallet is not open.
			/// 		 </return>
			/// 		<short>     Obtain the list of all folders contained in the wallet.</short>
			[SmokeMethod("folderList()")]
			public virtual List<string> FolderList() {
				return (List<string>) interceptor.Invoke("folderList", "folderList()", typeof(List<string>));
			}
			/// <remarks>
			///   Determine if the folder <code>f</code> exists in the wallet.
			/// <param> name="f" the name of the folder to check for
			/// </param></remarks>		<return> Returns true if the folder exists in the wallet.
			/// 		 </return>
			/// 		<short>     Determine if the folder <code>f</code> exists in the wallet.</short>
			[SmokeMethod("hasFolder(const QString&)")]
			public virtual bool HasFolder(string f) {
				return (bool) interceptor.Invoke("hasFolder$", "hasFolder(const QString&)", typeof(bool), typeof(string), f);
			}
			/// <remarks>
			///   Set the current working folder to <code>f.</code>  The folder must
			///   exist, or this call will fail.  Create a folder with
			///   createFolder().
			/// <param> name="f" the name of the folder to make the working folder
			/// </param></remarks>		<return> Returns true if the folder was successfully set.
			/// 		 </return>
			/// 		<short>     Set the current working folder to <code>f.</code></short>
			[SmokeMethod("setFolder(const QString&)")]
			public virtual bool SetFolder(string f) {
				return (bool) interceptor.Invoke("setFolder$", "setFolder(const QString&)", typeof(bool), typeof(string), f);
			}
			/// <remarks>
			///   Remove the folder <code>f</code> and all its entries from the wallet.
			/// <param> name="f" the name of the folder to remove
			/// </param></remarks>		<return> Returns true if the folder was successfully removed.
			/// 		 </return>
			/// 		<short>     Remove the folder <code>f</code> and all its entries from the wallet.</short>
			[SmokeMethod("removeFolder(const QString&)")]
			public virtual bool RemoveFolder(string f) {
				return (bool) interceptor.Invoke("removeFolder$", "removeFolder(const QString&)", typeof(bool), typeof(string), f);
			}
			/// <remarks>
			///   Created the folder <code>f.</code>
			/// <param> name="f" the name of the folder to create
			/// </param></remarks>		<return> Returns true if the folder was successfully created.
			/// 		 </return>
			/// 		<short>     Created the folder <code>f.</code></short>
			[SmokeMethod("createFolder(const QString&)")]
			public virtual bool CreateFolder(string f) {
				return (bool) interceptor.Invoke("createFolder$", "createFolder(const QString&)", typeof(bool), typeof(string), f);
			}
			/// <remarks>
			///   Determine the current working folder in the wallet.
			///   If the folder name is empty, it is working in the global
			///   folder, which is valid but discouraged.
			/// </remarks>		<return> Returns the current working folder.
			/// 		 </return>
			/// 		<short>     Determine the current working folder in the wallet.</short>
			[SmokeMethod("currentFolder() const")]
			public virtual string CurrentFolder() {
				return (string) interceptor.Invoke("currentFolder", "currentFolder() const", typeof(string));
			}
			/// <remarks>
			///   Return the list of keys of all entries in this folder.
			/// </remarks>		<return> Returns an empty list if the wallet is not open, or
			///           if the folder is empty.
			/// 		 </return>
			/// 		<short>     Return the list of keys of all entries in this folder.</short>
			[SmokeMethod("entryList()")]
			public virtual List<string> EntryList() {
				return (List<string>) interceptor.Invoke("entryList", "entryList()", typeof(List<string>));
			}
			/// <remarks>
			///   Rename the entry <code>oldName</code> to <code>newName.</code>
			/// <param> name="oldName" The original key of the entry.
			/// </param><param> name="newName" The new key of the entry.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Rename the entry <code>oldName</code> to <code>newName.</code></short>
			[SmokeMethod("renameEntry(const QString&, const QString&)")]
			public virtual int RenameEntry(string oldName, string newName) {
				return (int) interceptor.Invoke("renameEntry$$", "renameEntry(const QString&, const QString&)", typeof(int), typeof(string), oldName, typeof(string), newName);
			}
			/// <remarks>
			///   Read the entry <code>key</code> from the current folder.
			///   The entry format is unknown except that it is either a
			///   QByteArray or a QDataStream, which effectively means that
			///   it is anything.
			/// <param> name="key" The key of the entry to read.
			/// </param><param> name="value" A buffer to fill with the value.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Read the entry <code>key</code> from the current folder.</short>
			[SmokeMethod("readEntry(const QString&, QByteArray&)")]
			public virtual int ReadEntry(string key, QByteArray value) {
				return (int) interceptor.Invoke("readEntry$#", "readEntry(const QString&, QByteArray&)", typeof(int), typeof(string), key, typeof(QByteArray), value);
			}
			/// <remarks>
			///   Read the map entry <code>key</code> from the current folder.
			/// <param> name="key" The key of the entry to read.
			/// </param><param> name="value" A map buffer to fill with the value.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.  Will
			///           return an error if the key was not originally
			///           written as a map.
			/// 		 </return>
			/// 		<short>     Read the map entry <code>key</code> from the current folder.</short>
			[SmokeMethod("readMap(const QString&, QMap<QString, QString>&)")]
			public virtual int ReadMap(string key, Dictionary<string, string> value) {
				return (int) interceptor.Invoke("readMap$?", "readMap(const QString&, QMap<QString, QString>&)", typeof(int), typeof(string), key, typeof(Dictionary<string, string>), value);
			}
			/// <remarks>
			///   Read the password entry <code>key</code> from the current folder.
			/// <param> name="key" The key of the entry to read.
			/// </param><param> name="value" A password buffer to fill with the value.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.  Will
			///           return an error if the key was not originally
			///           written as a password.
			/// 		 </return>
			/// 		<short>     Read the password entry <code>key</code> from the current folder.</short>
			[SmokeMethod("readPassword(const QString&, QString&)")]
			public virtual int ReadPassword(string key, StringBuilder value) {
				return (int) interceptor.Invoke("readPassword$$", "readPassword(const QString&, QString&)", typeof(int), typeof(string), key, typeof(StringBuilder), value);
			}
			/// <remarks>
			///   Read the entries matching <code>key</code> from the current folder.
			///   The entry format is unknown except that it is either a
			///   QByteArray or a QDataStream, which effectively means that
			///   it is anything.
			/// <param> name="key" The key of the entry to read.  Wildcards
			///              are supported.
			/// </param><param> name="value" A buffer to fill with the value.  The key in
			///                the map is the entry key.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Read the entries matching <code>key</code> from the current folder.</short>
			public int ReadEntryList(string key, StringBuilder value) {
				return (int) interceptor.Invoke("readEntryList$?", "readEntryList(const QString&, QMap<QString, QByteArray>&)", typeof(int), typeof(string), key, typeof(StringBuilder), value);
			}
			/// <remarks>
			///   Read the map entry <code>key</code> from the current folder.
			/// <param> name="key" The key of the entry to read.  Wildcards
			///              are supported.
			/// </param><param> name="value" A buffer to fill with the value.  The key in
			///                the map is the entry key.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.  Will
			///           return an error if the key was not originally
			///           written as a map.
			/// 		 </return>
			/// 		<short>     Read the map entry <code>key</code> from the current folder.</short>
			public int ReadMapList(string key, StringBuilder value) {
				return (int) interceptor.Invoke("readMapList$?", "readMapList(const QString&, QMap<QString, QMap<QString, QString> >&)", typeof(int), typeof(string), key, typeof(StringBuilder), value);
			}
			/// <remarks>
			///   Read the password entry <code>key</code> from the current folder.
			/// <param> name="key" The key of the entry to read.  Wildcards
			///              are supported.
			/// </param><param> name="value" A buffer to fill with the value.  The key in
			///                the map is the entry key.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.  Will
			///           return an error if the key was not originally
			///           written as a password.
			/// 		 </return>
			/// 		<short>     Read the password entry <code>key</code> from the current folder.</short>
			public int ReadPasswordList(string key, Dictionary<string, string> value) {
				return (int) interceptor.Invoke("readPasswordList$?", "readPasswordList(const QString&, QMap<QString, QString>&)", typeof(int), typeof(string), key, typeof(Dictionary<string, string>), value);
			}
			/// <remarks>
			///   Write <code>key</code> = <code>value</code> as a binary entry to the current
			///   folder.  Be careful with this, it could cause inconsistency
			///   in the future since you can put an arbitrary entry type in
			///   place.
			/// <param> name="key" The key of the new entry.
			/// </param><param> name="value" The value of the entry.
			/// </param><param> name="entryType" The type of the entry.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Write <code>key</code> = <code>value</code> as a binary entry to the current   folder.</short>
			/// <remarks>
			///   Write <code>key</code> = <code>value</code> as a binary entry to the current
			///   folder.
			/// <param> name="key" The key of the new entry.
			/// </param><param> name="value" The value of the entry.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Write <code>key</code> = <code>value</code> as a binary entry to the current   folder.</short>
			[SmokeMethod("writeEntry(const QString&, const QByteArray&)")]
			public virtual int WriteEntry(string key, QByteArray value) {
				return (int) interceptor.Invoke("writeEntry$#", "writeEntry(const QString&, const QByteArray&)", typeof(int), typeof(string), key, typeof(QByteArray), value);
			}
			/// <remarks>
			///   Write <code>key</code> = <code>value</code> as a map to the current folder.
			/// <param> name="key" The key of the new entry.
			/// </param><param> name="value" The value of the map.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Write <code>key</code> = <code>value</code> as a map to the current folder.</short>
			[SmokeMethod("writeMap(const QString&, const QMap<QString, QString>&)")]
			public virtual int WriteMap(string key, Dictionary<string, string> value) {
				return (int) interceptor.Invoke("writeMap$?", "writeMap(const QString&, const QMap<QString, QString>&)", typeof(int), typeof(string), key, typeof(Dictionary<string, string>), value);
			}
			/// <remarks>
			///   Write <code>key</code> = <code>value</code> as a password to the current folder.
			/// <param> name="key" The key of the new entry.
			/// </param><param> name="value" The value of the password.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Write <code>key</code> = <code>value</code> as a password to the current folder.</short>
			[SmokeMethod("writePassword(const QString&, const QString&)")]
			public virtual int WritePassword(string key, string value) {
				return (int) interceptor.Invoke("writePassword$$", "writePassword(const QString&, const QString&)", typeof(int), typeof(string), key, typeof(string), value);
			}
			/// <remarks>
			///   Determine if the current folder has they entry <code>key.</code>
			/// <param> name="key" The key to search for.
			/// </param></remarks>		<return> Returns true if the folder contains <code>key.</code>
			/// 		 </return>
			/// 		<short>     Determine if the current folder has they entry <code>key.</code></short>
			[SmokeMethod("hasEntry(const QString&)")]
			public virtual bool HasEntry(string key) {
				return (bool) interceptor.Invoke("hasEntry$", "hasEntry(const QString&)", typeof(bool), typeof(string), key);
			}
			/// <remarks>
			///   Remove the entry <code>key</code> from the current folder.
			/// <param> name="key" The key to remove.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Remove the entry <code>key</code> from the current folder.</short>
			[SmokeMethod("removeEntry(const QString&)")]
			public virtual int RemoveEntry(string key) {
				return (int) interceptor.Invoke("removeEntry$", "removeEntry(const QString&)", typeof(int), typeof(string), key);
			}
			/// <remarks>
			///   Determine the type of the entry <code>key</code> in this folder.
			/// <param> name="key" The key to look up.
			/// </param></remarks>		<return> Returns an enumerated type representing the type
			///           of the entry.
			/// 		 </return>
			/// 		<short>     Determine the type of the entry <code>key</code> in this folder.</short>
			/// <remarks>
			///   Construct a KWallet object.
			/// <param> name="handle" The handle for the wallet.
			/// </param><param> name="name" The name of the wallet.
			/// 		 </param></remarks>		<short>     Construct a KWallet object.</short>
			public Wallet(int handle, string name) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("Wallet$$", "Wallet(int, const QString&)", typeof(void), typeof(int), handle, typeof(string), name);
			}
			/// <remarks>
			///   Copy a KWallet object.
			/// 		 </remarks>		<short>     Copy a KWallet object.</short>
			public Wallet(KWallet.Wallet arg1) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("Wallet#", "Wallet(const KWallet::Wallet&)", typeof(void), typeof(KWallet.Wallet), arg1);
			}
			~Wallet() {
				interceptor.Invoke("~Wallet", "~Wallet()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~Wallet", "~Wallet()", typeof(void));
			}
			/// <remarks>
			///   List all the wallets available.
			/// </remarks>		<return> Returns a list of the names of all wallets that are
			///           open.
			/// 		 </return>
			/// 		<short>     List all the wallets available.</short>
			public static List<string> WalletList() {
				return (List<string>) staticInterceptor.Invoke("walletList", "walletList()", typeof(List<string>));
			}
			/// <remarks>
			///   Determine if the KDE wallet is enabled.  Normally you do
			///   not need to use this because open() will just fail.
			/// </remarks>		<return> Returns true if the wallet enabled, else false.
			/// 		 </return>
			/// 		<short>     Determine if the KDE wallet is enabled.</short>
			public static bool IsEnabled() {
				return (bool) staticInterceptor.Invoke("isEnabled", "isEnabled()", typeof(bool));
			}
			/// <remarks>
			///   Determine if the wallet <code>name</code> is open by any application.
			/// <param> name="name" The name of the wallet to check.
			/// </param></remarks>		<return> Returns true if the wallet is open, else false.
			/// 		 </return>
			/// 		<short>     Determine if the wallet <code>name</code> is open by any application.</short>
			public static bool IsOpen(string name) {
				return (bool) staticInterceptor.Invoke("isOpen$", "isOpen(const QString&)", typeof(bool), typeof(string), name);
			}
			/// <remarks>
			///   Close the wallet <code>name.</code>  The wallet will only be closed
			///   if it is open but not in use (rare), or if it is forced
			///   closed.
			/// <param> name="name" The name of the wallet to close.
			/// </param><param> name="force" Set true to force the wallet closed even if it
			///                is in use by others.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Close the wallet <code>name.</code></short>
			public static int CloseWallet(string name, bool force) {
				return (int) staticInterceptor.Invoke("closeWallet$$", "closeWallet(const QString&, bool)", typeof(int), typeof(string), name, typeof(bool), force);
			}
			/// <remarks>
			///   Delete the wallet <code>name.</code>  The wallet will be forced closed
			///   first.
			/// <param> name="name" The name of the wallet to delete.
			/// </param></remarks>		<return> Returns 0 on success, non-zero on error.
			/// 		 </return>
			/// 		<short>     Delete the wallet <code>name.</code></short>
			public static int DeleteWallet(string name) {
				return (int) staticInterceptor.Invoke("deleteWallet$", "deleteWallet(const QString&)", typeof(int), typeof(string), name);
			}
			/// <remarks>
			///   Disconnect the application <code>app</code> from <code>wallet.</code>
			/// <param> name="wallet" The name of the wallet to disconnect.
			/// </param><param> name="app" The name of the application to disconnect.
			/// </param></remarks>		<return> Returns true on success, false on error.
			/// 		 </return>
			/// 		<short>     Disconnect the application <code>app</code> from <code>wallet.</code></short>
			public static bool DisconnectApplication(string wallet, string app) {
				return (bool) staticInterceptor.Invoke("disconnectApplication$$", "disconnectApplication(const QString&, const QString&)", typeof(bool), typeof(string), wallet, typeof(string), app);
			}
			/// <remarks>
			///   Open the wallet <code>name.</code>  The user will be prompted to
			///   allow your application to open the wallet, and may be
			///   prompted for a password.  You are responsible for deleting
			///   this object when you are done with it.
			/// <param> name="name" The name of the wallet to open.
			/// </param><param> name="ot" If Asynchronous, the call will return
			///                immediately with a non-null pointer to an
			///                invalid wallet.  You must immediately connect
			///                the walletOpened() signal to a slot so that
			///                you will know when it is opened, or when it
			///                fails.
			/// </param><param> name="w" The window id to associate any dialogs with.
			/// </param></remarks>		<return> Returns a pointer to the wallet if successful,
			///           or a null pointer on error or if rejected.
			/// 		 </return>
			/// 		<short>     Open the wallet <code>name.</code></short>
			public static KWallet.Wallet OpenWallet(string name, uint w) {
				return (KWallet.Wallet) staticInterceptor.Invoke("openWallet$$", "openWallet(const QString&, WId)", typeof(KWallet.Wallet), typeof(string), name, typeof(uint), w);
			}
			/// <remarks>
			///   List the applications that are using the wallet <code>wallet.</code>
			/// <param> name="wallet" The wallet to query.
			/// </param></remarks>		<return> Returns a list of all DCOP application IDs using
			///           the wallet.
			/// 		 </return>
			/// 		<short>     List the applications that are using the wallet <code>wallet.</code></short>
			public static List<string> Users(string wallet) {
				return (List<string>) staticInterceptor.Invoke("users$", "users(const QString&)", typeof(List<string>), typeof(string), wallet);
			}
			/// <remarks>
			///   The name of the wallet used to store local passwords.
			/// 		 </remarks>		<short>     The name of the wallet used to store local passwords.</short>
			public static string LocalWallet() {
				return (string) staticInterceptor.Invoke("LocalWallet", "LocalWallet()", typeof(string));
			}
			/// <remarks>
			///   The name of the wallet used to store network passwords.
			/// 		 </remarks>		<short>     The name of the wallet used to store network passwords.</short>
			public static string NetworkWallet() {
				return (string) staticInterceptor.Invoke("NetworkWallet", "NetworkWallet()", typeof(string));
			}
			/// <remarks>
			///   The standardized name of the password folder.
			///   It is automatically created when a wallet is created, but
			///   the user may still delete it so you should check for its
			///   existence and recreate it if necessary and desired.
			/// 		 </remarks>		<short>     The standardized name of the password folder.</short>
			public static string PasswordFolder() {
				return (string) staticInterceptor.Invoke("PasswordFolder", "PasswordFolder()", typeof(string));
			}
			/// <remarks>
			///   The standardized name of the form data folder.
			///   It is automatically created when a wallet is created, but
			///   the user may still delete it so you should check for its
			///   existence and recreate it if necessary and desired.
			/// 		 </remarks>		<short>     The standardized name of the form data folder.</short>
			public static string FormDataFolder() {
				return (string) staticInterceptor.Invoke("FormDataFolder", "FormDataFolder()", typeof(string));
			}
			/// <remarks>
			///   Request to the wallet service to change the password of
			///   the wallet <code>name.</code>
			/// <param> name="name" The the wallet to change the password of.
			/// </param><param> name="w" The window id to associate any dialogs with.
			/// 		 </param></remarks>		<short>     Request to the wallet service to change the password of   the wallet <code>name.</code></short>
			public static void ChangePassword(string name, uint w) {
				staticInterceptor.Invoke("changePassword$$", "changePassword(const QString&, WId)", typeof(void), typeof(string), name, typeof(uint), w);
			}
			/// <remarks>
			///   Determine if a folder does not exist in a wallet.  This
			///   does not require decryption of the wallet.
			///   This is a handy optimization to avoid prompting the user
			///   if your data is certainly not in the wallet.
			/// <param> name="wallet" The wallet to look in.
			/// </param><param> name="folder" The folder to look up.
			/// </param></remarks>		<return> Returns true if the folder does NOT exist in the
			///   wallet, or the wallet does not exist.
			/// 		 </return>
			/// 		<short>     Determine if a folder does not exist in a wallet.</short>
			public static bool FolderDoesNotExist(string wallet, string folder) {
				return (bool) staticInterceptor.Invoke("folderDoesNotExist$$", "folderDoesNotExist(const QString&, const QString&)", typeof(bool), typeof(string), wallet, typeof(string), folder);
			}
			/// <remarks>
			///   Determine if an entry in a folder does not exist in a
			///   wallet.  This does not require decryption of the wallet.
			///   This is a handy optimization to avoid prompting the user
			///   if your data is certainly not in the wallet.
			/// <param> name="wallet" The wallet to look in.
			/// </param><param> name="folder" The folder to look in.
			/// </param><param> name="key" The key to look up.
			/// </param></remarks>		<return> Returns true if the key does NOT exist in the
			///   wallet, or the folder or wallet does not exist.
			/// 		 </return>
			/// 		<short>     Determine if an entry in a folder does not exist in a   wallet.</short>
			public static bool KeyDoesNotExist(string wallet, string folder, string key) {
				return (bool) staticInterceptor.Invoke("keyDoesNotExist$$$", "keyDoesNotExist(const QString&, const QString&, const QString&)", typeof(bool), typeof(string), wallet, typeof(string), folder, typeof(string), key);
			}
			protected new IWalletSignals Emit {
				get { return (IWalletSignals) Q_EMIT; }
			}
		}

		public interface IWalletSignals : IQObjectSignals {
		/// <remarks>
		///   Emitted when this wallet is closed.
		/// 		 </remarks>		<short>     Emitted when this wallet is closed.</short>
		[Q_SIGNAL("void walletClosed()")]
		void WalletClosed();
		/// <remarks>
		///   Emitted when a folder in this wallet is updated.
		/// <param> name="folder" The folder that was updated.
		/// 		 </param></remarks>		<short>     Emitted when a folder in this wallet is updated.</short>
		[Q_SIGNAL("void folderUpdated(const QString&)")]
		void FolderUpdated(string folder);
		/// <remarks>
		///   Emitted when the folder list is changed in this wallet.
		/// 		 </remarks>		<short>     Emitted when the folder list is changed in this wallet.</short>
		[Q_SIGNAL("void folderListUpdated()")]
		void FolderListUpdated();
		/// <remarks>
		///   Emitted when a folder in this wallet is removed.
		/// <param> name="folder" The folder that was removed.
		/// 		 </param></remarks>		<short>     Emitted when a folder in this wallet is removed.</short>
		[Q_SIGNAL("void folderRemoved(const QString&)")]
		void FolderRemoved(string folder);
		/// <remarks>
		///   Emitted when a wallet is opened in asynchronous mode.
		/// <param> name="success" True if the wallet was opened successfully.
		/// 		 </param></remarks>		<short>     Emitted when a wallet is opened in asynchronous mode.</short>
		[Q_SIGNAL("void walletOpened(bool)")]
		void WalletOpened(bool success);
		}
	}
}
