//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	/// <remarks>
	///  This class is the main interface to access the KDE print framework. It allows KDE
	///  applications to easily access the print system, through an interface that is compatible
	///  with QPrinter. So that the porting of an existing application should be as easy as
	///  replacing any occurrence of QPrinter by KPrinter. However applications that explicitly
	///  used the QPrintDialog class must be changed to the standard KPrinter way of accessing
	///  the print dialog.
	///  Basically, a KDE application will use the KPrinter object as a paint device, and will draw
	///  on it using QPainter. In a standard application, the use of the KPrinter class will
	///  look like this:
	///  <pre>
	///  #include <kprinter.h>
	///  #include <qpainter.h>
	///  void MyClass.DoPrint()
	///  {
	///    KPrinter printer;
	///    // do some printer initialization
	///    printer.setFullPage( true );
	///    // initialize the printer using the print dialog
	///    if ( printer.setup( this ) )
	///    {
	///      // create a painter to paint on the printer object
	///      QPainter painter;
	///      // start painting
	///      painter.begin( &printer );
	///      <do something>
	///      // stop painting, this will automatically send the print data to the printer
	///      painter.end();
	///    }
	///  }
	///  </pre>
	///  The KPrinter interface also allows some more advanced possibilities, like the customization
	///  of the print dialog to integrate application specific print options. This is done by subclassing
	///  KPrintDialogPage and adding the page using addDialogPage().
	///  When compiling an application that uses KPrinter, you must link to -lkdeprint, which when
	///  using the standard KDE build framework can be done by adding $(LIB_KDEPRINT) to _LDADD.
	/// </remarks>		<author> Michael Goffioul
	/// </author>
	/// 		<short> The central interface class to access the KDE print system. </short>
	/// 		<see> QPrinter</see>
	/// 		<see> KPrintDialogPage</see>

	[SmokeClass("KPrinter")]
	public class KPrinter : KPReloadObject, IQPaintDevice, IDisposable {
 		protected KPrinter(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KPrinter), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KPrinter() {
			staticInterceptor = new SmokeInvocation(typeof(KPrinter), null);
		}
		/// <remarks>
		///  Defines the standard pages available for the print dialog:
		/// 
		/// <li>
		/// <code>CopiesPage</code>: page and copies selection (included by default)
		/// </li>
		/// 
		/// <li>
		/// <code>FilesPage</code>: file selection (only used by kprinter utility)
		/// </li>
		/// 
		/// <li>
		/// <code>Custom</code>: unused
		/// </li>
		/// </remarks>		<short>    Defines the standard pages available for the print dialog: </short>
		/// 		<see> addStandardPage</see>
		/// 		<see> removeStandardPage</see>
		public enum StandardPageType {
			CopiesPage = 0x01,
			FilesPage = 0x02,
			CustomPage = 0x10,
		}
		/// <remarks>
		///  Defines whether the application can perform page selection itself or not.
		///  Some print systems (like CUPS) can do page selection, in this case the
		///  page selection will be enabled in the print dialog, otherwise it will be
		///  disabled. However some applications (word processor) can do page selection
		///  themselves, then it will be enabled in the print dialog, whatever the
		///  print system used. But such an application has to tell kdeprint about its
		///  feature:
		/// 
		/// <li>
		/// <code>ApplicationSide</code>: the application will do page selection
		/// </li>
		/// 
		/// <li>
		/// <code>SystemSide</code>: page selection will be left to the print system, if available (default)
		/// </li>
		/// </remarks>		<short>    Defines whether the application can perform page selection itself or not.</short>
		/// 		<see> setPageSelection</see>
		/// 		<see> pageSelection</see>
		public enum PageSelectionType {
			ApplicationSide = 0x01,
			SystemSide = 0x02,
		}
		/// <remarks>
		///  Defines the type of the application, this affects the GUI of the print dialog:
		/// 
		/// <li>
		/// <code>Dialog</code>: print dialog used in an application (default)
		/// </li>
		/// 
		/// <li>
		/// <code>StandAlone</code>: print dialog used as a standalone widget
		/// </li>
		/// 
		/// <li>
		/// <code>StandAlonePersistent</code>: print dialog used as standalone widget, but persistent (do not use)
		/// </li>
		/// </remarks>		<short>    Defines the type of the application, this affects the GUI of the print dialog: </short>
		/// 		<see> setApplicationType</see>
		/// 		<see> applicationType</see>
		public enum ApplicationType {
			Dialog = 0x00,
			StandAlone = 0x01,
			StandAlonePersistent = 0x02,
		}
		/// <remarks>
		///  Defines the page set to print:
		/// 
		/// <li>
		/// <code>AllPages</code>: all pages
		/// </li>
		/// 
		/// <li>
		/// <code>OddPages</code>: only odd pages
		/// </li>
		/// 
		/// <li>
		/// <code>EvenPages</code>: only even pages
		/// </li>
		/// </remarks>		<short>    Defines the page set to print: </short>
		/// 		<see> pageSet</see>
		public enum PageSetType {
			AllPages = 0x00,
			OddPages = 0x01,
			EvenPages = 0x02,
		}
		/// <remarks>
		///  Defines the collate property of the printer (if supported by the print system):
		/// 
		/// <li>
		/// <code>Collate</code>: copies collated (1-2-3-..., 1-2-3-...)
		/// </li>
		/// 
		/// <li>
		/// <code>Uncollate</code>: copies uncollated (1-1-..., 2-2-..., 3-3-...)
		/// </li>
		/// </remarks>		<short>    Defines the collate property of the printer (if supported by the print system): </short>
		/// 		<see> setCollate</see>
		/// 		<see> collate</see>
		public enum CollateType {
			Collate = 0x00,
			Uncollate = 0x01,
		}
		/// <remarks>
		///  Defines the color mode of the printer
		/// </remarks>		<short>    Defines the color mode of the printer </short>
		/// 		<see> QPrinter.ColorMode</see>
		public enum ColorMode {
			GrayScale = QPrinter.GrayScale,
			Color = QPrinter.Color,
		}
		/// <remarks>
		///  Defines the orientation of the paper
		/// </remarks>		<short>    Defines the orientation of the paper </short>
		/// 		<see> QPrinter.Orientation</see>
		public enum Orientation {
			Portrait = QPrinter.Portrait,
			Landscape = QPrinter.Landscape,
		}
		/// <remarks>
		///  Defines the page order of the print job
		/// </remarks>		<short>    Defines the page order of the print job </short>
		/// 		<see> QPrinter.PageOrder</see>
		public enum PageOrder {
			FirstPageFirst = QPrinter.FirstPageFirst,
			LastPageFirst = QPrinter.LastPageFirst,
		}
		/// <remarks>
		///  Defines the paper size to use
		/// </remarks>		<short>    Defines the paper size to use </short>
		/// 		<see> QPrinter.PageSize</see>
		public enum PageSize {
			A4 = QPrinter.A4,
			B5 = QPrinter.B5,
			Letter = QPrinter.Letter,
			Legal = QPrinter.Legal,
			Executive = QPrinter.Executive,
			A0 = QPrinter.A0,
			A1 = QPrinter.A1,
			A2 = QPrinter.A2,
			A3 = QPrinter.A3,
			A5 = QPrinter.A5,
			A6 = QPrinter.A6,
			A7 = QPrinter.A7,
			A8 = QPrinter.A8,
			A9 = QPrinter.A9,
			B0 = QPrinter.B0,
			B1 = QPrinter.B1,
			B10 = QPrinter.B10,
			B2 = QPrinter.B2,
			B3 = QPrinter.B3,
			B4 = QPrinter.B4,
			B6 = QPrinter.B6,
			B7 = QPrinter.B7,
			B8 = QPrinter.B8,
			B9 = QPrinter.B9,
			C5E = QPrinter.C5E,
			Comm10E = QPrinter.Comm10E,
			DLE = QPrinter.DLE,
			Folio = QPrinter.Folio,
			Ledger = QPrinter.Ledger,
			Tabloid = QPrinter.Tabloid,
			NPageSize = QPrinter.NPageSize,
			CustomSize = QPrinter.Custom,
		}
		// KPrinterImpl* implementation(); >>>> NOT CONVERTED
		// void setRealPageSize(DrPageSize* arg1); >>>> NOT CONVERTED
		/// <remarks>
		///  Constructor. This also restores/saves the state from a previous KPrinter object created within
		///  the same application run, if <code>restore</code> is true. Setting <code>restore</code> to false may
		///  be useful if you want an independent/clean KPrinter object.
		/// <param> name="restore" if true, options will be restored/saved between successive KPrinter objects
		/// </param><param> name="m" the mode to establish the KPrinter in (see QPrinter.PrinterMode)
		///      </param></remarks>		<short>    Constructor.</short>
		public KPrinter(bool restore, QPrinter.PrinterMode m) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KPrinter$$", "KPrinter(bool, QPrinter::PrinterMode)", typeof(void), typeof(bool), restore, typeof(QPrinter.PrinterMode), m);
		}
		public KPrinter(bool restore) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KPrinter$", "KPrinter(bool)", typeof(void), typeof(bool), restore);
		}
		public KPrinter() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KPrinter", "KPrinter()", typeof(void));
		}
		/// <remarks>
		///  See QPrinter.NewPage().
		///      </remarks>		<short>    See QPrinter.NewPage().</short>
		public bool NewPage() {
			return (bool) interceptor.Invoke("newPage", "newPage()", typeof(bool));
		}
		/// <remarks>
		///  See QPrinter.Abort().
		///      </remarks>		<short>    See QPrinter.Abort().</short>
		public bool Abort() {
			return (bool) interceptor.Invoke("abort", "abort()", typeof(bool));
		}
		/// <remarks>
		///  See QPrinter.Aborted()
		///      </remarks>		<short>    See QPrinter.Aborted()      </short>
		public bool Aborted() {
			return (bool) interceptor.Invoke("aborted", "aborted() const", typeof(bool));
		}
		/// <remarks>
		///  See QPrinter.OutputToFile().
		///      </remarks>		<short>    See QPrinter.OutputToFile().</short>
		public bool OutputToFile() {
			return (bool) interceptor.Invoke("outputToFile", "outputToFile() const", typeof(bool));
		}
		/// <remarks>
		///  See QPrinter.SetOutputToFile().
		///      </remarks>		<short>    See QPrinter.SetOutputToFile().</short>
		public void SetOutputToFile(bool arg1) {
			interceptor.Invoke("setOutputToFile$", "setOutputToFile(bool)", typeof(void), typeof(bool), arg1);
		}
		/// <remarks>
		///  See QPrinter.OutputFileName().
		///      </remarks>		<short>    See QPrinter.OutputFileName().</short>
		public string OutputFileName() {
			return (string) interceptor.Invoke("outputFileName", "outputFileName() const", typeof(string));
		}
		/// <remarks>
		///  See QPrinter.SetOutputFileName().
		///      </remarks>		<short>    See QPrinter.SetOutputFileName().</short>
		public void SetOutputFileName(string arg1) {
			interceptor.Invoke("setOutputFileName$", "setOutputFileName(const QString&)", typeof(void), typeof(string), arg1);
		}
		/// <remarks>
		///  See QPrinter.DocName().
		///      </remarks>		<short>    See QPrinter.DocName().</short>
		public string DocName() {
			return (string) interceptor.Invoke("docName", "docName() const", typeof(string));
		}
		/// <remarks>
		///  See QPrinter.SetDocName().
		///      </remarks>		<short>    See QPrinter.SetDocName().</short>
		public void SetDocName(string arg1) {
			interceptor.Invoke("setDocName$", "setDocName(const QString&)", typeof(void), typeof(string), arg1);
		}
		/// <remarks>
		///  See QPrinter.Creator().
		///      </remarks>		<short>    See QPrinter.Creator().</short>
		public string Creator() {
			return (string) interceptor.Invoke("creator", "creator() const", typeof(string));
		}
		/// <remarks>
		///  See QPrinter.SetCreator().
		///      </remarks>		<short>    See QPrinter.SetCreator().</short>
		public void SetCreator(string arg1) {
			interceptor.Invoke("setCreator$", "setCreator(const QString&)", typeof(void), typeof(string), arg1);
		}
		/// <remarks>
		///  See QPrinter.FullPage().
		///      </remarks>		<short>    See QPrinter.FullPage().</short>
		public bool FullPage() {
			return (bool) interceptor.Invoke("fullPage", "fullPage() const", typeof(bool));
		}
		/// <remarks>
		///  See QPrinter.SetFullPage().
		///      </remarks>		<short>    See QPrinter.SetFullPage().</short>
		public void SetFullPage(bool arg1) {
			interceptor.Invoke("setFullPage$", "setFullPage(bool)", typeof(void), typeof(bool), arg1);
		}
		/// <remarks>
		///  See QPrinter.ColorMode().
		///      </remarks>		<short>    See QPrinter.ColorMode().</short>
		public KPrinter.ColorMode colorMode() {
			return (KPrinter.ColorMode) interceptor.Invoke("colorMode", "colorMode() const", typeof(KPrinter.ColorMode));
		}
		/// <remarks>
		///  See QPrinter.SetColorMode().
		///      </remarks>		<short>    See QPrinter.SetColorMode().</short>
		public void SetColorMode(KPrinter.ColorMode arg1) {
			interceptor.Invoke("setColorMode$", "setColorMode(KPrinter::ColorMode)", typeof(void), typeof(KPrinter.ColorMode), arg1);
		}
		/// <remarks>
		///  See QPrinter.NumCopies().
		///      </remarks>		<short>    See QPrinter.NumCopies().</short>
		public int NumCopies() {
			return (int) interceptor.Invoke("numCopies", "numCopies() const", typeof(int));
		}
		/// <remarks>
		///  See QPrinter.SetNumCopies().
		///      </remarks>		<short>    See QPrinter.SetNumCopies().</short>
		public void SetNumCopies(int n) {
			interceptor.Invoke("setNumCopies$", "setNumCopies(int)", typeof(void), typeof(int), n);
		}
		/// <remarks>
		///  See QPrinter.Orientation().
		///      </remarks>		<short>    See QPrinter.Orientation().</short>
		public KPrinter.Orientation orientation() {
			return (KPrinter.Orientation) interceptor.Invoke("orientation", "orientation() const", typeof(KPrinter.Orientation));
		}
		/// <remarks>
		///  See QPrinter.SetOrientation().
		///      </remarks>		<short>    See QPrinter.SetOrientation().</short>
		public void SetOrientation(KPrinter.Orientation arg1) {
			interceptor.Invoke("setOrientation$", "setOrientation(KPrinter::Orientation)", typeof(void), typeof(KPrinter.Orientation), arg1);
		}
		/// <remarks>
		///  See QPrinter.PageOrder().
		///      </remarks>		<short>    See QPrinter.PageOrder().</short>
		public KPrinter.PageOrder pageOrder() {
			return (KPrinter.PageOrder) interceptor.Invoke("pageOrder", "pageOrder() const", typeof(KPrinter.PageOrder));
		}
		/// <remarks>
		///  See QPrinter.SetPageOrder().
		///      </remarks>		<short>    See QPrinter.SetPageOrder().</short>
		public void SetPageOrder(KPrinter.PageOrder arg1) {
			interceptor.Invoke("setPageOrder$", "setPageOrder(KPrinter::PageOrder)", typeof(void), typeof(KPrinter.PageOrder), arg1);
		}
		/// <remarks>
		///  Returns the collate status of the current KPrinter.
		///      </remarks>		<short>    Returns the collate status of the current KPrinter.</short>
		public KPrinter.CollateType Collate() {
			return (KPrinter.CollateType) interceptor.Invoke("collate", "collate() const", typeof(KPrinter.CollateType));
		}
		/// <remarks>
		///  Sets the collate status for the current KPrinter to <code>type.</code>
		///      </remarks>		<short>    Sets the collate status for the current KPrinter to <code>type.</code></short>
		public void SetCollate(KPrinter.CollateType type) {
			interceptor.Invoke("setCollate$", "setCollate(KPrinter::CollateType)", typeof(void), typeof(KPrinter.CollateType), type);
		}
		/// <remarks>
		///  See QPrinter.MinPage().
		///      </remarks>		<short>    See QPrinter.MinPage().</short>
		public int MinPage() {
			return (int) interceptor.Invoke("minPage", "minPage() const", typeof(int));
		}
		/// <remarks>
		///  See QPrinter.MaxPage().
		///      </remarks>		<short>    See QPrinter.MaxPage().</short>
		public int MaxPage() {
			return (int) interceptor.Invoke("maxPage", "maxPage() const", typeof(int));
		}
		/// <remarks>
		///  See QPrinter.SetMinMax().
		///      </remarks>		<short>    See QPrinter.SetMinMax().</short>
		public void SetMinMax(int min, int max) {
			interceptor.Invoke("setMinMax$$", "setMinMax(int, int)", typeof(void), typeof(int), min, typeof(int), max);
		}
		/// <remarks>
		///  Sets the first and last page to be printed. See QPrinter.SetFromTo().
		///      </remarks>		<short>    Sets the first and last page to be printed.</short>
		public void SetFromTo(int arg1, int arg2) {
			interceptor.Invoke("setFromTo$$", "setFromTo(int, int)", typeof(void), typeof(int), arg1, typeof(int), arg2);
		}
		/// <remarks>
		///  See QPrinter.PageSize().
		///      </remarks>		<short>    See QPrinter.PageSize().</short>
		public KPrinter.PageSize pageSize() {
			return (KPrinter.PageSize) interceptor.Invoke("pageSize", "pageSize() const", typeof(KPrinter.PageSize));
		}
		/// <remarks>
		///  See QPrinter.SetPageSize().
		///      </remarks>		<short>    See QPrinter.SetPageSize().</short>
		public void SetPageSize(KPrinter.PageSize arg1) {
			interceptor.Invoke("setPageSize$", "setPageSize(KPrinter::PageSize)", typeof(void), typeof(KPrinter.PageSize), arg1);
		}
		/// <remarks>
		///  See QPrinter.PrinterName().
		///      </remarks>		<short>    See QPrinter.PrinterName().</short>
		public string PrinterName() {
			return (string) interceptor.Invoke("printerName", "printerName() const", typeof(string));
		}
		/// <remarks>
		///  See QPrinter.SetPrinterName().
		///      </remarks>		<short>    See QPrinter.SetPrinterName().</short>
		public void SetPrinterName(string arg1) {
			interceptor.Invoke("setPrinterName$", "setPrinterName(const QString&)", typeof(void), typeof(string), arg1);
		}
		/// <remarks>
		///  Returns the print program as set by setPrintProgram() or by the print dialog
		///  if a special printer has been selected.
		/// </remarks>		<return> the print command line
		/// </return>
		/// 		<short>    Returns the print program as set by setPrintProgram() or by the print dialog  if a special printer has been selected.</short>
		/// 		<see> setPrintProgram</see>
		public string PrintProgram() {
			return (string) interceptor.Invoke("printProgram", "printProgram() const", typeof(string));
		}
		/// <remarks>
		///  Sets the command line to use when printing. This function is useful
		///  when using a KPrinter object without the print dialog, to control what
		///  to print and how to do it. The command line may contain the following
		///  tags:
		/// 
		/// <li>
		/// %in : the input file to the print program. It is required and automatically
		///            appended at the end of the command line if not present.
		/// </li>
		/// 
		/// <li>
		/// %out : the output file. Use this tag in conjunction with setOutputToFile()
		///             and setOutputFileName()
		/// </li>
		/// 
		/// <li>
		/// %psl : the page size in lower case. This may be useful with some
		///             programs like gs.
		///  <pre>
		///  void createPNGOutputFile(string filename)
		///  {
		///    // use a clean KPrinter object
		///    KPrinter prt(false);
		/// </li>
		///    prt.setOutputToFile( true );
		///    prt.setOutputFileName( filename );
		///    prt.setPrintProgram( "gs -sDEVICE=png256 -sPAPERSIZE=%psl -sOutputFile=%out %in" );
		///    QPainter painter( &prt );
		///    doPaint( &painter );
		///  }
		///  </pre>
		/// <param> name="cmd" the print command line (containing at least the <code></code>%in tag)
		/// </param></remarks>		<short>    Sets the command line to use when printing.</short>
		/// 		<see> printProgram</see>
		public void SetPrintProgram(string cmd) {
			interceptor.Invoke("setPrintProgram$", "setPrintProgram(const QString&)", typeof(void), typeof(string), cmd);
		}
		/// <remarks>
		///  See QPrinter.PrinterSelectionOption(). Unused.
		///      </remarks>		<short>    See QPrinter.PrinterSelectionOption().</short>
		public string PrinterSelectionOption() {
			return (string) interceptor.Invoke("printerSelectionOption", "printerSelectionOption() const", typeof(string));
		}
		/// <remarks>
		///  See QPrinter.SetPrinterSelectionOption(). Unused
		///      </remarks>		<short>    See QPrinter.SetPrinterSelectionOption().</short>
		public void SetPrinterSelectionOption(string arg1) {
			interceptor.Invoke("setPrinterSelectionOption$", "setPrinterSelectionOption(const QString&)", typeof(void), typeof(string), arg1);
		}
		/// <remarks>
		///  Returns the current page number.
		/// </remarks>		<short>    Returns the current page number.</short>
		/// 		<see> setCurrentPage</see>
		public int CurrentPage() {
			return (int) interceptor.Invoke("currentPage", "currentPage() const", typeof(int));
		}
		/// <remarks>
		///  Sets the current page number. This page number will be used if the user
		///  selected "current page" in the print dialog. This option will only be
		///  enabled if the application does page selection itself and the application
		///  has called setCurrentPage() before opening the print dialog:
		///  <pre>
		///  MyClass.MyClass()
		///  {
		///    // declares my application able to do page selection
		///    KPrinter.SetPageSelection( KPrinter.ApplicationSide );
		///  }
		///  void MyClass.DoPrint()
		///  {
		///    KPrinter printer;
		///    printer.setCurrentPage( mycurrentpage );
		///    if ( printer.setup( this ) )
		///    {
		///      QValueList<int> pages = printer.pageList();
		///      // print the pages
		///      ...
		///    }
		///  }
		///  </pre>
		/// <param> name="p" the current page number (starting from 1)
		///      </param></remarks>		<short>    Sets the current page number.</short>
		public void SetCurrentPage(int p) {
			interceptor.Invoke("setCurrentPage$", "setCurrentPage(int)", typeof(void), typeof(int), p);
		}
		public void SetCurrentPage() {
			interceptor.Invoke("setCurrentPage", "setCurrentPage()", typeof(void));
		}
		/// <remarks>
		///  Returns the page set of the current KPrinter object.
		///      </remarks>		<short>    Returns the page set of the current KPrinter object.</short>
		public KPrinter.PageSetType PageSet() {
			return (KPrinter.PageSetType) interceptor.Invoke("pageSet", "pageSet() const", typeof(KPrinter.PageSetType));
		}
		/// <remarks>
		///  Sets up the KPrinter object using the print dialog, returns true if the user clicked OK.
		/// <param> name="parent" the parent widget to use for the print dialog
		/// </param><param> name="caption" the caption to use in the print dialog
		/// </param><param> name="forceExpand" force the expansion of the dialog (the show/hide button will be hidden)
		/// </param></remarks>		<return> boolean value corresponding to the button clicked by the user
		///      </return>
		/// 		<short>    Sets up the KPrinter object using the print dialog, returns true if the user clicked OK.</short>
		public bool Setup(QWidget parent, string caption, bool forceExpand) {
			return (bool) interceptor.Invoke("setup#$$", "setup(QWidget*, const QString&, bool)", typeof(bool), typeof(QWidget), parent, typeof(string), caption, typeof(bool), forceExpand);
		}
		public bool Setup(QWidget parent, string caption) {
			return (bool) interceptor.Invoke("setup#$", "setup(QWidget*, const QString&)", typeof(bool), typeof(QWidget), parent, typeof(string), caption);
		}
		public bool Setup(QWidget parent) {
			return (bool) interceptor.Invoke("setup#", "setup(QWidget*)", typeof(bool), typeof(QWidget), parent);
		}
		public bool Setup() {
			return (bool) interceptor.Invoke("setup", "setup()", typeof(bool));
		}
		/// <remarks>
		///  See QPrinter.Margins().
		///      </remarks>		<short>    See QPrinter.Margins().</short>
		public QSize Margins() {
			return (QSize) interceptor.Invoke("margins", "margins() const", typeof(QSize));
		}
		/// <remarks>
		///  Not used yet.
		///      </remarks>		<short>    Not used yet.</short>
		public void SetMargins(QSize m) {
			interceptor.Invoke("setMargins#", "setMargins(QSize)", typeof(void), typeof(QSize), m);
		}
		public void Margins(ref int top, ref int left, ref int bottom, ref int right) {
			StackItem[] stack = new StackItem[5];
			stack[1].s_int = top;
			stack[2].s_int = left;
			stack[3].s_int = bottom;
			stack[4].s_int = right;
			interceptor.Invoke("margins$$$$", "margins(uint*, uint*, uint*, uint*) const", stack);
			top = stack[1].s_int;
			left = stack[2].s_int;
			bottom = stack[3].s_int;
			right = stack[4].s_int;
			return;
		}
		public void SetMargins(uint top, uint left, uint bottom, uint right) {
			interceptor.Invoke("setMargins$$$$", "setMargins(uint, uint, uint, uint)", typeof(void), typeof(uint), top, typeof(uint), left, typeof(uint), bottom, typeof(uint), right);
		}
		/// <remarks>
		///  Returns the page list to be printed, correpsonding to the options selected by the user. This
		///  takes into account collate, page order, page set, ranges, ... This is useful when the
		///  application does page selection itself.
		/// </remarks>		<short>    Returns the page list to be printed, correpsonding to the options selected by the user.</short>
		/// 		<see> setCurrentPage</see>
		public List<int> PageList() {
			return (List<int>) interceptor.Invoke("pageList", "pageList() const", typeof(List<int>));
		}
		/// <remarks>
		///  Sets the KPrinter object to preview mode if <code>on</code> is true. In this mode, nothing will be
		///  printed but only a preview dialog will be popped up with the single "Close" action. Using
		///  this mode, any application can easily implement a preview action:
		///  <pre>
		///  void MyClass:doPreview()
		///  {
		///    // use a "clean" KPrinter object (independent from previous print jobs),
		///    // this is not necessary, it depends on the application
		///    KPrinter prt( false );
		///    prt.setPreviewOnly( true );
		///    QPainter painter( &prt );
		///    doPrint( &painter );
		///  }
		///  </pre>
		/// <param> name="on" the preview-only state
		/// </param></remarks>		<short>    Sets the KPrinter object to preview mode if <code>on</code> is true.</short>
		/// 		<see> previewOnly</see>
		public void SetPreviewOnly(bool on) {
			interceptor.Invoke("setPreviewOnly$", "setPreviewOnly(bool)", typeof(void), typeof(bool), on);
		}
		/// <remarks>
		///  Returns the preview-only state for this KPrinter object.
		/// </remarks>		<short>    Returns the preview-only state for this KPrinter object.</short>
		/// 		<see> setPreviewOnly</see>
		public bool PreviewOnly() {
			return (bool) interceptor.Invoke("previewOnly", "previewOnly() const", typeof(bool));
		}
		/// <remarks>
		///  Set the resolution of the current KPrinter object. The resolution is given in DPI. This
		///  resolution mainly affects the accuracy for object positionning on the paint device, and
		///  does not influence the real resolution that will be used by the printer (this should be
		///  set in the driver settings). The resolution is usually defined in the constructor.
		/// <param> name="dpi" the resolution in DPI
		/// </param></remarks>		<short>    Set the resolution of the current KPrinter object.</short>
		/// 		<see> KPrinter</see>
		/// 		<see> resolution</see>
		public void SetResolution(int dpi) {
			interceptor.Invoke("setResolution$", "setResolution(int)", typeof(void), typeof(int), dpi);
		}
		/// <remarks>
		///  Resturns the resolution of the current KPrinter object. The resolution is given in DPI.
		/// </remarks>		<return> resolution in DPI
		/// </return>
		/// 		<short>    Resturns the resolution of the current KPrinter object.</short>
		/// 		<see> setResolution</see>
		/// 		<see> KPrinter</see>
		public int Resolution() {
			return (int) interceptor.Invoke("resolution", "resolution() const", typeof(int));
		}
		/// <remarks>
		///  Define the KPrinter object to use the actual printer resolution. Under some print systems
		///  (CUPS, Foomatic, PostScript printers), it is possible to know the actual resolution that
		///  is used by the printer, as selected by the user in the driver settings. If <code>on</code> is true,
		///  this KPrinter object will use the actual printer resolution if it is able to extract it.
		///  If nothing can be found, the default resolution will be the one defined by the PrinterMode
		///  argument used in the KPrinter constructor, or set explicitly by setResolution().
		/// <param> name="on" true if the KPrinter object should use the actual printer resolution
		/// </param></remarks>		<short>    Define the KPrinter object to use the actual printer resolution.</short>
		/// 		<see> resolution</see>
		/// 		<see> setResolution</see>
		public void SetUsePrinterResolution(bool on) {
			interceptor.Invoke("setUsePrinterResolution$", "setUsePrinterResolution(bool)", typeof(void), typeof(bool), on);
		}
		/// <remarks>
		///  For internal use only.
		///      </remarks>		<short>    For internal use only.</short>
		/// <remarks>
		///  Prints the files given in argument. This will first filter the files accorsing to the filtering
		///  options selected by the user in the print dialog, then send the filtered files to the printer
		///  with the print options selected. This function is called automatically when calling
		///  QPainter.End() for a painter object constructed on KPrinter. In normal use, you don't need
		///  this use this function explicitly.
		///      </remarks>		<short>    Prints the files given in argument.</short>
		public bool PrintFiles(List<string> files, bool removeafter, bool startviewer) {
			return (bool) interceptor.Invoke("printFiles?$$", "printFiles(const QStringList&, bool, bool)", typeof(bool), typeof(List<string>), files, typeof(bool), removeafter, typeof(bool), startviewer);
		}
		public bool PrintFiles(List<string> files, bool removeafter) {
			return (bool) interceptor.Invoke("printFiles?$", "printFiles(const QStringList&, bool)", typeof(bool), typeof(List<string>), files, typeof(bool), removeafter);
		}
		public bool PrintFiles(List<string> files) {
			return (bool) interceptor.Invoke("printFiles?", "printFiles(const QStringList&)", typeof(bool), typeof(List<string>), files);
		}
		/// <remarks>
		///  The KPrinter object stores all its settings in an internal QMap structure on
		///  string. This allows to store any property. This method allows an application to access
		///  any print option from the KPrinter object, using the option name. For example if your
		///  application add a customized page to the print dialog, this page will saves its settings
		///  into the KPrinter object using this QMap<string,string> structure. After showing the
		///  print dialog, your application can then access these options using this method. The
		///  custom option name should follow the form "kde-appname-optionname".
		///  <pre>
		///  void MyClass.DoPrint()
		///  {
		///    KPrinter prt;
		///    // add my custom page
		///    prt.addDialogPage( new MyDialogPage() );
		///    // open print dialog
		///    if ( prt.setup( this ) )
		///    {
		///       string fntname = prt.option( "kde-myapp-fontname" );
		///       ...
		///       do_something;
		///       ...
		///    }
		///  }
		///  </pre>
		/// <param> name="key" the option name (key)
		/// </param></remarks>		<return> the option value correponding to the key, or string()
		/// </return>
		/// 		<short>    The KPrinter object stores all its settings in an internal QMap structure on  string.</short>
		/// 		<see> KPrintDialogPage</see>
		/// 		<see> setOption</see>
		/// 		<see> options</see>
		/// 		<see> setOptions</see>
		public string Option(string key) {
			return (string) interceptor.Invoke("option$", "option(const QString&) const", typeof(string), typeof(string), key);
		}
		/// <remarks>
		///  Adds or modifies an option in the KPrinter object. You probably don't need to use this function
		///  explicitly. This will be done implicitely for example when reimplementing
		///  KPrintDialogPage.GetOptions().
		/// <param> name="key" the option name
		/// </param><param> name="value" the option value
		/// </param></remarks>		<short>    Adds or modifies an option in the KPrinter object.</short>
		/// 		<see> option</see>
		/// 		<see> KPrintDialogPage</see>
		public void SetOption(string key, string value) {
			interceptor.Invoke("setOption$$", "setOption(const QString&, const QString&)", typeof(void), typeof(string), key, typeof(string), value);
		}
		/// <remarks>
		///  Returns the complete set of print options from the KPrinter object. For internal use.
		/// </remarks>		<return> the option set as a QMap object
		///      </return>
		/// 		<short>    Returns the complete set of print options from the KPrinter object.</short>
		public Dictionary<string, string> Options() {
			return (Dictionary<string, string>) interceptor.Invoke("options", "options() const", typeof(Dictionary<string, string>));
		}
		/// <remarks>
		///  Sets the option set in one operation. This method has some side effects like merging
		///  the internal map with the one given in argument, but only for option in the form
		///  "kde-...". For internal use only.
		/// <param> name="opts" the option set to be merged in the KPrinter object
		///      </param></remarks>		<short>    Sets the option set in one operation.</short>
		public void SetOptions(Dictionary<string, string> opts) {
			interceptor.Invoke("setOptions?", "setOptions(const QMap<QString, QString>&)", typeof(void), typeof(Dictionary<string, string>), opts);
		}
		/// <remarks>
		///  For internal use only. Does a similar job as setOption(), except that all possible
		///  internal printers are initialized with the option if it has the form "kde-...".
		/// <param> name="opts" the option set
		/// </param></remarks>		<short>    For internal use only.</short>
		/// 		<see> setOptions</see>
		public void InitOptions(Dictionary<string, string> opts) {
			interceptor.Invoke("initOptions?", "initOptions(const QMap<QString, QString>&)", typeof(void), typeof(Dictionary<string, string>), opts);
		}
		/// <remarks>
		///  Returns the search name of the printer selected by the user. Each printer is identified by
		///  a unique name. This method is mainly used for state restoration. For internal use.
		/// </remarks>		<return> the unique printer search name
		/// </return>
		/// 		<short>    Returns the search name of the printer selected by the user.</short>
		/// 		<see> setSearchName</see>
		public string SearchName() {
			return (string) interceptor.Invoke("searchName", "searchName() const", typeof(string));
		}
		/// <remarks>
		///  Sets the search name of the KPrinter object. For internal use.
		/// <param> name="n" the unique printer search name
		/// </param></remarks>		<short>    Sets the search name of the KPrinter object.</short>
		/// 		<see> searchName</see>
		public void SetSearchName(string n) {
			interceptor.Invoke("setSearchName$", "setSearchName(const QString&)", typeof(void), typeof(string), n);
		}
		/// <remarks>
		///  Returns the last error message issued by the print system. Unimplemented yet.
		/// </remarks>		<return> the last error message
		///      </return>
		/// 		<short>    Returns the last error message issued by the print system.</short>
		public string ErrorMessage() {
			return (string) interceptor.Invoke("errorMessage", "errorMessage() const", typeof(string));
		}
		/// <remarks>
		///  Sets the last error message. For internal use.
		/// <param> name="msg" the error message
		///      </param></remarks>		<short>    Sets the last error message.</short>
		public void SetErrorMessage(string msg) {
			interceptor.Invoke("setErrorMessage$", "setErrorMessage(const QString&)", typeof(void), typeof(string), msg);
		}
		/// <remarks>
		///  Configure the KPrinter object to be used with the printer named
		///  <code>prname.</code> After the call, the KPrinter object can be used without
		///  the need to call the print dialog. If <code>prname</code> is empty, then the
		///  KPrinter object is configured for the default printer. If <code>prname</code>
		///  corresponds to a pseudo-printer which needs an output file, a file
		///  dialog will be used. In that case, providing a parent widget for
		///  that dialog in <code>parent</code> may be useful.
		/// <param> name="prname" the name of the printer for which the KPrinter object
		///  has to be configured
		/// </param><param> name="parent" a parent widget, used a parent for a file dialog
		/// </param></remarks>		<return> boolean flag: if false, the KPrinter has not been correctly
		///  set up, and the application shouldn't use it to print. This may
		///  happen if the printer named <code>prname</code> has not been found or if the
		///  user clicked "Cancel" in the file dialog.
		/// </return>
		/// 		<short>    Configure the KPrinter object to be used with the printer named  <code>prname.</code></short>
		/// 		<see> setup</see>
		public bool AutoConfigure(string prname, QWidget parent) {
			return (bool) interceptor.Invoke("autoConfigure$#", "autoConfigure(const QString&, QWidget*)", typeof(bool), typeof(string), prname, typeof(QWidget), parent);
		}
		public bool AutoConfigure(string prname) {
			return (bool) interceptor.Invoke("autoConfigure$", "autoConfigure(const QString&)", typeof(bool), typeof(string), prname);
		}
		public bool AutoConfigure() {
			return (bool) interceptor.Invoke("autoConfigure", "autoConfigure()", typeof(bool));
		}
		/// <remarks>
		///  Set the default document filename. This filename will be used as the
		///  default basename for the output file, instead of the default "print".
		///  For example, by using setDocFileName("my_document"), the default
		///  output file will be $HOME/my_document.ps.
		/// <param> name="filename" the default document basename to use
		/// </param></remarks>		<short>    Set the default document filename.</short>
		/// 		<see> docFileName</see>
		public void SetDocFileName(string filename) {
			interceptor.Invoke("setDocFileName$", "setDocFileName(const QString&)", typeof(void), typeof(string), filename);
		}
		/// <remarks>
		///  Get the default document filename, that is the default basename used for
		///  the output file.
		/// </remarks>		<return> the default document basename
		/// </return>
		/// 		<short>    Get the default document filename, that is the default basename used for  the output file.</short>
		/// 		<see> setDocFileName</see>
		public string DocFileName() {
			return (string) interceptor.Invoke("docFileName", "docFileName() const", typeof(string));
		}
		/// <remarks>
		///  Set the default document directory. This directory will be used as
		///  the default location for any output file. If not set, $HOME directory
		///  is used instead.
		/// <param> name="dir" the new default output directory
		/// </param></remarks>		<short>    Set the default document directory.</short>
		/// 		<see> docDirectory</see>
		public void SetDocDirectory(string dir) {
			interceptor.Invoke("setDocDirectory$", "setDocDirectory(const QString&)", typeof(void), typeof(string), dir);
		}
		/// <remarks>
		///  Get the default document directory, that is the directory used for
		///  any output file. By default, it is the $HOME directory.
		/// </remarks>		<return> the default output directory
		/// </return>
		/// 		<short>    Get the default document directory, that is the directory used for  any output file.</short>
		/// 		<see> setDocDirectory</see>
		public string DocDirectory() {
			return (string) interceptor.Invoke("docDirectory", "docDirectory() const", typeof(string));
		}
		public void SetOutputFormat(QPrinter.OutputFormat format) {
			interceptor.Invoke("setOutputFormat$", "setOutputFormat(QPrinter::OutputFormat)", typeof(void), typeof(QPrinter.OutputFormat), format);
		}
		public QPrinter.OutputFormat OutputFormat() {
			return (QPrinter.OutputFormat) interceptor.Invoke("outputFormat", "outputFormat() const", typeof(QPrinter.OutputFormat));
		}
		public void SetPaperSource(QPrinter.PaperSource papersource) {
			interceptor.Invoke("setPaperSource$", "setPaperSource(QPrinter::PaperSource)", typeof(void), typeof(QPrinter.PaperSource), papersource);
		}
		public QPrinter.PaperSource PaperSource() {
			return (QPrinter.PaperSource) interceptor.Invoke("paperSource", "paperSource() const", typeof(QPrinter.PaperSource));
		}
		public List<int> SupportedResolutions() {
			return (List<int>) interceptor.Invoke("supportedResolutions", "supportedResolutions() const", typeof(List<int>));
		}
		public void SetFontEmbeddingEnabled(bool enable) {
			interceptor.Invoke("setFontEmbeddingEnabled$", "setFontEmbeddingEnabled(bool)", typeof(void), typeof(bool), enable);
		}
		public bool FontEmbeddingEnabled() {
			return (bool) interceptor.Invoke("fontEmbeddingEnabled", "fontEmbeddingEnabled() const", typeof(bool));
		}
		public void SetDoubleSidedPrinting(bool enable) {
			interceptor.Invoke("setDoubleSidedPrinting$", "setDoubleSidedPrinting(bool)", typeof(void), typeof(bool), enable);
		}
		public bool DoubleSidedPrinting() {
			return (bool) interceptor.Invoke("doubleSidedPrinting", "doubleSidedPrinting() const", typeof(bool));
		}
		public QRect PaperRect() {
			return (QRect) interceptor.Invoke("paperRect", "paperRect() const", typeof(QRect));
		}
		public QRect PageRect() {
			return (QRect) interceptor.Invoke("pageRect", "pageRect() const", typeof(QRect));
		}
		public QPrinter.PrinterState PrinterState() {
			return (QPrinter.PrinterState) interceptor.Invoke("printerState", "printerState() const", typeof(QPrinter.PrinterState));
		}
		[SmokeMethod("devType() const")]
		protected new virtual int DevType() {
			return (int) interceptor.Invoke("devType", "devType() const", typeof(int));
		}
		[SmokeMethod("paintEngine() const")]
		protected virtual QPaintEngine PaintEngine() {
			return (QPaintEngine) interceptor.Invoke("paintEngine", "paintEngine() const", typeof(QPaintEngine));
		}
		[SmokeMethod("metric(QPaintDevice::PaintDeviceMetric) const")]
		protected virtual int Metric(IQPaintDevice metric) {
			return (int) interceptor.Invoke("metric$", "metric(QPaintDevice::PaintDeviceMetric) const", typeof(int), typeof(IQPaintDevice), metric);
		}
		protected void TranslateQtOptions() {
			interceptor.Invoke("translateQtOptions", "translateQtOptions()", typeof(void));
		}
		protected void LoadSettings() {
			interceptor.Invoke("loadSettings", "loadSettings()", typeof(void));
		}
		protected void SaveSettings() {
			interceptor.Invoke("saveSettings", "saveSettings()", typeof(void));
		}
		protected void PreparePrinting() {
			interceptor.Invoke("preparePrinting", "preparePrinting()", typeof(void));
		}
		protected void FinishPrinting() {
			interceptor.Invoke("finishPrinting", "finishPrinting()", typeof(void));
		}
		[SmokeMethod("reload()")]
		protected override void Reload() {
			interceptor.Invoke("reload", "reload()", typeof(void));
		}
		protected void Init(bool restore, QPrinter.PrinterMode m) {
			interceptor.Invoke("init$$", "init(bool, QPrinter::PrinterMode)", typeof(void), typeof(bool), restore, typeof(QPrinter.PrinterMode), m);
		}
		protected void Init(bool restore) {
			interceptor.Invoke("init$", "init(bool)", typeof(void), typeof(bool), restore);
		}
		protected void Init() {
			interceptor.Invoke("init", "init()", typeof(void));
		}
		protected bool DoPreview(string file) {
			return (bool) interceptor.Invoke("doPreview$", "doPreview(const QString&)", typeof(bool), typeof(string), file);
		}
		protected void SetOption(string key, string value, bool broadcast) {
			interceptor.Invoke("setOption$$$", "setOption(const QString&, const QString&, bool)", typeof(void), typeof(string), key, typeof(string), value, typeof(bool), broadcast);
		}
		~KPrinter() {
			interceptor.Invoke("~KPrinter", "~KPrinter()", typeof(void));
		}
		public void Dispose() {
			interceptor.Invoke("~KPrinter", "~KPrinter()", typeof(void));
		}
		public bool PaintingActive() {
			return (bool) interceptor.Invoke("paintingActive", "paintingActive() const", typeof(bool));
		}
		public int Width() {
			return (int) interceptor.Invoke("width", "width() const", typeof(int));
		}
		public int Height() {
			return (int) interceptor.Invoke("height", "height() const", typeof(int));
		}
		public int WidthMM() {
			return (int) interceptor.Invoke("widthMM", "widthMM() const", typeof(int));
		}
		public int HeightMM() {
			return (int) interceptor.Invoke("heightMM", "heightMM() const", typeof(int));
		}
		public int LogicalDpiX() {
			return (int) interceptor.Invoke("logicalDpiX", "logicalDpiX() const", typeof(int));
		}
		public int LogicalDpiY() {
			return (int) interceptor.Invoke("logicalDpiY", "logicalDpiY() const", typeof(int));
		}
		public int PhysicalDpiX() {
			return (int) interceptor.Invoke("physicalDpiX", "physicalDpiX() const", typeof(int));
		}
		public int PhysicalDpiY() {
			return (int) interceptor.Invoke("physicalDpiY", "physicalDpiY() const", typeof(int));
		}
		public int NumColors() {
			return (int) interceptor.Invoke("numColors", "numColors() const", typeof(int));
		}
		public int Depth() {
			return (int) interceptor.Invoke("depth", "depth() const", typeof(int));
		}
		/// <remarks>
		///  Adds a customized page to the print dialog. The pages will appear in a tab widget in the
		///  bottom half of the dialog, along with the standard "Copies" page. The page must be created
		///  and added each time you want open a print dialog with setup(). If you correctly
		///  reimplemented KPrintDialogPage.SetOptions(), the settings will be restored from call
		///  to call, you don't have to worry about state saving/restoration.
		/// <param> name="_page" the page to add
		/// </param></remarks>		<short>    Adds a customized page to the print dialog.</short>
		/// 		<see> KPrintDialogPage.SetOptions</see>
		public static void AddDialogPage(KPrintDialogPage _page) {
			staticInterceptor.Invoke("addDialogPage#", "addDialogPage(KPrintDialogPage*)", typeof(void), typeof(KPrintDialogPage), _page);
		}
		/// <remarks>
		///  Sets the page selection mode of the application. If needed, call this method somewhere at
		///  the beginning of your code. The default value is <code>SystemSide.</code>
		/// <param> name="_mode" the mode for the application
		/// </param></remarks>		<short>    Sets the page selection mode of the application.</short>
		/// 		<see> pageSelection</see>
		public static void SetPageSelection(KPrinter.PageSelectionType _mode) {
			staticInterceptor.Invoke("setPageSelection$", "setPageSelection(KPrinter::PageSelectionType)", typeof(void), typeof(KPrinter.PageSelectionType), _mode);
		}
		/// <remarks>
		///  Returns the page selection mode of the current application.
		/// </remarks>		<return> the page selection mode
		/// </return>
		/// 		<short>    Returns the page selection mode of the current application.</short>
		/// 		<see> setPageSelection</see>
		public static KPrinter.PageSelectionType PageSelection() {
			return (KPrinter.PageSelectionType) staticInterceptor.Invoke("pageSelection", "pageSelection()", typeof(KPrinter.PageSelectionType));
		}
		/// <remarks>
		///  Sets the application type concerning the print dialog. You probably don't want to use it.
		///  For internal use only.
		/// <param> name="type" the type for this application
		/// </param></remarks>		<short>    Sets the application type concerning the print dialog.</short>
		/// 		<see> applicationType</see>
		public static void SetApplicationType(KPrinter.ApplicationType type) {
			staticInterceptor.Invoke("setApplicationType$", "setApplicationType(KPrinter::ApplicationType)", typeof(void), typeof(KPrinter.ApplicationType), type);
		}
		/// <remarks>
		///  Returns the application type concerning the print dialog. For internal use only.
		/// </remarks>		<return> the type for the current application
		/// </return>
		/// 		<short>    Returns the application type concerning the print dialog.</short>
		/// 		<see> setApplicationType</see>
		public static KPrinter.ApplicationType applicationType() {
			return (KPrinter.ApplicationType) staticInterceptor.Invoke("applicationType", "applicationType()", typeof(KPrinter.ApplicationType));
		}
		/// <remarks>
		///  Adds a standard page to the print dialog. This is not useful yet as there's only one
		///  standard page defines <code>CopiesPage.</code>
		/// <param> name="p" the page identifier
		/// </param></remarks>		<short>    Adds a standard page to the print dialog.</short>
		/// 		<see> StandardPageType</see>
		public static void AddStandardPage(int p) {
			staticInterceptor.Invoke("addStandardPage$", "addStandardPage(int)", typeof(void), typeof(int), p);
		}
		/// <remarks>
		///  Removes a standard page from the print dialog. If your application doesn't want a
		///  standard page in the dialog, simply call this method with the correct identifier.
		///  By default, the print dialog includes the <code>CopiesPage</code> page.
		/// <param> name="p" the page identifier
		/// </param></remarks>		<short>    Removes a standard page from the print dialog.</short>
		/// 		<see> StandardPageType</see>
		public static void RemoveStandardPage(int p) {
			staticInterceptor.Invoke("removeStandardPage$", "removeStandardPage(int)", typeof(void), typeof(int), p);
		}
	}
}
