//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  The base class for all jobs.
	///  For all jobs created in an application, the code looks like
	///  <pre>
	///    KJob  job = someoperation( some parameters );
	///    connect( job, SIGNAL("result( KJob  )"),
	///             this, SLOT("slotResult( KJob  )") );
	///    job.Start();
	///  </pre>
	///    (other connects, specific to the job)
	///  And slotResult is usually at least:
	///  <pre>
	///   if ( job.Error() )
	///       doSomething();
	///  </pre>
	///  With the synchronous interface the code looks like
	///  <pre>
	///   KJob job = someoperation( some parameters );
	///   if ( !job.Exec() )
	///   {
	///       // An error occurred
	///   }
	///   else
	///   {
	///       // Do something
	///   }
	///  </pre>
	///   See <see cref="IKJobSignals"></see> for signals emitted by KJob
	/// </remarks>		<short>    The base class for all jobs.</short>

	[SmokeClass("KJob")]
	public abstract class KJob : QObject {
 		protected KJob(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KJob), this);
		}
		public enum Unit {
			Bytes = 0,
			Files = 1,
			Directories = 2,
		}
		public enum Capability {
			NoCapabilities = 0x0000,
			Killable = 0x0001,
			Suspendable = 0x0002,
		}
		public enum KillVerbosity {
			Quietly = 0,
			EmitResult = 1,
		}
		public const int NoError = 0;
		public const int KilledJobError = 1;
		public const int UserDefinedError = 100;

		/// <remarks>
		///  Creates a new KJob object.
		/// <param> name="parent" the parent QObject
		///      </param></remarks>		<short>    Creates a new KJob object.</short>
		public KJob(QObject parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KJob#", "KJob(QObject*)", typeof(void), typeof(QObject), parent);
		}
		public KJob() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KJob", "KJob()", typeof(void));
		}
		/// <remarks>
		///  Attach a UI delegate to this job.
		///  If the job had another UI delegate, it's automatically deleted. Once
		///  attached to the job, the UI delegate will be deleted with the job.
		/// <param> name="delegate" the new UI delegate to use
		/// </param></remarks>		<short>    Attach a UI delegate to this job.</short>
		/// 		<see> KJobUiDelegate</see>
		public void SetUiDelegate(KJobUiDelegate arg1) {
			interceptor.Invoke("setUiDelegate#", "setUiDelegate(KJobUiDelegate*)", typeof(void), typeof(KJobUiDelegate), arg1);
		}
		/// <remarks>
		///  Retrieves the delegate attached to this job.
		/// </remarks>		<return> the delegate attached to this job, or 0 if there's no such delegate
		///      </return>
		/// 		<short>    Retrieves the delegate attached to this job.</short>
		public KJobUiDelegate UiDelegate() {
			return (KJobUiDelegate) interceptor.Invoke("uiDelegate", "uiDelegate() const", typeof(KJobUiDelegate));
		}
		/// <remarks>
		///  Returns the capabilities of this job.
		/// </remarks>		<return> the capabilities that this job supports
		/// </return>
		/// 		<short>    Returns the capabilities of this job.</short>
		/// 		<see> setCapabilities</see>
		public uint Capabilities() {
			return (uint) interceptor.Invoke("capabilities", "capabilities() const", typeof(uint));
		}
		/// <remarks>
		///  Returns if the job was suspended with the suspend() call.
		/// </remarks>		<return> if the job was suspended
		/// </return>
		/// 		<short>    Returns if the job was suspended with the suspend() call.</short>
		/// 		<see> suspend</see>
		/// 		<see> resume</see>
		public bool IsSuspended() {
			return (bool) interceptor.Invoke("isSuspended", "isSuspended() const", typeof(bool));
		}
		/// <remarks>
		///  Starts the job asynchronously. When the job is finished,
		///  result() is emitted.
		///      </remarks>		<short>    Starts the job asynchronously.</short>
		[SmokeMethod("start()")]
		public abstract void Start();
		/// <remarks>
		///  Executes the job synchronously.
		/// </remarks>		<return> true if the job has been executed without error, false otherwise
		///      </return>
		/// 		<short>    Executes the job synchronously.</short>
		public bool Exec() {
			return (bool) interceptor.Invoke("exec", "exec()", typeof(bool));
		}
		/// <remarks>
		///  Returns the error code, if there has been an error.
		///  Only call this method from the slot connected to result().
		/// </remarks>		<return> the error code for this job, 0 if no error.
		///      </return>
		/// 		<short>    Returns the error code, if there has been an error.</short>
		public int Error() {
			return (int) interceptor.Invoke("error", "error() const", typeof(int));
		}
		/// <remarks>
		///  Returns the error text if there has been an error.
		///  Only call if error is not 0.
		///  This is really internal, better use errorString.
		/// </remarks>		<return> a string to help understand the error, usually the url
		///  related to the error. Only valid if error() is not 0.
		///      </return>
		/// 		<short>    Returns the error text if there has been an error.</short>
		public string ErrorText() {
			return (string) interceptor.Invoke("errorText", "errorText() const", typeof(string));
		}
		/// <remarks>
		///  Converts an error code and a non-i18n error message into an
		///  error message in the current language. The low level (non-i18n)
		///  error message (usually a url) is put into the translated error
		///  message using %1.
		///  Example for errid == ERR_CANNOT_OPEN_FOR_READING:
		///  <pre>
		///    i18n( "Could not read\n%1" ).arg( errorText() );
		///  </pre>
		///  Do not call it if error() is not 0.
		/// </remarks>		<return> the error message and if there is no error, a message
		///          telling the user that the app is broken, so check with
		///          error() whether there is an error
		///      </return>
		/// 		<short>    Converts an error code and a non-i18n error message into an  error message in the current language.</short>
		[SmokeMethod("errorString() const")]
		public virtual string ErrorString() {
			return (string) interceptor.Invoke("errorString", "errorString() const", typeof(string));
		}
		/// <remarks>
		///  Returns the processed amount of a given unit for this job.
		/// <param> name="unit" the unit of the requested amount
		/// </param></remarks>		<return> the processed size
		///      </return>
		/// 		<short>    Returns the processed amount of a given unit for this job.</short>
		public ulong ProcessedAmount(KJob.Unit unit) {
			return (ulong) interceptor.Invoke("processedAmount$", "processedAmount(KJob::Unit) const", typeof(ulong), typeof(KJob.Unit), unit);
		}
		/// <remarks>
		///  Returns the total amount of a given unit for this job.
		/// <param> name="unit" the unit of the requested amount
		/// </param></remarks>		<return> the total size
		///      </return>
		/// 		<short>    Returns the total amount of a given unit for this job.</short>
		public ulong TotalAmount(KJob.Unit unit) {
			return (ulong) interceptor.Invoke("totalAmount$", "totalAmount(KJob::Unit) const", typeof(ulong), typeof(KJob.Unit), unit);
		}
		/// <remarks>
		///  Returns the overall progress of this job.
		/// </remarks>		<return> the overall progress of this job
		///      </return>
		/// 		<short>    Returns the overall progress of this job.</short>
		public ulong Percent() {
			return (ulong) interceptor.Invoke("percent", "percent() const", typeof(ulong));
		}
		/// <remarks>
		///  Aborts this job.
		///  This kills and deletes the job.
		/// <param> name="verbosity" if equals to EmitResult, Job will emit signal result
		///  and ask uiserver to close the progress window.
		///  <code>verbosity</code> is set to EmitResult for subjobs. Whether applications
		///  should call with Quietly or EmitResult depends on whether they rely
		///  on result being emitted or not.
		/// </param></remarks>		<return> true if the operation is supported and succeeded, false otherwise
		///      </return>
		/// 		<short>    Aborts this job.</short>
		[Q_SLOT("bool kill(KJob::KillVerbosity)")]
		public bool Kill(KJob.KillVerbosity verbosity) {
			return (bool) interceptor.Invoke("kill$", "kill(KJob::KillVerbosity)", typeof(bool), typeof(KJob.KillVerbosity), verbosity);
		}
		[Q_SLOT("bool kill()")]
		public bool Kill() {
			return (bool) interceptor.Invoke("kill", "kill()", typeof(bool));
		}
		/// <remarks>
		///  Suspends this job.
		///  The job should be kept in a state in which it is possible to resume it.
		/// </remarks>		<return> true if the operation is supported and succeeded, false otherwise
		///      </return>
		/// 		<short>    Suspends this job.</short>
		[Q_SLOT("bool suspend()")]
		public bool Suspend() {
			return (bool) interceptor.Invoke("suspend", "suspend()", typeof(bool));
		}
		/// <remarks>
		///  Resumes this job.
		/// </remarks>		<return> true if the operation is supported and succeeded, false otherwise
		///      </return>
		/// 		<short>    Resumes this job.</short>
		[Q_SLOT("bool resume()")]
		public bool Resume() {
			return (bool) interceptor.Invoke("resume", "resume()", typeof(bool));
		}
		/// <remarks>
		///  Aborts this job quietly.
		///  This simply kills the job, no error reporting or job deletion should be involved.
		/// </remarks>		<return> true if the operation is supported and succeeded, false otherwise
		///      </return>
		/// 		<short>    Aborts this job quietly.</short>
		[SmokeMethod("doKill()")]
		protected virtual bool DoKill() {
			return (bool) interceptor.Invoke("doKill", "doKill()", typeof(bool));
		}
		/// <remarks>
		///  Suspends this job.
		/// </remarks>		<return> true if the operation is supported and succeeded, false otherwise
		///      </return>
		/// 		<short>    Suspends this job.</short>
		[SmokeMethod("doSuspend()")]
		protected virtual bool DoSuspend() {
			return (bool) interceptor.Invoke("doSuspend", "doSuspend()", typeof(bool));
		}
		/// <remarks>
		///  Resumes this job.
		/// </remarks>		<return> true if the operation is supported and succeeded, false otherwise
		///      </return>
		/// 		<short>    Resumes this job.</short>
		[SmokeMethod("doResume()")]
		protected virtual bool DoResume() {
			return (bool) interceptor.Invoke("doResume", "doResume()", typeof(bool));
		}
		/// <remarks>
		///  Sets the capabilities for this job.
		/// <param> name="capabilities" are the capabilities supported by this job
		/// </param></remarks>		<short>    Sets the capabilities for this job.</short>
		/// 		<see> capabilities</see>
		protected void SetCapabilities(uint capabilities) {
			interceptor.Invoke("setCapabilities$", "setCapabilities(KJob::Capabilities)", typeof(void), typeof(uint), capabilities);
		}
		/// <remarks>
		///  Sets the error code. It should be called when an error
		///  is encountered in the job, just before calling emitResult().
		/// <param> name="errorCode" the error code
		/// </param></remarks>		<short>    Sets the error code.</short>
		/// 		<see> emitResult</see>
		protected void SetError(int errorCode) {
			interceptor.Invoke("setError$", "setError(int)", typeof(void), typeof(int), errorCode);
		}
		/// <remarks>
		///  Sets the error text. It should be called when an error
		///  is encountered in the job, just before calling emitResult().
		/// <param> name="errorText" the error text
		/// </param></remarks>		<short>    Sets the error text.</short>
		/// 		<see> emitResult</see>
		protected void SetErrorText(string errorText) {
			interceptor.Invoke("setErrorText$", "setErrorText(const QString&)", typeof(void), typeof(string), errorText);
		}
		/// <remarks>
		///  Sets the processed size. The processedAmount() and percent() signals
		///  are emitted if the values changed. The percent() signal is emitted
		///  only for the progress unit.
		/// <param> name="unit" the unit of the new processed amount
		/// </param><param> name="amount" the new processed amount
		///      </param></remarks>		<short>    Sets the processed size.</short>
		protected void SetProcessedAmount(KJob.Unit unit, ulong amount) {
			interceptor.Invoke("setProcessedAmount$$", "setProcessedAmount(KJob::Unit, qulonglong)", typeof(void), typeof(KJob.Unit), unit, typeof(ulong), amount);
		}
		/// <remarks>
		///  Sets the total size. The totalSize() and percent() signals
		///  are emitted if the values changed. The percent() signal is emitted
		///  only for the progress unit.
		/// <param> name="unit" the unit of the new total amount
		/// </param><param> name="amount" the new total amount
		///      </param></remarks>		<short>    Sets the total size.</short>
		protected void SetTotalAmount(KJob.Unit unit, ulong amount) {
			interceptor.Invoke("setTotalAmount$$", "setTotalAmount(KJob::Unit, qulonglong)", typeof(void), typeof(KJob.Unit), unit, typeof(ulong), amount);
		}
		/// <remarks>
		///  Sets the overall progress of the job. The percent() signal
		///  is emitted if the value changed.
		/// <param> name="percentage" the new overall progress
		///      </param></remarks>		<short>    Sets the overall progress of the job.</short>
		protected void SetPercent(ulong percentage) {
			interceptor.Invoke("setPercent$", "setPercent(unsigned long)", typeof(void), typeof(ulong), percentage);
		}
		/// <remarks>
		///  Utility function to emit the result signal, and suicide this job.
		///  It first notifies the observers to hide the progress for this job using
		///  the finished() signal.
		/// </remarks>		<short>    Utility function to emit the result signal, and suicide this job.</short>
		/// 		<see> result</see>
		/// 		<see> finished</see>
		protected void EmitResult() {
			interceptor.Invoke("emitResult", "emitResult()", typeof(void));
		}
		/// <remarks>
		///  Utility function for inherited jobs.
		///  Emits the percent signal if bigger than previous value,
		///  after calculating it from the parameters.
		/// <param> name="processedAmount" the processed amount
		/// </param><param> name="totalAmount" the total amount
		/// </param></remarks>		<short>    Utility function for inherited jobs.</short>
		/// 		<see> percent</see>
		protected void EmitPercent(ulong processedAmount, ulong totalAmount) {
			interceptor.Invoke("emitPercent$$", "emitPercent(qulonglong, qulonglong)", typeof(void), typeof(ulong), processedAmount, typeof(ulong), totalAmount);
		}
		/// <remarks>
		///  Utility function for inherited jobs.
		///  Emits the speed signal and starts the timer for removing that info
		/// <param> name="speed" the speed in bytes/s
		///      </param></remarks>		<short>    Utility function for inherited jobs.</short>
		protected void EmitSpeed(ulong speed) {
			interceptor.Invoke("emitSpeed$", "emitSpeed(unsigned long)", typeof(void), typeof(ulong), speed);
		}
		protected new IKJobSignals Emit {
			get { return (IKJobSignals) Q_EMIT; }
		}
	}

	public interface IKJobSignals : IQObjectSignals {
		// void description(KJob* arg1,const QString& arg2,const QPair<QString, QString>& field1(QString(), QString()) arg3,const QPair<QString, QString>& field2(QString(), QString()) arg4); >>>> NOT CONVERTED
		// void description(KJob* arg1,const QString& arg2,const QPair<QString, QString>& field1(QString(), QString()) arg3); >>>> NOT CONVERTED
		/// <remarks>
		///  Emitted to display general description of this job. A description has
		///  a title and two optional fields which can be used to complete the
		///  description.
		///  Examples of titles are "Copying", "Creating resource", etc.
		///  The fields of the description can be "Source" with an URL, and,
		///  "Destination" with an URL for a "Copying" description.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="title" the general description of the job
		/// </param><param> name="field1" first field (localized name and value)
		/// </param><param> name="field2" second field (localized name and value)
		///      </param></remarks>		<short>    Emitted to display general description of this job.</short>
		[Q_SIGNAL("void description(KJob*, const QString&)")]
		void Description(KJob job, string title);
		/// <remarks>
		///  Emitted to display state information about this job.
		///  Examples of message are "Resolving host", "Connecting to host...", etc.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="plain" the info message
		/// </param><param> name="rich" the rich text version of the message, or string() is none is available
		///      </param></remarks>		<short>    Emitted to display state information about this job.</short>
		[Q_SIGNAL("void infoMessage(KJob*, const QString&, const QString&)")]
		void InfoMessage(KJob job, string plain, string rich);
		/// <remarks>
		///  Emitted to display state information about this job.
		///  Examples of message are "Resolving host", "Connecting to host...", etc.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="plain" the info message
		/// </param><param> name="rich" the rich text version of the message, or string() is none is available
		///      </param></remarks>		<short>    Emitted to display state information about this job.</short>
		[Q_SIGNAL("void infoMessage(KJob*, const QString&)")]
		void InfoMessage(KJob job, string plain);
		/// <remarks>
		///  Emitted to display a warning about this job.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="plain" the warning message
		/// </param><param> name="rich" the rich text version of the message, or string() is none is available
		///      </param></remarks>		<short>    Emitted to display a warning about this job.</short>
		[Q_SIGNAL("void warning(KJob*, const QString&, const QString&)")]
		void Warning(KJob job, string plain, string rich);
		/// <remarks>
		///  Emitted to display a warning about this job.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="plain" the warning message
		/// </param><param> name="rich" the rich text version of the message, or string() is none is available
		///      </param></remarks>		<short>    Emitted to display a warning about this job.</short>
		[Q_SIGNAL("void warning(KJob*, const QString&)")]
		void Warning(KJob job, string plain);
	}
}
