/*
 * Copyright (c) 1999 by Preston Brown <pbrown@kde.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <QListWidget>
#include <QTreeWidget>
#include <QLabel>
#include <QDir>
#include <qtextstream.h>
#include <QFile>
#include <QRegExp>
//Added by qt3to4:
#include <QVBoxLayout>
#include <QHBoxLayout>

#include <kmessagebox.h>
#include <kglobal.h>
#include <klocale.h>

#include "ppitem.h"
#include "pamview.h"

#include <stdlib.h>

PamView::PamView(QWidget *parent)
  : QWidget(parent)
{
  QHBoxLayout *topl = new QHBoxLayout(this);
  
  QVBoxLayout *leftl = new QVBoxLayout;
  topl->addLayout(leftl);
  
  QLabel *label = new QLabel(i18n("Available services:"), this);
  leftl->addWidget(label);
  
  servicesLB = new QListWidget(this);
  leftl->addWidget(servicesLB);
  
  propertiesLV = new QTreeWidget(this);
  QStringList columns;
  columns << i18n("Category")<<i18n("Level")<<i18n("Module");
  propertiesLV->setHeaderLabels(columns);
  propertiesLV->setAllColumnsShowFocus( true );
  topl->addWidget(propertiesLV);

  init();
}

PamView::~PamView()
{
}

void PamView::init()
{
  initServices();
}

void PamView::initServices()
{

  QDir d("/etc/pam.d");
  d.setFilter(QDir::Files|QDir::Readable);

  if (!d.exists()) {
    KMessageBox::error(this, i18n("/etc/pam.d folder does not exist.\n"
				  "Either your system does not have PAM support "
				  "or there is some other configuration problem."));
    exit(1);
  }

  QFileInfoList list = d.entryInfoList();
  for (int i = 0; i < list.size(); ++i) {
  	QFileInfo fi = list.at(i);
	new QListWidgetItem(fi.fileName(), servicesLB);
	QFile f(fi.filePath());
	if (f.open(QIODevice::ReadOnly)) {
			QTextStream t(&f);
			QString s;
			while (!t.atEnd()) {
    			s = t.readLine().trimmed();
    			if (s.isEmpty() || (s[0] == '#'))
      				continue;

    			PamPropertiesItem *item = new PamPropertiesItem(fi.filePath(),
                            	s.split(QRegExp("\\s"),QString::SkipEmptyParts),
                            	propertiesLV);
   		 		propertiesLV->addTopLevelItem(item);
      		}
     		 f.close();
		}
  }
}

#include "pamview.moc"
