#!/bin/sh

set -e

FETCH_VERSION="$1"
__WORKDIR=`mktemp -d --tmpdir=.`

correctVersion() {
    ACTION="$1"
    VERSION=`echo "$2" | sed s/\+dfsg//g`

    if [ "x$ACTION" = "x--release" ] ; then
	if [ "x$VERSION" = x1.0rc8 ] ; then
	    VERSION=1.0
	fi
    elif [ "x$ACTION" = "x--fetch" -a "x$VERSION" = x1.0 ] ; then 
	VERSION=1.0~rc8
    fi   
    echo "$VERSION"
}

choke() {
    rm -fr "$__WORKDIR"
    exit 1
}

__VERSION=`correctVersion --fetch "$FETCH_VERSION"` 

uscan --watchfile debian/source.fetch --force-download --destdir="$__WORKDIR" --download-version $__VERSION || choke
cd "$__WORKDIR"
__ZIP=`ls`
__NEW_VERSION=$(correctVersion --release `echo $__ZIP | sed "s/.*-\(.*\)\.zip/\1/g"`) 
unzip $__ZIP >/dev/null 2>&1 || choke
rm -f $__ZIP 
tar --exclude='*.class' --exclude='*.jar' -czf ../jarjar_$__NEW_VERSION+dfsg.orig.tar.gz *  || choke
cd ..
rm -fr "$__WORKDIR" && echo "Orig source: jarjar_$__NEW_VERSION+dfsg.orig.tar.gz." 
exit 0


