/*
 * local_system_ima.cpp - namespace localSystem, providing an interface for
 *                        transparent usage of operating-system-specific
 *                        functions
 *
 * Copyright (c) 2006-2007 Tobias Doerffel <tobydox/at/users/dot/sf/dot/net>
 *
 * This file is part of iTALC - http://italc.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "local_system_ima.h"

#include <QtCore/QDir>


namespace localSystem
{


void initialize( void )
{
	localSystem::initialize( NULL, "italc_master.log" );

#ifdef BUILD_WIN32
	if( QDir( "C:\\WINDOWS" ).exists() == FALSE )
	{
		QDir( "C:\\" ).mkdir( "WINDOWS" );
	}
#endif
}


} // end of namespace localSystem

