/* daemon.c generated by valac 0.16.1, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <unity.h>
#include "gwibber.h"
#include <dee.h>
#include <dee-icu.h>
#include <libaccounts-glib/accounts-glib.h>
#include <gio/gio.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>


#define UNITY_GWIBBER_TYPE_DAEMON (unity_gwibber_daemon_get_type ())
#define UNITY_GWIBBER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemon))
#define UNITY_GWIBBER_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonClass))
#define UNITY_GWIBBER_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GWIBBER_TYPE_DAEMON))
#define UNITY_GWIBBER_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GWIBBER_TYPE_DAEMON))
#define UNITY_GWIBBER_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonClass))

typedef struct _UnityGwibberDaemon UnityGwibberDaemon;
typedef struct _UnityGwibberDaemonClass UnityGwibberDaemonClass;
typedef struct _UnityGwibberDaemonPrivate UnityGwibberDaemonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dee_icu_term_filter_destroy0(var) ((var == NULL) ? NULL : (var = (dee_icu_term_filter_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define UNITY_GWIBBER_TYPE_CATEGORIES (unity_gwibber_categories_get_type ())
typedef struct _UnityGwibberDaemonUpdateGlobalSearchData UnityGwibberDaemonUpdateGlobalSearchData;
typedef struct _UnityGwibberDaemonUpdateScopeSearchData UnityGwibberDaemonUpdateScopeSearchData;
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))
#define __vala_JsonArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonArray_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _UnityGwibberDaemon {
	GObject parent_instance;
	UnityGwibberDaemonPrivate * priv;
};

struct _UnityGwibberDaemonClass {
	GObjectClass parent_class;
};

struct _UnityGwibberDaemonPrivate {
	UnityLens* lens;
	UnityScope* scope;
	UnityPreferencesManager* preferences;
	GwibberStreams* streams_service;
	GwibberService* service;
	GwibberAccounts* accounts;
	GwibberUtils* utils;
	DeeModel* _model;
	DeeModel* _streams_model;
	DeeFilter _sort_filter;
	DeeModelIter* _stream_iter_first;
	DeeModelIter* _stream_iter_last;
	DeeAnalyzer* _analyzer;
	DeeIndex* _index;
	DeeICUTermFilter* _ascii_filter;
	AgManager* _account_manager;
	gboolean _has_accounts;
};

typedef enum  {
	UNITY_GWIBBER_CATEGORIES_MESSAGES = 0,
	UNITY_GWIBBER_CATEGORIES_REPLIES,
	UNITY_GWIBBER_CATEGORIES_IMAGES,
	UNITY_GWIBBER_CATEGORIES_VIDEOS,
	UNITY_GWIBBER_CATEGORIES_LINKS,
	UNITY_GWIBBER_CATEGORIES_PRIVATE,
	UNITY_GWIBBER_CATEGORIES_PUBLIC
} UnityGwibberCategories;

struct _UnityGwibberDaemonUpdateGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityGwibberDaemon* self;
	UnityLensSearch* search;
	GCancellable* cancellable;
	UnityPreferencesManager* _tmp0_;
	UnityPreferencesManagerRemoteContent _tmp1_;
	UnityPreferencesManagerRemoteContent _tmp2_;
	UnityLensSearch* _tmp3_;
	DeeSerializableModel* _tmp4_;
	DeeSerializableModel* _tmp5_;
	UnityLensSearch* _tmp6_;
	UnityScope* _tmp7_;
	DeeSerializableModel* _tmp8_;
	DeeSerializableModel* _tmp9_;
	DeeSerializableModel* _tmp10_;
	DeeSerializableModel* results_model;
	UnityLensSearch* _tmp11_;
	gboolean _tmp12_;
	UnityLensSearch* _tmp13_;
	DeeSerializableModel* _tmp14_;
	UnityLensSearch* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	UnityLensSearch* _tmp18_;
};

struct _UnityGwibberDaemonUpdateScopeSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityGwibberDaemon* self;
	UnityLensSearch* search;
	GCancellable* cancellable;
	UnityPreferencesManager* _tmp0_;
	UnityPreferencesManagerRemoteContent _tmp1_;
	UnityPreferencesManagerRemoteContent _tmp2_;
	UnityLensSearch* _tmp3_;
	DeeSerializableModel* _tmp4_;
	DeeSerializableModel* _tmp5_;
	UnityLensSearch* _tmp6_;
	UnityLensSearch* _tmp7_;
	DeeSerializableModel* _tmp8_;
	DeeSerializableModel* _tmp9_;
	DeeSerializableModel* _tmp10_;
	DeeSerializableModel* results_model;
	DeeSerializableModel* _tmp11_;
	UnityLensSearch* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	DeeSerializableModel* _tmp15_;
	guint _tmp16_;
	UnityLensSearch* _tmp17_;
};

struct _Block1Data {
	int _ref_count_;
	UnityGwibberDaemon * self;
	DeeModel* model;
	DeeModelIter* iter;
	gchar* uri;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gchar* _account_id;
	gchar* _status_id;
	gboolean liked;
};

struct _Block3Data {
	int _ref_count_;
	UnityGwibberDaemon * self;
	GList* accts;
};


static gpointer unity_gwibber_daemon_parent_class = NULL;

#define UNITY_GWIBBER_BUS_NAME "com.canonical.Unity.Lens.Gwibber"
#define UNITY_GWIBBER_ICON_PATH DATADIR "/icons/unity-icon-theme/places/svg/"
GType unity_gwibber_daemon_get_type (void) G_GNUC_CONST;
#define UNITY_GWIBBER_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonPrivate))
enum  {
	UNITY_GWIBBER_DAEMON_DUMMY_PROPERTY
};
static void unity_gwibber_daemon_setup (UnityGwibberDaemon* self);
UnityPreview* unity_gwibber_daemon_preview (UnityGwibberDaemon* self, const gchar* uri);
static UnityPreview* _unity_gwibber_daemon_preview_unity_scope_preview_uri (UnityScope* _sender, const gchar* uri, gpointer self);
static void __lambda8_ (UnityGwibberDaemon* self);
static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gchar* __lambda9_ (UnityGwibberDaemon* self, UnityLensSearch* lens_search);
static gchar* ___lambda9__unity_scope_generate_search_key (UnityScope* _sender, UnityLensSearch* search, gpointer self);
static void __lambda10_ (UnityGwibberDaemon* self, UnityLensSearch* lens_search, UnitySearchType search_type, GCancellable* cancellable);
static void unity_gwibber_daemon_update_scope_search (UnityGwibberDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_gwibber_daemon_update_scope_search_finish (UnityGwibberDaemon* self, GAsyncResult* _res_);
static void unity_gwibber_daemon_update_global_search (UnityGwibberDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_gwibber_daemon_update_global_search_finish (UnityGwibberDaemon* self, GAsyncResult* _res_);
static void ___lambda10__unity_scope_search_changed (UnityScope* _sender, UnityLensSearch* search, UnitySearchType search_type, GCancellable* cancellable, gpointer self);
static void __lambda13_ (UnityGwibberDaemon* self, GObject* obj, GParamSpec* pspec);
static void ___lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda14_ (UnityGwibberDaemon* self);
static void ___lambda14__unity_scope_filters_changed (UnityScope* _sender, gpointer self);
static void __lambda15_ (UnityGwibberDaemon* self, GObject* obj, GParamSpec* pspec);
static void ___lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_gwibber_daemon_setup_gwibber (UnityGwibberDaemon* self);
static void unity_gwibber_daemon_populate_categories (UnityGwibberDaemon* self);
static void unity_gwibber_daemon_populate_filters (UnityGwibberDaemon* self);
static void __lambda3_ (UnityGwibberDaemon* self, DeeTermList* terms_in, DeeTermList* terms_out);
static void ___lambda3__dee_term_filter_func (DeeTermList* terms_in, DeeTermList* terms_out, gpointer self);
static gchar* __lambda4_ (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter);
static gchar* ___lambda4__dee_model_reader_func (DeeModel* model, DeeModelIter* iter, gpointer self);
static UnityCheckOptionFilter* unity_gwibber_daemon_create_account_filter (UnityGwibberDaemon* self);
static void __lambda2_ (UnityGwibberDaemon* self, GwibberAccount* source);
static void ___lambda2__gwibber_accounts_created (GwibberAccounts* _sender, GwibberAccount* account, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean unity_gwibber_daemon_is_empty_search (UnityGwibberDaemon* self, UnityLensSearch* search);
static void unity_gwibber_daemon_update_global_search_data_free (gpointer _data);
static gboolean unity_gwibber_daemon_update_global_search_co (UnityGwibberDaemonUpdateGlobalSearchData* _data_);
GType unity_gwibber_categories_get_type (void) G_GNUC_CONST;
static void unity_gwibber_daemon_update_results_model (UnityGwibberDaemon* self, DeeModel* results_model, const gchar* search, UnityGwibberCategories* category);
static void unity_gwibber_daemon_update_scope_search_data_free (gpointer _data);
static gboolean unity_gwibber_daemon_update_scope_search_co (UnityGwibberDaemonUpdateScopeSearchData* _data_);
static gint _____lambda11_ (UnityGwibberDaemon* self, DeeModelIter* a, DeeModelIter* b);
static gint ______lambda11__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint __lambda12_ (UnityGwibberDaemon* self, DeeModelIter* a, DeeModelIter* b);
static gint ___lambda12__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gboolean unity_gwibber_daemon_matches_filters (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter, GeeList* stream_ids, GeeList* account_ids);
static void unity_gwibber_daemon_add_result (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter, DeeModel* results_model);
static gchar** _variant_get1 (GVariant* value, int* result_length1);
static gchar* unity_gwibber_daemon_get_avatar_path (UnityGwibberDaemon* self, const gchar* uri);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void unity_gwibber_daemon_parse_comments (UnityGwibberDaemon* self, UnitySocialPreview* preview, const gchar* _comments);
static gchar** _variant_get2 (GVariant* value, int* result_length1);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static UnityActivationResponse* ____lambda5_ (Block2Data* _data2_, const gchar* source);
static UnityActivationResponse* _____lambda5__unity_preview_action_activated (UnityPreviewAction* _sender, const gchar* uri, gpointer self);
static UnityActivationResponse* _____lambda6_ (Block2Data* _data2_, const gchar* source);
static UnityActivationResponse* ______lambda6__unity_preview_action_activated (UnityPreviewAction* _sender, const gchar* uri, gpointer self);
static UnityActivationResponse* _____lambda7_ (Block2Data* _data2_, const gchar* source);
static GVariant* _variant_new3 (gboolean value);
static UnityActivationResponse* ______lambda7__unity_preview_action_activated (UnityPreviewAction* _sender, const gchar* uri, gpointer self);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static JsonArray* _vala_JsonArray_copy (JsonArray* self);
static void _vala_JsonObject_free (JsonObject* self);
static void _vala_JsonArray_free (JsonArray* self);
UnityGwibberDaemon* unity_gwibber_daemon_new (void);
UnityGwibberDaemon* unity_gwibber_daemon_construct (GType object_type);
static GObject * unity_gwibber_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _unity_gwibber_daemon___lambda16_ (Block3Data* _data3_, guint id);
static void __unity_gwibber_daemon___lambda16__ag_manager_enabled_event (AgManager* _sender, guint account_id, gpointer self);
static void unity_gwibber_daemon_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static UnityPreview* _unity_gwibber_daemon_preview_unity_scope_preview_uri (UnityScope* _sender, const gchar* uri, gpointer self) {
	UnityPreview* result;
	result = unity_gwibber_daemon_preview (self, uri);
	return result;
}


static void __lambda8_ (UnityGwibberDaemon* self) {
	UnityScope* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->scope;
	_tmp1_ = unity_scope_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		UnityScope* _tmp3_;
		_tmp3_ = self->priv->scope;
		unity_scope_queue_search_changed (_tmp3_, UNITY_SEARCH_TYPE_DEFAULT);
	}
}


static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda8_ (self);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar* __lambda9_ (UnityGwibberDaemon* self, UnityLensSearch* lens_search) {
	gchar* result = NULL;
	UnityLensSearch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (lens_search != NULL, NULL);
	_tmp0_ = lens_search;
	_tmp1_ = unity_lens_search_get_search_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* ___lambda9__unity_scope_generate_search_key (UnityScope* _sender, UnityLensSearch* search, gpointer self) {
	gchar* result;
	result = __lambda9_ (self, search);
	return result;
}


static void __lambda10_ (UnityGwibberDaemon* self, UnityLensSearch* lens_search, UnitySearchType search_type, GCancellable* cancellable) {
	UnitySearchType _tmp0_;
	g_return_if_fail (lens_search != NULL);
	g_return_if_fail (cancellable != NULL);
	_tmp0_ = search_type;
	if (_tmp0_ == UNITY_SEARCH_TYPE_DEFAULT) {
		UnityLensSearch* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = lens_search;
		_tmp2_ = cancellable;
		unity_gwibber_daemon_update_scope_search (self, _tmp1_, _tmp2_, NULL, NULL);
	} else {
		UnityLensSearch* _tmp3_;
		GCancellable* _tmp4_;
		_tmp3_ = lens_search;
		_tmp4_ = cancellable;
		unity_gwibber_daemon_update_global_search (self, _tmp3_, _tmp4_, NULL, NULL);
	}
}


static void ___lambda10__unity_scope_search_changed (UnityScope* _sender, UnityLensSearch* search, UnitySearchType search_type, GCancellable* cancellable, gpointer self) {
	__lambda10_ (self, search, search_type, cancellable);
}


static void __lambda13_ (UnityGwibberDaemon* self, GObject* obj, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	UnityLens* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp7_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp1_ = self->priv->lens;
	_tmp2_ = unity_lens_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		UnityScope* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->scope;
		_tmp5_ = unity_scope_get_active (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		DeeModelIter* _tmp9_;
		DeeModel* _tmp10_;
		DeeModelIter* _tmp11_ = NULL;
		gboolean _tmp15_;
		_tmp9_ = self->priv->_stream_iter_first;
		_tmp10_ = self->priv->_model;
		_tmp11_ = dee_model_get_first_iter (_tmp10_);
		if (_tmp9_ != _tmp11_) {
			_tmp8_ = TRUE;
		} else {
			DeeModelIter* _tmp12_;
			DeeModel* _tmp13_;
			DeeModelIter* _tmp14_ = NULL;
			_tmp12_ = self->priv->_stream_iter_last;
			_tmp13_ = self->priv->_model;
			_tmp14_ = dee_model_get_last_iter (_tmp13_);
			_tmp8_ = _tmp12_ != _tmp14_;
		}
		_tmp15_ = _tmp8_;
		if (_tmp15_) {
			UnityScope* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = self->priv->scope;
			_tmp17_ = unity_scope_get_active (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				UnityScope* _tmp19_;
				_tmp19_ = self->priv->scope;
				unity_scope_queue_search_changed (_tmp19_, UNITY_SEARCH_TYPE_DEFAULT);
			}
		}
	}
}


static void ___lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda13_ (self, _sender, pspec);
}


static void __lambda14_ (UnityGwibberDaemon* self) {
	UnityScope* _tmp0_;
	_tmp0_ = self->priv->scope;
	unity_scope_queue_search_changed (_tmp0_, UNITY_SEARCH_TYPE_DEFAULT);
}


static void ___lambda14__unity_scope_filters_changed (UnityScope* _sender, gpointer self) {
	__lambda14_ (self);
}


static void __lambda15_ (UnityGwibberDaemon* self, GObject* obj, GParamSpec* pspec) {
	UnityScope* _tmp0_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->scope;
	unity_scope_queue_search_changed (_tmp0_, UNITY_SEARCH_TYPE_DEFAULT);
}


static void ___lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda15_ (self, _sender, pspec);
}


static void unity_gwibber_daemon_setup (UnityGwibberDaemon* self) {
	UnityScope* _tmp0_;
	UnityScope* _tmp1_;
	UnityScope* _tmp2_;
	UnityLens* _tmp3_;
	UnityLens* _tmp4_;
	UnityScope* _tmp5_;
	UnityScope* _tmp6_;
	UnityScope* _tmp7_;
	UnityScope* _tmp8_;
	UnityLens* _tmp9_;
	UnityScope* _tmp10_;
	UnityPreferencesManager* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_scope_new ("/com/canonical/unity/scope/gwibber");
	_g_object_unref0 (self->priv->scope);
	self->priv->scope = _tmp0_;
	_tmp1_ = self->priv->scope;
	unity_scope_set_search_in_global (_tmp1_, FALSE);
	_tmp2_ = self->priv->scope;
	g_signal_connect_object (_tmp2_, "preview-uri", (GCallback) _unity_gwibber_daemon_preview_unity_scope_preview_uri, self, 0);
	_tmp3_ = self->priv->lens;
	unity_lens_set_visible (_tmp3_, TRUE);
	_tmp4_ = self->priv->lens;
	_tmp5_ = self->priv->scope;
	unity_lens_add_local_scope (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->scope;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::active", (GCallback) ___lambda8__g_object_notify, self, 0);
	_tmp7_ = self->priv->scope;
	g_signal_connect_object (_tmp7_, "generate-search-key", (GCallback) ___lambda9__unity_scope_generate_search_key, self, 0);
	_tmp8_ = self->priv->scope;
	g_signal_connect_object (_tmp8_, "search-changed", (GCallback) ___lambda10__unity_scope_search_changed, self, 0);
	_tmp9_ = self->priv->lens;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::active", (GCallback) ___lambda13__g_object_notify, self, 0);
	_tmp10_ = self->priv->scope;
	g_signal_connect_object (_tmp10_, "filters-changed", (GCallback) ___lambda14__unity_scope_filters_changed, self, 0);
	_tmp11_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::remote-content-search", (GCallback) ___lambda15__g_object_notify, self, 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda3_ (UnityGwibberDaemon* self, DeeTermList* terms_in, DeeTermList* terms_out) {
	g_return_if_fail (terms_in != NULL);
	g_return_if_fail (terms_out != NULL);
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				guint _tmp3_;
				DeeTermList* _tmp4_;
				guint _tmp5_ = 0U;
				DeeTermList* _tmp6_;
				guint _tmp7_;
				const gchar* _tmp8_ = NULL;
				const gchar* term;
				DeeICUTermFilter* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* folded;
				DeeTermList* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = terms_in;
				_tmp5_ = dee_term_list_num_terms (_tmp4_);
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				_tmp6_ = terms_in;
				_tmp7_ = i;
				_tmp8_ = dee_term_list_get_term (_tmp6_, _tmp7_);
				term = _tmp8_;
				_tmp9_ = self->priv->_ascii_filter;
				_tmp10_ = term;
				_tmp11_ = dee_icu_term_filter_apply (_tmp9_, _tmp10_);
				folded = _tmp11_;
				_tmp12_ = terms_out;
				_tmp13_ = term;
				dee_term_list_add_term (_tmp12_, _tmp13_);
				_tmp14_ = folded;
				_tmp15_ = term;
				if (g_strcmp0 (_tmp14_, _tmp15_) != 0) {
					DeeTermList* _tmp16_;
					const gchar* _tmp17_;
					_tmp16_ = terms_out;
					_tmp17_ = folded;
					dee_term_list_add_term (_tmp16_, _tmp17_);
				}
				_g_free0 (folded);
			}
		}
	}
}


static void ___lambda3__dee_term_filter_func (DeeTermList* terms_in, DeeTermList* terms_out, gpointer self) {
	__lambda3_ (self, terms_in, terms_out);
}


static gchar* __lambda4_ (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter) {
	gchar* result = NULL;
	GwibberStreamModelColumn sender_col;
	GwibberStreamModelColumn msg_col;
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	DeeModel* _tmp3_;
	DeeModelIter* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	sender_col = GWIBBER_STREAM_MODEL_COLUMN_SENDER;
	msg_col = GWIBBER_STREAM_MODEL_COLUMN_MESSAGE;
	_tmp0_ = model;
	_tmp1_ = iter;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) sender_col);
	_tmp3_ = model;
	_tmp4_ = iter;
	_tmp5_ = dee_model_get_string (_tmp3_, _tmp4_, (guint) msg_col);
	_tmp6_ = g_strdup_printf ("%s\n%s", _tmp2_, _tmp5_);
	result = _tmp6_;
	return result;
}


static gchar* ___lambda4__dee_model_reader_func (DeeModel* model, DeeModelIter* iter, gpointer self) {
	gchar* result;
	result = __lambda4_ (self, model, iter);
	return result;
}


static void unity_gwibber_daemon_setup_gwibber (UnityGwibberDaemon* self) {
	GwibberStreams* _tmp0_;
	GwibberService* _tmp1_;
	GwibberUtils* _tmp2_;
	GwibberAccounts* _tmp3_;
	GwibberStreams* _tmp4_;
	DeeModel* _tmp5_;
	DeeModel* _tmp6_;
	DeeModel* _tmp7_;
	DeeFilter _tmp8_ = {0};
	DeeModel* _tmp9_;
	DeeFilter _tmp10_;
	DeeFilterModel* _tmp11_;
	DeeICUTermFilter* _tmp12_;
	DeeTextAnalyzer* _tmp13_;
	DeeAnalyzer* _tmp14_;
	DeeModelReader _tmp15_ = {0};
	DeeModelReader reader;
	DeeModel* _tmp16_;
	DeeAnalyzer* _tmp17_;
	DeeModelReader _tmp18_;
	DeeTreeIndex* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gwibber_streams_new ();
	_g_object_unref0 (self->priv->streams_service);
	self->priv->streams_service = _tmp0_;
	_tmp1_ = gwibber_service_new ();
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp1_;
	_tmp2_ = gwibber_utils_new ();
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp2_;
	_tmp3_ = gwibber_accounts_new ();
	_g_object_unref0 (self->priv->accounts);
	self->priv->accounts = _tmp3_;
	unity_gwibber_daemon_populate_categories (self);
	unity_gwibber_daemon_populate_filters (self);
	_tmp4_ = self->priv->streams_service;
	_tmp5_ = gwibber_streams_get_stream_model (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->_streams_model);
	self->priv->_streams_model = _tmp7_;
	setlocale (LC_COLLATE, "C");
	dee_filter_new_collator_desc ((guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTAMP, &_tmp8_);
	self->priv->_sort_filter = _tmp8_;
	_tmp9_ = self->priv->_streams_model;
	_tmp10_ = self->priv->_sort_filter;
	_tmp11_ = (DeeFilterModel*) dee_filter_model_new (_tmp9_, &_tmp10_);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = (DeeModel*) _tmp11_;
	_tmp12_ = dee_icu_term_filter_new_ascii_folder ();
	_dee_icu_term_filter_destroy0 (self->priv->_ascii_filter);
	self->priv->_ascii_filter = _tmp12_;
	_tmp13_ = dee_text_analyzer_new ();
	_g_object_unref0 (self->priv->_analyzer);
	self->priv->_analyzer = (DeeAnalyzer*) _tmp13_;
	_tmp14_ = self->priv->_analyzer;
	dee_analyzer_add_term_filter (_tmp14_, ___lambda3__dee_term_filter_func, g_object_ref (self), g_object_unref);
	dee_model_reader_new (___lambda4__dee_model_reader_func, g_object_ref (self), g_object_unref, &_tmp15_);
	reader = _tmp15_;
	_tmp16_ = self->priv->_model;
	_tmp17_ = self->priv->_analyzer;
	_tmp18_ = reader;
	_tmp19_ = dee_tree_index_new (_tmp16_, _tmp17_, &_tmp18_);
	_g_object_unref0 (self->priv->_index);
	self->priv->_index = (DeeIndex*) _tmp19_;
}


static void __lambda2_ (UnityGwibberDaemon* self, GwibberAccount* source) {
	g_return_if_fail (source != NULL);
}


static void ___lambda2__gwibber_accounts_created (GwibberAccounts* _sender, GwibberAccount* account, gpointer self) {
	__lambda2_ (self, account);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void unity_gwibber_daemon_populate_filters (UnityGwibberDaemon* self) {
	GList* filters;
	UnityLens* _tmp26_;
	GwibberAccounts* _tmp27_;
	g_return_if_fail (self != NULL);
	filters = NULL;
	{
		const gchar* _tmp0_ = NULL;
		UnityCheckOptionFilter* _tmp1_;
		UnityCheckOptionFilter* filter;
		const gchar* _tmp2_ = NULL;
		UnityFilterOption* _tmp3_ = NULL;
		UnityFilterOption* _tmp4_;
		const gchar* _tmp5_ = NULL;
		UnityFilterOption* _tmp6_ = NULL;
		UnityFilterOption* _tmp7_;
		const gchar* _tmp8_ = NULL;
		UnityFilterOption* _tmp9_ = NULL;
		UnityFilterOption* _tmp10_;
		const gchar* _tmp11_ = NULL;
		UnityFilterOption* _tmp12_ = NULL;
		UnityFilterOption* _tmp13_;
		const gchar* _tmp14_ = NULL;
		UnityFilterOption* _tmp15_ = NULL;
		UnityFilterOption* _tmp16_;
		const gchar* _tmp17_ = NULL;
		UnityFilterOption* _tmp18_ = NULL;
		UnityFilterOption* _tmp19_;
		const gchar* _tmp20_ = NULL;
		UnityFilterOption* _tmp21_ = NULL;
		UnityFilterOption* _tmp22_;
		UnityFilter* _tmp23_;
		_tmp0_ = _ ("Stream");
		_tmp1_ = unity_check_option_filter_new ("stream", _tmp0_, NULL, FALSE);
		filter = _tmp1_;
		_tmp2_ = _ ("Messages");
		_tmp3_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "messages", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		_tmp5_ = _ ("Replies");
		_tmp6_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "replies", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		_tmp8_ = _ ("Images");
		_tmp9_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "images", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_tmp11_ = _ ("Videos");
		_tmp12_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "videos", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp13_);
		_tmp14_ = _ ("Links");
		_tmp15_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "links", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
		_tmp17_ = _ ("Private");
		_tmp18_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "private", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp19_);
		_tmp20_ = _ ("Public");
		_tmp21_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "public", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp22_);
		_tmp23_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp23_);
		_g_object_unref0 (filter);
	}
	{
		UnityCheckOptionFilter* _tmp24_ = NULL;
		UnityCheckOptionFilter* filter;
		UnityFilter* _tmp25_;
		_tmp24_ = unity_gwibber_daemon_create_account_filter (self);
		filter = _tmp24_;
		_tmp25_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp25_);
		_g_object_unref0 (filter);
	}
	_tmp26_ = self->priv->lens;
	unity_lens_set_filters (_tmp26_, filters);
	_tmp27_ = self->priv->accounts;
	g_signal_connect_object (_tmp27_, "created", (GCallback) ___lambda2__gwibber_accounts_created, self, 0);
	__g_list_free__g_object_unref0_0 (filters);
}


static UnityCheckOptionFilter* unity_gwibber_daemon_create_account_filter (UnityGwibberDaemon* self) {
	UnityCheckOptionFilter* result = NULL;
	GIcon* icon = NULL;
	GFile* icon_file = NULL;
	const gchar* _tmp0_ = NULL;
	UnityCheckOptionFilter* _tmp1_;
	UnityCheckOptionFilter* filter;
	GwibberAccounts* _tmp2_;
	GList* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Account");
	_tmp1_ = unity_check_option_filter_new ("account_id", _tmp0_, NULL, FALSE);
	filter = _tmp1_;
	_tmp2_ = self->priv->accounts;
	_tmp3_ = gwibber_accounts_list (_tmp2_);
	{
		GList* _acct_collection = NULL;
		GList* _acct_it = NULL;
		_acct_collection = _tmp3_;
		for (_acct_it = _acct_collection; _acct_it != NULL; _acct_it = _acct_it->next) {
			GwibberAccount* _tmp4_;
			GwibberAccount* _acct = NULL;
			_tmp4_ = _g_object_ref0 ((GwibberAccount*) _acct_it->data);
			_acct = _tmp4_;
			{
				GwibberAccount* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GwibberAccount* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				GFile* _tmp21_ = NULL;
				GFile* _tmp22_;
				GFileIcon* _tmp23_;
				UnityCheckOptionFilter* _tmp24_;
				GwibberAccount* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				GwibberAccount* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				GwibberAccount* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				GIcon* _tmp38_;
				UnityFilterOption* _tmp39_ = NULL;
				UnityFilterOption* _tmp40_;
				_tmp5_ = _acct;
				_tmp6_ = gwibber_account_get_service (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (PKGDATADIR "/plugins/", _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strconcat (_tmp9_, "/ui/icons/16x16/", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = _acct;
				_tmp13_ = gwibber_account_get_service (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp16_, ".png", NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_build_filename (_tmp18_, NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_file_new_for_path (_tmp20_);
				_g_object_unref0 (icon_file);
				icon_file = _tmp21_;
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
				_tmp22_ = icon_file;
				_tmp23_ = (GFileIcon*) g_file_icon_new (_tmp22_);
				_g_object_unref0 (icon);
				icon = (GIcon*) _tmp23_;
				_tmp24_ = filter;
				_tmp25_ = _acct;
				_tmp26_ = gwibber_account_get_id (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _acct;
				_tmp29_ = gwibber_account_get_service (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp30_, "/", NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = _acct;
				_tmp34_ = gwibber_account_get_username (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
				_tmp37_ = _tmp36_;
				_tmp38_ = icon;
				_tmp39_ = unity_options_filter_add_option ((UnityOptionsFilter*) _tmp24_, _tmp27_, _tmp37_, _tmp38_);
				_tmp40_ = _tmp39_;
				_g_object_unref0 (_tmp40_);
				_g_free0 (_tmp37_);
				_g_free0 (_tmp32_);
				_g_object_unref0 (_acct);
			}
		}
		__g_list_free__g_object_unref0_0 (_acct_collection);
	}
	result = filter;
	_g_object_unref0 (icon_file);
	_g_object_unref0 (icon);
	return result;
}


static void unity_gwibber_daemon_populate_categories (UnityGwibberDaemon* self) {
	GList* categories;
	GIcon* icon = NULL;
	GFile* _tmp0_ = NULL;
	GFile* icon_dir;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFileIcon* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GIcon* _tmp5_;
	UnityCategory* _tmp6_;
	UnityCategory* cat;
	UnityCategory* _tmp7_;
	UnityCategory* _tmp8_;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_;
	GFileIcon* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GIcon* _tmp13_;
	UnityCategory* _tmp14_;
	UnityCategory* _tmp15_;
	UnityCategory* _tmp16_;
	GFile* _tmp17_ = NULL;
	GFile* _tmp18_;
	GFileIcon* _tmp19_;
	const gchar* _tmp20_ = NULL;
	GIcon* _tmp21_;
	UnityCategory* _tmp22_;
	UnityCategory* _tmp23_;
	UnityCategory* _tmp24_;
	GFile* _tmp25_ = NULL;
	GFile* _tmp26_;
	GFileIcon* _tmp27_;
	const gchar* _tmp28_ = NULL;
	GIcon* _tmp29_;
	UnityCategory* _tmp30_;
	UnityCategory* _tmp31_;
	UnityCategory* _tmp32_;
	GFile* _tmp33_ = NULL;
	GFile* _tmp34_;
	GFileIcon* _tmp35_;
	const gchar* _tmp36_ = NULL;
	GIcon* _tmp37_;
	UnityCategory* _tmp38_;
	UnityCategory* _tmp39_;
	UnityCategory* _tmp40_;
	GFile* _tmp41_ = NULL;
	GFile* _tmp42_;
	GFileIcon* _tmp43_;
	const gchar* _tmp44_ = NULL;
	GIcon* _tmp45_;
	UnityCategory* _tmp46_;
	UnityCategory* _tmp47_;
	UnityCategory* _tmp48_;
	GFile* _tmp49_ = NULL;
	GFile* _tmp50_;
	GFileIcon* _tmp51_;
	const gchar* _tmp52_ = NULL;
	GIcon* _tmp53_;
	UnityCategory* _tmp54_;
	UnityCategory* _tmp55_;
	UnityCategory* _tmp56_;
	UnityLens* _tmp57_;
	g_return_if_fail (self != NULL);
	categories = NULL;
	_tmp0_ = g_file_new_for_path ("/usr/share/gwibber/ui/icons/hicolor/scalable/places/");
	icon_dir = _tmp0_;
	_tmp1_ = g_file_get_child (icon_dir, "group-messages.svg");
	_tmp2_ = _tmp1_;
	_tmp3_ = (GFileIcon*) g_file_icon_new (_tmp2_);
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp4_ = _ ("Messages");
	_tmp5_ = icon;
	_tmp6_ = unity_category_new (_tmp4_, _tmp5_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	cat = _tmp6_;
	_tmp7_ = cat;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	categories = g_list_append (categories, _tmp8_);
	_tmp9_ = g_file_get_child (icon_dir, "group-replies.svg");
	_tmp10_ = _tmp9_;
	_tmp11_ = (GFileIcon*) g_file_icon_new (_tmp10_);
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp11_;
	_g_object_unref0 (_tmp10_);
	_tmp12_ = _ ("Replies");
	_tmp13_ = icon;
	_tmp14_ = unity_category_new (_tmp12_, _tmp13_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp14_;
	_tmp15_ = cat;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	categories = g_list_append (categories, _tmp16_);
	_tmp17_ = g_file_get_child (icon_dir, "group-images.svg");
	_tmp18_ = _tmp17_;
	_tmp19_ = (GFileIcon*) g_file_icon_new (_tmp18_);
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp19_;
	_g_object_unref0 (_tmp18_);
	_tmp20_ = _ ("Images");
	_tmp21_ = icon;
	_tmp22_ = unity_category_new (_tmp20_, _tmp21_, UNITY_CATEGORY_RENDERER_FLOW);
	_g_object_unref0 (cat);
	cat = _tmp22_;
	_tmp23_ = cat;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	categories = g_list_append (categories, _tmp24_);
	_tmp25_ = g_file_get_child (icon_dir, "group-videos.svg");
	_tmp26_ = _tmp25_;
	_tmp27_ = (GFileIcon*) g_file_icon_new (_tmp26_);
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp27_;
	_g_object_unref0 (_tmp26_);
	_tmp28_ = _ ("Videos");
	_tmp29_ = icon;
	_tmp30_ = unity_category_new (_tmp28_, _tmp29_, UNITY_CATEGORY_RENDERER_FLOW);
	_g_object_unref0 (cat);
	cat = _tmp30_;
	_tmp31_ = cat;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	categories = g_list_append (categories, _tmp32_);
	_tmp33_ = g_file_get_child (icon_dir, "group-links.svg");
	_tmp34_ = _tmp33_;
	_tmp35_ = (GFileIcon*) g_file_icon_new (_tmp34_);
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp35_;
	_g_object_unref0 (_tmp34_);
	_tmp36_ = _ ("Links");
	_tmp37_ = icon;
	_tmp38_ = unity_category_new (_tmp36_, _tmp37_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp38_;
	_tmp39_ = cat;
	_tmp40_ = _g_object_ref0 (_tmp39_);
	categories = g_list_append (categories, _tmp40_);
	_tmp41_ = g_file_get_child (icon_dir, "group-private.svg");
	_tmp42_ = _tmp41_;
	_tmp43_ = (GFileIcon*) g_file_icon_new (_tmp42_);
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp43_;
	_g_object_unref0 (_tmp42_);
	_tmp44_ = _ ("Private");
	_tmp45_ = icon;
	_tmp46_ = unity_category_new (_tmp44_, _tmp45_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp46_;
	_tmp47_ = cat;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	categories = g_list_append (categories, _tmp48_);
	_tmp49_ = g_file_get_child (icon_dir, "group-public.svg");
	_tmp50_ = _tmp49_;
	_tmp51_ = (GFileIcon*) g_file_icon_new (_tmp50_);
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp51_;
	_g_object_unref0 (_tmp50_);
	_tmp52_ = _ ("Public");
	_tmp53_ = icon;
	_tmp54_ = unity_category_new (_tmp52_, _tmp53_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp54_;
	_tmp55_ = cat;
	_tmp56_ = _g_object_ref0 (_tmp55_);
	categories = g_list_append (categories, _tmp56_);
	_tmp57_ = self->priv->lens;
	unity_lens_set_categories (_tmp57_, categories);
	_g_object_unref0 (cat);
	_g_object_unref0 (icon_dir);
	_g_object_unref0 (icon);
	__g_list_free__g_object_unref0_0 (categories);
}


static gboolean unity_gwibber_daemon_is_empty_search (UnityGwibberDaemon* self, UnityLensSearch* search) {
	gboolean result = FALSE;
	UnityLensSearch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (search != NULL, FALSE);
	_tmp0_ = search;
	_tmp1_ = unity_lens_search_get_search_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static void unity_gwibber_daemon_update_global_search_data_free (gpointer _data) {
	UnityGwibberDaemonUpdateGlobalSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityGwibberDaemonUpdateGlobalSearchData, _data_);
}


static void unity_gwibber_daemon_update_global_search (UnityGwibberDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityGwibberDaemonUpdateGlobalSearchData* _data_;
	UnityGwibberDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (UnityGwibberDaemonUpdateGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_gwibber_daemon_update_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_gwibber_daemon_update_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	unity_gwibber_daemon_update_global_search_co (_data_);
}


static void unity_gwibber_daemon_update_global_search_finish (UnityGwibberDaemon* self, GAsyncResult* _res_) {
	UnityGwibberDaemonUpdateGlobalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_gwibber_daemon_update_global_search_co (UnityGwibberDaemonUpdateGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->preferences;
	_data_->_tmp1_ = unity_preferences_manager_get_remote_content_search (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ != UNITY_PREFERENCES_MANAGER_REMOTE_CONTENT_ALL) {
		_data_->_tmp3_ = _data_->search;
		_data_->_tmp4_ = unity_lens_search_get_results_model (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		dee_model_clear ((DeeModel*) _data_->_tmp5_);
		_data_->_tmp6_ = _data_->search;
		g_signal_emit_by_name (_data_->_tmp6_, "finished");
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->scope;
	_data_->_tmp8_ = unity_scope_get_global_results_model (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
	_data_->results_model = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->search;
	_data_->_tmp12_ = FALSE;
	_data_->_tmp12_ = unity_gwibber_daemon_is_empty_search (_data_->self, _data_->_tmp11_);
	if (_data_->_tmp12_) {
		_data_->_tmp13_ = _data_->search;
		g_signal_emit_by_name (_data_->_tmp13_, "finished");
		_g_object_unref0 (_data_->results_model);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->results_model;
	_data_->_tmp15_ = _data_->search;
	_data_->_tmp16_ = unity_lens_search_get_search_string (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	unity_gwibber_daemon_update_results_model (_data_->self, (DeeModel*) _data_->_tmp14_, _data_->_tmp17_, NULL);
	_data_->_tmp18_ = _data_->search;
	g_signal_emit_by_name (_data_->_tmp18_, "finished");
	_g_object_unref0 (_data_->results_model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_gwibber_daemon_update_scope_search_data_free (gpointer _data) {
	UnityGwibberDaemonUpdateScopeSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityGwibberDaemonUpdateScopeSearchData, _data_);
}


static void unity_gwibber_daemon_update_scope_search (UnityGwibberDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityGwibberDaemonUpdateScopeSearchData* _data_;
	UnityGwibberDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (UnityGwibberDaemonUpdateScopeSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_gwibber_daemon_update_scope_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_gwibber_daemon_update_scope_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	unity_gwibber_daemon_update_scope_search_co (_data_);
}


static void unity_gwibber_daemon_update_scope_search_finish (UnityGwibberDaemon* self, GAsyncResult* _res_) {
	UnityGwibberDaemonUpdateScopeSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_gwibber_daemon_update_scope_search_co (UnityGwibberDaemonUpdateScopeSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->preferences;
	_data_->_tmp1_ = unity_preferences_manager_get_remote_content_search (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ != UNITY_PREFERENCES_MANAGER_REMOTE_CONTENT_ALL) {
		_data_->_tmp3_ = _data_->search;
		_data_->_tmp4_ = unity_lens_search_get_results_model (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		dee_model_clear ((DeeModel*) _data_->_tmp5_);
		_data_->_tmp6_ = _data_->search;
		g_signal_emit_by_name (_data_->_tmp6_, "finished");
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->search;
	_data_->_tmp8_ = unity_lens_search_get_results_model (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
	_data_->results_model = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->results_model;
	_data_->_tmp12_ = _data_->search;
	_data_->_tmp13_ = unity_lens_search_get_search_string (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	unity_gwibber_daemon_update_results_model (_data_->self, (DeeModel*) _data_->_tmp11_, _data_->_tmp14_, NULL);
	_data_->_tmp15_ = _data_->results_model;
	_data_->_tmp16_ = 0U;
	_data_->_tmp16_ = dee_model_get_n_rows ((DeeModel*) _data_->_tmp15_);
	g_debug ("daemon.vala:343: %u results", _data_->_tmp16_);
	_data_->_tmp17_ = _data_->search;
	g_signal_emit_by_name (_data_->_tmp17_, "finished");
	_g_object_unref0 (_data_->results_model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint _____lambda11_ (UnityGwibberDaemon* self, DeeModelIter* a, DeeModelIter* b) {
	gint result = 0;
	gint _tmp0_ = 0;
	DeeModelIter* _tmp1_;
	DeeModelIter* _tmp2_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = a;
	_tmp2_ = b;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = 0;
	} else {
		gint _tmp3_ = 0;
		DeeModelIter* _tmp4_;
		DeeModelIter* _tmp5_;
		gint _tmp6_;
		_tmp4_ = a;
		_tmp5_ = b;
		if (((void*) _tmp4_) > ((void*) _tmp5_)) {
			_tmp3_ = 1;
		} else {
			_tmp3_ = -1;
		}
		_tmp6_ = _tmp3_;
		_tmp0_ = _tmp6_;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


static gint ______lambda11__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = _____lambda11_ (self, a, b);
	return result;
}


static gint __lambda12_ (UnityGwibberDaemon* self, DeeModelIter* a, DeeModelIter* b) {
	gint result = 0;
	GwibberStreamModelColumn col;
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	DeeModel* _tmp3_;
	DeeModelIter* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	col = GWIBBER_STREAM_MODEL_COLUMN_TIMESTAMP;
	_tmp0_ = self->priv->_model;
	_tmp1_ = b;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) col);
	_tmp3_ = self->priv->_model;
	_tmp4_ = a;
	_tmp5_ = dee_model_get_string (_tmp3_, _tmp4_, (guint) col);
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
	result = _tmp6_;
	return result;
}


static gint ___lambda12__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda12_ (self, a, b);
	return result;
}


static void unity_gwibber_daemon_update_results_model (UnityGwibberDaemon* self, DeeModel* results_model, const gchar* search, UnityGwibberCategories* category) {
	DeeModelIter* iter = NULL;
	DeeModelIter* end = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* stream_ids;
	UnityScope* _tmp1_;
	UnityFilter* _tmp2_ = NULL;
	UnityCheckOptionFilter* filter;
	UnityCheckOptionFilter* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GeeArrayList* _tmp16_;
	GeeArrayList* account_ids;
	UnityScope* _tmp17_;
	UnityFilter* _tmp18_ = NULL;
	UnityCheckOptionFilter* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	DeeModel* _tmp32_;
	DeeModel* _tmp33_;
	DeeModel* _tmp34_;
	DeeModelIter* _tmp35_ = NULL;
	DeeModel* _tmp36_;
	DeeModelIter* _tmp37_ = NULL;
	DeeModel* _tmp38_;
	DeeModelIter* _tmp39_ = NULL;
	DeeModelIter* _tmp40_;
	GObject* _tmp41_ = NULL;
	GObject* _tmp42_;
	DeeTermList* term_list;
	DeeAnalyzer* _tmp43_;
	DeeICUTermFilter* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_;
	DeeTermList* _tmp48_;
	GSequence* _tmp49_;
	GSequence* matches;
	GSequence* _tmp87_;
	GSequence* _tmp88_;
	GSequenceIter* _tmp89_ = NULL;
	GSequenceIter* match_iter;
	GSequence* _tmp90_;
	GSequenceIter* _tmp91_ = NULL;
	GSequenceIter* match_end_iter;
	DeeTermList* _tmp106_;
	guint _tmp107_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	stream_ids = _tmp0_;
	_tmp1_ = self->priv->scope;
	_tmp2_ = unity_scope_get_filter (_tmp1_, "stream");
	filter = UNITY_IS_CHECK_OPTION_FILTER (_tmp2_) ? ((UnityCheckOptionFilter*) _tmp2_) : NULL;
	_tmp3_ = filter;
	_tmp4_ = unity_filter_get_filtering ((UnityFilter*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		UnityCheckOptionFilter* _tmp6_;
		GList* _tmp7_;
		_tmp6_ = filter;
		_tmp7_ = ((UnityOptionsFilter*) _tmp6_)->options;
		{
			GList* option_collection = NULL;
			GList* option_it = NULL;
			option_collection = _tmp7_;
			for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
				UnityFilterOption* _tmp8_;
				UnityFilterOption* option = NULL;
				_tmp8_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
				option = _tmp8_;
				{
					UnityFilterOption* _tmp9_;
					gboolean _tmp10_;
					gboolean _tmp11_;
					_tmp9_ = option;
					_tmp10_ = unity_filter_option_get_active (_tmp9_);
					_tmp11_ = _tmp10_;
					if (_tmp11_) {
						GeeArrayList* _tmp12_;
						UnityFilterOption* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						_tmp12_ = stream_ids;
						_tmp13_ = option;
						_tmp14_ = unity_filter_option_get_id (_tmp13_);
						_tmp15_ = _tmp14_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp15_);
					}
					_g_object_unref0 (option);
				}
			}
		}
	}
	_tmp16_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	account_ids = _tmp16_;
	_tmp17_ = self->priv->scope;
	_tmp18_ = unity_scope_get_filter (_tmp17_, "account_id");
	_g_object_unref0 (filter);
	filter = UNITY_IS_CHECK_OPTION_FILTER (_tmp18_) ? ((UnityCheckOptionFilter*) _tmp18_) : NULL;
	_tmp19_ = filter;
	_tmp20_ = unity_filter_get_filtering ((UnityFilter*) _tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_) {
		UnityCheckOptionFilter* _tmp22_;
		GList* _tmp23_;
		_tmp22_ = filter;
		_tmp23_ = ((UnityOptionsFilter*) _tmp22_)->options;
		{
			GList* option_collection = NULL;
			GList* option_it = NULL;
			option_collection = _tmp23_;
			for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
				UnityFilterOption* _tmp24_;
				UnityFilterOption* option = NULL;
				_tmp24_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
				option = _tmp24_;
				{
					UnityFilterOption* _tmp25_;
					gboolean _tmp26_;
					gboolean _tmp27_;
					_tmp25_ = option;
					_tmp26_ = unity_filter_option_get_active (_tmp25_);
					_tmp27_ = _tmp26_;
					if (_tmp27_) {
						GeeArrayList* _tmp28_;
						UnityFilterOption* _tmp29_;
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp28_ = account_ids;
						_tmp29_ = option;
						_tmp30_ = unity_filter_option_get_id (_tmp29_);
						_tmp31_ = _tmp30_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp31_);
					}
					_g_object_unref0 (option);
				}
			}
		}
	}
	_tmp32_ = results_model;
	dee_model_clear (_tmp32_);
	_tmp33_ = self->priv->_model;
	if (_tmp33_ == NULL) {
		unity_gwibber_daemon_setup_gwibber (self);
	}
	_tmp34_ = self->priv->_model;
	_tmp35_ = dee_model_get_first_iter (_tmp34_);
	iter = _tmp35_;
	_tmp36_ = self->priv->_model;
	_tmp37_ = dee_model_get_last_iter (_tmp36_);
	end = _tmp37_;
	_tmp38_ = self->priv->_model;
	_tmp39_ = dee_model_get_first_iter (_tmp38_);
	self->priv->_stream_iter_first = _tmp39_;
	_tmp40_ = end;
	self->priv->_stream_iter_last = _tmp40_;
	_tmp41_ = g_object_new (dee_term_list_get_type (), NULL);
	_tmp42_ = G_IS_INITIALLY_UNOWNED (_tmp41_) ? g_object_ref_sink (_tmp41_) : _tmp41_;
	term_list = DEE_IS_TERM_LIST (_tmp42_) ? ((DeeTermList*) _tmp42_) : NULL;
	_tmp43_ = self->priv->_analyzer;
	_tmp44_ = self->priv->_ascii_filter;
	_tmp45_ = search;
	_tmp46_ = dee_icu_term_filter_apply (_tmp44_, _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = term_list;
	dee_analyzer_tokenize (_tmp43_, _tmp47_, _tmp48_);
	_g_free0 (_tmp47_);
	_tmp49_ = g_sequence_new (NULL);
	matches = _tmp49_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp50_;
			_tmp50_ = TRUE;
			while (TRUE) {
				gboolean _tmp51_;
				guint _tmp53_;
				DeeTermList* _tmp54_;
				guint _tmp55_ = 0U;
				DeeIndex* _tmp56_;
				DeeTermList* _tmp57_;
				guint _tmp58_;
				const gchar* _tmp59_ = NULL;
				DeeResultSet* _tmp60_ = NULL;
				DeeResultSet* result_set;
				guint _tmp61_;
				gboolean first_pass;
				GCompareDataFunc cmp_func;
				void* cmp_func_target;
				GDestroyNotify cmp_func_target_destroy_notify;
				GSequence* _tmp62_;
				GSequence* remaining;
				gboolean _tmp81_;
				GSequence* _tmp83_;
				GSequenceIter* _tmp84_ = NULL;
				GSequence* _tmp85_;
				GSequenceIter* _tmp86_ = NULL;
				_tmp51_ = _tmp50_;
				if (!_tmp51_) {
					guint _tmp52_;
					_tmp52_ = i;
					i = _tmp52_ + 1;
				}
				_tmp50_ = FALSE;
				_tmp53_ = i;
				_tmp54_ = term_list;
				_tmp55_ = dee_term_list_num_terms (_tmp54_);
				if (!(_tmp53_ < _tmp55_)) {
					break;
				}
				_tmp56_ = self->priv->_index;
				_tmp57_ = term_list;
				_tmp58_ = i;
				_tmp59_ = dee_term_list_get_term (_tmp57_, _tmp58_);
				_tmp60_ = dee_index_lookup (_tmp56_, _tmp59_, DEE_TERM_MATCH_PREFIX);
				result_set = _tmp60_;
				_tmp61_ = i;
				first_pass = _tmp61_ == ((guint) 0);
				cmp_func = ______lambda11__gcompare_data_func;
				cmp_func_target = g_object_ref (self);
				cmp_func_target_destroy_notify = g_object_unref;
				_tmp62_ = g_sequence_new (NULL);
				remaining = _tmp62_;
				{
					DeeResultSet* _tmp63_;
					DeeResultSet* _tmp64_ = NULL;
					DeeResultSet* _item_it;
					DeeModelIter* item = NULL;
					_tmp63_ = result_set;
					_tmp64_ = _vala_dee_result_set_iterator (_tmp63_);
					_item_it = _tmp64_;
					while (TRUE) {
						DeeResultSet* _tmp65_;
						DeeModelIter* _tmp66_ = NULL;
						DeeModelIter* _tmp67_;
						gboolean _tmp68_;
						_tmp65_ = _item_it;
						_tmp66_ = _vala_dee_result_set_next_value (_tmp65_);
						item = _tmp66_;
						_tmp67_ = item;
						if (!(_tmp67_ != NULL)) {
							break;
						}
						_tmp68_ = first_pass;
						if (_tmp68_) {
							GSequence* _tmp69_;
							DeeModelIter* _tmp70_;
							GCompareDataFunc _tmp71_;
							void* _tmp71__target;
							GSequenceIter* _tmp72_ = NULL;
							_tmp69_ = matches;
							_tmp70_ = item;
							_tmp71_ = cmp_func;
							_tmp71__target = cmp_func_target;
							_tmp72_ = g_sequence_insert_sorted (_tmp69_, _tmp70_, _tmp71_, _tmp71__target);
						} else {
							GSequence* _tmp73_;
							DeeModelIter* _tmp74_;
							GCompareDataFunc _tmp75_;
							void* _tmp75__target;
							GSequenceIter* _tmp76_ = NULL;
							_tmp73_ = matches;
							_tmp74_ = item;
							_tmp75_ = cmp_func;
							_tmp75__target = cmp_func_target;
							_tmp76_ = g_sequence_lookup (_tmp73_, _tmp74_, _tmp75_, _tmp75__target);
							if (_tmp76_ != NULL) {
								GSequence* _tmp77_;
								DeeModelIter* _tmp78_;
								GCompareDataFunc _tmp79_;
								void* _tmp79__target;
								GSequenceIter* _tmp80_ = NULL;
								_tmp77_ = remaining;
								_tmp78_ = item;
								_tmp79_ = cmp_func;
								_tmp79__target = cmp_func_target;
								_tmp80_ = g_sequence_insert_sorted (_tmp77_, _tmp78_, _tmp79_, _tmp79__target);
							}
						}
					}
					_g_object_unref0 (_item_it);
				}
				_tmp81_ = first_pass;
				if (!_tmp81_) {
					GSequence* _tmp82_;
					_tmp82_ = remaining;
					remaining = NULL;
					_g_sequence_free0 (matches);
					matches = _tmp82_;
				}
				_tmp83_ = matches;
				_tmp84_ = g_sequence_get_begin_iter (_tmp83_);
				_tmp85_ = matches;
				_tmp86_ = g_sequence_get_end_iter (_tmp85_);
				if (_tmp84_ == _tmp86_) {
					_g_sequence_free0 (remaining);
					(cmp_func_target_destroy_notify == NULL) ? NULL : (cmp_func_target_destroy_notify (cmp_func_target), NULL);
					cmp_func = NULL;
					cmp_func_target = NULL;
					cmp_func_target_destroy_notify = NULL;
					_g_object_unref0 (result_set);
					break;
				}
				_g_sequence_free0 (remaining);
				(cmp_func_target_destroy_notify == NULL) ? NULL : (cmp_func_target_destroy_notify (cmp_func_target), NULL);
				cmp_func = NULL;
				cmp_func_target = NULL;
				cmp_func_target_destroy_notify = NULL;
				_g_object_unref0 (result_set);
			}
		}
	}
	_tmp87_ = matches;
	g_sequence_sort (_tmp87_, ___lambda12__gcompare_data_func, self);
	_tmp88_ = matches;
	_tmp89_ = g_sequence_get_begin_iter (_tmp88_);
	match_iter = _tmp89_;
	_tmp90_ = matches;
	_tmp91_ = g_sequence_get_end_iter (_tmp90_);
	match_end_iter = _tmp91_;
	while (TRUE) {
		GSequenceIter* _tmp92_;
		GSequenceIter* _tmp93_;
		GSequenceIter* _tmp94_;
		gconstpointer _tmp95_ = NULL;
		DeeModel* _tmp96_;
		DeeModelIter* _tmp97_;
		GeeArrayList* _tmp98_;
		GeeArrayList* _tmp99_;
		gboolean _tmp100_ = FALSE;
		GSequenceIter* _tmp104_;
		GSequenceIter* _tmp105_ = NULL;
		_tmp92_ = match_iter;
		_tmp93_ = match_end_iter;
		if (!(_tmp92_ != _tmp93_)) {
			break;
		}
		_tmp94_ = match_iter;
		_tmp95_ = g_sequence_get (_tmp94_);
		iter = (DeeModelIter*) _tmp95_;
		_tmp96_ = self->priv->_model;
		_tmp97_ = iter;
		_tmp98_ = stream_ids;
		_tmp99_ = account_ids;
		_tmp100_ = unity_gwibber_daemon_matches_filters (self, _tmp96_, _tmp97_, (GeeList*) _tmp98_, (GeeList*) _tmp99_);
		if (_tmp100_) {
			DeeModel* _tmp101_;
			DeeModelIter* _tmp102_;
			DeeModel* _tmp103_;
			_tmp101_ = self->priv->_model;
			_tmp102_ = iter;
			_tmp103_ = results_model;
			unity_gwibber_daemon_add_result (self, _tmp101_, _tmp102_, _tmp103_);
		}
		_tmp104_ = match_iter;
		_tmp105_ = g_sequence_iter_next (_tmp104_);
		match_iter = _tmp105_;
	}
	_tmp106_ = term_list;
	_tmp107_ = dee_term_list_num_terms (_tmp106_);
	if (_tmp107_ > ((guint) 0)) {
		_g_sequence_free0 (matches);
		_g_object_unref0 (term_list);
		_g_object_unref0 (account_ids);
		_g_object_unref0 (filter);
		_g_object_unref0 (stream_ids);
		return;
	}
	while (TRUE) {
		DeeModelIter* _tmp108_;
		DeeModelIter* _tmp109_;
		DeeModel* _tmp110_;
		DeeModelIter* _tmp111_;
		GeeArrayList* _tmp112_;
		GeeArrayList* _tmp113_;
		gboolean _tmp114_ = FALSE;
		DeeModel* _tmp118_;
		DeeModelIter* _tmp119_;
		DeeModelIter* _tmp120_ = NULL;
		_tmp108_ = iter;
		_tmp109_ = end;
		if (!(_tmp108_ != _tmp109_)) {
			break;
		}
		_tmp110_ = self->priv->_model;
		_tmp111_ = iter;
		_tmp112_ = stream_ids;
		_tmp113_ = account_ids;
		_tmp114_ = unity_gwibber_daemon_matches_filters (self, _tmp110_, _tmp111_, (GeeList*) _tmp112_, (GeeList*) _tmp113_);
		if (_tmp114_) {
			DeeModel* _tmp115_;
			DeeModelIter* _tmp116_;
			DeeModel* _tmp117_;
			_tmp115_ = self->priv->_model;
			_tmp116_ = iter;
			_tmp117_ = results_model;
			unity_gwibber_daemon_add_result (self, _tmp115_, _tmp116_, _tmp117_);
		}
		_tmp118_ = self->priv->_model;
		_tmp119_ = iter;
		_tmp120_ = dee_model_next (_tmp118_, _tmp119_);
		iter = _tmp120_;
	}
	_g_sequence_free0 (matches);
	_g_object_unref0 (term_list);
	_g_object_unref0 (account_ids);
	_g_object_unref0 (filter);
	_g_object_unref0 (stream_ids);
}


static gchar** _variant_get1 (GVariant* value, int* result_length1) {
	gchar** _tmp16_;
	int _tmp16__length;
	int _tmp16__size;
	int _tmp16__length1;
	GVariantIter _tmp17_;
	GVariant* _tmp18_;
	_tmp16_ = g_new (gchar*, 5);
	_tmp16__length = 0;
	_tmp16__size = 4;
	_tmp16__length1 = 0;
	g_variant_iter_init (&_tmp17_, value);
	for (; (_tmp18_ = g_variant_iter_next_value (&_tmp17_)) != NULL; _tmp16__length1++) {
		if (_tmp16__size == _tmp16__length) {
			_tmp16__size = 2 * _tmp16__size;
			_tmp16_ = g_renew (gchar*, _tmp16_, _tmp16__size + 1);
		}
		_tmp16_[_tmp16__length++] = g_variant_dup_string (_tmp18_, NULL);
		g_variant_unref (_tmp18_);
	}
	*result_length1 = _tmp16__length1;
	_tmp16_[_tmp16__length] = NULL;
	return _tmp16_;
}


static gboolean unity_gwibber_daemon_matches_filters (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter, GeeList* stream_ids, GeeList* account_ids) {
	gboolean result = FALSE;
	gboolean stream_match;
	gboolean account_match;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp35_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	g_return_val_if_fail (stream_ids != NULL, FALSE);
	g_return_val_if_fail (account_ids != NULL, FALSE);
	stream_match = TRUE;
	account_match = TRUE;
	_tmp0_ = stream_ids;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeList* _tmp3_;
		DeeModel* _tmp4_;
		DeeModelIter* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = stream_ids;
		_tmp4_ = model;
		_tmp5_ = iter;
		_tmp6_ = dee_model_get_string (_tmp4_, _tmp5_, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
		_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp6_);
		stream_match = _tmp7_;
	}
	_tmp8_ = account_ids;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		DeeModel* _tmp11_;
		DeeModelIter* _tmp12_;
		GVariant* _tmp13_ = NULL;
		GVariant* _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _accounts_array;
		gint _accounts_array_length1;
		gint __accounts_array_size_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		_tmp11_ = model;
		_tmp12_ = iter;
		_tmp13_ = dee_model_get_value (_tmp11_, _tmp12_, (guint) GWIBBER_STREAM_MODEL_COLUMN_ACCOUNTS);
		_tmp14_ = _tmp13_;
		_tmp15_ = _variant_get1 (_tmp14_, &_tmp15__length1);
		_tmp19_ = _tmp15_;
		_tmp19__length1 = _tmp15__length1;
		_g_variant_unref0 (_tmp14_);
		_accounts_array = _tmp19_;
		_accounts_array_length1 = _tmp19__length1;
		__accounts_array_size_ = _accounts_array_length1;
		_tmp20_ = _accounts_array;
		_tmp20__length1 = _accounts_array_length1;
		{
			gchar** a_collection = NULL;
			gint a_collection_length1 = 0;
			gint _a_collection_size_ = 0;
			gint a_it = 0;
			a_collection = _tmp20_;
			a_collection_length1 = _tmp20__length1;
			for (a_it = 0; a_it < _tmp20__length1; a_it = a_it + 1) {
				gchar* _tmp21_;
				gchar* a = NULL;
				_tmp21_ = g_strdup (a_collection[a_it]);
				a = _tmp21_;
				{
					const gchar* _tmp22_;
					gchar** _tmp23_;
					gchar** _tmp24_ = NULL;
					gchar** _tmp25_;
					gint _tmp25__length1;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _account;
					GeeList* _tmp29_;
					const gchar* _tmp30_;
					gboolean _tmp31_ = FALSE;
					_tmp22_ = a;
					_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, ":", 0);
					_tmp25_ = _tmp24_;
					_tmp25__length1 = _vala_array_length (_tmp23_);
					_tmp26_ = _tmp25_[0];
					_tmp27_ = g_strdup (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
					_account = _tmp28_;
					_tmp29_ = account_ids;
					_tmp30_ = _account;
					_tmp31_ = gee_collection_contains ((GeeCollection*) _tmp29_, _tmp30_);
					if (!_tmp31_) {
						account_match = FALSE;
					}
					_g_free0 (_account);
					_g_free0 (a);
				}
			}
		}
		_accounts_array = (_vala_array_free (_accounts_array, _accounts_array_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp33_ = account_match;
	if (_tmp33_) {
		gboolean _tmp34_;
		_tmp34_ = stream_match;
		_tmp32_ = _tmp34_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp35_ = _tmp32_;
	result = _tmp35_;
	return result;
}


static void unity_gwibber_daemon_add_result (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter, DeeModel* results_model) {
	UnityGwibberCategories group;
	gchar* _img_uri;
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* stream_id;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	static GQuark _tmp5_label6 = 0;
	DeeModel* _tmp7_;
	DeeModelIter* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _icon_uri;
	const gchar* _tmp11_;
	DeeModel* _tmp28_;
	DeeModel* _tmp29_;
	DeeModelIter* _tmp30_;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_;
	UnityGwibberCategories _tmp33_;
	DeeModel* _tmp34_;
	DeeModelIter* _tmp35_;
	const gchar* _tmp36_ = NULL;
	DeeModel* _tmp37_;
	DeeModelIter* _tmp38_;
	const gchar* _tmp39_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (results_model != NULL);
	group = UNITY_GWIBBER_CATEGORIES_MESSAGES;
	_img_uri = NULL;
	_tmp0_ = model;
	_tmp1_ = iter;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
	stream_id = _tmp2_;
	_tmp3_ = stream_id;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("messages")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_MESSAGES;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("replies")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_REPLIES;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("images")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_IMAGES;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("videos")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_VIDEOS;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("links")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_LINKS;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("private")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_PRIVATE;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("public")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_PUBLIC;
				break;
			}
		}
	}
	_tmp7_ = model;
	_tmp8_ = iter;
	_tmp9_ = dee_model_get_string (_tmp7_, _tmp8_, (guint) GWIBBER_STREAM_MODEL_COLUMN_ICON_URI);
	_tmp10_ = g_strdup (_tmp9_);
	_icon_uri = _tmp10_;
	_tmp11_ = stream_id;
	if (g_strcmp0 (_tmp11_, "images") == 0) {
		DeeModel* _tmp12_;
		DeeModelIter* _tmp13_;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp12_ = model;
		_tmp13_ = iter;
		_tmp14_ = dee_model_get_string (_tmp12_, _tmp13_, (guint) GWIBBER_STREAM_MODEL_COLUMN_IMG_SRC);
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (_img_uri);
		_img_uri = _tmp15_;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = stream_id;
		if (g_strcmp0 (_tmp16_, "videos") == 0) {
			DeeModel* _tmp17_;
			DeeModelIter* _tmp18_;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp17_ = model;
			_tmp18_ = iter;
			_tmp19_ = dee_model_get_string (_tmp17_, _tmp18_, (guint) GWIBBER_STREAM_MODEL_COLUMN_VIDEO_PIC);
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (_img_uri);
			_img_uri = _tmp20_;
			_tmp21_ = _img_uri;
			_tmp22_ = strlen (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_ < 1) {
				const gchar* _tmp24_;
				gchar* _tmp25_ = NULL;
				_tmp24_ = _icon_uri;
				_tmp25_ = unity_gwibber_daemon_get_avatar_path (self, _tmp24_);
				_g_free0 (_img_uri);
				_img_uri = _tmp25_;
			}
		} else {
			const gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			_tmp26_ = _icon_uri;
			_tmp27_ = unity_gwibber_daemon_get_avatar_path (self, _tmp26_);
			_g_free0 (_img_uri);
			_img_uri = _tmp27_;
		}
	}
	_tmp28_ = results_model;
	_tmp29_ = model;
	_tmp30_ = iter;
	_tmp31_ = dee_model_get_string (_tmp29_, _tmp30_, (guint) GWIBBER_STREAM_MODEL_COLUMN_URL);
	_tmp32_ = _img_uri;
	_tmp33_ = group;
	_tmp34_ = self->priv->_model;
	_tmp35_ = iter;
	_tmp36_ = dee_model_get_string (_tmp34_, _tmp35_, (guint) GWIBBER_STREAM_MODEL_COLUMN_SENDER);
	_tmp37_ = self->priv->_model;
	_tmp38_ = iter;
	_tmp39_ = dee_model_get_string (_tmp37_, _tmp38_, (guint) GWIBBER_STREAM_MODEL_COLUMN_MESSAGE);
	dee_model_append (_tmp28_, _tmp31_, _tmp32_, _tmp33_, "text/html", _tmp36_, _tmp39_, NULL);
	_g_free0 (_icon_uri);
	_g_free0 (_img_uri);
}


static gchar* unity_gwibber_daemon_get_avatar_path (UnityGwibberDaemon* self, const gchar* uri) {
	gchar* result = NULL;
	GwibberUtils* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _avatar_cache_image;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = self->priv->utils;
	_tmp1_ = uri;
	_tmp2_ = gwibber_utils_avatar_path (_tmp0_, _tmp1_);
	_avatar_cache_image = _tmp2_;
	_tmp3_ = _avatar_cache_image;
	if (_tmp3_ == NULL) {
		const gchar* _tmp8_;
		{
			GwibberService* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp4_ = self->priv->service;
			_tmp5_ = uri;
			_tmp6_ = gwibber_service_avatar_path (_tmp4_, _tmp5_, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			_g_free0 (_avatar_cache_image);
			_avatar_cache_image = _tmp7_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (_avatar_cache_image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = _avatar_cache_image;
		if (_tmp8_ == NULL) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = uri;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (_avatar_cache_image);
			_avatar_cache_image = _tmp10_;
		}
	}
	result = _avatar_cache_image;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		UnityGwibberDaemon * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->model);
		_g_free0 (_data1_->uri);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


static gchar** _variant_get2 (GVariant* value, int* result_length1) {
	gchar** _tmp132_;
	int _tmp132__length;
	int _tmp132__size;
	int _tmp132__length1;
	GVariantIter _tmp133_;
	GVariant* _tmp134_;
	_tmp132_ = g_new (gchar*, 5);
	_tmp132__length = 0;
	_tmp132__size = 4;
	_tmp132__length1 = 0;
	g_variant_iter_init (&_tmp133_, value);
	for (; (_tmp134_ = g_variant_iter_next_value (&_tmp133_)) != NULL; _tmp132__length1++) {
		if (_tmp132__size == _tmp132__length) {
			_tmp132__size = 2 * _tmp132__size;
			_tmp132_ = g_renew (gchar*, _tmp132_, _tmp132__size + 1);
		}
		_tmp132_[_tmp132__length++] = g_variant_dup_string (_tmp134_, NULL);
		g_variant_unref (_tmp134_);
	}
	*result_length1 = _tmp132__length1;
	_tmp132_[_tmp132__length] = NULL;
	return _tmp132_;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		UnityGwibberDaemon * self;
		self = _data2_->_data1_->self;
		_g_free0 (_data2_->_status_id);
		_g_free0 (_data2_->_account_id);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static UnityActivationResponse* ____lambda5_ (Block2Data* _data2_, const gchar* source) {
	Block1Data* _data1_;
	UnityGwibberDaemon * self;
	UnityActivationResponse* result = NULL;
	UnityActivationResponse* _tmp8_;
	UnityActivationResponse* _tmp9_;
	GError * _inner_error_ = NULL;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (source != NULL, NULL);
	{
		const gchar* _tmp0_;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		_tmp0_ = _data1_->uri;
		_tmp1_ = g_app_info_launch_default_for_uri (_tmp0_, NULL, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		if (_tmp2_) {
			UnityActivationResponse* _tmp3_;
			UnityActivationResponse* _tmp4_;
			_tmp3_ = unity_activation_response_new (UNITY_HANDLED_TYPE_HIDE_DASH, "");
			_tmp4_ = g_object_ref_sink (_tmp3_);
			result = _tmp4_;
			return result;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _data1_->uri;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("daemon.vala:630: Failed to launch default application for uri '%s': %s", _tmp5_, _tmp7_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
	_tmp9_ = g_object_ref_sink (_tmp8_);
	result = _tmp9_;
	return result;
}


static UnityActivationResponse* _____lambda5__unity_preview_action_activated (UnityPreviewAction* _sender, const gchar* uri, gpointer self) {
	UnityActivationResponse* result;
	result = ____lambda5_ (self, uri);
	return result;
}


static UnityActivationResponse* _____lambda6_ (Block2Data* _data2_, const gchar* source) {
	Block1Data* _data1_;
	UnityGwibberDaemon * self;
	UnityActivationResponse* result = NULL;
	GwibberService* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UnityActivationResponse* _tmp3_;
	UnityActivationResponse* _tmp4_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = self->priv->service;
	_tmp1_ = _data2_->_status_id;
	_tmp2_ = _data2_->_account_id;
	gwibber_service_retweet (_tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = unity_activation_response_new (UNITY_HANDLED_TYPE_SHOW_PREVIEW, "");
	_tmp4_ = g_object_ref_sink (_tmp3_);
	result = _tmp4_;
	return result;
}


static UnityActivationResponse* ______lambda6__unity_preview_action_activated (UnityPreviewAction* _sender, const gchar* uri, gpointer self) {
	UnityActivationResponse* result;
	result = _____lambda6_ (self, uri);
	return result;
}


static GVariant* _variant_new3 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static UnityActivationResponse* _____lambda7_ (Block2Data* _data2_, const gchar* source) {
	Block1Data* _data1_;
	UnityGwibberDaemon * self;
	UnityActivationResponse* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp10_;
	gboolean ret;
	gboolean _tmp11_;
	const gchar* _tmp16_;
	UnityPreview* _tmp17_ = NULL;
	UnityPreview* new_preview;
	UnityActivationResponse* _tmp18_;
	UnityActivationResponse* _tmp19_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp1_ = _data2_->liked;
	if (_tmp1_) {
		GwibberService* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = self->priv->service;
		_tmp3_ = _data2_->_status_id;
		_tmp4_ = _data2_->_account_id;
		_tmp5_ = gwibber_service_unlike (_tmp2_, _tmp3_, _tmp4_);
		_tmp0_ = _tmp5_;
	} else {
		GwibberService* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = self->priv->service;
		_tmp7_ = _data2_->_status_id;
		_tmp8_ = _data2_->_account_id;
		_tmp9_ = gwibber_service_like (_tmp6_, _tmp7_, _tmp8_);
		_tmp0_ = _tmp9_;
	}
	_tmp10_ = _tmp0_;
	ret = _tmp10_;
	_tmp11_ = ret;
	if (_tmp11_) {
		DeeModel* _tmp12_;
		DeeModelIter* _tmp13_;
		gboolean _tmp14_;
		GVariant* _tmp15_;
		_tmp12_ = _data1_->model;
		_tmp13_ = _data1_->iter;
		_tmp14_ = _data2_->liked;
		_tmp15_ = _variant_new3 (!_tmp14_);
		dee_model_set_value (_tmp12_, _tmp13_, (guint) GWIBBER_STREAM_MODEL_COLUMN_LIKED, _tmp15_);
	}
	_tmp16_ = _data1_->uri;
	_tmp17_ = unity_gwibber_daemon_preview (self, _tmp16_);
	new_preview = _tmp17_;
	_tmp18_ = unity_activation_response_new_with_preview (new_preview);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	result = _tmp19_;
	_g_object_unref0 (new_preview);
	return result;
}


static UnityActivationResponse* ______lambda7__unity_preview_action_activated (UnityPreviewAction* _sender, const gchar* uri, gpointer self) {
	UnityActivationResponse* result;
	result = _____lambda7_ (self, uri);
	return result;
}


UnityPreview* unity_gwibber_daemon_preview (UnityGwibberDaemon* self, const gchar* uri) {
	UnityPreview* result = NULL;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	UnitySocialPreview* preview;
	GFile* _tmp3_ = NULL;
	GFile* icon_dir;
	GIcon* icon = NULL;
	gchar* retweet_str = NULL;
	gchar* like_str = NULL;
	gchar* _img_uri;
	DeeModel* _tmp4_;
	DeeModel* _tmp5_;
	DeeModel* _tmp6_;
	DeeModelIter* end = NULL;
	DeeModel* _tmp7_;
	DeeModelIter* _tmp8_ = NULL;
	DeeModel* _tmp9_;
	DeeModelIter* _tmp10_ = NULL;
	DeeModel* _tmp127_;
	DeeModelIter* _tmp128_;
	GVariant* _tmp129_ = NULL;
	GVariant* _tmp130_;
	gchar** _tmp131_;
	gint _tmp131__length1;
	gchar** _tmp135_;
	gint _tmp135__length1;
	gchar** _accounts_array;
	gint _accounts_array_length1;
	gint __accounts_array_size_;
	gchar** _seen;
	gint _seen_length1;
	gint __seen_size_;
	gchar** _tmp136_;
	gint _tmp136__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = uri;
	_tmp1_ = g_strdup (_tmp0_);
	_data1_->uri = _tmp1_;
	_tmp2_ = _data1_->uri;
	g_debug ("daemon.vala:537: Previewing: %s", _tmp2_);
	preview = NULL;
	_tmp3_ = g_file_new_for_path (UNITY_GWIBBER_ICON_PATH);
	icon_dir = _tmp3_;
	_img_uri = NULL;
	_tmp4_ = self->priv->_streams_model;
	if (_tmp4_ == NULL) {
		unity_gwibber_daemon_setup_gwibber (self);
	}
	_tmp5_ = self->priv->_streams_model;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data1_->model = _tmp6_;
	_tmp7_ = _data1_->model;
	_tmp8_ = dee_model_get_first_iter (_tmp7_);
	_data1_->iter = _tmp8_;
	_tmp9_ = _data1_->model;
	_tmp10_ = dee_model_get_last_iter (_tmp9_);
	end = _tmp10_;
	while (TRUE) {
		DeeModelIter* _tmp11_;
		DeeModelIter* _tmp12_;
		DeeModel* _tmp13_;
		DeeModelIter* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* url;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		DeeModel* _tmp124_;
		DeeModelIter* _tmp125_;
		DeeModelIter* _tmp126_ = NULL;
		_tmp11_ = _data1_->iter;
		_tmp12_ = end;
		if (!(_tmp11_ != _tmp12_)) {
			break;
		}
		_tmp13_ = _data1_->model;
		_tmp14_ = _data1_->iter;
		_tmp15_ = dee_model_get_string (_tmp13_, _tmp14_, (guint) GWIBBER_STREAM_MODEL_COLUMN_URL);
		_tmp16_ = g_strdup (_tmp15_);
		url = _tmp16_;
		_tmp17_ = url;
		_tmp18_ = _data1_->uri;
		if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
			const gchar* _tmp19_;
			DeeModel* _tmp20_;
			DeeModelIter* _tmp21_;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gchar* icon_uri;
			const gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			const gchar* _tmp36_;
			GIcon* _tmp37_ = NULL;
			GIcon* avatar;
			DeeModel* _tmp38_;
			DeeModelIter* _tmp39_;
			gdouble _tmp40_ = 0.0;
			gdouble likes;
			DeeModel* _tmp41_;
			DeeModelIter* _tmp42_;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_;
			gchar* sender;
			DeeModel* _tmp45_;
			DeeModelIter* _tmp46_;
			const gchar* _tmp47_ = NULL;
			gchar* _tmp48_;
			gchar* sender_nick;
			DeeModel* _tmp49_;
			DeeModelIter* _tmp50_;
			const gchar* _tmp51_ = NULL;
			gchar* _tmp52_;
			gchar* timestring;
			const gchar* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			DeeModel* _tmp60_;
			DeeModelIter* _tmp61_;
			const gchar* _tmp62_ = NULL;
			gchar* _tmp63_;
			gchar* content;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			const gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* title;
			DeeModel* _tmp70_;
			DeeModelIter* _tmp71_;
			const gchar* _tmp72_ = NULL;
			gchar* _tmp73_;
			gchar* comments_json;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			GIcon* _tmp77_;
			UnitySocialPreview* _tmp78_;
			UnitySocialPreview* _tmp79_;
			const gchar* _tmp80_;
			UnitySocialPreview* _tmp81_;
			const gchar* _tmp82_;
			UnitySocialPreview* _tmp83_;
			const gchar* _tmp84_ = NULL;
			gdouble _tmp85_;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_;
			UnityInfoHint* _tmp88_;
			UnityInfoHint* _tmp89_;
			DeeModel* _tmp90_;
			DeeModelIter* _tmp91_;
			const gchar* _tmp92_ = NULL;
			gchar* _tmp93_;
			gchar* stream_id;
			const gchar* _tmp94_;
			gboolean _tmp112_ = FALSE;
			const gchar* _tmp113_;
			gboolean _tmp117_;
			UnitySocialPreview* _tmp122_;
			const gchar* _tmp123_;
			_tmp19_ = url;
			g_debug ("daemon.vala:556: Found %s", _tmp19_);
			_tmp20_ = _data1_->model;
			_tmp21_ = _data1_->iter;
			_tmp22_ = dee_model_get_string (_tmp20_, _tmp21_, (guint) GWIBBER_STREAM_MODEL_COLUMN_ICON_URI);
			_tmp23_ = g_strdup (_tmp22_);
			icon_uri = _tmp23_;
			_tmp24_ = icon_uri;
			_tmp25_ = string_contains (_tmp24_, "_normal.");
			if (_tmp25_) {
				const gchar* _tmp26_;
				gchar** _tmp27_;
				gchar** _tmp28_ = NULL;
				gchar** ss;
				gint ss_length1;
				gint _ss_size_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp26_ = icon_uri;
				_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, "_normal.", 0);
				ss = _tmp28_;
				ss_length1 = _vala_array_length (_tmp27_);
				_ss_size_ = ss_length1;
				_tmp29_ = ss;
				_tmp29__length1 = ss_length1;
				_tmp30_ = _tmp29_[0];
				_tmp31_ = g_strconcat (_tmp30_, ".", NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = ss;
				_tmp33__length1 = ss_length1;
				_tmp34_ = _tmp33_[1];
				_tmp35_ = g_strconcat (_tmp32_, _tmp34_, NULL);
				_g_free0 (icon_uri);
				icon_uri = _tmp35_;
				_g_free0 (_tmp32_);
				ss = (_vala_array_free (ss, ss_length1, (GDestroyNotify) g_free), NULL);
			}
			_tmp36_ = icon_uri;
			_tmp37_ = g_icon_new_for_string (_tmp36_, &_inner_error_);
			avatar = _tmp37_;
			if (_inner_error_ != NULL) {
				_g_free0 (icon_uri);
				_g_free0 (url);
				_g_free0 (_img_uri);
				_g_free0 (like_str);
				_g_free0 (retweet_str);
				_g_object_unref0 (icon);
				_g_object_unref0 (icon_dir);
				_g_object_unref0 (preview);
				block1_data_unref (_data1_);
				_data1_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp38_ = _data1_->model;
			_tmp39_ = _data1_->iter;
			_tmp40_ = dee_model_get_double (_tmp38_, _tmp39_, (guint) GWIBBER_STREAM_MODEL_COLUMN_LIKES);
			likes = _tmp40_;
			_tmp41_ = _data1_->model;
			_tmp42_ = _data1_->iter;
			_tmp43_ = dee_model_get_string (_tmp41_, _tmp42_, (guint) GWIBBER_STREAM_MODEL_COLUMN_SENDER);
			_tmp44_ = g_strdup (_tmp43_);
			sender = _tmp44_;
			_tmp45_ = _data1_->model;
			_tmp46_ = _data1_->iter;
			_tmp47_ = dee_model_get_string (_tmp45_, _tmp46_, (guint) GWIBBER_STREAM_MODEL_COLUMN_SENDER_NICK);
			_tmp48_ = g_strdup (_tmp47_);
			sender_nick = _tmp48_;
			_tmp49_ = _data1_->model;
			_tmp50_ = _data1_->iter;
			_tmp51_ = dee_model_get_string (_tmp49_, _tmp50_, (guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTRING);
			_tmp52_ = g_strdup (_tmp51_);
			timestring = _tmp52_;
			_tmp53_ = sender_nick;
			_tmp54_ = strlen (_tmp53_);
			_tmp55_ = _tmp54_;
			if (_tmp55_ > 0) {
				const gchar* _tmp56_;
				gchar* _tmp57_;
				_tmp56_ = sender_nick;
				_tmp57_ = g_strconcat ("@", _tmp56_, NULL);
				_g_free0 (sender_nick);
				sender_nick = _tmp57_;
			} else {
				const gchar* _tmp58_;
				gchar* _tmp59_;
				_tmp58_ = sender;
				_tmp59_ = g_strdup (_tmp58_);
				_g_free0 (sender_nick);
				sender_nick = _tmp59_;
			}
			_tmp60_ = _data1_->model;
			_tmp61_ = _data1_->iter;
			_tmp62_ = dee_model_get_string (_tmp60_, _tmp61_, (guint) GWIBBER_STREAM_MODEL_COLUMN_MESSAGE);
			_tmp63_ = g_strdup (_tmp62_);
			content = _tmp63_;
			_tmp64_ = sender_nick;
			_tmp65_ = g_strconcat (_tmp64_, " ", NULL);
			_tmp66_ = _tmp65_;
			_tmp67_ = timestring;
			_tmp68_ = g_strconcat (_tmp66_, _tmp67_, NULL);
			_tmp69_ = _tmp68_;
			_g_free0 (_tmp66_);
			title = _tmp69_;
			_tmp70_ = _data1_->model;
			_tmp71_ = _data1_->iter;
			_tmp72_ = dee_model_get_string (_tmp70_, _tmp71_, (guint) GWIBBER_STREAM_MODEL_COLUMN_COMMENTS);
			_tmp73_ = g_strdup (_tmp72_);
			comments_json = _tmp73_;
			_tmp74_ = sender;
			_tmp75_ = title;
			_tmp76_ = content;
			_tmp77_ = avatar;
			_tmp78_ = unity_social_preview_new (_tmp74_, _tmp75_, _tmp76_, _tmp77_);
			_g_object_unref0 (preview);
			preview = _tmp78_;
			_tmp79_ = preview;
			_tmp80_ = sender;
			unity_preview_set_title ((UnityPreview*) _tmp79_, _tmp80_);
			_tmp81_ = preview;
			_tmp82_ = title;
			unity_preview_set_subtitle ((UnityPreview*) _tmp81_, _tmp82_);
			_tmp83_ = preview;
			_tmp84_ = _ ("Favorites");
			_tmp85_ = likes;
			_tmp86_ = double_to_string (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = unity_info_hint_new ("likes", _tmp84_, NULL, _tmp87_);
			_tmp89_ = g_object_ref_sink (_tmp88_);
			unity_preview_add_info ((UnityPreview*) _tmp83_, _tmp89_);
			_g_object_unref0 (_tmp89_);
			_g_free0 (_tmp87_);
			_tmp90_ = _data1_->model;
			_tmp91_ = _data1_->iter;
			_tmp92_ = dee_model_get_string (_tmp90_, _tmp91_, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			_tmp93_ = g_strdup (_tmp92_);
			stream_id = _tmp93_;
			_tmp94_ = stream_id;
			if (g_strcmp0 (_tmp94_, "images") == 0) {
				DeeModel* _tmp95_;
				DeeModelIter* _tmp96_;
				const gchar* _tmp97_ = NULL;
				gchar* _tmp98_;
				_tmp95_ = _data1_->model;
				_tmp96_ = _data1_->iter;
				_tmp97_ = dee_model_get_string (_tmp95_, _tmp96_, (guint) GWIBBER_STREAM_MODEL_COLUMN_IMG_SRC);
				_tmp98_ = g_strdup (_tmp97_);
				_g_free0 (_img_uri);
				_img_uri = _tmp98_;
			} else {
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				const gchar* _tmp101_;
				gboolean _tmp103_;
				gboolean _tmp107_;
				_tmp101_ = stream_id;
				if (g_strcmp0 (_tmp101_, "videos") == 0) {
					const gchar* _tmp102_;
					_tmp102_ = _img_uri;
					_tmp100_ = _tmp102_ != NULL;
				} else {
					_tmp100_ = FALSE;
				}
				_tmp103_ = _tmp100_;
				if (_tmp103_) {
					const gchar* _tmp104_;
					gint _tmp105_;
					gint _tmp106_;
					_tmp104_ = _img_uri;
					_tmp105_ = strlen (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp99_ = _tmp106_ < 1;
				} else {
					_tmp99_ = FALSE;
				}
				_tmp107_ = _tmp99_;
				if (_tmp107_) {
					DeeModel* _tmp108_;
					DeeModelIter* _tmp109_;
					const gchar* _tmp110_ = NULL;
					gchar* _tmp111_;
					_tmp108_ = _data1_->model;
					_tmp109_ = _data1_->iter;
					_tmp110_ = dee_model_get_string (_tmp108_, _tmp109_, (guint) GWIBBER_STREAM_MODEL_COLUMN_VIDEO_PIC);
					_tmp111_ = g_strdup (_tmp110_);
					_g_free0 (_img_uri);
					_img_uri = _tmp111_;
				}
			}
			_tmp113_ = _img_uri;
			if (_tmp113_ != NULL) {
				const gchar* _tmp114_;
				gint _tmp115_;
				gint _tmp116_;
				_tmp114_ = _img_uri;
				_tmp115_ = strlen (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp112_ = _tmp116_ > 0;
			} else {
				_tmp112_ = FALSE;
			}
			_tmp117_ = _tmp112_;
			if (_tmp117_) {
				const gchar* _tmp118_;
				GIcon* _tmp119_ = NULL;
				GIcon* img;
				UnitySocialPreview* _tmp120_;
				GIcon* _tmp121_;
				_tmp118_ = _img_uri;
				_tmp119_ = g_icon_new_for_string (_tmp118_, &_inner_error_);
				img = _tmp119_;
				if (_inner_error_ != NULL) {
					_g_free0 (stream_id);
					_g_free0 (comments_json);
					_g_free0 (title);
					_g_free0 (content);
					_g_free0 (timestring);
					_g_free0 (sender_nick);
					_g_free0 (sender);
					_g_object_unref0 (avatar);
					_g_free0 (icon_uri);
					_g_free0 (url);
					_g_free0 (_img_uri);
					_g_free0 (like_str);
					_g_free0 (retweet_str);
					_g_object_unref0 (icon);
					_g_object_unref0 (icon_dir);
					_g_object_unref0 (preview);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp120_ = preview;
				_tmp121_ = img;
				unity_preview_set_image ((UnityPreview*) _tmp120_, _tmp121_);
				_g_object_unref0 (img);
			}
			_tmp122_ = preview;
			_tmp123_ = comments_json;
			unity_gwibber_daemon_parse_comments (self, _tmp122_, _tmp123_);
			_g_free0 (stream_id);
			_g_free0 (comments_json);
			_g_free0 (title);
			_g_free0 (content);
			_g_free0 (timestring);
			_g_free0 (sender_nick);
			_g_free0 (sender);
			_g_object_unref0 (avatar);
			_g_free0 (icon_uri);
			_g_free0 (url);
			break;
		}
		_tmp124_ = _data1_->model;
		_tmp125_ = _data1_->iter;
		_tmp126_ = dee_model_next (_tmp124_, _tmp125_);
		_data1_->iter = _tmp126_;
		_g_free0 (url);
	}
	_tmp127_ = _data1_->model;
	_tmp128_ = _data1_->iter;
	_tmp129_ = dee_model_get_value (_tmp127_, _tmp128_, (guint) GWIBBER_STREAM_MODEL_COLUMN_ACCOUNTS);
	_tmp130_ = _tmp129_;
	_tmp131_ = _variant_get2 (_tmp130_, &_tmp131__length1);
	_tmp135_ = _tmp131_;
	_tmp135__length1 = _tmp131__length1;
	_g_variant_unref0 (_tmp130_);
	_accounts_array = _tmp135_;
	_accounts_array_length1 = _tmp135__length1;
	__accounts_array_size_ = _accounts_array_length1;
	_seen = NULL;
	_seen_length1 = 0;
	__seen_size_ = _seen_length1;
	_tmp136_ = _accounts_array;
	_tmp136__length1 = _accounts_array_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp136_;
		a_collection_length1 = _tmp136__length1;
		for (a_it = 0; a_it < _tmp136__length1; a_it = a_it + 1) {
			gchar* _tmp137_;
			gchar* a = NULL;
			_tmp137_ = g_strdup (a_collection[a_it]);
			a = _tmp137_;
			{
				Block2Data* _data2_;
				const gchar* _tmp138_;
				gchar** _tmp139_;
				gchar** _tmp140_ = NULL;
				gchar** _tmp141_;
				gint _tmp141__length1;
				const gchar* _tmp142_;
				gchar* _tmp143_;
				gchar* _tmp144_;
				const gchar* _tmp145_;
				gchar** _tmp146_;
				gint _tmp146__length1;
				gchar** _tmp147_;
				gint _tmp147__length1;
				const gchar* _tmp148_;
				gchar* _tmp149_;
				const gchar* _tmp150_;
				gchar** _tmp151_;
				gchar** _tmp152_ = NULL;
				gchar** _tmp153_;
				gint _tmp153__length1;
				const gchar* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				gchar* _account_service;
				const gchar* _tmp157_;
				gchar** _tmp158_;
				gchar** _tmp159_ = NULL;
				gchar** _tmp160_;
				gint _tmp160__length1;
				const gchar* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				GFile* _tmp164_;
				const gchar* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				GFile* _tmp170_ = NULL;
				GFile* _tmp171_;
				GFile* icon_str;
				GFile* _tmp172_;
				gboolean _tmp173_ = FALSE;
				const gchar* _tmp176_ = NULL;
				GIcon* _tmp177_;
				UnityPreviewAction* _tmp178_;
				UnityPreviewAction* view_action;
				UnitySocialPreview* _tmp179_;
				UnityPreviewAction* _tmp180_;
				UnityPreviewAction* _tmp181_;
				gboolean _tmp182_ = FALSE;
				gboolean _tmp183_ = FALSE;
				gboolean _tmp184_ = FALSE;
				gboolean _tmp185_ = FALSE;
				const gchar* _tmp186_;
				gboolean _tmp188_;
				gboolean _tmp190_;
				gboolean _tmp192_;
				gboolean _tmp194_;
				DeeModel* _tmp206_;
				DeeModelIter* _tmp207_;
				gboolean _tmp208_ = FALSE;
				gboolean from_me;
				DeeModel* _tmp209_;
				DeeModelIter* _tmp210_;
				gboolean _tmp211_ = FALSE;
				gboolean _tmp212_ = FALSE;
				gboolean _tmp213_ = FALSE;
				gboolean _tmp214_ = FALSE;
				const gchar* _tmp215_;
				gboolean _tmp217_;
				gboolean _tmp219_;
				gboolean _tmp221_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->_data1_ = block1_data_ref (_data1_);
				_tmp138_ = a;
				_tmp140_ = _tmp139_ = g_strsplit (_tmp138_, ":", 0);
				_tmp141_ = _tmp140_;
				_tmp141__length1 = _vala_array_length (_tmp139_);
				_tmp142_ = _tmp141_[0];
				_tmp143_ = g_strdup (_tmp142_);
				_tmp144_ = _tmp143_;
				_tmp141_ = (_vala_array_free (_tmp141_, _tmp141__length1, (GDestroyNotify) g_free), NULL);
				_data2_->_account_id = _tmp144_;
				_tmp145_ = _data2_->_account_id;
				_tmp146_ = _seen;
				_tmp146__length1 = _seen_length1;
				if (_vala_string_array_contains (_tmp146_, _tmp146__length1, _tmp145_)) {
					_g_free0 (a);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					continue;
				}
				_tmp147_ = _seen;
				_tmp147__length1 = _seen_length1;
				_tmp148_ = _data2_->_account_id;
				_tmp149_ = g_strdup (_tmp148_);
				_vala_array_add1 (&_seen, &_seen_length1, &__seen_size_, _tmp149_);
				_tmp150_ = a;
				_tmp152_ = _tmp151_ = g_strsplit (_tmp150_, ":", 0);
				_tmp153_ = _tmp152_;
				_tmp153__length1 = _vala_array_length (_tmp151_);
				_tmp154_ = _tmp153_[1];
				_tmp155_ = g_strdup (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp153_ = (_vala_array_free (_tmp153_, _tmp153__length1, (GDestroyNotify) g_free), NULL);
				_account_service = _tmp156_;
				_tmp157_ = a;
				_tmp159_ = _tmp158_ = g_strsplit (_tmp157_, ":", 0);
				_tmp160_ = _tmp159_;
				_tmp160__length1 = _vala_array_length (_tmp158_);
				_tmp161_ = _tmp160_[2];
				_tmp162_ = g_strdup (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp160_ = (_vala_array_free (_tmp160_, _tmp160__length1, (GDestroyNotify) g_free), NULL);
				_data2_->_status_id = _tmp163_;
				_tmp164_ = icon_dir;
				_tmp165_ = _account_service;
				_tmp166_ = g_strconcat ("service-", _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strconcat (_tmp167_, ".svg", NULL);
				_tmp169_ = _tmp168_;
				_tmp170_ = g_file_get_child (_tmp164_, _tmp169_);
				_tmp171_ = _tmp170_;
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				icon_str = _tmp171_;
				_tmp172_ = icon_str;
				_tmp173_ = g_file_query_exists (_tmp172_, NULL);
				if (_tmp173_) {
					GFile* _tmp174_;
					GFileIcon* _tmp175_;
					_tmp174_ = icon_str;
					_tmp175_ = (GFileIcon*) g_file_icon_new (_tmp174_);
					_g_object_unref0 (icon);
					icon = (GIcon*) _tmp175_;
				} else {
					_g_object_unref0 (icon);
					icon = NULL;
				}
				_tmp176_ = _ ("View");
				_tmp177_ = icon;
				_tmp178_ = unity_preview_action_new ("view", _tmp176_, _tmp177_);
				view_action = _tmp178_;
				_tmp179_ = preview;
				_tmp180_ = view_action;
				unity_preview_add_action ((UnityPreview*) _tmp179_, _tmp180_);
				_tmp181_ = view_action;
				g_signal_connect_data (_tmp181_, "activated", (GCallback) _____lambda5__unity_preview_action_activated, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
				_tmp186_ = _account_service;
				if (g_strcmp0 (_tmp186_, "twitter") == 0) {
					_tmp185_ = TRUE;
				} else {
					const gchar* _tmp187_;
					_tmp187_ = _account_service;
					_tmp185_ = g_strcmp0 (_tmp187_, "identica") == 0;
				}
				_tmp188_ = _tmp185_;
				if (_tmp188_) {
					_tmp184_ = TRUE;
				} else {
					const gchar* _tmp189_;
					_tmp189_ = _account_service;
					_tmp184_ = g_strcmp0 (_tmp189_, "statusnet") == 0;
				}
				_tmp190_ = _tmp184_;
				if (_tmp190_) {
					_tmp183_ = TRUE;
				} else {
					const gchar* _tmp191_;
					_tmp191_ = _account_service;
					_tmp183_ = g_strcmp0 (_tmp191_, "sina") == 0;
				}
				_tmp192_ = _tmp183_;
				if (_tmp192_) {
					_tmp182_ = TRUE;
				} else {
					const gchar* _tmp193_;
					_tmp193_ = _account_service;
					_tmp182_ = g_strcmp0 (_tmp193_, "sohu") == 0;
				}
				_tmp194_ = _tmp182_;
				if (_tmp194_) {
					const gchar* _tmp195_;
					const gchar* _tmp200_;
					GIcon* _tmp201_;
					UnityPreviewAction* _tmp202_;
					UnityPreviewAction* retweet_action;
					UnitySocialPreview* _tmp203_;
					UnityPreviewAction* _tmp204_;
					UnityPreviewAction* _tmp205_;
					_tmp195_ = _account_service;
					if (g_strcmp0 (_tmp195_, "twitter") == 0) {
						const gchar* _tmp196_ = NULL;
						gchar* _tmp197_;
						_tmp196_ = _ ("Retweet");
						_tmp197_ = g_strdup (_tmp196_);
						_g_free0 (retweet_str);
						retweet_str = _tmp197_;
					} else {
						const gchar* _tmp198_ = NULL;
						gchar* _tmp199_;
						_tmp198_ = _ ("Share");
						_tmp199_ = g_strdup (_tmp198_);
						_g_free0 (retweet_str);
						retweet_str = _tmp199_;
					}
					_tmp200_ = retweet_str;
					_tmp201_ = icon;
					_tmp202_ = unity_preview_action_new ("retweet", _tmp200_, _tmp201_);
					retweet_action = _tmp202_;
					_tmp203_ = preview;
					_tmp204_ = retweet_action;
					unity_preview_add_action ((UnityPreview*) _tmp203_, _tmp204_);
					_tmp205_ = retweet_action;
					g_signal_connect_data (_tmp205_, "activated", (GCallback) ______lambda6__unity_preview_action_activated, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_g_object_unref0 (retweet_action);
				}
				_tmp206_ = _data1_->model;
				_tmp207_ = _data1_->iter;
				_tmp208_ = dee_model_get_bool (_tmp206_, _tmp207_, (guint) GWIBBER_STREAM_MODEL_COLUMN_FROM_ME);
				from_me = _tmp208_;
				_tmp209_ = _data1_->model;
				_tmp210_ = _data1_->iter;
				_tmp211_ = dee_model_get_bool (_tmp209_, _tmp210_, (guint) GWIBBER_STREAM_MODEL_COLUMN_LIKED);
				_data2_->liked = _tmp211_;
				_tmp215_ = _account_service;
				if (g_strcmp0 (_tmp215_, "flicker") != 0) {
					const gchar* _tmp216_;
					_tmp216_ = _account_service;
					_tmp214_ = g_strcmp0 (_tmp216_, "foursquare") != 0;
				} else {
					_tmp214_ = FALSE;
				}
				_tmp217_ = _tmp214_;
				if (_tmp217_) {
					const gchar* _tmp218_;
					_tmp218_ = _account_service;
					_tmp213_ = g_strcmp0 (_tmp218_, "digg") != 0;
				} else {
					_tmp213_ = FALSE;
				}
				_tmp219_ = _tmp213_;
				if (_tmp219_) {
					gboolean _tmp220_;
					_tmp220_ = from_me;
					_tmp212_ = !_tmp220_;
				} else {
					_tmp212_ = FALSE;
				}
				_tmp221_ = _tmp212_;
				if (_tmp221_) {
					const gchar* _tmp222_ = NULL;
					gboolean _tmp223_;
					const gchar* _tmp226_;
					gchar* _tmp227_;
					const gchar* _tmp228_;
					GIcon* _tmp229_;
					UnityPreviewAction* _tmp230_;
					UnityPreviewAction* like_action;
					UnitySocialPreview* _tmp231_;
					UnityPreviewAction* _tmp232_;
					UnityPreviewAction* _tmp233_;
					_tmp223_ = _data2_->liked;
					if (_tmp223_) {
						const gchar* _tmp224_ = NULL;
						_tmp224_ = _ ("Unlike");
						_tmp222_ = _tmp224_;
					} else {
						const gchar* _tmp225_ = NULL;
						_tmp225_ = _ ("Like");
						_tmp222_ = _tmp225_;
					}
					_tmp226_ = _tmp222_;
					_tmp227_ = g_strdup (_tmp226_);
					_g_free0 (like_str);
					like_str = _tmp227_;
					_tmp228_ = like_str;
					_tmp229_ = icon;
					_tmp230_ = unity_preview_action_new ("like", _tmp228_, _tmp229_);
					like_action = _tmp230_;
					_tmp231_ = preview;
					_tmp232_ = like_action;
					unity_preview_add_action ((UnityPreview*) _tmp231_, _tmp232_);
					_tmp233_ = like_action;
					g_signal_connect_data (_tmp233_, "activated", (GCallback) ______lambda7__unity_preview_action_activated, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_g_object_unref0 (like_action);
				}
				_g_object_unref0 (view_action);
				_g_object_unref0 (icon_str);
				_g_free0 (_account_service);
				_g_free0 (a);
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
		}
	}
	result = (UnityPreview*) preview;
	_seen = (_vala_array_free (_seen, _seen_length1, (GDestroyNotify) g_free), NULL);
	_accounts_array = (_vala_array_free (_accounts_array, _accounts_array_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_img_uri);
	_g_free0 (like_str);
	_g_free0 (retweet_str);
	_g_object_unref0 (icon);
	_g_object_unref0 (icon_dir);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
	return g_boxed_copy (json_object_get_type (), self);
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
	return self ? _vala_JsonObject_copy (self) : NULL;
}


static JsonArray* _vala_JsonArray_copy (JsonArray* self) {
	return g_boxed_copy (json_array_get_type (), self);
}


static gpointer __vala_JsonArray_copy0 (gpointer self) {
	return self ? _vala_JsonArray_copy (self) : NULL;
}


static void _vala_JsonObject_free (JsonObject* self) {
	g_boxed_free (json_object_get_type (), self);
}


static void _vala_JsonArray_free (JsonArray* self) {
	g_boxed_free (json_array_get_type (), self);
}


static void unity_gwibber_daemon_parse_comments (UnityGwibberDaemon* self, UnitySocialPreview* preview, const gchar* _comments) {
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (preview != NULL);
	g_return_if_fail (_comments != NULL);
	_tmp0_ = _comments;
	if (_tmp0_ != NULL) {
		gchar* _tmp1_;
		gchar* cname;
		gchar* _tmp2_;
		gchar* ctext;
		gchar* _tmp3_;
		gchar* time_string;
		JsonParser* _tmp4_;
		JsonParser* parser;
		JsonNode* comments_node;
		JsonParser* _tmp7_;
		JsonNode* _tmp8_ = NULL;
		JsonNode* _tmp9_;
		_tmp1_ = g_strdup ("");
		cname = _tmp1_;
		_tmp2_ = g_strdup ("");
		ctext = _tmp2_;
		_tmp3_ = g_strdup ("");
		time_string = _tmp3_;
		_tmp4_ = json_parser_new ();
		parser = _tmp4_;
		{
			JsonParser* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = parser;
			_tmp6_ = _comments;
			json_parser_load_from_data (_tmp5_, _tmp6_, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (time_string);
			_g_free0 (ctext);
			_g_free0 (cname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		comments_node = NULL;
		_tmp7_ = parser;
		_tmp8_ = json_parser_get_root (_tmp7_);
		comments_node = _tmp8_;
		_tmp9_ = comments_node;
		if (_tmp9_ != NULL) {
			JsonNode* _tmp10_;
			JsonObject* _tmp11_ = NULL;
			JsonObject* _tmp12_;
			JsonObject* comments_obj;
			JsonObject* _tmp13_;
			_tmp10_ = comments_node;
			_tmp11_ = json_node_get_object (_tmp10_);
			_tmp12_ = __vala_JsonObject_copy0 (_tmp11_);
			comments_obj = _tmp12_;
			_tmp13_ = comments_obj;
			if (_tmp13_ != NULL) {
				JsonObject* _tmp14_;
				gboolean _tmp15_ = FALSE;
				_tmp14_ = comments_obj;
				_tmp15_ = json_object_has_member (_tmp14_, "comments");
				if (_tmp15_) {
					JsonObject* _tmp16_;
					JsonArray* _tmp17_ = NULL;
					JsonArray* _tmp18_;
					JsonArray* comments;
					JsonArray* _tmp19_;
					guint _tmp20_ = 0U;
					_tmp16_ = comments_obj;
					_tmp17_ = json_object_get_array_member (_tmp16_, "comments");
					_tmp18_ = __vala_JsonArray_copy0 (_tmp17_);
					comments = _tmp18_;
					_tmp19_ = comments;
					_tmp20_ = json_array_get_length (_tmp19_);
					if (_tmp20_ > ((guint) 0)) {
						{
							gint i;
							i = 0;
							{
								gboolean _tmp21_;
								_tmp21_ = TRUE;
								while (TRUE) {
									gboolean _tmp22_;
									gint _tmp24_;
									JsonArray* _tmp25_;
									guint _tmp26_ = 0U;
									JsonArray* _tmp27_;
									gint _tmp28_;
									JsonNode* _tmp29_ = NULL;
									JsonObject* _tmp30_ = NULL;
									JsonObject* _tmp31_;
									JsonObject* obj;
									JsonObject* _tmp32_;
									_tmp22_ = _tmp21_;
									if (!_tmp22_) {
										gint _tmp23_;
										_tmp23_ = i;
										i = _tmp23_ + 1;
									}
									_tmp21_ = FALSE;
									_tmp24_ = i;
									_tmp25_ = comments;
									_tmp26_ = json_array_get_length (_tmp25_);
									if (!(((guint) _tmp24_) < _tmp26_)) {
										break;
									}
									_tmp27_ = comments;
									_tmp28_ = i;
									_tmp29_ = json_array_get_element (_tmp27_, (guint) _tmp28_);
									_tmp30_ = json_node_get_object (_tmp29_);
									_tmp31_ = __vala_JsonObject_copy0 (_tmp30_);
									obj = _tmp31_;
									_tmp32_ = obj;
									if (_tmp32_ != NULL) {
										JsonObject* _tmp33_;
										gboolean _tmp34_ = FALSE;
										JsonObject* _tmp41_;
										gboolean _tmp42_ = FALSE;
										JsonObject* _tmp49_;
										gboolean _tmp50_ = FALSE;
										UnitySocialPreview* _tmp63_;
										const gchar* _tmp64_;
										const gchar* _tmp65_;
										const gchar* _tmp66_;
										const gchar* _tmp67_;
										UnitySocialPreviewComment* _tmp68_;
										UnitySocialPreviewComment* _tmp69_;
										_tmp33_ = obj;
										_tmp34_ = json_object_has_member (_tmp33_, "text");
										if (_tmp34_) {
											JsonObject* _tmp35_;
											const gchar* _tmp36_ = NULL;
											gchar* _tmp37_;
											const gchar* _tmp38_;
											_tmp35_ = obj;
											_tmp36_ = json_object_get_string_member (_tmp35_, "text");
											_tmp37_ = g_strdup (_tmp36_);
											_g_free0 (ctext);
											ctext = _tmp37_;
											_tmp38_ = ctext;
											if (_tmp38_ != NULL) {
												const gchar* _tmp39_;
												gchar* _tmp40_ = NULL;
												_tmp39_ = ctext;
												_tmp40_ = g_markup_escape_text (_tmp39_, (gssize) (-1));
												_g_free0 (ctext);
												ctext = _tmp40_;
											}
										}
										_tmp41_ = obj;
										_tmp42_ = json_object_has_member (_tmp41_, "time");
										if (_tmp42_) {
											JsonObject* _tmp43_;
											gint64 _tmp44_ = 0LL;
											gint64 ctime;
											GwibberUtils* _tmp45_;
											gint64 _tmp46_;
											gchar* _tmp47_ = NULL;
											const gchar* _tmp48_;
											_tmp43_ = obj;
											_tmp44_ = json_object_get_int_member (_tmp43_, "time");
											ctime = _tmp44_;
											_tmp45_ = self->priv->utils;
											_tmp46_ = ctime;
											_tmp47_ = gwibber_utils_generate_time_string (_tmp45_, (guint) _tmp46_);
											_g_free0 (time_string);
											time_string = _tmp47_;
											_tmp48_ = time_string;
											g_debug ("daemon.vala:728: ctime: %s", _tmp48_);
										}
										_tmp49_ = obj;
										_tmp50_ = json_object_has_member (_tmp49_, "sender");
										if (_tmp50_) {
											JsonObject* _tmp51_;
											JsonObject* _tmp52_ = NULL;
											JsonObject* _tmp53_;
											JsonObject* _sender_obj;
											JsonObject* _tmp54_;
											_tmp51_ = obj;
											_tmp52_ = json_object_get_object_member (_tmp51_, "sender");
											_tmp53_ = __vala_JsonObject_copy0 (_tmp52_);
											_sender_obj = _tmp53_;
											_tmp54_ = _sender_obj;
											if (_tmp54_ != NULL) {
												JsonObject* _tmp55_;
												gboolean _tmp56_ = FALSE;
												_tmp55_ = _sender_obj;
												_tmp56_ = json_object_has_member (_tmp55_, "name");
												if (_tmp56_) {
													JsonObject* _tmp57_;
													const gchar* _tmp58_ = NULL;
													gchar* _tmp59_;
													const gchar* _tmp60_;
													_tmp57_ = _sender_obj;
													_tmp58_ = json_object_get_string_member (_tmp57_, "name");
													_tmp59_ = g_strdup (_tmp58_);
													_g_free0 (cname);
													cname = _tmp59_;
													_tmp60_ = cname;
													if (_tmp60_ != NULL) {
														const gchar* _tmp61_;
														gchar* _tmp62_ = NULL;
														_tmp61_ = cname;
														_tmp62_ = g_markup_escape_text (_tmp61_, (gssize) (-1));
														_g_free0 (cname);
														cname = _tmp62_;
													}
												}
											}
											__vala_JsonObject_free0 (_sender_obj);
										}
										_tmp63_ = preview;
										_tmp64_ = cname;
										_tmp65_ = cname;
										_tmp66_ = ctext;
										_tmp67_ = time_string;
										_tmp68_ = unity_social_preview_comment_new (_tmp64_, _tmp65_, _tmp66_, _tmp67_);
										_tmp69_ = g_object_ref_sink (_tmp68_);
										unity_social_preview_add_comment (_tmp63_, _tmp69_);
										_g_object_unref0 (_tmp69_);
									}
									__vala_JsonObject_free0 (obj);
								}
							}
						}
					}
					__vala_JsonArray_free0 (comments);
				}
			}
			__vala_JsonObject_free0 (comments_obj);
		}
		_g_object_unref0 (parser);
		_g_free0 (time_string);
		_g_free0 (ctext);
		_g_free0 (cname);
	}
}


UnityGwibberDaemon* unity_gwibber_daemon_construct (GType object_type) {
	UnityGwibberDaemon * self = NULL;
	self = (UnityGwibberDaemon*) g_object_new (object_type, NULL);
	return self;
}


UnityGwibberDaemon* unity_gwibber_daemon_new (void) {
	return unity_gwibber_daemon_construct (UNITY_GWIBBER_TYPE_DAEMON);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		UnityGwibberDaemon * self;
		self = _data3_->self;
		__g_list_free__g_object_unref0_0 (_data3_->accts);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _unity_gwibber_daemon___lambda16_ (Block3Data* _data3_, guint id) {
	UnityGwibberDaemon * self;
	AgManager* _tmp0_;
	GList* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GList* _tmp3_;
	guint _tmp4_ = 0U;
	gboolean _tmp6_;
	self = _data3_->self;
	_tmp0_ = self->priv->_account_manager;
	_tmp1_ = ag_manager_get_enabled_account_services (_tmp0_);
	__g_list_free__g_object_unref0_0 (_data3_->accts);
	_data3_->accts = _tmp1_;
	_tmp3_ = _data3_->accts;
	_tmp4_ = g_list_length (_tmp3_);
	if (_tmp4_ > ((guint) 0)) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_has_accounts;
		_tmp2_ = !_tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		self->priv->_has_accounts = TRUE;
		unity_gwibber_daemon_setup (self);
	} else {
		GList* _tmp7_;
		guint _tmp8_ = 0U;
		_tmp7_ = _data3_->accts;
		_tmp8_ = g_list_length (_tmp7_);
		if (_tmp8_ == ((guint) 0)) {
			UnityLens* _tmp9_;
			_tmp9_ = self->priv->lens;
			unity_lens_set_visible (_tmp9_, FALSE);
			self->priv->_has_accounts = FALSE;
		}
	}
}


static void __unity_gwibber_daemon___lambda16__ag_manager_enabled_event (AgManager* _sender, guint account_id, gpointer self) {
	_unity_gwibber_daemon___lambda16_ (self, account_id);
}


static GObject * unity_gwibber_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityGwibberDaemon * self;
	Block3Data* _data3_;
	UnityLens* _tmp0_;
	UnityLens* _tmp1_;
	UnityLens* _tmp2_;
	const gchar* _tmp3_ = NULL;
	UnityLens* _tmp4_;
	AgManager* _tmp8_;
	AgManager* _tmp9_;
	GList* _tmp10_ = NULL;
	GList* _tmp11_;
	GList* _tmp19_;
	guint _tmp20_ = 0U;
	AgManager* _tmp21_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_gwibber_daemon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_GWIBBER_DAEMON (obj);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = unity_lens_new ("/com/canonical/unity/lens/gwibber", "gwibber");
	_g_object_unref0 (self->priv->lens);
	self->priv->lens = _tmp0_;
	_tmp1_ = self->priv->lens;
	unity_lens_set_search_in_global (_tmp1_, FALSE);
	_tmp2_ = self->priv->lens;
	_tmp3_ = _ ("Enter name or content you would like to search for");
	unity_lens_set_search_hint (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->lens;
	unity_lens_set_visible (_tmp4_, FALSE);
	{
		UnityLens* _tmp5_;
		_tmp5_ = self->priv->lens;
		unity_lens_export (_tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			block3_data_unref (_data3_);
			_data3_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("daemon.vala:69: failed to export lens: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp8_ = ag_manager_new_for_service_type ("microblogging");
	_g_object_unref0 (self->priv->_account_manager);
	self->priv->_account_manager = _tmp8_;
	_tmp9_ = self->priv->_account_manager;
	_tmp10_ = ag_manager_get_enabled_account_services (_tmp9_);
	_data3_->accts = _tmp10_;
	_tmp11_ = _data3_->accts;
	{
		GList* account_service_collection = NULL;
		GList* account_service_it = NULL;
		account_service_collection = _tmp11_;
		for (account_service_it = account_service_collection; account_service_it != NULL; account_service_it = account_service_it->next) {
			AgAccountService* _tmp12_;
			AgAccountService* account_service = NULL;
			_tmp12_ = _g_object_ref0 ((AgAccountService*) account_service_it->data);
			account_service = _tmp12_;
			{
				AgAccountService* _tmp13_;
				AgAccount* _tmp14_ = NULL;
				AgAccount* _tmp15_;
				AgAccount* account;
				AgAccount* _tmp16_;
				AgAccount* _tmp17_;
				const gchar* _tmp18_ = NULL;
				_tmp13_ = account_service;
				_tmp14_ = ag_account_service_get_account (_tmp13_);
				_tmp15_ = _g_object_ref0 (_tmp14_);
				account = _tmp15_;
				_tmp16_ = account;
				ag_account_set_enabled (_tmp16_, FALSE);
				_tmp17_ = account;
				_tmp18_ = ag_account_get_provider_name (_tmp17_);
				g_message ("daemon.vala:79: ACCOUNT PROVIDER: %s", _tmp18_);
				_g_object_unref0 (account);
				_g_object_unref0 (account_service);
			}
		}
	}
	_tmp19_ = _data3_->accts;
	_tmp20_ = g_list_length (_tmp19_);
	if (_tmp20_ > ((guint) 0)) {
		self->priv->_has_accounts = TRUE;
		unity_gwibber_daemon_setup (self);
	}
	_tmp21_ = self->priv->_account_manager;
	g_signal_connect_data (_tmp21_, "enabled-event", (GCallback) __unity_gwibber_daemon___lambda16__ag_manager_enabled_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}


static void unity_gwibber_daemon_class_init (UnityGwibberDaemonClass * klass) {
	unity_gwibber_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityGwibberDaemonPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_gwibber_daemon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_gwibber_daemon_finalize;
}


static void unity_gwibber_daemon_instance_init (UnityGwibberDaemon * self) {
	UnityPreferencesManager* _tmp0_ = NULL;
	self->priv = UNITY_GWIBBER_DAEMON_GET_PRIVATE (self);
	_tmp0_ = unity_preferences_manager_get_default ();
	self->priv->preferences = _tmp0_;
	self->priv->_model = NULL;
	self->priv->_streams_model = NULL;
	self->priv->_stream_iter_first = NULL;
	self->priv->_stream_iter_last = NULL;
	self->priv->_has_accounts = FALSE;
}


static void unity_gwibber_daemon_finalize (GObject* obj) {
	UnityGwibberDaemon * self;
	self = UNITY_GWIBBER_DAEMON (obj);
	_g_object_unref0 (self->priv->lens);
	_g_object_unref0 (self->priv->scope);
	_g_object_unref0 (self->priv->preferences);
	_g_object_unref0 (self->priv->streams_service);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->accounts);
	_g_object_unref0 (self->priv->utils);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_streams_model);
	_g_object_unref0 (self->priv->_analyzer);
	_g_object_unref0 (self->priv->_index);
	_dee_icu_term_filter_destroy0 (self->priv->_ascii_filter);
	_g_object_unref0 (self->priv->_account_manager);
	G_OBJECT_CLASS (unity_gwibber_daemon_parent_class)->finalize (obj);
}


/**
   * The Daemon class implements all of the logic for the place.
   *
   */
GType unity_gwibber_daemon_get_type (void) {
	static volatile gsize unity_gwibber_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gwibber_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityGwibberDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_gwibber_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGwibberDaemon), 0, (GInstanceInitFunc) unity_gwibber_daemon_instance_init, NULL };
		GType unity_gwibber_daemon_type_id;
		unity_gwibber_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityGwibberDaemon", &g_define_type_info, 0);
		g_once_init_leave (&unity_gwibber_daemon_type_id__volatile, unity_gwibber_daemon_type_id);
	}
	return unity_gwibber_daemon_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



