/*
 * Copyright (C) 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along 
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

public class GwibberPreferences : GLib.Object
{
    public Gtk.Builder builder;

    public GwibberPreferences ()
    {
        Object ();
    }

    construct
    {
        try {
            builder = new Gtk.Builder ();
            builder.add_from_file ("/usr/share/gwibber/ui/gwibber-preferences-dialog.ui");
            builder.connect_signals (null);
            var dialog = builder.get_object ("prefs_dialog") as Gtk.Dialog;
            dialog.set_wmclass("gwibber", "Gwibber");
            dialog.set_title(_("Broadcast Messaging Preferences"));
            dialog.show_all ();
        } catch (Error e) {
            error ("Could not load UI: %s", e.message);
        }

        var image_uploader_container = builder.get_object("image_uploader") as Gtk.Box;
        var urlshortener_container = builder.get_object("urlshorter") as Gtk.Box;

        var image_uploader_frame = builder.get_object("frame5") as Gtk.Widget;
        image_uploader_frame.hide ();

        var settings = new GLib.Settings ("org.gwibber.preferences");

        var BOOL_SETTINGS = new GLib.List<string> ();
        var INT_SETTINGS = new GLib.List<string> ();
        var STRING_SETTINGS = new GLib.List<string> ();
        STRING_SETTINGS.append("image-uploader");
        STRING_SETTINGS.append("urlshorter");
        //foreach (string key in STRING_SETTINGS) {
        //    settings.bind(key, builder.get_object(key), "value", GLib.SettingsBindFlags.DEFAULT);
        //}

        var image_uploader = new Gtk.ComboBoxText ();
        image_uploader.append("yfrog", "yfrog");
        image_uploader.append("imageshack", "ImageShack");
        image_uploader_container.add(image_uploader);
        settings.bind("image-uploader", image_uploader, "active_id", GLib.SettingsBindFlags.DEFAULT);
        image_uploader_container.show_all ();

        image_uploader.changed.connect(() => {
          settings.set_string("image-uploader", image_uploader.active_id);
          });

        var urlshortener = new Gtk.ComboBoxText ();
        urlshortener.append("is.gd", "is.gd");
        urlshortener.append("tinyurl.com", "tinyurl.com");
        urlshortener.append("ur1.ca", "ur1.ca");
        urlshortener.append("cli.gs", "cli.gs");
        urlshortener_container.add(urlshortener);
        settings.bind("urlshorter", urlshortener, "active_id", GLib.SettingsBindFlags.DEFAULT);
        urlshortener_container.show_all ();

        urlshortener.changed.connect(() => {
          settings.set_string("urlshorter", urlshortener.active_id);
          });

        INT_SETTINGS.append("interval");
        foreach (string key in INT_SETTINGS) {
            settings.bind(key, builder.get_object(key), "value", GLib.SettingsBindFlags.DEFAULT);
        }

        BOOL_SETTINGS.append("no-notifications");
        BOOL_SETTINGS.append("notify-mentions-only");
        BOOL_SETTINGS.append("show-notifications");
        //BOOL_SETTINGS.append("presence-check");
        BOOL_SETTINGS.append("show-fullname");
        BOOL_SETTINGS.append("reply-append-colon");
        BOOL_SETTINGS.append("shorten-urls");
        BOOL_SETTINGS.append("autostart");
        foreach (string key in BOOL_SETTINGS) {
            settings.bind(key, builder.get_object(key), "active", GLib.SettingsBindFlags.DEFAULT);
        }
    }

    public void on_close_button_clicked() {
        Gtk.main_quit();
    }

    public void on_prefs_dialog_destroy_event() {
        Gtk.main_quit();
    }
}

int main (string[] args) {     
    Gtk.init (ref args);

  Intl.bindtextdomain(Config.GETTEXT_PACKAGE, Config.LOCALE_DIR);
  Intl.bind_textdomain_codeset(Config.GETTEXT_PACKAGE, "UTF-8");
  Intl.textdomain(Config.GETTEXT_PACKAGE);

    var p = new GwibberPreferences ();
    Gtk.main ();
    p = null;

    return 0;
}
