import os, unittest, gettext, mx.DateTime
from gi.repository import Gwibber
from hashlib import sha1

class TimeStringTestCase (unittest.TestCase):
    def setUp (self):
        os.environ["XDG_DATA_HOME"] = os.path.realpath (os.path.join (os.path.curdir, "..", "data"))
        os.environ["XDG_CACHE_HOME"] = os.path.realpath (os.path.join (os.path.curdir, "..", "data"))
        self.utils = Gwibber.Utils ()
        self.now = mx.DateTime.gmt()

    def test_time_string_seconds (self):
        ts = self.utils.generate_time_string (self.now - 59 * mx.DateTime.oneSecond)
        self.assertEqual (ts, 'a few seconds ago')

    def test_time_string_minute (self):
        ts = self.utils.generate_time_string (self.now - 60 * mx.DateTime.oneSecond)
        self.assertEqual (ts, '1 minute ago')

    def test_time_string_minutes (self):
        ts = self.utils.generate_time_string (self.now - 3559 * mx.DateTime.oneSecond)
        self.assertIn ('minutes ago', ts)

    def test_time_string_hour (self):
        ts = self.utils.generate_time_string (self.now - 3601 * mx.DateTime.oneSecond)
        self.assertEqual (ts, '1 hour ago')

    def test_time_string_hours (self):
        ts = self.utils.generate_time_string (self.now - 7201 * mx.DateTime.oneSecond)
        self.assertIn ('hours ago', ts)

    def test_time_string_day (self):
        ts = self.utils.generate_time_string (self.now - 86400 * mx.DateTime.oneSecond)
        self.assertEqual (ts, '1 day ago')

    def test_time_string_days (self):
        ts = self.utils.generate_time_string (self.now - 2 * mx.DateTime.oneDay)
        self.assertIn ('days ago', ts)

class AvatarPathTestCase (unittest.TestCase):

    def setUp (self):
        os.environ["XDG_DATA_HOME"] = os.path.realpath (os.path.join (os.path.curdir, "..", "data"))
        os.environ["XDG_CACHE_HOME"] = os.path.realpath (os.path.join (os.path.curdir, "..", "data"))
        self.utils = Gwibber.Utils ()

    def test_avatar_path (self):
        url = "http://test.com/avatar"
        avatar_path = self.utils.avatar_path (url)
        self.assertEqual (avatar_path, os.path.join (os.environ["XDG_CACHE_HOME"], "gwibber", "avatars", sha1(url).hexdigest()))

test_cases = (TimeStringTestCase, AvatarPathTestCase)

def load_tests(loader, tests, pattern):
    suite = unittest.TestSuite()
    for test_class in test_cases:
        tests = loader.loadTestsFromTestCase(test_class)
        suite.addTests(tests)
    return suite

