from gwibber.microblog import util
import json

import logging
logger = logging.getLogger("Plugin Test")
logger.debug("Initializing.")

import re, mx.DateTime
from gettext import lgettext as _

PROTOCOL_INFO = {
  "name": "Test",
  "version": 0.1,
  
  "config": [
    "username",
    "color",
    "receive_enabled",
  ],

  "authtype": "none",
  "color": "#C31A00",

  "features": [
    "receive",
  ],

  "default_streams": [
    "receive"
  ]
}

class Client:
  def __init__(self, acct):
    self.account = acct

  def _message(self, data):
    m = {}
    m["mid"] = str(data["id"])
    m["service"] = "test"
    m["account"] = self.account["id"]
    if data.has_key("created_at"):
      m["time"] = util.parsetime(data["created_at"])
    m["source"] = data["source"]
    m["text"] = data["text"]

    m["sender"] = {}
    m["sender"]["name"] = data["user"]["name"]
    m["sender"]["nick"] = data["user"]["screen_name"]
    m["sender"]["is_me"] = data["user"]["screen_name"] == self.account["username"]
    m["sender"]["id"] = data["user"]["id"]
    m["sender"]["image"] = data["user"]["profile_image_url"]
    m["sender"]["url"] = data["user"]["profile_url"]

    m["url"] = data["user"]["url"]

    m["content"] = data["html"]
    m["html"] = data["html"]

    return m

  def _get(self, method, parse="message", post=False, **args):
    data = json.loads(open("../data/sample.json", "r").read ())
    if parse == "message":
      return [self._message(m) for m in data]
    else: return data

  def __call__(self, opname, **args):
    return getattr(self, opname)(**args)

  def receive(self, count=util.COUNT, since=None):
    logger.debug ("HERE");
    return self._get("statuses/friends_timeline.json", count=count, since_id=since, source="Gwibber")
